<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the zh_CN locale.
 */
class XG_MessageCatalog_zh_CN extends XG_AbstractMessageCatalog {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = '1秒钟前 ';
            $a['N_SECONDS_AGO']['n'] = '%s 秒钟前 ';
            $a['N_MINUTES_AGO']['1'] = '1分钟前 ';
            $a['N_MINUTES_AGO']['n'] = '%s 分钟前 ';
            $a['N_HOURS_AGO']['1'] = '1小时前 ';
            $a['N_HOURS_AGO']['n'] = '%s 小时前 ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> 个视频 ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> 个视频 ';
            $a['N_VIEWS']['1'] = '1个视图 ';
            $a['N_VIEWS']['n'] = '%s 个视图 ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> 条评论 ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> 条评论 ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = '该视频是<strong>1人</strong> 的 <strong> 最爱 </strong>。 ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = '该视频是<strong>%s人</strong> 的  <strong> 最爱 </strong> 。 ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s 添加视频： ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s 添加 %s 视频。 ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = '您添加了一个视频： ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = '您添加了 %s 个视频。 ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = '在 %2$s 上有一个视频 ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 个视频 ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = '在 %2$s 上有1个 <a href="%3$s"> 视频 </a> ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 个 <a href="%3$s"> 视频 </a> ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '该专辑中的1 张照片已被删除或转为非公开，所以无法显示。 ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '该专辑中的 %s 张照片已被删除或转为非公开，所以无法显示。 ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> 张照片 ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> 张照片 ';
            $a['N_PHOTOS_2']['1'] = '1 张照片 ';
            $a['N_PHOTOS_2']['n'] = '%s 张照片 ';
            $a['AND_X_OTHER_PEOPLE']['1'] = '和其他 一 个人 ';
            $a['AND_X_OTHER_PEOPLE']['n'] = '和其他 %s 个人 ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = '上传下列文件时有问题： ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = '上传下列文件时有问题： ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = '该照片是 <strong> 1人 </strong> 的 <strong> 最爱 </strong> 。 ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = '该照片是 <strong> %s 人 </strong> 的 <strong> 最爱 </strong> 。 ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>评分：</strong> %2$s ，1人投票之后 ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>评分：</strong> %2$s ，%s 人投票之后 ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s，1人投票之后 ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s，%s 人投票之后 ';
            $a['N_PEOPLE']['1'] = '1人 ';
            $a['N_PEOPLE']['n'] = '%s 人 ';
            $a['N_OF_5_STARS']['1'] = '1/5 星 ';
            $a['N_OF_5_STARS']['n'] = '%s/5 星 ';
            $a['YOUR_RATING_X_STARS']['1'] = '您的评分：1星 ';
            $a['YOUR_RATING_X_STARS']['n'] = '您的评分：%s 星 ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s 添加了一张照片： ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s 添加了 %s 张照片。 ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = '您添加了一张照片： ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = '您添加了 %s 张照片。 ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = '在 %2$s 上有1张照片 ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 张照片 ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = '在 %2$s 上有 %1$s 张 <a href="%3$s"> 照片 </a> ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 张<a href="%3$s"> 照片 </a> ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '您的页面上的 <strong>1</strong> 条评论 ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Comments on your page';;
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> 条博客评论 ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> 条博客评论 ';
            $a['N_YEARS_OLD']['1'] = '1年新 ';
            $a['N_YEARS_OLD']['n'] = '%s 年新 ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = '您有1个朋友请求！ ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = '您有 %s 个朋友请求！ ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = '评论墙（1条评论） ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = '评论墙（%s 条评论） ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '上周有1个新成员加入 ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '上周有 %s 个新成员加入 ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '上周有1个 <a href="%2$s"> 新成员 </a> 加入 ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '上周有 %1$s 个 <a href="%2$s"> 新成员 </a> 加入 ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = '在 %2$s 上有1个成员 ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 个成员 ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = '在 %2$s 上有1个 <a href="%3$s"> 成员 </a> ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 个 <a href="%3$s"> 成员 </a> ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = '在 %2$s 上有1个博客贴子 ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 个博客贴子 ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> 个新成员 ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> 个新成员 ';
            $a['N_REPLIES']['1'] = '1个回复 ';
            $a['N_REPLIES']['n'] = '%s 个回复 ';
            $a['N_MINUTES']['1'] = '还剩1分钟时间编辑您的评论。 ';
            $a['N_MINUTES']['n'] = '还剩 %s 分钟时间编辑您的评论。 ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = '在 %2$s 上有1个论坛主题 ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 个论坛主题 ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = '在 %2$s 上有1个 <a href="%3$s"> 论坛主题 </a> ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 个 <a href="%3$s"> 论坛主题 </a> ';
            $a['N_INVITES']['1'] = '%s 邀请 ';
            $a['N_INVITES']['n'] = '%s 邀请 ';
            $a['N_MEMBERS']['1'] = '1个成员 ';
            $a['N_MEMBERS']['n'] = '%s 个成员 ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '（1个成员） ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '（%s 个成员） ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = '在 %2$s 上有1个小组 ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 个小组 ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = '在 %2$s 上有 %1$s 个 <a href="%3$s"> 小组 </a> ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s <a href="%3$s"> 小组 </a> ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '该播放列表上的1首歌曲无法显示，因为已被删除或不再被共享。 ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '该播放列表上的 %s 首歌曲无法显示，因为已被删除或不再被共享。 ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = '一首新歌已被添加到 %2$s 上 ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s 首新歌已被添加到 %2$s 上 ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s 添加了一首歌： ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s 添加了 %s 首歌。 ';
            $a['YOU_ADDED_X_SONGS']['1'] = '您添加了一首歌： ';
            $a['YOU_ADDED_X_SONGS']['n'] = '您添加了 %s 首歌。 ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1首歌被添加至该播放列表。 ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s 首歌被添加至该播放列表。 ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = '在 %2$s 上有1首歌 ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = '在 %2$s 上有 %1$s 首歌 ';
            $a['N_INVITATIONS_RESENT']['1'] = '已重发一封邀请函。 ';
            $a['N_INVITATIONS_RESENT']['n'] = '已重发%s封邀请函。 ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> 档案评论 ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> 档案评论 ';
            }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => '浏览',
        'MORE_VIDEOS' => '更多视频',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => '该网络还没有任何视频。',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => '该网络还没有任何被推荐的视频。',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => '该成员还没有任何视频。',
        'COPY_TO_CLIPBOARD' => '拷贝到剪贴板',
        'COPIED_TO_CLIPBOARD' => '已拷贝到剪贴板',
        'NO_VIDEOS_TO_DISPLAY' => '您现在没有显示任何视频。',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => '只有当您选中至少一个视频，其他人才能看得见该视频框。',
        'WATERMARK_LOGO' => '水印标志',
        'CHOOSE_HEADER_OR_WATERMARK' => '你可以为你的视频播放器挑选一个页头或者水印图标。',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => '标志会显示在你的%s上方。如果你不添加标志，网站的名称将会显示。 标志必须是.jpg, .gif 或者 .png 格式。 超过20像素的标志将会被自动调整。',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => '水印标志显示在视频的右下角。',
        'HEADER_LOGO' => '页头图标',
        'WATERMARK' => '水印',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => '定制您的视频播放器！',
        'VIDEO_PLAYER' => '视频播放器',
        'HEADER' => '页头',
        'SAVE_CHANGES' => '保存修改',
        'THUMBNAIL' => '缩略图',
        'CONVERSION_FAILED' => '转换失败',
        'CONVERSION_IN_PROGRESS' => '正在转换中',
        'MAP' => '地图',
        'WHAT_IS_THIS' => '这是什么？',
        'EDIT_VIDEO_INFORMATION' => '编辑视频信息',
        'ALL_VIDEOS' => '全部视频',
        'VIDEOS_HOME' => '视频主页',
        'MY_VIDEOS' => '我的视频',
        'MY_FRIENDS_VIDEOS' => '朋友视频',
        'MY_FAVORITES' => '我的最爱',
        'XS_FAVORITES' => '%s的最爱',
        'ADD_A_VIDEO' => '添加视频',
        'JUST_NOW' => '刚刚',
        '1_DAY_AGO' => '1 天以前',
        'M_J' => 'M j',
        'ME' => '我',
        'X_SAID' => '%s说',
        'DELETE_COMMENT' => '删除评论',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => '您还没添加何视频！',
        'ADD_VIDEOS_AND_SHARE' => '添加视频，并和你的朋友，家人或者其他人分享！',
        'THERE_ARE_NO_VIDEOS' => '您的社交网络还没有视频。',
        'THIS_BOX_WILL_NOT_SHOW' => '这里至少要有一个视频，其他人才能看得见该视频框。 现在就添加一个吧！',
        'ADD_VIDEOS' => '添加视频',
        'VIEW_VIDEOS' => '观看视频',
        'YIKES' => 'Yikes!',
        'A_PROBLEM_SEEMS' => '有错误发生。',
        'FOR_FURTHER_ASSISTANCE' => '如果您需要更多的协助,请和我们<a %s>联系</a>。',
        'OR_YOU_CAN_GO' => '您可以返回到<a %s> %s首页</a>, 或浏览其它<a %s>Ning的社交网络</a>。',
        'TAGS' => '标签：',
        'POPULAR_TAGS' => '热门标签',
        'MY_FRIENDS' => '我的朋友',
        'VIEW_ALL_MY_FRIENDS' => '浏览所有朋友',
        'VIEW_ALL_XS_FRIENDS' => '浏览%s的所有朋友',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => '抱歉 - 没有找到你要搜索的人。',
        'VIEW_POPULAR_CONTRIBUTORS' => '浏览最有人气的贡献者',
        'POPULAR_CONTRIBUTORS' => '最有人气的贡献者',
        'VIEW_MORE_CONTRIBUTORS' => '浏览更多贡献者',
        'ADD_AS_FRIEND' => '加入您的朋友名单中',
        'SEND_A_MESSAGE' => '发送消息',
        'IS_YOUR_FRIEND' => '是您的朋友',
        'IS_BLOCKED' => '被屏蔽了',
        'SORT_BY' => '按此排序：',
        'CLOSE' => '关闭',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => '还没任何视频, 您现在就可以加！',
        'SEARCH_PEOPLE' => '找人',
        'INVITE_YOUR_FRIENDS_TO' => '邀请朋友到%s。',
        'INVITE' => '邀请',
        'INVITE_TAB_TEXT' => '邀请',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => '您还没有在%里添加任何朋友。',
        'SEARCH_FRIENDS' => '搜索朋友',
        'ADD_YOUR_FIRST_VIDEO' => '添加您的第一段视频',
        'USE_HTML_EMBED_CODE' => '使用HTML内嵌代码',
        'UPLOAD_A_VIDEO_FROM' => '从您的电脑上传一个视频。',
        'WE_SUPPORT_MOV' => '我们支持 .mov, .mpg, .mp4, .avi, .3pg, 和 .wmv 文件格式. 文件必须不超过100MB',
        'NEED_HELP_HERE_ARE' => '需要帮助吗？这些说明是给<a %s>YouTube</a>和<a %s>Google Video</a>。',
        'ADD_TITLE_AND_DESCRIPTION' => '添加标题和描述',
        'DESCRIPTION_COLON' => '描述：',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => '给刚上传的视频添加一个标题，描述和其他信息。',
        'EVERYTHING_IS_OPTIONAL' => '所有项目都是可选择的，如果您不想加任何项目，可以点击右边的"跳过该步骤"。',
        'SKIP_THIS_STEP' => '跳过该步骤',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => '给该视频添加一个标题，描述和其他信息。',
        'CANCEL_AND_RETURN_TO_VIDEO' => '取消并回到视频',
        'TITLE' => '标题',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => '标签是较短的描述, 可以帮您搜索您的视频。 请用逗号分隔多个标签, 如果是多字标签, 可用引号 (") 将标签括起来, 比如 "San Francisco"。',
        'WHO_CAN_VIEW_VIDEO' => '谁可看该视频？',
        'MOST_POPULAR' => '最有人气的',
        'HIGHEST_RATED' => '最高评分的',
        'MOST_RECENT' => '最新的',
        'MOST_FAVORITED' => '最受喜爱的',
        'MOST_POPULAR_VIDEOS' => '最有人气的视频',
        'HIGHEST_RATED_VIDEOS' => '最高评分的视频',
        'MOST_RECENT_VIDEOS' => '最新的视频',
        'MOST_FAVORITED_VIDEOS' => '最受喜爱的视频',
        'ANYONE' => '任何人',
        'JUST_MY_FRIENDS' => '只有我的朋友',
        'JUST_ME' => '只有我',
        'VIEWABLE_BY_FRIENDS' => '只有<strong>朋友</strong>可以看',
        'PRIVATE_VIDEO' => '<strong>私有</strong>视频',
        'VIEWABLE_BY_EVERYONE' => '<strong>任何人</strong>都可以看',
        'LOCATION' => '地点:',
        'NO_LOCATION' => '无地点',
        'CLICK_ON_LOCATION' => '在地图上点击一个地点：',
        'FIND_AN_ADDRESS' => '找地址',
        'LOCATE' => '定位',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => '您可以<a %s>添加您自己的视频</a>到%s网络上！',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => '为您的网络视频播放器增加一个logo或水印。 <a %s>现在就装吧！</a>',
        'APPROVE' => '批准',
        'DELETE' => '删除',
        'APPLY_TO_VIDEOS_ADDED_BY' => '应用到所有由%s添加的视频',
        'NO_TITLE' => '无标题',
        'ADDED_BY_STRONG_X' => '<strong>%s</strong>添加的',
        'NO_DESCRIPTION' => '无描述',
        'BY_X' => '由%s上传的',
        'YOU_HAVE_FINISHED_MODERATING' => '您已完成审查',
        'NO_VIDEOS_AWAITING_APPROVAL' => '现在没有视频需要您的批准. 看看最新的视频吧。',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => '您的网络还没有视频。今天就添加第一个吧！',
        'ADDED_ON_DATE_BY_X' => '%s由%s添加。',
        'REMOVE_FROM_FAVORITES' => '从最爱中删除',
        'REMOVE_VIDEO_FROM_FAVORITES' => '从您的最爱中删除？',
        'COLLECTED_BY_X' => '%s的最爱',
        'ADD_FAVORITES' => '添加最爱',
        'YOU_CAN_MARK_VIDEO' => '您可以把任何视频标记为最爱。只需在您看见视频上的“添加到最爱”图标时点击即可。',
        'VIEW_RECENT_VIDEOS' => '观看最新视频',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s还没添加任何最爱。',
        'APPROVE_VIDEOS' => '批准视频',
        'YOUR_SITE_REQUIRES_YOU' => '您要求在每一张照片和每一个视频在发布前先接受您的审查.  若要改变这个选项, 可到“管理你的网络”下“网络信息“一栏,设置”内容审查“为\'否\'。',
        'YOUR_SITE_ALLOWS_USERS' => '您社交网络现在的设定是不要您审查每一个照片和视频。 若要改变这个选项, 可到“管理你的网络”下“网络信息“一栏,设置”内容审查“为\'是\'。',
        'APPROVE_ALL_VIDEOS' => '批准所有视频？',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => '您确定要批准全部视频？ 该过程可能会需要好几分钟。',
        'APPROVING' => '正在批准中...',
        'APPROVE_ALL' => '批准全部',
        'DELETE_ALL_VIDEOS' => '删除全部视频？',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => '您确定要删除全部未经批准的视频？该过程可能会需要好几分钟。',
        'DELETING' => '正在删除中...',
        'DELETE_ALL' => '删除全部',
        'XS_VIDEOS' => '%s的视频',
        'DELETE_ALL_XS_VIDEOS_Q' => '删除全部%s的视频？',
        'DELETE_ALL_XS_VIDEOS' => '删除全部%s的视频',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => '您确定要删除全部%s的视频？该过程可能会需要好几分钟。',
        'DELETE_THIS_VIDEO_Q' => '删除该视频？',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => '您确定要删除该视频? 该过程可能会需要好几分钟。',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => '您还没添加任何视频, 现在就加一个吧！',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s还没添加任何视频。',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => '您的朋友还没添加任何视频。',
        'ALL_VIDEOS_TAGGED_X' => '所有被标签为\'%s\'的视频',
        'ALL_VIDEOS_TAGGED_X_2' => '所有被标签为<em>\'%s\'</em>的视频',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => '没有任何标签为"%1$s"的视频.  您可以看看标签为<a %2$s>"%1$s"的讨论</a>, 或标签为<a %3$s>"%1$s"的照片</a>, 或添加您自己的视频并加标签。',
        'FILES_MUST_BE_100MB' => '文件必须不超过100MB。我们支持 .mov, .mpg, .mp4, .avi, .3pg, 和 .wmv 文件格式。',
        'NEED_HELP' => '需要帮忙？',
        'HERE_ARE_INSTRUCTIONS' => '这是 <a %s>YouTube</a> 和<a %s>Google Video</a>的说明。',
        'PERSON_IN_CHARGE' => '%s网络负责人需要先批准才能发布您的视频。',
        'LEAVE_WINDOW_OPEN' => '正在上传，请不要关闭该浏览窗口。',
        'KEEP_PAGE_OPEN' => '正在上传视频，请不要关闭该浏览窗口。',
        'MEANWHILE_FEEL_FREE' => '在此同时，您可以<a %s>另开一个窗口</a>继续浏览 %s. 上传结束后，您可以为视频添加标题和描述。',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => '该视频正在<strong>等待</strong>%s的负责人批准。',
        'LOADING' => '正在加载...',
        'EDIT_VIDEO' => '编辑视频',
        'DELETE_VIDEO' => '删除视频',
        'YOU_NEED_TO_BE_MEMBER' => '您得是成员才能加评论！',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>加入该网络</a>',
        'ADD_A_COMMENT' => '添加评论',
        'LEAVE_A_COMMENT_FOR_USERNAME' => '给%s留言',
        'MORE' => '更多',
        'PREVIOUS' => '前',
        'NEXT' => '下一步',
        'ABOUT_THIS_VIDEO' => '关于该视频',
        'ABOUT_YOUR_VIDEO' => '关于该视频',
        'ADDED_ON_DATE_BY' => '由<strong>%s</strong>添加：',
        'VIEWS' => '浏览:',
        'COMMENTS' => '评论',
        'COMMENTS_COLON' => '评论：',
        'LOCATION_OF_VIDEO' => '该视频的地点：',
        'RELATED_VIDEOS' => '相关的视频',
        'ALL_VIDEOS_TAGGED_X_X' => '所有标签为%s的视频(%s)',
        'XS_VIDEOS_X' => '%s的视频(%s)',
        'XS_FAVORITES_X' => '%s的最爱(%s)',
        'VIDEO_DETAILS' => '视频细节',
        'NEITHER_FILE_NOR_EMBED_CODE' => '您没制定一个文件或内嵌代码。',
        'VIDEO_UPLOADED_ON_X' => '视频已上传到%s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => '转换该视频到Flash格式时有出错： %s',
        'STATUS_N' => '状态%s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => '无法上传您的视频"%s"到%s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => '无法上传您的视频到%s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => '抱歉, 您还不能上传视频到%s, 您得先加入%s。',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => '视频上传到%s失败了',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => '您的视频上传到%s失败了。',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => '上传您的视频到%s时有错误发生',
        'THE_PROBLEM_WAS_X' => '问题是：%s',
        'FOR_FURTHER_ASSISTANCE_2' => '如需更多协助, 请和我们联系：',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => '视频%s（所属%s）在转换格式过程中发生了错误',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '当%s上传视频时发生了转换格式错误。',
        'ERROR_MESSAGE' => '错误信息:',
        'APPLICATION_NAME' => '网络名称:',
        'APPLICATION_ID' => '网络ID:',
        'VIDEO_ID' => '视频 ID:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => '上传视频到%s成功',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => '上传视频到%s成功',
        'YOUR_VIDEO_WAS_UPLOADED' => '上传视频到%s成功！',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => '该视频还在等待批准。',
        'THIS_VIDEO_IS_BEING_PROCESSED' => '视频正在转换中。',
        'ADD_VIDEO' => '添加视频',
        'VIDEO_BY_X' => '%s的视频',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => '您在%s上的视频"%s"）有一条新评论',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => '您在%s上的一个视频有一条新评论',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => '有人在您%s里的的一个视频上添加了一条新评论',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => '有人在%s里上传了一个视频',
        'MORE_WAYS_TO_ADD_VIDEOS' => '更多添加视频的方法...',
        'FROM_YOUTUBE_OR_GOOGLE' => '...来自 YouTube 或 Google',
        'GRAB_THE_HTML_EMBED_CODE' => '从任何热门视频网站抓取 HTML 内嵌代码 （\'embed\'）, 并添加该视频到这个社交网络里。',
        'ADD_A_VIDEO_FROM_YOUTUBE' => '从YouTube或Google那儿添加视频',
        'PASTE_IN_EMBED' => '请在此粘贴视频内嵌代码：',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => '通过手机或电子邮件添加视频',
        'VIDEO' => '视频',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => '没有视频符合您搜索的要求。',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => '您若想别人也可看到这个框, 请点击\'编辑\', 然后更改设置。',
        'PLAY_AGAIN' => '重新播放',
        'SHARE' => '分享',
        'EMBED' => '内嵌',
        'REWIND' => '回倒',
        'CHANGE_SIZE' => '改变大小',
        'FULLSCREEN' => '全屏',
        'EXIT_FULLSCREEN' => '退出全屏模式',
        'HIDE' => '关闭',
        'COPY_AND_PASTE_LINK' => '拷贝并粘粘该链接到电子邮件或即时消息(Instant Message)里。',
        'FIND_MORE_VIDEOS_LIKE_THIS' => '在 <em>%s</em> 上面找更多和这个类似的视频',
        'SEE_VIDEO_ON_NETWORK' => '在 %s 上观看该视频',
        'GET_EMBED_CODE' => '获取内嵌代码',
        'MORE_PHOTOS' => '更多照片',
        'THIS_ALBUM' => '该相册',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => '该网络还没有任何照片。',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => '该成员还没有任何照片。',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => '该相册还没有任何照片。',
        'FIND_MORE_PHOTOS_LIKE_THIS' => '在 <em>%s</em> 上面找更多和这个类似的照片',
        'NO_PHOTOS_AVAILABLE' => '该相册里没有照片。  <a %s>点击这里看所有的相册</a>。',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => '该相册其他人看不见，因为里面的照片要么只有您可以看，要么还没被批准。',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => '定制您的幻灯片播放器。',
        'ADD_SLIDESHOW_LOGO' => '您可以为您的社交网络的幻灯片加个标志。 <a %s>现在就装吧！</a>',
        'PHOTO_BY_X' => '%s提交的照片',
        'UPLOAD_PHOTOS' => '上传照片',
        'PLAYER_COLOR' => '播放器的颜色',
        'SLIDESHOW_PLAYER' => '幻灯片播放器',
        'SLIDESHOW' => '幻灯片',
        'FILTER' => '过滤',
        'SAVE_ALBUM' => '保存相册',
        'APPLY_THIS_INFO_TO_PHOTOS' => '应用到所有以下的照片',
        'CLICK_TO_ADD_A_DESCRIPTION' => '点击这里, 添加描述',
        'CHECK' => '检查',
        'YOU_NEED_TO_BE_X' => '抱歉, 您得是%s才能进行这项操作。',
        'ALL_PHOTOS' => '全部照片',
        'POPULAR_PHOTOS' => '最有人气的照片',
        'FEATURED_PHOTOS' => '被推荐的照片',
        'PHOTOS_HOME' => '照片主页',
        'ALL_ALBUMS' => '全部相册',
        'MY_PHOTOS' => '我的照片',
        'MY_ALBUMS' => '我的相册',
        'ADD_PHOTOS' => '添加照片',
        'ADD_PHOTOS_SENTENCE_CASE' => '添加照片',
        'EDIT' => '编辑',
        'CHOOSE_PHOTOS' => '选择照片',
        'ADD_PHOTOS_BY_DRAGGING' => '添加照片： 把照片拖放到右边您的相册。 删除照片： 把照片拖放回来。',
        'TITLE_YOUR_ALBUM' => '<strong>给您的相册起个名字</strong>, 再加个封面和描述。',
        'SAVE_YOUR_ALBUM' => '保存您的相册！',
        'CHOOSE_FROM' => '从这里选择：',
        'EVERYONES_PHOTOS' => '每个人的照片',
        'TAGGED' => '标签：',
        'OLDER_PHOTOS' => '较老的照片',
        'MORE_RECENT_PHOTOS' => '较新的照片',
        'YOUR_ALBUM' => '您的相册',
        'DRAG_ALBUM_COVER_HERE' => '把相册的封面拖放到这',
        'ALBUM_TITLE' => '相册标题：',
        'ALBUM' => '相册',
        'DRAG_PHOTOS_HERE' => '把您的照片拖放到这里',
        'PREVIOUS_ALBUM_PAGE' => '相册上一页',
        'NEXT_ALBUM_PAGE' => '相册下一页',
        'ADDED_ON_DATE' => '%s上传',
        'VIEW_AS_SLIDESHOW' => '以幻灯片方式显示',
        'CREATED_BY_ME' => '<a %s>我</a>创建的., //Created by <a %s>Me</a>',
        'CREATED_BY_X' => '%s创建的',
        'OUR_APOLOGIES' => '抱歉！',
        'ADD_PHOTOS_TO_ALBUM' => '从以下的选项中挑选照片, 放入该相册。',
        'YOU_CAN_ADD_PHOTOS' => '您现在就可为该相册<a %s>添加新的照片</a>。',
        'SITE_IS_GETTING_STARTED' => '该社交网络刚刚开始',
        'NO_ONE_CREATED_ALBUMS' => '这里还没有任何相册.  您现在就<a %s>创建一个吧</a>。',
        'EDIT_YOUR_ALBUM' => '编辑您的相册',
        'ALBUMS_WITH_THIS_PHOTO' => '所有包含该照片的相册',
        'ALBUMS_WITH_X' => '所有包含"%s"的相册',
        'ALBUMS_WITH_X_2' => '所有包含<em>"%s"</em>的相册',
        'NO_ALBUMS_CONTAINING_PHOTO' => '没有任何相册包含该照片. 您可<a %s>创建一个新的相册</a>。',
        'XS_ALBUMS' => '%s的相册',
        'CREATE_AN_ALBUM' => '创建新的相册',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => '您还没有任何相册。 现在就<a %s>创建一个吧</a>。',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s没有任何相册。',
        'MAKE_AN_ALBUM' => '创建新相册',
        'ABOUT_THIS_ALBUM' => '关于该相册',
        'ABOUT_YOUR_ALBUM' => '关于您的相册',
        'EDIT_ALBUM' => '编辑相册',
        'DELETE_THIS_ALBUM' => '删除该相册？',
        'DELETE_ALBUM' => '删除相册',
        'START_SLIDESHOW' => '播放幻灯片',
        'ALBUM_IS_NOW_EMPTY' => '该相册是空的了。',
        'YOU_ARE_GETTING_STARTED' => '您现在刚开始！',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => '您还没有任何照片！',
        'ADD_PHOTOS_AND_SHARE' => '添加照片，并和你的朋友，家人或者其他人分享！',
        'ADD_A_PHOTO' => '添加照片',
        'NO_PHOTOS_ON_SITE' => '您的社交网络还没有照片。',
        'BOX_WILL_NOT_SHOW_PHOTOS' => '这里至少要有一张照片，其他人才能看得见该相册。 现在就添加一个吧。',
        'VIEW_EMBED_CODE' => '看内嵌代码',
        'VIEW_SLIDESHOW' => '看幻灯片',
        'VIEW_PHOTOS' => '浏览照片',
        'ADD_YOUR_FIRST_PHOTOS' => '添加您第一张照片',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => '您可以<a %s>添加照片</a>到%s！',
        'UPLOAD_PHOTOS_FROM' => '从您的电脑上传照片',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => '为您的照片添加标题及描述',
        'EDIT_PHOTO_INFORMATION' => '编辑照片的信息',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => '您可为刚上传的照片添加标题, 描述, 及信息。',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => '您可为该照片添加标题, 描述, 及信息。',
        'CANCEL_AND_RETURN_TO_PHOTO' => '取消并回到照片',
        'WHO_CAN_VIEW_PHOTO' => '谁可以看该照片？',
        'CAN_BE_VIEWED_BY' => '谁能观看：',
        'BY_ME' => '由<a %s>我</a>上传的',
        'RSS_FEED_LABEL' => '<a %s>RSS Feed</a> - %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => '现在没有照片需要您的批准. 看看最新的照片吧。',
        'APPROVE_ALL_PHOTOS' => '批准所有照片？',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => '您确定要批准所有的照片？ 该过程可能会需要好几分钟。',
        'DELETE_ALL_PHOTOS' => '删除所有照片？',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => '您确定要删除所有未经批准的照片？该过程可能会需要好几分钟。',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => '在照片被批准过程中请不要关闭该浏览窗口。该过程可能会需要好几分钟。',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => '在照片被删除过程中请不要关闭该浏览窗口。该过程可能会需要好几分钟。',
        'APPLY_TO_PHOTOS_ADDED_BY' => '应用到所有由%s添加的照片',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => '您的社交网络还没有照片。您今天就<a %s>添加第一个吧！</a>',
        'UNTITLED' => '无标题',
        'A_PROBLEM_OCCURRED' => '有错误发生',
        'PHOTOS_EXCEEDED_LIMIT' => '照片的大小超过了10MB的限制。',
        'GET_A_SLIDESHOW_OF' => '获取 %s的幻灯片',
        'GET_A_SLIDESHOW' => '获取幻灯片！',
        'GET_SLIDESHOW_OF_PHOTOS' => '获取这些照片的幻灯片',
        'COPY_AND_PASTE_SLIDESHOW' => '您只要拷贝并粘贴下面的代码就可以把这些照片的幻灯片放在您的网站, MySpace 或其他 Ning 网络上。',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => '您只要拷贝并粘贴下面的代码就可以把这个相册的幻灯片放在您的网站, MySpace 或其他 Ning 网络上。',
        'LARGE_VERSION' => '大的',
        'SMALL_VERSION' => '小的',
        'VIEW_SLIDESHOW_FULL_SIZE' => '全屏幕幻灯片方式观看',
        'PHOTOS' => '照片',
        'XS_PHOTOS' => '%s的照片',
        'XS_PHOTO' => '%s的照片',
        'YOU_CAN_MARK_PHOTO' => '您可以把任何照片标记为最爱。只需在您看见照片上的"添加到最爱"图标时点击即可。',
        'VIEW_RECENT_PHOTOS' => '浏览最近照片',
        'APPROVE_PHOTOS' => '批准照片',
        'DELETE_ALL_XS_PHOTOS_Q' => '删除所有%s的照片？',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => '您确定要删除所有%s的照片？该过程可能会需要好几分钟。',
        'REMOVE_X_AND_ALL_CONTENT' => '从您的社交网络删除%1$s及所有%1$s的内容',
        'SUCCESS' => '成功。',
        'DELETING_CONTENT' => '删除内容...',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => '在内容被删除过程中请不要关闭该浏览窗口。该过程可能会需要好几分钟。',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => '在成员被删除过程中请不要关闭该浏览窗口。该过程可能会需要好几分钟。',
        'DELETE_ALL_XS_PHOTOS' => '删除所有%s的照片',
        'CREATE_A_NEW_ALBUM' => '创建一个新相册',
        'VIEW_ALL_XS_ALBUMS' => '浏览所有%s的相册',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => '您还没有添加任何照片。 开始添加一些图片吧！',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s还没有添加任何照片。',
        'MY_FRIENDS_PHOTOS' => '我朋友的照片',
        'VIEW_PHOTOS_IN_SLIDESHOW' => '用幻灯片观看这些照片！',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => '您的朋友们还没有任何照片',
        'ALL_PHOTOS_TAGGED_X' => '所有标记为\'%s\'的照片',
        'ALL_PHOTOS_TAGGED_X_2' => '所有标记为<em>\'%s\'</em>的照片',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => '没有任何标记为"%1$s"的照片。 您可以看看标签为<a %2$s>"%1$s"的讨论</a>, 或标签为<a %3$s>"%1$s"的视频</a>, 或添加您自己的照片并加标签。',
        'SELECT_YOUR_PHOTOS' => '选择照片',
        'PHOTO_MAY_BE_10MB' => '每张照片不能超过10MB. 照片越小,上传速度越快！',
        'KEEP_PAGE_OPEN_PHOTOS' => '正在上传照片,请保持此页面开启. 照片被批准后候我们会通知您。',
        'MEANWHILE_FEEL_FREE_PHOTOS' => '在此同时, 您可以<a %s>另开一个窗口</a>继续浏览%s。上传结束后, 您可以为照片添加标题和描述。',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => '该照片正在<strong>等待</strong>%s的负责人批准。',
        'ADD_TO_FAVORITES' => '添加到最爱',
        'EDIT_PHOTO' => '编辑照片',
        'DELETE_PHOTO' => '删除照片',
        'ABOUT_THIS_PHOTO' => '关于该照片',
        'LOCATION_OF_PHOTO' => '该照片的地点:',
        'ALBUMS_FEATURING_PHOTO' => '所有推荐该照片的相册',
        'VIEW_ALBUMS_WITH_PHOTO' => '浏览所有包含该照片的相册',
        'RETURN_TO_X' => '回到%s',
        'RETURN_TO_PHOTOS_HOME' => '返回照片主页',
        'WE_COULD_NOT_FIND_ANYONE' => '抱歉 - 没有找到任何人',
        'NOBODY_HAS_ADDED_PHOTOS' => '还没有任何人添加照片！ 开始添加一些照片吧。',
        'DEFAULT_TITLE' => '标题',
        'DEFAULT_DESCRIPTION' => '描述',
        'UPLOAD_LIMIT_EXCEEDED' => '上传文件的大小超过了限制。',
        'SLOW_DOWN_THERE_CHIEF' => '真抱歉',
        'I_DO_NOT_KNOW_USER' => '对不起, 我不知道这人。',
        'I_DO_NOT_HAVE_PHOTO' => '对不起, 我没有这个照片。',
        'I_DO_NOT_HAVE_ALBUM' => '对不起, 我没有这个相册。',
        'ALBUM_BY_X_ON_X' => '%s的相册 - %s',
        'SENT' => '已发送！',
        'I_HAVE_RECENTLY_ADDED' => '我最近新添加的',
        'FROM_THE_BAZEL' => '从该网络',
        'RECENTLY_ADDED' => '最近添加的',
        'RECENT_PUBLIC_PHOTOS_ON_X' => '%s上近期新加的共享照片',
        'X_ALL_PHOTOS' => '%s - 所有照片',
        'NO_TAG_WAS_SPECIFIED' => '没有指定任何标签',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => '被加了%s标签的共享照片（在%s上）',
        'XS_PUBLIC_PHOTOS_ON_X' => '%s的共享照片（在%s上）',
        'WE_DO_NOT_KNOW_USER' => '我们不知道此人。',
        'XS_FRIENDS_PHOTOS' => '%s朋友的照片',
        'XS_FAVORITE_PHOTOS_ON_X' => '%s的最爱照片（在%s上）',
        'PHOTO_UPLOADED_ON_X' => '%s上传的照片',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => '文件的大小超过了限制',
        'PART_OF_FILE_WAS_UPLOADED' => '该文件只上传了一部分',
        'NO_FILE_WAS_UPLOADED' => '上传失败；文件名可能不正确',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => '上传时出错。',
        'ALPHABETICAL' => '按字母顺序的',
        'MOST_VIEWS' => '最多浏览的',
        'RATING_NOT_RATED_YET' => '<strong>评分:</strong> 还未评分',
        'NOT_RATED_YET' => '还未评分',
        'HMM_SOMETHING_WENT_AWRY' => '嗯...有些不对呀',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => '标题为 "%s" 的照片不能被添加到 %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => '您的照片不能被添加到 %s',
        'YOU_JUST_TRIED_TO_SEND' => '您刚尝试传送一张照片到%s. 很遗憾，因为您还不是%s的成员，这张照片无法传送。',
        'ONLY_MY_FRIENDS' => '只有我的朋友',
        'ANYBODY' => '任何人',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => '只有我的朋友才能看到该照片',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => '只有%s的朋友才能看到该照片',
        'ONLY_I_CAN_SEE_PHOTO' => '只有我才能看到该照片',
        'ONLY_X_CAN_SEE_PHOTO' => '只有%s才能看到该照片',
        'EVERYONE_CAN_SEE_PHOTO' => '任何人看到该照片',
        'PRIVATE_PHOTO' => '<strong>私有</strong>照片',
        'HOWDY_STRANGER' => '您好, 朋友！',
        'YOU_NEED_TO_BE_SIGNED_IN' => '您得先登录到Ning才能进行这项操作。',
        'JUST_CLICK_ON_SIGN_IN' => '请点击上面的"登录"。 您若没有Ning帐户, 请点击"注册"。',
        'YOU_NEED_TO_BE_' => '抱歉, 您得是%s才能进行这项操作。',
        'YOU_NEED_TO_BE_OWNER' => '您必须是网络创建者才能行这项操作。',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => '该照片正在等待批准。',
        'YOU_NEED_TO_BE_A_FRIEND' => '您必须是%s的朋友才能进行这项操作。',
        'MOST_ACTIVE' => '最活跃的',
        'HOW_IT_WORKS' => '如何玩法',
        'MORE_WAYS_TO_ADD_PHOTOS' => '更多添加照片的方法...',
        'BY_PHONE_OR_EMAIL' => '...通过手机或电子邮件',
        'FROM_FLICKR' => '...通过 Flickr',
        'FROM_YOUR_COMPUTER' => '...通过您的电脑',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => '把您在Flickr的照片加进来。',
        'MORE_INFORMATION' => '更多信息',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => '通过手机或电子邮件添加照片',
        'SEND_ONE_PHOTO_OR_VIDEO' => '一个电子邮件可发送一张照片或者一个视频。电子邮件的主题会设成照片或视频的标题, 电子邮件的内容会设成照片或视频的描述。',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => '请点击这里, 您将获得一个新的电子邮件地址',
        'UPLOAD_PHOTOS_FROM_YOUR' => '从电脑上传照片。',
        'PHOTO' => '照片',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => '您现在没有显示任何照片。',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => '只有当您选中至少一张照片, 其他人才能看得见该相册。',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => '您的在%s上的照片"%s"有一条新发表的评论',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => '您在%s上的某个照片有一条新发表的评论',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => '您在%s上的某个照片有一条新发表的评论',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => '有人在%s上传了一张照片',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => '如果要从手机直接添加视频到%s，可将视频发送到一个电子邮件信箱。',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => '您确定从您的最爱中删除这项吗？',
        'DELETE_THIS_PHOTO_Q' => '删除该照片？',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => '您确定要删除这张照片？该过程可能会需要好几分钟。',
        'PHOTO_SLIDESHOW' => '幻灯片',
        'THUMBNAILS' => '缩略图',
        'DETAIL' => '详细内容',
        'TAG' => '标签',
        'RATE' => '评分',
        'ALL_SIZES' => '所有尺寸',
        'ADD_TO_ALBUM' => '添加到相册',
        'ROTATE_PHOTO' => '旋转照片',
        'ABOUT_YOUR_PHOTO' => '关于您的照片',
        'SEE_PHOTOS_ON_NETWORK' => '在 %s 上看这些照片',
        'EMBED_CODE' => '内嵌代码',
        'IMPORT_PHOTOS_FLICKR' => '从Flickr获取您的照片',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => '此处继续到Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => '若向从Flickr获取照片,你首先得需要允许%S链接到您的Flickr帐户。',
        'IMPORT_PHOTOS' => '导入照片',
        'GET_MY' => '获取我的',
        'GET_PHOTOS' => '获取照片',
        'MOST_RECENT_PHOTOS' => '最新的照片',
        'GET_ALL_MY_FLICKR' => '从Flickr获取我所有的照片（这需要一点时间）',
        'GET_ALL_MY_TAGGED' => '获取我所有被标记了的照片',
        'GET_PHOTOS_FROM_SET' => '从一组照片中获取：',
        'GET_STARTED_BY_IMPORT' => '我们将自动获取您的标题，标记, 和任何匹配的信息。 <br/>将要花费多长时间？</p><p><ul style="padding-top:10px;"><li>10张图片：<em>少于30秒</em>.</li><li>50张图片：<em>大约2分钟</em>.</li><li>200张图片：<em>大约6分钟</em>.</li><li>500张图片：<em>大约15分钟.</em>.</li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => '如果你还没有登录到Flickr, 你会被要求登录。 一旦你登录了，请点击按钮"OK，我同意"。',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => '获取描述（这将会花费两倍的时间）。',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => '请保持此页面开启以便我们完成照片的导入。',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => '获取每张照片的全尺寸版本（因为这将会增加导入的时间,所以我们不建议超过20张照片）。',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => '点击“编辑”可在该框内添加文本、视频、照片、或任何其他小工具。这可以使您的%s页面更有个性。',
        'CLICK_EDIT_TO_ADD_TEXT' => '点击“编辑”可在该框内添加文本、视频、照片、或任何其他<a %1$s>第三方小工具</a>。这可以使您的%2$s页面更有个性。',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => '如果您没有更新该框的内容，其他人看不见该框。',
        'YOUR_X_BOX' => '您的%s框',
        'ABOUT_WIDGETS' => '关于小工具',
        'HELP' => '帮助',
        'WIDGETS' => '小工具',
        'LOOKING_TO_ADD_FUNCTIONALITY' => '想为您的社交网络添加更多功能吗？比如日历，本地天气报告，大事小情倒计时表，或者网络摄像头什么的？有了小工具，在您网络的任何文本框里添加新功能就变成容易的事。',
        'GETTING_STARTED' => '开始吧',
        'BELOW_IS_LIST_OF_WIDGET' => '您也许可以看看<a %s>这些小工具提供者</a>。我们从<a %s>yourminis.com</a>选了些小工具帮您起步。您只需在下面装好小工具，拷贝内嵌代码，然后直接粘贴到文本框里就可以了。做做看吧！',
        'CALENDAR' => '日历',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => '日历小工具不仅可以显示日期，还可以让您搜索并添加iCal格式的事件（Google日历和许多其他在线日历提供商都使用这种格式）。',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => '用“编辑小工具”按钮来选择“搜索事件”选项，再输入搜索项（如某个节假日，某个球队等等）。然后选择一个结果把对应的事件加到您日历里。您也可以手动输入已有的iCal feed地址。',
        'CUSTOMIZATION' => '定制',
        'YOU_CAN_CUSTOMIZE_WIDGET' => '您可以定制小工具的颜色外观。将光标移到小工具上，然后点击颜色选择框，可以改变背景，小工具的风格，以及透明程度。完成后，点击“拷贝到网上”链接，然后“拷贝内嵌代码”按钮。代码拷贝好后，就回到您网络的任何一个文本框，粘贴并保存。齐活了！',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => '从yourminis.com 获取更多的小工具',
        'WEATHER' => '天气',
        'WEATHER_WIDGET_DISPLAYS' => '天气小工具显示来自“天气频道”的本地天气预报。',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => '用“编辑小工具”按钮来选择您的地点以及摄氏还是华氏。您可以选择只显示当天的天气，或者扩展到五天预报。',
        'COUNTDOWN' => '倒计时',
        'COUNTDOWN_WIDGET_LETS_YOU' => '倒计时小工具让您可以为某个特殊事件建立倒计时。点击“编辑小工具”，您可以输入日期，事件，以及倒计时事件的标题或图片。',
        'WEBCAM' => '网络摄像头',
        'WEBCAM_WIDGET_ALLOWS_YOU' => '网络摄像头小工具可以让您监看公共网络摄像头。用“编辑小工具”按钮来从预设的网络摄像头列表中选择，也可以手动输入一个网络摄像头的网址。',
        'MORE_WIDGETS' => '更多小工具',
        'NEED_MORE_OPTIONS' => '需要更多选择吗？我们推荐以下网站：',
        'MODERATION_DENIED_ON_X' => '网络负责人没有批准在%s 上的%s',
        'MODERATION_DENIED_ON_A_X' => '网络负责人没有批准在%s 上您的%s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => '在%s 上有个新的%s需要您审查',
        'NEW_X_TO_MODERATE' => '有个新的%s需要您审查。',
        'MODERATION_APPROVED_ON_X' => '网络负责人批准了在%s 上的%s',
        'MODERATION_APPROVED_ON_A_X' => '网络负责人批准了在%s 上您的%s',
        'JOIN' => '加入',
        'WELCOME' => '欢迎',
        'WELCOME_TO_X' => '欢迎来到%s',
        'WELCOME_TO_X_ELLIPSIS' => '欢迎来到 %s',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0"> 新功能！ </h3>
            <ul><li><strong> 小组 </strong> &ndash; 让您的成员在您的网络上创建小组 </li>
                <li><strong> 音乐播放器 </strong> &ndash; 为您的网络添加音乐和播客（podcast）</li></ul>
            <p><a href="%s" class="desc add"> 点击这里，添加功能 </a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0"> 新功能！ </h3>
            <ul><li><strong> 最新活动 </strong> &ndash; 跟踪您网络上最新的成员活动 </li>
                <li><strong> 徽章和小组件</strong> &ndash; 利用定制的徽章和小组件在web上推广您的网络 </li></ul>
            <p><a href="%s" class="desc add"> 点击这里，添加/编辑功能 </a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => '您的%2$s, %1$s，被%3$s上的一个成员添加了个评论！',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => '您的%1$s被%2$s上的一个成员添加了个评论！',
        'HERE_IS_LINK' => '这是加入的链接: <a %s>%s</a>',
        'THANKS_VALEDICTION' => '谢谢',
        'THANKS' => '谢谢!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => '您更改了您在 %s 的电邮地址。',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => '您更改了您在 %s 的电邮地址…',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => '点击这里，用您的新电邮地址来登陆：',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => '如果您没有更改您的电邮地址，点击这里：',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => '不想再收到有关新讨论的通知，请去：',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s 在%2$s上开始了新的讨论…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s 开始了新的讨论 "%2$s" 。',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => '要观阅这个讨论，请到：',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s邀请您加入%s！',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s邀请您看看在%s 上的“%s”！',
        'CHECK_OUT_TITLE_ON_APPNAME' => '看看 %s 上的 "%s"！',
        'ABOUT_X' => '关于%s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => '您收到这封邮件是因为%s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => '如果您不希望再收到来自%s的通知邮件，<a %s>请点击这里</a>。',
        'CLICK_HERE' => '点击这里',
        'YOU_CAN_CONTACT_US' => '如果您对您的隐私情况有任何问题或顾虑，您可以通过http://help.ning.com/?page_id=27 与我们联系。',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => '给%s所有成员的一个消息',
        'CLICK_TO_CHECK_OUT' => '点击这里来看看吧！',
        'CLICK_TO_APPROVE_X' => '点击这里来批准/删除这个%s',
        'YOUR_X_HAS_BEEN_APPROVED' => '您在%s上的%s已被批准',
        'YOUR_X_WAS_NOT_APPROVED' => '您在%s上的%s没被批准。',
        'CLICK_TO_VIEW_X' => '点击这里来看看这个%s！',
        'CLICK_TO_VIEW_IT' => '点击这里来看看！',
        'TO_VIEW_USER_PROFILE_VISIT' => '要查看 %s 的简介，请访问：',
        'YOU_ADDED_CONTENT' => '您的内容加到了%s，这是个需审查的社交网络',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s 对 %2$s 提了点意见…',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s 报告了下列问题。',
        'URL_REPORTED_COLON' => '报告的URL：',
        'ISSUE_COLON' => '问题：',
        'ADDITIONAL_INFORMATION_COLON' => '其他信息：',
        'SEND_AN_INVITATION_TO_X' => '给%s发送邀请',
        'SOMEBODY_REQUESTED_JOIN_X' => '有人申请加入%s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => '想在  %s 的简介上添加欢迎辞？请去：',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s 发给您一个消息。',
        'TO_READ_THIS_MESSAGE_VISIT' => '要阅读该消息，请访问：',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s 在 %s 上发给您一个消息…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s 已把您加为朋友…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s 已在 %s 上把您加为朋友。',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s接受了您在%s上做朋友的请求！',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => '要接受这个朋友请求，请访问：',
        'VIEW_XS_PAGE_ON_Y' => '浏览%szai在%s上的网页',
        'MEMBER_OF_X_ACCEPTED' => '%s的一位成员接受了您的朋友请求',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => '如果您不希望再收到来自%s的朋友请求通知，请<a %s>点击这里</a>。',
        'YOU_RECEIVED_INVITATION_FROM_X' => '您收到的这个邀请是来自于 %1$s的一位成员。如果您不再希望收到来自%1$s的邀请，请通过http://help.ning.com/?page_id=27 与我们联系。',
        'ON_X_COLON' => '在%s上：',
        'ON_X' => '在%s上',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s 已要求成为 %s 的成员。',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s 已要求成为 %3$s 上的%2$s 成员…',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s 邀请您加入 "%2$s" 小组',
        'VISIT_GROUP_AT' => '请访问 %s：',
        'ABOUT_GROUP' => '关于%s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => '一个%s发给所有%s（属%s)的消息。',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => '您可在这里用您的电邮地址来登陆：',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s在 \'%s\'上对博客帖子‘%s’进行了评论',
        'SEND_X_A_MESSAGE_HERE' => '在这里给 %s 发个消息：',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => '您在 %s 上有一位新成员有待批准…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => '您有一位新成员有待批准。',
        'TO_APPROVE_XS_PROFILE_VISIT' => '要批准 %s 的简介，请访问：',
        'CANT_CLICK_CUT_AND_PASTE' => '无法点击以上的链接? 您可以拷贝并粘贴该链接到您的浏览器。',
        'CLICK_HERE_TO_JOIN_COLON' => '点击这里来加入:',
        'CLICK_HERE_TO_JOIN_BANG' => '点击这里来加入!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => '您的 %s 成员资格已获批准…',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => '祝贺您！您的 %s 成员资格已获批准。',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => '您现在可在这里用您的电邮地址来登陆：',
        'VISIT_X_AT_Y' => '要访问 %1$s请到：%2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => '想要掌控您在 %1$s上收到什么样的电子邮件? 请去：',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => '一个被禁止的成员在 %s 上发给您一个消息…',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => '一个被禁止的成员在 %1$s 上发给您一个消息。%2$s 写道：',
        'WELCOME_TO_THE_GROUP_X' => '欢迎来到 "%s" 小组',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => '欢迎来到 %2$s 上的 %1$s…',
        'TO_VIEW_THIS_GROUP_VISIT' => '想要查看该小组，请访问：',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s 邀请您加入 %2$s。',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s 现在是 %2$s 的成员。',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s 现在是 %2$s 的成员…',
        'SOMEBODY' => '有人',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => '想要查看您的新评论，请访问：',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => '想要查看新的评论，请访问：',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => '想要查看新的回复，请访问：',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => '欢迎来到 %s！谢谢您的加入。',
        'NAME_COLON' => '名字：',
        'EMAIL_COLON' => '电邮：',
        'AGE_COLON' => '年龄：',
        'GENDER_COLON' => '性别：',
        'LOCATION_COLON' => '地点:',
        'COUNTRY_COLON' => '国家：',
        'GET_NETWORK_BADGE' => '%s 徽章',
        'SPREAD_WORD_GET_BADGE' => '请广而告知！为您的网站或您的MySpace页面获取一个 %s的徽章。 (<a %s> 获取代码</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => '请广而告知！<a href="%s"> 获取您的 %s 徽章 </a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => '显示您的忠诚度。获取您自己的 %s徽章，放在您的网站或您的MySpace页面上。 (<a %s> 获取代码 </a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s 在  %3$s 上评论了 %2$s "%4$s"',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => '对不起 – 我们不能从文件中提取出任何电邮地址。',
        'ADMINISTRATORS' => '管理员',
        'YOUR_INVITATION_HAS_EXPIRED' => '您的邀请已过期',
        'SORRY_INVITATION_EXPIRED' => '对不起，您使用的邀请已过期。您需要一个新的邀请才能加入 %s。',
        'DISABLE_INVITATION_LINK' => '禁用邀请链接？',
        'CREATING_LINK_WILL_DISABLE' => '创建一个新的邀请链接，当前的链接将被禁用。您确定要创建一个新的链接？',
        'SHARE_LINK_WITH_PEOPLE' => '让您希望加入本网络的人共享这一链接：',
        'CREATE_INVITATION_LINK' => '创建新的邀请链接',
        'PLEASE_SELECT_SECOND_PART' => '请选择您电邮地址的第二部分，例如：gmail.com。',
        'AT_SYMBOL_NOT_ALLOWED' => '请确定电邮地址的第一部分中没有 @ 符号。',
        'SORRY_WE_DONT_SUPPORT' => '对不起，您的电邮地址的web通讯簿不符合我们的使用规则。请试着点击下面的 \'Email Application\' ，以便使用您计算机中的地址。',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => '请输入您的 %s 密码。',
        'IMPORTING_ADDRESS_BOOK' => '输入通讯簿',
        'LEAVE_WINDOW_WHILE_GET' => '在我们获取您朋友的电邮地址时，<strong> 请不要关闭这一窗口 </strong>。等我们结束后，您可以选择想要邀请的朋友。',
        'SHARE_THIS_LINK' => '共享该链接：',
        'SEND_WITH_EMAIL_PROGRAM' => '用您电脑的电邮程序进行发送：',
        'EMAIL_THIS' => '用电邮发送',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '（是您的朋友）',
        'CLEAR' => '清除',
        'SEARCH_FRIENDS_TO_INVITE' => '搜索想要邀请的朋友：',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => '您的邀请已发出',
        'WANT_TO_INVITE_MORE' => '想要邀请更多的朋友？输入您的网站通讯簿或电邮应用程序中的联系人名单，就可以邀请更多的朋友。',
        'MESSAGE_TOO_LONG' => '该消息太长。请将其减至 %s 个字符，然后再试。',
        'FOLLOWING_DO_NOT_SEEM_VALID' => '下列地址好像不是有效的电邮地址。邀请没有发送。请更正电邮地址，然后再试。',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => '请输入一个或多个电邮地址。',
        'ENTER_EMAIL_ADDRESSES' => '输入电邮地址',
        'SEPARATE_MULTIPLE_ADDRESSES' => '用逗号把多个地址隔开',
        'YOUR_MESSAGE_OPTIONAL' => '<label>您的信息</label>（可选）',
        'SEND_INVITATIONS' => '发送邀请',
        'WEB_ADDRESS_BOOK' => '网站通讯簿',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail、Hotmail、Gmail或AOL Mail',
        'YOUR_EMAIL_ADDRESS' => '您的电邮地址',
        'IMPORT_ADDRESS_BOOK' => '输入通讯簿',
        'DONT_WORRY_WE_WONT_SAVE' => '不用担心，我们不会保存您的密码，您会有机会选择想要发送电邮的朋友。',
        'EMAIL_APPLICATION' => '电邮应用程序',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook，Apple Mail，.CSV等。',
        'UPLOAD_CSV_OR_VCF' => '上传从Microsoft Outlook或Apple Address Book（通讯簿）导出的 .csv 或 .vcf 文件。',
        'BROWSE_FOR_FILE' => '浏览文件',
        'UPLOAD' => '上传',
        'SELECT_ELLIPSIS' => '选择',
        'OTHER_ELLIPSIS' => '其他',
        'DONT_WORRY_YOULL_GET_CHANCE' => '不用担心，您会有机会选择想要发送电邮的朋友。',
        'MEMBERSHIP_BY_INVITATION_ONLY' => '特邀会员专用',
        'IF_YOU_ARE_ADMIN' => '如果您是管理者, <a %s>请点击这里登陆</a>。',
        'NAME_MUST_BE_SHORTER' => '姓名最多是%s个字符',
        'CITY_NAME_MUST_BE_SHORTER' => '城市名字最多是%s个字符',
        'EMAIL_ALREADY_REGISTERED' => '该电子邮件地址已被注册. 请另选一个。',
        'EMAIL_NOT_VALID' => '该电子邮件地址不是有效的地址。',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s邀请您到%s',
        'YOU_ARE_SIGNING_UP_WITH' => '您在用您的Ning ID 登陆.',
        'NOW_ENTER_PASSWORD' => '请输入您的密码。',
        'OR_SIGN_IN' => '或<a %s>登陆</a>',
        'CHANGE_ADDRESS' => '修改地址',
        'CHANGE_PAGE_ADDRESS' => '修改页面地址',
        'PAGE_ADDRESS_TAKEN' => '很抱歉 - 该名称已被使用。请另取一个名称。',
        'PAGE_ADDRESS_NOT_VALID' => '您的地址中只能使用英文字母、数字及下划线(_) 。',
        'ADD_BY_PHONE' => '用手机添加',
        'PAGE_ADDRESS' => '页面地址',
        'PHOTO_MUST_BE_TYPE' => '您的照片必须是一个 .jpg，.gif 或 .png 文件。',
        'USEFUL_ADDRESSES' => '有用的地址',
        'MY_DETAILS' => '我的详细介绍',
        'NONE_I_DO_NOT_WANT' => '无: 我不想收到任何来自%s的信件',
        'CHANGE_PASSWORD' => '修改密码',
        'PROFILE_SAVED' => '您的设置已被保存。',
        'UPDATE_EMAIL_ADDRESS' => '修改电子邮件地址',
        'EDIT_EMAIL_ADDRESS' => '编辑您的电子邮件地址',
        'MY_SETTINGS' => '我的简介设置',
        'ABOUT_ME' => '关于我',
        'SELECT' => '选择…',
        'CITY' => '城市',
        'COUNTRY' => '国家',
        'DATE_OF_BIRTH' => '生日',
        'DO_NOT_DISPLAY' => '不要显示',
        'GENDER' => '性别',
        'CREATE_YOUR_PROFILE' => '创建您的简介',
        'SYSTEM_REQUIREMENTS' => '系统要求',
        'WE_SUPPORT_INTERNET_EXPLORER' => '我们支持Internet Explorer 6 & 7, Firefox 2.0 和 Safari 2.0. 如果您用的是其他的浏览器(比如由您互联网服务提供商提供的), 您的浏览器有可能不兼容。',
        'MAKE_SURE_COOKIES' => '请确定您有开启您浏览器的cookies和JavaScript。',
        'WHAT_IS_MY_EMAIL' => '什么是我的电子邮件地址?',
        'IF_JOINED_BEFORE_OCTOBER' => '如果您在2007年10月5号之前加入的, 您以前是用Ning ID登陆的. 现在我们改变用您注册时的电子邮件地址, 不过您还是可以用您的Ning ID来登陆。',
        'CLICK_HERE_TO_RESET_PASSWORD' => '请点击这里重设您的密码。',
        'STILL_HAVING_PROBLEMS' => '还有问题么?',
        'VISIT_NING_HELP_CENTER' => '如果您需要更多的支持, 请到<a %s>Ning Help Center(Ning的帮助中心)</a>。',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => '无法注册或登录?',
        'WE_SENT_YOU_EMAIL' => '我们已寄给了您一个含有重设密码链接的电子邮件。',
        'RESET_PASSWORD_EMAIL_SUBJECT' => '重设密码',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

我们收到要求更改您的 %2$s密码的请求。

 点击下面的链接，以设置新的密码：

#{URL}

 如果您不想更改密码，您可以不用理会这个电子邮件。

 谢谢，
 "%2$s" 团队

-----
%2$s 使用Ning ID进行身份验证。',
        'SET_PASSWORD' => '设定密码',
        'NEW_PASSWORD' => '新的密码',
        'CREATE_NEW_PASSWORD' => '创建一个新的密码',
        'SET_NEW_PASSWORD' => '为您的Ning帐户设定一个新密码。',
        'CHOOSE_NEW_PASSWORD' => '请选择一个新密码',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>您好, %s</strong>(<a %s>退出</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => '无符合改电子邮件地址的帐户%s',
        'PLEASE_ENTER_CODE' => '请输入右边的验证码。',
        'PROBLEMS_SIGNING_UP' => '无法注册吗?',
        'BY_SIGNING_UP_YOU_AGREE' => '您的用户注册表示您已经同意<a %s>用户协议</a> and <a %s>隐私政策</a>。',
        'FEEDBACK' => '反馈',
        'TERMS_OF_SERVICE' => '用户协议',
        'PROBLEM_SIGNING_UP' => '无法注册',
        'ALREADY_MEMBER_SIGN_IN' => '您已是成员了吗? <a %s>请点击这里登陆</a>。',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => '%s的成员资格仅能邀请注册',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => '很抱歉, %s的管理员选择了加入该网络需要邀请的限制. 如果您有邀请函, 请点击邀请函里的链接。',
        'PROBLEM_SIGNING_IN' => '无法登陆',
        'WE_USE_NING_ID' => '我们使用Ning ID来做验证. <a %s>什么是 Ning ID?</a>',
        'PROBLEMS_SIGNING_IN' => '无法登陆?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="登陆" /> &#160;或&#160; <strong><a %s>注册</a></strong>',
        'SIGN_IN_TO_APPNAME' => '登陆至%s',
        'WHAT_IS_A_NING_ID' => '什么是 Ning ID?',
        'LARR_BACK' => '← <a %s>返回</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Ning ID 验证系统让您选择一个电子邮件地址和密码, 然后用它们加入或登陆任何使用Ning ID的社交网络。',
        'WHEN_YOU_CREATE_NING_ID' => '当您创建一个Ning ID时, 您也可以添加一些基本资料及您的照片到您的Ning ID简介。 当您新加入一个使用Ning ID用社交网络时, 这些资料将会被预先填入。 Ning ID还可让您记录所有您在Ning上的朋友与消息。',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => '当您看到该符号时, 您都可以用您的Ning ID和密码登陆: %s',
        'HELLO_USER' => '您好, %s',
        'TEXT_FOR_HEADER_TAB' => '这是页签标题的文本',
        'BASED_ON' => '基于',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => '您确定要删除该语言?',
        'DELETE_LANGUAGE' => '删除语言',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => '该文本已被调回到原文。',
        'UPLOAD_LANGUAGE_FILE' => '上传语言文件',
        'ADD_TO_LANGUAGE' => '添加到语言:',
        'IF_YOU_CREATED_TRANSLATION' => '如果您已经翻译了另一个Ning的网络, 您可以在此导入翻译。 这些文件的内容将会被加入到您所选的语言里。 没有您要的语言吗? <a %s>您可在这里很简单的添加一个</a>。',
        'EXAMPLES_SWEDISH_FINLAND' => '比如:&nbsp;简体中文, 瑞典语(芬兰), 法语, 西班牙语（波多里哥）',
        'START_FROM_SCRATCH_CREATE' => '从新开始! 您可以把您的网络翻译成另一个语言。 请先选择一个名称, 再选择一个现有的语言做为参考。',
        'KEY_MISSING_TEXT' => '注释: <span %s>未翻译的词汇</span> <span %s>翻译了的词汇</span>',
        'SHOW_ALL_TEXT' => '显示所有的词汇',
        'SHOW_MISSING_TEXT' => '显示所有未翻译的词汇',
        'SHOW_CHANGED_TEXT' => '显示所有翻译了的词汇',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => '比如: 页签, 成员, 朋友',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => '将文本调回到原文',
        'ORIGINAL_TEXT_X' => '原文-- %s',
        'EDIT_LANGUAGE_ON_NETWORK' => '编辑您网络的语言, 或翻译成新的语言。',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => '定制您网络上的任何文本, 包括页签名称, 电子邮件页脚, 错误消息, 及更多。',
        'ACTIVE_LANGUAGE_IS_X' => '<em>您网络现在所选的语言是%1$s</em>。 <a %2$s>修改您选择的语言</a>',
        'CURRENT_LANGUAGE_OPTIONS' => '现有的语言选项',
        'ACTIVE' => '现在的语言',
        'MY_LANGUAGES' => '我的语言',
        'CREATE_NEW_TRANSLATION' => '创建一个新的翻译',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => '没有您要的语言吗? <strong><a %s>把您的网络翻译成另一个语言</a></strong>。',
        'ADVANCED_IMPORT' => '高级导入',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => '如果您已经翻译了另一个Ning的网络, 您可以在此<strong><a %s>导入翻译</a></strong>, 用在这个网络上。',
        'LANGUAGE_EDITOR' => '语言编辑',
        'PUBLIC' => '共享的',
        'GRANDFATHERED_PRIVACY_SETTING' => '您网络的隐私设置现在是共享网络, 非成员只能看到登陆网页。 我们已不在提供这种隐私设置了。您的设置并没有被修改, 但如果您现在做任何修改, 您将无法返回。 现在对等的隐私设置是一个私有网络, 任何人都可注册为成员。',
        'NO_MISSING_ITEMS' => '所有的词汇都翻译了。 <a %s>浏览所有词汇。</a>',
        'NO_CHANGED_ITEMS' => '没有已被翻译过的词汇。',
        'COULD_NOT_FIND_ITEMS_MATCHING' => '对不起 - 我们无法找到符合<em>%s</em>的词汇。 <a %s>查看所有词汇。</a>',
        'FILE_N' => '文件%s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Ning翻译文件的名字类似与<code>en_US.txt</code>.。<a %s>在这里了解更多。</a>',
        'SELECT_TRANSLATION_FILE' => '选择翻译文件:',
        'USE_THIS_TRANSLATION' => '使用这个翻译',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => '以下这些是由特殊规则里漏掉的: %s',
        'ALL' => '所有的',
        'MISSING' => '还没翻译的',
        'VIEW' => '查看',
        'TRANSLATION_CHANGES_SAVED' => '已保存了您的修改。该翻译已经完成了%s%%。',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => '已保存了您的修改。该翻译已经完成了%s%%。 您要不要用这个作为您网络的语言?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => '您的上传已完成。 该翻译已经完成了%s%%。',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => '您的上传已完成。该翻译已经完成了%s%%。您要不要用这个作为您网络的语言?',
        'X_IS_CURRENT_LANGUAGE' => '%s是您网络的语言。',
        'SAVE_PAGE' => '保存',
        'LANGUAGE_NAME_TAKEN' => '很抱歉，该名称已被使用。请另取一个名称。',
        'ENTER_NAME_FOR_TRANSLATION' => '请为您的翻译输入一个名称, 比如 葡萄牙语(葡萄牙)',
        'CREATE' => '创建',
        'LANGUAGE_NAME' => '语言名称',
        'SAVE_ITEMS_ON_PAGE' => '保存该页面上的词汇',
        'NEW_TRANSLATION' => '新的翻译',
        'MISMATCHED_CURLY_BRACKETS' => '卷曲括号不匹配',
        'MISMATCHED_SQUARE_BRACKETS' => '方括号不匹配',
        'MISMATCHED_PARENTHESES' => '括号不匹配',
        'ERROR_PROCESSING_SPECIAL_RULES' => '在处理特殊规则时有错误发生。',
        'ERROR_PROCESSING_TAB_NAMES' => '在处理页签名称时有错误发生。',
        'SPECIAL_RULES' => '特殊规',
        'TAB_NAMES' => '页签名称',
        'SOURCE' => '源',
        'LANGUAGE_EDITOR_X' => '语言编辑: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← 回到语言编辑',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => '定制您网络的文本及消息, 或翻译成另一个语言。',
        'STOPWORDS' => 'a | about | an | are | as | at | be | by | com | de | en | for | from | how | i | in | is | it | la | of | on | or | that | the | this | to | was | what | when | where | who | will | with | und | the | www',
        'STOPWORDS_ARE' => '<a %s>忽略词汇单</a>是一个非必须的词汇单, 当我们从网络描述中产生meta tag时, 该词汇单里的字将会被过滤掉。 您不一定要创建这个忽略词汇单。',
        'I_AM_MEMBER' => '我属于：',
        'VIEW_PAGE_ON_APPNAME' => '浏览我在 <em>%s</em> 上的页面',
        'VISIT_APPNAME' => '访问%s',
        'JOIN_US' => '加入我们',
        'CREATED_BY_COLON' => '创建者：',
        'GET_MORE_BADGES' => '获取更多徽章',
        'SHOW_LOGO' => '显示标志',
        'GALLERY' => '画廊',
        'BADGES' => '徽章',
        'MEMBER_BADGE' => '成员徽章',
        'WEAR_IT_WITH_PRIDE' => '获取一个简介徽章,放在您的网站或您的MySpace页面上。',
        'NETWORK_BADGE_LARGE' => '网络徽章（大）',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => '广而告之！ 获取一个%s的可自动更新网络最有人气成员的徽章, 放在您的网站或您的MySpace页面上。',
        'NETWORK_BADGE_SMALL' => '网络徽章（小）',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => '广而告知！获取一个%s的徽章,放在您的网站或您的MySpace页面上。',
        'PHOTO_SLIDESHOW_PROPER' => '照片幻灯片',
        'DISPLAY_SELECTION_OF_PHOTOS' => '您可在您的网站或您的MySpace页面上,用我们最酷的幻灯片播放器来播放您所选择的照片。',
        'MUSIC_PLAYER' => '音乐播放器',
        'PLAY_MUSIC_ON_WEBSITE' => '您可在您的网站或您的MySpace页面上,用我们最时髦的音乐播放器来播放您所选择的音乐。',
        'ADD_A_VIDEO_MORE_OPTIONS' => '在您网站或MySpace页面上加个视频。 需要更多选择吗？<a href="%s">浏览</a>所有在%s的视频。',
        'LARGE_N_PIXELS_WIDE' => '大 - 宽%d像素',
        'MEDIUM_N_PIXELS_WIDE' => '中 - 宽%d像素',
        'SMALL_N_PIXELS_WIDE' => '小 - 宽%d像素',
        'MY_MOST_RECENT' => '我最新的',
        'APP_ICON' => '网络图标',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => '您需要被邀请才能加入%s',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s 提供了以下的反馈：',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s 在 %2$s 上提供了反馈…',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => '谢谢！ 您的消息已经送出去了。',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s想加入%s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '％s想要个到%s的邀请函',
        'YOUR_REQUEST_HAS_BEEN_SENT' => '您的请求已发送给网络创建者。',
        'TO_UNBAN_USERNAME_GO_TO' => '要解除禁止 %s，请到：',
        'SEND_REQUEST' => '发送请求',
        'SEARCH' => '搜索',
        'SEARCH_AGAIN' => '再搜索',
        'SEND_BROADCAST_MESSAGE' => '发送广播消息',
        'VERIFICATION_IMAGE' => '验证图片',
        'UNDER_CONSTRUCTION' => '正在建造中',
        'PROFILE_INFORMATION_SAVED' => '已保存了简介信息',
        'YOUR_SITES_DIRECTORY_PROFILE' => '已保存了您网络的简介信息。',
        'NO_ACCOUNT_WITH_EMAIL' => '没有符合该电子邮件的帐号。',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => '无效密码. 请检查Caps Lock是否开启?',
        'OOPS_THAT' => '对不起, 出错了。',
        'OOPS_THAT_DID_NOT_WORK' => '对不起, 出错了, 重试一下？',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => '对不起, 出错了(%s)。',
        'NOT_FOUND' => '没找到',
        'YOUR_SITES_FEATURE_LIST' => '已保存了您所想设定的网络功能。',
        'ONE_LINE_ANSWER' => '简洁答案',
        'LONGER_ANSWER' => '详细答案',
        'MULTIPLE_CHOICE' => '多选项',
        'DATE' => '日期',
        'WEBSITE_ADDRESS' => '网络地址',
        'EVERYTHING' => '所有项',
        'JUST_THE_HOMEPAGE' => '只有首页',
        'JUST_THE_SIGN_UP_PAGE' => '只有注册页面',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => '已保存您的修改。',
        'JOIN_ME_ON_X' => '和我一起加入%s!',
        'NOT_ALLOWED' => '不允许',
        'COME_JOIN_ME_ON_X' => '和我一起加入%s。',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => '和我一起加入%s…',
        'X_NOT_VALID_EMAIL' => '%s不是有效邮件地址或Ning ID',
        'USER_BANNED_FROM_NETWORK' => '您已禁止%1$s访问该网络。 <a %2$s>给%1$s发送个消息吧。</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s已是该网络的成员。 <a %2$s>给%1$s发送个消息吧。</a>',
        'YOU_CAN_SEND_AT_MOST_X' => '您一次只能发送%s个。',
        'PLEASE_ENTER_YOUR_FRIENDS' => '请输入您朋友的邮件地址或Ning ID',
        'THERE_HAS_BEEN_AN_ERROR' => '有错误发生',
        'INVITATIONS_HAVE_BEEN_SENT' => '您的邀请函已送出去了。',
        'SEARCH_RESULTS' => '搜索结果',
        'INVITE_YOUR_FRIENDS' => '邀请您的朋友',
        'SEND_INVITATIONS_FOR_FRIENDS' => '邀请您的朋友来加入',
        'INVITATION' => '邀请',
        'ADD_FROM_ADDRESS' => '从通讯录里添加',
        'TO' => '至：',
        'SEND_TO' => '送给',
        'SUBJECT' => '主题',
        'YOUR_MESSAGE' => '您的消息',
        'SEND' => '发送',
        'REPORT_AN_ISSUE' => '报告问题',
        'TYPE_OF_ISSUE' => '问题种类',
        'ADULT' => '成人',
        'ABUSIVE' => '侵犯性言语',
        'BUG' => '程序缺陷',
        'FRAUD' => '欺骗',
        'SPAM' => '垃圾邮件',
        'OTHER' => '其他',
        'DESCRIBE_YOUR_ISSUE' => '描述您的问题',
        'SEND_REPORT' => '发送报告',
        'ADDED_BY_X_AT_X' => '由<a %s>%s</a>添加 - %s（%s）',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => '由<a %s>%s</a>添加到%s - %s（%s）',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => '点击浏览',
        'COMMENT_FOR' => '以下评语给与:',
        'COMMENT_ON' => '以下评语关于:',
        'ACTION_BUTTON_FEATURE' => '推荐',
        'FEATURE_THIS_ON_YOUR' => '推荐这个上首页',
        'ACTION_BUTTON_REMOVE' => '删除',
        'REMOVE' => '删除',
        'REMOVE_THIS_FROM_YOUR' => '从首页删除这个',
        'FEATURE_ON_HOME' => '推荐到首页',
        'REMOVE_FROM_HOME' => '从首页中删除',
        'ITEM_WILL_APPEAR' => '这个项将会显示在主页上所选择的模块里',
        'ITEM_WILL_NO_LONGER_APPEAR' => '这个项将不在会显示在主页上所选择的模块里',
        'ADD_CONTENT' => '添加内容',
        'BROUGHT_TO_YOU_BY' => '%s是由%s为您创建的 © %s',
        'GIVE_US_YOUR_FEEDBACK' => '请给我们一些反馈意见',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => '有关其他的问题或要与Ning联系，请点击这里：',
        'SEND_FEEDBACK' => '发送反馈',
        'SIGN_OUT' => '退出',
        'SIGN_OUT_TITLE' => '退出',
        'EDIT_MY_PROFILE' => '编辑我的简介',
        'INVITE_MORE' => '邀请更多朋友',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => '用该表格送反馈意见给<a %3$s>%4$s</a>的创建者<a %1$s>%2$s</a>。',
        'YOUR_FEEDBACK' => '您的反馈',
        'NETWORK_INFORMATION' => '网络信息',
        'ABOUT_YOUR_SITE' => '关于您的网络',
        'WELCOME_TO_YOUR_SITE' => '欢迎来到您的社交网络!',
        'EDIT_YOUR_NETWORKS_INFO' => '编辑您网络的名字, 描述, 语言, 和隐私设置。',
        'TAGLINE' => '标签',
        'APPEARS_IN_HEADER' => '显示在您网络的页头',
        'APPEARS_IN_EMAILS' => '显示在电子邮件及其他一些地方',
        'NETWORK_NAME' => '网络名称',
        'DESCRIPTION' => '描述',
        'KEYWORDS' => '关键字',
        'LANGUAGE' => '语言',
        'SEPARATE_EACH_KEYWORD' => '用逗号分隔多个关键字',
        'ICON' => '图标',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => '请上传一张照片(GIF, JPG or PNG), 我们会自动把它调整成正方形。  照片需要几分钟才能显示出来。',
        'SAVE_SETTINGS' => '保存设置',
        'SUCCESS_EXCLAMATION' => '成功！',
        'FEATURES' => '功能',
        'ADD_FEATURES' => '为您的网络添加新功能',
        'ORGANIZE_FEATURES' => '您可以很简单地安排您的首页, 只要拖放以下的功能, 再按照您的喜好随意安排。',
        'SKIP_FEATURES' => '点击<a href="%s">按"跳过该步骤"</a>接受默认的功能及版面设计。',
        'FEATURES_FOR_ALL_PAGES' => '添加在该框内的功能将会显示在您网络所有的网页上。',
        'CUSTOMIZE_SITE_BY_ADDING' => '定制您的社交网络 - 您可以添加新的或删减已有的功能。',
        'ADJUST_YOUR_SITES_COLORS' => '调整您网络的颜色, 图片, 和整体风格。',
        'APPEARANCE' => '外观',
        'PROFILE_QUESTIONS' => '简介问题',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => '编辑网络成员在简介里必须回答的问题。',
        'MESSAGE_SENT' => '你的消息已发送！',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => '你的消息已发送到您网络的所有成员。',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => '你的消息已发送到您小组的所有成员。',
        'YOUR_MESSAGE_IS_BEING_SENT' => '你的消息正在发送. 请等一下, 可能会需要一会儿。',
        'BROADCAST_MESSAGE' => '广播消息',
        'TRACK_VISITORS_AND_TRENDS' => '跟踪您社交网站的访问者数量和趋势。',
        'EDIT_SOURCE_CODE' => '编辑源代码',
        'TAKE_FULL_CONTROL' => '打造一个全新独特的网络！现在就开始编辑您网络的源代码。',
        'DELETE_THIS_SITE' => '删除您的社交网络',
        'MAIN_PAGE' => '首页',
        'MAIN' => '首页',
        'MAIN_TAB_TEXT' => '首页',
        'MANAGE' => '管理',
        'MANAGE_TAB_TEXT' => '管理',
        'PAGE_TITLE' => '页面标题',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => '编辑您页面的外观',
        'CHOOSE_A_THEME' => '为您的社交网络选个主题',
        'NOW_CUSTOMIZE_SITE' => '定制您的社交网络...',
        'THEME_SETTINGS' => '主题设定',
        'ADVANCED' => '高级',
        'TOP_BAR_AND_FOOTER' => '上方工具栏与页脚',
        'HEADER_AND_NAVIGATION' => '页头与导航栏',
        'ADD_A_LOGO' => '添加标志',
        'THIS_IMAGE_WILL_REPLACE' => '该图片将取代网络名字文本',
        'TABS' => '页签',
        'TAB' => '页签',
        'SITE' => '网络',
        'SIDES' => '边',
        'BODY' => '正文',
        'SHOW_NING_LOGO' => '显示 Ning 标志?',
        'LAUNCH' => '发表！',
        'NING_ID' => 'Ning ID',
        'PASSWORD' => '密码',
        'RETYPE_PASSWORD' => '重新输入密码',
        'TYPE_CODE_ON_RIGHT' => '输入右边的<br />验证码',
        'JOIN_X' => '加入 %s',
        'SIGN_UP_FOR_X' => '注册上%s',
        'HAS_INVITED_YOU_TO_X' => '邀请你来加入 %s。',
        'CONTENT_AWAITING_APPROVAL' => '正在等待批准的内容',
        'NEW_MEMBER' => '新成员？',
        'JOIN_X_NOW' => '现在就加入%s!',
        'HIDE_THIS_MESSAGE' => '隐藏该消息',
        'PAGE_NOT_FOUND' => '页面未找到',
        'THIS_PAGE_WAS_NOT_FOUND' => '对不起, 页面未找到',
        'FOLLOW_THESE_LINKS_TO' => '下面这些链接是可以用的：',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => '您也可以搜索这个社交网络：',
        'IF_YOU_GET_THIS_MESSAGE' => '如果您再收到这个消息, <a %s>请告诉我们。</a>',
        'GROUP_MEMBERS' => '小组成员',
        'VIDEOS' => '视频',
        'BLOG' => '博客',
        'ACCOUNT' => '帐户',
        'WE_ARE_SORRY_WE_ARE_HAVING' => '对不起, 本页面有问题。',
        'FOLLOW_LINK_TO_HOMEPAGE' => '请跟随此链接到首页。',
        'REQUEST_AN_INVITATION' => '邀请我！',
        'NAME' => '名字',
        'EMAIL_ADDRESS' => '电子邮件地址',
        'MESSAGE_OPTIONAL' => '信息（可不填写）',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>抱歉！</strong>  但是您可以很简单的创建您自己的社交网络。',
        'GET_YOUR_OWN_BAZEL' => '创建您自己的社交网络！',
        'SITE_IS_NOT_READY' => '该社交网络还没准备好！',
        'BAZEL_IS_BEING_SET_UP' => '该社交网络还在建造中',
        'SIGN_IN' => '登录',
        'FORGOT_YOUR_PASSWORD' => '忘记密码了?',
        'FORGOT_YOUR_PASSWORD_TITLE' => '忘记密码?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => '输入您的电邮地址并点击 "重新设定密码"。您会收到一封电子邮件, 其中包含重新设定密码链接的电子邮件。',
        'RESET_PASSWORD' => '重新设定密码',
        'EXPLORE' => '浏览',
        'SIGN_UP' => '注册',
        'CONFIRM_PASSWORD' => '确认密码',
        'VERIFICATION' => '验证码',
        'YOUR_PHOTO' => '您的照片',
        'SUMMARY' => '摘要',
        'YOUR_SITE_IS_READY' => '您的社交网络已经可以发布了！如果您跳过了任何步骤,我们将用默认设置. 您可返回再修改, 或点击"发表"来发表您的网络。',
        'WHEN_YOU_ARE_FINISHED' => '当您做完了之后, 请点击"检查版面设计"来看看您的的创造！',
        'COMPLETE' => '完成的',
        'INCOMPLETE' => '未完成的',
        'VIEW_LAYOUT' => '检查版面设计',
        'CLEAR_CONTENTS' => '清除内容',
        'ADD_MODULE' => '添加模块...',
        'ADD_COLUMNS' => '添加竖列...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>共享的网络</strong> - 任何人都可加入。',
        'PRIVATE_ONLY_INVITED' => '<strong>私有的网络</strong> - 只有被邀请的朋友才能浏览及加入。',
        'INVITATIONS' => '邀请函',
        'MEMBERS_CAN_INVITE' => '本网络的成员可以邀请其他人加入。',
        'QUESTION_TITLE' => '问题标题',
        'ANSWER_TYPE' => '答案类型',
        'REQUIRED' => '必需的？',
        'PRIVATE' => '私有的',
        'CHOICES' => '选择',
        'SEPARATE_EACH_CHOICE' => '用逗号分隔多个选择',
        'CAN_PICK_MORE' => '可多项选择',
        'ADD_ANOTHER_QUESTION' => '添加另一个问题',
        'WHAT_INFORMATION' => '当新成员加入您的网络时, 您想要他们回答哪些问题？ 您可以随意调整问题的顺序 - 先点击问题, 再拖放到您想要的地方。',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => '如果您选择"必需的", 所有成员必须填写才能加入。 如果您选择"私有的", 只有您和网络管理者才能查看答案。',
        'WE_COULD_NOT_FIND_ANYTHING' => '我们无法找到和"%s"相关的项目。 要不要找些别的？',
        'GET_CUSTOM_URL' => '获取您定制的URL, 添加储存容量和带宽, 或经营您自己的网络广告服务。',
        'TRACK_STATISTICS' => '跟踪统计数据',
        'TRACKING_CODE' => '跟踪代码',
        'ANY_JAVASCRIPT_CODE' => '您在此处粘贴的任何JavaScript代码将会被放置在您的每一个网页的底部。您可用这项功能来增添外加的网络跟踪系统, 比如Google Analytics。',
        'ANALYTICS_LEARN_MORE' => '想要知道更多关于Google Analytics及如何设置您的帐户, 请<a %s>点击这里</a>。',
        'RESOURCES' => '资源',
        'LINKS' => '链接',
        'PAGE' => '页面',
        'BACKGROUND' => '背景',
        'TEXT' => '文本',
        'HEADING_TEXT' => '页头文本',
        'FONT' => '字体',
        'AABBCC' => 'AaBbCc',
        'COLOR' => '颜色',
        'LINK_COLOR' => '链接颜色',
        'BODY_TEXT' => '正文文本',
        'MIDDLE' => '中间',
        'FEATURE_BOXES' => '各项功能框架',
        'TITLEBAR_TEXT_COLOR' => '标题条文本的颜色',
        'TITLEBAR_BACKGROUND' => '标题条的背景',
        'UPLOADING_CONTENT' => '上传内容...',
        'WHEN_UPLOADING_IS_COMPLETE' => '上传完毕后您就可以浏览网络了.',
        'FINISH' => '完成',
        'FLICKR_IMPORT_SETUP' => '如何导入Flickr',
        'FLICKR_API_KEY' => '您的API键',
        'FLICKR_SECRET' => '您的密钥',
        'FLICKR_KEY_ERROR' => '您输入的Flickr密钥或API键有问题.  您可不可以检查一下再重新输入？',
        'FLICKR_INTRO' => '想让您的成员从Flickr导入他们的照片吗？ 那您可来对地方啦！ 您已经有了Flickr的API键和密钥了吗？从这<a %s>跳到最后一步</a>。 还没有吗？请按照以下这几个简单步骤：',
        'FLICKR_GET_ACCOUNT' => '您若还没有Flickr帐户, 您可<a %s>在此申请一个</a>。',
        'FLICKR_STEP1_TITLE' => '第一步： 获取一个Flickr API键',
        'FLICKR_STEP1_APPLY_SCREEN' => '申请您Flickr的API键的画面',
        'FLICKR_STEP1_API_SCREEN' => 'Flickr上API键的画面',
        'FLICKR_STEP1_INTRO' => '登录至Flickr, <a %s>申请Flickr API键</a> (点击该链接将会开启新窗口)。',
        'FLICKR_STEP1_A' => '填写<strong>您的名字</strong>和<strong>邮件地址</strong>。',
        'FLICKR_STEP1_B' => '在<strong>This key is for&hellip;</strong>下面选择 "non-commercial"（非商业）这一项。',
        'FLICKR_STEP1_C' => '在 "Describe the application are you planning to build" 的框内描述您的社交网络。',
        'FLICKR_STEP1_D' => '选中两个接受框。',
        'FLICKR_STEP1_APPLY' => '完成后请按"Apply"(应用)钮。',
        'FLICKR_STEP1_E' => '您会来到显示您新API键的画面。 点击“点击这里”链接来配置该键的用户验证。',
        'FLICKR_STEP2_TITLE' => '第二步：安装您的API键',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Flickr上配置您API键用户验证的画面。',
        'FLICKR_STEP2_F' => '粘贴以下网址到"Callback URL"(回叫URL)里：',
        'FLICKR_STEP2_SAVE_CHANGES' => '完成后请按 "Save Changes"(保存修改)钮。',
        'FLICKR_STEP3_TITLE' => '第三步：输入您的信息',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Flickr上API键信息的画面',
        'FLICKR_STEP3_CONGRATULATIONS' => '恭喜! 您已经装好了Flickr。',
        'FLICKR_STEP3_COMPLETE' => '最后一步就是拷贝并粘贴您的API键和密钥到下面的文本域：',
        'COMPLETE_SETUP' => '完成安装',
        'SETUP_YOUR_SITE_TO' => '把Flickr的照片导入到您的社交网络。',
        'FLICKR_IMPORTING' => 'Flickr的导入',
        'YOU_NEED_TO_SET_UP_FLICKR' => '您得先设定您的社交网络, 让成员能导入他们的Flickr照片。  这只要几分钟。 <a %s>现在就开始吧！</a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => '请不要再显示这个。',
        'YOUVE_SIGNED_OUT_OF_X' => '您已成功的退出%s。 请多多回来看看我们！',
        'CREATED_THIS_SOCIAL_NETWORK' => '在<a href="http://www.ning.com">Ning</a>上创建了这个社交网络。',
        'CREATE_YOUR_OWN' => '免费在Ning上创建了您自己的社交网络！',
        'DRAG_HERE_TO_REMOVE_FEATURE' => '拖放功能至此可将其删除',
        'LAYOUT' => '版面设计',
        'DRAG' => '拖动',
        'HERE' => '这儿',
        'YOU' => '您',
        'ADS' => '广告',
        'MEMBERS' => '成员列表',
        'HELLO_USERNAME' => '您好, 用户名称',
        'CREATED_BY' => '创建者:',
        'SAVE_FEATURES' => '保存所选择的功能',
        'FORUM' => '论坛',
        'CATEGORIES' => '类别',
        'FORUM_CATEGORIES' => '论坛类别',
        'A_THREADED_DISCUSSION_FORUM' => ' 一个基于线索讨论的论坛',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => ' 允许成员创建自己的兴趣小组',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => ' 从您的博客或其他成员的博客推荐帖子',
        'TEXT_BOX' => '文本框',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => '添加任何文本, 小工具, 或HTML在首页上',
        'A_LIST_OF_MEMBERS' => '一个显示您网络上所有成员的列表',
        'ALLOW_USERS_PHOTOS' => '(Photos) 允许成员上传及分享照片',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => '添加任何网站上的feed',
        'INFORMATION_ABOUT_THE_USER' => '已登录人员的信息',
        'ALLOW_USERS_VIDEOS' => '(Videos) 允许成员上传及分享视频',
        'SHOW_NETWORK_DESCRIPTION' => '显示您的网络描述',
        'PROMOTE_NETWORK_WITH_BADGES' => '用您定制的徽章及小工具在国际网络上推广您的社交网络',
        'MONETIZE_WITH_ADS' => '用广告来增加您网络的收入',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => '让您的成员知道是谁创建该网络的',
        'FOLLOW_LATEST_ACTIVITY' => '跟踪您网络上最新的成员活动',
        'FAQ_FOR_NETWORK_CREATORS' => '网络创建者的常见问题解答',
        'ANSWERS_TO_FAQS' => '有关定制您的社交网络的常见问题解答。',
        'MEET_OTHER_LIKEMINDED' => '和其他兴趣相合的网络创建者接触，分享点子，并获得 Ning 团队的支持。',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => '定制您社交网络的外观 - 您可在左边加上您自己的CSS。（<a href="%s">什么是CSS?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => '定制您的简介页面 - 您可在左边加上您自己的CSS。 （<a href="%s">什么是CSS?</a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => '您社交网络的CSS',
        'CSS_ON_YOUR_PAGE' => '您页面的层叠样式表单（CSS）',
        'ADDING_YOUR_OWN_CSS_NETWORK' => '添加您自己的CSS可以让您完全掌控您网络的字体, 颜色, 间隔, 和整体风格。',
        'ADDING_YOUR_OWN_CSS_PAGE' => '在您简介页面上添加您自己的CSS可以让您完全掌控您简介页面的字体, 颜色, 间隔, 和整体风格。',
        'CSS_STYLES_WILL_OVERRIDE' => '您在此添加的CSS将会覆盖现有的CSS。',
        'NEED_HELP_FIGURING_OUT_CSS' => '需要帮忙来弄明白您的网络上一个特有 CSS Class 的名称吗？我们建议使用免费的 Firebug 扩充件里的“检查 (Inspect)”功能（用于Firefox游览器）。',
        'WANT_TO_LEARN_MORE' => '想要知道更多吗？ 查看我们<a href="%s">高级的定制</a>部分。',
        'APPLY_XS_THEME' => '应用%s的主题',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => '已经有一个 Ning ID 是以这个电子邮件地址 %s注册的。在下方请以您的Ning ID或电子邮件地址登录。 如果您忘了您的密码， <a href="%s">请点击这里来重设您的密码</a>。',
        'INVITED' => '已被邀请的',
        'REQUESTED_INVITE' => '已申请邀请函的非成员',
        'BAN_FROM_NETWORK' => '禁止访问该网',
        'REMOVE_BAN' => '解除禁令',
        'CANCEL_INVITATION' => '取消邀请',
        'IGNORE' => '忽略',
        'PROMOTE_TO_ADMINISTRATOR' => '升级到管理者',
        'DEMOTE_FROM_ADMINISTRATOR' => '从管理者降级',
        'STATUS' => '状态',
        'DATE_JOINED' => '加入日期',
        'DATE_INVITED' => '邀请日期',
        'DATE_REQUESTED' => '请求日期',
        'DATE_APPLIED' => '申请日期',
        'NETWORK_CREATOR' => '网络创建者',
        'NETWORK_ADMINISTRATOR' => '网络管理者',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => '网络管理者有和网络创建者类似的管理权。',
        'DOWNLOAD_ALL_MEMBER_DATA' => '输出所有成员的数据 (.CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => '您的成员数据已被输出。右键点击 <a %s>这个链接</a>，选择“另存为”，将其保存到您的桌面。',
        'CLICK_GO_TO_START_EXPORT' => '点击“转到”开始输出。如果您有很多成员，该过程可能会需要好几分钟。',
        'MEMBER' => '成员',
        'INVITED_BY_X' => '被%s邀请的',
        'DONE' => '完毕',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => '您被禁止访问%s',
        'MESSAGE_TO_ADMINISTRATOR' => '送给管理者的消息',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => '抱歉, %s, 您已被禁止访问%s。 如果您觉得您不应该被禁, 请和网络管理者联系。',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => '抱歉, %s, 您已被禁止访问%s。',
        'SORRY_USERNAME' => '抱歉, %s',
        'PENDING' => '等候批准',
        'ACCEPT' => '接受',
        'PENDING_APPROVAL' => '等候批准',
        'ACCEPT_MEMBERSHIP' => '接受成员',
        'DECLINE_MEMBERSHIP' => '拒绝成员',
        'NO_PAGE_YET' => '尚无页面',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => '您在%s上的成员申请还得等网络管理者批准。',
        'MEMBERSHIP_PENDING_APPROVAL' => '成员资格正在等候批准中',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => '您的简介正在等候批准中',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => '您得等到网络管理者批准您的简介才能成为%s的成员。 您的简介一被批准我们就会通知您。',
        'CONTINUE_ARROW' => '继续 →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← 返回至等候成员列表',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s正在等候批准成为%s的新成员。',
        'VIEW_PAGE' => '查看页面',
        'MESSAGE' => '消息',
        'SEND_MESSAGE' => '发送消息',
        'MANAGE_FORUM_CATEGORIES' => '管理论坛类别',
        'START_DISCUSSIONS' => '开始讨论',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => '欢迎进入您新创建的社交网络!',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => '现在您只需 <a %s>邀请您的朋友</a>就行了！',
        'CONTRIBUTE' => '参与。',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>定制。</strong> 调整 <a %1$s>网络外观</a> 及设计 <a %2$s>徽章和小组件</a>。',
        'CONTROL_MANAGE_PAGE' => '<strong>控制。</strong> <a %s>管理</a> 页面上有许多配置选项。',
        'CREATE_GROUPS' => '创建小组',
        'INVITE_MORE_PEOPLE' => '邀请更多的朋友',
        'VIEW_THREAD' => '浏览线索',
        'COMMENT_THREAD' => '评论线索',
        'COMMENT_BACK' => '回复评论',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => '您得开启JavaScript才能用该网络。',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => '请检查您浏览器的设置或联系网络管理者。',
        'MANAGE_MEMBERS_ADMINS_INVITED' => '管理成员, 网络管理者, 被邀请的人员, 和被禁止的人员。',
        'MANAGE_MEMBERS' => '管理成员',
        'MANAGE_INVITED_PEOPLE' => '管理被邀请的人员',
        'NETWORK_SETTINGS' => '网络设置',
        'PROMOTE_YOUR_NETWORK' => '将您的网络升级',
        'NING_RESOURCES' => 'Ning的资源',
        'ADD_PREMIUM_SERVICES' => '添加特級服務',
        'REQUEST_SOURCE_CODE' => '请求源代码',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => '开发者：请求您网络的源代码。',
        'JOIN_NETWORK_CREATORS' => '加入网络创建者的社团',
        'SEND_MESSAGE_TO_ALL_THIS' => '给该网络的所有成员发送消息。',
        'CREATE_ANOTHER_NETWORK' => '创建另一个网络',
        'HAVE_ANOTHER_GREAT_IDEA' => '您又有了一个社交网络的好点子了吗？',
        'ALLOW_FACEBOOK_USERS_TO' => '允许Facebook的用户把您网络上的小工具放在他们的简介页面上。',
        'BADGES_AND_WIDGETS' => '徽章及小工具',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => '定制您网络徽章及小工具的外观。',
        'GET_BADGES' => '获取徽章',
        'CUSTOM_TEXT' => '自我定制的文本',
        'IM_A_MEMBER_OF' => '我属于：',
        'DONT_DISPLAY_ANY_BRANDING' => '不要显示任何品牌',
        'WATERMARK_OR_LOGO_IMAGE' => '水印或标志图片：',
        'NETWORK_BRANDING_BADGES' => '网络品牌传播：徽章',
        'NETWORK_BRANDING_WIDGETS' => '网络品牌传播：小工具',
        'LOGO_IMAGE' => '标志图片',
        'SMALL_NETWORK_BADGE' => '小网络徽章',
        'LARGE_NETWORK_BADGE' => '大网络徽章',
        'REFRESH' => '刷新',
        'HTML_EMBED_CODE' => 'HTML内嵌代码：',
        'CUSTOMIZE' => '定制',
        'SHARE_TITLE' => '分享 \'%s\'',
        'SHARE_TYPE' => '分享 %s',
        'YOUR_MESSAGE_SENT' => '您的消息已发送成功。',
        'YOUR_MESSAGES_SENT' => '您的消息已发送成功。',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => '您有两种方法共享%s&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => '看看这个%s: "%s"',
        'CHECK_OUT_THIS_TYPE' => '看看这个%s',
        'PHOTO_ALBUM' => '照片相册',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => '用您喜爱的颜色和图片来定制徽章和小工具。 您的修改最多需要四个小时才能在其他网站上显示出来。',
        'BACKGROUND_IMAGE_AND_COLOR' => '背景图片和颜色',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => '用该表格报告问题给<a %3$s>%34$s</a>的创建者 <a %1$s>%2$s</a>。',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => '对不起, 网络创建者不能在非他们创建的网络上修改电子邮件地址。',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => '对不起, 网络创建者不能在非他们创建的网络上修改密码。',
        'GO' => '开始',
        'LARGE_THUMBNAILS' => '大号缩略图',
        'SMALL_THUMBNAILS' => '小号缩略图',
        'RECENTLY_JOINED' => '最新的',
        'MOST_POPULAR_MEMBERS' => '最有人气的',
        'NO_MEMBERS_TO_DISPLAY' => '您现在没有显示任何成员',
        'BOX_WILL_NOT_SHOW_MEMBERS' => '只有当您选中至少一列, 其他人才能看得见该框。',
        'DETAIL_VIEW' => '详细浏览',
        'TITLES_ONLY' => '只有标题',
        'RECENTLY_ADDED_POSTS' => '最近添加的',
        'POPULAR_POSTS' => '最多评论的',
        'PROMOTED_POSTS' => '推荐的',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => '只有当您选中至少一个帖子, 其他人才能看得见该框。',
        'KEEP_WINDOW_OPEN_UPLOAD' => '在内容上传时请不要关闭该浏览窗口。',
        'CANCEL_UPLOAD' => '取消上传',
        'YOU_DO_NOT_HAVE_POSTS' => '您还未发表任何帖子。',
        'YOU_DO_NOT_HAVE_COMMENTS' => '没有任何评论需要您的批准。',
        'REQUIRED_FIELD' => '（必填项）',
        'BLOG_POST_BY_X' => '%s发表的博客帖子',
        'HELLO' => '您好',
        'ADDED_BY_X' => '%s添加的',
        'CLICK_TO_ADD_A_TITLE' => '点击这里添加标题',
        'DELETE_BLOG_POST' => '删除博文',
        'DELETE_THIS_BLOG_POST_Q' => '删除该博文？',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => '您确定您要删除这个博客文章？ 该过程可能会需要好几分钟。',
        'SPINNER' => '等待转轮',
        'PLEASE_ENTER_SOMETHING_FOR_X' => '请填写一些内容给：%s',
        'PLEASE_SELECT_OPTION_FOR_X' => '请选择一个选项给：%s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => '请提供一个有效日期给：%s',
        'PLEASE_PROVIDE_DATE_FOR_X' => '请提供一个日期给：%s',
        'XS_BLOG_POSTS_FOR_M_Y' => '%s的博文（为%s %s）',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => '被推荐的博文（为%s %s）',
        'BLOG_POSTS_FOR_M_Y' => '博文（为%s %s）',
        'FEATURED_BLOG_POSTS' => '被推荐的博文',
        'EVERYONES_POSTS' => '每个人的博文',
        'PUBLISHED_N_OF_N' => '发表于%d (%d)',
        'DOWNLOAD_X' => '下载%s',
        'UPLOAD_DID_NOT_WORK' => '抱歉, 上传失败',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M j Y',
        'XS_POSTS' => '%s的帖子',
        'USERNAMES_COMMENTS' => '%s的评论',
        'ADD_COMMENT' => '添加评论',
        'XS_PAGE' => '%s的页面',
        'XS_BLOG' => '%s的博客',
        'XS_FRIENDS' => '%s的朋友',
        'VIEW_XS_ELLIPSIS' => '浏览%s的...',
        'DRAFT_BRACKETS' => '[ 草稿 ]',
        'FEATURED' => '推荐的',
        'MY_POSTS' => '我的帖子',
        'MY_POSTS_ONLY' => '只有我的帖子',
        'OWNER_POSTS_ONLY' => '创建者的帖子',
        'JANUARY' => '一月',
        'FEBRUARY' => '二月',
        'MARCH' => '三月',
        'APRIL' => '四月',
        'MAY' => '五月',
        'JUNE' => '六月',
        'JULY' => '七月',
        'AUGUST' => '八月',
        'SEPTEMBER' => '九月',
        'OCTOBER' => '十月',
        'NOVEMBER' => '十一月',
        'DECEMBER' => '十二月',
        'MY_COMMENTS' => '我的评论',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => '我的页面',
        'MY_PAGE_TAB_TEXT' => '我的页面',
        'BLOG_POSTS' => '博文',
        'MY_BLOG' => '我的博客',
        'MONTH' => '月',
        'DAY' => '天',
        'PICK_VALID_DEFAULT_VISIBILITY' => '请为"默认可见性"挑一个有效的选择',
        'PICK_VALID_WHO_CAN_COMMENT' => '请为"谁可以添加评论"挑一个有效的选择',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => '请为"博文评论的审查"挑一个有效的选择',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => '请为"活动通知"挑一个有效的选择',
        'PICK_VALID_MODERATION_NOTIFICATION' => '请为"审查通知"挑一个有效的选择',
        'PICK_VALID_APPROVAL_NOTIFICATION' => '请为"审查结果通知"挑一个有效的选择',
        'PICK_VALID_INVITEE_NOTIFICATION' => '请为"被邀请者加入的通知"挑一个有效的选择',
        'PICK_VALID_NEVER_NOTIFICATION' => '请为"永不接收通知"挑一个有效的选择',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => '请为"请求朋友的通知"挑一个有效的选择',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => '请为"新消息的通知"挑一个有效的选择',
        'APPROVE_COMMENT' => '批准评论',
        'MANAGE_BLOG' => '管理博客',
        'COMMENTS_POSTED_ON_BLOG' => '贴在我博客上的评论',
        'COMMENT' => '评论',
        'COMMENTER' => '评论者',
        'POST' => '发表',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => '帖子已被删除了',
        'COMMENTS_ARE_CLOSED' => '该博文已不再接受评论',
        'NO_COMMENTS' => '无评论',
        'FLAG' => '加旗标',
        'POST_TITLE' => '帖子标题',
        'DRAFT_PARENTHESES' => '（草稿）',
        'SCHEDULED_TO_PUBLISH_ON' => '预定发表于：%s',
        'EDIT_2' => '编辑',
        'NONE' => '无',
        'N_NEW' => '%s新',
        'NO_POSTS' => '无帖子',
        'ADD_NEW_BLOG_POST' => '添加一个新的博文',
        'HAPPY' => '高兴',
        'SAD' => '伤心',
        'COOL' => '酷',
        'EVIL' => '邪恶的',
        'MAD' => '生气',
        'ENVIOUS' => '羡慕的',
        'ENTRY' => '条目',
        'WHAT_DATE_FOR_YOUR_POST' => '您想要何时发表这个帖子？',
        'NOW' => '现在',
        'CHOOSE_DATE_AND_TIME' => '为您的帖子选个日期和时间（如果是未来的日期, 您的帖子要到那时才会被发表）',
        'PRIVACY_AND_COMMENTS' => '隐私与评论',
        'WHO_CAN_VIEW_POST' => '谁可以看该帖子？',
        'EVERYONE' => '任何人',
        'ALLOW_COMMENTS' => '允许在该帖子上添加评论？',
        'YES' => '是',
        'NO' => '否',
        'COMMENT_MODERATION' => '审查评论',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => '您正在审查评论。',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => '您现在不在审查评论。',
        'SAVE_AS_DRAFT' => '保存为草稿',
        'PREVIEW' => '预览',
        'PUBLISH_POST' => '发表帖子',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => '这是您帖子的预览。 您可点击"返回"再继续编辑, 或点击"发表"来发表帖子！',
        'BACK' => '返回',
        'PUBLISH' => '发表',
        'BLOG_POST' => '博文',
        'PROFILE' => '简介',
        'THIS_IS_UNPUBLISHED_DRAFT' => '这是个还未发表的草稿',
        'WILL_BE_PUBLISHED_ON_X' => '将发表于%s <small> %s </small>',
        'POSTED_ON_X' => '已发表于%s <small> %s </small>',
        'POSTED_ON_X_BY' => '<strong>%s</strong> <small>%s</small> 的发表者:',
        'ABOUT_THIS_POST' => '关于该帖子',
        'ABOUT_YOUR_POST' => '关于您的帖子',
        'ADDED_BY' => '添加者:',
        'JUST_FRIENDS' => '只有朋友',
        'RECENT_POSTS' => '最近的帖子',
        'THERE_ARE_NO_RECENT_POSTS' => '最近没有帖子。',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => '您的帖子已添加, 但须经过审查后大家才能看到。',
        'AT_TIME_ON_DATE_USERNAME_SAID' => '在%s (%s), %s 说...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s在该社交网络上还没有朋友。',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => '您在该网络上还没有任何朋友。',
        'EDIT_PAGE_APPEARANCE' => '编辑页面的外观',
        'VIEW_PAGE_AS_OTHERS' => '从第三者角度预览页面',
        'ADD_BLOG_POST' => '添加博文',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => '在%s的内容被删除过程中请不要关闭该浏览窗口。该过程可能会需要好几分钟。',
        'BAN_MEMBER_FROM_NETWORK' => '禁止访问网络',
        'BAN_USERNAME' => '禁止%s?',
        'BLOCK' => '屏蔽',
        'CREATE_NEW_BLOG_POST' => '创建新的博文！',
        'EDIT_POST' => '编辑帖子',
        'EDIT_POST_COLON' => '编辑帖子：',
        'CONTINUE_READING' => '阅读全文...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => '由<a %s>我</a>发表于%s（%s）-',
        'POSTED_BY_X_ON_X_AT_X' => '由%s发表于%s（%s）-',
        'POSTED_BY_ME_ON_X_AT_X' => '由我发表于%s（%s）-',
        'ADD' => '添加',
        'SUBSCRIBE' => '订阅',
        'VIEW_ARCHIVES' => '查看档案',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => '您的设置已被保存。',
        'PLEASE_CORRECT_THE_FOLLOWING' => '请改正以下几点：',
        'PRIVACY' => '隐私',
        'NETWORK_PRIVACY' => '网络隐私',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => '该网络<strong>任何人都能浏览</strong>。',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => '任何人都可注册为成员。 访问者可以…',
        'SEE_EVERYTHING' => '可浏览所有网页',
        'SEE_JUST_THE_MAIN_PAGE' => '只能看见首页',
        'SEE_JUST_THE_SIGN_UP_PAGE' => '只能看见注册网页',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => '该网络只有<strong>成员能浏览</strong>。',
        'WHO_CAN_SIGN_UP' => '谁可以注册为成员?',
        'MODERATION' => '审查',
        'APPROVE_MEMBERS_BEFORE_JOIN' => '每一位成员在加入前得先得到您的批准',
        'APPROVE_PHOTOS_VIDEOS' => '每一张照片在发布前得先接受您的审查',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => '显示您网络上的最近活动！',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => '在您的网络主页上添加一个随时更新的活动流。',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => '点击这里来添加您网络上最近活动看板。',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'These options are disabled since you don\'t have activity on your network。',
        'ACTIVITY' => '活动',
        'DISPLAY_PREFERENCES' => '显示的偏好',
        'NEW_CONTENT' => '新的内容',
        'NEW_COMMENTS' => '新的评论',
        'NEW_MEMBERS' => '新的成员',
        'MEMBER_UPDATES' => '成员更新',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => '显示哪项在您网络的最近活动看板上?',
        'LATEST_ACTIVITY' => '最近的活动',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s评论了帖子%2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s<a %2$s>回复</a>了标题为<a %3$s>%4$s</a>的讨论',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => '您<a %1$s>回复</a>了标题为<a %2$s>%3$s</a>的讨论',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s 评论了博客帖子 %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s> 评论了 </a> 博客帖子 <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '您 <a %1$s> 评论了 </a> 博客帖子 <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s开始了个标题为%s的讨论',
        'YOU_STARTED_A_DISCUSSION_Y' => '您开始了个标题为%s的讨论',
        'X_ADDED_THE_BLOG_POST_Y' => '%s添加了博文\'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => '您添加了博文\'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s加入了小组%s',
        'YOU_JOINED_THE_GROUP_X' => '您加入了小组%s',
        'X_JOINED_Y_GROUPS' => '%s加入了%s的小组',
        'YOU_JOINED_X_GROUPS' => '您加入了%s的小组',
        'X_JOINED_APPNAME' => '%s加入了%s。',
        'WELCOME_MEMBER_N_OF_APPNAME' => '欢迎, %1$s! 您是%3$s上的第%2$s号成员。',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => '欢迎，%1$s！您是 %3$s 上的第 %2$s 号成员。<a %4$s> 现可查找朋友 </a> 。',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s是%3$s上的第%2$s号成员。',
        'XS_PROFILE_CHANGED' => '%s的简介被修改了',
        'YOUR_PROFILE_CHANGED' => '您的简介被修改了Your profile changed',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s给%s留了个评论',
        'YOU_LEFT_A_COMMENT_FOR_X' => '您给%s留了个评论',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s给您留了个评论',
        'X_CREATED_A_GROUP_Y' => '%s创建了个小组: %s',
        'YOU_CREATED_A_GROUP_Y' => '您创建了个小组: %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s创建了%s个小组',
        'X_STARTED_Y_FORUM_POSTS' => '%s开始了%s个新的论坛帖子',
        'YOU_STARTED_Y_FORUM_POSTS' => '您开始了%s个新的论坛帖子',
        'X_ADDED_Y_BLOG_POSTS' => '%s开始了%s个新的博客帖子',
        'YOU_ADDED_Y_BLOG_POSTS' => '您开始了%s个新的博客帖子',
        'VIEW_XS_BLOG_POSTS' => '浏览%s的博客帖子',
        'VIEW_YOUR_BLOG_POSTS' => '浏览您的博客帖子',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s有<a %s>新的简介问题</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s现在有音乐播放器了',
        'APPNAME_NOW_HAS_GROUPS' => '%s现在有<a %s>小组</a>了',
        'APPNAME_NOW_HAS_VIDEO' => '%s现在有<a %s>视频</a>了',
        'APPNAME_NOW_HAS_FORUM' => '%s现在有<a %s>论坛</a>了',
        'APPNAME_NOW_HAS_PHOTO' => '%s现在有<a %s>照片</a>了',
        'DID_YOU_KNOW' => '您知道吗',
        'ANNOUNCEMENT' => '通告',
        'CONGRATULATIONS' => '祝贺',
        'YOU_CREATED_APPNAME' => '您创建了 %s 网络。',
        'USER_CREATED_APPNAME' => '%s 创建了 %s 网络。',
        'ADD_MESSAGES_ACTIVITY_FEED' => '添加消息并选择什么消息会显示在您网络的活动Feed上。',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => '您想将哪些活动显示在您网络的最新活动看板上?',
        'NEW_CONTENT_I_ADD' => '我所添加的新内容',
        'NEW_COMMENTS_I_ADD' => '我所添加的新评论',
        'WHEN_I_UPDATE_MY_PROFILE' => '当我更新我的简介',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => '最新活动看板不会显示您发送的消息、您阅览的页面及简介、您拒绝的邀请函、您拒绝的成员、 或任何您删除的内容。',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => '您最近没做什么事情。现在开始做些什么吧。',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => '您已关闭您的活动看板。<a %s>点击这里来启动。</a>You\'ve turned off the display of your activity。 <a %s>Click here to turn it back on。</a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => '该网络创建者没有显示任何活动。',
        'NO_ACTIVITY_TO_DISPLAY' => '您现在没有显示任何活动。',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => '只有当您选中至少一个活动项目，其他人才能看得见该框。',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => '您的网络最近没啥动静。现在开始做些什么吧。',
        'MY_ACTIVITY_PREFERENCES' => '我的活动偏好',
        'DELETE_ACTIVITY_ITEM' => '隐藏活动消息',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => '隐藏活动消息?',
        'THIS_WILL_PREVENT_ACTIVITY' => '这将让所有人看不到该活动消息',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%s添加了最多的照片',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s是最有人气的照片',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%s添加了最多的视频',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s是最有人气的视频',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s添加了最多首歌曲',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s是最有人气的歌曲',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s是最有人气的论坛帖子',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s是最有人气的博客帖子',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s的最新活动(在%s上)',
        'LATEST_ACTIVITY_ON_APPNAME' => '%s的最新活动',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => '在最新活动看板添加消息',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => '添加该网络的信息…',
        'ADD_MESSAGE' => '添加消息',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '…或填写您自己的消息',
        'NETWORK' => '网络',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => '在默认情况下, 谁可以看我的照片, 视频, 和博文？',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(您在添加照片, 视频, 和博文时, 可覆盖此设置。）',
        'MODERATE_COMMENTS_ON_BLOG' => '在您的博客上发表评论之前是否需要您的审查？',
        'YES_LET_ME_APPROVE' => '是 - 我要先审查评论',
        'NO_PUBLISH_COMMENTS' => '否 - 直接发表',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => '谁可以评论我的照片, 视频, 和博文？',
        'SAVE' => '保存',
        'EMAIL' => '电邮',
        'YOUR_PRIVACY_IS_IMPORTANT' => '我们非常重视您的隐私。 如果您对您的邮件通知有任何问题或顾虑，您可以通过<a href="http://help.ning.com/?page_id=27">Ning的帮助中心</a>联系我们。',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => '添加照片和视频到 %s, 发送至此邮件地址：',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => '您可用手机直接添加照片和视频到%s，只需把它们发送到这个电子邮件信箱：',
        'GENERATE_NEW_EMAIL_ADDRESS' => '产生新的邮件地址',
        'SUPPORTS_TEXT_EMBEDDED' => '支持文本, 内嵌视频, 照片, 和小工具',
        'POST_COMMENT' => '发表评论',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => '您得是成员才能加评论！',
        'MONTHLY_ARCHIVES' => '按月存档',
        'NO_FRIENDS_ON_SITE' => '在此社交网络上还没朋友。',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => '该社交网络没有符合您搜索条件的朋友。',
        'MEMBERS_TAB_TEXT' => '成员列表',
        'SITE_HAS_NO_MEMBERS' => '这个社交网络还没有成员。',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => '该社交网络没有符合您搜索条件的成员。',
        'NO_COMMENTS_YET' => '还没评论！',
        'VIEW_ALL_COMMENTS' => '浏览所有的评论',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => '您还没添加任何博文。',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => '您可写任何内容, 谈论和内嵌您喜爱的视频, 照片, 和音乐。',
        'WRITE_YOUR_FIRST_ENTRY' => '写您的第一个博文！',
        'THERE_ARE_NO_BLOG_POSTS' => '您的社交网络没有任何博客帖子。',
        'THERE_ARE_NO_FEATURED_X' => '您的社交网络没有任何被推荐的 %s 。',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => '没有任何符合您预选的 %s 。',
        'START_FEATURING_X_CLICK_Y' => '当您看到"推荐"这个选项时, 您可以推荐 %s 。想要知道更多关于"推荐", 请<a %s>点击这里</a>。',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => '这里至少要有一个博客贴子，其他人才能看得见该视频框。 现在就添加一个吧！',
        'YOUR_FRIEND' => '这是您的朋友',
        'REQUEST_SENT' => '请求已被发送。',
        'BLOCKED' => '被屏蔽了',
        'BANNED' => '禁止',
        'ADD_YOUR_FIRST_BLOG_POST' => '添加您第一个博文',
        'MY_FIRST_BLOG_POST' => '我的第一个博文！',
        'TELL_THE_PEOPLE_ON' => '向%s的成员介绍您自己：',
        'CHOOSE_A_THEME_FOR_PAGE' => '为您的页面选一个主题',
        'NOW_CUSTOMIZE_PAGE' => '现在定制您的页面...',
        'NO_POSTS_TO_DISPLAY' => '没有帖子可显示。',
        'YOU_ARE_DISPLAYING_NO_POSTS' => '您现在没有显示任何帖子。',
        'DATE_COLON' => '日期：',
        'TIME_COLON' => '时间：',
        'CHANGE' => '修改',
        'UPLOAD_A_PHOTO' => '上传照片',
        'OPTIONS' => '选项',
        'PIXELS' => '像素',
        'CANCEL' => '取消',
        'UPLOAD_A_FILE' => '上传文件：',
        'TO_INSERT_A_FILE' => '要插入文件，点击上面的”浏览“或”选择“按钮选定您电脑上的文件。',
        'UPLOADING' => '上传...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => '最有人气的成员',
        'INVITE_FRIENDS' => '邀请朋友',
        'VIEW_ALL' => '浏览全部',
        'REMOVE_X' => '删除 %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => '您确定您要禁止 %1$s 访问您的社交网络, 并删除 %1$s 所添加的所有内容？ 该过程可能会需要好几分钟。',
        'REMOVING_X' => '正在删除 %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => '您确定您要禁止这几位成员访问您的社交网络, 并删除他们所添加的所有内容？ 该过程可能会需要好几分钟。',
        'ARE_YOU_SURE_BAN_MEMBERS' => '您确定您要禁止这几位成员访问您的社交网络? 该过程可能会需要好几分钟。',
        'BAN' => '禁止',
        'REMOVING_MEMBERS' => '删除成员',
        'FEMALE' => '女',
        'MALE' => '男',
        'UNITED_STATES' => '美国',
        'AND' => '和',
        'FROM' => '来自',
        'GENDER_M' => '男',
        'GENDER_F' => '女',
        'XS_PAGE_ON_Y' => '%s 的页面（在 %s 上）',
        'SEARCH_MEMBERS' => '搜索成员：',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => '有人评论了您在 %s 上的博文',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => '您的页面上多了一条新评论。',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => '您在%s的页面上多了一条新评论。',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => '您在%s的页面上多了一条新评论',
        'A_BLOG_POST' => '一个博文',
        'NOW_THAT_YOU_JOINED_INVITE' => '既然您已加入，<strong><a %s> 邀请您的朋友一起来吧 </a></strong>！',
        'THIS_IS_YOUR_PROFILE' => '这是您的简介：',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => '开始先 <a %s> 定制其外观 </a> 。',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => '用它来 <a %1$s> 保留博客 </a>，和显示 <a %2$s> 您的简介答复</a> 。',
        'START_CONTRIBUTING' => '开始提供：',
        'UPLOAD_VIDEOS' => '上传视频',
        'CONTRIBUTE_TO_DISCUSSIONS' => '参与讨论',
        'JOIN_GROUPS' => '加入小组',
        'ADD_A_BLOG_POST' => '添加一个博文',
        'CLICK_TO_ACCEPT_FRIENDS' => '点击这里查看您的朋友请求。',
        'LEAVE_X' => '离开 %s',
        'LEAVE_X_Q' => '离开 %s？',
        'ARE_YOU_SURE_LEAVE_X' => '您确定要离开 %s 并删除您的所有内容？该过程可能会需要好几分钟。',
        'BACK_TO_USERNAMES_PAGE' => '&#8592; 返回 %s 的页面',
        'BACK_TO_MY_PAGE' => '&#8592; 返回我的页面',
        'COMMENT_WALL' => '评论墙',
        'ONLINE' => '在线',
        'MEMBER_IS_ONLINE' => '成员在线上',
        'ONLINE_NOW' => '现在在线上',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => '选择谁可浏览, 加入并提供内容到您的网络。',
        'EMAIL_NOTIFICATIONS' => '电子邮件通知',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => '您想收到哪些活动的电子邮件通知?',
        'NETWORK_MESSAGES' => '网络消息',
        'MEMBER_ACTIVITY' => '成员活动',
        'APPROVAL' => '批准',
        'FRIEND_REQUESTS' => '朋友请求',
        'PEOPLE_IVE_INVITED_JOIN' => '被我邀请加入该网络的人员',
        'MESSAGES_SENT_TO_ME' => '由我发送的消息',
        'MESSAGES_SENT_TO_GROUPS' => '消息发给我所属的小组',
        'MESSAGES_SENT_TO_NETWORK' => '发送给网络所有成员的消息',
        'I_HAVE_NEW_COMMENTS' => '有新的消息要我批准',
        'I_HAVE_NEW_NETWORK_CONTENT' => '有新的内容要我批准',
        'CONTENT_ACTIVITY' => '内容活动',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => '我所添加的内容上的活动',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => '自动跟踪我所回复的讨论',
        'THINGS_IVE_ADDED_APPROVED' => '我所添加的内容已被批准',
        'NOTIFICATIONS' => '通知',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => '当有人回复时请寄电子邮件给我',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => '当有人回复时别寄邮件给我',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => '若想停止跟踪该%s, <a %s>请按这里</a>。',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => '您不再跟踪这个%s。',
        'NOTIFY' => '通知',
        'STOP_NOTIFYING' => '停止通知',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => '当有新的讨论时请寄电子邮件给我',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => '当有新的讨论时请不要寄电子邮件给我',
        'STOP_FOLLOWING_ALL' => '停止跟踪所有的讨论及博文评论',
        'CHANGE_MY_PHOTO' => '更换我的照片',
        'COUNTRY_AF' => '阿富汗',
        'COUNTRY_AX' => '奥兰群岛',
        'COUNTRY_AL' => '阿尔巴尼亚',
        'COUNTRY_DZ' => '阿尔及利亚',
        'COUNTRY_AS' => '美属萨摩亚',
        'COUNTRY_AD' => '安道尔',
        'COUNTRY_AO' => '安哥拉',
        'COUNTRY_AI' => '安圭拉',
        'COUNTRY_AQ' => '南极洲',
        'COUNTRY_AG' => '安提瓜和巴布达',
        'COUNTRY_AR' => '阿根廷',
        'COUNTRY_AM' => '亚美尼亚',
        'COUNTRY_AW' => '阿鲁巴',
        'COUNTRY_AU' => '澳大利亚',
        'COUNTRY_AT' => '奥地利',
        'COUNTRY_AZ' => '阿塞拜疆',
        'COUNTRY_BS' => '巴哈马',
        'COUNTRY_BH' => '巴林',
        'COUNTRY_BD' => '孟加拉',
        'COUNTRY_BB' => '巴巴多斯',
        'COUNTRY_BY' => '白俄罗斯',
        'COUNTRY_BE' => '比利时',
        'COUNTRY_BZ' => '伯利兹',
        'COUNTRY_BJ' => '贝宁',
        'COUNTRY_BM' => '百慕大',
        'COUNTRY_BT' => '不丹',
        'COUNTRY_BO' => '玻利维亚',
        'COUNTRY_BA' => '波斯尼亚和黑塞哥维那',
        'COUNTRY_BW' => '博茨瓦纳',
        'COUNTRY_BV' => '布韦岛',
        'COUNTRY_BR' => '巴西',
        'COUNTRY_IO' => '英属印度洋领地',
        'COUNTRY_BN' => '文莱达鲁萨兰国',
        'COUNTRY_BG' => '保加利亚',
        'COUNTRY_BF' => '布基纳法索',
        'COUNTRY_BI' => '布隆迪',
        'COUNTRY_KH' => '柬埔寨',
        'COUNTRY_CM' => '喀麦隆',
        'COUNTRY_CA' => '加拿大',
        'COUNTRY_CV' => '佛得角',
        'COUNTRY_KY' => '开曼群岛',
        'COUNTRY_CF' => '中非共和国',
        'COUNTRY_TD' => '乍得',
        'COUNTRY_CL' => '智利',
        'COUNTRY_CN' => '中国',
        'COUNTRY_CX' => '圣诞岛',
        'COUNTRY_CC' => '科科斯群岛',
        'COUNTRY_CO' => '哥伦比亚',
        'COUNTRY_KM' => '科摩罗联盟',
        'COUNTRY_CG' => '刚果共和国',
        'COUNTRY_CD' => '刚果民主共和国',
        'COUNTRY_CK' => '库可群岛',
        'COUNTRY_CR' => '哥斯达黎加',
        'COUNTRY_CI' => '科特迪瓦',
        'COUNTRY_HR' => '克罗地亚',
        'COUNTRY_CU' => '古巴',
        'COUNTRY_CY' => '塞浦路斯',
        'COUNTRY_CZ' => '捷克共和国',
        'COUNTRY_DK' => '丹麦',
        'COUNTRY_DJ' => '吉布提',
        'COUNTRY_DM' => '多米尼克',
        'COUNTRY_DO' => '多米尼加共和国',
        'COUNTRY_EC' => '厄瓜多尔',
        'COUNTRY_EG' => '埃及',
        'COUNTRY_SV' => '萨尔瓦多',
        'COUNTRY_GQ' => '赤道几内亚',
        'COUNTRY_ER' => '厄立特里亚',
        'COUNTRY_EE' => '爱沙尼亚',
        'COUNTRY_ET' => '埃塞俄比亚',
        'COUNTRY_EU' => '欧盟',
        'COUNTRY_FK' => '福克兰群岛',
        'COUNTRY_FO' => '法罗群岛',
        'COUNTRY_FJ' => '斐济',
        'COUNTRY_FI' => '芬兰',
        'COUNTRY_FR' => '法国',
        'COUNTRY_GF' => '法属圭亚那',
        'COUNTRY_PF' => '法属波利尼西亚',
        'COUNTRY_TF' => '法属南部领土',
        'COUNTRY_GA' => '加蓬',
        'COUNTRY_GM' => '冈比亚',
        'COUNTRY_GE' => '格鲁吉亚',
        'COUNTRY_DE' => '德国',
        'COUNTRY_GH' => '加纳',
        'COUNTRY_GI' => '直布罗陀',
        'COUNTRY_GR' => '希腊',
        'COUNTRY_GL' => '格陵兰',
        'COUNTRY_GD' => '格林纳达',
        'COUNTRY_GP' => '瓜德罗普',
        'COUNTRY_GU' => '关岛',
        'COUNTRY_GT' => '危地马拉',
        'COUNTRY_GN' => '几内亚',
        'COUNTRY_GW' => '几内亚比绍',
        'COUNTRY_GY' => '圭亚那',
        'COUNTRY_HT' => '海地',
        'COUNTRY_HM' => '赫德和麦克唐纳群岛',
        'COUNTRY_HN' => '洪都拉斯',
        'COUNTRY_HK' => '香港',
        'COUNTRY_HU' => '匈牙利',
        'COUNTRY_IS' => '冰岛',
        'COUNTRY_IN' => '印度',
        'COUNTRY_ID' => '印度尼西亚',
        'COUNTRY_IR' => '伊朗伊斯兰共和国',
        'COUNTRY_IQ' => '伊拉克',
        'COUNTRY_IE' => '爱尔兰',
        'COUNTRY_IL' => '以色列',
        'COUNTRY_IT' => '意大利',
        'COUNTRY_JM' => '牙买加',
        'COUNTRY_JP' => '日本',
        'COUNTRY_JO' => '约旦',
        'COUNTRY_KZ' => '哈萨克斯坦',
        'COUNTRY_KE' => '肯尼亚',
        'COUNTRY_KI' => '基里巴斯',
        'COUNTRY_KP' => '朝鲜民主主义人民共和国',
        'COUNTRY_KR' => '大韩民国',
        'COUNTRY_KW' => '科威特',
        'COUNTRY_KG' => '吉尔吉斯斯坦',
        'COUNTRY_LA' => '老挝人民民主共和国',
        'COUNTRY_LV' => '拉脱维亚',
        'COUNTRY_LB' => '黎巴嫩',
        'COUNTRY_LS' => '莱索托',
        'COUNTRY_LR' => '利比里亚',
        'COUNTRY_LY' => '阿拉伯利比亚民众国',
        'COUNTRY_LI' => '列支敦士登',
        'COUNTRY_LT' => '立陶宛',
        'COUNTRY_LU' => '卢森堡',
        'COUNTRY_MO' => '澳门',
        'COUNTRY_MK' => '前南斯拉夫马其顿共和国',
        'COUNTRY_MG' => '马达加斯加',
        'COUNTRY_MW' => '马拉维',
        'COUNTRY_MY' => '马来西亚',
        'COUNTRY_MV' => '马尔代夫',
        'COUNTRY_ML' => '马里',
        'COUNTRY_MT' => '马耳他',
        'COUNTRY_MH' => '马绍尔群岛',
        'COUNTRY_MQ' => '马提尼克',
        'COUNTRY_MR' => '毛利塔尼亚',
        'COUNTRY_MU' => '毛里求斯',
        'COUNTRY_YT' => '马约特岛',
        'COUNTRY_MX' => '墨西哥',
        'COUNTRY_FM' => '密克罗尼西亚联邦',
        'COUNTRY_MD' => '摩尔多瓦共和国',
        'COUNTRY_MC' => '摩纳哥',
        'COUNTRY_MN' => '蒙古',
        'COUNTRY_MS' => '蒙特塞拉特岛',
        'COUNTRY_MA' => '摩洛哥',
        'COUNTRY_MZ' => '莫桑比克',
        'COUNTRY_MM' => '缅甸',
        'COUNTRY_NA' => '纳米比亚',
        'COUNTRY_NR' => '瑙鲁',
        'COUNTRY_NP' => '尼泊尔',
        'COUNTRY_NL' => '荷兰',
        'COUNTRY_AN' => '荷属安地列斯群岛',
        'COUNTRY_NC' => '新喀里多尼亚',
        'COUNTRY_NZ' => '新西兰',
        'COUNTRY_NI' => '尼加拉瓜',
        'COUNTRY_NE' => '尼日尔',
        'COUNTRY_NG' => '尼日利亚',
        'COUNTRY_NU' => '纽埃',
        'COUNTRY_NF' => '诺福克岛',
        'COUNTRY_MP' => '北马里亚纳群岛',
        'COUNTRY_NO' => '挪威',
        'COUNTRY_OM' => '阿曼',
        'COUNTRY_PK' => '巴基斯坦',
        'COUNTRY_PW' => '帕劳',
        'COUNTRY_PS' => '巴勒斯坦被占领土',
        'COUNTRY_PA' => '巴拿马',
        'COUNTRY_PG' => '巴布亚新几内亚',
        'COUNTRY_PY' => '巴拉圭',
        'COUNTRY_PE' => '秘鲁',
        'COUNTRY_PH' => '菲律宾',
        'COUNTRY_PN' => '皮特凯恩',
        'COUNTRY_PL' => '波兰',
        'COUNTRY_PT' => '葡萄牙',
        'COUNTRY_PR' => '波多黎各',
        'COUNTRY_QA' => '卡塔尔',
        'COUNTRY_RE' => '留尼汪',
        'COUNTRY_RO' => '罗马尼亚',
        'COUNTRY_RU' => '俄罗斯联邦',
        'COUNTRY_RW' => '卢旺达',
        'COUNTRY_SH' => '圣赫勒拿',
        'COUNTRY_KN' => '圣基茨和尼维斯',
        'COUNTRY_LC' => '圣卢西亚',
        'COUNTRY_PM' => '圣皮埃尔和密克隆',
        'COUNTRY_VC' => '圣文森特和格林纳丁斯',
        'COUNTRY_WS' => '萨摩亚',
        'COUNTRY_SM' => '圣马力诺',
        'COUNTRY_ST' => '圣多美和普林西比',
        'COUNTRY_SA' => '沙特阿拉伯',
        'COUNTRY_SN' => '塞内加尔',
        'COUNTRY_CS' => '塞尔维亚和黑山',
        'COUNTRY_SC' => '塞舌尔',
        'COUNTRY_SL' => '塞拉利昂',
        'COUNTRY_SG' => '新加坡',
        'COUNTRY_SK' => '斯洛伐克',
        'COUNTRY_SI' => '斯洛文尼亚',
        'COUNTRY_SB' => '所罗门群岛',
        'COUNTRY_SO' => '索马里',
        'COUNTRY_ZA' => '南非',
        'COUNTRY_GS' => '南乔治亚和南桑德韦奇群岛',
        'COUNTRY_ES' => '西班牙',
        'COUNTRY_LK' => '斯里兰卡',
        'COUNTRY_SD' => '苏丹',
        'COUNTRY_SR' => '苏里南',
        'COUNTRY_SJ' => '斯瓦尔巴岛和扬马延岛',
        'COUNTRY_SZ' => '斯威士兰',
        'COUNTRY_SE' => '瑞典',
        'COUNTRY_CH' => '瑞士',
        'COUNTRY_SY' => '阿拉伯叙利亚共和国',
        'COUNTRY_TW' => '台湾',
        'COUNTRY_TJ' => '塔吉克斯坦',
        'COUNTRY_TZ' => '坦桑尼亚联合共和国',
        'COUNTRY_TH' => '泰国',
        'COUNTRY_TL' => '东帝汶',
        'COUNTRY_TG' => '多哥',
        'COUNTRY_TK' => '托克劳',
        'COUNTRY_TO' => '汤加',
        'COUNTRY_TT' => '特立尼达和多巴哥',
        'COUNTRY_TN' => '突尼斯',
        'COUNTRY_TR' => '土耳其',
        'COUNTRY_TM' => '土库曼斯坦',
        'COUNTRY_TC' => '特克斯和凯科斯群岛',
        'COUNTRY_TV' => '图瓦卢',
        'COUNTRY_UG' => '乌干达',
        'COUNTRY_UA' => '乌克兰',
        'COUNTRY_AE' => '阿拉伯联合酋长国',
        'COUNTRY_GB' => '英国',
        'COUNTRY_US' => '美国',
        'COUNTRY_UM' => '美属外岛',
        'COUNTRY_UY' => '乌拉圭',
        'COUNTRY_UZ' => '乌兹别克斯坦',
        'COUNTRY_VU' => '瓦努阿图',
        'COUNTRY_VA' => '梵蒂冈',
        'COUNTRY_VE' => '委内瑞拉',
        'COUNTRY_VN' => '越南',
        'COUNTRY_VG' => '英属维尔京群岛',
        'COUNTRY_VI' => '美属维尔京群岛',
        'COUNTRY_WF' => '瓦利斯和富图纳',
        'COUNTRY_EH' => '西撒哈拉',
        'COUNTRY_YE' => '也门',
        'COUNTRY_ZM' => '赞比亚',
        'COUNTRY_ZW' => '津巴布韦',
        'ERROR_LOG' => '错误日志',
        'CANNOT_READ_ERROR_LOG' => '无法阅读错误日志',
        'CANNOT_OPEN_ERROR_LOG' => '无法打开错误日志',
        'CANNOT_SCAN_ERROR_LOG' => '无法扫描错误日志',
        'MODELS_RESET' => 'Models reset:',
        'NO_MODELS_RESET' => 'No models reset.',
        'NO_FEED_TO_DISPLAY' => '您现在没有显示任何Feed。',
        'BOX_WILL_NOT_SHOW_FEED' => '只有当您选中至少一个Feed, 其他人才能看得见该框。',
        'CLICK_EDIT_TO_SPECIFY_FEED' => '请点击 "编辑" 来制定该框的 RSS 输入。',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => '无法取得该 RSS 输入。',
        'MORE_ELLIPSIS' => '更多...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => '对不起, 这个网络出了点错。',
        'PLEASE_TRY_REFRESHING' => '请30秒后刷新本页. 如果您又得到了这个消息<a %s>请通知我们<a/>。',
        'NO_DISCUSSIONS_TAGGED_X' => '没有被标签 "%1$s" 的讨论。',
        'PAGE_TITLE_COLON' => '页面标题：',
        'PAGE_CONTENT' => '内容：',
        'CREATE_PAGE' => '创建页面',
        'CREATE_NEW_PAGE' => '创建一个新页面',
        'YOUR_COMMENT' => '您的评论',
        'ADD_YOUR_COMMENT' => '添加您的评论',
        'DELETE_PAGE' => '删除此页',
        'DELETE_THIS_PAGE_Q' => '删除此页？',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => '您确定您要删除此页（包括所有的评论）？该过程可能会需要好几分钟。',
        'SEARCH_PAGES' => '搜索页面',
        'ALL_PAGES' => '全部页面',
        'SUBSCRIBE_TO_PAGES' => '订阅这些页面',
        'NOBODY_HAS_ADDED_PAGES' => '还没人添加任何页面。',
        'ADD_PAGES_CALL_TO_ACTION' => '开始创建新页面。',
        'CREATE_A_PAGE' => '创建一个新页面',
        'PLEASE_ENTER_PAGE_CONTENT' => '请输入该页面的内容',
        'SEARCH_RESULTS_FOR_X' => '<em>%s</em> 的搜索结果',
        'EDIT_YOUR_PAGE' => '编辑您的页面',
        'UPDATE_PAGE' => '更新页面',
        'CLOSE_DISCUSSION' => '关闭讨论',
        'REOPEN_DISCUSSION' => '重开讨论',
        'CLOSING_DISCUSSION_PREVENTS' => '关闭讨论将停止接受任何回复',
        'NO_DISCUSSION_TO_DISPLAY' => '您现在没有显示任何讨论。',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => '只有当您选中至少一个讨论, 其他人才能看得见该框。',
        'NEWEST_DISCUSSIONS' => '最新的讨论',
        'LATEST_REPLIES' => '最近回复的',
        'REPLIES_CLOSED_FOR_DISCUSSION' => '该讨论不再接受任何回复。',
        'SORRY_DISCUSSION_CLOSED' => '对不起, 该讨论不再接受任何回复。',
        'MOST_REPLIES' => '最多回复的',
        'OWNER_DISCUSSIONS_ONLY' => '只有网络创建者的讨论',
        'MY_DISCUSSIONS_ONLY' => '只有我的讨论',
        'DISCUSSION_DELETED' => '讨论已被删除',
        'DISCUSSION_HAS_BEEN_DELETED' => '该讨论已被删除。',
        'REPLY_DELETED' => '回复已被删除',
        'REPLY_HAS_BEEN_DELETED' => '该回复已被删除。 <a %s>回到讨论.</a>',
        'VIEW_ALL_DISCUSSIONS' => '浏览全部讨论',
        'ADD_CATEGORIES' => '添加类别',
        'CATEGORY' => '类别：',
        'NO_DISCUSSIONS_IN_CATEGORY' => '该类别还没任何讨论。',
        'ADD_MANAGE_CATEGORIES' => '添加/管理类别',
        'VIEW_ALL_N_CATEGORIES' => '查看所有 %s 类别',
        'UNTITLED_CATEGORY' => '无题类别',
        'SAMPLE_TITLE' => '样本标题',
        'UNCATEGORIZED' => '无类别的',
        'EXISTING_DISCUSSIONS' => '还未被分类的讨论。',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => '这里还没有任何类别.  现在就添加一个吧！',
        'ADD_A_CATEGORY' => '添加类别',
        'ADD_ANOTHER_CATEGORY' => '添加另一个类别',
        'MANAGE_CATEGORIES' => '管理类别',
        'CATEGORY_TITLE' => '类别标题',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => '允许成员在该类别里添加讨论',
        'ONLY_I_CAN_START_DISCUSSIONS' => '只有我能在该类别里添加讨论',
        'ALLOW_MEMBERS_TO_REPLY' => '只有成员能回复',
        'SUGGESTIONS' => '建议：',
        'TRY_DIFFERENT_KEYWORDS' => '试试别的或较笼统的关键字',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>浏览全部讨论</a> 或 <a %s>开始新的讨论</a>',
        'MAKE_SURE_WORDS_SPELLED' => '请确定所有的字都拼对了',
        'REPLY_WAS_DELETED' => '该回复已被删除',
        'TAGS_X' => '<strong>标签:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => '发送消息',
        'PERMALINK_TO_REPLY' => '永久链接到该回复',
        'PERMALINK' => '永久链接',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => '对不起 - 我们无法找到符合您搜索的讨论。',
        'DISCUSSIONS_MATCHING_X' => '符合<em>"%s"</em>的讨论',
        'SEARCH_DISCUSSIONS' => '搜索讨论',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => '您还未添加任何讨论',
        'ADD_DISCUSSIONS_AND_SHARE' => '添加讨论, 并和你的朋友，家人或者其他人分享！',
        'DISCUSSION' => '讨论',
        'DISCUSSIONS' => '讨论',
        'KEEP_PAGE_OPEN_FORUM' => '在上传文件时请不要关闭该浏览窗口。',
        'MEANWHILE_FEEL_FREE_FORUM' => '在此同时, 您可<a %s>另开一个窗口</a>继续浏览 %s。',
        'START_A_NEW_DISCUSSION' => '开始新讨论',
        'DISCUSSION_TITLE' => '讨论标题：',
        'FIRST_POST' => '帖子：',
        'UPLOAD_FILES' => '附加文件：',
        'START_DISCUSSION' => '开始讨论',
        'EDIT_DISCUSSION' => '编辑讨论',
        'START_A_DISCUSSION' => '开始一个讨论',
        'ALL_DISCUSSIONS' => '全部讨论',
        'CONTRIBUTORS' => '贡献者',
        'MY_DISCUSSIONS' => '我的讨论',
        'READ_MORE' => '阅读全文',
        'STARTED_T_BY' => '于<strong>%s</strong>开始, 来自：',
        'ADDED_BY_X_T' => '来自 %s %s',
        'STARTED_BY_X_T' => '由 %s %s 开始',
        'REPLY_BY_X_T' => '<strong>%s</strong>在%s回复',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => '由 %s开始讨论.  最后<a %s>回复</a>是由%s在%s送交。',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>开始该讨论。</strong> 最后<a %s>回复</a>是由 %s %s。',
        'STARTED_DISCUSSION_T' => '<strong>开始该讨论</strong>',
        'ADDED_REPLY_T' => '<strong>添加回复</strong> %s',
        'ADDED_POST_T' => '<strong>添加帖子</strong> %s',
        'STARTED_BY_X_ON' => '由 %s 开始, 在 %s',
        'STARTED_DISCUSSION_ON' => '<strong>开始该讨论</strong>',
        'STARTED_ON' => '<strong>开始</strong> %s',
        'ADDED_REPLY_ON' => '<strong>添加回复</strong> %s',
        'ADDED_POST_ON' => '<strong>添加帖子</strong> %s',
        'XS_DISCUSSIONS' => '%s 的讨论',
        'XS_DISCUSSIONS_LOWERCASE' => '%s 的讨论',
        'VIEW_XS_DISCUSSIONS' => '浏览%s的讨论',
        'VIEW_YOUR_DISCUSSIONS' => '浏览您的讨论',
        'TAGGED_X' => '标签： %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => '订阅这些讨论',
        'SUBSCRIBE_TO_DISCUSSION' => '订阅这个讨论',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => '订阅 %s 的讨论',
        'ALL_DISCUSSIONS_TAGGED_X' => '全部标签为 <em>"%s"</em> 的讨论',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => '订阅标签为 "%s" 的讨论',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => '上传文件',
        'ATTACHMENTS' => '附加文件',
        'YOUR_POST' => '您的帖子：',
        'YOUR_REPLY' => '您的回复：',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => '您要上传文件吗？',
        'ADD_YOUR_REPLY' => '添加您的回复',
        'REPLIES_TO_THIS_DISCUSSION' => '该讨论的回复',
        'POSTED_BY_X_ON' => '%s %s 发表的',
        'PLEASE_ENTER_TITLE' => '请输入该讨论的标题',
        'PLEASE_ENTER_FIRST_POST' => '请写您第一个讨论帖子。',
        'REPLY_TO_THIS' => '回复',
        'DELETE_ATTACHMENT' => '删除附加文件',
        'DELETE_ATTACHMENT_Q' => '删除该附加文件？',
        'DELETE_REPLY' => '删除回复',
        'DELETE_THIS_DISCUSSION_Q' => '删除该讨论？',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => '您确定您要删除这个讨论及全部回复？ 该过程可能会需要好几分钟。',
        'DELETE_DISCUSSION' => '删除该讨论',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => '还没人添加任何讨论。',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => '还没人添加任何讨论！ 您现在就加第一条吧。',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => '您还没开始任何讨论.。现在就加一条吧。',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => '您还没开始任何讨论。',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => '您还没开始任何讨论。',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s 还没添加任何讨论。',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s 还没开始任何讨论。',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s 还没参与任何讨论。',
        'VIEW_DISCUSSIONS' => '浏览讨论',
        'VIEW_ALL_PEOPLE_ON_X' => '浏览全部在 %s 的人员',
        'THERE_ARE_NO_DISCUSSIONS' => '您的网络现在还没任何讨论。',
        'GROUP_HAS_NO_DISCUSSIONS' => '该网络现在还没任何讨论。',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => '浏览全部在 <a %s>%s 论坛 </a>上的讨论。',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => '没有任何标签为 "%1$s" 的讨论。 您可以看看标签为<a %2$s>"%1$s"的照片</a>, 或标签为<a %3$s>"%1$s"的视频</a>, 或添加您自己的讨论并加标签。',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => '没有任何标签为 "%1$s" 的讨论。  您可以看看标签为<a %2$s>"%1$s"的照片</a>, 或标签为<a %3$s>"%1$s"的视频</a>。',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => '这里至少要有一个讨论其他人才能看得见该视频框。现在就添加一个吧！',
        'DISCUSSIONS_I_STARTED' => '我开始的讨论',
        'DISCUSSIONS_X_STARTED' => '%s开始的讨论',
        'DISCUSSIONS_I_REPLIED_TO' => '我回复的讨论',
        'DISCUSSIONS_X_REPLIED_TO' => '%s回复的讨论',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => '请填写您的帖子。',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => '请填写您的回复。',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => '您的讨论 "%s"（在 %s 上）有新的评论',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => '您在 %s 上有个讨论有新的评论',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => '有人评论了您在 %s 上开始的讨论',
        'ABOUT_YOUR_DISCUSSION' => '关于您的讨论',
        'ABOUT_THIS_DISCUSSION' => '关于该讨论',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s回复了在%s上的一个讨论',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%1$s回复了%3$s上标题为"%2$s"的讨论',
        'PROBLEM_WITH_ICON' => '您的图标文件有问题',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => '小组管理者有和小组创建者相同级别的管理权。',
        'CREATE_NEW_GROUP' => '创建新小组',
        'CREATE_A_NEW_GROUP' => '创建一个新小组',
        'CREATE_A_GROUP' => '创建一个小组',
        'VIEW_GROUPS' => '浏览小组',
        'CREATE_GROUP' => '创建小组',
        'PLEASE_ENTER_NAME_FOR_GROUP' => '请给您的小组取名。',
        'PLEASE_ENTER_URL_FOR_GROUP' => '请给您的小组选择网址。',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => '网址只能有字母和数字（无空格）。',
        'NAME_TAKEN' => '很抱歉，该名称已被使用。请另取一个名称。',
        'URL_TAKEN' => '很抱歉，该网址已被使用。请另择网址。',
        'GROUP_INFORMATION' => '小组信息',
        'EXTERNAL_WEBSITE' => '其他网站',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => '您的小组是否有其他网站？',
        'URL' => 'URL',
        'GROUPS' => '小组',
        'SEARCH_GROUPS' => '搜索小组',
        'NOBODY_HAS_CREATED_GROUPS' => '还没人创建任何小组。',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => '还没人创建任何小组。 您现在就创建一个吧。',
        'MY_GROUPS' => '我的小组',
        'FEATURED_GROUPS' => '被推荐的小组',
        'YOU_CAN_CREATE_GROUP' => '您可<a %s>创建新的小组</a>（在 %s 上）!',
        'GROUP_FORUM' => '%s 论坛',
        'USER_CREATED_GROUP' => '%s 创建了该小组（在 %s 上）。',
        'GROUP_MEMBERS_COUNT' => '%s 成员（%d）',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => '抱歉, 您没被允许加入该小组。',
        'JOIN_GROUP_NOW' => '现在就加入%s!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s 邀请您加入 %s',
        'DECLINE' => '拒绝',
        'WELCOME_TO_GROUP' => '欢迎来到%s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => '您可以参与 %s 的论坛。',
        'SEND_MESSAGE_TO_GROUP' => '给小组发送消息',
        'LEAVE_THIS_GROUP' => '离开小组',
        'EDIT_GROUP_INFO' => '编辑该小组的信息',
        'EDIT_GROUP_INFORMATION' => '编辑小组信息',
        'MANAGE_GROUP_MEMBERS' => '管理小组成员',
        'GROUP_HAS_NO_MEMBERS' => '该小组还没有任何成员！',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => '该小组没有符合您搜索条件的成员。',
        'USERS_GROUPS' => '%s的小组',
        'YOU_HAVE_NOT_CREATED_GROUPS' => '您还没创建任何小组。',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s 还没创建任何小组。',
        'THERE_ARE_NO_FEATURED_GROUPS' => '您的社交网络没有任何推荐的小组。',
        'START_FEATURING_GROUPS' => '当您看到"推荐"这个选项时, 您可以推荐该小组 。想要知道更多关于"推荐", 请<a %s>点击这里</a>。',
        'NO_GROUPS_TO_DISPLAY' => '您现在没显示任何小组。',
        'BOX_WILL_NOT_SHOW_GROUPS' => '只有当您选中至少一个小组, 其他人才能看得见该框。',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => '您还未创建任何小组！',
        'CREATE_GROUPS_AND_SHARE' => '添加小组，并和你的朋友，家人或者其他人分享！',
        'THERE_ARE_NO_GROUPS' => '您网络现在还没有小组。',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => '这里至少要有一个小组，其他人才能看得见该框。 现在就创建一个小组吧。',
        'GROUPS_MATCHING_SEARCH_TERM' => '符合 <em>"%s"</em> 的小组',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => '抱歉 - 我们没有符合您搜索要求的小组。',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>浏览全部小组</a> 或 <a %s>创建新小组p</a>',
        'VIEW_ALL_GROUPS' => '浏览全部小组',
        'DELETE_GROUP' => '删除该小组',
        'DELETE_GROUP_Q' => '您确定要删除该小组？',
        'GROUP_INVITATIONS' => '小组邀请函',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => '您被邀请加入：',
        'VISIT' => '访问',
        'WHO_CAN_JOIN_GROUP' => '谁可加入该小组？',
        'PRIVACY_CANNOT_BE_CHANGED' => '小组创建后, 不能更改隐私设定。',
        'ONLY_INVITED_PEOPLE' => '只有被邀请的人员',
        'ALLOW_PEOPLE_TO_REQUEST' => '允许访问者请求邀请函',
        'ANYONE_CAN_JOIN_GROUP' => '任何人都可加入该小组',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => '只有被邀请的成员才能加入该小组',
        'WHY_NOT_CREATE_GROUP' => '为何不<a %s>创建您自己的小组</a>？',
        'PLEASE_ENTER_NAME' => '请输入您的名字',
        'PLEASE_ENTER_EMAIL_ADDRESS' => '请输入您的电子邮件地址。',
        'PLEASE_ENTER_PAGE_ADDRESS' => '请输入一个新的页面地址。',
        'PLEASE_ENTER_PASSWORD' => '请输入您的密码。',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>点击这里创建一个新帐户</a> 或用您的Ning ID登陆。',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>点击这里创建一个新帐户</a> 或用您的Ning ID加入。',
        'CHOOSE_SHORTER_PASSWORD' => '请选个短点的密码。',
        'CHOOSE_SHORTER_NAME' => '请选个短点的名字。',
        'ENTER_SHORTER_CITY_NAME' => '请输入短点的城市名字。',
        'PLEASE_ENTER_PASSWORD_AGAIN' => '请将您的密码在"重新输入密码"栏里再输一遍。',
        'PLEASE_ENTER_CURRENT_PASSWORD' => '请输入您现在的密码。',
        'PLEASE_ENTER_NEW_PASSWORD' => '请输入您的密码。',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => '请将您的密码在"确认新密码"栏里再输一遍。',
        'CURRENT_PASSWORD' => '现在的密码',
        'PASSWORDS_DO_NOT_MATCH' => '这两个密码不符合。',
        'NEW_AND_CONFIRMATION_PASSWORDS' => '您的新密码和确认新密码不符合。',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => '已发送您的请求给小组创建者。',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s 不是有效邮件地址',
        'COME_JOIN_ME_ON_GROUP' => '和我一起加入%s！',
        'INVITE_PEOPLE_TO_GROUP' => '邀请朋友加入 %s',
        'INVITE_FRIENDS_TO_GROUP' => '邀请朋友到 %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => '邀请别人加入 %s。',
        'GROUPNAME_MEMBERS' => '%s 的成员',
        'GROUP_CREATOR' => '小组创建者',
        'GROUP_ADMINISTRATOR' => '小组管理者',
        'DATE_BANNED' => '被禁止的日期',
        'BAN_FROM_GROUP' => '从该小组里禁止',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => '您确定您要禁止这几位成员访问您的小组？ 该过程可能会需要好几分钟。',
        'ALSO_DELETE_FORUM_POSTINGS' => '并删除他们的论坛帖子及回复。',
        'GROUP_WEB_ADDRESS' => '小组网址',
        'GROUP' => '小组',
        'BACK_TO_GROUP' => '← 返回 %s',
        'USER_BANNED_FROM_GROUP' => '%1$s 已被禁止访问该小组。 <a %2$s>给 %1$s 发个消息</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s 已是该小组成员。 <a %2$s>给 %1$s 发个消息</a>',
        'GROUP_ADMIN_DISCUSSIONS' => '小组管理讨论',
        'BACK_TO_NETWORK_GROUPS' => '返回 %s 的小组',
        'MOST_MEMBERS' => '最多成员的',
        'THIS_SETS_URL_OF_GROUP' => '这是您小组的 URL：<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => '喜欢%s的内容吗? 来加入我们吧!',
        'LIKE_WHAT_YOU_SEE_GROUP' => '喜欢%s的内容吗? 来加入我们吧!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => '您创建了个小组: %s。  您可在 %1$s 论坛上开始一个讨论, 或邀请更多朋友加入。',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => '您现在已是 %1$s 的成员。 您可参与 %1$s 论坛上的讨论, 或邀请更多朋友加入。',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => '该网络还没有任何音乐。',
        'PERSON_DOES_NOT_HAVE_MUSIC' => '该成员还没有任何音乐。',
        'FIND_MORE_MUSIC_LIKE_THIS' => '在 <em>%s</em> 上面找更多和这个类似的音乐。',
        'TRACKS' => 'Tracks',
        'ADD_MUSIC_TRACKS' => '添加音乐',
        'CHOOSE_MUSIC_TRACKS' => '选择添加的歌曲',
        'YOU_CAN_ADD_UP_TO_MP3' => '您一次可添加最多4个MP3。',
        'UPLOAD_TRACKS' => '上传歌曲',
        'ADD_TRACKS' => '添加歌曲',
        'ENTER_THE_URL_MP3_TO_ADD' => '输入您想添加的MP3的URL：',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => '您可以上传最多100个 MP3！每个 MP3 不能超过20MB。 文件越小,上传速度越快。',
        'BE_NICE' => '别做傻事',
        'PLEASE_UPLOAD_ONLY_TRACKS' => '请您只上传您有版权, 或得到艺术家或版权持有者许可的歌曲。',
        'PLEASE_LINK_ONLY_TRACKS' => '请您只链接到已被授权可在网上发表的的音乐。',
        'MORE_WAY_TO_ADD_MUSIC' => '更多添加音乐的方法...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '...从别的网站',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => '只需粘贴链接到您的MP3就可通过任何网站添加音乐。',
        'KEEP_PAGE_OPEN_MUSIC' => '在歌曲上传时请不要关闭该浏览窗口。 歌曲被批准后候我们会通知你！',
        'MEANWHILE_FEEL_FREE_MUSIC' => '在此同时, 您可<a %s>另开一个窗口</a>继续浏览%s。上传结束后, 您可以为歌曲添加标题和描述。',
        'TRACKS_EXCEEDED_LIMIT' => '歌曲超过了每首10MB的限制。',
        'EDIT_TRACK_INFORMATION' => '编辑歌曲信息',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => '给刚上传的歌曲添加一个标题，描述和其他信息。',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => '给这首歌添加一个标题，描述和其他信息。',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« 取消并返回播放列表',
        'TRACK_TITLE' => '歌曲标题',
        'TRACK_ARTIST' => '歌手',
        'TRACK_ALBUM' => '专辑',
        'ENABLE_DOWNLOAD_LINK' => '开启下载链接',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => '允许大家将该歌曲放入他们的页面',
        'TRACK_ARTWORK' => '艺术作品',
        'EDIT_PLAYLIST' => '编辑播放列表',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => '您可以随意调整歌曲的顺序 - 先点击歌曲, 再拖放到您想要的地方。',
        'ADD_MUSIC_ELLIPSIS' => '添加音乐...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '...通过您的电脑',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => '从电脑上传MP3。',
        'DELETE_THIS_TRACK_Q' => '删除这首歌曲？',
        'DELETE_TRACK' => '删除歌曲',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => '您将要删除这首歌曲, 您确定么？',
        'PLAY' => '播放',
        'GENRE' => '风格',
        'YEAR' => '年份',
        'LABEL' => '唱片公司',
        'EXPLICIT_LYRICS' => '限制级歌词',
        'ARTIST_SITE' => '歌手网站',
        'HOSTING_SITE' => '寄存网站',
        'LABEL_SITE' => '唱片公司',
        'LICENSE' => '授权',
        'SELECT_LICENSE' => '— 选择授权 —',
        'LICENSE_NAME' => '授权名称',
        'LICENSE_URL' => '授权URL',
        'MUSIC' => '音乐',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => '(Music) 允许成员上传及分享音乐',
        'PLAYLIST' => '播放列表',
        'PODCAST' => '有声博客（Podcast）',
        'MOST_RECENT_TRACKS' => '最新的',
        'FEATURED_TRACKS' => '推荐的',
        'HIGHEST_RATED_TRACKS' => '最高评分的',
        'NO_TRACKS_TO_PLAY' => '您的网络还没有音乐。',
        'BOX_WILL_NOT_SHOW_TRACKS' => '这里至少要有一首歌曲或podcast其他人才能看得见该框。 现在就添加一个吧。',
        'NO_TRACKS_ON_PLAYLIST' => '您的播放列表没有歌曲。',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => '这里至少要有一首歌曲或播客才会显示播放器。  现在就添加一个吧。',
        'NO_FEATURED_TRACKS' => '您网络上还没有被推荐的歌。',
        'START_FEATURING_TRACKS' => '当您听到您喜欢的歌时, 您可以推荐它到首页。',
        'VIEW_MUSICPLAYER' => '浏览音乐播放器',
        'MY_PLAYLIST' => '我的播放列表',
        'NETWORK_PLAYLIST' => '网络上的播放列表',
        'COPYRIGHT' => '©保留所有权利',
        'CC_BY_X' => '创作共用－署名：%s',
        'CC_BY_SA_X' => '创作共用－署名－保持一致%s',
        'CC_BY_ND_X' => '创作共用－署名－非派生作品：%s',
        'CC_BY_NC_X' => '创作共用－署名－非商业用途：%s',
        'CC_BY_NC_SA_X' => '创作共用—署名－非商业用途－保持一致：%s',
        'CC_BY_NC_ND_X' => '创作共用－署名－非商业用途－非派生作品：%s',
        'PUBLICDOMAIN' => '公共领域',
        'FACEBOOK_CONFIRM_DISABLE' => '您确定？',
        'FACEBOOK_PLAYER_DISABLE' => '关闭',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => '音乐播放器',
        'FACEBOOK_MUSIC_PLAYER_DESC' => '允许任何人在他们的Facebook简介页面上添加可播放您选择的音乐的应用程序。',
        'FACEBOOK_MUSIC_BUTTON' => '创建音乐播放应用程序 &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => '已开启 Facebook 音乐播放器。',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => '视频播放器',
        'FACEBOOK_VIDEO_PLAYER_DESC' => '允许任何人在他们的Facebook简介页面上添加可播放您选择的视频的应用程序。',
        'FACEBOOK_VIDEO_BUTTON' => '创建视频播放应用程序 &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => '已开启 Facebook 视频播放器。',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => '照片幻灯片',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => '允许任何人在他们的Facebook简介页面上添加可播放您选择的照片的应用程序。',
        'FACEBOOK_SLIDESHOW_BUTTON' => '创建照片幻灯片应用程序&raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => '已开启 Facebook 照片播放器。',
        'FACEBOOK_PLATFORM_LOGO' => 'Facebook 平台标志',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, 一个热门的社交网络, 允许第三方开发者创建一些可加在 Facebook 成员简介页面上的应用程序。 这些应用程序不仅可增加简介页面的功能, 也可将 Fabook 的用户带到其他网站。',
        'FACEBOOK_QUICK_INTRO_2' => '通过 Ning, 您不必是开发者。  我们已经为您建造好了基础, 您的网络已有了和 Facebook 应用程序集成的功能。 您只要从以下选择您要的选项, 您的社交网络马上就可与Facebook集成。',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => '添加开发者按钮',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => '安装新应用程序按钮',
        'FACEBOOK_YOUR_APPLICATIONS' => '您的 Facebook 应用程序',
        'FACEBOOK_EMBEDDING' => 'Facebook网站推广',
        'FACEBOOK_SETUP' => 'Facebook网站推广',
        'FACEBOOK_PROMOTING' => '在 Facebook 上推广应用程序',
        'FACEBOOK_VIEW_APP' => '查看应用程序',
        'FACEBOOK_ADD_THE' => '添加',
        'FACEBOOK_RECENT' => '最新的',
        'FACEBOOK_RECENTLY_FEATURED' => '最新推荐的',
        'FACEBOOK_RECENTLY_ADDED' => '最新添加的',
        'FACEBOOK_PROMOTED' => '推荐的',
        'FACEBOOK_RATED' => '最高评分的',
        'FACEBOOK_POPULAR' => '最有人气的',
        'FACEBOOK_MUSIC_WIDGET' => '音乐小工具',
        'FACEBOOK_VIDEO_WIDGET' => '视频小工具',
        'FACEBOOK_PHOTO_WIDGET' => '照片小工具',
        'FACEBOOK_INSTR_FIRST_STEPS' => '第一步',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => '点击这里到 Facebook 并创建您的应用程序。',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => '这将在另一窗口打开 Facebook。 您若还没登录 Facebook, 可在此登录。',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => '如果您在 Facebook 上还没创建应用程序, 您会被要求添加 Facebook 开发者应用程序。 当您看到 "You have no applications"（您还没有应用程序）时, 请点击<strong>Create one</strong>（创建）。',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => '如果您在 Facebook 上已有应用程序, 您将会到达 Facebook 开发者应用程序页面。请点击<strong>Set Up New Application</strong>（安装新应用程序）。',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => '下一步：如何安装您 %s 应用程序使其在 Facebook 上运作。',
        'FACEBOOK_INSTR_SETUP' => '安装说明',
        'FACEBOOK_INSTR_SETUP_1' => 'Facebook 需要知道您应用程序的一些信息。 请按照以下这几个简单步骤来做！',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => '必填项',
        'FACEBOOK_INSTR_SETUP_2' => '选择 <strong>应用程序名称</strong>。',
        'FACEBOOK_INSTR_SETUP_3' => '选中该接受框表示您已读过 Facebook 的用户协议。',
        'FACEBOOK_INSTR_SETUP_4' => '打开 <em>Optional Fields</em>（可选项）部分。',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => '基本项',
        'FACEBOOK_INSTR_SETUP_5' => '在<strong>Support E-Mail</strong>（支持邮件）里输入您邮件地址。',
        'FACEBOOK_INSTR_SETUP_6' => '粘贴以下网址到"Callback URL"(回叫URL)里：',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => '选个<strong>Canvas Page URL</strong>(帆布页面URL),比如<em>%s</em>。',
        'FACEBOOK_INSTR_SETUP_8' => '在"<em>Can your application be added on Facebook</em>（是否在 Facebook 上添加您的应用程序）"这项选<strong>Yes</strong>（是）。',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => '安装选项',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => '填写<strong>应用程序描述</strong>。',
        'FACEBOOK_INSTR_SETUP_9' => '粘贴以下代码到<strong>Default FBML</strong>(默认FBML)里',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => '在 <strong>Default Profile Box Column</strong>(默认简介框列), 选<strong>Wide</strong>（宽）。',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => '在 <strong>Default Profile Box Column</strong>(默认简介框列), 选<strong>Narrow</strong>（窄）。',
        'FACEBOOK_INSTR_SETUP_10' => '在 <strong>Side Nav URL</strong>(侧边导航URL)里, 输入您的<em>Canvas Page URL</em>（上面&#8216;f&#8217;步)。请确定有包括 URL 的 http://apps.facebook.com/ 部分。',
        'FACEBOOK_INSTR_SETUP_11' => '填写 <strong>Attachment action</strong> 这项。 如果您想在Facebook上发送消息给其他人并包括您的一个应用程序, 这将是被显示出来的内容。  如果您的应用程序是照片幻灯片, 您可输入 "某某网络的照片"。 如果您的应用程序是视频, 您可输入 "某某网络的视频"。',
        'FACEBOOK_INSTR_SETUP_12' => '粘贴以下网址到"Callback URL"(回叫URL)里：',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Facebook 应用程序安装',
        'FACEBOOK_INSTR_SETUP_DONE' => '当您完成后, 请按<strong>Submit</strong>(提交)按钮。',
        'FACEBOOK_INSTR_SETUP_NEXT' => '下一步：获取您的API键与密钥。',
        'FACEBOOK_API_INFO_TITLE' => 'Facebook API 信息',
        'FACEBOOK_API_INFO_DESC' => '请输入您的API键, 密钥, 及应用程序URL。',
        'FACEBOOK_API_INFO_FIND_KEY' => '您可在 <a %s>Facebook "My Applications" (我的应用程序) 页面</a>上(点击该链接将会开启新窗口), 在应用程序标题下找到您的API键和密钥。',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => '"我的应用程序"页面（突出API信息的位置）',
        'FACEBOOK_API_INFO_KEY' => 'API 键',
        'FACEBOOK_API_INFO_SECRET' => 'API 密钥',
        'FACEBOOK_URL_INFO_TITLE' => 'Facebook 应用程序 URL',
        'FACEBOOK_URL_INFO_DESC' => '应用程序URL就是<strong>Canvas Page URL</strong>(帆布页面URL)（您在上页&#8216;f&#8217;步所设定的）。',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Facebook音乐应用程序播放：',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Facebook视频应用程序播放：',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Facebook视照片应用程序播放：',
        'FACEBOOK_PROMOTING_ON' => 'Facebook上的推广',
        'FACEBOOK_SETUP_INSTR' => '安装说明',
        'FACEBOOK_API_INFO' => 'API 信息',
        'FACEBOOK_DISABLE' => '关闭该应用程序',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => '到您的Facebook简介页面上',
        'FACEBOOK_BACK_TO_EMBEDDING' => '返回到Facebook上的推广',
        'FACEBOOK_EMBEDDING_DESC' => '允许 Facebook 用户把您网络的小工具及徽章放在他们的简介页面上。',
        'FACEBOOK_PROMOTE' => '如何最有效推广您的应用程序？ 我们建议您采取以下几个步骤。  您可通过 Facebook 的 “<strong><a %s>My Applications</a></strong>”（我的应用程序）页面访问这些选项 (点击该链接将会开启新窗口)。',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => '提供一个 "关于" 的页面',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => '给您的应用程序提供一个清楚的描述, 向Facebook用户介绍您的应用程序。 请点击您要修改应用程序的"<strong>Edit About Page</strong>" (编辑关于页面)的链接,进行编辑。',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => '提交应用程序至 Facebook 目录',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => '广而告知 - 将您新的应用程序添加在 Facebook 目录里。',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => '点击您在修改的应用程序旁, "<strong>Submit Application</strong>"(提交应用程序)的链接来提交您的应用程序。  在下面一页, 您还可以编辑应用程序描述, 并添加应用程序标志。',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => '添加该应用程序到您 Facebook 的简介页面',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => '展现您的应用程序！将您的应用程序加入您 Facebook 的简介页面, 您的朋友也会跟着您一样做。',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => '请点击您要添加的应用程序旁, "<strong>View About Page</strong>"(浏览关于页面) 的链接, 然后在下一页点击 "Add Application"(添加应用程序)按钮。',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => '您的应用程序现已显示在您 Facebook 简介页面的最下面。',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => '我在 Facebook 上的应用程序页面',
        'FACEBOOK_MY_APPS' => '我的应用程序',
        'FORUM_TAB_TEXT' => '论坛',
        'VIDEOS_TAB_TEXT' => '视频',
        'PHOTOS_TAB_TEXT' => '照片',
        'GROUPS_TAB_TEXT' => '小组',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => '由于转换出错，未能将您的视频上传到 %s。',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => '要想获得解决问题的帮助，请提供此视频 ID： %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => '您的视频已被成功地上传到 %s。',
        'TO_VIEW_THE_VIDEO_VISIT' => '要查看视频，请访问：',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => '您在 %2$s 上的视频 "%1$s" 有一条新评论。',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => '您在 %s 上的视频有一条新评论。',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => '您在 %2$s 上的照片 "%1$s"有一条新评论。',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => '您在 %s 上的照片有一条新评论。',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => '您在 %2$s 上有一个新的 %1$s 有待批准…',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => '您在 %2$s 上有一个新的 %1$s 有待批准。',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => '您在 %3$s 上有一个新的 %1$s "%2$s" 有待批准。',
        'TO_APPROVE_THIS_X_VISIT' => '要批准这个%s，请访问：',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => '您在 %2$s上 的 %1$s 已获得批准…',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => '您在 %2$s 上的 %1$s 有一条新评论…',
        'CLICK_HERE_TO_JOIN' => '点击这里来加入:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s 邀请您看看 %3$s 上的 "%2$s"！',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => '您在 %s 上的 %s 已获得批准。',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => '您在 %3$s 上的 %1$s "%2$s" 已获得批准。',
        'TO_VIEW_YOUR_X_VISIT' => '要查看您的 %s，请访问：',
        'TO_VIEW_THIS_X_VISIT' => '要查看该 %s，请访问：',
        'TO_VIEW_IT_VISIT' => '要查看它，请访问：',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s报告了%2$s上的以下问题…',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s 在 %2$s 上发给您一个消息。',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s 申请加入在 %3$s 上的 %2$s。',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => '要批准或否决%s的申请，请访问：',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s 对在 %3$s 上的博客帖子 "%2$s" 增添了一条评论。',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s 对在 %2$s 上的博客帖子增添了一条评论…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => '您在 %s 上有一位新成员有待批准。',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => '欢迎光临在 %2$s 上的 "%1$s" 小组',
        'LOADING_YOUR_FRIENDS' => '我们正在加载您的朋友…',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => '您的消息已经发送',
        'TO_SEND_ANOTHER_MESSAGE' => '要发送另一则消息，请在下面输入文字。',
        'PLEASE_CHOOSE_FRIENDS' => '发送消息前，请选取一些朋友。',
        'THESE_FRIENDS' => '这些朋友：',
        'ALL_FRIENDS' => '所有朋友',
        'ALL_FRIENDS_ON_APPNAME' => '%s 上的所有朋友',
        'SHARE_WITH_FRIENDS' => '与朋友共享',
        'SHARE_THIS_WITH_FRIENDS' => '与您的朋友分享此物品',
        'COMPOSE_MESSAGE' => '撰写消息',
        'INVITATION_LINK_ONLY_VISIBLE' => '只有网络创建者和管理员能看到本邀请链接。加入本链接的成员将自动成为网络创建者的朋友。',
        'WE_ARE_LOADING_ADDRESSES' => '我们正在加载您的地址…',
        'SELECT_ALL_NONE' => '全选/全不选',
        'INVITE_TO_APPNAME' => '邀请到 \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => '邀请您的朋友到%s!',
        'ALREADY_MEMBER_OF_NETWORK' => '（已经是本网络的成员）',
        'OR_SHARE_THIS_INVITATION_LINK' => '或分享本邀请链接：',
        'CLICK_TO_MAIL' => '<a %s> 点击此处现在就发送邮件</a>。',
        'MESSAGE_HAS_BEEN_SENT' => '您的消息已经发送',
        'YOU_CAN_SHARE_THIS' => '您可以在下面与更多朋友分享，或 <a %s> 返回到前页 </a>。',
        'VCARD_IMPORT_UNAVAILABLE' => '很抱歉，目前没有 vCard 输入服务。',
        'CSV_IMPORT_UNAVAILABLE' => '很抱歉，目前没有 CSV 输入服务。',
        'ERROR_OCCURRED' => '很抱歉，出现了一个错误。',
        'IMPORT_FAILED' => '很抱歉，未能输入。',
        'LOGIN_FAILED' => '很抱歉，未能登录。',
        'UNABLE_TO_FIND_EMAIL' => '很抱歉，找不到电子邮件字段。',
        'CANNOT_READ_VCARDS' => '很抱歉，无法读取这些 vCard。',
        'NO_ADDRESSES_FOUND' => '没有找到地址',
        'WE_DID_NOT_FIND_ADDRESSES' => '我们在输入的地址簿中没有找到任何地址。',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => '从 Web 地址簿中输入',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => '从地址簿应用程序中输入',
        'PRIVACY_POLICY' => '隐私保护政策',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s 在 %2$s 上提供了以下反馈：',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => '看看在 %2$s 上的 "%1$s" …',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => '看看在 %2$s 上的这个 %1$s …',
        'SEND_MESSAGE_TO_FRIENDS' => '给朋友发送消息',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => '请为发送给所有朋友的消息通知挑一个有效的选择',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => '欢迎，%1$s！ 您是 %3$s 上的第 #%2$s 号成员。 <a %4$s> 现在可邀请朋友 </a>。',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => '您对照片 <a %s>%s</a> 做了评论',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s 对照片 <a %s>%s</a> 做了评论',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => '您对视频<a %s>%s</a>做了评论',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s 对视频 <a %s>%s</a> 做了评论',
        'THIS_IS_YOUR_PAGE' => '这是您的页面：',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => '发送给所有朋友的消息',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => '若想停止跟踪该 %s，请转到：',
        'CHOOSE_GADGETS' => '选择其中一个出色的 OpenSocial 小工具，添加到您的简介页面！ 您可以 <a %s> 在此查看小工具并给小工具评分</a>，或 <a %s> 在此了解有关 OpenSocial 的更多信息</a>。',
        'GADGETS_UNAVAILABLE' => '小工具暂时不可用',
        'APOLOGIES_GADGETS_UNAVAILABLE' => '抱歉，小工具暂时不可用。',
        'BOX_WILL_NOT_SHOW_GADGET' => '除非您选中一项小工具，否则其他人不会看到该框。',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => '请点击“编辑”来指定该框的小工具的 URL，或访问 <a %s> 小工具目录 </a>。',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => '无法取得该小工具的 URL 输入。',
        'ADD_GADGET_TO_YOUR_PAGE' => '将此小工具添加到您的简介',
        'GADGETS_BETA' => '小工具（试用版）',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => '尝试 OpenSocial 小工具。  警告： 此功能为试验性质。',
        'ADD_TO_MY_PAGE' => '添加到我的页面',
        'GADGETS' => '小工具',
        'GADGETS_TAB_TEXT' => '小工具',
        'GADGET' => '小工具',
        'GADGETS_IS_IN_BETA' => '小工具为测试版本。',
        'SORRY_GADGET_UNAVAILABLE' => '很抱歉，该小工具不可用。 请核对，确保 URL 正确无误。 如果您仍有问题， <a %s> 请告诉我们 </a>。',
        'ALREADY_MEMBER_OF_GROUP' => '（已经是本小组的成员）',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => '邀请您的朋友到%s!',
        'COME_JOIN_ME_ON_X_ON_Y' => '和我一起加入在 %2$s 上的 %1$s。',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => '和我一起加入在 %2$s 上的 %1$s…',
        'INVITE_TO_GROUP' => '邀请到 \'%s\'',

        'EACH_VIDEO_MAY_BE_100MB' => '每个视频最大可达100MB。我们支持.mov、.mp4、.mpg、.avi、.wmv和.3gp文件格式的视频。 ',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => '我有权根据<a %s>服务条款</a>上传这些视频。 ',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => '批量视频上传程序要求使用较新的Java版本。<strong><a %s>点击此处获取Java</a></strong>，或<strong><a %s>返回简单上传程序</a></strong>。 ',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => '从您的电脑上传视频 ',
        'HAVE_LOT_OF_VIDEOS' => '您有许多视频要分享？ ',
        'TRY_BULK_VIDEO_UPLOADER' => '请尝试批量视频上传程序 ',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => '您的视频已成功上传。 ',
        'VIDEOS_UPLOADED_AWAITING' => '您的视频已经成功上传，正在等待%s的创建人批准。 ',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => '如果要从手机直接将视频或照片添加到%s，可将其发送到一个独有的电子邮件地址。 ',
        'GRAB_HTML_EMBED' => '从任何热门视频网站抓取 HTML 内嵌代码 （\'embed\'）, 并将该视频添加到这个网络里。 ',
        'GOOGLE' => 'Google ',
        'YOUTUBE' => 'YouTube ',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => '使用批量视频上传程序有困难？  <strong><a %s>请返回我们的简单上传程序</a></strong>。 ',
        'ADD_VIDEOS_FROM_YOUTUBE' => '从YouTube或Google那儿添加视频 ',
        'TAGS_NO_COLON' => '标签 ',
        'NO_VIDEOS_TAGGED_X_CHECK' => '没有任何标签为"%1$s"的视频。您可以看看<a %2$s>标签为"%1$s"的讨论</a>, <a %4$s>标签为"%1$s"的博文</a>或<a %3$s> 标签为 "%1$s"的照片</a>。或添加您自己的视频并添加标签！ ',
        'UPLOAD_VIDEOS_FROM' => '从您的电脑上传视频 ',
        'ADD_VIDEOS_BY_PHONE_OR' => '通过手机或电子邮件添加视频 ',
        //music player
        'FEATURING_ELLIPSIS' => '推荐...',
        'OPEN_POPUP_WINDOW' => '打开弹出式窗口',
        'NOW_FEATURED_ON_MAIN' => '现在首页上推荐 ',
        'DONT_FEATURE' => '不要推荐 ',
        'UNFEATURING_ELLIPSIS' => '正从首页删除... ',
        'REMOVED_FROM_MAIN' => '已从首页删除 ',
        'ADDED_EXCLAMATION' => '已添加！ ',
        'ERROR' => '错误 ',
        'ADDING_ELLIPSIS' => '正在添加... ',
        'TRACK_COULD_NOT_BE_LOADED' => '不能加载歌曲 ',
        'INVALID_URL' => 'URL无效 ',
        'NORMAL_PLAYBACK_ON' => '正常播放： 打开 ',
        'REPEAT_PLAYBACK_ON' => '重复播放： 打开 ',
        'SHUFFLE_PLAYBACK_ON' => '无序播放： 打开 ',
        'LOADING_PLAYLIST_ELLIPSIS' => '正在加载播放清单... ',
        'CLICK_TO_SEE_MEMBER_DATA' => '您的成员数据已被输出。点击 <a %s>此链接</a>，将其保存到您的桌面上。 ',
        'SET_NEW_PASSWORD' => '为您的帐户设定一个新密码。 ',
        'CLICK_EDIT_TO_ADD_TEXT' => '点击 \'编辑\' 可在该框内添加文本、HTML、视频、照片或任何<a %1$s>第三方小工具</a>。 ',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => '每张照片最大可达10MB。我们支持.jpg、.gif和.png文件格式的照片。 ',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => '我有权根据<a %s>服务条款</a>上传这些照片。 ',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => '批量照片上传程序要求使用较新的Java版本。<strong><a %s>点击此处获取Java</a></strong>，或<strong><a %s>返回简单上传程序</a></strong>。 ',
        'TRY_BULK_PHOTO_UPLOADER' => '请尝试批量照片上传程序 ',
        'HAVE_LOT_OF_PHOTOS' => '您有许多照片要分享？ ',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => '您的照片已成功上传。 ',
        'PHOTOS_UPLOADED_AWAITING' => '您的照片已经成功上传，正在等待%s的创建者批准。 ',
        'FLICKR' => 'Flickr ',
        'ADD_PHOTOS_FROM_FLICKR' => '从Flickr添加照片 ',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => '如果要从手机直接将照片或视频添加到%s，可将其发送到一个独有的电子邮件地址。 ',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => '使用批量照片上传程序有困难？  <strong><a %s>请返回我们的简单上传程序</a></strong>。 ',
        'VIEW_SLIDESHOW' => '看幻灯片 ',
        'NO_PHOTOS_TAGGED_X_CHECK' => '没有任何标签为"%1$s"的照片。您可以看看<a %2$s>标签为"%1$s"的讨论</a>, <a %4$s>标签为"%1$s"的博文</a>或<a %3$s> 标签为 "%1$s"的视频</a>。或添加您自己的照片并添加标签！ ',
        'PHOTO_MAY_BE_10MB' => '每张照片最大可达10MB，但较小的照片上传较快。我们支持.jpg、.gif和.png文件格式的照片。 ',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => '从您的电脑上传照片 ',
        'CLICK_EDIT_TO_ADD_TEXT' => '点击 \' 编辑\' 可在该框内添加文本、HTML、视频、照片或任何<a %1$s>第三方小工具</a>。 ',
        'PLEASE_SELECT_A_MEMBER' => '请选取一个或多个成员 ',
        'RESEND_INVITATION' => '重发邀请 ',
        'CHOOSE_FRIENDS' => '选择朋友... ',
        'SORRY_WE_DO_NOT_SUPPORT' => '很抱歉，您的电邮地址的web通讯簿不符合我们的使用规则。请试着点击下面的 \'从地址簿应用程序中输入\' ，以便使用您计算机中的地址。 ',
        'WANT_TO_INVITE_MORE_FRIENDS' => '想要邀请更多的朋友？输入您的网站通讯簿或电邮应用程序中的联系人名单，就可以邀请更多的朋友。 ',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook，Apple Mail，.CSV等。 ',
        'SET_NEW_PASSWORD' => '为您的帐户设定一个新密码。 ',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => ' 立即申请加入。您已是成员了吗？ <a %s> 请点击这里登录</a>。 ',
        'FEATURED_MEMBERS' => '被推荐的成员 ',
        'CLICK_TO_SEE_MEMBER_DATA' => '您的成员数据已被输出。点击 <a %s>此链接</a>，将其保存到您的桌面上。 ',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => '很抱歉，没有找到符合 "%s" 的成员。 ',
        'WHO_CAN_COMMENT_ON_POST' => '谁可以在该帖子上添加评论？ ',
        'PREVIOUS_POST' => '←  前帖 ',
        'NEXT_POST' => '后贴，→ ',
        'PREVIOUS_POSTS' => '←  前帖 ',
        'NEXT_POSTS' => '后贴 →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => '没有任何标签为"%1$s"的博文。您可以看看<a %2$s>标签为"%1$s"的讨论</a>, <a %4$s>标签为"%1$s"的照片</a>或<a %3$s> 标签为 "%1$s"的视频</a>。或添加您自己的博文并加标签! ',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => '针对%s %s标签为<em>\'%s\'</em>的所有帖子 ',
        'ALL_POSTS_TAGGED_X' => '标签为<em>\'%s\'</em>的所有帖子 ',
        'MY_BLOG_POSTS_FOR_M_Y' => '我的博文（为%s %s） ',
        'MY_BLOG_POSTS' => '我的博文 ',
        'PRIVACY_CONTENT_CONTROL' => '隐私保护和内容控制 ',
        'MODERATION' => '内容控制 ',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => '启用音乐播放器的下传链接 ',
        'NOTIFY_BLOG_PING_SERVICES' => '您添加新博文时，想要通知第三方的博客跟踪服务吗？ ',
        'YES_NOTIFY_BLOG_SERVICES' => '是的，我添加新博文时，请 通知<a %s>网站更新服务</a> ',
        'THERE_ARE_NO_FEATURED_MEMBERS' => '您的社交网络没有任何被推荐的成员。 ',
        'START_FEATURING_MEMBERS_CLICK_Y' => '当您看到“推荐”选项时，您可以推荐成员。想要详细了解“推荐”，请<a %s>点击这里</a>。 ',
        'SHOW_ALL' => '显示全部 ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => '没有任何标签为"%1$s"的讨论。您可以看看<a %2$s>标签为"%1$s"的照片</a>, <a %4$s>标签为"%1$s"的博文</a>或<a %3$s> 标签为 "%1$s"的视频</a>。或添加您自己的讨论并加标签！ ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => '没有任何标签为"%1$s"的讨论。您可以看看<a %2$s>标签为"%1$s"的照片</a>, <a %4$s>标签为"%1$s"的博文</a>或<a %3$s> 标签为 "%1$s"的视频</a>。 ',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => '您已创建小组%1$s。您可在 %1$s 论坛上开始一个讨论, 或邀请更多朋友加入。 ',
        'YOU_CAN_ADD_100_SONGS' => '您可以添加总计100首歌曲，且每首歌曲最大可达20MB。我们支持.mp3文件格式的歌曲。 ',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => '我有权根据<a %s">服务条款</a>上传这些歌曲。 ',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => '批量音乐上传程序要求使用较新的Java版本。<strong><a %s>单击此处获取Java</a></strong>，或<strong><a %s>返回简单上传程序</a></strong>。 ',
        'HAVE_LOT_OF_MUSIC' => '您有许多音乐要分享？ ',
        'TRY_BULK_MUSIC_UPLOADER' => '请尝试批量音乐上传程序 ',
        'SONGS_SUCCESSFULLY_UPLOADED' => '您的音乐已成功上传。 ',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => '抱歉，您的播放列表只能有 %s 首歌曲。请先删除一些现有的歌曲，然后再添加新的。 ',
        'ADD_MUSIC_FROM_WEBSITE' => '从别的网站添加音乐 ',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => '使用此音乐上传程序有困难？  <strong><a %s>请返回我们的简单上传程序</a></strong>。 ',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => '从您的电脑上传音乐 ',
        'ADD_MUSIC' => '添加音乐 ',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => '选取 <strong>用户</strong>和<strong>所有页面</strong>。 ',



    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}