<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the sv_SE
 */
class XG_MessageCatalog_sv_SE extends XG_AbstractMessageCatalog {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param array $args the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = 'för 1 sekund sedan ';
            $a['N_SECONDS_AGO']['n'] = 'för %s sekunder sedan ';
            $a['N_MINUTES_AGO']['1'] = 'för 1 minut sedan ';
            $a['N_MINUTES_AGO']['n'] = 'för %s minuter sedan ';
            $a['N_HOURS_AGO']['1'] = 'för 1 timme sedan ';
            $a['N_HOURS_AGO']['n'] = 'för %s timmar sedan ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> Video ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> Videor ';
            $a['N_VIEWS']['1'] = '1 visning ';
            $a['N_VIEWS']['n'] = '%s visningar ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> Inlägg ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> Inlägg ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Denna video är en <strong>favorit</strong> för<strong>1 person</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Denna video är en <strong>favorit</strong> för <strong>%s personer</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s lade till en video: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s lade till %s videor. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Du lade till en video: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Du lade till %s videor. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Det finns 1 video på %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Det finns %1$s videor på %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Det finns 1 <a href="%3$s">video</a> på %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Det finns %1$s <a href="%3$s">videor</a> på %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 bild från detta album har tagits bort eller ändrats till privat, så den kan inte visas. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s bilder från detta album har tagits bort eller ändrats till privata, så de kan inte visas. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> Bild ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> Bilder ';
            $a['N_PHOTOS_2']['1'] = '1 bild ';
            $a['N_PHOTOS_2']['n'] = '%s bilder ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Ett problem uppstod vid uppladdning av följande fil: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Ett problem uppstod vid uppladdning av följande filer: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Denna bild är en <strong>favorit</strong> för <strong>1 person</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Denna bild är en <strong>favorit</strong> för <strong>%s personer</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Klassning:</strong> %2$s efter 1 röst ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Klassning:</strong> %2$s efter %s röster ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s efter 1 röst ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s efter %s röster ';
            $a['N_PEOPLE']['1'] = '1 person ';
            $a['N_PEOPLE']['n'] = '%s personer ';
            $a['N_OF_5_STARS']['1'] = '1/5 stjärna ';
            $a['N_OF_5_STARS']['n'] = '%s/5 stjärnor ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Din klassning: 1 stjärna ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Din klassning: %s stjärnor ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s lade till en bild: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s lade till %s bilder. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Du lade till en bild: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Du lade till %s bilder. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Det finns 1 bild på %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Det finns %1$s bilder på %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Det finns %1$s <a href="%3$s">bild</a> på %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Det finns %1$s <a href="%3$s">bilder</a> på %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = '1 inbjudan har skickats tillbaka. ';
            $a['N_INVITATIONS_RESENT']['n'] = '%s inbjudningar har skickats tillbaka. ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'och 1 ytterligare person ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'och %s ytterligare personer ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Profilinlägg ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Profilinlägg ';
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> Blogg-Inlägg ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> Blogg-Inlägg ';
            $a['N_YEARS_OLD']['1'] = '1 år gammal ';
            $a['N_YEARS_OLD']['n'] = '%s år gammal ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Du har 1 vänförfrågan! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Du har %s vänförfrågningar! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Kommentarplank (1 inlägg) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Kommentarplank (%s kommentarer) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 ny medlem har gått med under senaste veckan ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s nya medlemmar har gått med under senaste veckan ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">ny medlem</a> gick med under senaste veckan ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">nya medlemmar</a> gick med under senaste veckan ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Det finns 1 medlem på %2$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Det finns %1$s medlemmar på %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Det finns 1 <a href="%3$s">medlem</a> på %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Det finns %1$s <a href="%3$s">medlemmar</a> på %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Det finns 1 bloggpost på %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Det finns %1$s bloggposter på %2$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> Ny Medlem ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> Nya Medlemmar ';
            $a['N_REPLIES']['1'] = '1 Svar ';
            $a['N_REPLIES']['n'] = '%s Svar ';
            $a['N_MINUTES']['1'] = '1 minut kvar för att ändra ditt inlägg. ';
            $a['N_MINUTES']['n'] = '%s minuter kvar för att ändra ditt inlägg. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Det finns 1 forumämne på %2$s ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Det finns %1$s forumämnen på %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Det finns 1 <a href="%3$s">forumämne</a> på %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Det finns %1$s <a href="%3$s">forumämnen</a> on %2$s ';
            $a['N_INVITES']['1'] = '%s inbjudan ';
            $a['N_INVITES']['n'] = '%s inbjudningar ';
            $a['N_MEMBERS']['1'] = '1 medlem ';
            $a['N_MEMBERS']['n'] = '%s medlemmar ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 medlem) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s medlemmar) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Det finns1 grupp på %2$s ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Det finns %1$s grupper på %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Det finns %1$s <a href="%3$s">grupp</a> på %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Det finns %1$s <a href="%3$s">grupper</a> på %2$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 låt från denna spellista kan inte visas eftersom den tagits bort eller inte längre delas. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s låtar från denna spellista kan inte visas eftersom de tagits bort eller inte längre delas. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'En ny låt har lagts till till %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s nya låtar har lagts till till %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s lade till en låt: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s lade till %s låtar. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Du lade till en låt: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Du lade till %s låtar. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 låt har lagts till till denna spellista. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s låtar har lagts till till denna spellista. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Det finns 1 låt på %2$s ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Det finns %1$s låtar på %2$s ';
        }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Bläddrar',
        'MORE_VIDEOS' => 'Fler Videor',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Detta nätverk har ännu inga videor.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Detta närverk har ännu inga framhållna videor.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Denna person har ännu inga videor.',
        'COPY_TO_CLIPBOARD' => 'Kopiera till Urklipp',
        'COPIED_TO_CLIPBOARD' => 'Kopierade till Urklipp!',
        'NO_VIDEOS_TO_DISPLAY' => 'Du visar för närvarande inga videor.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Denna ruta visas inte för andra personer om du inte valt åtminstone en video.',
        'WATERMARK_LOGO' => 'Vattenmärkeslogga',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Du kan välja antingen en rubrik eller vattenmärkeslogga för din videospelare.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Logotypen visas högst upp på din %s.  Om du inte lägger till en logotyp kommer istället nätverkets namn att visas.  Din logotyp bör vara i . jpg, . gif eller . png format.  Logotyper som är mer än 20 pixlar höga kommer att förminskas för att få plats.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'Vattenmärkesloggan visas ovanför videoklippets nedre högra hörn.',
        'HEADER_LOGO' => 'Rubriklogotyp',
        'WATERMARK' => 'Vattenstämpel',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Anpassa Din Videospelare!',
        'VIDEO_PLAYER' => 'Videospelare',
        'HEADER' => 'Rubrik',
        'SAVE_CHANGES' => 'Spara Ändringar',
        'THUMBNAIL' => 'Miniatyr',
        'CONVERSION_FAILED' => 'Konvertering Misslyckades',
        'CONVERSION_IN_PROGRESS' => 'Konvertering Pågår',
        'MAP' => 'Karta',
        'WHAT_IS_THIS' => 'Vad är Detta?',
        'EDIT_VIDEO_INFORMATION' => 'Ändra Videoinformation',
        'ALL_VIDEOS' => 'Alla Videor',
        'VIDEOS_HOME' => 'Start för Videor',
        'MY_VIDEOS' => 'Mina videoklipp',
        'MY_FRIENDS_VIDEOS' => 'Mina Vänners Videor',
        'MY_FAVORITES' => 'Mina Favoriter',
        'XS_FAVORITES' => '%s\'s Favoriter',
        'ADD_A_VIDEO' => 'Lägg till en video',
        'JUST_NOW' => 'just nu',
        '1_DAY_AGO' => 'för 1 dag sedan',
        'M_J' => 'M j',
        'ME' => 'Mig',
        'X_SAID' => '%s sade…',
        'DELETE_COMMENT' => 'Ta bort Kommentar',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Du har ännu inte lagt till några videor!',
        'ADD_VIDEOS_AND_SHARE' => 'Lägg till videor och dela dem med dina vänner, din familj eller med resten av världen!',
        'THERE_ARE_NO_VIDEOS' => 'Det finns för närvarande inga videor i ditt sociala nätverk.',
        'THIS_BOX_WILL_NOT_SHOW' => 'Denna ruta visas inte för andra personer förrän det finns videor att visa.  Varför inte lägga till en?',
        'ADD_VIDEOS' => 'Lägg till Videor',
        'VIEW_VIDEOS' => 'Visa Videor',
        'YIKES' => 'Yikes!',
        'A_PROBLEM_SEEMS' => 'Ett problem tycks ha uppstått.',
        'FOR_FURTHER_ASSISTANCE' => 'För ytterligare hjälp, <a %s>kontakta oss</a>.',
        'OR_YOU_CAN_GO' => 'Eller så kan du gå tillbaka till <a %s>%s huvudsida</a> eller söka i <a %s>andra sociala Ning-nätverk</a>',
        'TAGS' => 'Taggar:',
        'POPULAR_TAGS' => 'Populära Taggar',
        'MY_FRIENDS' => 'Mina Vänner',
        'VIEW_ALL_MY_FRIENDS' => 'Visa Alla Mina Vänner',
        'VIEW_ALL_XS_FRIENDS' => 'Visa Alla %s\'s Vänner',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Vi beklagar – vi kunde inte hitta någon som matchar din sökning.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Visa Populära Bidragsgivare',
        'POPULAR_CONTRIBUTORS' => 'Populära Bidragsgivare',
        'VIEW_MORE_CONTRIBUTORS' => 'Visa Fler Bidragsgivare',
        'ADD_AS_FRIEND' => 'Lägg till som vän',
        'SEND_A_MESSAGE' => 'Sänd ett Meddelande',
        'IS_YOUR_FRIEND' => 'Är Din Vän',
        'IS_BLOCKED' => 'Är Blockerad',
        'SORT_BY' => 'Sortera med avseende på:',
        'CLOSE' => 'Stäng',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Ingen har ännu lagt till videor!  Lägg till några videor för att komma igång.',
        'SEARCH_PEOPLE' => 'Sök Personer:',
        'INVITE_YOUR_FRIENDS_TO' => 'Bjud in dina vänner till %s.',
        'INVITE' => 'Bjud in',
        'INVITE_TAB_TEXT' => 'Bjud in',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Du har ännu inte lagt till några vänner på %s.',
        'SEARCH_FRIENDS' => 'Sök Vänner:',
        'ADD_YOUR_FIRST_VIDEO' => 'Lägg till Din Första Video',
        'USE_HTML_EMBED_CODE' => 'Använd HTML-inbäddad kod',
        'UPLOAD_A_VIDEO_FROM' => 'Ladda upp en video från din dator. Vi godkänner alla populära format!',
        'WE_SUPPORT_MOV' => 'Vi stödjer .mov, .mpg, .avi, .3gp och .wmv  format. Filerna får vara högst 100MB.',
        'NEED_HELP_HERE_ARE' => 'Behöver du hjälp?  Här är instruktioner för <a %s>YouTube</a> och <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Lägg till en titel och beskrivning',
        'DESCRIPTION_COLON' => 'Beskrivning:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Lägg till en titel, beskrivning och annan information om videon du just laddat upp.',
        'EVERYTHING_IS_OPTIONAL' => 'Allt är valfritt;  Om du inte vill lägga till någonting, klicka bara på "Hoppa över detta steg" till höger.',
        'SKIP_THIS_STEP' => 'Hoppa över detta steg',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Lägg till en titel, beskrivning och annan information om denna video.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Avbryt och gå tillbaka till video',
        'TITLE' => 'Titel:',
        'EACH_VIDEO_MAY_BE_100MB' => 'En video får vara upp till 100MB. Vi stödjer videor i .mov, .mpg, .avi, .wmv och .3gp  format.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Jag har rätt att ladda upp den här videon enligt<a %s>Användarvillkoren</a>.',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'Innehållsuppladdaren för video kräver en nyare version av Java. <strong><a %s>Klicka här för att komma till Java</a></strong>, eller <strong><a %s>gå tillbaks till den enkla uppladdaren</a></strong>.',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Ladda upp en video från din dator',
        'HAVE_LOT_OF_VIDEOS' => 'Har du många videor du vill dela?',
        'TRY_BULK_VIDEO_UPLOADER' => 'Pröva innehållsuppladdaren för video',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Dina videor laddades upp utan problem',
        'VIDEOS_UPLOADED_AWAITING' => 'Dina videor laddades upp utan problem och väntar på godkännande från %s skapare.',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Lägg till bilder eller videor till %s direkt från din telefon genom att sända dem till en e-postadress',
        'GRAB_HTML_EMBED' => 'Fånga den \\‘inbäddade\\’ HTML-koden från vilken popular videoplats som helst och lägg den videon till nätverket.',
        'GOOGLE' => 'Google',
        'YOUTUBE' => 'YouTube',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Har du problem med innehållsuppladdaren för video?  <strong><a %s>Gå tillbaks till vår enkla uppladdare</a></strong>.',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Lägg till videor från YouTube eller Google',
        'TAGS_NO_COLON' => 'Taggar',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Det finns inga videor taggade med "%1$s". Sök på<a %2$s>diskussioner taggade med "%1$s"</a>, <a %4$s>bloggposter taggade med "%1$s"</a> eller <a %3$s>bilder  taggade med "%1$s"</a>. Eller lägg till och tagga dina egna videor!',
        'UPLOAD_VIDEOS_FROM' => 'Ladda upp videor från din dator',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Din uppladdning av video på %s fungerade inte beroende på ett konverteringsproblem.',
        'FOR_FURTHER_ASSISTANCE_2' => 'För ytterligare hjälp, kontakta oss på:',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'För att underlätta problemlösningen, lämna detta videoID: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Din video laddades utan problem upp på %s.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'För att se på videon gå in på:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Din video "%1$s" på %2$s har en ny kommentar.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Din video på %s har en ny kommentar.',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Lägg till videos via telefon eller e-post',
        'FEATURING_ELLIPSIS' => 'Med…',
        'NOW_FEATURED_ON_MAIN' => 'Visas nu på förstasidan',
        'DONT_FEATURE' => 'Visa inte',
        'UNFEATURING_ELLIPSIS' => 'Tar bort från förstasidan...',
        'REMOVED_FROM_MAIN' => 'Borttagen från förstasidan',
        'ADDED_EXCLAMATION' => 'Tillagd!',
        'ERROR' => 'Fel',
        'ADDING_ELLIPSIS' => 'Lägger till...',
        'TRACK_COULD_NOT_BE_LOADED' => 'Låten laddades inte',
        'INVALID_URL' => 'Ogiltig URL',
        'NORMAL_PLAYBACK_ON' => 'Normal playback: På',
        'REPEAT_PLAYBACK_ON' => 'Repetitionsplayback: På',
        'SHUFFLE_PLAYBACK_ON' => 'Blandad playback: På',
        'OPEN_POPUP_WINDOW' => 'Öppna popupp-fönster',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Laddar spellista...',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'En bild kan vara på upp till 10 MB. Vi stödjer bilder i .jpg, .gif och .png format.',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Jag har rätt att ladda upp bilderna enligt <a %s>Användarvillkoren</a>.',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'Innehållsuppladdaren kräver en nyare version av Java. <strong><a %s>Klicka här för att komma till Java</a></strong>, eller <strong><a %s>gå tillbaks till den enkla oppladdaren</a></strong>.',
        'TRY_BULK_PHOTO_UPLOADER' => 'Pröva innehållsuppladdaren för bilder',
        'HAVE_LOT_OF_PHOTOS' => 'Har du många bilder du vill dela?',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Dina bilder laddades upp utan problem.',
        'PHOTOS_UPLOADED_AWAITING' => 'Dina bilder laddades upp utan problem och väntar på godkännande från %s skapare.',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => 'Lägg till bilder från Flickr',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Lägg till bilder eller videor till %s direkt från din telefon genom att sända dem till en e-postadress',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Har du problem med innehållsuppladdaren för bilder?  <strong><a %s>Gå tillbaks till vår enkla uppladdare</a></strong>.',
        'VIEW_SLIDESHOW' => 'Visa bildspel',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Det finns inga bilder taggade med "%1$s". Sök på <a %2$s>diskussioner taggade med "%1$s"</a>, <a %4$s>bloggposter taggade med "%1$s"</a> eller <a %3$s>videor taggade med "%1$s"</a>. Eller lägg till och tagga dina egna bilder!',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Ladda upp bilder från din dator',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Din bild "%1$s" har en ny kommentar på %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Din bild har en ny kommentar på %s.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Klicka ’Edit’ för att lägga till text, HTML, videor, bilder eller några <a %1$s>tredjeparts-widgets</a> till denna ruta.  Det är ett annat sätt som du kan göra din %2$s sida till din egen.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Du har en ny %1$s att godkänna på %2$s...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Du har en ny %1$s att godkänna på %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Du har en ny %1$s att godkänna på %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'För att godkänna %s, besök:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Din %1$s på %2$s har godkänts...',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Din %1$s på %2$s har en ny kommentar...',
        'CLICK_HERE_TO_JOIN' => 'Klicka här för att gå med:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s vill att du kollar på "%2$s" på %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Din %s har godkänts på %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Din %1$s "%2$s" har godkänts på %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'För att se dina %s, gå in på:',
        'TO_VIEW_THIS_X_VISIT' => 'För att se på denna %s, gå in på :',
        'TO_VIEW_IT_VISIT' => 'För att se den, gå in på:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s rapporterade följande fråga på %2$s...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s har sänt dig ett meddelande på %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s har bett att få gå med i %2$s på %3$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s har begärt medlemskap i %2$s på %3$s…',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'För att godkänna eller avslå %s begäran, gå in på:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s gjorde en kommentar till bloggposten "%2$s" på %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s gjorde en kommentar till en bloggpost på %2$s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Du har en ny medlem att godkänna på %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Välkommen till Klubben "%1$s" på %2$s',
        'COME_JOIN_ME_ON_X' => 'Kom och gör mig sällskap på %s!',
        'PLEASE_SELECT_A_MEMBER' => 'Välj en eller flera medlemmar',
        'LOADING_YOUR_FRIENDS' => 'Vi laddar upp dina vänner...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Ditt meddelande har sänts',
        'TO_SEND_ANOTHER_MESSAGE' => 'För att sända ytterligare ett meddelande, lägg in din text nedan.',
        'PLEASE_CHOOSE_FRIENDS' => 'Välj ut några vänner innan du skickar ditt meddelande.',
        'RESEND_INVITATION' => 'Sänd inbjudan på nytt',
        'CHOOSE_FRIENDS' => 'Välj vänner...',
        'ALL_FRIENDS' => 'Alla vänner',
        'ALL_FRIENDS_ON_APPNAME' => 'Alla vänner på %s',
        'SHARE_WITH_FRIENDS' => 'Dela med Vänner',
        'SHARE_THIS_WITH_FRIENDS' => 'Dela denna sak med dina vänner',
        'COMPOSE_MESSAGE' => 'Sätt ihop ett meddelande',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Inbjudningslänken är bara synlig för Nätverkets Skapare och för Administratörerna. De som blivit medlemmar via denna länk blir automatiskt vänner till Nätverkets Skapare.',
        'WE_ARE_LOADING_ADDRESSES' => 'Vi laddar upp dina adresser...',
        'SELECT_ALL_NONE' => 'Välj samtliga/ingen',
        'INVITE_TO_APPNAME' => 'Bjud in till \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Bjud in dina vänner till \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Redan medlem i nätverket)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Eller dela den här inbjudningslänken:',
        'CLICK_TO_MAIL' => '<a %s>Klicka här för att posta nu</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Ditt meddelande har sänts',
        'YOU_CAN_SHARE_THIS' => 'Du kan dela med fler personer nedan eller <a %s>gå tillbaks till föregående sida</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Vi är ledsna men vKort-importtjänsten är inte tillgänglig just nu.',
        'CSV_IMPORT_UNAVAILABLE' => 'Vi är ledsna men CSV-importtjänsten är inte tillgänglig just nu.',
        'ERROR_OCCURRED' => 'Vi är ledsna men ett fel har inträffat.',
        'IMPORT_FAILED' => 'Vi är ledsna men importen misslyckades.',
        'LOGIN_FAILED' => 'Vi är ledsna men inloggningen misslyckades.',
        'UNABLE_TO_FIND_EMAIL' => 'Vi är ledsna men vi kunde inte hitta e-postrutan.',
        'CANNOT_READ_VCARDS' => 'Vi är ledsna men vi kan inte läsa vKorten.',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Tyvärr stödjer vi inte adressboken till din e-postadress. Klicka på  \'Address Book Application\' nedan för att använda adresserna från din dator.',
        'NO_ADDRESSES_FOUND' => 'Adresser hittades inte',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Vi hittade inga adresser i den adressbok vi importerade.',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Vill du bjuda in fler vänner? Importera kontakter från ditt webb- eller adressboksprogram.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Importera från webb-adressboken',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Importera från adressboksprogrammet',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Address Book, .CSV, osv.',
        'SET_NEW_PASSWORD' => 'Bestäm ett nytt lösenord för ditt Ning-ID konto.',
        'PRIVACY_POLICY' => 'Integritetspolicy',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => 'Ansök om medlemskap nu. Är du redan medlem? <a %s>Klicka här för att logga in</a>.',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s gav följande feedback om %2$s:',
        'TRACK_STATISTICS' => 'Följ upp statistik',
        'FEATURED_MEMBERS' => 'Framträdande medlemmar',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Ledsen, %s, du saknar åtkomst till %s eftersom du blivit bannad.  Om du tror att du blivit bannad av misstag kan du kontakta administratören.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Ledsen, %s, du saknar åtkomst till %s eftersom du blivit bannad.',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Kolla på "%1$s" på %2$s...',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Kolla den här %1$s på %2$s...',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Tyvärr, inga medlemmar som matchar "%s" hittades.',
        'WHO_CAN_COMMENT_ON_POST' => 'Vem kan kommentera den här posten?',
        'SEND_MESSAGE_TO_FRIENDS' => 'Skicka meddelande till vänner',
        'PREVIOUS_POST' => '← Föregående post',
        'NEXT_POST' => 'Nästa post →',
        'PREVIOUS_POSTS' => '←  Föregående poster',
        'NEXT_POSTS' => 'Nästkommande poster →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Det finns inga bloggposter taggade med "%1$s". Sök på <a %2$s>diskussioner taggade med "%1$s"</a>, <a %4$s>bilder taggade med "%1$s"</a> eller <a %3$s>videor taggade med "%1$s"</a>. Eller lägg till och tagga dina egna bloggposter!',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Alla poster taggade <em>\'%s\'</em> för %s %s',
        'ALL_POSTS_TAGGED_X' => 'Alla poster taggade <em>\'%s\'</em>',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Mina bloggposter på %s %s',
        'MY_BLOG_POSTS' => 'Mina bloggposter',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Välj sätt att underrätta om meddelanden som skickats till samtliga vänner',
        'PRIVACY_CONTENT_CONTROL' => 'Integritet och Innehållskontroll',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Tillåt nerladdningslänkar för musikspelare',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Välkommen %1$s! Du är medlem #%2$s i %3$s. <a %4$s>Bjud in vänner nu</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Du kommenterade bilden<a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s kommenterade bilden<a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Du kommenterade videon<a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s kommenterade videon<a %s>%s</a>',
        'NOTIFY_BLOG_PING_SERVICES' => 'Vill du underrätta en utomstående bloggspårningstjänst när du lägger till en ny bloggpost?',
        'YES_NOTIFY_BLOG_SERVICES' => 'Ja -- Underrätta <a %s>sajtuppdateringtjänster</a> när jag lägger till en ny bloggpost.',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Det finns inga Framträdande medlemmar på ditt sociala nätverk.',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Börja lyfta fram medlemmar där du ser Lyft fram-valet. För att veta mer om att Lyfta fram, <a %s>Klicka här</a>.',
        'THIS_IS_YOUR_PAGE' => 'Det här är din sida:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Meddelanden som skickats till samtliga vänner',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Vill du sluta följa den här %s, gå till:',
        'SHOW_ALL' => 'Visa alla',
        'CHOOSE_GADGETS' => 'Välj en av dessa fina Öppet sociala gadgets och lägg in den på din profilsida! Du kan  <a %s>se och betygssätta gadgets här</a>, eller<a %s>lära dig mer om Öppet socialt här</a>.',
        'GADGETS_UNAVAILABLE' => 'Gadgets är inte tillgängliga för tillfället',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Vi ber om ursäkt – gadgets är inte tillgängliga för tillfället.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Rutan kommer inte att visas för andra om du inte väljer en gadget.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Klicka på Ändra för att ange gadget-URL:en för den här rutan eller gå in på <a %s>Gadgetbiblioteket</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Ett problem uppstod vid hämtningen av den här gadgetURL-matningen.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Lägg den här gadgeten till din profil',
        'GADGETS_BETA' => 'Gadgets (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Pröva Öppet sociala gadgets.  Varning: funktionen är ett experiment.',
        'ADD_TO_MY_PAGE' => 'Lägg till min sida',
        'GADGETS' => 'Gadgets',
        'GADGETS_TAB_TEXT' => 'Gadgets',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Gadgets är i betaversion.',
        'SORRY_GADGET_UNAVAILABLE' => 'Vi är ledsna men den här gadgeten är inte tillgänglig. Kolla att du har rätt URL. Om problemen kvarstår <a %s>meddela oss</a>.',
        'VIEW_ALL_N_CATEGORIES' => 'Visa alla %s kategorier',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Det finns inga diskussioner taggade med "%1$s". Sök på <a %2$s>bilder taggade med "%1$s"</a>, <a %4$s>bloggposter taggade med "%1$s"</a> eller <a %3$s>videor taggade med "%1$s"</a>. Eller lägg till och tagga dina egna diskussioner!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Det finns inga diskussioner taggade med "%1$s". Sök på <a %2$s>bilder taggade med "%1$s"</a>, <a %4$s>bloggposter taggde med "%1$s"</a> eller <a %3$s>videor taggade med "%1$s"</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Redan medlem i gruppen)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Bjud in dina vänner till \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Kom och gör mig sällskap på %1$s på %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Kom och gör mig sällskap på %1$s på %2$s...',
        'INVITE_TO_GROUP' => 'Bjud in till \'%s\'',
        'YOU_CAN_ADD_100_SONGS' => 'Du kan lägga till 100 låtar totalt och varje låt får vara upp till 20MB. Vi stödjer låtar i .mp3  format.',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Jag har rätt att ladda upp låtarna enligt  <a %s">Användarvillkoren</a>.',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'Innehållsuppladdaren för musik kräver en nyare version av Java. <strong><a %s>Klicka här för att komma till Java</a></strong>, eller <strong><a %s>gå tillbaks till den enkla uppladdaren</a></strong>.',
        'HAVE_LOT_OF_MUSIC' => 'Har du mycket musik du vill dela?',
        'TRY_BULK_MUSIC_UPLOADER' => 'Pröva innehållsuppladdaren för musik.',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Dina låtar laddades upp utan problem.',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Tyvärr kan du bara ha %s låtar på spellistan. Ta bort några gamla låtar innan du lägger in nya.',
        'ADD_MUSIC_FROM_WEBSITE' => 'Lägg till musik från en annan webbplats',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Har du problem med den här musikuppladdaren?  <strong><a %s>Gå tillbaks till vår enkla uppladdare</a></strong>.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Ladda upp musik från din dator',
        'ADD_MUSIC' => 'Lägg till musik',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Välj <strong>Användare</strong> och <strong>Alla sidor</strong>.',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Taggar är korta beskrivningar som hjälper dig att hitta dina videor.  Separera taggar med kommatecken eller sätt flerordstaggar inom citationstecken, som exempelvis ”San Francisco”.',
        'WHO_CAN_VIEW_VIDEO' => 'Vem kan visa denna video?',
        'MOST_POPULAR' => 'Mest Populär',
        'HIGHEST_RATED' => 'Högst klassificerad',
        'MOST_RECENT' => 'Senaste',
        'MOST_FAVORITED' => 'Största Favoriten',
        'MOST_POPULAR_VIDEOS' => 'Mest Populära Videor',
        'HIGHEST_RATED_VIDEOS' => 'Högst Klassificerade Videor',
        'MOST_RECENT_VIDEOS' => 'Senaste Videor',
        'MOST_FAVORITED_VIDEOS' => 'Största Videofavoriterna',
        'ANYONE' => 'Alla',
        'JUST_MY_FRIENDS' => 'Endast Mina Vänner',
        'JUST_ME' => 'Endast Jag',
        'VIEWABLE_BY_FRIENDS' => 'Kan visas av <strong>Vänner</strong>',
        'PRIVATE_VIDEO' => '<strong>Privat</strong> video',
        'VIEWABLE_BY_EVERYONE' => 'Kan visas av <strong>Alla</strong>',
        'LOCATION' => 'Plats:',
        'NO_LOCATION' => 'Ingen plats',
        'CLICK_ON_LOCATION' => 'Klicka på en plats på kartan:',
        'FIND_AN_ADDRESS' => 'Finn adressen:',
        'LOCATE' => 'Hitta',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Du kan <a %s>lägga till din egen video</a> till %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Lägg till en logotyp eller vattenstämpel till ditt nätverks videospelare.  <a %s>Sätt upp den nu! </a>',
        'APPROVE' => 'Godkänn',
        'DELETE' => 'Ta bort',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Gäller samtliga Videor tillagda av %s',
        'NO_TITLE' => 'Ingen Titel',
        'ADDED_BY_STRONG_X' => 'Tillagd av <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Ingen Beskrivning',
        'BY_X' => 'av %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Du Har Avslutat Moderering',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Det finns för närvarande inga videor som väntar på godkännande.  Om du letar efter något att göra, varför inte ta en titt på de<a %s>senaste videorna</a>?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Ingen har lagt till videor till ditt sociala nätverk.  Bli den förste att lägga till en video!',
        'ADDED_ON_DATE_BY_X' => 'Tillagd %s av %s.',
        'REMOVE_FROM_FAVORITES' => 'Ta bort från Favoriter',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Ta bort denna video från dina favoriter?',
        'COLLECTED_BY_X' => 'Samlad av %s',
        'ADD_FAVORITES' => 'Lägg till Favoriter',
        'YOU_CAN_MARK_VIDEO' => 'Du kan markera vilken video som helst som en favorit.  Klicka bara på ikonen "Lägg till i Favoriter" när du ser den på en video.',
        'VIEW_RECENT_VIDEOS' => 'Visa Senaste Videorna',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s har ännu inte lagt till några favoriter.',
        'APPROVE_VIDEOS' => 'Godkänn Videor',
        'YOUR_SITE_REQUIRES_YOU' => 'Du har bett om att moderera bilder och videor på ditt sociala nätverk innan de skickas.  För att ändra denna inställning, <a %s>klicka här för att komma till Integritetssidan</a> och stäng av \\’Godkänn Nya Bilder och Videor\\’.',
        'YOUR_SITE_ALLOWS_USERS' => 'Du har bett om att inte moderera bilder och videor på ditt sociala nätverk innan de skickas.  För att ändra denna inställning, <a %s>klicka här för att komma till Integritetssidan</a> och stäng av \\’Godkänn Nya Bilder Och Videor\\’.',
        'APPROVE_ALL_VIDEOS' => 'Godkänn Alla Videor?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Är du säker på att du vill godkänna alla videor?  Detta kan ta några minuter.',
        'APPROVING' => 'Godkänner…',
        'APPROVE_ALL' => 'Godkänn Alla',
        'DELETE_ALL_VIDEOS' => 'Ta bort Alla Videor?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Är du säker på att du vill ta bort alla icke-godkända videor?  Detta kan ta några minuter.',
        'DELETING' => 'Tar bort…',
        'DELETE_ALL' => 'Ta bort Alla',
        'XS_VIDEOS' => '%s\'s Videor',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Ta bort Alla %s\'s Videor?',
        'DELETE_ALL_XS_VIDEOS' => 'Ta bort Alla %s\'s Videor',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Är du säker på att du vill ta bort alla videor av %s?  Denna bearbetning kan ta några minuter.',
        'DELETE_THIS_VIDEO_Q' => 'Ta bort Denna Video?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Är du säker på att du vill ta bort denna video?  Denna bearbetning kan ta några minuter.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Du har ännu inte lagt till någon video.  Lägg till några videor för att komma igång!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s har ännu inte lagt till några videor.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Dina vänner har ännu inga videor.',
        'ALL_VIDEOS_TAGGED_X' => 'Alla Videor Taggade \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Alla Videor Taggade <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'Det finns inte några taggade videor "%1$s".  Titta på <a %2$s>taggade diskussioner "%1$s"</a> eller <a %3$s>taggade bilder "%1$s"</a>.  Eller lägg till och tagga dina egna videor!',
        'FILES_MUST_BE_100MB' => 'Filer måste vara 100 MB eller mindre.  Vi stödjer filformaten .mov, .mpg, .avi, .3gp och .wmv.',
        'NEED_HELP' => 'Behöver du hjälp?',
        'HERE_ARE_INSTRUCTIONS' => 'Här är instruktioner för <a %s>YouTube</a> och <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'Personen med ansvar för %s vill se din skapelse innan den visas för resten av världen.',
        'LEAVE_WINDOW_OPEN' => 'Lämna detta fönster öppet medan uppladdningsprocessen pågår.',
        'KEEP_PAGE_OPEN' => 'Håll denna sida öppen så vi kan avsluta uppladdning av din video, så meddelar vi dig när den godkänts!',
        'MEANWHILE_FEEL_FREE' => 'Under tiden får du gärna <a %s>öppna ett nytt fönster</a> och fortsätta använda %s.  När uppladdningen är klar kan du lägga till en titel och beskrivning av din video i detta fönster.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Denna video <strong>väntar på godkännande</strong> från %s\'s skapare.',
        'LOADING' => 'Laddar…',
        'EDIT_VIDEO' => 'Ändra Video',
        'DELETE_VIDEO' => 'Ta bort Video',
        'YOU_NEED_TO_BE_MEMBER' => 'Du måste vara medlem av %s för att lägga till kommentarer!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Gå med i detta nätverk</a>',
        'ADD_A_COMMENT' => 'Lägg till en Kommentar',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Lämna en Kommentar till %s',
        'MORE' => 'Mer',
        'PREVIOUS' => 'Föregående',
        'NEXT' => 'Nästa',
        'ABOUT_THIS_VIDEO' => 'Om Denna Video',
        'ABOUT_YOUR_VIDEO' => 'Om Denna Video',
        'ADDED_ON_DATE_BY' => 'Tillagd <strong>%s</strong> av:',
        'VIEWS' => 'Visningar:',
        'COMMENTS' => 'Kommentarer',
        'COMMENTS_COLON' => 'Kommentarer:',
        'LOCATION_OF_VIDEO' => 'Plats för denna video:',
        'RELATED_VIDEOS' => 'Närbesläktade Videor',
        'ALL_VIDEOS_TAGGED_X_X' => 'Alla Videor Taggade %s (%s)',
        'XS_VIDEOS_X' => '%s\'s Videor (%s)',
        'XS_FAVORITES_X' => '%s\'s Favoriter (%s)',
        'VIDEO_DETAILS' => 'Videodetaljer',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Varken fil eller inbäddad kod specificerades.',
        'VIDEO_UPLOADED_ON_X' => 'Video uppladdad på %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Ett problem uppstod medan videon konverterades till Flash-format: %s',
        'STATUS_N' => 'Status %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Din video med titeln "%s" kunde inte läggas till i %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Din video kunde inte läggas till i %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Du har just försökt sända in en video till %s.  Du är tyvärr inte medlem av %s och vi kan inte leverera denna video.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Din uppladdning av video på %s fungerade inte',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'din uppladdning av video på %s avslutades ej.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Det uppstod ett problem med din video under uppladdningen till %s',
        'THE_PROBLEM_WAS_X' => 'Problemet var: %s',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Transkodningen av video %s misslyckades i %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s laddade upp en video där transkodningen misslyckades.',
        'ERROR_MESSAGE' => 'Felmeddelande:',
        'APPLICATION_NAME' => 'Programnamn:',
        'APPLICATION_ID' => 'Program ID:',
        'VIDEO_ID' => 'Video ID:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Uppladdning av din video avslutad på %s',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'Uppladdning av din video avslutad på %s',
        'YOUR_VIDEO_WAS_UPLOADED' => 'Din video laddades utan problem upp på %s!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Denna video väntar på godkännande.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Denna video bearbetas fortfarande.',
        'ADD_VIDEO' => 'Lägg till Video',
        'VIDEO_BY_X' => 'Video av %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'Det finns en ny kommentar till din video "%s" på %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'Det finns en ny kommentar till en av dina videor på %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'någon har kommenterat en video du lagt till i %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'någon har laddat upp en video till %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Fler sätt att lägga till videor…',
        'FROM_YOUTUBE_OR_GOOGLE' => '…från YouTube eller Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Fånga den ’inbäddade’ HTML-koden från vilken populär videoplats som helst och lägg till denna video till detta sociala nätverk.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Lägg till en video från YouTube eller Google',
        'PASTE_IN_EMBED' => 'Klistra in den ’inbäddade’ koden för videon här:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Lägg till video via telefon eller e-post',
        'VIDEO' => 'video',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Det finns inga videor som matchar inställningarna som du valt.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Klicka på \\‘ Ändra\\’ och ändra inställningar om du vill att denna ruta skall visas för andra personer.',
        'PLAY_AGAIN' => 'Spela upp Igen',
        'SHARE' => 'Dela',
        'EMBED' => 'Bädda in',
        'REWIND' => 'Spola tillbaka',
        'CHANGE_SIZE' => 'Ändra storlek',
        'FULLSCREEN' => 'Helskärm',
        'EXIT_FULLSCREEN' => 'Stäng Helskärm',
        'HIDE' => 'Stäng',
        'COPY_AND_PASTE_LINK' => 'Kopiera och klistra in denna länk i ett e-postmeddelande eller snabbmeddelande:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Hitta fler videor liknande denna på <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Visa denna video på %s',
        'GET_EMBED_CODE' => 'Hämta inbäddad kod',
        'MORE_PHOTOS' => 'Fler Bilder',
        'THIS_ALBUM' => 'Detta Album',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Detta nätverk har ännu inte några bilder.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Denna person har ännu inte några bilder.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Detta album har ännu inte några bilder.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Hitta fler bilder liknande denna på <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'Det finns för närvarande inga bilder tillgängliga i detta album.  <a %s>Klicka här för att se alla album</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Detta album kan inte ses av andra personer i nätverket eftersom dess bilder endast kan ses av dig eller måste ännu godkännas.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Anpassa Din Bildspelsvisare!',
        'ADD_SLIDESHOW_LOGO' => 'Lägg till en logotyp i bildspelet i ditt sociala nätverk.  <a %s>Sätt upp den nu! </a>',
        'PHOTO_BY_X' => 'Bild av %s',
        'UPLOAD_PHOTOS' => 'Ladda upp Bilder',
        'PLAYER_COLOR' => 'Spelarfärg',
        'SLIDESHOW_PLAYER' => 'bildspelsvisare',
        'SLIDESHOW' => 'bildspel',
        'FILTER' => 'Filter',
        'SAVE_ALBUM' => 'Spara Album',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Använd denna information för följande bilder',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'klicka för att lägga till en beskrivning',
        'CHECK' => 'Kontrollera',
        'YOU_NEED_TO_BE_X' => 'Du måste vara %s för att göra detta.',
        'ALL_PHOTOS' => 'Alla Bilder',
        'POPULAR_PHOTOS' => 'Populära Bilder',
        'FEATURED_PHOTOS' => 'Uppmärksammade Bilder',
        'PHOTOS_HOME' => 'Start för Bilder',
        'ALL_ALBUMS' => 'Alla album',
        'MY_PHOTOS' => 'Mina Bilder',
        'MY_ALBUMS' => 'Mina Album',
        'ADD_PHOTOS' => 'Lägg till Bilder',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Lägg till Bilder',
        'EDIT' => 'Ändra',
        'CHOOSE_PHOTOS' => 'Välj Bilder',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Lägg till bilder genom att dra dem</strong> till ditt album till höger.  Avlägsna dem genom att dra dem tillbaka.',
        'TITLE_YOUR_ALBUM' => '<strong>Ge ditt album en titel. </strong> Ge den ett omslag och beskrivning.',
        'SAVE_YOUR_ALBUM' => 'Spara ditt album!',
        'CHOOSE_FROM' => 'Välj från:',
        'EVERYONES_PHOTOS' => 'Allas Bilder',
        'TAGGED' => 'Taggad:',
        'OLDER_PHOTOS' => 'Äldre Bilder',
        'MORE_RECENT_PHOTOS' => 'Nyare Bilder',
        'YOUR_ALBUM' => 'Ditt Album',
        'DRAG_ALBUM_COVER_HERE' => 'Drag albumets omslag hit',
        'ALBUM_TITLE' => 'Titel för Album:',
        'ALBUM' => 'album',
        'DRAG_PHOTOS_HERE' => 'Drag Dina Bilder Hit',
        'PREVIOUS_ALBUM_PAGE' => 'Föregående Albumsida',
        'NEXT_ALBUM_PAGE' => 'Nästa Albumsida',
        'ADDED_ON_DATE' => 'Tillagda %s',
        'VIEW_AS_SLIDESHOW' => 'Visa som Bildspel',
        'CREATED_BY_ME' => 'Skapad av <a %s>Mig</a>',
        'CREATED_BY_X' => 'Skapad av %s',
        'OUR_APOLOGIES' => 'Vi beklagar',
        'ADD_PHOTOS_TO_ALBUM' => 'Välj ytterligare bilder till detta album genom att välja från alternativen nedan.',
        'YOU_CAN_ADD_PHOTOS' => 'Du kan <a %s>nu lägga till bilder till detta album</a>.',
        'SITE_IS_GETTING_STARTED' => 'Detta sociala nätverk har just startats!',
        'NO_ONE_CREATED_ALBUMS' => 'Det ser inte ut som om någon har skapat något album ännu.  Du kan<a %s>skapa ett album nu</a>.',
        'EDIT_YOUR_ALBUM' => 'Ändra i Ditt Album',
        'ALBUMS_WITH_THIS_PHOTO' => 'Samtliga Album med Denna Bild',
        'ALBUMS_WITH_X' => 'Samtliga Album Med \'%s\'',
        'ALBUMS_WITH_X_2' => 'Samtliga Album Med <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Det finns inga album som har denna bild.  Du kan <a %s>skapa ett nytt album</a>.',
        'XS_ALBUMS' => '%s\'s Album',
        'CREATE_AN_ALBUM' => 'Skapa ett Album',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Du har inte skapat något fotoalbum ännu.  Du kan<a %s>skapa ett album nu</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s har ännu inte skapat något fotoalbum.',
        'MAKE_AN_ALBUM' => 'Skapa ett Album',
        'ABOUT_THIS_ALBUM' => 'Om Detta Album',
        'ABOUT_YOUR_ALBUM' => 'Om Ditt Album',
        'EDIT_ALBUM' => 'Ändra i Album',
        'DELETE_THIS_ALBUM' => 'Radera detta album?',
        'DELETE_ALBUM' => 'Radera Album',
        'START_SLIDESHOW' => 'Börja Bildspel',
        'ALBUM_IS_NOW_EMPTY' => 'Detta album är nu tomt.',
        'YOU_ARE_GETTING_STARTED' => 'Du har just startat!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Du har ännu inte lagt till några bilder!',
        'ADD_PHOTOS_AND_SHARE' => 'Lägg in bilder och dela dem med dina vänner, din familj eller med resten av världen!',
        'ADD_A_PHOTO' => 'Lägg till en Bild',
        'NO_PHOTOS_ON_SITE' => 'Det finns just nu inga bilder i ditt sociala nätverk.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Denna ruta visas inte för andra personer förrän det finns bilder att visa.  Varför inte lägga till en?',
        'VIEW_EMBED_CODE' => 'Visa inbäddad kod',
        'VIEW_PHOTOS' => 'Visa Bilder',
        'ADD_YOUR_FIRST_PHOTOS' => 'Lägg Till Dina Första Bilder',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Du kan <a %s>lägga till dina bilder</a> till %s!',
        'UPLOAD_PHOTOS_FROM' => 'Ladda upp bilder från din dator:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Lägg till en titel och beskrivning för dina bilder',
        'EDIT_PHOTO_INFORMATION' => 'Ändra Bildinformation',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Lägg till en titel, beskrivning och annan information till bilderna du just laddat upp.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Lägg till en titel, beskrivning och annan information för denna bild.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Avbryt och gå tillbaka till bild',
        'WHO_CAN_VIEW_PHOTO' => 'Vem kan se denna bild?',
        'CAN_BE_VIEWED_BY' => 'Kan ses av:',
        'BY_ME' => 'av <a %s>Mig</a>',
        'RSS_FEED_LABEL' => '<a %s>RSS-Matning</a> – %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Det finns för närvarande inga bilder som väntar på godkännande.  Om du söker något att göra, varför inte ta en titt på de <a %s>senaste bilderna</a>?',
        'APPROVE_ALL_PHOTOS' => 'Godkänna Alla Bilder?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Är det säkert att du vill godkänna alla bilder?  Detta kan ta några minuter.',
        'DELETE_ALL_PHOTOS' => 'Ta Bort Alla Bilder?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Är det säkert att du vill ta bort alla icke-godkända bilder?  Detta kan ta några minuter.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Håll detta webbläsarfönster öppet medan bilder godkänns.  Denna bearbetning kan ta några minuter.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Håll detta webbläsarfönster öppet medan bilder tas bort.  Denna bearbetning kan ta några minuter.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Gäller för alla Bilder som läggs till av %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Ingen har lagt till några bilder till ditt sociala nätverk.  Du kan bli den förste att <a %s>lägga till bilder. </a>',
        'UNTITLED' => 'Utan titel',
        'A_PROBLEM_OCCURRED' => 'Ett problem har inträffat',
        'PHOTOS_EXCEEDED_LIMIT' => 'Bilden (bilderna) tycks ha överskridit gränsen på 10 MB per bild.',
        'GET_A_SLIDESHOW_OF' => 'Skapa ett Bildspel av %s',
        'GET_A_SLIDESHOW' => 'Skapa ett Bildspel!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Skapa ett bildspel av dessa bilder',
        'COPY_AND_PASTE_SLIDESHOW' => 'Kopiera och klistra in koden nedan för att lägga in ett bildspel med dessa bilder på din webbsida, MySpace-sida eller andra Ning-nätverk.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Kopiera och klistra in koden nedan för att lägga in ett bildspel med detta album på din webbsida, MySpace-sida eller andra Ning-nätverk.',
        'LARGE_VERSION' => 'Stor Version',
        'SMALL_VERSION' => 'Liten Version',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Visa detta bildspel i full storlek',
        'PHOTOS' => 'Bilder',
        'XS_PHOTOS' => '%s\'s Bilder',
        'XS_PHOTO' => '%s\'s Bild',
        'YOU_CAN_MARK_PHOTO' => 'Du kan markera valfri bild som favorit.  Klicka bara på ikonen "Lägg till i Favoriter" när du ser den på en bild.',
        'VIEW_RECENT_PHOTOS' => 'Visa Senaste Bilderna',
        'APPROVE_PHOTOS' => 'Godkänn Bilder',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Ta bort Alla %s\'s Bilder?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Är det säkert att du vill ta bort alla bilder av %s?  Denna bearbetning kan ta några minuter.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Avlägsna %1$s och hela %1$s\'s innehåll från ditt sociala  nätverk',
        'SUCCESS' => 'Framgång.',
        'DELETING_CONTENT' => 'Tar bort Innehåll…',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Håll detta webbläsarfönster öppet medan innehållet tas bort.  Denna bearbetning kan ta några minuter.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Håll detta webbläsarfönster öppet medan medlemmar tas bort.  Denna bearbetning kan ta några minuter.',
        'DELETE_ALL_XS_PHOTOS' => 'Ta bort Alla %s\'s Bilder',
        'CREATE_A_NEW_ALBUM' => 'Skapa ett Nytt Album',
        'VIEW_ALL_XS_ALBUMS' => 'Visa Alla %s\'s Album',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Du har ännu inte lagt till några bilder.  Lägg till några bilder för att komma igång!',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s har ännu inte lagt till några bilder.',
        'MY_FRIENDS_PHOTOS' => 'Mina Vänners Bilder',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Visa dessa bilder i ett bildspel!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Dina vänner har ännu inga bilder',
        'ALL_PHOTOS_TAGGED_X' => 'Alla Bilder Taggade \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Alla Bilder Taggade <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'Det finns inga taggade bilder "%1$s".  Titta på <a %2$s>taggade diskussioner "%1$s"</a> eller <a %3$s>taggade videor "%1$s"</a>.  Eller lägg till och tagga dina egna bilder!',
        'SELECT_YOUR_PHOTOS' => 'Välj Dina Bilder',
        'PHOTO_MAY_BE_10MB' => 'En bild kan vara på upp till 10 MB men små bilder laddas upp snabbare. Vi stödjer bilder i .jpg, .gif och .png format.',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Håll denna sida öppen så vi kan avsluta uppladdning av dina bilder och vi meddelar dig när de blivit godkända!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Under tiden får du gärna <a %s>öppna ett nytt fönster</a> och fortsätta använda %s.  När uppladdningen är klar kommer du att kunna lägga till titlar och beskrivningar på dina bilder i detta fönster.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Denna bild <strong>väntar på godkännande</strong> från %s\'s skapare.',
        'ADD_TO_FAVORITES' => 'Lägg till i Favoriter',
        'EDIT_PHOTO' => 'Ändra Bild',
        'DELETE_PHOTO' => 'Ta bort Bild',
        'ABOUT_THIS_PHOTO' => 'Om Denna Bild',
        'LOCATION_OF_PHOTO' => 'Plats för denna bild:',
        'ALBUMS_FEATURING_PHOTO' => 'Album som Uppmärksammar Denna Bild',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Visa Alla Album med Denna Bild',
        'RETURN_TO_X' => 'Tillbaka till %s',
        'RETURN_TO_PHOTOS_HOME' => 'Tillbaka till Start för Bilder',
        'WE_COULD_NOT_FIND_ANYONE' => 'Vi beklagar – vi kunde inte hitta någon',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Ingen har lagt till några bilder ännu!  Lägg till några bilder för att komma igång.',
        'DEFAULT_TITLE' => 'Titel',
        'DEFAULT_DESCRIPTION' => 'Beskrivning',
        'UPLOAD_LIMIT_EXCEEDED' => 'Gränsen för den uppladdade filens storlek överskreds.',
        'SLOW_DOWN_THERE_CHIEF' => 'Vi beklagar',
        'I_DO_NOT_KNOW_USER' => 'Jag känner tyvärr inte denna person.',
        'I_DO_NOT_HAVE_PHOTO' => 'Jag har tyvärr inte denna bild.',
        'I_DO_NOT_HAVE_ALBUM' => 'Jag har tyvärr inte detta album.',
        'ALBUM_BY_X_ON_X' => 'Album av %s på %s',
        'SENT' => 'Sänd!',
        'I_HAVE_RECENTLY_ADDED' => 'Jag har Nyligen Lagt till',
        'FROM_THE_BAZEL' => 'Från Detta Nätverk',
        'RECENTLY_ADDED' => 'Nyligen Tillagda',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Senaste offentliga bilderna på %s',
        'X_ALL_PHOTOS' => '%s – Alla Bilder',
        'NO_TAG_WAS_SPECIFIED' => 'Ingen tagg angavs',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Offentliga bilder taggade med %s på %s',
        'XS_PUBLIC_PHOTOS_ON_X' => '%s\'s offentliga bilder på %s',
        'WE_DO_NOT_KNOW_USER' => 'Vi känner inte till denna person.',
        'XS_FRIENDS_PHOTOS' => '%s\'s Vänners Bilder',
        'XS_FAVORITE_PHOTOS_ON_X' => '%s\'s favoritbilder på %s',
        'PHOTO_UPLOADED_ON_X' => 'Bild uppladdad på %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'Filen överskrider den maximala storleken',
        'PART_OF_FILE_WAS_UPLOADED' => 'Endast en del av filen laddades upp',
        'NO_FILE_WAS_UPLOADED' => 'Uppladdningen misslyckades;  filnamnet kan ha varit felaktigt',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Ett problem uppstod under uppladdningen.',
        'ALPHABETICAL' => 'Alfabetisk',
        'MOST_VIEWS' => 'Flest Visningar',
        'RATING_NOT_RATED_YET' => '<strong>Klassning:</strong> Ej klassad ännu',
        'NOT_RATED_YET' => 'Ej klassad ännu',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm…  något gick snett',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Din bild med titeln "%s" kunde inte läggas till i %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Din bild kunde inte läggas till i %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Du försökte just sända in en bild till %s.  Du är tyvärr inte medlem i %s och vi kan inte leverera denna bild.',
        'ONLY_MY_FRIENDS' => 'Endast Mina Vänner',
        'ANYBODY' => 'Vem som helst',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Endast mina vänner kan se denna bild',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Endast %s\'s vänner kan se denna bild',
        'ONLY_I_CAN_SEE_PHOTO' => 'Endast jag kan se denna bild',
        'ONLY_X_CAN_SEE_PHOTO' => 'Endast %s kan se denna bild',
        'EVERYONE_CAN_SEE_PHOTO' => 'Alla kan se denna bild',
        'PRIVATE_PHOTO' => '<strong>Privat</strong> bild',
        'HOWDY_STRANGER' => 'Hej, Främling!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Du måste logga in på Ning innan du kan göra detta.',
        'JUST_CLICK_ON_SIGN_IN' => 'Klicka bara på "Logga In" ovan, eller om du ännu inte har ett Ning-konto, klicka på "Registrera".',
        'YOU_NEED_TO_BE_' => 'Du måste vara %s för att göra detta.',
        'YOU_NEED_TO_BE_OWNER' => 'Du måste vara nätverkets skapare för att göra detta.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Denna bild väntar på godkännande.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Du måste vara en vän till %s för att göra detta.',
        'MOST_ACTIVE' => 'Mest Aktiv',
        'HOW_IT_WORKS' => 'Hur det fungerar',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Fler sätt att lägga till bilder…',
        'BY_PHONE_OR_EMAIL' => '… via telefon eller e-post',
        'FROM_FLICKR' => '…från Flickr',
        'FROM_YOUR_COMPUTER' => '…från din dator',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Lägg till bilder från ditt Flickr-konto.',
        'MORE_INFORMATION' => 'Mer Information',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Lägg till bilder via telefon eller e-post',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Skicka en bild eller video via e-post.  E-postens ämne blir titeln för bilden eller videon, och brödtexten blir beskrivningen.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Klicka här för att få en ny e-postadress',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Ladda upp bilder från din dator.',
        'PHOTO' => 'bild',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Du visar för närvarande inga bilder.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Denna ruta visas inte för andra personer om du inte väljer åtminstone en bild.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'Det finns en ny kommentar till din bild "%s" på %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'Det finns en ny kommentar till en av dina bilder på %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'någon kommenterade en bild du har lagt till i %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'någon har laddat upp en bild till %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Lägg till bilder eller videor till %s direkt från din telefon genom att sända dem till en e-postadress.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Vill du verkligen ta bort denna artikel från dina favoriter?',
        'DELETE_THIS_PHOTO_Q' => 'Ta bort denna bild?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Är du säker på att du vill ta bort denna bild?  Denna bearbetning kan ta några minuter.',
        'PHOTO_SLIDESHOW' => 'Bildspel',
        'THUMBNAILS' => 'Miniatyrer',
        'DETAIL' => 'Detalj',
        'TAG' => 'Tagg',
        'RATE' => 'Hastighet',
        'ALL_SIZES' => 'Alla Storlekar',
        'ADD_TO_ALBUM' => 'Lägg till i Album',
        'ROTATE_PHOTO' => 'Rotera Bild',
        'ABOUT_YOUR_PHOTO' => 'Om Din Bild',
        'SEE_PHOTOS_ON_NETWORK' => 'Se dessa bilder på %s',
        'EMBED_CODE' => 'Bädda in Kod',
        'IMPORT_PHOTOS_FLICKR' => 'Hämta Dina Bilder från Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Klicka här för att fortsätta till Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'För att hämta dina bilder från Flickr, måste du först låta %S länka till ditt Flickr-konto.',
        'IMPORT_PHOTOS' => 'Importera Bilder',
        'GET_MY' => 'Hämta min',
        'GET_PHOTOS' => 'Hämta Bilder',
        'MOST_RECENT_PHOTOS' => 'senaste bilderna',
        'GET_ALL_MY_FLICKR' => 'Hämta alla mina bilder från Flickr (kan ta en stund)',
        'GET_ALL_MY_TAGGED' => 'Hämta alla mina bilder taggade',
        'GET_PHOTOS_FROM_SET' => 'Hämta bilder från ett set:',
        'GET_STARTED_BY_IMPORT' => 'Vi kommer automatiskt att få dina titlar, taggar och den mapping-information du kan ha. <br/>Hur lång tid tar det? </p> <p><ul style="padding-top:10px; "><li>10 Bilder: <em>mindre än 30 sekunder</em>. </li><li>50 Bilder: <em>cirka 2 minuter</em>. </li><li>200 Bilder: <em>cirka 6 minuter</em>. </li><li>500 bilder: <em>cirka 15 minuter</em>. </li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Om du inte loggat in på Flickr, blir du ombedd att logga in.  När du väl loggat in, klicka på knappen med texten "OK, jag tillåter det".',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Hämta beskrivningar också (detta fördubblar tiden det tar).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Håll denna sida öppen så vi kan avsluta import av dina bilder.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Hämta fullstora versioner av varje bild (detta kommer att väsentligt öka tiden för import och vi rekommenderar det inte för mer än 20 bilder).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Klicka på ”edit” för att lägga till text, videor, bilder eller någon widget till denna ruta.  Det är ett annat sätt som du kan göra din %s sida till din egen.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Denna ruta visas inte för andra personer förrän du har uppdaterat dess innehåll.',
        'YOUR_X_BOX' => 'Din %s Ruta',
        'ABOUT_WIDGETS' => 'Om Widgets',
        'HELP' => 'Hjälp',
        'WIDGETS' => 'Widgets',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Vill du lägga till mer funktioner till ditt sociala nätverk?  Kanske en kalender, lokal väderrapport, händelseräknare eller webbkamera?  Med widgets är det lätt att lägga till ytterligare funktioner till någon Textruta i ditt nätverk.',
        'GETTING_STARTED' => 'Komma igång',
        'BELOW_IS_LIST_OF_WIDGET' => 'Nedan finns en <a %s>lista med källor för widgets</a> som du kanske vill undersöka.  Vi har valt några widgets från <a %s>yourminis. com</a> för att du skall komma igång.  Ställ bara in en widget nedan, kopiera den inbäddade koden och klistra in den direkt i Textrutan.  Sätt igång!',
        'CALENDAR' => 'Kalender',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'Kalender-widgeten visar inte bara datum, utan låter dig också söka och lägga till händelser i iCal-format (används av Google-Calendar och många andra kalenderkällor online).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Använd &#8221;ändra widget&#8221;  knapp för att välja &#8221;sök händelser&#8221; , ange sedan ett sökord (försök semestrar, ett idrottslag, etc. ). Sedan väljer du bara ett sökresultat för att dessa händelser skall läggas till i din kalender.  Du kan också manuellt lägga in adressen till någon befintlig iCal-inmatning.',
        'CUSTOMIZATION' => 'Anpassning',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Du kan anpassa utseende på widgeten genom att hålla musen över den, sedan klicka på färgväljarikonen för att ändra bakgrund, widget-stil och grad av transparens.  När du är klar, klicka på &#8221;kopiera till webb&#8221;  länk, sedan &#8221;kopiera inbäddad kod&#8221;  knapp.  När koden väl kopierats, gå då bara tillbaka till någon Textruta i ditt nätverk, kopiera in koden och spara dina ändringar.  Allt klart!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Skaffa fler widgets från yourminis. com »',
        'WEATHER' => 'Väder',
        'WEATHER_WIDGET_DISPLAYS' => 'Väder-widgeten visar lokala väderprognoser från Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Använd &#8221;ändra widget&#8221;  knapp för att välja din vistelseort och välja Fahrenheit eller Celsius.  Du kan välja att visa vädret för just den aktuella dagen eller utöka visningen till en 5-dygnsprognos.',
        'COUNTDOWN' => 'Nedräkning',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Nedräknings-widgeten låter dig skapa en nedräkning inför en speciell händelse.  Genom att klicka på &#8221;ändra widget&#8221;  knappen, kan du ange datum, tid och titel eller bild för en händelse att räkna ned inför.',
        'WEBCAM' => 'Webbkamera',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Webbkamera-widgeten låter dig aktivt övervaka vilken offentligt tillgänglig webbkamera som helst.  Använd &#8221;ändra widget&#8221;  knapp för att välja från en lista med fördefinierade webbkameror, eller manuellt ange någon webbkameras URL.',
        'MORE_WIDGETS' => 'Fler Widgets',
        'NEED_MORE_OPTIONS' => 'Behöver du fler alternativ?  Vi rekommenderar något av följande ställen för att släcka din törst efter widgets:',
        'MODERATION_DENIED_ON_X' => 'Moderering nekad på %s på %s',
        'MODERATION_DENIED_ON_A_X' => 'Moderering nekad på en av dina %s på %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Du har en ny %s att moderera på %s',
        'NEW_X_TO_MODERATE' => 'Det finns en ny %s för dig att moderera.',
        'MODERATION_APPROVED_ON_X' => 'Moderering godkänd på %s på %s',
        'MODERATION_APPROVED_ON_A_X' => 'Moderering godkänd på en av dina %s på %s',
        'JOIN' => 'Gå med',
        'WELCOME' => 'Välkommen',
        'WELCOME_TO_X' => 'Välkommen till %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Välkommen till %s…',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Nya Funktioner! </h3>
            <ul><li><strong>Grupper</strong> &ndash;  Låt dina medlemmar skapa grupper på ditt nätverk</li>
                <li><strong>Musikspelare</strong> &ndash;  Lägg till musik och podcaster till ditt nätverk</li></ul>
            <p><a href="%s" class="desc add">Klicka här för att lägga till funktioner</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Nya Funktioner! </h3>
            <ul><li><strong>Senaste Aktivitet</strong> &ndash;  Följ den senaste medlemsaktiviteten på ditt nätverk</li>
                <li><strong>Emblem & Widgets</strong> &ndash;  Marknadsför ditt nätverk på webben med skräddarsydda emblem och widgets</li></ul>
            <p><a href="%s" class="desc add">Klicka här för att lägga till ytterligare funktioner</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Din %2$s, %1$s, har en ny kommentar som lagts till av någon på %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Din %1$s har en ny kommentar som lagts till av någon på %2$s!',
        'HERE_IS_LINK' => 'Här är länken du kan ansluta dig till: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Tack,',
        'THANKS' => 'Tack!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Du ändrade din e-postadress på %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Du ändrade din e-postadress på %s…',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Klicka här för att logga in med din nya e-postadress:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Om du inte ändrade din e-postadress, klicka här:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'För att stoppa meddelanden om nya diskussioner, gå till:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s startade en ny diskussion på %2$s…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s startade diskussionen "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'För att visa denna diskussion, gå till:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s har bjudit in dig att gå med %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s vill att du kollar på "%s" på %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Kolla på "%s" på %s!',
        'ABOUT_X' => 'Om %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Du har fått denna e-post på grund av %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Om du inte längre vill ha e-post med meddelanden från %s, <a %s>klicka här</a>.',
        'CLICK_HERE' => 'Klicka Här',
        'YOU_CAN_CONTACT_US' => 'Du kan kontakta oss med vilka frågor eller undringar som helst om din integritet på http://help.ning.com/?page_id=27 .',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Ett meddelande till alla medlemmar i %s',
        'CLICK_TO_CHECK_OUT' => 'Klicka här för att kolla!',
        'CLICK_TO_APPROVE_X' => 'Klicka här för att godkänna/ta bort detta %s',
        'YOUR_X_HAS_BEEN_APPROVED' => 'Din %s har godkänts på %s!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Din %s godkändes inte på %s.',
        'CLICK_TO_VIEW_X' => 'Klicka här för att visa detta %s!',
        'CLICK_TO_VIEW_IT' => 'Klicka här för att visa det!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'För att visa %s\'s profil, besök:',
        'YOU_ADDED_CONTENT' => 'du lade till innehåll till %s, ett modererat socialt nätverk',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s har rapporterat en fråga på %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s rapporterade följande fråga.',
        'URL_REPORTED_COLON' => 'URL Rapporterade:',
        'ISSUE_COLON' => 'Fråga:',
        'ADDITIONAL_INFORMATION_COLON' => 'Ytterligare information:',
        'SEND_AN_INVITATION_TO_X' => 'Sänd en inbjudan till %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'någon har bett att få gå med i %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Vill du lägga till ett välkomstmeddelande för %s på deras profil?   Gå till:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s har sänt dig ett meddelande.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'För att läsa detta meddelande, besök:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s har sänt dig ett meddelande på %s…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s har lagt till dig som en vän...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s har lagt till dig som en vän på %s...',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s har accepterat din vänförfrågan på %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'För att acceptera denna vänförfrågan, besök:',
        'VIEW_XS_PAGE_ON_Y' => 'Visa %s\'s sida på %s',
        'MEMBER_OF_X_ACCEPTED' => 'en medlem i %s accepterade din vänförfrågan',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Om du inte längre vill få e-postmeddelanden med vänförfrågningar från %s, <a %s>klicka här</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Du erhöll denna inbjudan från en medlem i %1$s.  om du inte vill få inbjudningar från %1$s, kontakta oss på http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => 'På %s:',
        'ON_X' => 'på %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s har begärt medlemskap i %s.',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s har bjudit in dig att gå med i Gruppen "%2$s"',
        'VISIT_GROUP_AT' => 'Besök %s på:',
        'ABOUT_GROUP' => 'Om %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Ett meddelande från %s till alla medlemmar i %s på %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Du kan logga in med din e-postadress här:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s kommenterade bloggposten \'%s\' på %s',
        'SEND_X_A_MESSAGE_HERE' => 'Skicka %s ett meddelande här:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Du har en ny medlem att godkänna på %s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Du har en ny medlem att godkänna.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'För att godkänna %s\'s profil, besök:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Kan du inte klicka på länken ovan?  Kopiera helt enkelt och klistra in URL-en i din webbläsare.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Klicka här för att gå med:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Klicka här för att gå med!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Ditt %s medlemsskap har godkänts…',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Gratulerar!   Ditt %s medlemsskap har godkänts.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Du kan nu logga in med din e-postadress här:',
        'VISIT_X_AT_Y' => 'Besök %1$s vid: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'För att kontrollera vilken e-post du får på %1$s, gå till:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'En avstängd medlem har sänt dig ett meddelande på %s…',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'En avstängd medlem har sänt dig ett meddelande på %1$s.   %2$s skriver:',
        'WELCOME_TO_THE_GROUP_X' => 'Välkommen till Klubben "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Välkommen till %1$s på %2$s…',
        'TO_VIEW_THIS_GROUP_VISIT' => 'För att visa denna grupp, besök:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s inbjuder dig att gå med %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s är nu en medlem i %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$sâ är nu en medlem i %2$s…',
        'SOMEBODY' => 'Någon',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'För att visa din nya kommentar, besök:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'För att visa den nya kommentaren, besök:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'För att visa det nya svaret, besök:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Välkommen till %s!  Tack för att du går med.',
        'NAME_COLON' => 'Namn:',
        'EMAIL_COLON' => 'E-post:',
        'AGE_COLON' => 'Ålder:',
        'GENDER_COLON' => 'Kön:',
        'LOCATION_COLON' => 'Plats:',
        'COUNTRY_COLON' => 'Land:',
        'GET_NETWORK_BADGE' => '%s Emblem',
        'SPREAD_WORD_GET_BADGE' => 'Skicka informationen vidare.  Skaffa ditt eget %s emblem till din webbsida eller MySpace-sida.  (<a %s>Skaffa Kod</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Skicka informationen vidare.  <a href="%s">Skaffa ditt eget %s emblem</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Visa din lojalitet.  Skaffa ditt eget %s emblem att sättas på din webbsida eller MySpace-sida.  (<a %s>Skaffa Kod</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s lämnade kommentar på %2$s "%4$s" på %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Vi ber om ursäkt â€“ Vi kunde inte extrahera några e-postadresser från filen.',
        'ADMINISTRATORS' => 'Administratörer',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Din Inbjudan Har Upphört att gälla',
        'SORRY_INVITATION_EXPIRED' => 'Vi beklagar, den inbjudan du har använt har upphört att gälla.   Du behöver en ny inbjudan för att gå med %s.',
        'DISABLE_INVITATION_LINK' => 'Inaktivera Länk till Inbjudan?',
        'CREATING_LINK_WILL_DISABLE' => 'Skapande av ny länk för inbjudan kommer att inaktivera den nuvarande länken.  Är du säker på att du vill skapa en ny länk?',
        'SHARE_LINK_WITH_PEOPLE' => 'Dela denna länk med personer du vill ska gå med i detta nätverk:',
        'CREATE_INVITATION_LINK' => 'Skapa Ny Länk för Inbjudan',
        'PLEASE_SELECT_SECOND_PART' => 'Välj den andra delen av din e-postadress, t.ex. gmail. com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Se till att @-symbolen inte finns i den första delen av e-postadressen.',
        'SORRY_WE_DONT_SUPPORT' => 'Vi stöder tyvärr inte webbadressboken för dina e-postadresser.  Försök att klicka på \'E-postprogram\' nedan för att använda adresser från din dator.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Ange ditt lösenord för %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importerar Adressbok',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Lämna detta fönster öppet</strong> medan vi hämtar din väns e-postadresser.  När vi är klara, kan du välja vilka vänner du vill bjuda in.',
        'SHARE_THIS_LINK' => 'Dela denna länk:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Sänd den med din dators e-postprogram:',
        'EMAIL_THIS' => 'E-posta detta',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(är din vän)',
        'CLEAR' => 'Avmarkera',
        'SEARCH_FRIENDS_TO_INVITE' => 'Sök efter vänner att Bjuda in:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Dina Inbjudningar har Skickats',
        'WANT_TO_INVITE_MORE' => 'Vill du bjuda in fler vänner?  Bjud in fler vänner genom att importera kontakter från din webb-adressbok eller ditt e-postprogram.',
        'MESSAGE_TOO_LONG' => 'Ditt meddelande är för långt. Använd färre än %s bokstäver.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Det följande tycks inte vara giltiga e-postadresser.  Inbjudningarna sändes inte.  Korrigera e-postadresserna och försök igen.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Ange en eller flera e-postadresser.',
        'ENTER_EMAIL_ADDRESSES' => 'Ange E-postadresser',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Avdela multipla adresser med kommatecken',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Ditt Meddelande</label> (Valfritt)',
        'SEND_INVITATIONS' => 'Skicka inbjudningar',
        'WEB_ADDRESS_BOOK' => 'Webb-adressbok',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail eller AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Din E-postadress',
        'IMPORT_ADDRESS_BOOK' => 'Importera Adressbok',
        'DONT_WORRY_WE_WONT_SAVE' => 'Var inte orolig, vi kommer inte att spara ditt lösenord och du kommer att få möjlighet att välja vilka vänner du vill skicka e-post till.',
        'EMAIL_APPLICATION' => 'E-postprogram',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, . CSV, etc.',
        'UPLOAD_CSV_OR_VCF' => 'Ladda upp en . csv eller . vcf-fil exporterad från Microsoft Outlook eller Apple Address Book.',
        'BROWSE_FOR_FILE' => 'Bläddra Efter Fil',
        'UPLOAD' => 'Ladda upp',
        'SELECT_ELLIPSIS' => 'välj...',
        'OTHER_ELLIPSIS' => 'annan...',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Var inte orolig, du kommer att få möjlighet att välja vilka vänner du vill e-posta.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Endast Medlemsskap genom Inbjudan',
        'IF_YOU_ARE_ADMIN' => 'Om du är administratör, <a %s>klicka här för att logga in</a>.',
        'NAME_MUST_BE_SHORTER' => 'Namn måste vara kortare än %s tecken',
        'CITY_NAME_MUST_BE_SHORTER' => 'Stadsnamn måste vara kortare än %s tecken',
        'EMAIL_ALREADY_REGISTERED' => 'E-postadressen har redan registrerats.  Välj någon annan.',
        'EMAIL_NOT_VALID' => 'E-postadressen tycks inte vara giltig.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s bjuder in dig till %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Du loggar in med din Ning-ID.',
        'NOW_ENTER_PASSWORD' => 'Ange nu bara ditt lösenord för att fortsätta.',
        'OR_SIGN_IN' => 'eller <a %s>Logga In</a>',
        'CHANGE_ADDRESS' => 'Ändra Adress',
        'CHANGE_PAGE_ADDRESS' => 'Ändra Sidadress',
        'PAGE_ADDRESS_TAKEN' => 'Vi beklagar - denna adress är redan upptagen.  Välj någon annan.',
        'PAGE_ADDRESS_NOT_VALID' => 'Du kan endast använda bokstäverna A-Z, siffror och understreck (_) i din adress.',
        'ADD_BY_PHONE' => 'Lägg till Via Telefon',
        'PAGE_ADDRESS' => 'Sidadress',
        'PHOTO_MUST_BE_TYPE' => 'Din bild måste vara en . jpg, . gif eller . Png-fil.',
        'USEFUL_ADDRESSES' => 'Användbara Adresser',
        'MY_DETAILS' => 'Mina Detaljer',
        'NONE_I_DO_NOT_WANT' => 'Inga: Jag vill inte ta emot e-post från %s',
        'CHANGE_PASSWORD' => 'Ändra Lösenord',
        'PROFILE_SAVED' => 'Dina förändringar sparades utan problem.',
        'UPDATE_EMAIL_ADDRESS' => 'Uppdatera E-postadress',
        'EDIT_EMAIL_ADDRESS' => 'Ändra Din E-postadress',
        'MY_SETTINGS' => 'Mina Inställningar',
        'ABOUT_ME' => 'Om Mig',
        'SELECT' => 'Välj…',
        'CITY' => 'Stad',
        'COUNTRY' => 'Land',
        'DATE_OF_BIRTH' => 'Födelsedatum',
        'DO_NOT_DISPLAY' => 'Visa Ej',
        'GENDER' => 'Kön',
        'CREATE_YOUR_PROFILE' => 'Skapa Din Profil',
        'SYSTEM_REQUIREMENTS' => 'Systemkrav',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Vi stödjer Internet Explorer 6 & 7, Firefox 2.0 och Safari 2.0. Om du använder en annan webbläsare (kanske en som tillhandahålls av din internetoperatör) är den eventuellt inte kompatibel.',
        'MAKE_SURE_COOKIES' => 'Se till att cookies och JavaScript aktiverats i din webbläsare.',
        'WHAT_IS_MY_EMAIL' => 'Vilken är min E-postadress?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Om du gick med före 5 oktober 2007, kan du tidigare ha uppmanats att ange ett \'Ning-ID\'.  Vi ber dig nu att logga in med den e-postadress du använde vid din registrering, men du kan fortfarande ange din Ning-ID i detta fält.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Klicka här för att återställa ditt lösenord.',
        'STILL_HAVING_PROBLEMS' => 'Har du fortfarande problem?',
        'VISIT_NING_HELP_CENTER' => 'Besök <a %s>Ning Hjälpcenter</a> för ytterligare felsökningsinformation och hjälp.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problem vid Registrering eller Inloggning',
        'WE_SENT_YOU_EMAIL' => 'Vi har sänt e-post till dig med en länk för återställning av ditt lösenord.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Återställning av Lösenord',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

Vi har fått en begäran att ändra ditt lösenord på %2$s.

Klicka på länken nedan för att bestämma ett nytt lösenord:

#{URL}

Om du inte vill ändra ditt lösenord, kan du bortse från denna e-post.

Tack,
 "%2$s" Gruppen

-----
%2$s använder Ning-ID för autentisering.',
        'SET_PASSWORD' => 'Bestäm Lösenord',
        'NEW_PASSWORD' => 'Nytt Lösenord',
        'CREATE_NEW_PASSWORD' => 'Skapa ett Nytt Lösenord',
        'CHOOSE_NEW_PASSWORD' => 'Välj ett nytt lösenord',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Hej, %s</strong> (<a %s>Logga Ut</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Det finns inget konto med e-postadressen %s',
        'PLEASE_ENTER_CODE' => 'Ange koden som finns på den högra sidan.',
        'PROBLEMS_SIGNING_UP' => 'Problem med att logga in?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Genom att registrera dig, accepterar du <a %s>Villkoren för Tjänst</a> och <a %s>Integritet&nbsp; Policy</a>.',
        'FEEDBACK' => 'Feedback',
        'TERMS_OF_SERVICE' => 'Användningsvillkor',
        'PROBLEM_SIGNING_UP' => 'Ett problem uppstod vid inloggning',
        'ALREADY_MEMBER_SIGN_IN' => 'Redan medlem?  <a %s>Klicka här för att logga in</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Medlemskap i %s sker Endast Genom Inbjudan',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Vi beklagar, men administratören har valt att kräva en inbjudan för att du ska få gå med i %s.  Om du har en inbjudan, klicka på länken i e-postmeddelandet för att gå med.',
        'PROBLEM_SIGNING_IN' => 'Ett problem uppstod vid inloggning',
        'WE_USE_NING_ID' => 'Vi använder Ning-ID for autentisering.  <a %s>Vad är ett Ning-ID? </a>',
        'PROBLEMS_SIGNING_IN' => 'Problem med att logga in?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Logga In" /> &#160; eller&#160;  <strong><a %s>Logga in</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Logga in på %s',
        'WHAT_IS_A_NING_ID' => 'Vad är ett Ning-ID?',
        'LARR_BACK' => '← <a %s>Tillbaka</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Ning-ID autentisering låter dig en gång välja en e-postadress och lösenord och använda det för att gå med i eller logga på något socialt nätverk som använder Ning-ID.',
        'WHEN_YOU_CREATE_NING_ID' => 'När du skapar ett Ning-ID, kan du också lägga till en uppsättning basinformation och din bild till Ning-ID kontot.  Denna information är sedan ifyllda på förhand närhelst du går med i ett nytt socialt nätverk som använder Ning-ID som autentisering.  Den gör det också möjligt för dig att hålla koll på dina vänner och meddelanden i samtliga sociala nätverk som kan använda den.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Du kan logga in med din Ning-ID e-postadress och lösenord, närhelst du ser denna symbol: %s',
        'HELLO_USER' => 'Hej, %s',
        'TEXT_FOR_HEADER_TAB' => 'Denna text är avsedd för en rubrikflik',
        'BASED_ON' => 'Baserad på',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Är du säker på att du vill ta bort detta språk?',
        'DELETE_LANGUAGE' => 'Ta bort Språk',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'Texten har återställts till sin ursprungliga version.',
        'UPLOAD_LANGUAGE_FILE' => 'Ladda upp Språkfil',
        'ADD_TO_LANGUAGE' => 'Lägg till i Språk:',
        'IF_YOU_CREATED_TRANSLATION' => 'om du skapat en ny översättning eller ett annat socialt Ning-nätverk, kan du importera ditt arbete här.  Innehållet i filen kommer att läggas till det språk du valt.  Ser du inte de listade språken?  <a %s>Det är lätt att lägga till ett nytt</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Exampel: Svenska (Finland), Filipinska, Spanska (Puerto Rico)',
        'START_FROM_SCRATCH_CREATE' => 'Börja om från början!  Skapa en ny översättning för ditt nätverk genom att ange ett namn för det nya språket, och sedan att välja ett existerande språk som referenspunkt.',
        'KEY_MISSING_TEXT' => 'Nyckel: <span %s>Saknad Text</span> <span %s>Ändrad text</span>',
        'SHOW_ALL_TEXT' => 'Visa All Text',
        'SHOW_MISSING_TEXT' => 'Visa Saknad Text',
        'SHOW_CHANGED_TEXT' => 'Visa Förändrad Text',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Exempel: Flikar, Medlemmar, Vänner',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Återställ Text till Ursprunglig Version',
        'ORIGINAL_TEXT_X' => 'Ursprunglig Text – %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Ändra Språk i Ditt Nätverk',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Anpassa någon av texterna på ditt nätverk, inklusive fliknamnen, sidfötterna i e-posten, felmeddelanden och mer.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>Det aktiva språket för ditt nätverk är %1$s</em>.  <a %2$s>Ändra Aktivt Språk</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Aktuella Språkalternativ',
        'ACTIVE' => 'Aktiv',
        'MY_LANGUAGES' => 'Mina språk',
        'CREATE_NEW_TRANSLATION' => 'Skapa en ny översättning',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Ser du inte ditt språk listat ovan?  <strong><a %s>Skapa en ny översättning för ditt nätverk</a></strong>.',
        'ADVANCED_IMPORT' => 'Avancerad Import',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Om du har översatt ett språk på ett befintligt nätverk, kan du <strong><a %s>importera din språkfil</a></strong> och använda den på detta nätverk.',
        'LANGUAGE_EDITOR' => 'Språkredigeringsprogram',
        'PUBLIC' => 'Offentlig',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Din aktuella integritetsinställning som är ett offentligt nätverk där icke-medlemmar bara kan se inloggningsbildskärmen, är inte längre tillgängligt.   Din integritetsinställning har inte ändrats, men om du gör några ändringar här kan du inte gå tillbaka.   Den aktuella motsvarigheten är ett privat nätverk där vem som helst kan registrera sig och bli medlem.',
        'NO_MISSING_ITEMS' => 'Inga punkter saknas – översättningen är 100%% klar.  <a %s>Visa alla artiklar. </a>',
        'NO_CHANGED_ITEMS' => 'Inga artiklar har ändrats.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Vi beklagar – vi kunde inte hitta några artiklar som matchade <em>%s</em>.  <a %s>Visa alla artiklar. </a>',
        'FILE_N' => 'Fil %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'En Ning översättningsfil har ett filnamn som ser ut som <code>en_US. txt</code>.  <a %s>Lär dig mer här. </a>',
        'SELECT_TRANSLATION_FILE' => 'Markera översättningsfil:',
        'USE_THIS_TRANSLATION' => 'Använd översättningen',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Lägg märke till att följande saknas i reglerna nedan: %s',
        'ALL' => 'Alla',
        'MISSING' => 'Saknas',
        'VIEW' => 'Visa',
        'TRANSLATION_CHANGES_SAVED' => 'Dina ändringar har sparats.  Översättningen är %s%% klar.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Dina ändringar har sparats.  Översättningen är %s%% klar.  Vill du använda det som aktuellt språk för ditt nätverk?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Din uppladdning gick bra.  Översättningen är %s%% klar.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Din uppladdning gick bra.  Översättningen är %s%% klar.  Vill du använda det som aktuellt språk för ditt nätverk?',
        'X_IS_CURRENT_LANGUAGE' => '%s är nu språket för ditt nätverk.',
        'SAVE_PAGE' => 'Spara sidan',
        'LANGUAGE_NAME_TAKEN' => 'Vi beklagar – detta namn är redan upptaget.  Välj ett annat namn.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Ange ett namn för din nya översättning t.ex. portugisiska (Portugal)',
        'CREATE' => 'Skapa',
        'LANGUAGE_NAME' => 'Språkets namn',
        'SAVE_ITEMS_ON_PAGE' => 'Spara artiklarna på den här sidan',
        'NEW_TRANSLATION' => 'Ny översättning',
        'MISMATCHED_CURLY_BRACKETS' => 'Felmatchade svängda klamrar',
        'MISMATCHED_SQUARE_BRACKETS' => 'Felmatchade kantiga klamrar',
        'MISMATCHED_PARENTHESES' => 'Felmatchade parenteser',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Ett fel uppstod vid bearbetningen av specialreglerna.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Ett fel uppstod vid bearbetningen av reglerna för fliknamn.',
        'SPECIAL_RULES' => 'Specialregler',
        'TAB_NAMES' => 'Fliknamn',
        'SOURCE' => 'Källa',
        'LANGUAGE_EDITOR_X' => 'Språkredigeringsprogram: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Gå tillbaka till språkredigeringsprogrammet',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Anpassa nätverkets texter och meddelanden eller skapa ett nytt språk.',
        'STOPWORDS' => 'en | om | ett | är | som | hos | vara | av | com | de | one | för | från | hur | i | in | är | den | la | av | på | eller | det | den | denna | till | var | vad | när | var | vem | ska | med | und | den | www',
        'STOPWORDS_ARE' => '<a %s>Stoppord</a> är en extra lista med ord som kan filtreras bort från nätverksbeskrivningen vid skapandet av metataggen högst upp på varje sida.  Alternativ.',
        'I_AM_MEMBER' => 'Jag är medlem i:',
        'VIEW_PAGE_ON_APPNAME' => 'Visa min sida på <em>%s</em>',
        'VISIT_APPNAME' => 'Gå in på <em>%s</em>',
        'JOIN_US' => 'Bli medlem hos oss',
        'CREATED_BY_COLON' => 'Skapad av:',
        'GET_MORE_BADGES' => 'Skaffa fler emblem',
        'SHOW_LOGO' => 'Visa logotyp',
        'GALLERY' => 'Galleri',
        'BADGES' => 'Emblem',
        'MEMBER_BADGE' => 'Medlemsemblem',
        'WEAR_IT_WITH_PRIDE' => 'Bär det med stolthet!  Skaffa ett %s medlemsemblem som du kan visa på din hemsida eller på en Myspacesida.',
        'NETWORK_BADGE_LARGE' => 'Nätverksemblem (Stort)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Berätta för alla!  Skaffa ett %s emblem som uppdateras dynamiskt hos nätverkets populäraste medlemmar.  Lägg in den på din hemsida eller på en Myspacesida.',
        'NETWORK_BADGE_SMALL' => 'Nätverksemblem (Litet)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Berätta för alla!  Skaffa ett %s emblem som du kan visa på din hemsida eller en Myspacesida.',
        'PHOTO_SLIDESHOW_PROPER' => 'Bildspel med foton',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Visa ett urval av foton på en webbsida eller på en Myspacesida med vår snygga bildspelare.',
        'MUSIC_PLAYER' => 'Musikspelare',
        'PLAY_MUSIC_ON_WEBSITE' => 'Spela din egen musik på en webbsida eller på en Myspacesida med vår snygga musikspelare.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Lägg in en video på din hemsida eller på en MySpacesida.  Vill du ha fler alternativ?  <a href="%s">Se alla videos</a> on %s.',
        'LARGE_N_PIXELS_WIDE' => 'Stor - %d bildpunkter',
        'MEDIUM_N_PIXELS_WIDE' => 'Medelstor - %d bildpunkter',
        'SMALL_N_PIXELS_WIDE' => 'Liten - %d bildpunkter',
        'MY_MOST_RECENT' => 'Mina senaste',
        'APP_ICON' => 'App Ikon',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'För att bli medlem i %s måste du vara inbjuden',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s gav följande feedback:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s gav feedback på %2$s…',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Tack.   Ditt meddelande har skickats.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s vill gå med i %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s har begärt att %s bjuds in',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Din begäran har skickats till nätverkets skapare.',
        'TO_UNBAN_USERNAME_GO_TO' => 'För att tillåta %s, gå till:',
        'SEND_REQUEST' => 'Skicka begäran',
        'SEARCH' => 'Sök',
        'SEARCH_AGAIN' => 'Sök på nytt',
        'SEND_BROADCAST_MESSAGE' => 'Skicka ett broadcastmeddelande',
        'VERIFICATION_IMAGE' => 'Verifieringsbild',
        'UNDER_CONSTRUCTION' => 'Under uppbyggnad',
        'PROFILE_INFORMATION_SAVED' => 'Profilinformationen sparades',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'Profilinformationen i katalogen för ditt nätverk har sparats.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Det finns inget konto med den e-postadressen.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Fel lösenord.   Är Caps Lock på?',
        'OOPS_THAT' => 'Hoppsan – det fungerade inte.',
        'OOPS_THAT_DID_NOT_WORK' => 'Hoppsan – det fungerade inte. Försöka igen?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Hoppsan – det fungerade inte (%s).',
        'NOT_FOUND' => 'Hittades inte',
        'YOUR_SITES_FEATURE_LIST' => 'Listan över funktioner i ditt nätverk har sparats.',
        'ONE_LINE_ANSWER' => 'Svar på en rad',
        'LONGER_ANSWER' => 'Längre svar',
        'MULTIPLE_CHOICE' => 'Flerval',
        'DATE' => 'Datum',
        'WEBSITE_ADDRESS' => 'Webbadress',
        'EVERYTHING' => 'Allt',
        'JUST_THE_HOMEPAGE' => 'Bara förstasidan',
        'JUST_THE_SIGN_UP_PAGE' => 'Bara registreringssidan',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Dina ändringar har sparats.',
        'JOIN_ME_ON_X' => 'Gör mig sällskap på %s!',
        'NOT_ALLOWED' => 'Inte tillåtet',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Kom och gör mig sällskap på %s…',
        'X_NOT_VALID_EMAIL' => '%s är ingen godkänd e-postadress eller Ning ID',
        'USER_BANNED_FROM_NETWORK' => '%1$s har förbjudits att delta i nätverket.  <a %2$s>Skicka %1$s ett meddelande</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s är redan medlem i nätverket.  <a %2$s>Skicka %1$s ett meddelande</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Du kan som mest skicka %s på en gång.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Ange dina vänners e-postadresser eller Ning ID',
        'THERE_HAS_BEEN_AN_ERROR' => 'Ett fel har uppstått',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Dina inbjudningar har skickats.',
        'SEARCH_RESULTS' => 'Sökresultat',
        'INVITE_YOUR_FRIENDS' => 'Bjud in dina vänner',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Skicka inbjudan till dina vänner och låt dem bli medlemmar',
        'INVITATION' => 'Inbjudan',
        'ADD_FROM_ADDRESS' => 'Lägg till från adressboken',
        'TO' => 'Till:',
        'SEND_TO' => 'Skicka till',
        'SUBJECT' => 'Ämne',
        'YOUR_MESSAGE' => 'Ditt meddelande',
        'SEND' => 'Skicka',
        'REPORT_AN_ISSUE' => 'Rapportera en händelse',
        'TYPE_OF_ISSUE' => 'Typ av utleverans',
        'ADULT' => 'Vuxen',
        'ABUSIVE' => 'Oegentlig',
        'BUG' => 'Bugg',
        'FRAUD' => 'Bedrägeri',
        'SPAM' => 'Spam',
        'OTHER' => 'Annat',
        'DESCRIBE_YOUR_ISSUE' => 'Beskriv din utleverans',
        'SEND_REPORT' => 'Skicka rapport',
        'ADDED_BY_X_AT_X' => 'Inlagt av <a %s>%s</a> hos %s på %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Inlagt av <a %s>%s</a> på %s hos %s på %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Klicka för att visa',
        'COMMENT_FOR' => 'Kommentar till:',
        'COMMENT_ON' => 'Kommentar om:',
        'ACTION_BUTTON_FEATURE' => 'Funktion',
        'FEATURE_THIS_ON_YOUR' => 'Visa det på förstasidan',
        'ACTION_BUTTON_REMOVE' => 'Ta bort',
        'REMOVE' => 'Ta bort',
        'REMOVE_THIS_FROM_YOUR' => 'Ta bort det från förstasidan',
        'FEATURE_ON_HOME' => 'Förstasidesvisning',
        'REMOVE_FROM_HOME' => 'Ta bort från förstasidan',
        'ITEM_WILL_APPEAR' => 'Artikeln kommer att visas i markerade moduler på förstasidan',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Artikeln kommer inte längre att visas i markerade moduler på förstasidan.',
        'ADD_CONTENT' => 'Lägg till innehåll',
        'BROUGHT_TO_YOU_BY' => '%s levereras av %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Säg vad du tycker',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Har du ytterligare frågor eller vill kontakta Ning, klicka här:',
        'SEND_FEEDBACK' => 'Skicka feedback',
        'SIGN_OUT' => 'logga ut',
        'SIGN_OUT_TITLE' => 'Logga ut',
        'EDIT_MY_PROFILE' => 'Ändra profilsvar',
        'INVITE_MORE' => 'Bjud in fler',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Använd formuläret för att skicka feedback till <a %s>%s</a>, som skapat <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Din feedback',
        'NETWORK_INFORMATION' => 'Nätverksinformation',
        'ABOUT_YOUR_SITE' => 'Om ditt nätverk',
        'WELCOME_TO_YOUR_SITE' => 'Välkommen till ditt sociala nätverk!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Ändra nätverkets namn, beskrivning och annan information.',
        'TAGLINE' => 'Taggrad',
        'APPEARS_IN_HEADER' => 'Syns i rubriken på ditt nätverk.',
        'APPEARS_IN_EMAILS' => 'Visas i e-postmeddelanden och på andra ställen',
        'NETWORK_NAME' => 'Nätverkets namn',
        'DESCRIPTION' => 'Beskrivning',
        'KEYWORDS' => 'Nyckelord',
        'LANGUAGE' => 'Språk',
        'SEPARATE_EACH_KEYWORD' => 'Skilj nyckelorden åt med kommatecken',
        'ICON' => 'Ikon',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Ladda upp ett foto (GIF, JPG eller PNG) som kommer att omformas till en fyrkant.  Det kan ta några minuter innan fotot syns.',
        'SAVE_SETTINGS' => 'Spara inställningarna',
        'SUCCESS_EXCLAMATION' => 'Succé!',
        'FEATURES' => 'Funktioner',
        'ADD_FEATURES' => 'Lägg till funktioner i ditt nätverk',
        'ORGANIZE_FEATURES' => 'Organisera förstasidan genom att dra fram funktioner från listan nedan och placera ut dem på valfritt sätt.',
        'SKIP_FEATURES' => 'Klicka på <a href="%s">Hoppa över detta steg</a> för att fortsätta med standardinställningen och funktionerna.',
        'FEATURES_FOR_ALL_PAGES' => 'Funktioner som lagts in fältet kommer att synas på alla sidor i nätverket.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Anpassa det sociala nätverket genom att lägga till eller ta bort funktioner.',
        'ADJUST_YOUR_SITES_COLORS' => 'Anpassa nätverkets färger, bilder och övergripande stil.',
        'APPEARANCE' => 'Utseende',
        'PROFILE_QUESTIONS' => 'Profilfrågor',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Redigera frågor som medlemmarna får om sig själva.',
        'MESSAGE_SENT' => 'Meddelande skickat!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Ditt meddelande har skickats till alla medlemmar i nätverket.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Ditt meddelande har skickats till alla medlemmar i gruppen.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Ditt meddelande har skickats.  Vänta, det kan ta några minuter.',
        'BROADCAST_MESSAGE' => 'Meddelandeutsändning',
        'TRACK_VISITORS_AND_TRENDS' => 'Följ upp besökare och trender på ditt sociala nätverk.',
        'EDIT_SOURCE_CODE' => 'Redigera källkod',
        'TAKE_FULL_CONTROL' => 'Få fullständig kontroll över nätverkets funktioner genom att redigera källkoden.',
        'DELETE_THIS_SITE' => 'Ta bort det sociala nätverket',
        'MAIN_PAGE' => 'Förstasidan',
        'MAIN' => 'Förstasidan',
        'MAIN_TAB_TEXT' => 'Förstasidan',
        'MANAGE' => 'Hantera',
        'MANAGE_TAB_TEXT' => 'Hantera',
        'PAGE_TITLE' => 'Sidrubrik',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit.  Nunc scelerisque blandit dolor.  Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Redigera sidans utseende',
        'CHOOSE_A_THEME' => 'Välj ett tema för ditt sociala nätverk',
        'NOW_CUSTOMIZE_SITE' => 'Anpassa nu ditt sociala nätverk…',
        'THEME_SETTINGS' => 'Temainställningar',
        'ADVANCED' => 'Avancerad',
        'TOP_BAR_AND_FOOTER' => 'Sidhuvud och sidfot',
        'HEADER_AND_NAVIGATION' => 'Rubrik och sidnavigering',
        'ADD_A_LOGO' => 'Lägg till en logotyp',
        'THIS_IMAGE_WILL_REPLACE' => 'Bilden ersätter texten med nätverkets namn',
        'TABS' => 'Flikar',
        'TAB' => 'Flik',
        'SITE' => 'Nätverk',
        'SIDES' => 'Sidor',
        'BODY' => 'Brödtext',
        'SHOW_NING_LOGO' => 'Visa Ninglogotypen?',
        'LAUNCH' => 'STARTA!',
        'NING_ID' => 'Ning ID',
        'PASSWORD' => 'Lösenord',
        'RETYPE_PASSWORD' => 'Skriv lösenordet en gång till',
        'TYPE_CODE_ON_RIGHT' => 'Skriv koden<br />till höger',
        'JOIN_X' => 'Gå med i %s',
        'SIGN_UP_FOR_X' => 'Registrera dig på %s',
        'HAS_INVITED_YOU_TO_X' => 'har inbjudit dig att gå med i %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Väntar på godkännande',
        'NEW_MEMBER' => 'Ny medlem?',
        'JOIN_X_NOW' => 'Gå med i %s nu!',
        'HIDE_THIS_MESSAGE' => 'Dölj det här meddelandet',
        'PAGE_NOT_FOUND' => 'Sidan hittades inte',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Vi beklagar – sidan hittades inte',
        'FOLLOW_THESE_LINKS_TO' => 'Följ dessa länkar till ett antal saker som vi vet finns tillgängliga:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Alternativt kan du söka på det här sociala nätverket:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Om du får det här meddelande igen, <a %s>tala om det för oss. </a>',
        'GROUP_MEMBERS' => 'Gruppmedlemmar',
        'VIDEOS' => 'Videor',
        'BLOG' => 'Blogg',
        'ACCOUNT' => 'Konto',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Beklagar men vi har problem med den här sidan.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Följ <a %s>denna länk</a> till förstasidan.',
        'REQUEST_AN_INVITATION' => 'Be om en inbjudan',
        'NAME' => 'Namn',
        'EMAIL_ADDRESS' => 'E-postadress',
        'MESSAGE_OPTIONAL' => 'Meddelande (inte obligatoriskt)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Ledsen! </strong>  Men det är lätt att starta ett eget socialt nätverk.',
        'GET_YOUR_OWN_BAZEL' => 'Skapa ditt eget sociala nätverk!',
        'SITE_IS_NOT_READY' => 'Det här sociala nätverket är inte färdigt än!',
        'BAZEL_IS_BEING_SET_UP' => 'Det här sociala nätverket håller fortfarande på att bildas!',
        'SIGN_IN' => 'Logga in',
        'FORGOT_YOUR_PASSWORD' => 'Glömt lösenordet?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Glömt lösenordet?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Ange e-postadressen och klicka på Återställ lösenord.  Du får ett e-postmeddelande med en länk för att återställa lösenordet.',
        'RESET_PASSWORD' => 'Återställ lösenord',
        'EXPLORE' => 'Utforska',
        'SIGN_UP' => 'Registrera dig',
        'CONFIRM_PASSWORD' => 'Bekräfta lösenord',
        'VERIFICATION' => 'Låt oss få veta att du är <br />en person',
        'YOUR_PHOTO' => 'Ditt foto',
        'SUMMARY' => 'Sammanfattning',
        'YOUR_SITE_IS_READY' => 'Ditt sociala nätverk kan starta!   Standardinställningar används för de steg du hoppat över.  Gå tillbaka och gör ändringar eller klicka på  Starta! För att starta ditt nätverk.',
        'WHEN_YOU_ARE_FINISHED' => 'När du är klar, klicka på \'Visa layout\' för att se din skapelse!',
        'COMPLETE' => 'fullständigt',
        'INCOMPLETE' => 'ofullständigt',
        'VIEW_LAYOUT' => 'Visa layout',
        'CLEAR_CONTENTS' => 'Avmarkera innehåll',
        'ADD_MODULE' => 'Lägg till modul…',
        'ADD_COLUMNS' => 'Lägg till kolumner…',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Offentlig</strong> –  Vem som helst kan gå med',
        'PRIVATE_ONLY_INVITED' => '<strong>Privat</strong> – Bara inbjudna kan se det och gå med',
        'INVITATIONS' => 'Inbjudan',
        'MEMBERS_CAN_INVITE' => 'Medlemmar kan bjuda in andra personer att bli medlemmar.',
        'QUESTION_TITLE' => 'Frågerubrik',
        'ANSWER_TYPE' => 'Svarstyp',
        'REQUIRED' => 'Obligatorisk',
        'PRIVATE' => 'Privat',
        'CHOICES' => 'Val',
        'SEPARATE_EACH_CHOICE' => 'Skilj valen åt med kommatecken',
        'CAN_PICK_MORE' => 'Kan välja mer än en',
        'ADD_ANOTHER_QUESTION' => 'Lägg till en fråga',
        'WHAT_INFORMATION' => 'Vilka frågor vill du att dina medlemmar ska svara på när de går med i ditt nätverk?  Du kan organisera om frågorna nedan.  Klicka bara på frågan och dra den dit där du vill ha den.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Om du väljer "Obligatorisk" måste medlemmarna svara på frågan för att kunna gå med.  Om du väljer "Privat" kommer svaret bara att synas för dig och andra administratörer.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Vi kunde inte hitta något som matchar"%s".  Varför inte leta efter något annat?',
        'GET_CUSTOM_URL' => 'Skaffa en egen standard-URL, lägg till lagerutrymme och bandbredd eller ha egna annonser.',
        'VIEW_STATISTICS' => 'Visa statistik',
        'ADD_TRACKING_CODE' => '<a %s>Lägg till din egen sökkod</a>.',
        'TRACKING_CODE' => 'Sökkod',
        'ANY_JAVASCRIPT_CODE' => 'JavaScript-kod som du klistrar in här kommer den att fogas in längst ner på varje sida i nätverket.  Du kan använda den för extern uppföljning av webbplatser, på samma sätt som Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Vill du lära dig mer om Google Analytics och öppna ett eget konto <a %s>klicka här</a>.',
        'RESOURCES' => 'Resurser',
        'LINKS' => 'Länkar',
        'PAGE' => 'Sida',
        'BACKGROUND' => 'Bakgrund',
        'TEXT' => 'Text',
        'HEADING_TEXT' => 'Rubriktext',
        'FONT' => 'Teckensnitt',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Färg',
        'LINK_COLOR' => 'Länkfärg',
        'BODY_TEXT' => 'Brödtext',
        'MIDDLE' => 'Mitten',
        'FEATURE_BOXES' => 'Funktionsrutor',
        'TITLEBAR_TEXT_COLOR' => 'Textfärg för titellisten',
        'TITLEBAR_BACKGROUND' => 'Bakgrund för titellisten',
        'UPLOADING_CONTENT' => 'Uppladdning av innehåll…',
        'WHEN_UPLOADING_IS_COMPLETE' => 'När uppladdningen är klar kan du kontrollera nätverket.',
        'FINISH' => 'Slut',
        'FLICKR_IMPORT_SETUP' => 'Program för import av Flickr',
        'FLICKR_API_KEY' => 'Din nyckel',
        'FLICKR_SECRET' => 'Din hemlighet',
        'FLICKR_KEY_ERROR' => 'Det uppstod ett problem med Flickr nyckeln eller hemligheten du angav.   Kan du kontrollera dem och ange dem på nytt?',
        'FLICKR_INTRO' => 'Vill du att dina medlemmar ska importera foton från Flickr?  Du har kommit till det rätta stället.  Om du redan har en Flickr API nyckel och en hemlighet kan du <a %s>gå vidare</a>.  Inte säker på vad det betyder?  Följ bara instruktionen nedan så kommer du igång på bara några minuter.',
        'FLICKR_GET_ACCOUNT' => 'Om du inte redan har ett Flickr konto, skaffa ett <a %s>här</a>.',
        'FLICKR_STEP1_TITLE' => 'Steg 1: Skaffa en Flickr API nyckel',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Ansöka om API nyckel-skärmbild på Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'API nyckel-skärmbild på Flickr',
        'FLICKR_STEP1_INTRO' => 'Logga in på Flickr och <a %s>ansök om en ny API nyckel</a> (öppnas i nytt fönster).',
        'FLICKR_STEP1_A' => 'Fyll i <strong>Namn</strong> och <strong>E-postadress</strong>.',
        'FLICKR_STEP1_B' => 'Under <strong>Nyckeln är avsedd för&hellip; </strong> välj alternativet <em>icke-kommersiell användning </em>.',
        'FLICKR_STEP1_C' => 'Beskriv ditt sociala nätverk i  rutan <strong>Beskriv det program du vill bygga</strong>.',
        'FLICKR_STEP1_D' => 'Markera båda godkännanderutorna.',
        'FLICKR_STEP1_APPLY' => 'När du är färdig, klicka på <strong>Använd</strong> knappen.',
        'FLICKR_STEP1_E' => 'Du kommer då till en skärmbild som visar din nya API nyckel.  Klicka på <strong>Klicka här</strong> länken för att ställa in användarautentiseringen för nyckeln.',
        'FLICKR_STEP2_TITLE' => 'Steg 2: Installation av nyckeln',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Installationsskärmbild för API nyckel autentisering på Flickr',
        'FLICKR_STEP2_F' => 'Klistra in följande webbadress i <strong>Återuppringning URL</strong> fältet:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'När du är klar, klicka på knappen <strong>Spara ändringar</strong>.',
        'FLICKR_STEP3_TITLE' => 'Steg 3: Mata in dina uppgifter',
        'FLICKR_STEP3_KEYS_SCREEN' => 'API nyckelinformation-skärmbild på Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Gratulerar!  Nu har du ett konto på Flickr.',
        'FLICKR_STEP3_COMPLETE' => 'För att göra klart installationen på %s är det bara att kopiera och klistra in nyckeln och hemligheten i följande fält:',
        'COMPLETE_SETUP' => 'Fullständig installation',
        'SETUP_YOUR_SITE_TO' => 'Ställ in ditt sociala nätverk för att importera foton från Flickr.',
        'FLICKR_IMPORTING' => 'Import från Flickr',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Du måste skapa ett eget socialt nätverk för att personer ska kunna importera sina bilder från Flickr.  Det tar bara några minuter så varför inte %s>skapa det nu? </a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Visa inte detta för mig igen.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Du har loggat ut från %s.  Kom gärna tillbaka till oss snart igen!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'skapade det här sociala nätverket på<a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Skapa ditt eget sociala nätverk gratis på Ning!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Dra här för att ta bort funktionen',
        'LAYOUT' => 'Layout',
        'DRAG' => 'Dra',
        'HERE' => 'Här',
        'YOU' => 'Du',
        'ADS' => 'Annonser',
        'MEMBERS' => 'Medlemmar',
        'HELLO_USERNAME' => 'Hej, användarnamn',
        'CREATED_BY' => 'Skapad av',
        'SAVE_FEATURES' => 'Spara funktioner',
        'FORUM' => 'Forum',
        'CATEGORIES' => 'Kategorier',
        'FORUM_CATEGORIES' => 'Forumkategorier',
        'A_THREADED_DISCUSSION_FORUM' => 'Ett diskussionsforum med trådar',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Låt medlemmarna skapa sina egna intressegrupper på nätverket.',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Visa poster från din eller andra medlemmars bloggar',
        'TEXT_BOX' => 'Textruta',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Sätt text, widget eller HTML på förstasidan',
        'A_LIST_OF_MEMBERS' => 'En lista över medlemmarna i ditt sociala nätverk.',
        'ALLOW_USERS_PHOTOS' => 'Låt andra ladda upp och visa foton',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Lägg in feeds från hela webben',
        'INFORMATION_ABOUT_THE_USER' => 'Information om den person som just loggade in',
        'ALLOW_USERS_VIDEOS' => 'Låt andra lägga in videos och visa dem',
        'SHOW_NETWORK_DESCRIPTION' => 'Visa beskrivningen av ditt nätverk',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Gör reklam för ditt nätverk på webben med standardemblem och widgets',
        'MONETIZE_WITH_ADS' => 'Tjäna pengar på nätverket genom annonsering',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Låt dina medlemmar få veta vem som skapade det här nätverket',
        'FOLLOW_LATEST_ACTIVITY' => 'Följ upp den allra senaste medlemsaktiviteten på ditt nätverk',
        'FAQ_FOR_NETWORK_CREATORS' => 'Vanliga frågor för skapare av nätverk',
        'ANSWERS_TO_FAQS' => 'Svar på vanliga frågor om anpassningen av det sociala nätverket.',
        'MEET_OTHER_LIKEMINDED' => 'Träffa andra likasinnade nätverkskreatörer, utbyt idéer och få support från Ninggruppen.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Anpassa utseendet på det sociala nätverket genom att lägga till dina egna Cascading-formatmallar (CSS) i fältet till vänster.  (<a href="%s">Vad är CSS? </a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Anpassa utseendet på sidan genom att lägga till dina egna Cascading-formatmallar i fältet till vänster.  (<a href="%s">Vad är CSS? </a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS på ditt sociala nätverk',
        'CSS_ON_YOUR_PAGE' => 'CSS på din sida',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Genom att lägga till din egen CSS får du full överblick över teckensnitten, färgerna, utrymmesdisponeringen och den övergripande stilen på nätverket.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Genom att lägga till din egen CSS på sidan får du full överblick över teckensnitten, färgerna, utrymmesdisponeringen och den övergripande stilen på nätverket.',
        'CSS_STYLES_WILL_OVERRIDE' => 'De CSS-stilar du lägger till här ersätter de CSS-stilar du valt tidigare.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Behöver du hjälp med att hitta på ett namn på en viss CSS-klass på nätverket?  Vi rekommenderar "Inspektera"-funktionen på det gratis<a href="%s">Firebug</a> filnamnstillägget (för Firefox-webbläsaren).',
        'WANT_TO_LEARN_MORE' => 'Vill du lära dig mer?  Besök vår avdelning <a href="%s">Avancerad anpassning</a>.',
        'APPLY_XS_THEME' => 'Använd %s\'s tema',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'Det finns redan ett NingID registrerat på e-postadressen %s.  Logga in nedan med ditt NingID eller e-postadress.  Om du glömt lösenordet kan du <a href="%s">klicka här och återställa det</a>.',
        'INVITED' => 'Inbjuden',
        'REQUESTED_INVITE' => 'Begärd inbjudan',
        'BAN_FROM_NETWORK' => 'Förbjuda någon att vara på nätverket',
        'REMOVE_BAN' => 'Ta bort förbud',
        'CANCEL_INVITATION' => 'Abryta inbjudan',
        'IGNORE' => 'Ignorera',
        'PROMOTE_TO_ADMINISTRATOR' => 'Upphöja till administratör',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Degradera som administratör',
        'STATUS' => 'Status',
        'DATE_JOINED' => 'Datum för medlemskap',
        'DATE_INVITED' => 'Datum för inbjudan',
        'DATE_REQUESTED' => 'Datum för begäran',
        'DATE_APPLIED' => 'Datum som valts',
        'NETWORK_CREATOR' => 'Nätverkets skapare',
        'NETWORK_ADMINISTRATOR' => 'Administratör',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Administratörer har en kontrollfunktion som liknar nätverkets skapare.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Exportera alla medlemsdata (. CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Dina medlemsuppgifter har exporterats. Klicka på <a %s>den här länken</a> för ett spara på skrivbordet.',
        'CLICK_GO_TO_START_EXPORT' => 'Klicka på Gå för att börja exportera.   Om du har många medlemmar kan processen ta några minuter.',
        'MEMBER' => 'Medlem',
        'INVITED_BY_X' => 'Inbjuden av %s',
        'DONE' => 'Klart',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Du har blivit bannad från %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Meddelande till administratören',
        'SORRY_USERNAME' => 'Ledsen, %s',
        'PENDING' => 'Väntande',
        'ACCEPT' => 'Accept',
        'PENDING_APPROVAL' => 'Väntande godkännande',
        'ACCEPT_MEMBERSHIP' => 'Acceptera medlemskap',
        'DECLINE_MEMBERSHIP' => 'Avböja medlemskap',
        'NO_PAGE_YET' => 'Ingen sida än',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Ditt medlemskap i %s väntar på godkännande från administratörerna.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Medlemskap Väntar på Godkännande',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Din profil väntar på godkännande',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Dina profildetaljer måste godkännas av administratören innan du kan bli medlem i %s.  Du får ett e-postmeddelande så snart din profil är godkänd.',
        'CONTINUE_ARROW' => 'Fortsätt →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Tillbaka till väntande medlemmar',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s väntar på godkännande för att bli medlem i %s.',
        'VIEW_PAGE' => 'Visa sida',
        'MESSAGE' => 'Meddelande',
        'SEND_MESSAGE' => 'Skicka meddelande',
        'MANAGE_FORUM_CATEGORIES' => 'Hantera forumkategorier',
        'START_DISCUSSIONS' => 'Starta diskussioner',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Välkommen till ditt nya sociala nätverk',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Det enda du behöver göra är att <a %s>bjuda in dina vänner</a>!',
        'CONTRIBUTE' => 'Bidra.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Anpassa. </strong> Justera <a %1$s>nätverkets utseende</a> och skapa <a %2$s>emblem och widgets</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Kontroll. </strong>  På <a %s>hantera</a> sida finns ett antal inställningsmöjligheter.',
        'CREATE_GROUPS' => 'Skapa grupper',
        'INVITE_MORE_PEOPLE' => 'Bjud in fler människor',
        'VIEW_THREAD' => 'Visa tråden',
        'COMMENT_THREAD' => 'Kommentera tråden',
        'COMMENT_BACK' => 'Ge en svarskommentar',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Hallå, du måste tillåta JavaScript att använda nätverket.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Kontrollera inställningarna för webbläsaren eller kontakta systemadministratören.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Hantera medlemmar, administratörer, inbjudna och bannade.',
        'MANAGE_MEMBERS' => 'Hantera medlemmar',
        'MANAGE_INVITED_PEOPLE' => 'Hantera inbjudna',
        'NETWORK_SETTINGS' => 'Nätverksinställningar',
        'PROMOTE_YOUR_NETWORK' => 'Gör reklam för ditt nätverk',
        'NING_RESOURCES' => 'Ningresurser',
        'ADD_PREMIUM_SERVICES' => 'Lägg till premiumtjänster',
        'REQUEST_SOURCE_CODE' => 'Begär källkodsåtkomst',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Datautvecklare: begär åtkomst till den källkod som styr nätverket.',
        'JOIN_NETWORK_CREATORS' => 'Gå med i nätverksskaparna',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Skicka ett meddelande till alla medlemmar i nätverket.',
        'CREATE_ANOTHER_NETWORK' => 'Skapa ett annat nätverk',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Har du någon annan bra idé för ett socialt nätverk?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Ge Facebook-användare tillstånd att placera ditt nätverks widgets på sina profilsidor.',
        'BADGES_AND_WIDGETS' => 'Emblem och widgets',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Anpassa utseendet på ditt nätverks widgets och emblem.',
        'GET_BADGES' => 'Skaffa emblem',
        'CUSTOM_TEXT' => 'Standardtext',
        'IM_A_MEMBER_OF' => 'Jag är medlem i:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Visa inga varumärken',
        'WATERMARK_OR_LOGO_IMAGE' => 'Vattenmärke eller logotypbild:',
        'NETWORK_BRANDING_BADGES' => 'Nätverksvarumärke: Emblem',
        'NETWORK_BRANDING_WIDGETS' => 'Nätverksvarumärke: Widgets',
        'LOGO_IMAGE' => 'Logotyp-bild',
        'SMALL_NETWORK_BADGE' => 'Litet nätverksemblem',
        'LARGE_NETWORK_BADGE' => 'Stort nätverksemblem',
        'REFRESH' => 'Uppdatera',
        'HTML_EMBED_CODE' => 'HTML inbäddad kod:',
        'CUSTOMIZE' => 'Anpassa',
        'SHARE_TITLE' => 'Dela \'%s\'',
        'SHARE_TYPE' => 'Dela %s',
        'YOUR_MESSAGE_SENT' => 'Ditt meddelande har skickats.',
        'YOUR_MESSAGES_SENT' => 'Dina meddelanden har skickats.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Du kan dela den här %s på två sätt&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Titta närmare på %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Titta närmare på %s',
        'PHOTO_ALBUM' => 'fotoalbum',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Anpassa dina emblem och widgets och välj dina egna färger och bilder.  Det kan ta upp till 4 timmar innan ändringarna syns på andra webbsidor.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Bakgrundsbild och färg',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Använd det här formuläret för att rapportera en händelse till <a %s>%s</a> skaparen av <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Skapare av nätverk kan inte ändra sina e-postadresser via nätverk de inte äger.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Skapare av nätverk kan inte ändra sina lösenord via nätverk de inte äger.',
        'GO' => 'Gå',
        'LARGE_THUMBNAILS' => 'Stora miniatyrer',
        'SMALL_THUMBNAILS' => 'Små miniatyrer',
        'RECENTLY_JOINED' => 'Senaste',
        'MOST_POPULAR_MEMBERS' => 'Mest Populär',
        'NO_MEMBERS_TO_DISPLAY' => 'Du visar inte att du har några medlemmar just nu',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Rutan kommer inte att visas för andra om du inte väljer minst en rad.',
        'DETAIL_VIEW' => 'Visa Detalj',
        'TITLES_ONLY' => 'Endast Titlar',
        'RECENTLY_ADDED_POSTS' => 'Nyligen Tillagda',
        'POPULAR_POSTS' => 'Flest kommentarer',
        'PROMOTED_POSTS' => 'Framhållna',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Rutan kommer inte att visas för andra om du inte väljer minst en post.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Håll detta webbläsarfönster öppet medan uppladdningen pågår.',
        'CANCEL_UPLOAD' => 'Avbryt Uppladdning',
        'YOU_DO_NOT_HAVE_POSTS' => 'Du har inte skrivit några poster än.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Du har inga kommentarer att godkänna.',
        'REQUIRED_FIELD' => '(Obligatoriskt fält)',
        'BLOG_POST_BY_X' => 'Bloggpost av %s',
        'HELLO' => 'Hej,',
        'ADDED_BY_X' => 'Tillagd av %s',
        'CLICK_TO_ADD_A_TITLE' => 'Klicka för att lägga till en rubrik',
        'DELETE_BLOG_POST' => 'Ta bort post',
        'DELETE_THIS_BLOG_POST_Q' => 'Ta bort den här bloggposten?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Är du säker på att du vill ta bort den här bloggposten?  Denna bearbetning kan ta några minuter.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Ange något för: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Välj ett alternativ för: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Lämna ett giltigt datum för: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Ange ett datum för: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => '%s Bloggposter för %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Visade bloggposter på %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Bloggposter på %s %s',
        'FEATURED_BLOG_POSTS' => 'Visade bloggposter',
        'EVERYONES_POSTS' => 'Allas bloggposter',
        'PUBLISHED_N_OF_N' => 'Publicerade %d av %d',
        'DOWNLOAD_X' => 'Hämta %s',
        'UPLOAD_DID_NOT_WORK' => 'Ledsen men uppladdningen fungerade inte',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M. j, Y',
        'XS_POSTS' => '%s\'s  poster',
        'USERNAMES_COMMENTS' => '%s\'s kommentarer',
        'ADD_COMMENT' => 'Lägg till en kommentar',
        'XS_PAGE' => '%s\'s sida',
        'XS_BLOG' => '%s\'s blogg',
        'XS_FRIENDS' => '%s\'s vänner',
        'VIEW_XS_ELLIPSIS' => 'Visa %ss…',
        'DRAFT_BRACKETS' => '[ Utkast ]',
        'FEATURED' => 'Framhållna',
        'MY_POSTS' => 'Mina poster',
        'MY_POSTS_ONLY' => 'Mina poster endast',
        'OWNER_POSTS_ONLY' => 'Skaparens poster endast',
        'JANUARY' => 'Januari',
        'FEBRUARY' => 'Februari',
        'MARCH' => 'Mars',
        'APRIL' => 'April',
        'MAY' => 'Maj',
        'JUNE' => 'Juni',
        'JULY' => 'Juli',
        'AUGUST' => 'Augusti',
        'SEPTEMBER' => 'September',
        'OCTOBER' => 'Oktober',
        'NOVEMBER' => 'November',
        'DECEMBER' => 'December',
        'MY_COMMENTS' => 'Mina kommentarer',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => 'Min sida',
        'MY_PAGE_TAB_TEXT' => 'Min sida',
        'BLOG_POSTS' => 'Bloggposter',
        'MY_BLOG' => 'Min blogg',
        'MONTH' => 'Månad',
        'DAY' => 'Dag',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Välj standardinställning för synbarhet',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Välj vem som kan kommentera',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Välj modereringsnivå för bloggkommentarer',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Välj aktivitetsmeddelande',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Välj modereringsmeddelande',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Välj godkännandemeddelande',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Välj medlemskap för inbjuden-meddelande',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Välj att aldrig få några meddelanden',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Välj väninbjudnings-meddelanden',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Välj sätt att meddela om ett nytt meddelande',
        'APPROVE_COMMENT' => 'Godkänn en kommentar',
        'MANAGE_BLOG' => 'Hantera blogg',
        'COMMENTS_POSTED_ON_BLOG' => 'Kommentarer som postats på min blogg',
        'COMMENT' => 'Kommentar',
        'COMMENTER' => 'Kommentator',
        'POST' => 'POST',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Post har tagits bort',
        'COMMENTS_ARE_CLOSED' => 'Bloggposten stängd för kommentarer',
        'NO_COMMENTS' => 'Inga kommentarer',
        'FLAG' => 'Markera',
        'POST_TITLE' => 'Posttitel',
        'DRAFT_PARENTHESES' => '(Utkast)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Ska publiceras på: %s',
        'EDIT_2' => '"ändring, redigering"',
        'NONE' => 'Inget',
        'N_NEW' => '%s nya',
        'NO_POSTS' => 'Inga poster',
        'ADD_NEW_BLOG_POST' => 'Lägg till en ny bloggpost',
        'HAPPY' => 'Glad',
        'SAD' => 'Ledsen',
        'COOL' => 'Cool',
        'EVIL' => 'Ond',
        'MAD' => 'Galen',
        'ENVIOUS' => 'Avundsjuk',
        'ENTRY' => 'Notis',
        'WHAT_DATE_FOR_YOUR_POST' => 'Vilket datum vill du ha för din post?',
        'NOW' => 'Nu',
        'CHOOSE_DATE_AND_TIME' => 'Välj datum och tidpunkt (om du väljer ett datum längre fram kommer din post att publiceras då)',
        'PRIVACY_AND_COMMENTS' => 'Integritet och kommentarer',
        'WHO_CAN_VIEW_POST' => 'Vem kan se den här posten?',
        'EVERYONE' => 'alla',
        'ALLOW_COMMENTS' => 'Ska det vara tillåtet att kommentera den här posten?',
        'YES' => 'Ja',
        'NO' => 'Nej',
        'COMMENT_MODERATION' => 'Kommentarmoderering',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Du modererar bloggkommentarer just nu.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Du modererar inte bloggkommentarer just nu.',
        'SAVE_AS_DRAFT' => 'Spara som utkast',
        'PREVIEW' => 'Förhandsvisning',
        'PUBLISH_POST' => 'Publicera post',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Det här är en förhandsvisning av hur din post kommer att se ut när den publiceras.  Klicka på tillbaka för att redigera posten eller på publicera om den är klar!',
        'BACK' => 'Tillbaka',
        'PUBLISH' => 'Publicera!',
        'BLOG_POST' => 'Bloggpost',
        'PROFILE' => 'Profil',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Detta är ett opublicerat utkast',
        'WILL_BE_PUBLISHED_ON_X' => 'Kommer att publiceras på %s <small>%s</small>',
        'POSTED_ON_X' => 'Postad <strong>%s</strong> <small>%s</small>',
        'POSTED_ON_X_BY' => 'Postad <strong>%s</strong> <small>%s</small> av:',
        'ABOUT_THIS_POST' => 'Om posten',
        'ABOUT_YOUR_POST' => 'Om din post',
        'ADDED_BY' => 'Tillagd av:',
        'JUST_FRIENDS' => 'Bara vänner',
        'RECENT_POSTS' => 'Aktuella poster',
        'THERE_ARE_NO_RECENT_POSTS' => 'Det finns inga aktuella poster.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Din kommentar har lagts till men den måste godkännas innan alla kan se den.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'På %s på %s, %s sade…',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s har inga vänner på det här sociala nätverket än.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Du har inga vänner på det här sociala nätverket än.',
        'EDIT_PAGE_APPEARANCE' => 'Redigera sidans utseende',
        'VIEW_PAGE_AS_OTHERS' => 'Visa sidan som andra ser den',
        'ADD_BLOG_POST' => 'Lägg till bloggpost',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Håll webbläsarfönstret öppet medan allt %s innehåll tas bort.  Denna bearbetning kan ta några minuter.',
        'BAN_MEMBER_FROM_NETWORK' => 'Banna medlem från nätverket',
        'BAN_USERNAME' => 'Banna %s?',
        'BLOCK' => 'blockera',
        'CREATE_NEW_BLOG_POST' => 'Skapa en ny bloggpost!',
        'EDIT_POST' => 'Redigera post',
        'EDIT_POST_COLON' => 'Redigera post:',
        'CONTINUE_READING' => 'Fortsätt att läsa…',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Postat av <a %s>mig</a> den %s kl. %s —',
        'POSTED_BY_X_ON_X_AT_X' => 'Postat av %s den %s kl. %s —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Postat av mig den %s kl. %s —',
        'ADD' => 'Lägg till',
        'SUBSCRIBE' => 'Prenumerera',
        'VIEW_ARCHIVES' => 'Visa arkiv',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Dina inställningar har sparats.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Korrigera följande:',
        'PRIVACY' => 'Integritet',
        'NETWORK_PRIVACY' => 'Nätverksintegritet',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Nätverket är <strong>synligt för alla</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Vem som helst kan registrera sig och bli medlem.  Besökare kan…',
        'SEE_EVERYTHING' => 'Se allt',
        'SEE_JUST_THE_MAIN_PAGE' => 'Se bara förstasidan',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Se bara registreringssidan',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Nätverket <strong>syns bara för medlemmarna</strong>.',
        'WHO_CAN_SIGN_UP' => 'Vem kan registrera sig och bli medlem?',
        'MODERATION' => 'Innehållskontroll',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Godkänn nya medlemmar innan de kan gå med',
        'APPROVE_PHOTOS_VIDEOS' => 'Godkänn foton och videos innan de visas',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Visa den senaste aktiviteten på ditt nätverk!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Lägg in ett konstant uppdaterat flöde av aktuell aktivitet på nätverkets förstasida.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Klicka här för att lägga till senaste aktivitet på nätverket.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Alternativen är avaktiverade eftersom du inte lagt in senaste aktivitet på nätverket.',
        'ACTIVITY' => 'Aktivitet',
        'DISPLAY_PREFERENCES' => 'Visa önskemål',
        'NEW_CONTENT' => 'Nytt innehåll',
        'NEW_COMMENTS' => 'Nya kommentarer',
        'NEW_MEMBERS' => 'Nya medlemmar',
        'MEMBER_UPDATES' => 'Medlemsuppdateringar',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Vad visas på nätverkets<br />Senaste aktivitet?',
        'LATEST_ACTIVITY' => 'Senaste aktivitet',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s gjorde ett inlägg i diskussionen %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>gjorde ett inlägg</a> i diskussionen<a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'Du <a %1$s>gjorde ett inlägg</a> i diskussionen<a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s kommenterade bloggposten %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>kommenterade</a> bloggposten <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'Du <a %1$s>kommenterade</a> bloggposten <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s startade en diskussion som heter %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Du startade en diskussion som heter %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s lade till bloggposten \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Du lade till bloggposten \'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s gick med i gruppen %s',
        'YOU_JOINED_THE_GROUP_X' => 'Du gick med i gruppen %s',
        'X_JOINED_Y_GROUPS' => '%s gick med i %s grupper',
        'YOU_JOINED_X_GROUPS' => 'Du gick med i %s grupper',
        'X_JOINED_APPNAME' => '%s har gått med i %s. <a %s>Lämna en kommentar</a> till %s.',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Välkommen, %1$s!  Du är medlem #%2$s i %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Välkommen, %1$s!  Du är medlem #%2$s i %3$s.  <a %4$s>Hitta vänner nu</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s är medlem #%2$s i %3$s.',
        'XS_PROFILE_CHANGED' => '%s profil ändrades',
        'YOUR_PROFILE_CHANGED' => 'Din profil ändrades',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s gjorde en kommentar till %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Du gjorde en kommentar till %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s gjorde en kommentar till dig',
        'X_CREATED_A_GROUP_Y' => '%s skapade en grupp som heter %s',
        'YOU_CREATED_A_GROUP_Y' => 'Du skapade en grupp som heter %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s skapade %s nya grupper',
        'X_STARTED_Y_FORUM_POSTS' => '%s startade %s nya forumdiskussioner',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Du startade %s nya forumdiskussioner',
        'X_ADDED_Y_BLOG_POSTS' => '%s lade till %s nya bloggposter',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Du lade till %s nya bloggposter',
        'VIEW_XS_BLOG_POSTS' => 'Visa %s bloggposter',
        'VIEW_YOUR_BLOG_POSTS' => 'Visa dina bloggposter',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s har <a %s>nya profilfrågor</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s har nu en musikspelare',
        'APPNAME_NOW_HAS_GROUPS' => '%s har nu <a %s>grupper</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s har nu <a %s>videos</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s har nu ett <a %s>forum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s har nu <a %s>foton</a>',
        'DID_YOU_KNOW' => 'Visste du om',
        'ANNOUNCEMENT' => 'Meddelande',
        'CONGRATULATIONS' => 'Grattis',
        'YOU_CREATED_APPNAME' => 'Du skapade %s nätverket',
        'USER_CREATED_APPNAME' => '%s skapade %s nätverket.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Lägg till meddelanden och välj vad som ska visas i nätverkets aktivitetsfeed.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Vilka av era aktiviteter ska visas <br />på senaste aktivitet?',
        'NEW_CONTENT_I_ADD' => 'Nytt innehåll jag lägger till',
        'NEW_COMMENTS_I_ADD' => 'Nya kommentarer jag lägger till',
        'WHEN_I_UPDATE_MY_PROFILE' => 'När jag uppdaterar min profil',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Senaste aktivitet visar aldrig meddelanden du skickar, sidor eller medlemmar du ser på, inbjudningar du tackar nej till, personer du avvisar eller säger nej till eller saker du tar bort.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Du har ingen aktuell aktivitet.  Varför inte starta någon?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Du har stängt av visningen av din aktivitet.  <a %s>Klicka här för att sätta på den igen. </a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'Nätverkets skapare har stängt av visningen av all aktivitet.',
        'NO_ACTIVITY_TO_DISPLAY' => 'Du visar ingen aktivitet just nu.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Rutan kommer inte att vara synlig för andra om du inte väljer minst en aktivitet.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Det finns ingen aktuell aktivitet.  Varför inte starta någon?',
        'MY_ACTIVITY_PREFERENCES' => 'Mina aktivitetsönskemål',
        'DELETE_ACTIVITY_ITEM' => 'Ta bort aktivitetsmeddelande',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Ta bort det här aktivitetsmeddelandet?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Det gör att andra inte kan se det här aktivitetsmeddelandet',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s har postat flest %2$foton%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s är det populäraste fotot hittills',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s har postat flest %2$svideos%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s är den populäraste videon hittills',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s har postat flest låtar',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s är den populäraste låten hittills',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s är den populäraste forumposten hittills',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s är den populäraste bloggposten hittills',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s senaste aktivitet på %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Senaste aktivitet på %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Lägg ett meddelande till den senaste aktiviteten',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Lägg till fakta om nätverket…',
        'ADD_MESSAGE' => 'Lägg till meddelande',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '…eller skriv ditt eget meddelande',
        'NETWORK' => 'Nätverk',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Vem kan i normalfallet se dina foton, videos <br/> och bloggposter?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(När du lägger till foto, video eller bloggpost kan du ändra inställningen.)',
        'MODERATE_COMMENTS_ON_BLOG' => 'Vill du kunna godkänna kommentarer <br />innan de visas på din blogg?',
        'YES_LET_ME_APPROVE' => 'Ja – Låt mig få godkänna kommentarer först',
        'NO_PUBLISH_COMMENTS' => 'Nej – Publicera kommentarer direkt',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Vem kan kommentera dina foton,<br/> videos och blogg?',
        'SAVE' => 'Spara',
        'EMAIL' => 'E-post',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Din integritet är viktig för oss.  Om du har frågor om dina e-postmeddelanden, skicka ett meddelande till oss på <a href="http://help.ning.com/?page_id=27">Hjälpcentral</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Lägg till foton och videos på %s genom att skicka dem till den här e-postadressen:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Lägg till foton och videos på %s från din telefon genom att skicka dem till den här e-postadressen:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Skapa ny e-postadress',
        'SUPPORTS_TEXT_EMBEDDED' => 'Stöder text, inbäddade videos, foton och widgets',
        'POST_COMMENT' => 'Postkommentar',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Du måste vara medlem av %s för att lägga till kommentarer!',
        'MONTHLY_ARCHIVES' => 'Månadsarkiv',
        'NO_FRIENDS_ON_SITE' => 'Inga vänner ännu på det här sociala nätverket.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Inga vänner på det här sociala nätverket som matchar din sökning.',
        'MEMBERS_TAB_TEXT' => 'Medlemmar',
        'SITE_HAS_NO_MEMBERS' => 'Det här sociala nätverket har ännu inga medlemmar!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Det här sociala nätverket har inga medlemmar som matchar din sökning.',
        'NO_COMMENTS_YET' => 'Inga kommentarer än!',
        'VIEW_ALL_COMMENTS' => 'Visa alla kommentarer',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Du har inte lagt till några bloggposter ännu!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Du kan skriva om vad du vill, berätta om och lägga in dina favoritvideos, foton och musik.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Skriv din första notis!',
        'THERE_ARE_NO_BLOG_POSTS' => 'Det finns inga bloggposter just nu på ditt sociala nätverk.',
        'THERE_ARE_NO_FEATURED_X' => 'Det finns inga %s som visas på ditt sociala nätverk.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Det finns inga %s som matchar de inställningar du valt.',
        'START_FEATURING_X_CLICK_Y' => 'Börja visa %s där du ser visningsalternativet.  För att lära dig mer om visning, <a %s>klicka här</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Rutan är inte synlig för andra förrän det finns bloggposter att visa.  Varför inte lägga till en?',
        'YOUR_FRIEND' => 'Din vän',
        'REQUEST_SENT' => 'Begäran Avsänd!',
        'BLOCKED' => 'Blockerad',
        'BANNED' => 'Bannad',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Lägg till din första bloggpost',
        'MY_FIRST_BLOG_POST' => 'Min första bloggpost!',
        'TELL_THE_PEOPLE_ON' => 'Berätta mer om dig själv för de andra på %s.  Frågor markerade med ett <span %s>lås</span> är privata och syns bara för administratörer.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Välj ett tema för din sida',
        'NOW_CUSTOMIZE_PAGE' => 'Anpassa din sida nu…',
        'NO_POSTS_TO_DISPLAY' => 'Inga poster att visa.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'Du visar inga poster just nu.',
        'DATE_COLON' => 'Datum:',
        'TIME_COLON' => 'Tidpunkt:',
        'CHANGE' => 'Ändra',
        'UPLOAD_A_PHOTO' => 'Ladda upp en Bild',
        'OPTIONS' => 'alternativ',
        'PIXELS' => 'Bildpunkter',
        'CANCEL' => 'Avbryt',
        'UPLOAD_A_FILE' => 'Ladda upp en fil:',
        'TO_INSERT_A_FILE' => 'För att lägga in en fil, klicka på ”Bläddra” eller ”Välj” - knappen ovan för att hitta filen på datorn.',
        'UPLOADING' => 'Laddar upp…',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Populära medlemmar',
        'INVITE_FRIENDS' => 'Bjud in Vänner',
        'VIEW_ALL' => 'Visa alla',
        'REMOVE_X' => 'Ta bort %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Är du säker på att du vill banna %1$s från ditt sociala nätverk och ta bort allt innehåll %1$s lagt till?  Denna bearbetning kan ta några minuter.',
        'REMOVING_X' => 'Tar bort %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Är du säker på att du vill banna den utvalda medlemmen /medlemmarna från ditt sociala nätverk och ta bort allt innehåll de lagt in?  Denna bearbetning kan ta några minuter.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Är du säker på att du vill banna den utvalda medlemmen/medlemmarna från ditt sociala nätverk?  Denna bearbetning kan ta några minuter.',
        'BAN' => 'Banna',
        'REMOVING_MEMBERS' => 'Borttagning av medlemmar',
        'FEMALE' => 'Kvinnlig',
        'MALE' => 'Manlig',
        'UNITED_STATES' => 'Förenta staterna',
        'AND' => 'och',
        'FROM' => 'från',
        'GENDER_M' => 'Manlig',
        'GENDER_F' => 'Kvinnlig',
        'XS_PAGE_ON_Y' => '%s Sida på %s',
        'SEARCH_MEMBERS' => 'Sök medlemmar',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'Någon kommenterade en bloggpost du lagt till på %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Du har en ny kommentar på din sida.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Du har en ny kommentar på din sida på %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Du har en ny kommentar på din sida på %s…',
        'A_BLOG_POST' => 'en bloggpost',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Nu när du gått med i <strong><a %s>bjud in dina vänner</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'Det här är din profil:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Börja med att <a %s>anpassa utseendet</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Använd den till att <a %1$s>ha en blogg</a>, och visa <a %2$s>dina profilsvar</a>.',
        'START_CONTRIBUTING' => 'Börja bidra:',
        'UPLOAD_VIDEOS' => 'Ladda upp videos',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Bidra till diskussioner',
        'JOIN_GROUPS' => 'Gå med i grupper',
        'ADD_A_BLOG_POST' => 'Lägg till en bloggpost',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Klicka här för att visa dina väninbjudningar.',
        'LEAVE_X' => 'Lämna %s',
        'LEAVE_X_Q' => 'Lämna %s?',
        'ARE_YOU_SURE_LEAVE_X' => 'Är du säker på att du vill lämna %s och ta bort allt ditt innehåll?  Denna bearbetning kan ta några minuter.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592;  Tillbaka till %s\'s sida',
        'BACK_TO_MY_PAGE' => '&#8592;  Tillbaka till min sida',
        'COMMENT_WALL' => 'kommentarplank',
        'ONLINE' => 'Online',
        'MEMBER_IS_ONLINE' => 'En medlem är online',
        'ONLINE_NOW' => 'Online nu',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Välj vem som kan se, gå med i och bidra till ditt nätverk.',
        'EMAIL_NOTIFICATIONS' => 'E-postmeddelanden',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Vilken sorts nätverksaktivitet vill du ha ett e-postmeddelande om?',
        'NETWORK_MESSAGES' => 'Nätverksmeddelanden',
        'MEMBER_ACTIVITY' => 'Medlemsaktivitet',
        'APPROVAL' => 'Godkännande',
        'FRIEND_REQUESTS' => 'Väninbjudningar',
        'PEOPLE_IVE_INVITED_JOIN' => 'Andra som jag bjudit in att gå med i nätverket',
        'MESSAGES_SENT_TO_ME' => 'Meddelanden som skickats till mig',
        'MESSAGES_SENT_TO_GROUPS' => 'Meddelanden som skickats till grupper jag tillhör',
        'MESSAGES_SENT_TO_NETWORK' => 'Meddelanden som skickats till hela nätverket',
        'I_HAVE_NEW_COMMENTS' => 'Jag har nya kommentarer att godkänna',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Jag har nytt nätverksinnehåll att godkänna',
        'CONTENT_ACTIVITY' => 'Innehållsaktivitet',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Aktivitet på saker jag lagt till',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Följer automatiskt diskussioner jag svarar på',
        'THINGS_IVE_ADDED_APPROVED' => 'Saker jag lagt till har godkänts',
        'NOTIFICATIONS' => 'Meddelanden',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'E-posta mig när andra svarar',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'E-posta mig inte när andra svarar',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'Vill du sluta följa den här %s, <a %s>klicka här</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Du följer inte längre den här %s.',
        'NOTIFY' => 'Underrätta',
        'STOP_NOTIFYING' => 'Sluta underrätta',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'E-posta mig när det kommer nya diskussioner',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'E-posta mig inte när det kommer nya diskussioner',
        'STOP_FOLLOWING_ALL' => 'Sluta följa alla diskussioner och bloggkommentarer',
        'CHANGE_MY_PHOTO' => 'Ändra mitt foto',
        'COUNTRY_AF' => 'Afghanistan',
        'COUNTRY_AX' => 'Åland',
        'COUNTRY_AL' => 'Albanien',
        'COUNTRY_DZ' => 'Algeriet',
        'COUNTRY_AS' => 'Amerikanska Samoa',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antarktis',
        'COUNTRY_AG' => 'Antigua och Barbuda',
        'COUNTRY_AR' => 'Argentina',
        'COUNTRY_AM' => 'Armenien',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australien',
        'COUNTRY_AT' => 'Österrike',
        'COUNTRY_AZ' => 'Azerbajdzjan',
        'COUNTRY_BS' => 'Bahamas',
        'COUNTRY_BH' => 'Bahrain',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Vitryssland',
        'COUNTRY_BE' => 'Belgien',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermuda',
        'COUNTRY_BT' => 'Bhutan',
        'COUNTRY_BO' => 'Bolivia',
        'COUNTRY_BA' => 'Bosnien och Hercegovina',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Bouvetön',
        'COUNTRY_BR' => 'Brasilien',
        'COUNTRY_IO' => 'Brittiska territoriet i Indiska Oceanen',
        'COUNTRY_BN' => 'Brunei Darussalam',
        'COUNTRY_BG' => 'Bulgarien',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Kambodja',
        'COUNTRY_CM' => 'Kamerun',
        'COUNTRY_CA' => 'Kanada',
        'COUNTRY_CV' => 'Kap Verde',
        'COUNTRY_KY' => 'Caymanöarna',
        'COUNTRY_CF' => 'Centralafrikanska Republiken',
        'COUNTRY_TD' => 'Tchad',
        'COUNTRY_CL' => 'Chile',
        'COUNTRY_CN' => 'China, mainland',
        'COUNTRY_CX' => 'Christmas Island',
        'COUNTRY_CC' => 'Kokosöarna',
        'COUNTRY_CO' => 'Colombia',
        'COUNTRY_KM' => 'Komorerna',
        'COUNTRY_CG' => 'Republiken Kongo',
        'COUNTRY_CD' => 'Demokratiska republiken Kongo',
        'COUNTRY_CK' => 'Cooköarna',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Elfenbenskusten',
        'COUNTRY_HR' => 'Kroatien',
        'COUNTRY_CU' => 'Kuba',
        'COUNTRY_CY' => 'Cypern',
        'COUNTRY_CZ' => 'Tjeckiska republiken',
        'COUNTRY_DK' => 'Danmark',
        'COUNTRY_DJ' => 'Djibouti',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'Dominikanska republiken',
        'COUNTRY_EC' => 'Ecuador',
        'COUNTRY_EG' => 'Egypten',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_GQ' => 'Ekvatorialguinea',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_EE' => 'Estland',
        'COUNTRY_ET' => 'Etiopien',
        'COUNTRY_EU' => 'Europeiska unionen',
        'COUNTRY_FK' => 'Falklandsöarna',
        'COUNTRY_FO' => 'Färöarna',
        'COUNTRY_FJ' => 'Fijiöarna',
        'COUNTRY_FI' => 'Finland',
        'COUNTRY_FR' => 'Frankrike',
        'COUNTRY_GF' => 'Franska Guyana',
        'COUNTRY_PF' => 'Franska Polynesien',
        'COUNTRY_TF' => 'Frankrikes södra territorier',
        'COUNTRY_GA' => 'Gabon',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GE' => 'Georgien',
        'COUNTRY_DE' => 'Tyskland',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Grekland',
        'COUNTRY_GL' => 'Grönland',
        'COUNTRY_GD' => 'Grenada',
        'COUNTRY_GP' => 'Guadeloupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guinea',
        'COUNTRY_GW' => 'Guinea-Bissau',
        'COUNTRY_GY' => 'Guyana',
        'COUNTRY_HT' => 'Haiti',
        'COUNTRY_HM' => 'Heardön och McDonaldöarna',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Ungern',
        'COUNTRY_IS' => 'Island',
        'COUNTRY_IN' => 'Indien',
        'COUNTRY_ID' => 'Indonesien',
        'COUNTRY_IR' => 'Islamiska republiken Iran',
        'COUNTRY_IQ' => 'Irak',
        'COUNTRY_IE' => 'Irland',
        'COUNTRY_IL' => 'Israel',
        'COUNTRY_IT' => 'Italien',
        'COUNTRY_JM' => 'Jamaica',
        'COUNTRY_JP' => 'Japan',
        'COUNTRY_JO' => 'Jordanien',
        'COUNTRY_KZ' => 'Kazakstan',
        'COUNTRY_KE' => 'Kenya',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Demokratiska folkrepubliken Korea',
        'COUNTRY_KR' => 'Republiken Korea',
        'COUNTRY_KW' => 'Kuwait',
        'COUNTRY_KG' => 'Kirgisistan',
        'COUNTRY_LA' => 'Laos Demokratiska Folkrepubliken',
        'COUNTRY_LV' => 'Lettland',
        'COUNTRY_LB' => 'Libanon',
        'COUNTRY_LS' => 'Lesotho',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LY' => 'Libyen Arab Jamahiriya',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Litauen',
        'COUNTRY_LU' => 'Luxemburg',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Makedonien, f.d. jugoslaviska republiken',
        'COUNTRY_MG' => 'Madagaskar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malaysia',
        'COUNTRY_MV' => 'Maldiverna',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Marshallöarna',
        'COUNTRY_MQ' => 'Martinique',
        'COUNTRY_MR' => 'Mauretanien',
        'COUNTRY_MU' => 'Mauritius',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'Mexico',
        'COUNTRY_FM' => 'Mikronesien, de federerade staterna',
        'COUNTRY_MD' => 'Republiken Moldavien',
        'COUNTRY_MC' => 'Monaco',
        'COUNTRY_MN' => 'Mongoliet',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Marocko',
        'COUNTRY_MZ' => 'Moçambique',
        'COUNTRY_MM' => 'Myanmar',
        'COUNTRY_NA' => 'Namibia',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Nederländerna',
        'COUNTRY_AN' => 'Nederländska antillerna',
        'COUNTRY_NC' => 'Nya Kaledonien',
        'COUNTRY_NZ' => 'Nya Zeeland',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Norfolkön',
        'COUNTRY_MP' => 'Nordmarianerna',
        'COUNTRY_NO' => 'Norge',
        'COUNTRY_OM' => 'Oman',
        'COUNTRY_PK' => 'Pakistan',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Det ockuperade territoriet Palestina',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PG' => 'Papua Nya Guinea',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Peru',
        'COUNTRY_PH' => 'Filippinerna',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Polen',
        'COUNTRY_PT' => 'Portugal',
        'COUNTRY_PR' => 'Puerto Rico',
        'COUNTRY_QA' => 'Qatar',
        'COUNTRY_RE' => 'Réunion',
        'COUNTRY_RO' => 'Rumänien',
        'COUNTRY_RU' => 'Ryska federationen',
        'COUNTRY_RW' => 'Ruanda',
        'COUNTRY_SH' => 'Saint Helena',
        'COUNTRY_KN' => 'Saint Kitts och Nevis',
        'COUNTRY_LC' => 'Saint Lucia',
        'COUNTRY_PM' => 'Saint-Pierre et Miquelon',
        'COUNTRY_VC' => 'Saint Vincent and the Grenadines',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Sao Tome and Principe',
        'COUNTRY_SA' => 'Saudiarabien',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Serbien och Montenegro',
        'COUNTRY_SC' => 'Seychellerna',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SG' => 'Singapore',
        'COUNTRY_SK' => 'Slovakien',
        'COUNTRY_SI' => 'Slovenien',
        'COUNTRY_SB' => 'Solomonöarna',
        'COUNTRY_SO' => 'Somalia',
        'COUNTRY_ZA' => 'Sydafrika',
        'COUNTRY_GS' => 'South Georgia and the South Sandwich Islands',
        'COUNTRY_ES' => 'Spanien',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Sudan',
        'COUNTRY_SR' => 'Surinam',
        'COUNTRY_SJ' => 'Svalbard och Jan Mayen',
        'COUNTRY_SZ' => 'Swaziland',
        'COUNTRY_SE' => 'Sverige',
        'COUNTRY_CH' => 'Schweiz',
        'COUNTRY_SY' => 'Syriska arabrepubliken',
        'COUNTRY_TW' => 'Taiwan',
        'COUNTRY_TJ' => 'Tadzjikistan',
        'COUNTRY_TZ' => 'Tanzania, förenade republiken',
        'COUNTRY_TH' => 'Thailand',
        'COUNTRY_TL' => 'Timor-Leste',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad och Tobago',
        'COUNTRY_TN' => 'Tunisien',
        'COUNTRY_TR' => 'Turkiet',
        'COUNTRY_TM' => 'Turkmenistan',
        'COUNTRY_TC' => 'Turks and Caicos Islands',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ukraina',
        'COUNTRY_AE' => 'Förenade arabemiraten',
        'COUNTRY_GB' => 'Storbritannien',
        'COUNTRY_US' => 'Förenta staterna',
        'COUNTRY_UM' => 'Förenta staternas mindre öar i Oceanien och Västindien',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Uzbekistan',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Vatikanstaten',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VG' => 'Virgin Islands, British',
        'COUNTRY_VI' => 'Virgin Islands, U.S.',
        'COUNTRY_WF' => 'Wallis and Futuna',
        'COUNTRY_EH' => 'Västsahara',
        'COUNTRY_YE' => 'Jemen',
        'COUNTRY_ZM' => 'Zambia',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Fellogg',
        'CANNOT_READ_ERROR_LOG' => 'Kunde inte läsa fellogg',
        'CANNOT_OPEN_ERROR_LOG' => 'Kunde inte öppna fellogg',
        'CANNOT_SCAN_ERROR_LOG' => 'Kunde inte skanna fellogg',
        'MODELS_RESET' => 'Återställ modeller:',
        'NO_MODELS_RESET' => 'Inga modeller återställda.',
        'NO_FEED_TO_DISPLAY' => 'Du visar inga artiklar just nu.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Rutan kommer inte att visas för andra om du inte väljer minst en artikel.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Klicka på redigera för att bestämma RSS-matningen för den här rutan.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Ett problem uppstod vid hämtningen av den här RSS-matningen.',
        'MORE_ELLIPSIS' => 'Mer…',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Vi är ledsna men det finns ett problem med sidan.',
        'PLEASE_TRY_REFRESHING' => 'Försök uppdatera sidan inom 30 sekunder eller <a %s>tala om det för oss</a> om du får meddelandet igen.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Det finns inga diskussioner som taggats "%1$s".',
        'PAGE_TITLE_COLON' => 'Sidrubrik:',
        'PAGE_CONTENT' => 'Innehåll:',
        'CREATE_PAGE' => 'Skapa sida',
        'CREATE_NEW_PAGE' => 'Skapa en ny sida',
        'YOUR_COMMENT' => 'Din kommentar',
        'ADD_YOUR_COMMENT' => 'Lägg till din kommentar',
        'DELETE_PAGE' => 'Ta bort sidan',
        'DELETE_THIS_PAGE_Q' => 'Ta bort sidan?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Är du säker på att du vill ta bort den här sidan (inklusive alla kommentarer)?  Denna bearbetning kan ta några minuter.',
        'SEARCH_PAGES' => 'Sök sidor',
        'ALL_PAGES' => 'Alla sidor',
        'SUBSCRIBE_TO_PAGES' => 'Prenumerera på sidorna',
        'NOBODY_HAS_ADDED_PAGES' => 'Ingen har lagt till några sidor än!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Skapa en sida för att komma igång.',
        'CREATE_A_PAGE' => 'Skapa en sida',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Ange sidans innehåll',
        'SEARCH_RESULTS_FOR_X' => 'Sökresultat för <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Redigera din sida',
        'UPDATE_PAGE' => 'Uppdatera sida',
        'CLOSE_DISCUSSION' => 'Stäng diskussion',
        'REOPEN_DISCUSSION' => 'Öppna diskussion igen',
        'CLOSING_DISCUSSION_PREVENTS' => 'Stängning av en diskussion förhindrar fler inlägg.',
        'NO_DISCUSSION_TO_DISPLAY' => 'Du visar inga diskussioner just nu.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Rutan kommer inte att synas för andra om du inte väljer minst en diskussion.',
        'NEWEST_DISCUSSIONS' => 'De senaste diskussionerna',
        'LATEST_REPLIES' => 'De senaste inläggen',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Den här diskussionen är stängd för fler inlägg.',
        'SORRY_DISCUSSION_CLOSED' => 'Vi är ledsna men diskussionen har just stängts för fler inlägg.',
        'MOST_REPLIES' => 'Flest inlägg',
        'OWNER_DISCUSSIONS_ONLY' => 'Diskussioner för skapare endast',
        'MY_DISCUSSIONS_ONLY' => 'Mina diskussioner endast',
        'DISCUSSION_DELETED' => 'Diskussion borttagen',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Diskussionen är inte tillgänglig längre.',
        'REPLY_DELETED' => 'Inlägg borttaget',
        'REPLY_HAS_BEEN_DELETED' => 'Inlägget har tagits bort  <a %s>Gå tillbaka till diskussionen. </a>',
        'VIEW_ALL_DISCUSSIONS' => 'Visa alla diskussioner',
        'ADD_CATEGORIES' => 'Lägg till kategorier',
        'CATEGORY' => 'Kategori:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'Det finns inga diskussioner i kategorin än.',
        'ADD_MANAGE_CATEGORIES' => 'Lägg till/hantera kategorier',
        'UNTITLED_CATEGORY' => 'Orubricerad kategori',
        'SAMPLE_TITLE' => 'Provtitel',
        'UNCATEGORIZED' => 'Okategoriserade',
        'EXISTING_DISCUSSIONS' => 'De aktuella diskussionerna har inte tilldelats någon kategori.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Det finns inga kategorier just nu.  Lägg till en kategori för att komma igång!',
        'ADD_A_CATEGORY' => 'Lägg till en kategori',
        'ADD_ANOTHER_CATEGORY' => 'Lägg till en kategori ytterligare',
        'MANAGE_CATEGORIES' => 'Hantera kategorier',
        'CATEGORY_TITLE' => 'Kategorititel',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Tillåt medlemmarna att starta diskussioner i den här kategorin',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Bara jag kan starta diskussioner i den här kategorin',
        'ALLOW_MEMBERS_TO_REPLY' => 'Tillåt medlemmarna att göra inlägg',
        'SUGGESTIONS' => 'Förslag:',
        'TRY_DIFFERENT_KEYWORDS' => 'Prova olika eller mer allmänna nyckelord',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Visa alla diskussioner</a> or <a %s>Starta en ny diskussion</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Kontrollera att alla ord är rättstavade',
        'REPLY_WAS_DELETED' => 'Inlägget togs bort',
        'TAGS_X' => '<strong>Taggar:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Skicka ett privat meddelande',
        'PERMALINK_TO_REPLY' => 'Permalänk för inlägget',
        'PERMALINK' => 'Permalänk',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Vi är ledsna men vi kunde inte hitta några diskussioner som matchade din sökning.',
        'DISCUSSIONS_MATCHING_X' => 'Diskussioner som matchar <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Sök diskussioner',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Du har inte lagt till några diskussioner än!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Lägg till diskussioner och upplev dem med dina vänner, med familjen eller med resten av världen!',
        'DISCUSSION' => 'Diskussion',
        'DISCUSSIONS' => 'Diskussioner',
        'KEEP_PAGE_OPEN_FORUM' => 'Håll sidan öppen så vi kan slutföra uppladdningen av filerna till forumet.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Under tiden får du gärna <a %s>öppna ett nytt fönster</a> och fortsätta använda %s.',
        'START_A_NEW_DISCUSSION' => 'Starta en ny diskussion',
        'DISCUSSION_TITLE' => 'Diskussionstitel:',
        'FIRST_POST' => 'Post:',
        'UPLOAD_FILES' => 'Bifoga fil(er):',
        'START_DISCUSSION' => 'Starta diskussion',
        'EDIT_DISCUSSION' => 'Redigera diskussion',
        'START_A_DISCUSSION' => 'Starta en diskussion',
        'ALL_DISCUSSIONS' => 'Forum startsida',
        'CONTRIBUTORS' => 'Bidragsgivare',
        'MY_DISCUSSIONS' => 'Mina diskussioner',
        'READ_MORE' => 'Läs mer',
        'STARTED_T_BY' => 'Startad <strong>%s</strong> av:',
        'ADDED_BY_X_T' => 'Tillagd av %s %s',
        'STARTED_BY_X_T' => 'Startad av %s %s',
        'REPLY_BY_X_T' => 'Inlägg av <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Startad av %s.  Senaste <a %s>inlägg</a> av %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Startade den här diskussionen. </strong> Senaste <a %s>inlägg</a> av %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>Startade den här diskussionen</strong> %s',
        'ADDED_REPLY_T' => '<strong>Lade till ett inlägg</strong> %s',
        'ADDED_POST_T' => '<strong>Lade till en post</strong> %s',
        'STARTED_BY_X_ON' => 'Startad av %s på %s',
        'STARTED_DISCUSSION_ON' => '<strong>Startade den här diskussionen</strong> %s',
        'STARTED_ON' => '<strong>Startad</strong> %s',
        'ADDED_REPLY_ON' => '<strong>Lade till ett inlägg</strong> %s',
        'ADDED_POST_ON' => '<strong>Lade till en post</strong> %s',
        'XS_DISCUSSIONS' => '%s diskussioner',
        'XS_DISCUSSIONS_LOWERCASE' => '%s diskussioner',
        'VIEW_XS_DISCUSSIONS' => 'Visa %s diskussioner',
        'VIEW_YOUR_DISCUSSIONS' => 'Visa dina diskussioner',
        'TAGGED_X' => 'Taggad: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Prenumerera på diskussionerna',
        'SUBSCRIBE_TO_DISCUSSION' => 'Prenumerera på den här diskussionen',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Prenumerera på %s\'s diskussioner',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Alla diskussioner taggade <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Prenumerera på diskussioner taggade \'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Uppladdning av filer',
        'ATTACHMENTS' => 'Bifogade filer',
        'YOUR_POST' => 'Din post:',
        'YOUR_REPLY' => 'Ditt inlägg:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Vill du ladda upp filer?',
        'ADD_YOUR_REPLY' => 'Lägg till ditt inlägg',
        'REPLIES_TO_THIS_DISCUSSION' => 'Inlägg i den här diskussionen',
        'POSTED_BY_X_ON' => 'Postade av %s %s',
        'PLEASE_ENTER_TITLE' => 'Ange en titel på diskussionen',
        'PLEASE_ENTER_FIRST_POST' => 'Skriv den första posten i diskussionen.',
        'REPLY_TO_THIS' => 'Gör ett inlägg på det här',
        'DELETE_ATTACHMENT' => 'Ta bort bifogad fil',
        'DELETE_ATTACHMENT_Q' => 'Ta bort den bifogade filen?',
        'DELETE_REPLY' => 'Ta bort Svar',
        'DELETE_THIS_DISCUSSION_Q' => 'Ta bort den här diskussionen?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Är du säker på att du vill ta bort den här diskussionen (inklusive alla inlägg)?  Denna bearbetning kan ta några minuter.',
        'DELETE_DISCUSSION' => 'Ta bort diskussion',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Ingen har lagt till några diskussioner än.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Ingen har lagt till några diskussioner än!  Lägg till en diskussion för att komma igång.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Du har inte lagt till några diskussioner än.  Lägg till en diskussion för att komma igång!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Du har inte startat några diskussioner än.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Du har inte lagt till några diskussioner än.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s har inte lagt till några diskussioner än.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s har inte startat några diskussioner än.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s har inte lagt till några diskussioner än.',
        'VIEW_DISCUSSIONS' => 'Visa diskussioner',
        'VIEW_ALL_PEOPLE_ON_X' => 'Visa alla andra på %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'Det finns inga diskussioner på ditt nätverk just nu.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Den här gruppen har inga diskussioner än.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Visa diskussioner på  <a %s>%s forum</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Det finns inga diskussioner som taggats "%1$s".  Titta på <a %2$s>taggade foton "%1$s"</a> eller <a %3$s>taggade videos "%1$s"</a>.  Eller lägg till och tagga dina egna diskussioner!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Det finns inga diskussioner som taggats "%1$s".  Titta på <a %2$s>taggade foton "%1$s"</a> eller <a %3$s>taggade videos "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Rutan kommer inte att synas för andra om det inte finns diskussioner att visa.  Varför inte starta en?',
        'DISCUSSIONS_I_STARTED' => 'Diskussioner jag Startade',
        'DISCUSSIONS_X_STARTED' => 'Diskussioner %s startade',
        'DISCUSSIONS_I_REPLIED_TO' => 'Diskussioner I Med inlägg',
        'DISCUSSIONS_X_REPLIED_TO' => 'Diskussioner %s med inlägg',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Skriv något till din post.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Skriv något till ditt inlägg.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Det finns en ny kommentar till din diskussion "%s" på %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Det finns en ny kommentar till en av dina diskussioner på %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'Någon gjorde en kommentar till en diskussion du startade på %s',
        'ABOUT_YOUR_DISCUSSION' => 'Om din diskussion',
        'ABOUT_THIS_DISCUSSION' => 'Om den här diskussionen',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s gjorde ett inlägg i en diskussion på %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s gjorde ett inlägg i diskussionen "%s" på %s',
        'PROBLEM_WITH_ICON' => 'Det uppstod ett problem med ikonfilen.',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Gruppadministratörer har en liknande kontrollnivå i förhållande till gruppens skapare.',
        'CREATE_NEW_GROUP' => 'Skapa ny grupp',
        'CREATE_A_NEW_GROUP' => 'Skapa en ny grupp',
        'CREATE_A_GROUP' => 'Skapa en grupp',
        'VIEW_GROUPS' => 'Visa grupper',
        'CREATE_GROUP' => 'Skapa grupp',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Välj ett namn på din grupp.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Välj en webbadress till din grupp.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'Webbadressen får endast innehålla bokstäver och siffror (inga mellanslag).',
        'NAME_TAKEN' => 'Vi beklagar – detta namn är redan upptaget.  Välj ett annat namn.',
        'URL_TAKEN' => 'Vi beklagar – denna webbadress är redan upptagen.  Välj en annan webbadress.',
        'GROUP_INFORMATION' => 'Gruppinformation',
        'EXTERNAL_WEBSITE' => 'Extern webbplats',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Har du en befintlig gruppwebbplats någon annanstans?',
        'URL' => 'URL',
        'GROUPS' => 'Grupper',
        'SEARCH_GROUPS' => 'Sök grupper',
        'NOBODY_HAS_CREATED_GROUPS' => 'Ingen har skapat några grupper än.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Ingen har skapat några grupper än!  Skapa en grupp för att komma igång.',
        'MY_GROUPS' => 'Mina grupper',
        'FEATURED_GROUPS' => 'Visade grupper',
        'YOU_CAN_CREATE_GROUP' => 'Du kan <a %s>skapa en ny grupp</a> på %s!',
        'GROUP_FORUM' => '%s Forum',
        'USER_CREATED_GROUP' => '%s skapade gruppen på %s.',
        'GROUP_MEMBERS_COUNT' => '%s Medlemmar (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Vi är ledsna men du får inte bli medlem i gruppen.',
        'JOIN_GROUP_NOW' => 'Gå med i %s nu!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s har bjudit in dig att bli medlem i %s',
        'DECLINE' => 'Avböj',
        'WELCOME_TO_GROUP' => 'Välkommen till %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Nu kan du delta i %s forum.',
        'SEND_MESSAGE_TO_GROUP' => 'Skicka meddelande till grupp',
        'LEAVE_THIS_GROUP' => 'Lämna grupp',
        'EDIT_GROUP_INFO' => 'Redigera gruppens info',
        'EDIT_GROUP_INFORMATION' => 'Redigera gruppinformation',
        'MANAGE_GROUP_MEMBERS' => 'Hantera gruppmedlemmar',
        'GROUP_HAS_NO_MEMBERS' => 'Gruppen har inga medlemmar än!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Gruppen har inga medlemmar som matchar din sökning.',
        'USERS_GROUPS' => '%ss grupper',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Du har inte skapat några grupper än.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s har inte skapat några grupper än.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Det finns inga grupper som visas på ditt sociala nätverk.',
        'START_FEATURING_GROUPS' => 'Börja visa grupper där du ser ett visningsalternativ.  För att lära dig mer om visning, <a %s>klicka här</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'Du visar inga grupper just nu.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Rutan kommer inte att synas för andra om du inte väljer minst en grupp.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Du har inte skapat några grupper än!',
        'CREATE_GROUPS_AND_SHARE' => 'Skapa grupper och visa dem för dina vänner, för familjen och för resten av världen!',
        'THERE_ARE_NO_GROUPS' => 'Det finns inga grupper på dit nätverk just nu.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Ruten kommer inte att synas för andra om det inte finns grupper att visa.  Varför inte skapa en?',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Grupper som matchar <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Vi beklagar men vi kunde inte hitta några grupper som matchar din sökning.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Visa alla grupper</a> eller <a %s>Skapa ny grupp</a>',
        'VIEW_ALL_GROUPS' => 'Visa alla grupper',
        'DELETE_GROUP' => 'Ta bort grupp',
        'DELETE_GROUP_Q' => 'Är du säker på att du vill ta bort den här gruppen?',
        'GROUP_INVITATIONS' => 'Gruppinbjudningar',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Du har bjudits in att gå med i:',
        'VISIT' => 'Besök',
        'WHO_CAN_JOIN_GROUP' => 'Vem kan gå med i gruppen?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'Integriteten kan inte ändras efter det gruppen skapats.',
        'ONLY_INVITED_PEOPLE' => 'Bara inbjudna',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Låt andra begära en inbjudan',
        'ANYONE_CAN_JOIN_GROUP' => 'Vem som helst kan gå med i gruppen',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Bara inbjudna kan gå med i gruppen',
        'WHY_NOT_CREATE_GROUP' => 'Varför inte <a %s>skapa en egen grupp</a>?',
        'PLEASE_ENTER_NAME' => 'Ange ditt namn',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Ange din e-postadress.',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Uppge en ny sidadress.',
        'PLEASE_ENTER_PASSWORD' => 'Ange ditt lösenord.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Klicka här för att skapa ett konto</a> eller försök logga in igen nedan.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Klicka här för att skapa ett konto</a> eller försök gå med på nytt nedan med ditt Ning ID.',
        'CHOOSE_SHORTER_PASSWORD' => 'Välj ett kortare lösenord.',
        'CHOOSE_SHORTER_NAME' => 'Välj ett kortare namn.',
        'ENTER_SHORTER_CITY_NAME' => 'Ange ett kortare ortsnamn.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Ange lösenordet på nytt i tutan ”Skriv lösenordet på nytt”.',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Ange ditt aktuella lösenord.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Ange ditt nya lösenord.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Ange ditt nya lösenord på nytt i rutan ”Bekräfta lösenord”.',
        'CURRENT_PASSWORD' => 'Aktuellt lösenord',
        'PASSWORDS_DO_NOT_MATCH' => 'De två lösenorden matchar inte.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'Det nya lösenordet och det bekräftande lösenordet matchar inte.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Din begäran har skickats till gruppens skapare.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s är ingen giltig e-postadress.',
        'COME_JOIN_ME_ON_GROUP' => 'Kom och gör mig sällskap på %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Bjud in andra till %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Bjud in vänner till %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Skicka inbjudan till andra att gå med i %s.',
        'GROUPNAME_MEMBERS' => '%s Medlemmar',
        'GROUP_CREATOR' => 'Gruppskapare',
        'GROUP_ADMINISTRATOR' => 'Gruppadministratör',
        'DATE_BANNED' => 'Datum för ban',
        'BAN_FROM_GROUP' => 'Banna från grupp',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Är du säker på att du vill banna den utvalda medlemmen/de utvalda medlemmarna från gruppen?  Denna bearbetning kan ta några minuter.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Ta också bort deras forumposter och inlägg.',
        'GROUP_WEB_ADDRESS' => 'Gruppwebbadress',
        'GROUP' => 'Grupp',
        'BACK_TO_GROUP' => '← Tillbaka till %s',
        'USER_BANNED_FROM_GROUP' => '%1$s har bannats från gruppen.  <a %2$s>Skicka %1$s ett meddelande</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s är redan medlem i gruppen.  <a %2$s>Skicka %1$s ett meddelande</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Gruppadministratörsdiskussioner',
        'BACK_TO_NETWORK_GROUPS' => 'Tillbaka till %s grupper',
        'MOST_MEMBERS' => 'Flest medlemmar',
        'THIS_SETS_URL_OF_GROUP' => 'Det anger gruppens URL som:<br />http://%s/<strong>gruppwebbadress</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Gillar du det du ser på %s?  Gå med nu!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Gillar du det du ser i %s?  Gå med nu!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Du har skapat gruppen %1$s. Du kan starta en diskussion på %1$s forum eller bjuda in andra att gå med.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Du är nu medlem i %1$s.  Du kan delta i %1$s forum eller bjuda in andra att gå med.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Nätverket har ingen musik än.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Personen har ingen musik än.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Hitta mer liknande musik på <em>%s</em>',
        'TRACKS' => 'Spår',
        'ADD_MUSIC_TRACKS' => 'Lägg till musik',
        'CHOOSE_MUSIC_TRACKS' => 'Välj låtar att lägga till',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Du kan lägga till upp till 4 MP3-or åt gången.',
        'UPLOAD_TRACKS' => 'Ladda upp låtar',
        'ADD_TRACKS' => 'Lägg till låtar',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Ange URL:en för varje MP3 du lägger till:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Du kan ladda upp så många som 100 MP3-or!  En MP3 fil får vara ända upp till 20MB men mindre filer laddas upp snabbare.',
        'BE_NICE' => 'Var just',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Ladda bara upp låtar om du har tillstånd från artisten eller copyrightinnehavaren att göra det.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Länka bara till musik som har tillstånd för spridning på webben.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Fler sätt att lägga till musik…',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '…från en annan webbplats',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Lägg till musik från en webbplats genom att klistra in en länk till MP3:n.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Håll sidan öppen så vi kan avsluta uppladdningen av låtarna och vi meddelar dig när de blivit godkända!',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Under tiden får du gärna <a %s>öppna ett nytt fönster</a> och fortsätta använda %s.  När uppladdningen är klar kan du lägga till titlar och låtbeskrivningar i fönstret.',
        'TRACKS_EXCEEDED_LIMIT' => 'Spåret(en) verkar överskrida gränsen på 10 MB per låt.',
        'EDIT_TRACK_INFORMATION' => 'Redigera låtinformation',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Lägg till en titel, en beskrivning och annan info om låtarna du just laddat upp.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Lägg till en titel, en beskrivning och annan info om låten.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Avbryt och gå tillbaka till spellistan',
        'TRACK_TITLE' => 'Låttitel',
        'TRACK_ARTIST' => 'Artist',
        'TRACK_ALBUM' => 'Album',
        'ENABLE_DOWNLOAD_LINK' => 'Aktivera hämtningslänk',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Tillåt andra att lägga in låten på sina sidor',
        'TRACK_ARTWORK' => 'Bildmaterial',
        'EDIT_PLAYLIST' => 'Redigera spellista',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Vill du göra om spellistan, klicka på låten och dra den till den plats där du vill att den ska spelas upp.',
        'ADD_MUSIC_ELLIPSIS' => 'Lägg till musik…',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '…från din dator',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Ladda upp MP3:or från din dator.',
        'DELETE_THIS_TRACK_Q' => 'Ta bort den här låten?',
        'DELETE_TRACK' => 'Ta bort låt',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Är du säker på att du vill ta bort den här låten?',
        'PLAY' => 'Spela upp',
        'GENRE' => 'Genre',
        'YEAR' => 'År',
        'LABEL' => 'Del',
        'EXPLICIT_LYRICS' => 'Uttrycksfull text',
        'ARTIST_SITE' => 'Artistplats',
        'HOSTING_SITE' => 'Värddatorplats',
        'LABEL_SITE' => 'Delplats',
        'LICENSE' => 'Licens',
        'SELECT_LICENSE' => '— Select license —',
        'LICENSE_NAME' => 'Licensnamn',
        'LICENSE_URL' => 'Licens URL',
        'MUSIC' => 'Musik',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Tillåt andra att ladda upp och dela ljud',
        'PLAYLIST' => 'Spellista',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Senaste',
        'FEATURED_TRACKS' => 'Framhållna',
        'HIGHEST_RATED_TRACKS' => 'Högst klassificerad',
        'NO_TRACKS_TO_PLAY' => 'Det finns ingen musik på ditt nätverk just nu.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Rutan kommer inte att visas för andra förrän det finns en låt eller podcast att spela.  Varför inte lägga till en?',
        'NO_TRACKS_ON_PLAYLIST' => 'Det finns inga låtar på spellistan just nu.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Spelaren kommer inte att visas för andra förrän det finns en låt eller podcast att spela.  Varför inte lägga till en?',
        'NO_FEATURED_TRACKS' => 'Det finns inga rekommenderade låtar på ditt nätverk.',
        'START_FEATURING_TRACKS' => 'Börja rekommendera låtar när du hör en låt som du vill ska finnas på förstasidan.',
        'VIEW_MUSICPLAYER' => 'Visa musikspelare',
        'MY_PLAYLIST' => 'Min spellista',
        'NETWORK_PLAYLIST' => 'Nätverksspellista',
        'COPYRIGHT' => 'Â© Alla rättigheter förbehålles',
        'CC_BY_X' => 'Creative Commons beteckning %s',
        'CC_BY_SA_X' => 'Creative Commons beteckning Dela lika %s',
        'CC_BY_ND_X' => 'Creative Commons beteckning Inga härledningar %s',
        'CC_BY_NC_X' => 'Creative Commons beteckning Icke-kommersiell %s',
        'CC_BY_NC_SA_X' => 'Creative Commons beteckning Icke-kommersiell Dela lika %s',
        'CC_BY_NC_ND_X' => 'Creative Commons beteckning Icke-kommersiell Inga härledningar %s',
        'PUBLICDOMAIN' => 'Offentlig domän',
        'FACEBOOK_CONFIRM_DISABLE' => 'Är du säker?',
        'FACEBOOK_PLAYER_DISABLE' => 'Inaktivera',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Musikspelare',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Tillåt vem som helst att lägga till ett program på sina Facebook-profilsidor som spelar upp ditt val av musik.',
        'FACEBOOK_MUSIC_BUTTON' => 'Skapa musikprogram &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Facebook-musikspelare redan aktiverad.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Videospelare',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Tillåt vem som helst att lägga till ett program på sina Facebook-profilsidor som spelar upp en video från ditt nätverk.',
        'FACEBOOK_VIDEO_BUTTON' => 'Skapa videoprogram &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Facebook-videospelare redan aktiverad.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Bildspel med foton',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Tillåt vem som helst att lägga till ett program på sina Facebook-profilsidor som spelar upp ett bildspel med foton från ditt nätverk.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Skapa ett program för fotobildspel &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Facebook-fotobildspel redan aktiverat.',
        'FACEBOOK_PLATFORM_LOGO' => 'Facebook-plattformslogotyp',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, som är en omtyckt socialt nätverksplats, tillåter att utomstående datautvecklare skapar program som kan läggas in på medlemmarnas profilsidor.  Förutom att programmen ger en bättre profilsidefunktionalitet kan de också användas till att förmå Facebookanvändare att söka sig till andra platser på webben.',
        'FACEBOOK_QUICK_INTRO_2' => 'Tack vare Ning behöver du inte vara datautvecklare för att göra reklam för ditt sociala nätverk på Facebook.  Vi har gjort allt det tunga jobbet och ditt nätverk har färdiga anpassningar för integration med Facebookprogrammet.  Välj bara bland alternativen nedan så integreras ditt sociala nätverk med Facebook på bara några sekunder.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Lägg till datautvecklar-knapp',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Installera ny programvaru-knapp',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Dina Facebookprogram',
        'FACEBOOK_EMBEDDING' => 'Facebookreklam',
        'FACEBOOK_SETUP' => 'Facebookreklam',
        'FACEBOOK_PROMOTING' => 'Göra reklam för program på Facebook',
        'FACEBOOK_VIEW_APP' => 'Visa program',
        'FACEBOOK_ADD_THE' => 'Lägg till',
        'FACEBOOK_RECENT' => 'Senaste',
        'FACEBOOK_RECENTLY_FEATURED' => 'Rekommenderat allra senast',
        'FACEBOOK_RECENTLY_ADDED' => 'Tillagt allra senast',
        'FACEBOOK_PROMOTED' => 'Framhållna',
        'FACEBOOK_RATED' => 'Högst klassificerad',
        'FACEBOOK_POPULAR' => 'Populär',
        'FACEBOOK_MUSIC_WIDGET' => 'Musikwidget',
        'FACEBOOK_VIDEO_WIDGET' => 'Videowidget',
        'FACEBOOK_PHOTO_WIDGET' => 'Fotowidget',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Första steg',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Klicka här för att gå till Facebook och börja skapa ditt program.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Det öppnar Facebook i ett nytt fönster.  Om du inte redan är inloggad på Facebook måste du logga in nu.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Om du inte skapat något program på Facebook blir du ombedd att lägga till Facebooks utvecklarprogram.  När du gjort det säger det ”Du har inga program".  Klicka då på <strong>Skapa ett</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Om du redan skapat ett program på Facebook hamnar du i Facebooks utvecklarprogram.  Klicka på <strong>Installera nytt program</strong> knappen.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Nästa: Instruktioner för hur du installerar ditt %s program så det fungerar på Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Installationsinstruktion',
        'FACEBOOK_INSTR_SETUP_1' => 'Bra!  Nu till detaljerna.  Facebook behöver lite grundinformation så du kan komma igång med programmet.  Följ bara stegen nedan.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Obligatoriska fält',
        'FACEBOOK_INSTR_SETUP_2' => 'Välj ett <strong>Programnamn</strong>.',
        'FACEBOOK_INSTR_SETUP_3' => 'Markera för att visa att du läst Facebooks villkorsdokument.',
        'FACEBOOK_INSTR_SETUP_4' => 'Öppna <em>Valfritt fält</em> avdelningen.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Grundalternativ',
        'FACEBOOK_INSTR_SETUP_5' => 'Lägg in din e-postadress i <strong>Support e-post</strong> fältet.',
        'FACEBOOK_INSTR_SETUP_6' => 'Klistra in följande webbadress i <strong>Återuppringning URL</strong> fältet:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Välj en <strong>Canvasside-URL</strong> (e.g. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Välj <strong>Ja</strong> på <em>Kan ditt program läggas till på Facebook</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Installationsalternativ',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Gör en <strong> Programbeskrivning</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Klistra in följande kod i <strong>Standard FBML</strong> fältet:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Som <strong>Standard profilrutekolumn</strong> ,välj <strong>Bred</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Som <strong>Standard profilrutekolumn</strong> ,välj <strong>Smal</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'I <strong>Sidnavig URL</strong> fältet, ange din <em>Canvasside URL</em> (som skapats i steg &#8216; f&#8217;  ovan).  Glöm inte att ta med http://apps.facebook.com/ delen av URL:en.',
        'FACEBOOK_INSTR_SETUP_11' => 'Skriv text till <strong>Bifogad fil åtgärd</strong>.  Det här är vad som visas om du skickar ett meddelande till någon på Facebook och vill inkludera något av dina program.  Om ditt program är ett bildspel kan du lägga in  foton från Nätverksnamnet.  Om ditt program är en videospelare kan du lägga in videos från Nätverketsnamnet.',
        'FACEBOOK_INSTR_SETUP_12' => 'Klistra in följande webbadress i <strong>Återuppringning URL</strong> fältet:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Inställningssida för Facebookprogram',
        'FACEBOOK_INSTR_SETUP_DONE' => 'När du är klar, klicka på  <strong>Skicka</strong> knappen.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Nästa: Hämta din API nyckel och hemlighet.',
        'FACEBOOK_API_INFO_TITLE' => 'Facebook API Information',
        'FACEBOOK_API_INFO_DESC' => 'För att göra klart installationen måste du ange din API nyckel och hemlighet och ditt programs URL i fälten nedan.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Du kan hitta API nyckeln och hemligheten på  <a %s>Min programsida på Facebook</a> (öppas i nytt fönster) under namnet på det program du just skapat.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Min programsida (visar platsen för API informationen)',
        'FACEBOOK_API_INFO_KEY' => 'API nyckel',
        'FACEBOOK_API_INFO_SECRET' => 'API hemlighet',
        'FACEBOOK_URL_INFO_TITLE' => 'Facebookprogram URL',
        'FACEBOOK_URL_INFO_DESC' => 'Program URL:en är samma som den  <strong>Canvasside URL</strong> som du angav på förra sidan (i steg &#8216; f&#8217; ).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Facebooks musikprogram borde spela:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Facebooks videoprogram borde spela upp den här videon:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Facebooks bildspelsprogram borde spela upp foton från:',
        'FACEBOOK_PROMOTING_ON' => 'Göra reklam på Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Installationsinstruktion',
        'FACEBOOK_API_INFO' => 'API information',
        'FACEBOOK_DISABLE' => 'Inaktivera det här programmet',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'till din Facebookprofil',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Tillbaka till reklam på Facebook',
        'FACEBOOK_EMBEDDING_DESC' => 'Tillåt Facebookanvändare att lägga in ditt nätverks widgets och emblem på sina profilsidor.',
        'FACEBOOK_PROMOTE' => 'För att få valuta för pengarna när det gäller att göra reklam för ditt nya program rekommenderar vi att du stegvis gör på följande sätt.  Samtliga alternativ är åtkomliga på Facebooks <strong><a %s>Mina program</a></strong> sida (länk öppnas i nytt fönster).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Ha en Om-sida',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Låt Facebookanvändare få veta vad ditt program går ut på genom att lämna en tydlig beskrivning.  För att redigera informationen, klicka på <strong>Redigera Om-sida</strong> länken bredvid det program som du modifierar.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Skicka programmet till Facebookkatalogen',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Berätta för alla om ditt nya program genom att lägga till det i Facebookkatalogen.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'För att skicka in ditt program, klicka på <strong>Skicka in program</strong> länken bredvid det program som du modifierar.  På följande sida kan du redigera programbeskrivningen och även lägga till en logotyp för ditt program.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Lägg programmet till din Facebookprofil',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Visa upp ditt program genom att lägga det till din Facebookprofilsida och luta dig sedan tillbaka och se dina vänner göra samma sak.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Klicka bara på <strong>Visa Om-sida</strong> länken bredvid det program du vill lägga till din profil och välj sedan Lägg till program-knappen på nästa sida.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Ditt program finns nu nertill på din Facebookprofilsida!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Mina programsidan på Facebook',
        'FACEBOOK_MY_APPS' => 'Mina program',
        'FORUM_TAB_TEXT' => 'Forum',
        'VIDEOS_TAB_TEXT' => 'Videor',
        'PHOTOS_TAB_TEXT' => 'Bilder',
        'GROUPS_TAB_TEXT' => 'Grupper',
        'ADD_PHOTOS_LOWER' => 'Lägg till Bilder',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param string $widgetTitle  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}