<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the Portuguese  (Brazil) locale.
 */
class XG_MessageCatalog_pt_BR extends XG_AbstractMessageCatalog  {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = '1 segundo atrás ';
            $a['N_SECONDS_AGO']['n'] = '%s segundos atrás ';
            $a['N_MINUTES_AGO']['1'] = '1 minuto atrás ';
            $a['N_MINUTES_AGO']['n'] = '%s minutos atrás ';
            $a['N_HOURS_AGO']['1'] = '1 hora atrás ';
            $a['N_HOURS_AGO']['n'] = '%s hora atrás ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> Vídeo ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> Vídeos ';
            $a['N_VIEWS']['1'] = '1 exibição ';
            $a['N_VIEWS']['n'] = '%s exibições ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> Comentário ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> Comentários ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Este vídeo é <strong>favorito</strong> de <strong>1 pessoa</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Este video é <strong>favorito</strong> de <strong>%s pessoas</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s adicionou um vídeo: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s adicionou %s vídeos. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Você adicionou um vídeo: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Você adicionou %s vídeos. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Há 1 vídeo em %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Há %1$s vídeos em %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Há 1 <a href="%3$s">vídeo</a> em %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Há %1$s <a href="%3$s">vídeos</a> em %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 foto deste álbum foi excluída ou se tornou particular, portanto não pode ser exibida. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s fotos deste álbum foram excluídas ou se tornaram particular, portanto não podem ser exibidas. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> Foto ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> Fotos ';
            $a['N_PHOTOS_2']['1'] = '1 foto ';
            $a['N_PHOTOS_2']['n'] = '%s fotos ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'e mais 1 pessoa ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'e mais %s pessoas ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Houve um problema ao carregar o seguinte arquivo: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Houve um problema ao carregar os seguintes arquivos: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Esta foto é <strong>favorita</strong> de<strong>1 pessoa</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Esta foto é <strong>favorita</strong> de<strong> %s pessoas</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Classificação:</strong> %2$s depois de 1 voto ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Classificação:</strong> %2$s depois de %s votos ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s depois de 1 voto ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s depois de %s votos ';
            $a['N_PEOPLE']['1'] = '1 pessoa ';
            $a['N_PEOPLE']['n'] = '%s pessoas ';
            $a['N_OF_5_STARS']['1'] = '1/5 estrela ';
            $a['N_OF_5_STARS']['n'] = '%s/5 estrelas ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Sua classificação: 1 estrela ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Sua classificação: %s estrelas ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s adicionou uma foto: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s adicionou %s fotos. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Você adicionou uma foto: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Você adicionou %s fotos. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Há 1 foto em %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Há %1$s fotos em %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Há %1$s <a href="%3$s">foto</a> em %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Há %1$s <a href="%3$s">fotos</a> em %2$s ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Comentário em sua página ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Comments on your page';;
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> Comentário de blog ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> Comentários de blog ';
            $a['N_YEARS_OLD']['1'] = '1 ano de idade ';
            $a['N_YEARS_OLD']['n'] = '%s anos de idade ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Você tem 1 pedido de amigo! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Você tem %s pedidos de amigos! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Caixa de Recados (1 comentário) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Caixa de Recados (%s comentários) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 novo membro se associou na última semana ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s novos membros se associaram na última semana ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">novo membro</a> se associou na última semana ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">novos membros</a> se associaram na última semana ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Há um membro em %2$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Há %1$s membros em %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Há 1 <a href="%3$s">membro</a> em %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Há %1$s <a href="%3$s">membros</a> em %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Há 1 lançamento no blog em %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Há %1$s lançamentos no blog em %2$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> Novo Membro ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> Novos Membros ';
            $a['N_REPLIES']['1'] = '1 resposta ';
            $a['N_REPLIES']['n'] = '%s respostas ';
            $a['N_MINUTES']['1'] = 'Falta 1 minuto para editar seu comentário. ';
            $a['N_MINUTES']['n'] = 'Faltam %s minutos para editar seu comentário. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Há 1 tópico de fórum em %2$s ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Há %1$s tópicos de fórum em %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Há 1 <a href="%3$s">tópico de fórum</a> em %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Há %1$s <a href="%3$s">tópicos de fórum</a> em %2$s ';
            $a['N_INVITES']['1'] = '%s convidam ';
            $a['N_INVITES']['n'] = '%s convida ';
            $a['N_MEMBERS']['1'] = '1 membro ';
            $a['N_MEMBERS']['n'] = '%s membros ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 membro) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s membros) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Há 1 grupo em %2$s ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Há %1$s grupos em %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Há %1$s <a href="%3$s">grupo</a> em %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Há %1$s <a href="%3$s">grupos</a> em %2$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 música nesta lista de reprodução não pode ser exibida porque foi excluída ou não pode mais ser compartilhada. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s músicas nesta lista de reprodução não podem ser exibidas porque foram excluídas ou não podem mais ser compartilhadas. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Uma nova música foi adicionada a %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s novas músicas foram adicionadas a %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s adicionou uma música: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s adicionou %s músicas. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Você adicionou uma música: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Você adicionou %s músicas. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 música adicionada à lista de reprodução. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s músicas adicionadas à lista de reprodução. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Há 1 música em %2$s ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Há %1$s músicas em %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = '1 convite foi enviado novamente. ';
            $a['N_INVITATIONS_RESENT']['n'] = '%s convites foram enviados novamente. ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Comentário de perfil ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Comentários de perfil ';
            }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Procurando',
        'MORE_VIDEOS' => 'Mais vídeos',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Esta rede ainda não possui nenhum vídeo.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Esta rede ainda não possui nenhum vídeo promovido como destaque.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Esta pessoa ainda não possui nenhum vídeo.',
        'COPY_TO_CLIPBOARD' => 'Copiar para a área de transferência',
        'COPIED_TO_CLIPBOARD' => 'Copiado para a área de transferência!',
        'NO_VIDEOS_TO_DISPLAY' => 'Você não está exibindo nenhum vídeo no momento.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Esta caixa não aparecerá para outras pessoas a não ser que você selecione pelo menos um vídeo.',
        'WATERMARK_LOGO' => 'Marca d\'água',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Você pode escolher entre um cabeçalho ou uma marca d\'água para usar em seu Video Player.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'O logo será exibido no topo de %s. Se não adicionar um logo, o nome da rede aparecerá no lugar. Seu logo deve estar no formato .jpg, .gif ou .png. Logos com mais de 20 pixels de altura serão redimensionados.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'A marca d\'água aparecerá sobre o canto inferior direito do vídeo clipe.',
        'HEADER_LOGO' => 'Cabeçalho',
        'WATERMARK' => 'Marca d\'água',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Personalize seu Video Player!',
        'VIDEO_PLAYER' => 'Video Player',
        'HEADER' => 'Cabeçalho',
        'SAVE_CHANGES' => 'Salvar mudanças',
        'THUMBNAIL' => 'Miniatura',
        'CONVERSION_FAILED' => 'Falha na conversão',
        'CONVERSION_IN_PROGRESS' => 'Conversão em andamento',
        'MAP' => 'Mapa',
        'WHAT_IS_THIS' => 'O que é isso?',
        'EDIT_VIDEO_INFORMATION' => 'Editar informações sobre o vídeo',
        'ALL_VIDEOS' => 'Todos os vídeos',
        'VIDEOS_HOME' => 'Início dos vídeos',
        'MY_VIDEOS' => 'Meus vídeos',
        'MY_FRIENDS_VIDEOS' => 'Vídeos de amigos',
        'MY_FAVORITES' => 'Meus favoritos',
        'XS_FAVORITES' => 'Favoritos de %s',
        'ADD_A_VIDEO' => 'Adicionar vídeo',
        'JUST_NOW' => 'agora mesmo',
        '1_DAY_AGO' => '1 dia atrás',
        'M_J' => 'd/m',
        'ME' => 'mim',
        'X_SAID' => '%s disse...',
        'DELETE_COMMENT' => 'Excluir comentário',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Você ainda não adicionou nenhum vídeo!',
        'ADD_VIDEOS_AND_SHARE' => 'Adicione vídeos e compartilhe-os com seus amigos, familiares ou com o resto do mundo!',
        'THERE_ARE_NO_VIDEOS' => 'Sua rede social não contém vídeos no momento.',
        'THIS_BOX_WILL_NOT_SHOW' => 'Esta caixa não aparecerá para outras pessoas enquanto não houver vídeo para ser exibido. Que tal adicionar um?',
        'ADD_VIDEOS' => 'Adicionar vídeos',
        'VIEW_VIDEOS' => 'Assistir vídeos',
        'YIKES' => 'Oh não!',
        'A_PROBLEM_SEEMS' => 'Parece que há um problema.',
        'FOR_FURTHER_ASSISTANCE' => '<a %s>Entre em contato conosco</a> para receber ajuda.',
        'OR_YOU_CAN_GO' => 'Você pode também <a %s>voltar para a página principal de %s</a> ou navegar por <a %s>outras Redes Sociais do Ning</a>',
        'TAGS' => 'Tags:',
        'POPULAR_TAGS' => 'Tags populares',
        'MY_FRIENDS' => 'Meus amigos',
        'VIEW_ALL_MY_FRIENDS' => 'Exibir todos meus amigos',
        'VIEW_ALL_XS_FRIENDS' => 'Exibir todos os amigos de %s',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Desculpe-nos, não foi encontrado nenhum resultado para sua busca.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Exibir principais colaboradores',
        'POPULAR_CONTRIBUTORS' => 'Principais colaboradores',
        'VIEW_MORE_CONTRIBUTORS' => 'Exibir mais colaboradores',
        'ADD_AS_FRIEND' => 'Adicionar como amigo!',
        'SEND_A_MESSAGE' => 'Enviar mensagem',
        'IS_YOUR_FRIEND' => 'É seu amigo',
        'IS_BLOCKED' => 'Está bloqueado',
        'SORT_BY' => 'Ordenar por:',
        'CLOSE' => 'Fechar',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Ninguém adicionou vídeos ainda! Adicione alguns para começar.',
        'SEARCH_PEOPLE' => 'Procurar pessoas:',
        'INVITE_YOUR_FRIENDS_TO' => 'Convide seus amigos para %s.',
        'INVITE' => 'Convidar',
        'INVITE_TAB_TEXT' => 'Convidar',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Você ainda não adicionou nenhum amigo em %s.',
        'SEARCH_FRIENDS' => 'Procurar amigos:',
        'ADD_YOUR_FIRST_VIDEO' => 'Adicionar seu primeiro vídeo',
        'USE_HTML_EMBED_CODE' => 'Usar Código HTML',
        'UPLOAD_A_VIDEO_FROM' => 'Carregue um vídeo de seu computador:',
        'WE_SUPPORT_MOV' => 'Aceitamos arquivos nos formatos .mov, .mpg, .mp4, .avi, .3gp e .wmv com até 100MB.',
        'NEED_HELP_HERE_ARE' => 'Precisa de ajuda? Confira as instruções para vídeos do <a %s>YouTube</a> e <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Adicionar título e descrição',
        'DESCRIPTION_COLON' => 'Descrição:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Adicione um título, descrição e outras informações ao vídeo que você acaba de carregar.',
        'EVERYTHING_IS_OPTIONAL' => 'Todos os campos são opcionais; se você não quiser preencher nada, apenas clique em "Pular esta etapa" à sua direita.',
        'SKIP_THIS_STEP' => 'Pular esta etapa',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Adicione um título, descrição e outras informações ao vídeo.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Cancelar e voltar ao vídeo',
        'TITLE' => 'Título:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Tags são pequenas descrições que lhe ajudam a encontrar seus vídeos. Separe as tags por vírgulas ou coloque tags com várias palavras entre aspas, como "São Paulo".',
        'WHO_CAN_VIEW_VIDEO' => 'Quem pode assistir a este vídeo?',
        'MOST_POPULAR' => 'Mais populares',
        'HIGHEST_RATED' => 'Classificação mais alta',
        'MOST_RECENT' => 'Mais recentes',
        'MOST_FAVORITED' => 'Favoritos',
        'MOST_POPULAR_VIDEOS' => 'Vídeos mais populares',
        'HIGHEST_RATED_VIDEOS' => 'Vídeos com classificação mais alta',
        'MOST_RECENT_VIDEOS' => 'Vídeos mais recentes',
        'MOST_FAVORITED_VIDEOS' => 'Vídeos favoritos',
        'ANYONE' => 'Qualquer um',
        'JUST_MY_FRIENDS' => 'Somente meus amigos',
        'JUST_ME' => 'Somente eu',
        'VIEWABLE_BY_FRIENDS' => 'Visível para <strong>amigos</strong>',
        'PRIVATE_VIDEO' => 'Vídeo <strong>Privado</strong>',
        'VIEWABLE_BY_EVERYONE' => 'Visível para <strong>todos</strong>',
        'LOCATION' => 'Local:',
        'NO_LOCATION' => 'Nenhum local',
        'CLICK_ON_LOCATION' => 'Clique em um local no mapa:',
        'FIND_AN_ADDRESS' => 'Encontrar um endereço:',
        'LOCATE' => 'Localizar',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Você pode <a %s>adicionar seu próprio vídeo</a> a %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Adicione um logotipo personalizado ou uma marca d\'água ao Video Player de sua rede. <a %s>Defina-o agora!</a>',
        'APPROVE' => 'Aprovar',
        'DELETE' => 'Excluir',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Aplicar a todos os vídeos adicionados por %s',
        'NO_TITLE' => 'Sem título',
        'ADDED_BY_STRONG_X' => 'Adicionado por <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Sem descrição',
        'BY_X' => 'por %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Você terminou o trabalho de moderador',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Não há mais vídeos a serem aprovados. Se estiver procurando algo para fazer, que tal assistir os <a %s>últimos vídeos</a>?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Ninguém adicionou vídeos à sua rede social. Seja o primeiro a fazer isso!',
        'ADDED_ON_DATE_BY_X' => '%s adicionado(s) por %s.',
        'REMOVE_FROM_FAVORITES' => 'Remover dos Favoritos',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Remover este vídeo de seus favoritos?',
        'COLLECTED_BY_X' => 'Colecionados por %s',
        'ADD_FAVORITES' => 'Adicionar aos Favoritos',
        'YOU_CAN_MARK_VIDEO' => 'Você pode selecionar qualquer vídeo como sendo um favorito. Basta clicar em "Adicionar aos Favoritos" quando ver este ícone em um vídeo.',
        'VIEW_RECENT_VIDEOS' => 'Exibir vídeos recentes',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s ainda não adicionou nenhum favorito.',
        'APPROVE_VIDEOS' => 'Aprovar vídeos',
        'YOUR_SITE_REQUIRES_YOU' => 'Você escolheu a opção de moderar fotos e vídeos em sua rede social antes de publicá-los. Para alterar esta opção, <a %s>clique aqui para ir à página de Privacidade</a> na configuração da sua rede e desmarque \'Aprovar novas fotos e vídeos\'.',
        'YOUR_SITE_ALLOWS_USERS' => 'Você escolheu a opção de não moderar fotos e vídeos em sua rede social antes de publicá-los. Para alterar esta opção, <a %s>clique aqui para ir à página de Privacidade</a> na configuração da sua rede e marque \'Aprovar novas fotos e vídeos\'.',
        'APPROVE_ALL_VIDEOS' => 'Aprovar todos os vídeos?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Você realmente deseja aprovar todos os vídeos? Isto pode levar alguns minutos.',
        'APPROVING' => 'Aprovando...',
        'APPROVE_ALL' => 'Aprovar todos',
        'DELETE_ALL_VIDEOS' => 'Excluir todos os vídeos?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Você realmente deseja excluir todos os vídeos não aprovados? Isto pode levar alguns minutos.',
        'DELETING' => 'Excluindo...',
        'DELETE_ALL' => 'Excluir todos',
        'XS_VIDEOS' => 'Vídeos de %s',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Remover todos os vídeos de %s?',
        'DELETE_ALL_XS_VIDEOS' => 'Remover todos os vídeos de %s',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Você realmente deseja excluir todos os vídeos de %s? Este processo pode levar alguns minutos.',
        'DELETE_THIS_VIDEO_Q' => 'Remover este vídeo?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Você realmente deseja remover este vídeo? Este processo pode levar alguns minutos.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Você ainda não adicionou nenhum vídeo. Adicione alguns para começar!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s ainda não adicionou nenhum vídeo.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Seus amigos ainda não possuem nenhum vídeo.',
        'ALL_VIDEOS_TAGGED_X' => 'Todos os vídeos com a tag \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Todos os vídeos com a tag <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'Não existe nenhum vídeo com a tag "%1$s". Confira <a %2$s>os tópicos com a tag "%1$s"</a><a %2$s>as fotos com a tag "%1$s"</a>. Ou adicione tags em seus próprios vídeos!',
        'FILES_MUST_BE_100MB' => 'Os arquivos podem ter até 100MB. Aceitamos os formatos .mov, .mpg, .avi, .3gp e .wmv.',
        'NEED_HELP' => 'Precisa de ajuda?',
        'HERE_ARE_INSTRUCTIONS' => 'Aqui estão as instruções para vídeos do <a %s>YouTube</a> e <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'A pessoa encarregada de %s quer analisar seu trabalho antes de mostrá-lo ao mundo.',
        'LEAVE_WINDOW_OPEN' => 'Deixe esta janela aberta enquanto o processo de carregamento estiver em andamento.',
        'KEEP_PAGE_OPEN' => 'Deixe esta página aberta para que possamos concluir o carregamento de seu vídeo e notificaremos você assim que ele for aprovado!',
        'MEANWHILE_FEEL_FREE' => 'Enquanto isso, fique à vontade para <a %s>abrir uma nova janela do navegador</a> e continuar usando %s. Quando o carregamento terminar, você poderá adicionar um título e descrição ao seu vídeo nesta janela.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Este vídeo está <strong>aguardando a aprovação</strong> do criador de %s.',
        'LOADING' => 'Carregando...',
        'EDIT_VIDEO' => 'Editar vídeo',
        'DELETE_VIDEO' => 'Remover vídeo',
        'YOU_NEED_TO_BE_MEMBER' => 'Você precisa ser um membro de %s para adicionar comentários!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Faça parte desta rede</a>',
        'ADD_A_COMMENT' => 'Adicione um comentário',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Deixe um comentário para %s',
        'MORE' => 'Mais',
        'PREVIOUS' => 'Anterior',
        'NEXT' => 'Próximo',
        'ABOUT_THIS_VIDEO' => 'Sobre este vídeo',
        'ABOUT_YOUR_VIDEO' => 'Sobre este vídeo',
        'ADDED_ON_DATE_BY' => 'Adicionado em <strong>%s</strong> por:',
        'VIEWS' => 'Exibições:',
        'COMMENTS' => 'Comentários',
        'COMMENTS_COLON' => 'Comentários:',
        'LOCATION_OF_VIDEO' => 'Localização deste vídeo:',
        'RELATED_VIDEOS' => 'Vídeos relacionados',
        'ALL_VIDEOS_TAGGED_X_X' => 'Todos os vídeos com a tag %s (%s)',
        'XS_VIDEOS_X' => 'Vídeos de %s (%s)',
        'XS_FAVORITES_X' => 'Favoritos de %s (%s)',
        'VIDEO_DETAILS' => 'Detalhes do vídeo',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Não foi especificado nem um arquivo nem um código embutido.',
        'VIDEO_UPLOADED_ON_X' => 'Vídeo carregado em %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Ocorreu um problema durante a conversão do vídeo para o formato Flash: %s',
        'STATUS_N' => 'Status %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Seu vídeo de título "%s" não foi adicionado em %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Seu vídeo não foi adicionado em %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Você enviou recentemente um vídeo para %s. Infelizmente, você não é membro de %s e não podemos entregar este vídeo.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'O carregamento do vídeo não foi concluído em %s',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'O carregamento de seu vídeo não foi concluído em %s.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Ocorreu um problema durante o carregamento de seu vídeo para %s',
        'THE_PROBLEM_WAS_X' => 'O problema foi: %s',
        'FOR_FURTHER_ASSISTANCE_2' => 'Para maiores informações e ajuda, contate-nos:',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Falha na transcodificação do vídeo %s em %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s carregou um vídeo que falhou na transcodificação.',
        'ERROR_MESSAGE' => 'Mensagem de erro:',
        'APPLICATION_NAME' => 'Nome do aplicativo:',
        'APPLICATION_ID' => 'ID do aplicação:',
        'VIDEO_ID' => 'ID do vídeo:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Carregamento do vídeo concluído em %s',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'o carregamento de seu vídeo foi concluído em %s',
        'YOUR_VIDEO_WAS_UPLOADED' => 'O carregamento de seu vídeo para %s foi feito com sucesso!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Este vídeo está aguardando aprovação.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Este vídeo ainda está sendo processado.',
        'ADD_VIDEO' => 'Adicionar vídeo',
        'VIDEO_BY_X' => 'Vídeo por %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'Há um novo comentário no seu vídeo "%s" em %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'Há um novo comentário em um de seus vídeos em %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'alguém comentou sobre um vídeo que você adicionou a %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'alguém carregou um vídeo em %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Outras maneiras de adicionar vídeos...',
        'FROM_YOUTUBE_OR_GOOGLE' => '...do YouTube ou Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Pegue o código HTML \'embutido\' de qualquer site de vídeos popular para adicioná-lo a esta rede social.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Adicione um vídeo do YouTube ou Google',
        'PASTE_IN_EMBED' => 'Cole aqui o código HTML \'embutido\' do vídeo:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Adicione vídeos pelo telefone ou e-mail',
        'VIDEO' => 'vídeo',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Não há vídeos que atendem ao critério selecionado.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Clique em \'Editar\' para mudar a configuração caso queira que esta caixa seja visível para outras pessoas.',
        'PLAY_AGAIN' => 'Reproduzir novamente',
        'SHARE' => 'Compartilhar',
        'EMBED' => 'Embutido',
        'REWIND' => 'Retroceder',
        'CHANGE_SIZE' => 'Alterar o tamanho',
        'FULLSCREEN' => 'Tela cheia',
        'EXIT_FULLSCREEN' => 'Sair da tela cheia',
        'HIDE' => 'Fechar',
        'COPY_AND_PASTE_LINK' => 'Copie e cole este link em um e-mail ou programa de mensagens instantâneas:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Ache outros vídeos como este em <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Assista a este vídeo em %s',
        'GET_EMBED_CODE' => 'Obter o código embutido',
        'MORE_PHOTOS' => 'Mais fotos',
        'THIS_ALBUM' => 'Este álbum',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Esta rede ainda não tem fotos.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Esta pessoa ainda não tem fotos.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Este álbum não tem fotos.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Veja mais fotos como esta em <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'Não há fotos disponíveis neste álbum no momento. <a %s>Clique aqui para ver todos os álbuns</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Este álbum não pode ser visto por outras pessoas na rede, pois suas fotos são visíveis apenas para você ou ainda não foram aprovadas.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Personalize seu reprodutor de slides!',
        'ADD_SLIDESHOW_LOGO' => 'Adicione um logotipo à exibição de slides de sua rede social. <a %s>Defina-o agora!</a>',
        'PHOTO_BY_X' => 'Foto adicionada por %s',
        'UPLOAD_PHOTOS' => 'Carregar fotos',
        'PLAYER_COLOR' => 'Cor do reprodutor',
        'SLIDESHOW_PLAYER' => 'reprodutor de slides',
        'SLIDESHOW' => 'exibição de slides',
        'FILTER' => 'Filtro',
        'SAVE_ALBUM' => 'Salvar álbum',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Aplicar estas informações às seguintes fotos',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'clique para adicionar uma descrição',
        'CHECK' => 'Marcar',
        'YOU_NEED_TO_BE_X' => 'Apenas %s pode fazer isso.',
        'ALL_PHOTOS' => 'Todas as fotos',
        'POPULAR_PHOTOS' => 'Fotos populares',
        'FEATURED_PHOTOS' => 'Fotos de destaque',
        'PHOTOS_HOME' => 'Todas as fotos',
        'ALL_ALBUMS' => 'Todos os álbuns',
        'MY_PHOTOS' => 'Minhas fotos',
        'MY_ALBUMS' => 'Meus álbuns',
        'ADD_PHOTOS' => 'Adicionar fotos',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Adicione fotos',
        'EDIT' => 'Editar',
        'CHOOSE_PHOTOS' => 'Escolher as fotos',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Adicione fotos arrastando-as</strong> para seu álbum à direita. Arraste-as de volta para removê-las.',
        'TITLE_YOUR_ALBUM' => '<strong>Dê título ao seu álbum.</strong> Dê-lhe uma capa e descrição.',
        'SAVE_YOUR_ALBUM' => 'Salve seu álbum!',
        'CHOOSE_FROM' => 'Escolha de:',
        'EVERYONES_PHOTOS' => 'Fotos de todos',
        'TAGGED' => 'Com a tag:',
        'OLDER_PHOTOS' => 'Fotos mais antigas',
        'MORE_RECENT_PHOTOS' => 'Fotos mais recentes',
        'YOUR_ALBUM' => 'Seu álbum',
        'DRAG_ALBUM_COVER_HERE' => 'Arraste uma capa de álbum aqui',
        'ALBUM_TITLE' => 'Título do álbum:',
        'ALBUM' => 'álbum',
        'DRAG_PHOTOS_HERE' => 'Arraste suas fotos aqui',
        'PREVIOUS_ALBUM_PAGE' => 'Página anterior do álbum',
        'NEXT_ALBUM_PAGE' => 'Próxima página',
        'ADDED_ON_DATE' => 'Adicionado(s) %s',
        'VIEW_AS_SLIDESHOW' => 'Exibir em slides',
        'CREATED_BY_ME' => 'Criado por <a %s>mim</a>',
        'CREATED_BY_X' => 'Criado por %s',
        'OUR_APOLOGIES' => 'Desculpe-nos',
        'ADD_PHOTOS_TO_ALBUM' => 'Adicione mais fotos a este álbum escolhendo uma das opções abaixo.',
        'YOU_CAN_ADD_PHOTOS' => 'Você pode <a %s>adicionar fotos a este álbum agora mesmo</a>.',
        'SITE_IS_GETTING_STARTED' => 'Esta rede social está apenas começando!',
        'NO_ONE_CREATED_ALBUMS' => 'Aparentemente nenhum álbum foi criado ainda. Você pode <a %s>criar um álbum agora mesmo</a>.',
        'EDIT_YOUR_ALBUM' => 'Editar seu álbum',
        'ALBUMS_WITH_THIS_PHOTO' => 'Todos os álbuns contendo esta foto',
        'ALBUMS_WITH_X' => 'Todos os álbuns com \'%s\'',
        'ALBUMS_WITH_X_2' => 'Todos os álbuns com <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Não há álbuns contendo esta foto. Você pode <a %s>criar um novo álbum</a>.',
        'XS_ALBUMS' => 'Álbuns de %s',
        'CREATE_AN_ALBUM' => 'Criar um álbum',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Você ainda não criou nenhum álbum. Você pode <a %s>criar um agora</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s ainda não criou nenhum álbum.',
        'MAKE_AN_ALBUM' => 'Crie um álbum',
        'ABOUT_THIS_ALBUM' => 'Sobre este álbum',
        'ABOUT_YOUR_ALBUM' => 'Sobre seu álbum',
        'EDIT_ALBUM' => 'Editar álbum',
        'DELETE_THIS_ALBUM' => 'Excluir este álbum?',
        'DELETE_ALBUM' => 'Excluir álbum',
        'START_SLIDESHOW' => 'Iniciar exibição de slides',
        'ALBUM_IS_NOW_EMPTY' => 'Este álbum se encontra vazio.',
        'YOU_ARE_GETTING_STARTED' => 'Você está apenas começando!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Você ainda não adicionou nenhuma foto!',
        'ADD_PHOTOS_AND_SHARE' => 'Adicione fotos e compartilhe-as com seus amigos, familiares e o resto do mundo!',
        'ADD_A_PHOTO' => 'Adicionar foto',
        'NO_PHOTOS_ON_SITE' => 'Sua rede social não contém fotos por enquanto.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Está caixa não será vista por outras pessoas até que haja fotos a serem exibidas. Que tal adicionar uma?',
        'VIEW_EMBED_CODE' => 'Exibir código',
        'VIEW_SLIDESHOW' => 'Exibição de slides',
        'VIEW_PHOTOS' => 'Exibir fotos',
        'ADD_YOUR_FIRST_PHOTOS' => 'Adicione suas primeiras fotos',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Você pode <a %s>adicionar suas fotos</a> a %s!',
        'UPLOAD_PHOTOS_FROM' => 'Carregue fotos de seu computador:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Adicione título e descrição a suas fotos',
        'EDIT_PHOTO_INFORMATION' => 'Editar informações sobre a foto',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Adicione um título, descrição e outras informações às fotos recém-adicionadas.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Adicione um título, descrição e outras informações a esta foto.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Cancelar e voltar à foto',
        'WHO_CAN_VIEW_PHOTO' => 'Quem pode ver esta foto?',
        'CAN_BE_VIEWED_BY' => 'Pode ser vista por:',
        'BY_ME' => 'por <a %s>mim</a>',
        'RSS_FEED_LABEL' => '<a %s>RSS Feed</a> –  %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Não há mais fotos a serem aprovadas. Se estiver procurando algo para fazer, que tal dar uma olhada nas <a %s>últimas fotos</a>?',
        'APPROVE_ALL_PHOTOS' => 'Aprovar todas as fotos?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Você realmente deseja aprovar todas as fotos? Isto pode levar alguns minutos.',
        'DELETE_ALL_PHOTOS' => 'Excluir todas as fotos?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Você realmente deseja excluir todas as fotos não aprovadas? Isto pode levar alguns minutos.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Deixe esta janela do navegador aberta enquanto as fotos estiverem sendo aprovadas. Este processo pode levar alguns minutos.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Deixe esta janela do navegador aberta enquanto as fotos estiverem sendo excluídas. Este processo pode levar alguns minutos.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Aplicar a todas as fotos adicionadas por %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Ninguém adicionou fotos à sua rede social. Você pode ser o primeiro a <a %s>adicionar fotos.</a>',
        'UNTITLED' => 'Sem título',
        'A_PROBLEM_OCCURRED' => 'Ocorreu um problema',
        'PHOTOS_EXCEEDED_LIMIT' => 'A(s) foto(s) aparentemente excedeu o limite de 10 MB por foto.',
        'GET_A_SLIDESHOW_OF' => 'Obter uma exibição de slides para: %s',
        'GET_A_SLIDESHOW' => 'Obtenha uma exibição de slides!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Obtenha uma exibição de slides destas fotos',
        'COPY_AND_PASTE_SLIDESHOW' => 'Copie e cole o código abaixo para fazer uma exibição de slides destas fotos em seu website, blog, ou outra rede no Ning.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Copie e cole o código abaixo para ter uma exibição de slides deste álbum em seu website, blog, ou outra rede no Ning.',
        'LARGE_VERSION' => 'Tamanho grande',
        'SMALL_VERSION' => 'Tamanho pequeno',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Ver esta exibição de slides em tamanho maior',
        'PHOTOS' => 'Fotos',
        'XS_PHOTOS' => 'Fotos de %s',
        'XS_PHOTO' => 'Foto de %s',
        'YOU_CAN_MARK_PHOTO' => 'Você pode selecionar qualquer foto como sendo uma favorita. Basta clicar em "Adicionar aos Favoritos" quando ver este ícone em uma foto.',
        'VIEW_RECENT_PHOTOS' => 'Fotos recentes',
        'APPROVE_PHOTOS' => 'Aprovar fotos',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Excluir todas as fotos de %s?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Você realmente deseja excluir todas as fotos de %s? Este processo pode levar alguns minutos.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Excluir %1$s e todo o conteúdo de %1$s de sua rede social',
        'SUCCESS' => 'Êxito.',
        'DELETING_CONTENT' => 'Excluindo conteúdo...',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Deixe esta janela do navegador aberta enquanto o conteúdo estiver sendo excluído. Este processo pode levar alguns minutos.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Deixe esta janela do navegador aberta enquanto os membros são removidos. Este processo pode levar alguns minutos.',
        'DELETE_ALL_XS_PHOTOS' => 'Remover todas as fotos de %s',
        'CREATE_A_NEW_ALBUM' => 'Criar um novo álbum',
        'VIEW_ALL_XS_ALBUMS' => 'Exibir todos os álbuns de %s',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Você ainda não adicionou nenhuma foto. Adicione algumas para começar!',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s ainda não adicionou nenhuma foto.',
        'MY_FRIENDS_PHOTOS' => 'Fotos de amigos',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Exibir estas fotos em slides!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Seus amigos ainda não possuem nenhuma foto',
        'ALL_PHOTOS_TAGGED_X' => 'Todas as fotos com a tag \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Todas as fotos com a tag <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'Não existem fotos com a tag "%1$s". Confira <a %2$s>tópicos com a tag "%1$s"</a> ou a %3$s>vídeos com a tag "%1$s"</a>. Ou adicione tags a suas próprias fotos!',
        'SELECT_YOUR_PHOTOS' => 'Selecione suas fotos',
        'PHOTO_MAY_BE_10MB' => 'Cada foto pode ter até 10MB, mas fotos menores serão carregadas com mais rapidez!',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Deixe esta janela aberta para que possamos concluir o carregamento de suas fotos e notificaremos você assim que forem aprovadas!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Enquanto isso, fique à vontade para <a %s>abrir uma nova janela do navegador</a> e continuar usando %s. Quando o carregamento terminar você poderá adicionar título e descrição às suas fotos nesta janela.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Esta foto está <strong>aguardando aprovação</strong> do criador de %s.',
        'ADD_TO_FAVORITES' => 'Adicionar aos Favoritos',
        'EDIT_PHOTO' => 'Editar foto',
        'DELETE_PHOTO' => 'Excluir foto',
        'ABOUT_THIS_PHOTO' => 'Sobre esta foto',
        'LOCATION_OF_PHOTO' => 'Localização desta foto:',
        'ALBUMS_FEATURING_PHOTO' => 'Álbuns contendo esta foto',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Exibir todos os álbuns contendo esta foto',
        'RETURN_TO_X' => 'Voltar para %s',
        'RETURN_TO_PHOTOS_HOME' => 'Retornar à página inicial de fotos',
        'WE_COULD_NOT_FIND_ANYONE' => 'Desculpe-nos, não encontramos ninguém',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Ninguém adicionou fotos ainda! Adicione algumas para começar.',
        'DEFAULT_TITLE' => 'Título',
        'DEFAULT_DESCRIPTION' => 'Descrição',
        'UPLOAD_LIMIT_EXCEEDED' => 'O limite de tamanho de arquivo a carregar foi excedido.',
        'SLOW_DOWN_THERE_CHIEF' => 'Desculpe-nos!',
        'I_DO_NOT_KNOW_USER' => 'Desculpe, não conheço esta pessoa.',
        'I_DO_NOT_HAVE_PHOTO' => 'Desculpe, não tenho esta foto.',
        'I_DO_NOT_HAVE_ALBUM' => 'Desculpe, não tenho este álbum.',
        'ALBUM_BY_X_ON_X' => 'Álbum de %s em %s',
        'SENT' => 'Enviado!',
        'I_HAVE_RECENTLY_ADDED' => 'Adicionei recentemente',
        'FROM_THE_BAZEL' => 'Desta rede',
        'RECENTLY_ADDED' => 'Recém-adicionados',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Fotos públicas recentes em %s',
        'X_ALL_PHOTOS' => '%s - Todas as fotos',
        'NO_TAG_WAS_SPECIFIED' => 'Nenhuma tag foi especificada',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Fotos públicas com a tag %s em %s',
        'XS_PUBLIC_PHOTOS_ON_X' => 'Fotos públicas de %s em %s',
        'WE_DO_NOT_KNOW_USER' => 'Não conhecemos esta pessoa.',
        'XS_FRIENDS_PHOTOS' => 'Fotos dos amigos de %s',
        'XS_FAVORITE_PHOTOS_ON_X' => 'Fotos favoritas de %s em %s',
        'PHOTO_UPLOADED_ON_X' => 'Foto carregada em %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'O arquivo excedeu o tamanho máximo',
        'PART_OF_FILE_WAS_UPLOADED' => 'O carregamento do arquivo foi feito parcialmente',
        'NO_FILE_WAS_UPLOADED' => 'Ocorreu uma falha durante o carregamento; o nome do arquivo pode ser incorreto',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Ocorreu um problema durante o carregamento.',
        'ALPHABETICAL' => 'Ordem alfabética',
        'MOST_VIEWS' => 'Mais visitadas',
        'RATING_NOT_RATED_YET' => '<strong>Classificação:</strong> Ainda sem classificação',
        'NOT_RATED_YET' => 'Ainda sem classificação',
        'HMM_SOMETHING_WENT_AWRY' => 'Humm... algo deu errado',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Sua foto "%s" não pôde ser adicionada em %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Sua foto não pôde ser adicionada em %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Você tentou enviar um vídeo para %s. Infelizmente, você não é membro de %s e por isso não podemos entregar esta foto.',
        'ONLY_MY_FRIENDS' => 'Apenas meus amigos',
        'ANYBODY' => 'Qualquer um',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Apenas meus amigos podem ver esta foto',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Apenas os amigos de %s podem ver esta foto',
        'ONLY_I_CAN_SEE_PHOTO' => 'Apenas você pode ver esta foto',
        'ONLY_X_CAN_SEE_PHOTO' => 'Apenas %s pode ver esta foto',
        'EVERYONE_CAN_SEE_PHOTO' => 'Todos podem ver esta foto',
        'PRIVATE_PHOTO' => 'foto <strong>Particular</strong>',
        'HOWDY_STRANGER' => 'Olá, estranho!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Você precisa estar conectado ao Ning para fazer isso.',
        'JUST_CLICK_ON_SIGN_IN' => 'Clique em "Entrar" acima, ou caso ainda não possua uma conta no Ning, clique em "Cadastre-se".',
        'YOU_NEED_TO_BE_' => 'Apenas %s pode fazer isso.',
        'YOU_NEED_TO_BE_OWNER' => 'Você precisa ser o criador da rede para fazer isso.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Esta foto aguarda aprovação.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Você precisa ser amigo de %s para fazer isso.',
        'MOST_ACTIVE' => 'Mais ativos',
        'HOW_IT_WORKS' => 'Como funciona',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Outras maneiras de adicionar fotos...',
        'BY_PHONE_OR_EMAIL' => '...por telefone ou e-mail',
        'FROM_FLICKR' => '...do Flickr',
        'FROM_YOUR_COMPUTER' => '...de seu computador',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Adicione fotos da sua conta no Flickr.',
        'MORE_INFORMATION' => 'Mais informações',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Adicione fotos pelo telefone ou e-mail',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Envie uma foto ou vídeo por e-mail. O assunto do e-mail será usado como título da foto ou vídeo, e o conteúdo do e-mail é usado como descrição.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Clique aqui para obter um novo endereço de e-mail',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Carregue fotos do seu computador.',
        'PHOTO' => 'foto',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Você não está exibindo nenhuma foto no momento.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Esta caixa não aparecerá para outras pessoas a não ser que você selecione ao menos uma foto.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'Há um novo comentário em sua foto "%s" em %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'Há um novo comentário em uma de suas fotos em %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'alguém fez um comentário sobre uma foto que você adicionou a %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'alguém carregou uma nova foto em %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Adicione fotos ou vídeos a %s diretamente de seu telefone enviando-os para um endereço de e-mail.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Deseja realmente remover este item de seus favoritos?',
        'DELETE_THIS_PHOTO_Q' => 'Excluir esta foto?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Deseja realmente excluir esta foto? Este processo pode levar alguns minutos.',
        'PHOTO_SLIDESHOW' => 'Exibição de slides',
        'THUMBNAILS' => 'Miniaturas',
        'DETAIL' => 'Detalhes',
        'TAG' => 'Tag',
        'RATE' => 'Classificação',
        'ALL_SIZES' => 'Todos os tamanhos',
        'ADD_TO_ALBUM' => 'Adicionar a um álbum',
        'ROTATE_PHOTO' => 'Girar a foto',
        'ABOUT_YOUR_PHOTO' => 'Sobre sua foto',
        'SEE_PHOTOS_ON_NETWORK' => 'Veja estas fotos em %s',
        'EMBED_CODE' => 'Código embutido',
        'IMPORT_PHOTOS_FLICKR' => 'Obtenha suas fotos do Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Clique aqui para continuar no Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Para obter suas fotos do Flickr, é necessário permitir que %S faça um link com sua conta no Flickr.',
        'IMPORT_PHOTOS' => 'Importar fotos',
        'GET_MY' => 'Obter minhas',
        'GET_PHOTOS' => 'Obter fotos',
        'MOST_RECENT_PHOTOS' => 'fotos mais recentes',
        'GET_ALL_MY_FLICKR' => 'Obter todas as minhas fotos do Flickr (pode demorar um tempo)',
        'GET_ALL_MY_TAGGED' => 'Obter todas as minhas fotos que contém tag',
        'GET_PHOTOS_FROM_SET' => 'Obter fotos da série:',
        'GET_STARTED_BY_IMPORT' => 'Os títulos, tags e informações de mapeamento presentes nas fotos serão obtidos automaticamente.<br/>Quanto tempo demora?</p> <p><ul style="padding-top:10px;"><li>10 fotos: <em>menos de 30 segundos</em>.</li><li>50 fotos: <em>aproximadamente 2 minutos</em>.</li><li>200 fotos: <em>aproximadamente 6 minutos</em>.</li><li>500 fotos: <em>aproximadamente 15 minutos</em>.</li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Se você não estiver conectado ao Flickr, o acesso será solicitado. Uma vez conectado, clique no botão "OK, I\'ll allow it" (OK, eu permito).',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Obtenha também as descrições (isto dobrará o tempo que leva)',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Deixe esta janela aberta até que o processo de importar fotos termine.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Obtenha a versão original de cada foto (isto aumentará substancialmente o tempo de importação e não recomendamos fazer isso com mais de 20 fotos).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => '<p>Clique em "Editar" para adicionar texto, vídeos, fotos, ou qualquer outro componente gráfico a esta caixa. Esta é mais uma das maneiras de personalizar sua página.</p>',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Clique em "Editar" para adicionar texto, HTML, vídeo, fotos, ou qualquer outro <a %1$s>componente gráfico de terceiros</a> a esta caixa. É mais uma maneira de personalizar a sua página %2$s.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Esta caixa não aparecerá para outros até que você atualize o seu conteúdo.',
        'YOUR_X_BOX' => 'Sua caixa %s',
        'ABOUT_WIDGETS' => 'Sobre os componentes gráficos',
        'HELP' => 'Ajuda',
        'WIDGETS' => 'Componentes de interface',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Procurando adicionar mais funcionalidades à sua rede social? Talvez um calendário, previsão do tempo local, contagem regressiva para algum evento ou quem sabe uma webcam? Com os componentes gráficos é fácil adicionar novos atrativos às caixas de texto de sua rede.',
        'GETTING_STARTED' => 'Como começar',
        'BELOW_IS_LIST_OF_WIDGET' => 'Abaixo se encontra uma <a %s>lista de fornecedores de componentes gráficos</a> que você pode querer conferir. Selecionamos alguns componentes gráficos do <a %s>yourminis.com</a> para lhe ajudar. Basta configurar um componente gráfico abaixo, copiar o código embutido e colar diretamente na caixa de texto.',
        'CALENDAR' => 'Calendário',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'O componente gráfico de calendário não exibe apenas a data, mas também permite buscar e adicionar eventos em formato iCal (utilizado pelo Google Calendar e diversos outros provedores de calendários online).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Utilize o botão &#8220;editar componente gráfico&#8221; para selecionar &#8220;procurar eventos&#8221;, e entre então com um termo de busca (tente feriados, um time esportivo, etc.). Depois escolha um resultado da busca para ter estes eventos adicionados ao seu calendário. Você pode também inserir manualmente o endereço de um iCal existente.',
        'CUSTOMIZATION' => 'Personalização',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Você pode personalizar a aparência de seu componente gráfico passando o mouse sobre ele, e clicando no ícone de paleta de cores para mudar a cor de fundo, estilo e intensidade da transparência. Quando estiver pronto, clique no link &#8220;copiar para a web&#8221; e em seguida no botão &#8220;copiar código embutido&#8221;. Uma vez copiado o código, retorne para uma caixa de texto de sua rede, cole o código e salve suas mudanças. Tudo pronto!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Obtenha mais componentes gráficos em yourminis.com »',
        'WEATHER' => 'Previsão do tempo',
        'WEATHER_WIDGET_DISPLAYS' => 'O componente gráfico de previsão do tempo exibe previsões do tempo locais feitas pelo Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Utilize o botão &#8220;editar componente gráfico&#8221; para selecionar sua localização e escolher entre Celsius ou Fahrenheit. Você pode optar por exibir a previsão do dia apenas, ou expandir para até cinco dias à frente.',
        'COUNTDOWN' => 'Contagem regressiva',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'O componente gráfico de contagem regressiva lhe permite criar uma contagem regressiva para um evento específico. Clicando no botão &#8220;editar componente gráfico&#8221; você pode escolher a data, horário e título ou imagem de algum evento para saber quanto tempo falta.',
        'WEBCAM' => 'Webcam',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'O componente gráfico de Webcam lhe permite monitorar qualquer webcam disponível publicamente. Use o botão &#8220;editar componente gráfico&#8221; para selecionar câmeras da web a partir de uma lista predefinida, ou entre manualmente com o endereço URL de uma webcam.',
        'MORE_WIDGETS' => 'Mais componentes gráficos',
        'NEED_MORE_OPTIONS' => 'Precisa de mais opções? Recomendamos qualquer um dos sites a seguir para saciar sua sede de componentes gráficos:',
        'MODERATION_DENIED_ON_X' => 'Reprovação de moderador em %s em %s',
        'MODERATION_DENIED_ON_A_X' => 'Reprovação de moderador em seu(suas) %s em %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Você tem um(a) novo(a) %s para moderar em %s',
        'NEW_X_TO_MODERATE' => 'Há um(a) novo(a) %s para você moderar.',
        'MODERATION_APPROVED_ON_X' => 'Aprovação de moderador em %s em %s',
        'MODERATION_APPROVED_ON_A_X' => 'Aprovação de moderador em %s em %s',
        'JOIN' => 'Associar-se',
        'WELCOME' => 'Bem-vindo',
        'WELCOME_TO_X' => 'Bem-vindo a %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Bem-vindo a %s...',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Novos recursos!</h3>
            <ul><li><strong>Grupos</strong> &ndash; Permita que seus membros criem grupos em sua rede</li>
                <li><strong>Music Player</strong> &ndash; Adicione música e podcasts à sua rede</li></ul>
            <p><a href="%s" class="desc add">Clique aqui para adicionar recursos</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Novos recursos!</h3>
            <ul><li><strong>Última atividade</strong> &ndash; Acompanhe as últimas atividades de membro em sua rede</li>
                <li><strong>Badges e componentes gráficos</strong> &ndash; Promova sua rede na web com badges e componentes gráficos</li></ul>
            <p><a href="%s" class="desc add">Clique aqui para adicionar/editar recursos</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Seu(sua) %2$s, %1$s, recebeu um novo comentário adicionado por alguém em %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Seu(sua) %1$s recebeu um novo comentário adicionado por alguém em %2$s!',
        'HERE_IS_LINK' => 'Aqui está o link para se associar: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Obrigado,',
        'THANKS' => 'Obrigado!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Você alterou seu endereço de e-mail em %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Você alterou seu endereço de e-mail em %s...',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Clique aqui para acessar utilizando seu novo endereço de e-mail:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Você não alterou seu endereço de e-mail, clique aqui:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Para parar de receber notificações sobre novos tópicos, vá em:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s iniciou um novo tópico em %2$s...',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s iniciou o tópico "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Para ver este tópico, vá em:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s convidou você para fazer parte de %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s gostaria que você visse "%s" em %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Veja "%s" em %s!',
        'ABOUT_X' => 'Sobre %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Você recebeu este e-mail porque %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Caso não queira mais receber notificações por e-mail de %s, <a %s>clique aqui</a>.',
        'CLICK_HERE' => 'Clique aqui',
        'YOU_CAN_CONTACT_US' => 'Para entrar em contato sobre dúvidas ou considerações com relação à sua privacidade utilize o endereço http://help.ning.com/?page_id=27.',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Uma mensagem a todos os membros de %s',
        'CLICK_TO_CHECK_OUT' => 'Clique aqui para conferir!',
        'CLICK_TO_APPROVE_X' => 'Clique aqui para aprovar/excluir este(a) %s',
        'YOUR_X_HAS_BEEN_APPROVED' => 'Seu(sua) %s foi aprovado(a)!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Desculpas! Seu(sua) %s foi reprovado em %s.',
        'CLICK_TO_VIEW_X' => 'Clique aqui para ver este(a) %s',
        'CLICK_TO_VIEW_IT' => 'Clique aqui para ver',
        'TO_VIEW_USER_PROFILE_VISIT' => 'Para ver o perfil de %s, visite:',
        'YOU_ADDED_CONTENT' => 'você adicionou conteúdo em %s, uma rede social moderada',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s relatou algo a considerar sobre %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s informou o seguinte incidente.',
        'URL_REPORTED_COLON' => 'URL informada:',
        'ISSUE_COLON' => 'Incidente:',
        'ADDITIONAL_INFORMATION_COLON' => 'Informações adicionais:',
        'SEND_AN_INVITATION_TO_X' => 'Envie um convite para %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'alguém pediu para participar de %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Deseja adicionar uma mensagem de boas-vindas para %s em seu perfil? Vá em:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s lhe enviou uma mensagem.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Para ler esta mensagem, visite:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s lhe enviou uma mensagem em %s...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s adicionou você como amigo...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s adicionou você como amigo em %s.',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s aceitou seu pedido de amizade em %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Para aceitar este pedido de amizade, visite:',
        'VIEW_XS_PAGE_ON_Y' => 'Exibir a página de %s em %s',
        'MEMBER_OF_X_ACCEPTED' => 'um membro de %s aceitou seu pedido de amizade',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Caso não queira mais receber e-mails com pedidos de amizade de %s, <a %s>clique aqui</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Você recebeu este convite de um membro de %1$s. Caso não queira receber convites de %1$s, entre em contato conosco em http://help.ning.com/?page_id=27.',
        'ON_X_COLON' => 'Em %s:',
        'ON_X' => 'em %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s solicitou associação a %s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s solicitou associação a %2$s em %3$s...',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s convidou você para fazer parte do Grupo "%2$s"',
        'VISIT_GROUP_AT' => 'Visite %s em:',
        'ABOUT_GROUP' => 'Sobre %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Uma mensagem de %s a todos os membros de %s em %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Você pode acessar utilizando seu endereço de e-mail aqui:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s comentou na publicação de blog \'%s\' em %s',
        'SEND_X_A_MESSAGE_HERE' => 'Envie uma mensagem a %s aqui:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Você tem um novo membro para aprovar em %s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Você tem um novo membro para aprovar.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Para aprovar o perfil de %s, visite:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Não consegue clicar no link acima? Basta copiar e colar a URL em seu navegador.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Clique aqui para participar:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Clique aqui para participar!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Sua %s associação foi aprovada...',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Parabéns! Sua %s associação foi aprovada.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Agora, você pode acessar utilizando seu endereço de e-mail aqui:',
        'VISIT_X_AT_Y' => 'Visite %1$s em: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Para controlar os e-mails que deseja receber em%1$s, vá para:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Um membro banido lhe enviou uma mensagem em %s...',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Um membro banido lhe enviou uma mensagem em %1$s. %2$s escreveu:',
        'WELCOME_TO_THE_GROUP_X' => 'Bem-vindo ao Grupo "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Bem-vindo a %1$s em %2$s...',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Para ver este grupo, visite:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s convidou você para fazer parte de %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s é um novo membro de %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s é um novo membro de %2$s...',
        'SOMEBODY' => 'Alguém',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Para ver seu novo comentário, visite:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Para ver o novo comentário, visite:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Para ver a nova resposta, visite:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Bem-vindo a %s! Obrigado por se associar.',
        'NAME_COLON' => 'Nome:',
        'EMAIL_COLON' => 'E-mail:',
        'AGE_COLON' => 'Idade:',
        'GENDER_COLON' => 'Sexo:',
        'LOCATION_COLON' => 'Local:',
        'COUNTRY_COLON' => 'País:',
        'GET_NETWORK_BADGE' => 'Badge %s',
        'SPREAD_WORD_GET_BADGE' => 'Conte para todos. Obtenha seu próprio badge %s para seu website ou página do MySpace. (<a %s>Obter código</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Conte para todos <a href="%s">Obtenha seu próprio badge %s </a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Mostre sua lealdade. Obtenha seu próprio badge %s para colocar em seu website ou página do MySpace. (<a %s>Obter código</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s comentou sobre %2$s "%4$s" em %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Desculpe-nos â€“ Não conseguimos extrair endereços de e-mail do arquivo.',
        'ADMINISTRATORS' => 'Administradores',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Seu convite expirou',
        'SORRY_INVITATION_EXPIRED' => 'Desculpe, o convite que você usou expirou. Você precisa de um novo convite para se associar a %s.',
        'DISABLE_INVITATION_LINK' => 'Desabilitar link de convite?',
        'CREATING_LINK_WILL_DISABLE' => 'Criar um novo link de convite desabilitará o link atual. Você realmente quer criar um novo link?',
        'SHARE_LINK_WITH_PEOPLE' => 'Compartilhe este link com quem você quer que se associe a esta rede:',
        'CREATE_INVITATION_LINK' => 'Crie um novo link para convite',
        'PLEASE_SELECT_SECOND_PART' => 'Selecione a segunda parte de seu endereço de email, por exemplo, gmail.com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Certifique-se que o símbolo @ não faça parte do endereço de e-mail.',
        'SORRY_WE_DONT_SUPPORT' => 'Não aceitamos o catálogo de endereços da web para seu endereço de e-mail. Tente clicar em \'Email Application\' abaixo para usar os endereços de seu computador.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Digite uma senha para %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importando Catálogo de Endereços',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Deixe esta janela aberta </strong> enquanto obtemos os endereços de e-mail de seus amigos. Quando terminar, você pode escolher quais amigos convidar.',
        'SHARE_THIS_LINK' => 'Compartilhe este link:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Enviar através do programa de e-mail de seu computador:',
        'EMAIL_THIS' => 'Enviar por e-mail',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(é seu amigo)',
        'CLEAR' => 'Limpar',
        'SEARCH_FRIENDS_TO_INVITE' => 'Buscar amigos para convidar:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Seus convites foram enviados',
        'WANT_TO_INVITE_MORE' => 'Deseja convidar mais amigos? Convite mais amigos importando contatos de seu catálogo de endereços da web ou aplicativo de e-mail.',
        'MESSAGE_TOO_LONG' => 'A mensagem é muito longa. Reduza-a para %s caracteres e tente novamente.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Os endereços de e-mail a seguir não parecem ser válidos. Os convites não foram enviados. Corrija os endereços de e-mail e tente novamente.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Digite um ou mais endereços de e-mail.',
        'ENTER_EMAIL_ADDRESSES' => 'Digite endereços de e-mail.',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Separe vários endereços de e-mail por vírgulas',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Sua mensagem</label> (opcional)',
        'SEND_INVITATIONS' => 'Enviar convites',
        'WEB_ADDRESS_BOOK' => 'Catálogo de endereços na web',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail ou AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Seu endereço de e-mail',
        'IMPORT_ADDRESS_BOOK' => 'Importar Catálogo de Endereços',
        'DONT_WORRY_WE_WONT_SAVE' => 'Não se preocupe, não salvamos sua senha e você terá a oportunidade de escolher para quais amigos enviar um e-mail.',
        'EMAIL_APPLICATION' => 'Aplicativo de e-mail',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, .CSV, etc.',
        'UPLOAD_CSV_OR_VCF' => 'Carregue um arquivo .csv ou .vcf exportado do Catálogo de Endereços do Microsoft Outlook ou Apple.',
        'BROWSE_FOR_FILE' => 'Procurar por arquivo',
        'UPLOAD' => 'Carregar',
        'SELECT_ELLIPSIS' => 'selecionar…',
        'OTHER_ELLIPSIS' => 'outro…',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Não se preocupe, você terá a oportunidade de escolher para quais amigos enviar um e-mail.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Participação apenas por convite',
        'IF_YOU_ARE_ADMIN' => 'Se você for um administrador, <a %s>clique aqui para acessar</a>.',
        'NAME_MUST_BE_SHORTER' => 'O nome deve ter menos de %s caracteres',
        'CITY_NAME_MUST_BE_SHORTER' => 'A cidade deve ter menos de %s caracteres',
        'EMAIL_ALREADY_REGISTERED' => 'Este endereço de e-mail já foi registrado. Escolha outro.',
        'EMAIL_NOT_VALID' => 'Este endereço de e-mail não parece ser válido.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s lhe convidou para %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Você está fazendo o acesso com sua Ning ID.',
        'NOW_ENTER_PASSWORD' => 'Agora entre com sua senha para continuar.',
        'OR_SIGN_IN' => 'ou <a %s>acesse</a>',
        'CHANGE_ADDRESS' => 'Mudar endereço',
        'CHANGE_PAGE_ADDRESS' => 'Mudar endereço de página',
        'PAGE_ADDRESS_TAKEN' => 'Desculpe, este endereço já está registrado. Escolha outro.',
        'PAGE_ADDRESS_NOT_VALID' => 'São permitidos apenas as letras de A a Z, números e sublinhado (_) em seu endereço.',
        'ADD_BY_PHONE' => 'Adicionar por telefone',
        'PAGE_ADDRESS' => 'Endereço de página',
        'PHOTO_MUST_BE_TYPE' => 'Sua foto deve ser um arquivo .jpg, .gif ou .png.',
        'USEFUL_ADDRESSES' => 'Endereços úteis',
        'MY_DETAILS' => 'Meus detalhes',
        'NONE_I_DO_NOT_WANT' => 'Nenhum: eu não quero receber e-mails de %s',
        'CHANGE_PASSWORD' => 'Mudar a senha',
        'PROFILE_SAVED' => 'Suas mudanças foram salvas com sucesso.',
        'UPDATE_EMAIL_ADDRESS' => 'Atualizar endereço de e-mail',
        'EDIT_EMAIL_ADDRESS' => 'Editar seu endereço de e-mail',
        'MY_SETTINGS' => 'Minhas configurações',
        'ABOUT_ME' => 'Sobre mim',
        'SELECT' => 'Selecione...',
        'CITY' => 'Cidade',
        'COUNTRY' => 'País',
        'DATE_OF_BIRTH' => 'Data de Nascimento',
        'DO_NOT_DISPLAY' => 'Não exibir',
        'GENDER' => 'Sexo',
        'CREATE_YOUR_PROFILE' => 'Crie seu perfil',
        'SYSTEM_REQUIREMENTS' => 'Requisitos do sistema',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Nós aceitamos os navegadores Internet Explorer 6 e 7, Firefox 2.0 e Safari 2.0. Se estiver utilizando um navegador diferente (talvez um fornecido pelo seu provedor de acesso) ele pode não ser compatível.',
        'MAKE_SURE_COOKIES' => 'Certifique-se que os cookies e JavaScript estão habilitados em seu navegador.',
        'WHAT_IS_MY_EMAIL' => 'Qual é meu endereço de e-mail?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Caso você tenha se cadastrado antes de 5 de outubro de 2007, você pode estar acostumado a entrar usando uma \'Ning ID\'. Agora solicitamos que acesse utilizando o endereço de e-mail com o qual se registrou, porém ainda é possível utilizar sua Ning ID neste campo.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Clique aqui para redefinir sua senha.',
        'STILL_HAVING_PROBLEMS' => 'Ainda com problemas?',
        'VISIT_NING_HELP_CENTER' => 'Visite a <a %s>Central de Ajuda do Ning</a> para maiores informações sobre a resolução do problema e suporte.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problemas de registro ou acesso',
        'WE_SENT_YOU_EMAIL' => 'Enviamos a você um e-mail com o link para redefinir sua senha.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Redefinir senha',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

Recebemos um pedido para mudar sua senha em %2$s.

Clique no link abaixo para criar uma nova senha:

#{URL}

Se não quiser mudar sua senha, ignore este e-mail.

Obrigado,
A "%2$s" Equipe

-----
%2$s usa a Ning ID para autenticação.',
        'SET_PASSWORD' => 'Definir senha',
        'NEW_PASSWORD' => 'Nova senha',
        'CREATE_NEW_PASSWORD' => 'Criar uma nova senha',
        'SET_NEW_PASSWORD' => 'Escolha uma nova senha para sua Ning ID.',
        'CHOOSE_NEW_PASSWORD' => 'Escolha uma nova senha',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Olá, %s</strong> (<a %s>Sair</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Não há nenhuma conta com o endereço de e-mail %s',
        'PLEASE_ENTER_CODE' => 'Digite o código que aparece à sua direita.',
        'PROBLEMS_SIGNING_UP' => 'Problemas para fazer o registro?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Ao fazer o registro, você concorda com os <a %s>Termos de serviço</a> e <a %s>Política de privacidade </a>.',
        'FEEDBACK' => 'Comentários',
        'TERMS_OF_SERVICE' => 'Termos de serviço',
        'PROBLEM_SIGNING_UP' => 'Houve um problema durante o registro',
        'ALREADY_MEMBER_SIGN_IN' => 'Já é um membro? <a %s>Clique aqui para acessar</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'A associação a %s é apenas por convite',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Desculpe-nos, mas o administrador escolheu a exigência de convite para participar de %s. Caso você possua um convite, clique no link enviado por e-mail para associar-se.',
        'PROBLEM_SIGNING_IN' => 'Houve um problema ao acessar',
        'WE_USE_NING_ID' => 'Utilizamos uma Ning ID para autenticação. <a %s>O que é Ning ID?</a>',
        'PROBLEMS_SIGNING_IN' => 'Problemas para acessar?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Acesso" /> &#160;ou&#160; <strong><a %s>Registro</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Acessar %s',
        'WHAT_IS_A_NING_ID' => 'O que é Ning ID?',
        'LARR_BACK' => '← <a %s>Voltar</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'O sistema de autenticação de Ning ID lhe permite escolher um endereço de e-mail e senha uma vez e utilizá-los para participar ou acessar qualquer rede social que utilize a Ning ID.',
        'WHEN_YOU_CREATE_NING_ID' => 'Ao criar uma Ning ID, você pode também adicionar um conjunto de dados básicos e uma foto para sua conta. Estes dados serão então preenchidos sempre que você se associar a uma nova rede social que utilize a Ning ID para autenticação. Isto também lhe permite acompanhar seus amigos e as mensagens por todas as redes sociais que utilizarem o mesmo sistema.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Você pode identificar-se com seu endereço de e-mail e senha da Ning ID sempre que visualizar este símbolo: %s',
        'HELLO_USER' => 'Olá %s,',
        'TEXT_FOR_HEADER_TAB' => 'Este texto é para uma guia do cabeçalho',
        'BASED_ON' => 'Com base em',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Você realmente deseja excluir este idioma?',
        'DELETE_LANGUAGE' => 'Excluir idioma',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'O texto foi restaurado para a versão original.',
        'UPLOAD_LANGUAGE_FILE' => 'Carregar arquivo de idioma',
        'ADD_TO_LANGUAGE' => 'Adicionar ao idioma:',
        'IF_YOU_CREATED_TRANSLATION' => 'Caso você tenha criado uma nova tradução em outra rede social no Ning, é possível importar seu trabalho aqui. O conteúdo do arquivo será adicionado ao idioma de sua escolha. Seu idioma não está listado? <a %s>É simples adicionar um novo</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Exemplos: sueco (Finlândia), Filipino, espanhol (Porto Rico)',
        'START_FROM_SCRATCH_CREATE' => 'Comece do zero! Entre com o nome do novo idioma para criar uma nova tradução em sua rede e, em seguida, escolha um idioma existente como ponto de referência.',
        'KEY_MISSING_TEXT' => 'Legenda: <span %s>Texto ausente</span> <span %s>Texto alterado</span>',
        'SHOW_ALL_TEXT' => 'Listar todos os textos',
        'SHOW_MISSING_TEXT' => 'Listar os textos ausentes',
        'SHOW_CHANGED_TEXT' => 'Listar os textos alterados',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Exemplos: Guias, Membros, Amigos',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Redefinir o texto para versão original',
        'ORIGINAL_TEXT_X' => 'Texto original – %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Edite o idioma de sua rede',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Personalize qualquer texto de sua rede, incluindo os nomes de guias, rodapés de e-mails, mensagens de erro e outros.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>O idioma ativo de sua rede é %1$s</em>. <a %2$s>Alterar o idioma ativo</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Opções atuais de idioma',
        'ACTIVE' => 'Ativo',
        'MY_LANGUAGES' => 'Meus idiomas',
        'CREATE_NEW_TRANSLATION' => 'Crie uma nova tradução',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Seu idioma não está listado acima? <strong><a %s>Crie uma nova tradução para sua rede</a></strong>.',
        'ADVANCED_IMPORT' => 'Importação avançada',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Caso você tenha traduzido um idioma em uma rede social existente, você pode <strong><a %s>importar o arquivo de seu idioma</a></strong> e usá-lo nesta rede.',
        'LANGUAGE_EDITOR' => 'Editor de idioma',
        'PUBLIC' => 'Público',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Sua configuração de privacidade atual, uma rede pública onde não-membros podem apenas acessar a tela de login, não está mais disponível. Sua configuração de privacidade não foi alterada, mas se fizer alterações aqui, não será possível retornar a esta configuração. A opção mais próxima disponível é a de uma rede privada onde qualquer um pode se associar.',
        'NO_MISSING_ITEMS' => 'Não há itens ausentes –  esta tradução está 100%% completa. <a %s>Exibir todos os itens.</a>',
        'NO_CHANGED_ITEMS' => 'Nenhum item foi alterado.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Desculpe-nos – não foi possível encontrar nenhum item que corresponda a <em>%s</em>. <a %s>Exibir todos os itens.</a>',
        'FILE_N' => 'Arquivo %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Um arquivo de tradução do Ning possui um nome parecido com <code>en_US.txt</code>. <a %s>Maiores informações aqui.</a>',
        'SELECT_TRANSLATION_FILE' => 'Selecionar arquivo de tradução:',
        'USE_THIS_TRANSLATION' => 'Utilizar esta tradução',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Note que o que vem a seguir está faltando nas regras abaixo: %s',
        'ALL' => 'Todos',
        'MISSING' => 'Ausente',
        'VIEW' => 'Exibir',
        'TRANSLATION_CHANGES_SAVED' => 'Suas mudanças foram salvas. Esta tradução está %s%% completa.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Suas mudanças foram salvas. Esta tradução está %s%% completa. Gostaria de usar este como o idioma atual em sua rede?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'O carregamento foi bem-sucedido. Esta tradução está %s%% completa.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'O carregamento foi bem-sucedido. Esta tradução está %s%% completa. Gostaria de usar este como o idioma atual em sua rede?',
        'X_IS_CURRENT_LANGUAGE' => 'A partir de agora %s é o idioma de sua rede.',
        'SAVE_PAGE' => 'Salvar página',
        'LANGUAGE_NAME_TAKEN' => 'Desculpe-nos - este nome já foi utilizado. Escolha outro nome.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Escolha um nome para sua nova tradução, por exemplo, Português (Portugal)',
        'CREATE' => 'Criar',
        'LANGUAGE_NAME' => 'Idioma',
        'SAVE_ITEMS_ON_PAGE' => 'Salvar os itens desta página',
        'NEW_TRANSLATION' => 'Nova tradução',
        'MISMATCHED_CURLY_BRACKETS' => 'Chaves não-pareadas',
        'MISMATCHED_SQUARE_BRACKETS' => 'Colchetes não-pareados',
        'MISMATCHED_PARENTHESES' => 'Parênteses não-pareados',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Ocorreu um erro ao processar o código de Regras Especiais.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Ocorreu um erro ao processar o código de Nome de Guias.',
        'SPECIAL_RULES' => 'Regras especiais',
        'TAB_NAMES' => 'Nome de Guias',
        'SOURCE' => 'Fonte',
        'LANGUAGE_EDITOR_X' => 'Editor de idioma: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Voltar ao editor de idioma',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Personalize os textos e mensagens de sua rede ou crie um novo idioma.',
        'STOPWORDS' => 'um | sobre | uma | são | conforme | na | for | por | com | de | em | para | de | como | i | no | é | ele | ela | de | na | ou | que | a | isto | para | foi | o que | quando | onde | quem | irá | com | e | o | www',
        'STOPWORDS_ARE' => '<a %s>Stopwords</a> é uma lista opcional de palavras a serem ignoradas da descrição de sua rede para a criação de meta tag no topo do código de cada página. Opcional.',
        'I_AM_MEMBER' => 'Eu sou membro de:',
        'VIEW_PAGE_ON_APPNAME' => 'Exibir minha página em <em>%s</em>',
        'VISIT_APPNAME' => 'Visite <em>%s</em>',
        'JOIN_US' => 'Junte-se a nós',
        'CREATED_BY_COLON' => 'Criado por:',
        'GET_MORE_BADGES' => 'Obter outros badges',
        'SHOW_LOGO' => 'Exibir logo',
        'GALLERY' => 'Galeria',
        'BADGES' => 'Badges',
        'MEMBER_BADGE' => 'Badges de membro',
        'WEAR_IT_WITH_PRIDE' => 'Use com orgulho! Obtenha um badge de membro %s para usar em seu site ou página do MySpace.',
        'NETWORK_BADGE_LARGE' => 'Badge da rede (grande)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Avise a todos! Obtenha um badge que se atualiza dinamicamente com os membros mais populares de sua rede. Adicione ao seu site ou página do MySpace.',
        'NETWORK_BADGE_SMALL' => 'Badge da rede (pequeno)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Divulgue! Obtenha um badge %s que possa utilizar em seu site ou página do MySpace.',
        'PHOTO_SLIDESHOW_PROPER' => 'Exibição das fotos em slides',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Mostre uma seleção de suas fotos em um site ou página do Myspace com nossa exibição de fotos em slides.',
        'MUSIC_PLAYER' => 'Music Player',
        'PLAY_MUSIC_ON_WEBSITE' => 'Toque músicas em um site ou página do Myspace com nosso music player.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Adicione um vídeo ao seu site ou página do Myspace. Procurando mais opções? <a href="%s">Veja todos os vídeos</a> em %s.',
        'LARGE_N_PIXELS_WIDE' => 'Grande - %d pixels de largura',
        'MEDIUM_N_PIXELS_WIDE' => 'Médio - %d pixels de largura',
        'SMALL_N_PIXELS_WIDE' => 'Pequeno - %d pixels de largura',
        'MY_MOST_RECENT' => 'Mais recentes',
        'APP_ICON' => 'Ícone do aplicativo',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'A associação a %s é restrita a convidados apenas.',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => 'O comentário a seguir foi enviado por %s:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s fez comentário em %2$s...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Obrigado. Sua mensagem foi enviada.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s gostaria de participar de %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s requisitou um convite para fazer parte de %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Seu pedido foi enviado ao criador da rede.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Para retirar a proibição %s, vá em:',
        'SEND_REQUEST' => 'Enviar pedido',
        'SEARCH' => 'Procurar',
        'SEARCH_AGAIN' => 'Procurar novamente',
        'SEND_BROADCAST_MESSAGE' => 'Enviar aviso geral',
        'VERIFICATION_IMAGE' => 'Imagem de verificação',
        'UNDER_CONSTRUCTION' => 'Em construção',
        'PROFILE_INFORMATION_SAVED' => 'Informações salvas do perfil',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'As informações do perfil de diretório da sua rede foram salvas.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Não existe conta com este endereço de e-mail.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Senha errada. A tecla Caps Lock está ativada?',
        'OOPS_THAT' => 'Opa –  isso não funcionou.',
        'OOPS_THAT_DID_NOT_WORK' => 'Opa  – isso não funcionou. Tentar novamente?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Opa – isso não funcionou (%s).',
        'NOT_FOUND' => 'Não encontrado',
        'YOUR_SITES_FEATURE_LIST' => 'A lista de recursos de sua rede foi salva.',
        'ONE_LINE_ANSWER' => 'Resposta de uma linha',
        'LONGER_ANSWER' => 'Resposta longa',
        'MULTIPLE_CHOICE' => 'Múltipla escolha',
        'DATE' => 'Data',
        'WEBSITE_ADDRESS' => 'Endereço do site',
        'EVERYTHING' => 'Tudo',
        'JUST_THE_HOMEPAGE' => 'Apenas a página principal',
        'JUST_THE_SIGN_UP_PAGE' => 'Apenas a página de registro',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Suas mudanças foram salvas.',
        'JOIN_ME_ON_X' => 'Venha participar de %s!',
        'NOT_ALLOWED' => 'Não permitido',
        'COME_JOIN_ME_ON_X' => 'Venha participar de %s!',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Venha participar de %s...',
        'X_NOT_VALID_EMAIL' => '%s não é um endereço de e-mail ou Ning ID válida',
        'USER_BANNED_FROM_NETWORK' => '%1$s foi banido(a) desta rede. <a %2$s>Envie uma mensagem para %1$s</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s já é um membro desta rede. <a %2$s>Envie uma mensagem para %1$s</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Você pode enviar até %s por vez.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Digite os endereços de e-mail ou Ning IDs de seus amigos.',
        'THERE_HAS_BEEN_AN_ERROR' => 'Houve um erro',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Seus convites foram enviados.',
        'SEARCH_RESULTS' => 'Resultados da busca',
        'INVITE_YOUR_FRIENDS' => 'Convide seus amigos',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Envie convites para que seus amigos possam fazer parte',
        'INVITATION' => 'Convite',
        'ADD_FROM_ADDRESS' => 'Adicionar do Catálogo de Endereços',
        'TO' => 'Para:',
        'SEND_TO' => 'Enviar para',
        'SUBJECT' => 'Assunto',
        'YOUR_MESSAGE' => 'Sua mensagem',
        'SEND' => 'Enviar',
        'REPORT_AN_ISSUE' => 'Relatar um incidente',
        'TYPE_OF_ISSUE' => 'Tipo de incidente',
        'ADULT' => 'Para adultos',
        'ABUSIVE' => 'Abusivo',
        'BUG' => 'Erro de programação',
        'FRAUD' => 'Fraude',
        'SPAM' => 'Spam',
        'OTHER' => 'Outros',
        'DESCRIBE_YOUR_ISSUE' => 'Descreva o incidente',
        'SEND_REPORT' => 'Enviar relato',
        'ADDED_BY_X_AT_X' => 'Adicionado por <a %s>%s</a> em %s em %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Adicionado por <a %s>%s</a> a %s em %s em %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Clicar para exibir',
        'COMMENT_FOR' => 'Comentário para:',
        'COMMENT_ON' => 'Comentário em:',
        'ACTION_BUTTON_FEATURE' => 'Recurso',
        'FEATURE_THIS_ON_YOUR' => 'Apresentar isto na página principal',
        'ACTION_BUTTON_REMOVE' => 'Remover',
        'REMOVE' => 'Remover',
        'REMOVE_THIS_FROM_YOUR' => 'Remover isto da página principal',
        'FEATURE_ON_HOME' => 'Apresentar na página principal',
        'REMOVE_FROM_HOME' => 'Remover da página principal',
        'ITEM_WILL_APPEAR' => 'Este item aparecerá agora nos módulos selecionados em sua página principal',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Este item não mais aparecerá nos módulos selecionados em sua página principal',
        'ADD_CONTENT' => 'Adicionar conteúdo',
        'BROUGHT_TO_YOU_BY' => '%s é uma cortesia de %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Envie-nos seus comentários',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Para mais perguntas ou para contatar Ning, clique aqui:',
        'SEND_FEEDBACK' => 'Enviar comentários',
        'SIGN_OUT' => 'sair',
        'SIGN_OUT_TITLE' => 'Sair',
        'EDIT_MY_PROFILE' => 'Editar respostas do perfil',
        'INVITE_MORE' => 'Convidar mais',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Use este formulário para enviar comentários para <a %s>%s</a>, o(a) criador(a) de <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Seus comentários',
        'NETWORK_INFORMATION' => 'Informações da rede',
        'ABOUT_YOUR_SITE' => 'Sobre sua rede',
        'WELCOME_TO_YOUR_SITE' => 'Bem-vindo à sua rede social!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Edite o nome de sua rede, descrição e outras informações.',
        'TAGLINE' => 'Slogan',
        'APPEARS_IN_HEADER' => 'Aparece no cabeçalho de sua rede',
        'APPEARS_IN_EMAILS' => 'Aparece em e-mails e outras partes',
        'NETWORK_NAME' => 'Nome da rede',
        'DESCRIPTION' => 'Descrição',
        'KEYWORDS' => 'Palavras-chave',
        'LANGUAGE' => 'Idioma',
        'SEPARATE_EACH_KEYWORD' => 'Separe as palavras-chave por vírgulas',
        'ICON' => 'Ícone',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Carregue uma foto (GIF, JPG ou PNG) que será redimensionada para um quadrado. A nova foto pode demorar alguns minutos para aparecer.',
        'SAVE_SETTINGS' => 'Salvar configurações',
        'SUCCESS_EXCLAMATION' => 'Êxito!',
        'FEATURES' => 'Recursos',
        'ADD_FEATURES' => 'Adicionar módulos à sua rede',
        'ORGANIZE_FEATURES' => 'Organize sua página principal arrastando os recursos da lista abaixo e depois os posicione da maneira que preferir.',
        'SKIP_FEATURES' => 'Clique em <a href="%s">Pular esta etapa</a> para continuar com o arranjo e recursos padrão.',
        'FEATURES_FOR_ALL_PAGES' => 'Os recursos adicionados a esta caixa aparecerão em todas as páginas de sua rede.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Personalize sua rede social adicionando ou removendo recursos.',
        'ADJUST_YOUR_SITES_COLORS' => 'Ajuste as cores, imagens e o visual geral de sua rede.',
        'APPEARANCE' => 'Aparência',
        'PROFILE_QUESTIONS' => 'Perguntas de perfil',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Edite as perguntas que os membros respondem sobre si.',
        'MESSAGE_SENT' => 'Mensagem enviada!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Sua mensagem foi enviada a todos os membros de sua rede.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Sua mensagem foi enviada a todos os membros de seu grupo.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Sua mensagem está sendo enviada. Aguarde, pois isso leva alguns minutos.',
        'BROADCAST_MESSAGE' => 'Aviso geral',
        'TRACK_VISITORS_AND_TRENDS' => 'Analise as visitas e tendências de sua rede social.',
        'EDIT_SOURCE_CODE' => 'Editar código-fonte',
        'TAKE_FULL_CONTROL' => 'Tenha controle pleno sob as funcionalidades de sua rede editando o código-fonte.',
        'DELETE_THIS_SITE' => 'Excluir sua rede social',
        'MAIN_PAGE' => 'Página principal',
        'MAIN' => 'Principal',
        'MAIN_TAB_TEXT' => 'Principal',
        'MANAGE' => 'Administrar',
        'MANAGE_TAB_TEXT' => 'Administrar',
        'PAGE_TITLE' => 'Título da página',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Edite a aparência de sua página',
        'CHOOSE_A_THEME' => 'Escolha um tema para sua rede social',
        'NOW_CUSTOMIZE_SITE' => 'Agora personalize sua rede social...',
        'THEME_SETTINGS' => 'Configurações do tema',
        'ADVANCED' => 'Avançado',
        'TOP_BAR_AND_FOOTER' => 'Barra superior e rodapé',
        'HEADER_AND_NAVIGATION' => 'Cabeçalho e navegação',
        'ADD_A_LOGO' => 'Adicionar logo',
        'THIS_IMAGE_WILL_REPLACE' => 'Esta imagem substituirá o texto do nome da rede',
        'TABS' => 'Guias',
        'TAB' => 'Guia',
        'SITE' => 'Rede',
        'SIDES' => 'Laterais',
        'BODY' => 'Corpo',
        'SHOW_NING_LOGO' => 'Exibir o logo do Ning?',
        'LAUNCH' => 'LANÇAR!',
        'NING_ID' => 'Ning ID',
        'PASSWORD' => 'Senha',
        'RETYPE_PASSWORD' => 'Confirme a senha',
        'TYPE_CODE_ON_RIGHT' => 'Digite o código <br />à direita',
        'JOIN_X' => 'Associe-se a %s',
        'SIGN_UP_FOR_X' => 'Registre-se em %s',
        'HAS_INVITED_YOU_TO_X' => 'convidou você para fazer parte de %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Aguardando aprovação',
        'NEW_MEMBER' => 'Novo membro?',
        'JOIN_X_NOW' => 'Associe-se a %s já!',
        'HIDE_THIS_MESSAGE' => 'Esconder esta mensagem',
        'PAGE_NOT_FOUND' => 'Página não encontrada',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Desculpe-nos – esta página não foi encontrada',
        'FOLLOW_THESE_LINKS_TO' => 'Siga estes links para algumas coisas que sabemos estar disponíveis:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Ou então, faça uma busca nesta rede social:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Se você se deparar com esta mensagem novamente, <a %s>notifique-nos.</a>',
        'GROUP_MEMBERS' => 'Membros do grupo',
        'VIDEOS' => 'Vídeos',
        'BLOG' => 'Blog',
        'ACCOUNT' => 'Conta',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Desculpe-nos, estamos tendo um problema com esta página.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Siga <a %s>este link</a> para a página principal.',
        'REQUEST_AN_INVITATION' => 'Requisitar um convite',
        'NAME' => 'Nome',
        'EMAIL_ADDRESS' => 'Endereço de e-mail',
        'MESSAGE_OPTIONAL' => 'Mensagem (opcional)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Desculpe-nos.</strong> Porém, é fácil começar sua própria rede social.',
        'GET_YOUR_OWN_BAZEL' => 'Crie sua própria rede social!',
        'SITE_IS_NOT_READY' => 'Esta rede social ainda não está pronta!',
        'BAZEL_IS_BEING_SET_UP' => 'Esta rede social ainda está sendo configurada!',
        'SIGN_IN' => 'Acessar',
        'FORGOT_YOUR_PASSWORD' => 'Esqueceu sua senha?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Esqueceu sua senha?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Entre com seu endereço de e-mail e clique em \'Redefinir senha\'. Você receberá um e-mail com um link para redefinir sua senha.',
        'RESET_PASSWORD' => 'Redefinir senha',
        'EXPLORE' => 'Explorar',
        'SIGN_UP' => 'Registre-se',
        'CONFIRM_PASSWORD' => 'Confirme a senha',
        'VERIFICATION' => 'Avise-nos que você é <br />uma pessoa',
        'YOUR_PHOTO' => 'Sua foto',
        'SUMMARY' => 'Sumário',
        'YOUR_SITE_IS_READY' => 'Sua rede social está pronta para ser inaugurada! As configurações padrão serão usadas para as etapas que tenha pulado. Volte a qualquer uma delas para fazer alterações, ou clique em \'Lançar!\' para estrear sua rede.',
        'WHEN_YOU_ARE_FINISHED' => 'Assim que acabar, clique em \'Exibir layout\' para ver o resultado!',
        'COMPLETE' => 'completo',
        'INCOMPLETE' => 'incompleto',
        'VIEW_LAYOUT' => 'Exibir layout',
        'CLEAR_CONTENTS' => 'Limpar conteúdo',
        'ADD_MODULE' => 'Adicionar módulo...',
        'ADD_COLUMNS' => 'Adicionar colunas...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Pública</strong> – Qualquer um pode associar-se',
        'PRIVATE_ONLY_INVITED' => '<strong>Particular</strong> – Apenas convidados podem visitar e fazer parte',
        'INVITATIONS' => 'Convites',
        'MEMBERS_CAN_INVITE' => 'Membros podem convidar outras pessoas para participar',
        'QUESTION_TITLE' => 'Pergunta',
        'ANSWER_TYPE' => 'Tipo de resposta',
        'REQUIRED' => 'Obrigatória',
        'PRIVATE' => 'Privada',
        'CHOICES' => 'Múltipla escolha',
        'SEPARATE_EACH_CHOICE' => 'Separe cada escolha por vírgulas',
        'CAN_PICK_MORE' => 'Permitir escolher mais de uma',
        'ADD_ANOTHER_QUESTION' => 'Adicionar outra pergunta',
        'WHAT_INFORMATION' => 'Quais perguntas você quer que os membros respondam quando entrarem para sua rede? Você pode reordenar as perguntas abaixo. Basta clicar na pergunta e arrastá-la para onde quiser.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Caso tenha escolhido "Obrigatória", os membros terão que responder a pergunta para poderem participar. Caso escolha "Particular", a resposta será visível apenas para você e outros administradores.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Não foi possível encontrar nada com o termo "%s". Por que não pesquisa outra coisa?',
        'GET_CUSTOM_URL' => 'Obtenha sua própria URL, adicione armazenamento e largura de banda, ou use seus próprios anúncios.',
        'TRACK_STATISTICS' => 'Acompanhar estatísticas',
        'TRACKING_CODE' => 'Código de rastreamento',
        'ANY_JAVASCRIPT_CODE' => 'Qualquer código JavaScript que você colar aqui será inserido ao final de todas as páginas de sua rede. Você pode utilizar este para os sistemas de rastreamento e estatísticas externos, como por exemplo o Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Para saber mais sobre o Google Analytics e configurar sua conta, <a %s>clique aqui</a>.',
        'RESOURCES' => 'Recursos',
        'LINKS' => 'Links',
        'PAGE' => 'Página',
        'BACKGROUND' => 'Fundo',
        'TEXT' => 'Texto',
        'HEADING_TEXT' => 'Texto de cabeçalho',
        'FONT' => 'Tipo de letra',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Cor',
        'LINK_COLOR' => 'Cor do link',
        'BODY_TEXT' => 'Texto',
        'MIDDLE' => 'Meio',
        'FEATURE_BOXES' => 'Caixas apresentadas',
        'TITLEBAR_TEXT_COLOR' => 'Cor do texto da barra de título',
        'TITLEBAR_BACKGROUND' => 'Cor de fundo da barra de título',
        'UPLOADING_CONTENT' => 'Carregando comentário...',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Quando o carregamento terminar, você poderá conferir a rede.',
        'FINISH' => 'Concluir',
        'FLICKR_IMPORT_SETUP' => 'Configurar importação do Flickr',
        'FLICKR_API_KEY' => 'Sua chave',
        'FLICKR_SECRET' => 'Seu segredo',
        'FLICKR_KEY_ERROR' => 'Houve um problema com a chave ou segredo do Flickr que você utilizou. Você poderia conferi-las e tentar novamente?',
        'FLICKR_INTRO' => 'Gostaria de permitir que membros importem suas fotos do Flickr? Você veio ao lugar certo. Caso já possua uma chave API e um segredo do Flickr, você pode <a %s>avançar</a>. Tem dúvidas sobre o que isto significa? Basta seguir as etapas abaixo e você estará pronto em pouco tempo.',
        'FLICKR_GET_ACCOUNT' => 'Caso você não possua uma conta no Flickr, crie uma <a %s>aqui</a>.',
        'FLICKR_STEP1_TITLE' => 'Etapa 1: Obtenha uma chave API do Flickr',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Solicitação de tela para sua chave API no Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'Tela da chave API no Flickr',
        'FLICKR_STEP1_INTRO' => 'Acesse o Flickr e <a %s>solicite uma nova chave API</a> (abre em uma nova janela).',
        'FLICKR_STEP1_A' => 'Forneça <strong>seu nome</strong> e <strong>endereço de e-mail</strong>.',
        'FLICKR_STEP1_B' => 'Abaixo de <strong>Esta chave é  para&hellip;</strong> escolha a opção <em>uso não comercial</em>.',
        'FLICKR_STEP1_C' => 'Descreva sua rede social no campo <strong>Descreva o aplicativo que planeja criar</strong>.',
        'FLICKR_STEP1_D' => 'Marque ambas as caixas de seleção.',
        'FLICKR_STEP1_APPLY' => 'Quando tiver terminado, clique no botão <strong>Aplicar</strong>.',
        'FLICKR_STEP1_E' => 'Você será levado a uma tela que exibe sua nova chave API. Clique no link <strong>Clique aqui</strong> para configurar a autenticação de usuário para esta chave.',
        'FLICKR_STEP2_TITLE' => 'Etapa 2: Configure sua chave',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Tela de configuração de autenticação da chave API no Flickr',
        'FLICKR_STEP2_F' => 'Cole o seguinte endereço no campo <strong>Callback URL</strong> (URL de retorno):',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Quando estiver terminado, clique no botão <strong>Salvar alterações</strong>.',
        'FLICKR_STEP3_TITLE' => 'Etapa 3: Forneça suas informações',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Tela de informações sobre a chave API no Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Parabéns! Você completou a configuração no Flickr.',
        'FLICKR_STEP3_COMPLETE' => 'Para completar a configuração em %s, simplesmente copie e cole a sua chave e o segredo nos campos a seguir:',
        'COMPLETE_SETUP' => 'Completar a configuração',
        'SETUP_YOUR_SITE_TO' => 'Configure sua rede social para importar fotos do Flickr.',
        'FLICKR_IMPORTING' => 'Importar do Flickr',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Você precisa configurar sua rede social para permitir que usuários importem as fotos deles a partir do Flickr. Isso leva alguns minutos, portanto por que não <a %s>configurar agora?</a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Não me mostre mais isso.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Você saiu de %s com êxito. Volte logo e junte-se a nós!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'criou esta rede social no <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Crie sua própria rede social no Ning gratuitamente!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Arraste aqui para remover um recurso',
        'LAYOUT' => 'Layout',
        'DRAG' => 'Arraste',
        'HERE' => 'Aqui',
        'YOU' => 'Você',
        'ADS' => 'Anúncios',
        'MEMBERS' => 'Membros',
        'HELLO_USERNAME' => 'Olá Usuário,',
        'CREATED_BY' => 'Criada por',
        'SAVE_FEATURES' => 'Salvar recursos',
        'FORUM' => 'Fórum',
        'CATEGORIES' => 'Categorias',
        'FORUM_CATEGORIES' => 'Categorias de fórum',
        'A_THREADED_DISCUSSION_FORUM' => 'Um fórum de tópicos em cadeia',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Permitir que membros criem seus próprios grupos de interesse dentro de sua rede',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Exiba mensagens de seu blog ou de blogs de outros membros',
        'TEXT_BOX' => 'Caixa para texto',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Insira qualquer texto, componente gráfico ou HTML em sua página principal',
        'A_LIST_OF_MEMBERS' => 'Uma lista dos membros de sua rede social',
        'ALLOW_USERS_PHOTOS' => 'Permitir que outros carreguem e compartilhem fotos',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Adicionar feeds da web',
        'INFORMATION_ABOUT_THE_USER' => 'Informações sobre a pessoa que está acessando no momento',
        'ALLOW_USERS_VIDEOS' => 'Permitir que outros adicionem e compartilhem vídeos',
        'SHOW_NETWORK_DESCRIPTION' => 'Exibir a descrição de sua rede',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Promova sua rede pela web com badges e componentes gráficos personalizados',
        'MONETIZE_WITH_ADS' => 'Ganhe dinheiro com propaganda em sua rede',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Deixe que seus membros saibam quem criou esta rede',
        'FOLLOW_LATEST_ACTIVITY' => 'Acompanhe as últimas atividades de seus membros em sua rede',
        'FAQ_FOR_NETWORK_CREATORS' => 'Perguntas freqüentes para criadores de rede',
        'ANSWERS_TO_FAQS' => 'Respostas para as perguntas mais freqüentes sobre personalização de sua rede social.',
        'MEET_OTHER_LIKEMINDED' => 'Conheça outros donos de redes que pensam como você, troque idéias e receba ajuda da equipe do Ning.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Personalize o visual de sua rede social adicionando suas próprias folhas de estilo em cascata (CSS) no campo à esquerda. (<a href="%s">O que é CSS?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Personalize o visual de sua página adicionando suas próprias folhas de estilo em cascata (CSS) no campo à esquerda. (<a href="%s">O que é CSS?</a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS em sua rede social',
        'CSS_ON_YOUR_PAGE' => 'CSS em sua página',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Ao adicionar sua própria CSS você tem controle total sobre os tipos de letra, cores, espaçamento e estilo geral de sua rede.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Ao adicionar sua própria CSS à sua página, você tem controle total sobre os tipos de letra, cores, espaçamento e estilo geral de sua página.',
        'CSS_STYLES_WILL_OVERRIDE' => 'Os estilos de CSS que você adicionar aqui irão sobrescrever os estilos de CSS existentes que você possa ter escolhido antes.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Precisa de ajuda para descobrir o nome de uma classe CSS específica em sua rede? Recomendamos o uso do recurso "Inspecionar" disponível na ferramenta gratuita <a href="%s">Firebug</a> (uma extensão para o navegador Firefox).',
        'WANT_TO_LEARN_MORE' => 'Quer saber mais a respeito? Confira nossa seção <a href="%s">Personalização Avançada</a>.',
        'APPLY_XS_THEME' => 'Aplicar o tema %s',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'Já existe uma Ning ID registrada com o endereço de e-mail %s. Acesse abaixo usando sua Ning ID ou endereço de e-mail. Caso tenha esquecido sua senha, <a href="%s">clique aqui para redefini-la</a>.',
        'INVITED' => 'Convidado',
        'REQUESTED_INVITE' => 'Requisitou convite',
        'BAN_FROM_NETWORK' => 'Banir da rede',
        'REMOVE_BAN' => 'Remover proibição',
        'CANCEL_INVITATION' => 'Cancelar convite',
        'IGNORE' => 'Ignorar',
        'PROMOTE_TO_ADMINISTRATOR' => 'Promover a administrador',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Rebaixar de administrador',
        'STATUS' => 'Status',
        'DATE_JOINED' => 'Data de registro',
        'DATE_INVITED' => 'Data do convite',
        'DATE_REQUESTED' => 'Data do pedido',
        'DATE_APPLIED' => 'Data da aplicação',
        'NETWORK_CREATOR' => 'Criador da rede',
        'NETWORK_ADMINISTRATOR' => 'Administrador',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Administradores possuem um nível de controle semelhante ao do criador da rede.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Exportar dados de todos os membros (.CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Seus dados de membros foram exportados. Clique com o botão direito do mouse <a %s>neste link</a> e selecione \'Salvar como\' para salvar em sua área de trabalho.',
        'CLICK_GO_TO_START_EXPORT' => 'Clique em Ir para iniciar a exportação. Se você tiver muitos membros, o processo pode demorar alguns minutos.',
        'MEMBER' => 'Membro',
        'INVITED_BY_X' => 'Convidado por %s',
        'DONE' => 'Pronto',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Você foi banido de %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Mensagem ao administrador',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Desculpe %s, você não pode acessar %s pois você foi banido. Se você acredita que foi banido por engano, entre em contato com o administrador.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Desculpe, %s, você não pode acessar %s pois foi banido.',
        'SORRY_USERNAME' => 'Desculpe, %s',
        'PENDING' => 'Pendente',
        'ACCEPT' => 'Aceitar',
        'PENDING_APPROVAL' => 'Aprovação pendente',
        'ACCEPT_MEMBERSHIP' => 'Aceitar associação',
        'DECLINE_MEMBERSHIP' => 'Negar associação',
        'NO_PAGE_YET' => 'Ainda não há uma página',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Sua associação em %s está aguardando aprovação dos administradores.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Associação esperando aprovação',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Seu perfil está pendendo aprovação',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Os detalhes de seu perfil precisam ser aprovados pelo administrador antes de se tornar membro de %s. Você receberá um e-mail assim que seu perfil for aprovado.',
        'CONTINUE_ARROW' => 'Continuar →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Voltar para os membros pendentes',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s está aguardando aprovação para se tornar um membro de %s.',
        'VIEW_PAGE' => 'Exibir página',
        'MESSAGE' => 'Mensagem',
        'SEND_MESSAGE' => 'Enviar mensagem',
        'MANAGE_FORUM_CATEGORIES' => 'Administre categorias de fórum',
        'START_DISCUSSIONS' => 'Inicie tópicos de discussão',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Bem-vindo à sua nova rede social!',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Agora, tudo o que você tem a fazer é <a %s>convidar seus amigos</a>!',
        'CONTRIBUTE' => 'Contribua.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Personalize.</strong> Ajuste <a %1$s>o visual da rede</a> e crie <a %2$s>badges e componentes gráficos</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Controle.</strong> A página de <a %s>administração<e/a> contém as opções de configuração.',
        'CREATE_GROUPS' => 'Crie grupos',
        'INVITE_MORE_PEOPLE' => 'Convidar mais pessoas',
        'VIEW_THREAD' => 'Exibir a cadeia',
        'COMMENT_THREAD' => 'Cadeia de comentários',
        'COMMENT_BACK' => 'Responder',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Olá, você precisa habilitar JavaScript para usar esta rede.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Verifique as configurações do seu navegador ou contate o administrador do sistema.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Administre membros, Administradores, pessoas convidadas e banidas.',
        'MANAGE_MEMBERS' => 'Administrar membros',
        'MANAGE_INVITED_PEOPLE' => 'Administrar convidados',
        'NETWORK_SETTINGS' => 'Configurações de rede',
        'PROMOTE_YOUR_NETWORK' => 'Promova sua rede',
        'NING_RESOURCES' => 'Recursos do Ning',
        'ADD_PREMIUM_SERVICES' => 'Adicionar serviços extras',
        'REQUEST_SOURCE_CODE' => 'Requisitar acesso de código fonte',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Desenvolvedores: requisite acesso ao código fonte de sua rede.',
        'JOIN_NETWORK_CREATORS' => 'Junte-se aos criadores de rede',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Envie uma mensagem a todos os membros de sua rede.',
        'CREATE_ANOTHER_NETWORK' => 'Criar outra rede',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Você tem outra grande idéia para uma rede social?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Permitir que usuários do Facebook coloquem os componentes gráficos de sua rede nos perfis de usuário deles.',
        'BADGES_AND_WIDGETS' => 'Badges e componentes gráficos',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Personalize o visual das badges e componentes gráficos de sua rede.',
        'GET_BADGES' => 'Obter badges',
        'CUSTOM_TEXT' => 'Texto personalizado',
        'IM_A_MEMBER_OF' => 'Eu sou membro de:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Não mostrar marcas',
        'WATERMARK_OR_LOGO_IMAGE' => 'Marca d\'água ou logotipo:',
        'NETWORK_BRANDING_BADGES' => 'Marca da rede: badges',
        'NETWORK_BRANDING_WIDGETS' => 'Marca da rede: componentes gráficos',
        'LOGO_IMAGE' => 'Logotipo',
        'SMALL_NETWORK_BADGE' => 'Badge de rede pequeno',
        'LARGE_NETWORK_BADGE' => 'Badge de rede grande',
        'REFRESH' => 'Atualizar',
        'HTML_EMBED_CODE' => 'Código HTML:',
        'CUSTOMIZE' => 'Personalizar',
        'SHARE_TITLE' => 'Compartilhar \'%s\'',
        'SHARE_TYPE' => 'Compartilhar %s',
        'YOUR_MESSAGE_SENT' => 'Sua mensagem foi enviada com sucesso.',
        'YOUR_MESSAGES_SENT' => 'Suas mensagens foram enviadas com sucesso.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Você pode compartilhar este(a) %s de duas maneiras&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Confira este(a) %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Confira este(a) %s',
        'PHOTO_ALBUM' => 'álbum de fotos',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Personalize seus badges e componentes gráficos com cores e imagens de sua escolha. Suas alterações podem levar até 4 horas para aparecer em outros sites.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Imagem e cor de fundo',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Utilize este formulário para relatar um incidente a <a %s>%s</a>, o(a) criador(a) de <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Desculpe, mas os criadores de rede não podem mudar seus endereços de e-mail através de redes que não sejam deles.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Desculpe, mas os criadores de rede não podem mudar suas senhas através de redes que não sejam deles.',
        'GO' => 'Ir',
        'LARGE_THUMBNAILS' => 'Miniaturas grandes',
        'SMALL_THUMBNAILS' => 'Miniaturas pequenas',
        'RECENTLY_JOINED' => 'Mais novos',
        'MOST_POPULAR_MEMBERS' => 'Mais populares',
        'NO_MEMBERS_TO_DISPLAY' => 'Você não está mostrando nenhum membro no momento',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Esta caixa não aparecerá para outras pessoas a não ser que você selecione pelo menos uma linha.',
        'DETAIL_VIEW' => 'Exibição detalhada',
        'TITLES_ONLY' => 'Apenas títulos',
        'RECENTLY_ADDED_POSTS' => 'Recém-adicionados(as)',
        'POPULAR_POSTS' => 'Mais comentados',
        'PROMOTED_POSTS' => 'Destaques',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Esta caixa não aparecerá para outras pessoas a não ser que você selecione ao menos uma mensagem.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Mantenha esta janela do navegador aberta enquanto o carregamento estiver em andamento.',
        'CANCEL_UPLOAD' => 'Cancelar carregamento',
        'YOU_DO_NOT_HAVE_POSTS' => 'Você ainda não escreveu nenhuma mensagem.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Não há mais comentários aguardando aprovação.',
        'REQUIRED_FIELD' => '(Campo obrigatório)',
        'BLOG_POST_BY_X' => 'Mensagem de blog por %s',
        'HELLO' => 'Olá,',
        'ADDED_BY_X' => 'Adicionado por %s',
        'CLICK_TO_ADD_A_TITLE' => 'clique para adicionar um título',
        'DELETE_BLOG_POST' => 'Excluir mensagem',
        'DELETE_THIS_BLOG_POST_Q' => 'Excluir esta mensagem de blog?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Você realmente deseja excluir esta mensagem de blog? Este processo pode levar algum tempo.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Preencha algo em: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Selecione uma opção em: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Forneça uma data válida para: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Forneça uma data para: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => 'Mensagens de blog de %s em %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Mensagens de blog de destaque em %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Mensagens de blog para %s %s',
        'FEATURED_BLOG_POSTS' => 'Mensagens de blog de destaque',
        'EVERYONES_POSTS' => 'Mensagens de blog de todos',
        'PUBLISHED_N_OF_N' => 'Publicado em %d de %d',
        'DOWNLOAD_X' => 'Baixar %s',
        'UPLOAD_DID_NOT_WORK' => 'Desculpe, este carregamento não funcionou',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'j. M, Y',
        'XS_POSTS' => 'Mensagens de %s',
        'USERNAMES_COMMENTS' => 'Comentários de %s',
        'ADD_COMMENT' => 'Adicionar comentário',
        'XS_PAGE' => 'Página de %s',
        'XS_BLOG' => 'Blog de %s',
        'XS_FRIENDS' => 'Amigos de %s',
        'VIEW_XS_ELLIPSIS' => 'Exibir de %s:',
        'DRAFT_BRACKETS' => '[ Rascunho ]',
        'FEATURED' => 'Destaques',
        'MY_POSTS' => 'Minhas mensagens',
        'MY_POSTS_ONLY' => 'Apenas minhas mensagens',
        'OWNER_POSTS_ONLY' => 'Apenas mensagens do criador',
        'JANUARY' => 'janeiro',
        'FEBRUARY' => 'fevereiro',
        'MARCH' => 'março',
        'APRIL' => 'abril',
        'MAY' => 'maio',
        'JUNE' => 'junho',
        'JULY' => 'julho',
        'AUGUST' => 'agosto',
        'SEPTEMBER' => 'setembro',
        'OCTOBER' => 'outubro',
        'NOVEMBER' => 'novembro',
        'DECEMBER' => 'dezembro',
        'MY_COMMENTS' => 'Meus comentários',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => 'Minha página',
        'MY_PAGE_TAB_TEXT' => 'Minha página',
        'BLOG_POSTS' => 'Mensagens de blog',
        'MY_BLOG' => 'Meu blog',
        'MONTH' => 'Mês',
        'DAY' => 'Dia',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Escolha uma alternativa válida para visibilidade padrão',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Escolha uma alternativa válida sobre quem pode comentar',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Escolha uma alternativa válida para a moderação de comentários no blogs',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Escolha uma alternativa válida para notificações de atividade',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Escolha uma alternativa válida para notificações de moderação',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Escolha uma alternativa válida para notificações de aprovação',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Escolha uma alternativa válida para notificações de convidados se associando',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Escolha uma alternativa válida para nunca receber notificações',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Escolha uma alternativa válida para notificações de pedidos de amizade',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Escolha uma alternativa válida para notificações de novas mensagens',
        'APPROVE_COMMENT' => 'Aprovar comentário',
        'MANAGE_BLOG' => 'Administrar blog',
        'COMMENTS_POSTED_ON_BLOG' => 'Comentários publicados em meu blog',
        'COMMENT' => 'Comentário',
        'COMMENTER' => 'Autor',
        'POST' => 'MENSAGEM',
        'M_J_Y_G_IA' => 'j M, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'A mensagem foi excluída',
        'COMMENTS_ARE_CLOSED' => 'Os comentários estão fechados para esta mensagem de blog',
        'NO_COMMENTS' => 'Sem comentários',
        'FLAG' => 'Sinalizar',
        'POST_TITLE' => 'Título da mensagem',
        'DRAFT_PARENTHESES' => '(Rascunho)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Programada para ser publicada em: %s',
        'EDIT_2' => 'edição',
        'NONE' => 'Nenhuma',
        'N_NEW' => '%s novo',
        'NO_POSTS' => 'Sem mensagens',
        'ADD_NEW_BLOG_POST' => 'Adicionar uma nova mensagem de blog',
        'HAPPY' => 'Feliz',
        'SAD' => 'Triste',
        'COOL' => 'Legal',
        'EVIL' => 'Maligno',
        'MAD' => 'Louco',
        'ENVIOUS' => 'Invejoso',
        'ENTRY' => 'Entrada',
        'WHAT_DATE_FOR_YOUR_POST' => 'Que data você gostaria para sua mensagem?',
        'NOW' => 'Agora',
        'CHOOSE_DATE_AND_TIME' => 'Escolha uma data e hora (se escolher uma data futura, sua mensagem será publicada naquela ocasião)',
        'PRIVACY_AND_COMMENTS' => 'Privacidade e Comentários',
        'WHO_CAN_VIEW_POST' => 'Quem pode ler esta mensagem?',
        'EVERYONE' => 'Todos',
        'ALLOW_COMMENTS' => 'Permitir comentários para esta mensagem?',
        'YES' => 'Sim',
        'NO' => 'Não',
        'COMMENT_MODERATION' => 'Moderação de comentários',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Você está atualmente moderando comentários no blog.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Você não está atualmente moderando comentários no blog.',
        'SAVE_AS_DRAFT' => 'Salvar como rascunho',
        'PREVIEW' => 'Prévia',
        'PUBLISH_POST' => 'Publicar mensagem',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Esta é uma prévia de como sua mensagem do blog ficará quando publicada. Clique em Voltar para editar a mensagem ou em Publicar caso esteja pronta!',
        'BACK' => 'Voltar',
        'PUBLISH' => 'Publicar!',
        'BLOG_POST' => 'Mensagem do blog',
        'PROFILE' => 'Perfil',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Este é um rascunho não publicado',
        'WILL_BE_PUBLISHED_ON_X' => 'Será publicado em %s <small>%s</small>',
        'POSTED_ON_X' => 'Publicado em <strong>%s</strong> <small>%s</small>',
        'POSTED_ON_X_BY' => 'Publicado em <strong>%s</strong> <small>%s</small> por:',
        'ABOUT_THIS_POST' => 'Sobre esta mensagem',
        'ABOUT_YOUR_POST' => 'Sobre sua mensagem',
        'ADDED_BY' => 'Adicionada por:',
        'JUST_FRIENDS' => 'Apenas amigos',
        'RECENT_POSTS' => 'Mensagens recentes',
        'THERE_ARE_NO_RECENT_POSTS' => 'Não há mensagens recentes.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Seu comentário foi enviado, mas precisa ser aprovado antes que todos possam vê-lo.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'Em %s em %s, %s disse...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s ainda não possui amigos nesta rede social.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Você ainda não possui amigos nesta rede social.',
        'EDIT_PAGE_APPEARANCE' => 'Editar o visual da página',
        'VIEW_PAGE_AS_OTHERS' => 'Exibir a página como os outros a vêem',
        'ADD_BLOG_POST' => 'Adicionar mensagem de blog',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Deixe esta janela do navegador aberta enquanto todo o conteúdo de %s é removido. Este processo pode levar alguns minutos.',
        'BAN_MEMBER_FROM_NETWORK' => 'Banir membro da rede',
        'BAN_USERNAME' => 'Banir %s?',
        'BLOCK' => 'bloquear',
        'CREATE_NEW_BLOG_POST' => 'Criar uma nova mensagem de blog!',
        'EDIT_POST' => 'Editar mensagem',
        'EDIT_POST_COLON' => 'Editar mensagem:',
        'CONTINUE_READING' => 'Continuar leitura...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Publicado por <a %s>mim</a> em %s às %s —',
        'POSTED_BY_X_ON_X_AT_X' => 'Publicado por %s em %s às %s —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Publicado por mim em %s às %s —',
        'ADD' => 'Adicionar',
        'SUBSCRIBE' => 'Assinar',
        'VIEW_ARCHIVES' => 'Exibir arquivos',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Suas configurações foram salvas.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Corrija o seguinte:',
        'PRIVACY' => 'Privacidade',
        'NETWORK_PRIVACY' => 'Privacidade da rede',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Esta rede é <strong>visível a todos</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Qualquer um pode entrar e se tornar um membro. Visitantes podem...',
        'SEE_EVERYTHING' => 'Ver tudo',
        'SEE_JUST_THE_MAIN_PAGE' => 'Ver apenas a página principal',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Ver apenas a página de registro',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Esta rede é <strong>visível apenas aos membros</strong>.',
        'WHO_CAN_SIGN_UP' => 'Quem pode se registrar e virar membro?',
        'MODERATION' => 'Moderação',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Aprovar o perfil de novos membros antes de se associarem',
        'APPROVE_PHOTOS_VIDEOS' => 'Aprovar fotos e vídeos antes de aparecerem',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Exibir as últimas atividades em sua rede!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Coloque um fluxo constantemente atualizado das atividades recentes na página principal de sua rede.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Clique aqui para adicionar as últimas atividades à sua rede.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Estas opções estão desabilitadas já que você não possui o módulo de últimas atividades em sua rede.',
        'ACTIVITY' => 'Atividade',
        'DISPLAY_PREFERENCES' => 'Preferências de exibição',
        'NEW_CONTENT' => 'Novos conteúdos',
        'NEW_COMMENTS' => 'Novos comentários',
        'NEW_MEMBERS' => 'Novos membros',
        'MEMBER_UPDATES' => 'Atualizações de membros',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'O que deve ser exibido no módulo de<br /> últimas atividades de sua rede?',
        'LATEST_ACTIVITY' => 'Últimas atividades',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s respondeu ao tópico %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>respondeu</a> ao tópico <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'Você <a %1$s>respondeu</a> ao tópico <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s fez um comentário à mensagem do blog%2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>fez um comentário</a> à mensagem do blog <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'Você <a %1$s>fez um comentário</a> à mensagem do blog <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s iniciou um tópico de discussão chamado %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Você iniciou um tópico de discussão chamado %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s adicionou uma mensagem de blog \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Você adicionou uma mensagem de blog \'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s entrou para o grupo %s',
        'YOU_JOINED_THE_GROUP_X' => 'Você entrou para o grupo %s',
        'X_JOINED_Y_GROUPS' => '%s entrou para %s grupos',
        'YOU_JOINED_X_GROUPS' => 'Você entrou para %s grupos',
        'X_JOINED_APPNAME' => '%s entrou para %s',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Bem-vindo(a) %1$s! Você é o membro %2$s de %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Bem-vindo(a) %1$s! Você é o membro %2$s de %3$s. <a %4$s>Encontre amigos agora</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s é o membro %2$s de %3$s.',
        'XS_PROFILE_CHANGED' => 'o perfil de %s mudou',
        'YOUR_PROFILE_CHANGED' => 'Seu perfil mudou',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s deixou um comentário para %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Você deixou um comentário para %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s deixou um comentário para você',
        'X_CREATED_A_GROUP_Y' => '%s criou um grupo chamado %s',
        'YOU_CREATED_A_GROUP_Y' => 'Você criou um grupo chamado %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s criou %s novos grupos',
        'X_STARTED_Y_FORUM_POSTS' => '%s iniciou %s novos tópicos no fórum',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Você iniciou %s novos tópicos no fórum',
        'X_ADDED_Y_BLOG_POSTS' => '%s adicionou %s novas mensagens de blog',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Você adicionou %s novas mensagens de blog',
        'VIEW_XS_BLOG_POSTS' => 'Exibir as mensagens de blog de %s',
        'VIEW_YOUR_BLOG_POSTS' => 'Exibir suas mensagens de blog',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s possui <a %s>novas perguntas de perfil</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s agora possui um music player',
        'APPNAME_NOW_HAS_GROUPS' => '%s agora possui <a %s>grupos</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s agora possui <a %s>vídeos</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s agora possui <a %s>fórum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s agora possui <a %s>fotos</a>',
        'DID_YOU_KNOW' => 'Você sabia',
        'ANNOUNCEMENT' => 'Comunicado',
        'CONGRATULATIONS' => 'Parabéns',
        'YOU_CREATED_APPNAME' => 'Você criou a rede %s.',
        'USER_CREATED_APPNAME' => '%s criou a rede %s.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Adicione mensagens e defina o que é exibido no quadro de atividades em sua rede.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Quais ações devem ser exibidas no quadro<br /> \'Últimas atividades\'?',
        'NEW_CONTENT_I_ADD' => 'Novos conteúdos que eu adicionar',
        'NEW_COMMENTS_I_ADD' => 'Novos comentários que eu adicionar',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Quando eu atualizar meu perfil',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'O quadro \'Últimas atividades\' nunca exibirá mensagens que você enviar, páginas ou perfis visitados, convites recusados, pessoas removidas de sua lista de amigos ou cujo pedido de amizade você recusou ou itens excluídos.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Você não possui atividade recente. Que tal começar algo?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Você desligou o quadro de suas atividades. <a %s>Clique aqui para ativá-lo novamente.</a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'O criador desta rede desabilitou a exibição de todas as atividades.',
        'NO_ACTIVITY_TO_DISPLAY' => 'Você não está exibindo atividades no momento.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Esta caixa não aparecerá para outras pessoas a não ser que você selecione pelo menos um item de atividade.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Não há atividade recente. Que tal começar algo?',
        'MY_ACTIVITY_PREFERENCES' => 'Minhas preferências de atividade',
        'DELETE_ACTIVITY_ITEM' => 'Remover mensagem de atividade',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Remover esta mensagem de atividade?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Isto evitará que os usuários vejam esta mensagem de atividade',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s foi quem publicou mais %2$sfotos%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s é a foto mais popular até agora',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s foi quem publicou mais %2$svídeos%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s é o vídeo mais popular até agora',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s foi quem publicou mais músicas',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s é a música mais popular até agora',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s é a mensagem mais popular do fórum até agora',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s é a mensagem de blog mais popular até agora',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => 'Últimas atividades de %s\\ em %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Últimas atividades em %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Adicionar mensagem às últimas atividades',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Adicionar fatos sobre a rede...',
        'ADD_MESSAGE' => 'Adicionar mensagem',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '...ou escreva sua própria mensagem',
        'NETWORK' => 'Rede',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Quem pode ver minhas fotos, vídeos<br/> e mensagens do blog?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Você pode sobrepor esta configuração para foto, vídeo ou mensagem do blog quando adicionar um desses itens.)',
        'MODERATE_COMMENTS_ON_BLOG' => 'Deseja aprovar os comentários <br />antes de aparecerem em seu blog?',
        'YES_LET_ME_APPROVE' => 'Sim - Os comentários precisam ser aprovados antes',
        'NO_PUBLISH_COMMENTS' => 'Não - Publique os comentários imediatamente',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Quem pode comentar sobre minhas fotos,<br/> vídeos e blog?',
        'SAVE' => 'Salvar',
        'EMAIL' => 'E-mail',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Sua privacidade é importante para nós. Caso tenha qualquer dúvida sobre as notificações por e-mail, entre em contato pela <a href="http://help.ning.com/?page_id=27">Central de Ajuda</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Adicione fotos e vídeos a %s enviando-os para este endereço de e-mail:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Adicione fotos e vídeos a %s de seu celular enviando-os para este endereço de e-mail:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Gerar novo endereço de e-mail',
        'SUPPORTS_TEXT_EMBEDDED' => 'Aceita texto, vídeos embutidos, fotos e componentes gráficos',
        'POST_COMMENT' => 'Publicar comentário',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Você precisa ser um membro de %s para adicionar comentários!',
        'MONTHLY_ARCHIVES' => 'Arquivos mensais',
        'NO_FRIENDS_ON_SITE' => 'Não há ainda nenhum amigo nesta rede social.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Nenhum amigo nesta rede social atende os termos de sua pesquisa.',
        'MEMBERS_TAB_TEXT' => 'Membros',
        'SITE_HAS_NO_MEMBERS' => 'Esta rede social ainda não possui nenhum membro!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Esta rede social não tem membros que atendam os termos de sua pesquisa.',
        'NO_COMMENTS_YET' => 'Sem comentários por enquanto!',
        'VIEW_ALL_COMMENTS' => 'Ver todos os comentários',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Você ainda não adicionou nenhuma mensagem de blog!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Escreva sobre o que quiser e cole seus vídeos, fotos e músicas prediletos.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Escreva sua primeira entrada!',
        'THERE_ARE_NO_BLOG_POSTS' => 'No momento não há mensagens de blog em sua rede social.',
        'THERE_ARE_NO_FEATURED_X' => 'Não há %s de destaque em sua rede social.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Não há %s que atendem ao critério selecionado.',
        'START_FEATURING_X_CLICK_Y' => 'Comece a apresentação de %s quando visualizar a opção Apresentar. Para saber mais sobre o processo, <a %s>clique aqui</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Esta caixa não aparecerá para outras pessoas até que haja mensagens de blog a serem exibidas. Que tal adicionar uma?',
        'YOUR_FRIEND' => 'Seu amigo',
        'REQUEST_SENT' => 'Pedido enviado!',
        'BLOCKED' => 'Bloqueado',
        'BANNED' => 'Banido',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Adicione sua primeira mensagem de blog',
        'MY_FIRST_BLOG_POST' => 'Minha primeira mensagem de blog!',
        'TELL_THE_PEOPLE_ON' => 'Conte mais sobre você em %s. Perguntas marcadas com um <span %s>cadeado</span> são particulares e visíveis apenas para os administradores.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Escolha um tema para sua página',
        'NOW_CUSTOMIZE_PAGE' => 'Personalize agora a sua página...',
        'NO_POSTS_TO_DISPLAY' => 'Não há mensagens a exibir.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'Você não está exibindo mensagens no momento.',
        'DATE_COLON' => 'Data:',
        'TIME_COLON' => 'Horário:',
        'CHANGE' => 'Alterar',
        'UPLOAD_A_PHOTO' => 'Carregar uma foto',
        'OPTIONS' => 'Opções',
        'PIXELS' => 'Pixels',
        'CANCEL' => 'Cancelar',
        'UPLOAD_A_FILE' => 'Carregar um arquivo:',
        'TO_INSERT_A_FILE' => 'Para inserir um arquivo, clique no botão "Procurar" ou "Escolher" acima para localizar o arquivo em seu computador.',
        'UPLOADING' => 'Carregando...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Membros populares',
        'INVITE_FRIENDS' => 'Convidar amigos',
        'VIEW_ALL' => 'Exibir todos',
        'REMOVE_X' => 'Remover %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Você realmente deseja banir %1$s de sua rede social e remover todo conteúdo adicionado por %1$s? Este processo pode levar alguns minutos.',
        'REMOVING_X' => 'Removendo %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Você realmente deseja banir de sua rede social o(s) membro(s) selecionado(s) e remover todo conteúdo adicionado por ele(s)? Este processo pode levar alguns minutos.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Você realmente deseja banir de sua rede social o(s) membro(s) selecionado(s)? Este processo pode levar alguns minutos.',
        'BAN' => 'Banir',
        'REMOVING_MEMBERS' => 'Removendo membros',
        'FEMALE' => 'Feminino',
        'MALE' => 'Masculino',
        'UNITED_STATES' => 'Estados Unidos',
        'AND' => 'e',
        'FROM' => 'de',
        'GENDER_M' => 'Masculino',
        'GENDER_F' => 'Feminino',
        'XS_PAGE_ON_Y' => 'Página de %s em %s',
        'SEARCH_MEMBERS' => 'Procurar membros',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'alguém fez um comentário sobre uma mensagem do blog que você adicionou a %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Você tem novo comentário em sua página.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Você tem novo comentário em sua página em %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Você tem novo comentário em sua página em %s...',
        'A_BLOG_POST' => 'uma mensagem do blog',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Agora que você entrou, <strong><a %s>convide seus amigos</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'Este é seu perfil:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Comece <a %s>personalizando o visual</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Use para <a %1$s>manter um blog</a> e exibir <a %2$s>as respostas de seu perfil</a>.',
        'START_CONTRIBUTING' => 'Comece a contribuir:',
        'UPLOAD_VIDEOS' => 'Carregue vídeos',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Contribua nos tópicos de discussão',
        'JOIN_GROUPS' => 'Associe-se a grupos',
        'ADD_A_BLOG_POST' => 'Adicione uma mensagem no blog',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Clique aqui para conferir seus pedidos de amizade.',
        'LEAVE_X' => 'Sair de %s',
        'LEAVE_X_Q' => 'Sair de %s?',
        'ARE_YOU_SURE_LEAVE_X' => 'Você realmente deseja sair de %s e remover todo o conteúdo? Isto pode levar alguns minutos.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592; Voltar para a página de %s\\',
        'BACK_TO_MY_PAGE' => '&#8592;Voltar para minha página',
        'COMMENT_WALL' => 'Caixa de Recados',
        'ONLINE' => 'Online',
        'MEMBER_IS_ONLINE' => 'Membro está online',
        'ONLINE_NOW' => 'Online agora',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Escolha quem pode acessar, associar-se e contribuir em sua rede.',
        'EMAIL_NOTIFICATIONS' => 'Notificações por e-mail',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Sobre quais atividades da rede você gostaria de ser notificado por e-mail?',
        'NETWORK_MESSAGES' => 'Mensagens da rede',
        'MEMBER_ACTIVITY' => 'Atividades de membros',
        'APPROVAL' => 'Aprovação',
        'FRIEND_REQUESTS' => 'Pedidos de amizade',
        'PEOPLE_IVE_INVITED_JOIN' => 'Pessoas que eu convidei para fazer parte desta rede',
        'MESSAGES_SENT_TO_ME' => 'Mensagens enviadas a mim',
        'MESSAGES_SENT_TO_GROUPS' => 'Mensagens enviadas a grupos de que faço parte',
        'MESSAGES_SENT_TO_NETWORK' => 'Mensagens enviadas para toda a rede',
        'I_HAVE_NEW_COMMENTS' => 'Comentários esperando aprovação',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Conteúdos na rede esperando aprovação',
        'CONTENT_ACTIVITY' => 'Atividade de conteúdo',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Atividade em coisas que eu adicionei',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Acompanhar automaticamente tópicos que eu responder',
        'THINGS_IVE_ADDED_APPROVED' => 'Coisas que eu adicionei foram aprovadas',
        'NOTIFICATIONS' => 'Notificações',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Enviar-me e-mail quando alguém responder',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Não me enviar e-mail quando alguém responder',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'Para não mais acompanhar este(a) %s, <a %s>clique aqui</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Você não está mais acompanhando este(a) %s.',
        'NOTIFY' => 'Notificar',
        'STOP_NOTIFYING' => 'Parar notificação',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Enviar-me e-mail quando houver novos tópicos',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Não me enviar e-mail quando houver novos tópicos',
        'STOP_FOLLOWING_ALL' => 'Parar de acompanhar todas as discussões e comentários de blog',
        'CHANGE_MY_PHOTO' => 'Alterar minha foto',
        'COUNTRY_AF' => 'Afeganistão',
        'COUNTRY_AX' => 'Ilhas Aland',
        'COUNTRY_AL' => 'Albânia',
        'COUNTRY_DZ' => 'Argélia',
        'COUNTRY_AS' => 'Samoa Americana',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antártica',
        'COUNTRY_AG' => 'Antígua e Barbuda',
        'COUNTRY_AR' => 'Argentina',
        'COUNTRY_AM' => 'Armênia',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Austrália',
        'COUNTRY_AT' => 'Áustria',
        'COUNTRY_AZ' => 'Azerbaijão',
        'COUNTRY_BS' => 'Bahamas',
        'COUNTRY_BH' => 'Bahrein',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Belarus',
        'COUNTRY_BE' => 'Bélgica',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermuda',
        'COUNTRY_BT' => 'Butão',
        'COUNTRY_BO' => 'Bolívia',
        'COUNTRY_BA' => 'Bósnia e Herzegovina',
        'COUNTRY_BW' => 'Botsuana',
        'COUNTRY_BV' => 'Ilha Bouvet',
        'COUNTRY_BR' => 'Brasil',
        'COUNTRY_IO' => 'Território Britânico do Oceano Índico',
        'COUNTRY_BN' => 'Brunei Darussalam',
        'COUNTRY_BG' => 'Bulgária',
        'COUNTRY_BF' => 'Burquina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Camboja',
        'COUNTRY_CM' => 'Camarões',
        'COUNTRY_CA' => 'Canadá',
        'COUNTRY_CV' => 'Cabo Verde',
        'COUNTRY_KY' => 'Ilhas Cayman',
        'COUNTRY_CF' => 'República Centro-Africana',
        'COUNTRY_TD' => 'Chade',
        'COUNTRY_CL' => 'Chile',
        'COUNTRY_CN' => 'China, terra firme',
        'COUNTRY_CX' => 'Ilha Christmas',
        'COUNTRY_CC' => 'Ilhas Cocos (Keeling)',
        'COUNTRY_CO' => 'Colômbia',
        'COUNTRY_KM' => 'Ilhas Comores',
        'COUNTRY_CG' => 'Congo, República do',
        'COUNTRY_CD' => 'Congo, República Democrática do',
        'COUNTRY_CK' => 'Ilhas Cook',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Costa do Marfim',
        'COUNTRY_HR' => 'Croácia',
        'COUNTRY_CU' => 'Cuba',
        'COUNTRY_CY' => 'Chipre',
        'COUNTRY_CZ' => 'República Tcheca',
        'COUNTRY_DK' => 'Dinamarca',
        'COUNTRY_DJ' => 'Djibuti',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'República Dominicana',
        'COUNTRY_EC' => 'Equador',
        'COUNTRY_EG' => 'Egito',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_GQ' => 'Guiné Equatorial',
        'COUNTRY_ER' => 'Eritréia',
        'COUNTRY_EE' => 'Estônia',
        'COUNTRY_ET' => 'Etiópia',
        'COUNTRY_EU' => 'União Européia',
        'COUNTRY_FK' => 'Ilhas Falkland',
        'COUNTRY_FO' => 'Ilhas Faroe',
        'COUNTRY_FJ' => 'Fiji',
        'COUNTRY_FI' => 'Finlândia',
        'COUNTRY_FR' => 'França',
        'COUNTRY_GF' => 'Guiana Francesa',
        'COUNTRY_PF' => 'Polinésia Francesa',
        'COUNTRY_TF' => 'Territórios Franceses do Sul',
        'COUNTRY_GA' => 'Gabão',
        'COUNTRY_GM' => 'Gâmbia',
        'COUNTRY_GE' => 'Geórgia',
        'COUNTRY_DE' => 'Alemanha',
        'COUNTRY_GH' => 'Gana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Grécia',
        'COUNTRY_GL' => 'Groenlândia',
        'COUNTRY_GD' => 'Granada',
        'COUNTRY_GP' => 'Guadalupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guiné',
        'COUNTRY_GW' => 'Guiné-Bissau',
        'COUNTRY_GY' => 'Guiana',
        'COUNTRY_HT' => 'Haiti',
        'COUNTRY_HM' => 'Ilhas Heard e McDonald',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Hungria',
        'COUNTRY_IS' => 'Islândia',
        'COUNTRY_IN' => 'Índia',
        'COUNTRY_ID' => 'Indonésia',
        'COUNTRY_IR' => 'Irã, República Islâmica do',
        'COUNTRY_IQ' => 'Iraque',
        'COUNTRY_IE' => 'Irlanda',
        'COUNTRY_IL' => 'Israel',
        'COUNTRY_IT' => 'Itália',
        'COUNTRY_JM' => 'Jamaica',
        'COUNTRY_JP' => 'Japão',
        'COUNTRY_JO' => 'Jordânia',
        'COUNTRY_KZ' => 'Cazaquistão',
        'COUNTRY_KE' => 'Quênia',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Coréia, República Democrática Popular da',
        'COUNTRY_KR' => 'Coréia, República da',
        'COUNTRY_KW' => 'Kuwait',
        'COUNTRY_KG' => 'Quirguistão',
        'COUNTRY_LA' => 'Lao, República Democrática Popular do',
        'COUNTRY_LV' => 'Letônia',
        'COUNTRY_LB' => 'Líbano',
        'COUNTRY_LS' => 'Lesoto',
        'COUNTRY_LR' => 'Libéria',
        'COUNTRY_LY' => 'República Árabe de Líbia',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Lituânia',
        'COUNTRY_LU' => 'Luxemburgo',
        'COUNTRY_MO' => 'Macau',
        'COUNTRY_MK' => 'Macedônia, Antiga República Iugoslava da',
        'COUNTRY_MG' => 'Madagascar',
        'COUNTRY_MW' => 'Malaui',
        'COUNTRY_MY' => 'Malásia',
        'COUNTRY_MV' => 'Maldivas',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Ilhas Marshall',
        'COUNTRY_MQ' => 'Martinica',
        'COUNTRY_MR' => 'Mauritânia',
        'COUNTRY_MU' => 'Maurício',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'México',
        'COUNTRY_FM' => 'Micronésia, Estados Federados da',
        'COUNTRY_MD' => 'Moldávia, República de',
        'COUNTRY_MC' => 'Mônaco',
        'COUNTRY_MN' => 'Mongólia',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Marrocos',
        'COUNTRY_MZ' => 'Moçambique',
        'COUNTRY_MM' => 'Miamar',
        'COUNTRY_NA' => 'Namíbia',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Países Baixos',
        'COUNTRY_AN' => 'Antilhas Holandesas',
        'COUNTRY_NC' => 'Nova Caledônia',
        'COUNTRY_NZ' => 'Nova Zelândia',
        'COUNTRY_NI' => 'Nicarágua',
        'COUNTRY_NE' => 'Níger',
        'COUNTRY_NG' => 'Nigéria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Ilha Norfolk',
        'COUNTRY_MP' => 'Ilhas Marianas do Norte',
        'COUNTRY_NO' => 'Noruega',
        'COUNTRY_OM' => 'Omã',
        'COUNTRY_PK' => 'Paquistão',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Território Ocupado da Palestina',
        'COUNTRY_PA' => 'Panamá',
        'COUNTRY_PG' => 'Papua-Nova Guiné',
        'COUNTRY_PY' => 'Paraguai',
        'COUNTRY_PE' => 'Peru',
        'COUNTRY_PH' => 'Filipinas',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Polônia',
        'COUNTRY_PT' => 'Portugal',
        'COUNTRY_PR' => 'Porto Rico',
        'COUNTRY_QA' => 'Catar',
        'COUNTRY_RE' => 'Reunião',
        'COUNTRY_RO' => 'Romênia',
        'COUNTRY_RU' => 'Federação Russa',
        'COUNTRY_RW' => 'Ruanda',
        'COUNTRY_SH' => 'Santa Helena',
        'COUNTRY_KN' => 'São Cristóvão e Névis',
        'COUNTRY_LC' => 'Santa Lúcia',
        'COUNTRY_PM' => 'São Pedro e Miquelon',
        'COUNTRY_VC' => 'São Vicente e Granadinas',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'São Marino',
        'COUNTRY_ST' => 'São Tomé e Príncipe',
        'COUNTRY_SA' => 'Arábia Saudita',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Sérbia e Montenegro',
        'COUNTRY_SC' => 'Seicheles',
        'COUNTRY_SL' => 'Serra Leoa',
        'COUNTRY_SG' => 'Cingapura',
        'COUNTRY_SK' => 'Eslováquia',
        'COUNTRY_SI' => 'Eslovênia',
        'COUNTRY_SB' => 'Ilhas Salomão',
        'COUNTRY_SO' => 'Somália',
        'COUNTRY_ZA' => 'África do Sul',
        'COUNTRY_GS' => 'Ilhas Geórgia do Sul e Sandwich do Sul',
        'COUNTRY_ES' => 'Espanha',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Sudão',
        'COUNTRY_SR' => 'Suriname',
        'COUNTRY_SJ' => 'Svalbard e Jan Mayen',
        'COUNTRY_SZ' => 'Suazilândia',
        'COUNTRY_SE' => 'Suécia',
        'COUNTRY_CH' => 'Suíça',
        'COUNTRY_SY' => 'República Árabe da Síria',
        'COUNTRY_TW' => 'Taiwan',
        'COUNTRY_TJ' => 'Tajiquistão',
        'COUNTRY_TZ' => 'Tanzânia, República Unida da',
        'COUNTRY_TH' => 'Tailândia',
        'COUNTRY_TL' => 'Timor Leste',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad e Tobago',
        'COUNTRY_TN' => 'Tunísia',
        'COUNTRY_TR' => 'Turquia',
        'COUNTRY_TM' => 'Turcomenistão',
        'COUNTRY_TC' => 'Ilhas Turcos e Caicos',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ucrânia',
        'COUNTRY_AE' => 'Emirados Árabes Unidos',
        'COUNTRY_GB' => 'Reino Unido',
        'COUNTRY_US' => 'Estados Unidos',
        'COUNTRY_UM' => 'Territórios Insulares dos Estados Unidos',
        'COUNTRY_UY' => 'Uruguai',
        'COUNTRY_UZ' => 'Usbequistão',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Cidade-Estado do Vaticano',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Vietnã',
        'COUNTRY_VG' => 'Ilhas Virgens Britânicas',
        'COUNTRY_VI' => 'Ilhas Virgens dos EUA',
        'COUNTRY_WF' => 'Wallis e Futuna',
        'COUNTRY_EH' => 'Saara Ocidental',
        'COUNTRY_YE' => 'Iêmen',
        'COUNTRY_ZM' => 'Zâmbia',
        'COUNTRY_ZW' => 'Zimbábue',
        'ERROR_LOG' => 'Registro de erros',
        'CANNOT_READ_ERROR_LOG' => 'Não foi possível ler o registro de erros',
        'CANNOT_OPEN_ERROR_LOG' => 'Não foi possível abrir o registro de erros',
        'CANNOT_SCAN_ERROR_LOG' => 'Não foi possível fazer a varredura no registro de erros',
        'MODELS_RESET' => 'Reinicialização de modelos:',
        'NO_MODELS_RESET' => 'Nenhuma reinicialização de modelo.',
        'NO_FEED_TO_DISPLAY' => 'Você não está exibindo nenhum item.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Esta caixa não aparecerá para outras pessoas a não ser que você selecione pelo menos um item.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Clique em Editar para especificar um RSS feed para esta caixa.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Ocorreu um problema durante a restauração deste RSS feed.',
        'MORE_ELLIPSIS' => 'Mais...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Desculpe-nos, este site teve um problema.',
        'PLEASE_TRY_REFRESHING' => 'Tente atualizar esta página em 30 segundos, ou <a %s>nos avise</a> se esta mensagem aparecer novamente.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Não há discussões com a tag "%1$s".',
        'PAGE_TITLE_COLON' => 'Título da página:',
        'PAGE_CONTENT' => 'Conteúdo:',
        'CREATE_PAGE' => 'Criar página',
        'CREATE_NEW_PAGE' => 'Criar nova página',
        'YOUR_COMMENT' => 'Seu comentário',
        'ADD_YOUR_COMMENT' => 'Adicionar seu comentário',
        'DELETE_PAGE' => 'Excluir esta página',
        'DELETE_THIS_PAGE_Q' => 'Excluir esta página?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Tem certeza de que deseja excluir esta página (incluindo todos os comentários)? Este processo pode levar alguns minutos.',
        'SEARCH_PAGES' => 'Procurar páginas',
        'ALL_PAGES' => 'Todas as páginas',
        'SUBSCRIBE_TO_PAGES' => 'Inscrever-se para estas páginas',
        'NOBODY_HAS_ADDED_PAGES' => 'Ninguém adicionou uma página ainda!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Crie uma página para começar.',
        'CREATE_A_PAGE' => 'Criar uma página',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Digite o conteúdo da página',
        'SEARCH_RESULTS_FOR_X' => 'Procurar resultados para <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Editar sua página',
        'UPDATE_PAGE' => 'Atualizar página',
        'CLOSE_DISCUSSION' => 'Encerrar discussão',
        'REOPEN_DISCUSSION' => 'Reabrir discussão',
        'CLOSING_DISCUSSION_PREVENTS' => 'O encerramento de uma discussão impede respostas adicionais',
        'NO_DISCUSSION_TO_DISPLAY' => 'Você não está exibindo nenhum tópico no momento.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Esta caixa não aparecerá para outras pessoas a não ser que você selecione pelo menos um tópico.',
        'NEWEST_DISCUSSIONS' => 'Últimos tópicos',
        'LATEST_REPLIES' => 'Últimas respostas',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'As respostas para este tópico estão encerradas.',
        'SORRY_DISCUSSION_CLOSED' => 'Desculpe-nos, mas este tópico acaba de ser fechado para novas respostas.',
        'MOST_REPLIES' => 'Mais respostas',
        'OWNER_DISCUSSIONS_ONLY' => 'Somente tópicos do criador',
        'MY_DISCUSSIONS_ONLY' => 'Apenas meus tópicos',
        'DISCUSSION_DELETED' => 'Tópico removido',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Este tópico foi removido.',
        'REPLY_DELETED' => 'Resposta removida',
        'REPLY_HAS_BEEN_DELETED' => 'Esta resposta foi removida. <a %s>Voltar para o tópico.</a>',
        'VIEW_ALL_DISCUSSIONS' => 'Exibir todos os tópicos',
        'ADD_CATEGORIES' => 'Adicionar categorias',
        'CATEGORY' => 'Categoria:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'Esta categoria ainda não possui tópicos.',
        'ADD_MANAGE_CATEGORIES' => 'Adicionar/Gerenciar categorias',
        'VIEW_ALL_N_CATEGORIES' => 'Exibir todas as categorias de %s',
        'UNTITLED_CATEGORY' => 'Categoria sem título',
        'SAMPLE_TITLE' => 'Exemplo de título',
        'UNCATEGORIZED' => 'Não-categorizado',
        'EXISTING_DISCUSSIONS' => 'Tópicos existentes que não foram categorizados.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Não há categorias no momento. Adicione uma categoria para começar!',
        'ADD_A_CATEGORY' => 'Adicionar uma categoria',
        'ADD_ANOTHER_CATEGORY' => 'Adicionar outra categoria',
        'MANAGE_CATEGORIES' => 'Gerenciar categorias',
        'CATEGORY_TITLE' => 'Título da categoria',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Permitir que membros iniciem tópicos nesta categoria',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Apenas eu posso iniciar tópicos nesta categoria',
        'ALLOW_MEMBERS_TO_REPLY' => 'Permitir que membros respondam',
        'SUGGESTIONS' => 'Sugestões:',
        'TRY_DIFFERENT_KEYWORDS' => 'Tente palavras-chave diferentes ou mais genéricas',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Exibir todos os tópicos</a> ou <a %s>Iniciar um novo tópico</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Certifique-se de que todas as palavras estão corretas',
        'REPLY_WAS_DELETED' => 'Esta resposta foi excluída',
        'TAGS_X' => '<strong>Tags:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Enviar mensagem particular',
        'PERMALINK_TO_REPLY' => 'Permalink para esta resposta',
        'PERMALINK' => 'Permalink',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Desculpe-nos - nenhum tópico contendo os termos de sua busca foi encontrado.',
        'DISCUSSIONS_MATCHING_X' => 'Tópicos contendo <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Procurar tópicos',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Você ainda não adicionou nenhum tópico!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Adicione tópicos e compartilhe-os com seus amigos, familiares e o resto do mundo!',
        'DISCUSSION' => 'Tópico',
        'DISCUSSIONS' => 'Tópicos',
        'KEEP_PAGE_OPEN_FORUM' => 'Deixe esta página aberta até terminar o carregamento dos arquivos para o fórum.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Enquanto isso, fique à vontade para <a %s>abrir uma nova janela do navegador</a> e continuar usando %s.',
        'START_A_NEW_DISCUSSION' => 'Iniciar um novo tópico',
        'DISCUSSION_TITLE' => 'Título do tópico:',
        'FIRST_POST' => 'Mensagem:',
        'UPLOAD_FILES' => 'Anexar arquivo(s):',
        'START_DISCUSSION' => 'Iniciar tópico',
        'EDIT_DISCUSSION' => 'Editar tópico',
        'START_A_DISCUSSION' => 'Criar um tópico',
        'ALL_DISCUSSIONS' => 'Página inicial do fórum',
        'CONTRIBUTORS' => 'Colaboradores',
        'MY_DISCUSSIONS' => 'Meus tópicos',
        'READ_MORE' => 'Ler mais',
        'STARTED_T_BY' => 'Iniciado <strong>%s</strong> por:',
        'ADDED_BY_X_T' => 'Adicionado por %s %s',
        'STARTED_BY_X_T' => 'Iniciado por %s %s',
        'REPLY_BY_X_T' => 'Resposta de <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Iniciado por %s. Última <a %s>resposta</a> de %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Iniciou este tópico.</strong> Última <a %s>resposta</a> por %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>Iniciou este tópico</strong> %s',
        'ADDED_REPLY_T' => '<strong>Respondeu</strong> %s',
        'ADDED_POST_T' => '<strong>Adicionou uma mensagem</strong> %s',
        'STARTED_BY_X_ON' => 'Iniciado por %s em %s',
        'STARTED_DISCUSSION_ON' => '<strong>Iniciou este tópico</strong> %s',
        'STARTED_ON' => '<strong>Iniciou</strong> %s',
        'ADDED_REPLY_ON' => '<strong>Respondeu</strong> %s',
        'ADDED_POST_ON' => '<strong>Adicionou uma mensagem</strong> %s',
        'XS_DISCUSSIONS' => 'Tópicos de %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'Tópicos de %s',
        'VIEW_XS_DISCUSSIONS' => 'Exibir tópicos de %s',
        'VIEW_YOUR_DISCUSSIONS' => 'Exibir seus tópicos',
        'TAGGED_X' => 'Tag: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Inscrever-se para estes tópicos',
        'SUBSCRIBE_TO_DISCUSSION' => 'Inscrever-se para este tópico',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Inscrever-se para os tópicos de %s',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Todos os tópicos com a tag <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Acompanhar os tópicos com a tag \'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Carregando arquivos',
        'ATTACHMENTS' => 'Anexos',
        'YOUR_POST' => 'Sua mensagem:',
        'YOUR_REPLY' => 'Sua resposta:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Deseja carregar arquivos?',
        'ADD_YOUR_REPLY' => 'Adicionar resposta',
        'REPLIES_TO_THIS_DISCUSSION' => 'Respostas a este tópico',
        'POSTED_BY_X_ON' => 'Enviado por %s %s',
        'PLEASE_ENTER_TITLE' => 'Digite um título para seu tópico',
        'PLEASE_ENTER_FIRST_POST' => 'Escreva a mensagem inicial deste tópico.',
        'REPLY_TO_THIS' => 'Responder esta',
        'DELETE_ATTACHMENT' => 'Excluir anexo',
        'DELETE_ATTACHMENT_Q' => 'Excluir este anexo?',
        'DELETE_REPLY' => 'Excluir resposta',
        'DELETE_THIS_DISCUSSION_Q' => 'Excluir este tópico?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Você realmente deseja remover este tópico (incluindo todas as respostas)? Este processo pode demorar alguns minutos.',
        'DELETE_DISCUSSION' => 'Remover tópico',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Ninguém adicionou um tópico até o momento.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Ninguém adicionou um tópico até o momento! Adicione um tópico para começar.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Você não iniciou nenhum tópico até agora. Adicione um tópico para começar!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Você ainda não criou nenhum tópico.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Você ainda não adicionou nenhum tópico.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s ainda não adicionou nenhum tópico.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s ainda não iniciou nenhum tópico.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s ainda não participou de nenhum tópico.',
        'VIEW_DISCUSSIONS' => 'Exibir tópicos',
        'VIEW_ALL_PEOPLE_ON_X' => 'Exibir todas as pessoas em %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'Não há tópicos em sua rede.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Este grupo ainda não possui nenhum tópico.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Exibir tópicos no <a %s> fórum %s</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Não há nenhum tópico com a tag "%1$s". Confira <a %2$s>as fotos com a tag "%1$s"</a> ou <a %3$s>os vídeos com a tag "%1$s"</a>. Ou adicione seus próprios tópicos e tags.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Não há nenhum tópico com a tag "%1$s". Confira <a %2$s>as fotos com a tag "%1$s"</a> ou <a %3$s>os vídeos com a tag "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Esta caixa não aparecerá para outras pessoas até que haja algum tópico. Que tal iniciar um?',
        'DISCUSSIONS_I_STARTED' => 'Tópicos iniciados por mim',
        'DISCUSSIONS_X_STARTED' => 'Tópicos iniciados por %s',
        'DISCUSSIONS_I_REPLIED_TO' => 'Tópicos que eu respondi',
        'DISCUSSIONS_X_REPLIED_TO' => 'Tópicos que %s respondeu',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Escreva uma mensagem.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Escreva sua resposta.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Há um novo comentário em seu tópico "%s" em %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Há um novo comentário em um de seus tópicos em %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'alguém fez um comentário sobre o tópico que você iniciou em %s',
        'ABOUT_YOUR_DISCUSSION' => 'Sobre seu tópico',
        'ABOUT_THIS_DISCUSSION' => 'Sobre este tópico',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s respondeu um tópico em %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s respondeu o tópico "%s" em %s',
        'PROBLEM_WITH_ICON' => 'Houve um problema com o arquivo do ícone',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Administradores do grupo possuem um nível de controle semelhante ao do criador do grupo.',
        'CREATE_NEW_GROUP' => 'Criar novo grupo',
        'CREATE_A_NEW_GROUP' => 'Criar um novo grupo',
        'CREATE_A_GROUP' => 'Criar um grupo',
        'VIEW_GROUPS' => 'Exibir grupos',
        'CREATE_GROUP' => 'Criar grupo',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Escolha um nome para seu grupo.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Escolha um endereço web para seu grupo.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'O endereço web deve conter apenas letras e números (sem espaços).',
        'NAME_TAKEN' => 'Desculpe-nos - este nome já foi utilizado. Escolha outro nome.',
        'URL_TAKEN' => 'Desculpe-nos - este endereço web já foi cadastrado. Escolha outro.',
        'GROUP_INFORMATION' => 'Informações sobre o grupo',
        'EXTERNAL_WEBSITE' => 'Site externo',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Você possui um site de grupo em algum outro lugar?',
        'URL' => 'URL',
        'GROUPS' => 'Grupos',
        'SEARCH_GROUPS' => 'Procurar grupos',
        'NOBODY_HAS_CREATED_GROUPS' => 'Nenhum grupo foi criado por enquanto.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Ninguém criou um grupo ainda! Crie um grupo para começar.',
        'MY_GROUPS' => 'Meus grupos',
        'FEATURED_GROUPS' => 'Grupos de destaque',
        'YOU_CAN_CREATE_GROUP' => 'Você pode <a %s>criar um novo grupo</a> em %s!',
        'GROUP_FORUM' => 'Fórum %s',
        'USER_CREATED_GROUP' => '%s criou um grupo em %s.',
        'GROUP_MEMBERS_COUNT' => 'Membros de %s (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Desculpe-nos, você não está autorizado a participar deste grupo.',
        'JOIN_GROUP_NOW' => 'Associe-se a %s já!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s convidou você para fazer parte de %s',
        'DECLINE' => 'Recusar',
        'WELCOME_TO_GROUP' => 'Bem-vindo a %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Você pode agora participar do fórum %s.',
        'SEND_MESSAGE_TO_GROUP' => 'Enviar mensagem ao grupo',
        'LEAVE_THIS_GROUP' => 'Deixar este grupo',
        'EDIT_GROUP_INFO' => 'Editar as informações deste grupo',
        'EDIT_GROUP_INFORMATION' => 'Editar as informações do grupo',
        'MANAGE_GROUP_MEMBERS' => 'Gerenciar membros do grupo',
        'GROUP_HAS_NO_MEMBERS' => 'Este grupo ainda não possui membros!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Este grupo ainda não possui membros que atendam sua pesquisa,',
        'USERS_GROUPS' => 'Grupos de %s',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Você ainda não criou nenhum grupo.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s ainda não criou nenhum grupo.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Não há grupos de destaque em sua rede social.',
        'START_FEATURING_GROUPS' => 'Comece a apresentação de grupos quando visualizar a opção Apresentar. Para saber mais sobre o processo, <a %s>clique aqui</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'Você não está exibindo grupos no momento.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Esta caixa não será vista por outras pessoas a não ser que você selecione pelo menos um grupo.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Você ainda não criou nenhum grupo!',
        'CREATE_GROUPS_AND_SHARE' => 'Crie grupos e compartilhe-os com seus amigos, familiares e o resto do mundo!',
        'THERE_ARE_NO_GROUPS' => 'Não há grupos em sua rede por enquanto.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Esta caixa não aparecerá para outras pessoas até que haja grupos a serem exibidos. Que tal criar um?',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Grupos que correspondam a <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Desculpe-nos - não encontramos nenhum grupo como resultado de sua busca.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Exibir todos os grupos</a> ou <a %s>Criar um novo grupo</a>',
        'VIEW_ALL_GROUPS' => 'Todos os grupos',
        'DELETE_GROUP' => 'Excluir grupo',
        'DELETE_GROUP_Q' => 'Deseja realmente remover este grupo?',
        'GROUP_INVITATIONS' => 'Convites do grupo',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Você foi convidado a participar de:',
        'VISIT' => 'Visitar',
        'WHO_CAN_JOIN_GROUP' => 'Quem pode participar deste grupo?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'Sua escolha de privacidade não poderá ser alterada depois que o grupo for criado.',
        'ONLY_INVITED_PEOPLE' => 'Apenas convidados',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Permitir que pessoas solicitem um convite',
        'ANYONE_CAN_JOIN_GROUP' => 'Qualquer um pode participar deste grupo',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Apenas convidados podem participar deste grupo',
        'WHY_NOT_CREATE_GROUP' => 'Que tal <a %s>criar seu próprio grupo</a>?',
        'PLEASE_ENTER_NAME' => 'Digite seu nome',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Seu endereço de e-mail',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Digite um novo endereço de página.',
        'PLEASE_ENTER_PASSWORD' => 'Digite sua senha.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Clique aqui para criar uma conta</a> ou tente fazer novamente o acesso abaixo.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Clique aqui para criar uma conta</a> ou tente associar-se com sua Ning ID abaixo.',
        'CHOOSE_SHORTER_PASSWORD' => 'Escolha uma senha mais curta.',
        'CHOOSE_SHORTER_NAME' => 'Escolha um nome mais curto.',
        'ENTER_SHORTER_CITY_NAME' => 'Digite um nome de cidade mais curto.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Digite sua senha novamente no campo "Confirmar senha".',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Digite sua senha atual.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Digite sua nova senha.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Digite sua nova senha novamente no campo "Confirmar senha".',
        'CURRENT_PASSWORD' => 'Senha atual',
        'PASSWORDS_DO_NOT_MATCH' => 'As duas senhas não se correspondem.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'A nova senha e a confirmação de senha não se correspondem.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Seu pedido foi enviado ao criador do grupo.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s não é um endereço de e-mail válido',
        'COME_JOIN_ME_ON_GROUP' => 'Junte-se a mim em %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Convide pessoas para %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Convide amigos para %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Convide outras pessoas para entrarem para participar de %s.',
        'GROUPNAME_MEMBERS' => 'Membros de %s',
        'GROUP_CREATOR' => 'Criador(a) do grupo',
        'GROUP_ADMINISTRATOR' => 'Administrador(a) do grupo',
        'DATE_BANNED' => 'Data de banimento',
        'BAN_FROM_GROUP' => 'Banimento do grupo',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Deseja realmente banir do seu grupo o(s) membro(s) selecionado(s)? Este processo pode levar alguns minutos.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Remova também os tópicos e respostas deles no fórum.',
        'GROUP_WEB_ADDRESS' => 'Endereço web do grupo',
        'GROUP' => 'Grupo',
        'BACK_TO_GROUP' => '← Voltar para %s',
        'USER_BANNED_FROM_GROUP' => '%1$s foi banido(a) deste grupo. <a %2$s>Enviar mensagem para %1$s</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s já faz parte deste grupo. <a %2$s>Enviar mensagem para %1$s</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Tópicos dos administradores do grupo',
        'BACK_TO_NETWORK_GROUPS' => 'Voltar para os grupos em %s',
        'MOST_MEMBERS' => 'Mais membros',
        'THIS_SETS_URL_OF_GROUP' => 'Isto define o endereço URL de seu grupo: http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Gostou do que viu em %s? Associe-se agora!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Gostou do que viu em %s? Associe-se agora!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Você criou um grupo chamado %s. Você pode iniciar um tópico no fórum %1$s ou convidar mais pessoas para participar.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Você agora entrou para o grupo %1$s. Você pode participar do fórum %1$s ou convidar mais gente para fazer parte.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Esta rede ainda não possui músicas.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Esta pessoa ainda não possui músicas.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Encontre mais músicas como esta em <em>%s</em>',
        'TRACKS' => 'Trilhas',
        'ADD_MUSIC_TRACKS' => 'Adicionar música',
        'CHOOSE_MUSIC_TRACKS' => 'Escolha músicas para adicionar',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Você pode adicionar até 4 MP3s por vez.',
        'UPLOAD_TRACKS' => 'Carregar músicas',
        'ADD_TRACKS' => 'Adicionar músicas',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Entre com a URL de cada MP3 que você gostaria de adicionar:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Você pode carregar até 100 MP3s! Cada arquivo de MP3 pode ter até 20 MB de tamanho, mas arquivos menores irão carregar mais rapidamente!',
        'BE_NICE' => 'Seja legal',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Carregue apenas músicas que você tenha permissão para tal do artista ou detentor de direitos autorais.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Faça link apenas para músicas que foram autorizadas para distribuição na web.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Outras maneiras de adicionar música...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '...de outro website',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Adicione músicas de qualquer website colando um link para o MP3.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Deixe esta janela aberta para que possamos concluir o carregamento de suas músicas e notificaremos você assim que forem aprovadas!',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Enquanto isso, fique à vontade para <a %s>abrir uma nova janela do navegador</a> e continuar usando %s. Quando o carregamento terminar, você poderá adicionar um título e descrição às suas músicas nesta janela.',
        'TRACKS_EXCEEDED_LIMIT' => 'Aparentemente a(s) trilhas(s) excederam o limite de 10 MB por música.',
        'EDIT_TRACK_INFORMATION' => 'Editar informações sobre a música',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Adicione um título, descrição e outras informações às músicas que acabou de carregar.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Adicione um título, descrição e outras informações a esta música.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Cancelar e voltar à lista de reprodução',
        'TRACK_TITLE' => 'Título',
        'TRACK_ARTIST' => 'Artista',
        'TRACK_ALBUM' => 'Álbum',
        'ENABLE_DOWNLOAD_LINK' => 'Habilitar link para download',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Permitir que pessoas coloquem esta música em suas páginas',
        'TRACK_ARTWORK' => 'Ilustração',
        'EDIT_PLAYLIST' => 'Editar lista de reprodução',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Para reordenar sua lista de reprodução, clique na música e arraste-a para onde quiser reproduzi-la.',
        'ADD_MUSIC_ELLIPSIS' => 'Adicionar música...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '...de seu computador',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Carregue MP3s de seu computador.',
        'DELETE_THIS_TRACK_Q' => 'Excluir esta música?',
        'DELETE_TRACK' => 'Excluir música',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Deseja realmente excluir esta música?',
        'PLAY' => 'executar',
        'GENRE' => 'Gênero',
        'YEAR' => 'Ano',
        'LABEL' => 'Selo',
        'EXPLICIT_LYRICS' => 'Letras explícitas',
        'ARTIST_SITE' => 'Site do artista',
        'HOSTING_SITE' => 'Site de hospedagem',
        'LABEL_SITE' => 'Site do selo',
        'LICENSE' => 'Licença',
        'SELECT_LICENSE' => '— Selecionar licença —',
        'LICENSE_NAME' => 'Nome da licença',
        'LICENSE_URL' => 'URL da licença',
        'MUSIC' => 'Música',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Permitir que as pessoas transfiram e compartilhem áudio',
        'PLAYLIST' => 'Lista de reprodução',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Mais recentes',
        'FEATURED_TRACKS' => 'Destaques',
        'HIGHEST_RATED_TRACKS' => 'Classificação mais alta',
        'NO_TRACKS_TO_PLAY' => 'Não há música em sua rede no momento.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Esta caixa não será visível para outras pessoas até que haja uma música ou podcast para executar. Por que você não adiciona um?',
        'NO_TRACKS_ON_PLAYLIST' => 'Não há músicas nesta lista de reprodução.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Este Player não aparecerá para outras pessoas até que haja música ou podcast para executar. Que tal adicionar uma?',
        'NO_FEATURED_TRACKS' => 'Não há músicas de destaque em sua rede.',
        'START_FEATURING_TRACKS' => 'Comece a apresentar músicas quando ouvir alguma que gostaria que aparecesse na página principal.',
        'VIEW_MUSICPLAYER' => 'Exibir o Music Player',
        'MY_PLAYLIST' => 'Minha lista de reprodução',
        'NETWORK_PLAYLIST' => 'Lista de reprodução da rede',
        'COPYRIGHT' => '© Todos os direitos reservados',
        'CC_BY_X' => 'Atribuição da Creative Commons %s',
        'CC_BY_SA_X' => 'Atribuição-Compartilhamento pela mesma Licença da Creative Commons %s',
        'CC_BY_ND_X' => 'Atribuição-Vedada a Criação de Obras Derivadas Creative Commons %s',
        'CC_BY_NC_X' => 'Atribuição-Uso Não-Comercial da Creative Commons %s',
        'CC_BY_NC_SA_X' => 'Atribuição-Uso Não-Comercial-Compartilhamento pela mesma Licença da Creative Commons %s',
        'CC_BY_NC_ND_X' => 'Atribuição-Uso Não-Comercial-Vedada a Criação de Obras Derivadas da Creative Commons %s',
        'PUBLICDOMAIN' => 'Domínio público',
        'FACEBOOK_CONFIRM_DISABLE' => 'Tem certeza?',
        'FACEBOOK_PLAYER_DISABLE' => 'Desativar',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Music Player',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Permitir que qualquer pessoa adicione um aplicativo em suas páginas de perfil no Facebook que toque sua seleção musical.',
        'FACEBOOK_MUSIC_BUTTON' => 'Criar aplicativo de música &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'O Facebook Music Player já se encontra habilitado.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Video Player',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Permitir que qualquer pessoa adicione um aplicativo em suas páginas de perfil no Facebook que reproduza um vídeo de sua rede.',
        'FACEBOOK_VIDEO_BUTTON' => 'Criar aplicativo de vídeo &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'O Facebook Video Player já se encontra ativo.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Exibição das fotos em slides',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Permitir que qualquer pessoa adicione um aplicativo em suas páginas de perfil no Facebook que exiba as fotos de sua rede em slides.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Criar aplicativo de exibição de fotos em slides &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'A exibição de fotos em slides do Facebook já está habilitada.',
        'FACEBOOK_PLATFORM_LOGO' => 'Logotipo da plataforma Facebook',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook é uma rede social popular na América do Norte e permite que programadores terceirizados criem aplicativos que possam ser adicionados às páginas de perfil de membros do Facebook. Além de fornecer a funcionalidade de adicionar itens ao perfil, estes aplicativos podem ser usados para encaminhar os usuários do Facebook para outros destinos na web.',
        'FACEBOOK_QUICK_INTRO_2' => 'No Ning, você não precisa ser um programador para promover sua rede social no Facebook. Já fizemos a parte mais difícil e sua rede social já vem com a possibilidade de integração com o aplicativo do Facebook. Basta escolher dentre as opções abaixo, e sua rede social estará pronta para se integrar com o Facebook em questão de segundos.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Adicionar botão de programador',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Configurar botão de novo aplicativo',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Seus aplicativos do Facebook',
        'FACEBOOK_EMBEDDING' => 'Promoção do Facebook',
        'FACEBOOK_SETUP' => 'Promoção do Facebook',
        'FACEBOOK_PROMOTING' => 'Promoção de aplicativos no Facebook',
        'FACEBOOK_VIEW_APP' => 'Exibir aplicativos',
        'FACEBOOK_ADD_THE' => 'Adicionar',
        'FACEBOOK_RECENT' => 'Mais recentes',
        'FACEBOOK_RECENTLY_FEATURED' => 'Destaques mais recentes',
        'FACEBOOK_RECENTLY_ADDED' => 'Recém-adicionados(as)',
        'FACEBOOK_PROMOTED' => 'Destaques',
        'FACEBOOK_RATED' => 'Classificação mais alta',
        'FACEBOOK_POPULAR' => 'Popular',
        'FACEBOOK_MUSIC_WIDGET' => 'Componente gráfico de música',
        'FACEBOOK_VIDEO_WIDGET' => 'Componente gráfico de vídeos',
        'FACEBOOK_PHOTO_WIDGET' => 'Componente gráfico de fotos',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Primeiros passos',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Clique aqui para ir ao Facebook e iniciar a criação de seu aplicativo.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Isto abrirá o site do Facebook em uma nova janela. Caso você não esteja logado no Facebook, precisará fazer o acesso agora.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Se você ainda não criou um aplicativo no Facebook, você precisará adicionar o aplicativo "Developer" (programador) do Facebook. Assim que tiver feito isto, você verá uma mensagem: "You have no applications" (você não possui aplicativos). Clique no link <strong>Create one</strong> (criar um).',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Caso já tenha criado um aplicativo no Facebook, você será redirecionado para a página do aplicativo "Developer" (programador) do Facebook. Clique no botão <strong>Set Up New Application</strong> (configurar novo aplicativo).',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'A seguir: Instruções sobre como configurar seu aplicativo %s para funcionar no Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Instruções de configuração',
        'FACEBOOK_INSTR_SETUP_1' => 'Excelente! Vamos aos detalhes agora. É preciso fornecer ao Facebook algumas informações básicas para que seu aplicativo saia do papel. Siga as etapas abaixo.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Campos obrigatórios',
        'FACEBOOK_INSTR_SETUP_2' => 'Escolha um <strong>Application Name </strong> (nome do aplicativo).',
        'FACEBOOK_INSTR_SETUP_3' => 'Marque o campo que indica que você leu os termos de uso do Facebook.',
        'FACEBOOK_INSTR_SETUP_4' => 'Abra a sessão de campos opcionais clicando em <em>Opcional Fields</em>.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Opções de base',
        'FACEBOOK_INSTR_SETUP_5' => 'Digite seu endereço de e-mail no campo <strong>Support E-Mail</strong> (e-mail de suporte).',
        'FACEBOOK_INSTR_SETUP_6' => 'Cole o seguinte endereço no campo <strong>Callback URL</strong> (URL de retorno):',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Escolha uma <strong>Canvas Page URL</strong> (endereço da página com moldura) (ex: <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Selecione a opção <strong>Yes</strong> (sim) para a pergunta <em>Can your application be added on Facebook</em> (seu aplicativo pode ser adicionado ao Facebook?).',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Opções de instalação',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Escreva uma descrição no campo <strong>Application Description</strong> (descrição do aplicativo).',
        'FACEBOOK_INSTR_SETUP_9' => 'Cole o seguinte código no campo <strong>Default FBML</strong>:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Para a opção <strong>Default Profile Box Column</strong> (coluna da caixa de perfil padrão), escolha a alternativa <strong>Wide</strong> (ampla).',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Para a opção <strong>Default Profile Box Column</strong>, escolha a alternativa <strong>Narrow</strong> (estreita).',
        'FACEBOOK_INSTR_SETUP_10' => 'No campo <strong>Side Nav URL</strong>, digite sua <em>Canvas Page URL</em> (criada na etapa &#8216;f&#8217; acima). Certifique-se de incluir a parte http://apps.facebook.com/ da URL.',
        'FACEBOOK_INSTR_SETUP_11' => 'Escreva um texto para a <strong>Attachment action</strong> (ação de anexo). Este aparecerá se você estiver enviando uma mensagem a alguém pelo Facebook e quiser incluir um de seus aplicativos. Se for um aplicativo de exibição de fotos em slides, você pode usar, por exemplo, Fotos de Nome da Rede. Se for um aplicativo de execução de vídeo, você pode usar Vídeos de Nome da Rede.',
        'FACEBOOK_INSTR_SETUP_12' => 'Cole o seguinte endereço no campo <strong>Callback URL</strong> (URL de retorno):',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Página de configuração do aplicativo do Facebook',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Quando tiver tudo pronto, clique no botão <strong>Submit</strong> (enviar).',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'A seguir: Resgate de sua chave API e Segredo.',
        'FACEBOOK_API_INFO_TITLE' => 'Informações sobre a API do Facebook',
        'FACEBOOK_API_INFO_DESC' => 'Para terminar a configuração, você precisará fornecer sua chave API, o Segredo e sua URL do aplicativo nos campos abaixo.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Você pode encontrar a chave API e o Segredo em sua página <a %s>My Applications do Facebook</a> (página de meus aplicativos que se abre em uma nova janela) abaixo do título do aplicativo que você acaba de criar.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Página My Applications (destacando a localização das informações de API)',
        'FACEBOOK_API_INFO_KEY' => 'Chave API',
        'FACEBOOK_API_INFO_SECRET' => 'Segredo da API',
        'FACEBOOK_URL_INFO_TITLE' => 'URL do aplicativo do Facebook',
        'FACEBOOK_URL_INFO_DESC' => 'O URL do aplicativo é o mesmo da <strong>Canvas Page URL</strong> que você definiu na página anterior (na etapa &#8216;f&#8217;).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Os aplicativos de música no Facebook devem tocar:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Os aplicativos de vídeo no Facebook devem tocar o vídeo:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Os aplicativos de exibição de fotos em slides no Facebook devem exibir as fotos de:',
        'FACEBOOK_PROMOTING_ON' => 'Promoção no Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Instruções de configuração',
        'FACEBOOK_API_INFO' => 'Informações da API',
        'FACEBOOK_DISABLE' => 'Desabilitar este aplicativo',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'em seu perfil no Facebook',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Voltar para Promoção no Facebook',
        'FACEBOOK_EMBEDDING_DESC' => 'Permitir que usuários do Facebook adicionem os componentes gráficos e badges de sua rede nas páginas de perfil deles.',
        'FACEBOOK_PROMOTE' => 'Para aumentar o potencial de promoção de seu novo aplicativo, recomendamos os seguintes procedimentos. Estas opções podem ser vistas na página <strong><a %s>My Applications</a></strong> (meus aplicativos) do Facebook (o link se abre em uma nova janela).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Forneça uma página informativa (About Page)',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Deixe que os usuários do Facebook saibam do que se trata seu aplicativo fornecendo uma descrição clara. Para editar esta informação, clique no link <strong>Edit About Page</strong> (editar página informativa) referente ao aplicativo que você está modificando.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Cadastre seu aplicativo no diretório do Facebook',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Divulgue seu novo aplicativo adicionando-o ao diretório do Facebook.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Para enviar seu aplicativo, clique no link <strong>Submit Application</strong> (enviar aplicativo) próximo ao aplicativo que está modificando. Na página seguinte você pode editar a descrição  e adicionar um logotipo para seu aplicativo.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Adicione o aplicativo em seu perfil do Facebook',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Mostre seu aplicativo adicionando-o à página do seu perfil no Facebook e. em seguida, relaxe e assista seus amigos fazendo o mesmo.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Apenas clique no link <strong>View About Page</strong> (exibir página informativa) próximo ao aplicativo que deseja adicionar ao seu perfil e, em seguida, clique no botão Adicionar aplicativo na página seguinte.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Seu aplicativo está agora no final de seu perfil no Facebook!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Página My Applications (meus aplicativos) no Facebook',
        'FACEBOOK_MY_APPS' => 'Meus aplicativos',
        'FORUM_TAB_TEXT' => 'Fórum',
        'VIDEOS_TAB_TEXT' => 'Vídeos',
        'PHOTOS_TAB_TEXT' => 'Fotos',
        'GROUPS_TAB_TEXT' => 'Grupos',
        'I_FOUND_THIS_COOL_TYPE' => 'Acabei de encontrar este %s interessante e acho que você vai gostar. Confira.',
        'POPULATE' => '<strong>Preencha.</strong>',
        'ADD_PHOTOS_LOWER' => 'Adicione fotos',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'O carregamento do vídeo em %s não foi concluído devido a um erro de conversão.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Para ajudar na solução do problema, forneça a identificação deste vídeo: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'O carregamento de seu vídeo para %s foi feito com sucesso.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Para visualizar o vídeo, visite:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Há um novo comentário em seu vídeo "%1$s" em %2$s.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Há um novo comentário em seu vídeo em %s.',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Há um novo comentário em sua foto"%1$s" em %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Há um novo comentário em sua foto em %s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Você tem um(a) novo(a) %1$s para aprovar em %2$s…',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Você tem um(a) novo(a) %1$s para aprovar em %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Você tem um(a) novo(a) %1$s "%2$s" para aprovar em %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Para aprovar este %s, visite:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Seu(sua) %1$s em %2$s foi aprovado(a)…',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Há um novo comentário em seu(sua) %1$s em %2$s…',
        'CLICK_HERE_TO_JOIN' => 'Clique aqui para participar:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s gostaria que você visse "%2$s" em %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Seu(Sua) %s foi aprovado(a) em %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Seu(Sua) %1$s "%2$s" foi aprovado(a) em %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'Para visualizar seu(sua) %s, visite:',
        'TO_VIEW_THIS_X_VISIT' => 'Para visualizar este(a) %s, visite:',
        'TO_VIEW_IT_VISIT' => 'Para visualizar, visite:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s informou o seguinte incidente em %2$s…',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s lhe enviou uma mensagem em %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s solicitou associação a %2$s em %3$s.',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Para aprovar ou recusar o pedido de %s, visite:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s adicionou um comentário em sua mensagem do blog "%2$s" em %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s adicionou um comentário em sua mensagem do blog em %2$s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Você tem um novo membro para aprovar em %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Bem-vindo ao grupo "%1$s" em %2$s',
        'LOADING_YOUR_FRIENDS' => 'Estamos carregando seus amigos…',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Sua mensagem foi enviada',
        'TO_SEND_ANOTHER_MESSAGE' => 'Para enviar outra mensagem, digite seu texto abaixo',
        'PLEASE_CHOOSE_FRIENDS' => 'Selecione alguns amigos antes de enviar sua mensagem.',
        'THESE_FRIENDS' => 'Estes amigos:',
        'ALL_FRIENDS' => 'Todos os amigos',
        'ALL_FRIENDS_ON_APPNAME' => 'Todos os amigos em %s',
        'SHARE_WITH_FRIENDS' => 'Compartilhar com amigos',
        'SHARE_THIS_WITH_FRIENDS' => 'Compartilhe este item com seus amigos',
        'COMPOSE_MESSAGE' => 'Criar mensagem',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Este link de convite é visível apenas para o Criador da Rede e Administradores. Quem quiser se associar usando este link será automaticamente amigo do Criador da Rede.',
        'WE_ARE_LOADING_ADDRESSES' => 'Estamos carregando seus endereços…',
        'SELECT_ALL_NONE' => 'Selecionar Todos/Nenhum',
        'INVITE_TO_APPNAME' => 'Convidar para \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Convide seus amigos para \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Já é membro desta rede)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Ou compartilhar este link de convite:',
        'CLICK_TO_MAIL' => '<a %s>Clique aqui para enviar um e-mail agora</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Sua mensagem foi enviada',
        'YOU_CAN_SHARE_THIS' => 'Você pode compartilhar com mais pessoas abaixo, ou <a %s>retornar à página anterior</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Desculpe, o serviço de importação vCard não está disponível no momento.',
        'CSV_IMPORT_UNAVAILABLE' => 'Desculpe, o serviço de importação CSV não está disponível no momento.',
        'ERROR_OCCURRED' => 'Desculpe, ocorreu um erro.',
        'IMPORT_FAILED' => 'Desculpe, não foi possível importar.',
        'LOGIN_FAILED' => 'Desculpe, a operação de login não foi concluída.',
        'UNABLE_TO_FIND_EMAIL' => 'Desculpe, não foi possível encontrar o campo de e-mail.',
        'CANNOT_READ_VCARDS' => 'Desculpe, não é possível ler estes vCards.',
        'NO_ADDRESSES_FOUND' => 'Nenhum endereço encontrado',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Não foi possível encontrar endereços no catálogo de endereços importado.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Importar do Catálogo de Endereços da Web',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Importar do aplicativo Catálogo de Endereços',
        'PRIVACY_POLICY' => 'Política de privacidade',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => 'O comentário a seguir foi enviado por %1$s em %2$s:',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Veja "%1$s" em %2$s…',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Veja este(a) %1$s em %2$s…',
        'SEND_MESSAGE_TO_FRIENDS' => 'Enviar mensagens aos Amigos',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Escolha uma alternativa válida para notificações de mensagens enviadas a todos os amigos',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Bem-vindo(a), %1$s! Você é membro #%2$s de %3$s. <a %4$s>Convide amigos agora</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Você fez um comentário sobre a foto <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s fez um comentário sobre a foto <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Você fez um comentário sobre o vídeo <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s fez um comentário sobre o vídeo <a %s>%s</a>',
        'THIS_IS_YOUR_PAGE' => 'Esta é sua página:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Mensagens enviadas para todos os amigos',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Para não mais acompanhar este(a) %s, vá para:',
        'CHOOSE_GADGETS' => 'Escolha um destes excelentes gadgets OpenSocial para adicionar à página de seu perfil! Você pode <a %s>ver e classificar gadgets</a> ou <a %s>saber mais sobre OpenSocial aqui</a>.',
        'GADGETS_UNAVAILABLE' => 'Os gadgets não estão disponíveis no momento.',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Desculpe, os gadgets não estão disponíveis no momento',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Esta caixa não aparecerá para outras pessoas a não ser que você selecione um gadget.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Clique em Editar para especificar a URL do gadget para esta caixa ou visite o <a %s>Diretório de Gadgets</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Ocorreu um problema durante a restauração deste RSS feed.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Adicionar este gadget a seu perfil',
        'GADGETS_BETA' => 'Gadgets (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Experimente nossos Gadgets OpenSocial.  Aviso: este recurso é experimental.',
        'ADD_TO_MY_PAGE' => 'Adicionar à Minha Página',
        'GADGETS' => 'Gadgets',
        'GADGETS_TAB_TEXT' => 'Gadgets',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Os gadgets estão em fase beta.',
        'SORRY_GADGET_UNAVAILABLE' => 'Desculpe, mas este gadget está indisponível. Verifique se usou a URL correta. Se ainda tiver problemas, <a %s>queira nos informar</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Já é membro deste grupo)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Convide seus amigos para \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Venha participar de %1$s em %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Venha participar de %1$s em %2$s…',
        'INVITE_TO_GROUP' => 'Convidar para \'%s\'',
        'EACH_VIDEO_MAY_BE_100MB' => 'Cada vídeo deve ter o tamanho máximo de 100MB. Suportamos vídeos nos formatos .mov, .mp4, .mpg, .avi, .wmv e .3gp. ',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Eu tenho o direito de carregar este vídeo conforme os <a Termos de Serviço</a>. ',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'O carregador de múltiplos vídeos requer uma versão recente de Java. <strong><a %s>Clique aqui para obter o Java</a></strong> ou <strong><a %s>retorne ao carregador simples</a></strong>. ',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Carregar um vídeo de seu computador ',
        'HAVE_LOT_OF_VIDEOS' => 'Você tem muitos vídeos que deseja compartilhar? ',
        'TRY_BULK_VIDEO_UPLOADER' => 'Tente o carregador para múltiplos vídeos ',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Seus vídeos foram carregados com sucesso. ',
        'VIDEOS_UPLOADED_AWAITING' => 'Seus vídeos foram carregados com sucesso e estão aguardando aprovação do criador %s. ',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Adicione fotos ou vídeos %s diretamente de seu telefone enviando-os para um endereço de e-mail único. ',
        'GRAB_HTML_EMBED' => 'Pegue o código HTML \'embutido\' de qualquer site de vídeos popular para adicioná-lo a esta rede social. ',
        'GOOGLE' => 'Google ',
        'YOUTUBE' => 'YouTube ',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Está encontrando problemas com o carregador de múltiplos vídeos? <strong><a %s>Retorne ao carregador simples</a></strong>. ',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Adicionar vídeos do YouTube ou Google ',
        'TAGS_NO_COLON' => 'Tags ',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Não existem fotos com a tag "%1$s". Confira <a %2$s>tópicos com a tag "%1$s"</a>, <a %4$s>mensagens de blog com a tag "%1$s"</a> ou <a %3$s>vídeos com a tag  "%1$s"</a>. Ou adicione tags aos seus próprios vídeos! ',
        'UPLOAD_VIDEOS_FROM' => 'Carregar vídeos de seu computador ',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Adicione vídeos pelo telefone ou e-mail ',
        //music player
        'FEATURING_ELLIPSIS' => 'Caracterizando...',
        'OPEN_POPUP_WINDOW' => 'Abra janela pop-up',
        'NOW_FEATURED_ON_MAIN' => 'Apresentado agora na página principal ',
        'DONT_FEATURE' => 'Não apresentar ',
        'UNFEATURING_ELLIPSIS' => 'Removendo da página principal... ',
        'REMOVED_FROM_MAIN' => 'Removido da página principal ',
        'ADDED_EXCLAMATION' => 'Adicionado! ',
        'ERROR' => 'Erro ',
        'ADDING_ELLIPSIS' => 'Adicionando... ',
        'TRACK_COULD_NOT_BE_LOADED' => 'A música não pôde ser adicionada ',
        'INVALID_URL' => 'URL inválido ',
        'NORMAL_PLAYBACK_ON' => 'Playback normal: On ',
        'REPEAT_PLAYBACK_ON' => 'Repetir Playback: On ',
        'SHUFFLE_PLAYBACK_ON' => 'Playback aleatório: On ',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Carregando lista de reprodução ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Seus dados de membros foram exportados. Clique  <a %s>neste link</a> para salvá-los em sua área de trabalho. ',
        'SET_NEW_PASSWORD' => 'Escolha uma nova senha para sua conta. ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Clique em "Editar" para adicionar texto, HTML, vídeo, fotos, ou qualquer outro <a %1$s>componente gráfico de terceiros</a> a esta caixa. ',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Cada foto deve ter tamanho máximo de 10MB. Suportamos fotos nos formatos .jpg, .gif e .png. ',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Eu tenho o direito de carregar estas fotos conforme os <a Termos de Serviço</a>. ',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'O carregador de múltiplas fotos requer uma versão recente de Java. <strong><a %s>Clique aqui para obter o Java</a></strong> ou <strong><a %s>retorne ao carregador simples</a></strong>. ',
        'TRY_BULK_PHOTO_UPLOADER' => 'Tentar o carregador de múltiplas fotos ',
        'HAVE_LOT_OF_PHOTOS' => 'Você tem muitas fotos que deseja compartilhar? ',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Suas fotos foram carregadas com sucesso. ',
        'PHOTOS_UPLOADED_AWAITING' => 'Suas fotos foram carregadas com sucesso e estão aguardando aprovação do criador %s. ',
        'FLICKR' => 'Flickr ',
        'ADD_PHOTOS_FROM_FLICKR' => 'Adicionar fotos do Flickr ',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Adicione fotos a %s diretamente de seu telefone enviando-os para um endereço de e-mail. ',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Está encontrando problemas com o carregador de múltiplas fotos? <strong><a %s>Retorne ao carregador simples</a></strong>. ',
        'VIEW_SLIDESHOW' => 'Exibir slides ',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Não existem fotos com a tag "%1$s". Confira <a %2$s>tópicos com a tag "%1$s"</a>, <a %4$s>mensagens de blog com a tag "%1$s"</a> ou <a %3$s>vídeos com a tag  "%1$s"</a>. Ou adicione tags a suas próprias fotos! ',
        'PHOTO_MAY_BE_10MB' => 'Cada vídeo deve ter o tamanho máximo de 10M, porém fotos menores carregam mais rápido. Suportamos fotos nos formatos ..jpg, .gif and .png. ',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Carregar fotos de seu computador ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Clique em "Editar" para adicionar texto, HTML, vídeo, fotos, ou qualquer outro <a %1$s>componente gráfico de terceiros</a> a esta caixa. ',
        'PLEASE_SELECT_A_MEMBER' => 'Selecione um ou mais associados ',
        'RESEND_INVITATION' => 'Enviar novamente um convite ',
        'CHOOSE_FRIENDS' => 'Escolher amigos… ',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Não aceitamos o caderno de endereços da web para seu endereço de e-mail. Tente clicar em \'Aplicativo de Contatos\' abaixo para usar os endereços de seu computador. ',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Deseja convidar mais amigos? Convite mais amigos importando contatos de seu catálogo de endereços da web ou aplicativo de e-mail. ',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Mail, .CSV, etc. ',
        'SET_NEW_PASSWORD' => 'Escolha uma nova senha para sua conta. ',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => 'Associe-se agora. Já é um membro? <a %s>Clique aqui para acessar</a>. ',
        'FEATURED_MEMBERS' => 'Membros apresentados ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Seus dados de membros foram exportados. Clique  <a %s>neste link</a> para salvá-los em sua área de trabalho. ',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Desculpe, não foram encontrados membros que correspondam a "%s". ',
        'WHO_CAN_COMMENT_ON_POST' => 'Quem pode comentar sobre esta mensagem? ',
        'PREVIOUS_POST' => '←  Mensagem anterior ',
        'NEXT_POST' => 'Próxima mensagem  →',
        'PREVIOUS_POSTS' => '←  Mensagens anteriores ',
        'NEXT_POSTS' => 'Próximas mensagens  →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Não existe nenhuma mensagem de blog com a tag "%1$s". Confira <a %2$s>tópicos com a tag "%1$s"</a>, <a %4$s>fotos com a tag "%1$s"</a> ou <a %3$s>vídeos com a tag "%1$s"</a>. Ou adicione tags em suas mensagens de blog! ',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Todas as mensagens com a tag <em>\'%s\'</em> para %s %s ',
        'ALL_POSTS_TAGGED_X' => 'Todas as mensagens com a tag <em>\'%s\'</em> ',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Minhas mensagens de blog para %s %s ',
        'MY_BLOG_POSTS' => 'Minhas mensagens de blog ',
        'PRIVACY_CONTENT_CONTROL' => 'Privacidade e Controle de Conteúdo ',
        'MODERATION' => 'Controle de Conteúdo ',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Habilitar links para download do Music Player ',
        'NOTIFY_BLOG_PING_SERVICES' => 'Você deseja notificar serviços externos de rastreio de blogs quando adicionar uma nova mensagem? ',
        'YES_NOTIFY_BLOG_SERVICES' => 'Sim – Notifique <a %s>os serviços de atualização do site</a> quando eu adicionar uma nova mensagem ',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Não há Membros apresentados em sua rede social. ',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Comece a apresentar membros quando vir a opção Apresentar. Para saber mais sobre o processo, <a %s>clique aqui</a>. ',
        'SHOW_ALL' => 'Exibir todos ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Não há nenhum tópico com a tag "%1$s". Confira <a %2$s>fotos com a tag "%1$s"</a>, <a %4$s>mensagens de blog com a tag "%1$s"</a> ou <a %3$s>vídeos com a tag "%1$s"</a>. Ou adicione seus próprios tópicos e tags. ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Não há nenhum tópico com a tag "%1$s". Confira <a %2$s>fotos com a tag "%1$s"</a>, <a %4$s>mensagens de blog com a tag "%1$s"</a> ou <a %3$s>vídeos com a tag"%1$s"</a>. ',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Você criou o grupo %1$s. Você pode iniciar um tópico no fórum %1$s ou convidar mais pessoas para participar. ',
        'YOU_CAN_ADD_100_SONGS' => 'Você pode adicionar um total de 100 músicas; cada uma deve ter o tamanho máximo de 20MB. Suportamos músicas no formato .mp3. ',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Eu tenho o direito de carregar estas músicas conforme os <a Termos de Serviço</a>. ',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'O carregador de múltiplas músicas requer uma versão recente de Java. <strong><a %s>Clique aqui para obter o Java</a></strong>, ou <strong><a %s>retorne ao carregador simples</a></strong>. ',
        'HAVE_LOT_OF_MUSIC' => 'Você tem muitas músicas que deseja compartilhar? ',
        'TRY_BULK_MUSIC_UPLOADER' => 'Tente o carregador para múltiplas músicas ',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Suas músicas foram carregadas com sucesso ',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Desculpe, você pode ter apenas %s músicas em sua lista de reproduções. Remova algumas músicas existentes antes de adicionar mais. ',
        'ADD_MUSIC_FROM_WEBSITE' => 'Adicionar músicas de outro website ',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Está encontrando problemas com o carregador de múltiplas músicas? <strong><a %s>Retorne ao carregador simples</a></strong>. ',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Carregar música de seu computador ',
        'ADD_MUSIC' => 'Adicionar música ',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => '‘Selecione <strong>Usuários/strong> e <strong>Todas as páginas/strong>. ',



    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}