<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the Italian locale.
 */
class XG_MessageCatalog_it_IT extends XG_AbstractMessageCatalog {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = '1 secondo fa ';
            $a['N_SECONDS_AGO']['n'] = '%s secondi fa ';
            $a['N_MINUTES_AGO']['1'] = '1 minuto fa ';
            $a['N_MINUTES_AGO']['n'] = '%s minuti fa ';
            $a['N_HOURS_AGO']['1'] = '1 ora fa ';
            $a['N_HOURS_AGO']['n'] = '%s ore fa ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> Video ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> Video ';
            $a['N_VIEWS']['1'] = '1 vista ';
            $a['N_VIEWS']['n'] = '%s viste ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> Commento ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> Commenti ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Questo video è un <strong>preferito</strong> di <strong>1 persona</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Questo video è un <strong>preferito</strong> di<strong>%s persone</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s ha aggiunto un video: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s ha aggiunto %s video. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Hai aggiunto un video: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Hai aggiunto %s video. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'C\'è 1 video su %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Ci sono %1$s video su %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'C\'è 1 <a href="%3$s">video</a> su %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Ci sono %1$s <a href="%3$s">video</a> su %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 fotografia è stata eliminata da questo album o resa privata, quindi non può essere visualizzata. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s fotografie sono state eliminate da questo album o rese private, quindi non possono essere visualizzate. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> Fotografia ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> Fotografie ';
            $a['N_PHOTOS_2']['1'] = '1 fotografia ';
            $a['N_PHOTOS_2']['n'] = '%s fotografie ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'e 1 altra persona ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'e altre %s persone ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Si è verificato un problema nel caricamento del seguente file: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Si è verificato un problema nel caricamento dei seguenti file: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Questa fotografia è <strong>preferita </strong> da <strong>1 persona</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Questa fotografia è <strong>preferita</strong> da <strong>%s persone</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Valutazione:</strong> %2$s dopo 1 voto ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Valutazione:</strong> %2$s dopo %s voti ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s dopo 1 voto ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s dopo %s voti ';
            $a['N_PEOPLE']['1'] = '1 persona ';
            $a['N_PEOPLE']['n'] = '%s persone ';
            $a['N_OF_5_STARS']['1'] = '1/5 stella ';
            $a['N_OF_5_STARS']['n'] = '%s/5 stelle ';
            $a['YOUR_RATING_X_STARS']['1'] = 'La tua valutazione: 1 stella ';
            $a['YOUR_RATING_X_STARS']['n'] = 'La tua valutazione: %s stelle ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s ha aggiunto una fotografia: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s ha aggiunto %s fotografie. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Hai aggiunto una fotografia: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Hai aggiunto %s fotografie. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'C\'è 1 fotografia su %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Ci sono %1$s fotografie su %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'C\'è %1$s <a href="%3$s">fotografia</a> su %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Ci sono %1$s <a href="%3$s">fotografie</a> su %2$s ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Commento sulla tua pagina ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Comments on your page';;
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> Commento Blog ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> Commenti Blog ';
            $a['N_YEARS_OLD']['1'] = '1 anno ';
            $a['N_YEARS_OLD']['n'] = '%s anni ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Hai 1 richiesta amico! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Hai %s richieste amici! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Spazio commenti (1 commento) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Spazio commenti (%s commenti) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 nuovo membro si è aggiunto durante la settimana scorsa ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s nuovi membri si sono aggiunti durante la settimana scorsa ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">nuovo membro</a> si è aggiunto durante la settimana scorsa ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">nuovi membri </a> si sono aggiunti durante la settimana scorsa ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'C\'è 1 membro su %2$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Ci sono %1$s membri su %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'C\'è 1 <a href="%3$s">membro</a> su %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Ci sono %1$s <a href="%3$s">membri</a> su %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'C\'è 1 blog su %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Ci sono %1$s blog su %2$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> Nuovo membro ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> Nuovi membri ';
            $a['N_REPLIES']['1'] = '1 Risposta ';
            $a['N_REPLIES']['n'] = '%s Risposte ';
            $a['N_MINUTES']['1'] = '1 minuto rimanente per modificare il tuo commento. ';
            $a['N_MINUTES']['n'] = '%s minuti rimanenti per modificare il tuo commento. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'C\'è 1 argomento del forum su %2$s ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Ci sono %1$s argomenti del forum su %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'C\'è 1 <a href="%3$s">argomento del forum </a> su %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Ci sono %1$s <a href="%3$s">argomenti del forum </a> su %2$s ';
            $a['N_INVITES']['1'] = '%s invito ';
            $a['N_INVITES']['n'] = '%s inviti ';
            $a['N_MEMBERS']['1'] = '1 membro ';
            $a['N_MEMBERS']['n'] = '%s membri ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 membro) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s membri) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'C\'è 1 gruppo su %2$s ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Ci sono %1$s gruppi su %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'C\'è %1$s <a href="%3$s">gruppo</a> su %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Ci sono %1$s <a href="%3$s">gruppi</a> su %2$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 canzone da questa playlist non può essere  visualizzata perché è stata eliminata o non è più condivisa. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s canzoni da questa playlist non possono essere non visualizzate perché sono state eliminate o non sono più condivise. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Una nuova canzone è stata aggiunta a %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s nuove canzoni sono state aggiunte a %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s ha aggiunto una canzone: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s ha aggiunto %s canzoni. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Hai aggiunto una canzone: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Hai aggiunto %s canzoni. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 canzone aggiunta a questa playlist. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s canzoni aggiunte a questa playlist. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'C\'è 1 canzone su %2$s ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Ci sono %1$s canzoni su %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = '1 invito è stato mandato nuovamente. ';
            $a['N_INVITATIONS_RESENT']['n'] = '%s inviti sono stati mandati nuovamente. ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Commento profilo ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Commenti profilo ';
            }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Scorrimento',
        'MORE_VIDEOS' => 'Altri video',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Non ci sono ancora video disponibili su questo network.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Non ci sono ancora video selezionati in questo network.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Al momento questa persona non ha nessun  video.',
        'COPY_TO_CLIPBOARD' => 'Copia negli Appunti',
        'COPIED_TO_CLIPBOARD' => 'Copiato negli Appunti!',
        'NO_VIDEOS_TO_DISPLAY' => 'In questo momento non stai visualizzando nessun video.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Questo riquadro non sarà  visibile ad altre persone se non selezioni al meno un video.',
        'WATERMARK_LOGO' => 'Filigrana',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Puoi scegliere una intestazione o una filigrana per il tuo lettore video.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Questo logo appare nella parte superiore del tuo %s.  Se non aggiungi un logo, verrà visualizzato il nome del network.  Il tuo logo dovrebbe essere in formato: jpg, . gif o . png.  I loghi di altezza superiore a 20 pixel saranno ridimensionati per essere adattati.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'La filigrana appare sopra l\'angolo in fondo a destra del video clip.',
        'HEADER_LOGO' => 'Intestazione logo',
        'WATERMARK' => 'Filigrana',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Personalizza il tuo Lettore Video!',
        'VIDEO_PLAYER' => 'Lettore Video',
        'HEADER' => 'Intestazione',
        'SAVE_CHANGES' => 'Salva modifiche',
        'THUMBNAIL' => 'Anteprima',
        'CONVERSION_FAILED' => 'Conversione non riuscita',
        'CONVERSION_IN_PROGRESS' => 'Conversione in corso',
        'MAP' => 'Mapping',
        'WHAT_IS_THIS' => 'Cos\'è questo?',
        'EDIT_VIDEO_INFORMATION' => 'Modifica informazioni video',
        'ALL_VIDEOS' => 'Tutti i video',
        'VIDEOS_HOME' => 'Video Home',
        'MY_VIDEOS' => 'Video',
        'MY_FRIENDS_VIDEOS' => 'I video dei miei amici',
        'MY_FAVORITES' => 'I miei Preferiti',
        'XS_FAVORITES' => 'I Preferiti di %s',
        'ADD_A_VIDEO' => 'Aggiungi un Video',
        'JUST_NOW' => 'in questo momento',
        '1_DAY_AGO' => '1 giorno fa',
        'M_J' => 'j M',
        'ME' => 'Io',
        'X_SAID' => '%s ha detto...',
        'DELETE_COMMENT' => 'Elimina commento',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Non hai ancora aggiunto nessun video!',
        'ADD_VIDEOS_AND_SHARE' => 'Aggiungi video e condividili con i tuoi amici, la tua famiglia o il resto del mondo!',
        'THERE_ARE_NO_VIDEOS' => 'In questo momento non ci sono video nel tuo social network.',
        'THIS_BOX_WILL_NOT_SHOW' => 'Questo riquadro non sarà visibile ad altre persone finché non ci saranno video da mostrare.  Perché non ne aggiungi uno?',
        'ADD_VIDEOS' => 'Aggiungi video',
        'VIEW_VIDEOS' => 'Visualizza video',
        'YIKES' => 'Yikes!',
        'A_PROBLEM_SEEMS' => 'Si è verificato un problema.',
        'FOR_FURTHER_ASSISTANCE' => 'Per richiedere ulteriore assistenza, <a %s>contattaci</a>.',
        'OR_YOU_CAN_GO' => 'Oppure torna alla <a %s>%s pagina principale</a> o sfoglia <a %s>altri social network Ning</a>',
        'TAGS' => 'Tag:',
        'POPULAR_TAGS' => 'Tag popolari',
        'MY_FRIENDS' => 'I miei amici',
        'VIEW_ALL_MY_FRIENDS' => 'Visualizza tutti i miei amici',
        'VIEW_ALL_XS_FRIENDS' => 'Visualizza tutti gli amici di %s',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Spiacenti, non siamo riusciti a trovare nessuno che corrispondesse alla tua ricerca.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Visualizza i collaboratori più popolari',
        'POPULAR_CONTRIBUTORS' => 'Collaboratori più popolari',
        'VIEW_MORE_CONTRIBUTORS' => 'Visualizza altri collaboratori',
        'ADD_AS_FRIEND' => 'Aggiungi come amico',
        'SEND_A_MESSAGE' => 'Invia un messaggio',
        'IS_YOUR_FRIEND' => 'È tuo amico',
        'IS_BLOCKED' => 'È bloccato',
        'SORT_BY' => 'Ordina per:',
        'CLOSE' => 'Chiudi',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Nessuno ha ancora aggiunto dei video!  Aggiungi qualche video per iniziare.',
        'SEARCH_PEOPLE' => 'Cerca persone:',
        'INVITE_YOUR_FRIENDS_TO' => 'Invita i tuoi amici a %s.',
        'INVITE' => 'Invita',
        'INVITE_TAB_TEXT' => 'Invita',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Non hai ancora aggiunto nessun amico su %s.',
        'SEARCH_FRIENDS' => 'Cerca amici:',
        'ADD_YOUR_FIRST_VIDEO' => 'Aggiungi il tuo primo video',
        'USE_HTML_EMBED_CODE' => 'Utilizza il codice incorporato HTML',
        'UPLOAD_A_VIDEO_FROM' => 'Carica un video dal tuo computer.  Accettiamo tutti i formati più diffusi!',
        'WE_SUPPORT_MOV' => 'Noi supportiamo i formati file: mov, . mpg, . mp4, . avi, . 3gp e. wmv.  I file devono essere di 100MB o più piccoli.',
        'NEED_HELP_HERE_ARE' => 'Hai bisogno di aiuto?  Ecco qui le istruzioni per <a %s>YouTube</a> e <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Aggiungi un titolo e una descrizione',
        'DESCRIPTION_COLON' => 'Descrizione',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Aggiungi un titolo, la descrizione e ulteriori informazioni al video che hai appena caricato.',
        'EVERYTHING_IS_OPTIONAL' => 'Tutto e facoltativo;  Se non vuoi aggiungere niente, clicca su “Salta questo passo” a destra.',
        'SKIP_THIS_STEP' => 'Salta questo passaggio',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Aggiungi un titolo, la descrizione e ulteriori informazioni a questo video.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Annulla e ritorna al video',
        'TITLE' => 'Titolo:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'I Tag sono descrizioni corte che ti consentono di trovare i tuoi video.  Separa i tag con la virgola oppure metti i tag formati da parole multipli fra virgolette tali come "San Francisco".',
        'WHO_CAN_VIEW_VIDEO' => 'Chi può visualizzare questo video?',
        'MOST_POPULAR' => 'Più popolare',
        'HIGHEST_RATED' => 'Più votato',
        'MOST_RECENT' => 'Più recente',
        'MOST_FAVORITED' => 'Più preferito',
        'MOST_POPULAR_VIDEOS' => 'Video più popolari',
        'HIGHEST_RATED_VIDEOS' => 'Video più votati',
        'MOST_RECENT_VIDEOS' => 'Video più recenti',
        'MOST_FAVORITED_VIDEOS' => 'Video più preferiti',
        'ANYONE' => 'Chiunque',
        'JUST_MY_FRIENDS' => 'Solo i miei amici',
        'JUST_ME' => 'Solo io',
        'VIEWABLE_BY_FRIENDS' => 'Visualizzabile da <strong>amici</strong>',
        'PRIVATE_VIDEO' => 'Video <strong>privato</strong>',
        'VIEWABLE_BY_EVERYONE' => 'Visualizzabile da <strong>tutti</strong>',
        'LOCATION' => 'Posizione:',
        'NO_LOCATION' => 'Nessuna posizione',
        'CLICK_ON_LOCATION' => 'Clicca su una posizione sul mapping:',
        'FIND_AN_ADDRESS' => 'Trova indirizzo:',
        'LOCATE' => 'Individua',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Puoi <a %s>aggiungere i tuoi video</a> a %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Aggiungi un logo o un\'immagine filigrana al lettore video del tuo network.  <a %s>Impostalo adesso! </a>',
        'APPROVE' => 'Approvare',
        'DELETE' => 'Elimina',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Applica a tutti i video aggiunti da %s',
        'NO_TITLE' => 'Nessun titolo',
        'ADDED_BY_STRONG_X' => 'Aggiunto da <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Nessuna descrizione',
        'BY_X' => 'da %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'La tua moderazione è conclusa',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'In questo momento non ci sono video in corso d\'approvazione.  Se stai cercando qualcosa da fare, perché non guardi i <a %s>video più recenti</a>?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Nessuno ha aggiunto video al tuo social network.  Sii il primo ad aggiungere un video!',
        'ADDED_ON_DATE_BY_X' => 'Aggiunto %s da %s.',
        'REMOVE_FROM_FAVORITES' => 'Rimuovi da Preferiti',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Rimuovere questo video dai preferiti?',
        'COLLECTED_BY_X' => 'Raccolto da %s',
        'ADD_FAVORITES' => 'Aggiungi a Preferiti',
        'YOU_CAN_MARK_VIDEO' => 'Puoi inserire qualsiasi video preferito tra i preferiti. Clicca sull\'icona "Aggiungi ai Preferiti" quando la vedi su un video.',
        'VIEW_RECENT_VIDEOS' => 'Visualizza video recenti',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s non ha ancora aggiunto nessun preferito.',
        'APPROVE_VIDEOS' => 'Approva video',
        'YOUR_SITE_REQUIRES_YOU' => 'Hai richiesto di moderare le fotografie e i video nel tuo social network prima che siano pubblicati. Per modificare questa impostazione, <a %s>clicca qui per andare alla pagina della privacy</a> e disattivare "Approva nuove fotografie e video".',
        'YOUR_SITE_ALLOWS_USERS' => 'Hai richiesto di non moderare le fotografie e i video nel tuo social network prima che siano pubblicati.  Per modificare questa impostazione, <a %s>fai clic qui per andare alla pagina della privacy</a> e attivare\'Approva nuove fotografie e video\'.',
        'APPROVE_ALL_VIDEOS' => 'Approvare tutti i video?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Sei sicuro di voler approvare tutti i video?  Questo potrebbe impiegare qualche minuto.',
        'APPROVING' => 'Approvazione...',
        'APPROVE_ALL' => 'Approva tutti',
        'DELETE_ALL_VIDEOS' => 'Eliminare tutti i Video?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Sei sicuro di voler eliminare tutti i video non approvati?  Questo potrebbe impiegare qualche minuto.',
        'DELETING' => 'Eliminazione...',
        'DELETE_ALL' => 'Elimina tutti',
        'XS_VIDEOS' => 'Video di %s',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Eliminare tutti i video di %s?',
        'DELETE_ALL_XS_VIDEOS' => 'Elimina tutti i video di %s',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Sei sicuro di voler eliminare tutti i video di %s?  Questo processo potrebbe impiegare qualche minuto.',
        'DELETE_THIS_VIDEO_Q' => 'Eliminare questo video?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Sei sicuro di voler eliminare questo video?  Questo processo potrebbe impiegare qualche minuto.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Non hai ancora aggiunto nessun video.  Aggiungi qualche video per iniziare!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s non ha ancora aggiunto nessun video.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'I tuoi amici non hanno ancora nessun video.',
        'ALL_VIDEOS_TAGGED_X' => 'Tutti i video contrassegnati \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Tutti i video contrassegnati \'<em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'Non c\'è nessun video contrassegnato"%1$s".  Guarda <a %2$s>discussioni contrassegnate "%1$s"</a> o <a %3$s>fotografie contrassegnate "%1$s"</a>.  O aggiungi e contrassegna i tuoi video!',
        'FILES_MUST_BE_100MB' => 'I file devono essere di 100MB o più piccoli.  Noi supportiamo i formati file: mov, . mpg, . avi, . 3gp e. wmv.',
        'NEED_HELP' => 'Hai bisogno di aiuto?',
        'HERE_ARE_INSTRUCTIONS' => 'Ecco qui le istruzioni per <a %s>YouTube</a> e <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'La persona preposta %s desidera vedere la tua opera prima di mostrarla al mondo.',
        'LEAVE_WINDOW_OPEN' => 'Mantieni questa finestra aperta durante il processo di caricamento.',
        'KEEP_PAGE_OPEN' => 'Tieni questa pagina aperta per concludere la fase di caricamento del tuo video e ti faremo sapere quando sarà  approvato!',
        'MEANWHILE_FEEL_FREE' => 'Nel frattempo, puoi <a %s>aprire una nuova finestra del browser</a> e continuare ad usare %s.  Quando il caricamento sarà stato completato potrai aggiungere un titolo e una descrizione al tuo video in questa finestra.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Questo video è <strong>in corso d\'approvazione</strong> da parte dell\'autore di %s.',
        'LOADING' => 'Caricamento...',
        'EDIT_VIDEO' => 'Modifica video',
        'DELETE_VIDEO' => 'Elimina video',
        'YOU_NEED_TO_BE_MEMBER' => 'Devi essere un membro di %s per aggiungere commenti!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Partecipa in questo network</a>',
        'ADD_A_COMMENT' => 'Aggiungi un Commento',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Lascia un commento per %s',
        'MORE' => 'Altro',
        'PREVIOUS' => 'Precedente',
        'NEXT' => 'Successivo',
        'ABOUT_THIS_VIDEO' => 'Informazioni su questo video',
        'ABOUT_YOUR_VIDEO' => 'Informazioni su questo video',
        'ADDED_ON_DATE_BY' => 'Aggiunto <strong>%s</strong> da',
        'VIEWS' => 'Viste',
        'COMMENTS' => 'Commenti',
        'COMMENTS_COLON' => 'Commenti:',
        'LOCATION_OF_VIDEO' => 'Posizione di questo video:',
        'RELATED_VIDEOS' => 'Video collegati',
        'ALL_VIDEOS_TAGGED_X_X' => 'Tutti i video contrassegnati %s (%s)',
        'XS_VIDEOS_X' => 'Video di %s (%s)',
        'XS_FAVORITES_X' => 'Preferiti di %s (%s)',
        'VIDEO_DETAILS' => 'Dettagli video',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Non sono stati specificati nè un file nè il codice incorporato.',
        'VIDEO_UPLOADED_ON_X' => 'Video caricato su %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Si è verificato un problema durante la conversione del video a formato Flash: %s',
        'STATUS_N' => 'Pagamenti %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Non è stato possibile aggiungere il tuo video intitolato "%s" a %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Non è stato possibile aggiungere il tuo video a %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Hai appena cercato di inviare un video a %s.  Purtroppo non sei un membro di %s e non possiamo fornire questo video.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Il caricamento del video non è stato completato su %s',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Il caricamento del tuo video non è stato completato su %s.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Si è verificato un problema col tuo video durante il caricamento %s',
        'THE_PROBLEM_WAS_X' => 'Il problema era: %s',
        'FOR_FURTHER_ASSISTANCE_2' => 'Per richiedere ulteriore assistenza, contattaci a:',
        'ID' => 'Identificazione',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Transcodificazione del video non riuscita per video %s in %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s ha caricato un video per il quale non è riuscita la transcodificazione.',
        'ERROR_MESSAGE' => 'Messaggio di errore:',
        'APPLICATION_NAME' => 'Nome dell\'applicazione:',
        'APPLICATION_ID' => 'Identificazione dell\'applicazione:',
        'VIDEO_ID' => 'Identificazione video:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Caricamento video completato su %s',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'Il caricamento del tuo video è stato completato su %s',
        'YOUR_VIDEO_WAS_UPLOADED' => 'Il tuo video è stato caricato a %s con successo!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Quel video è in attesa di approvazione.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Questo video è ancora in corso di verifica.',
        'ADD_VIDEO' => 'Aggiungi video',
        'VIDEO_BY_X' => 'Video di %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'C\'è un nuovo commento al tuo video "%s" su %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'C\'è un nuovo commento a uno dei tuoi video su %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'Qualcuno ha lasciato un commento a un video che hai aggiunto a %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'qualcuno ha caricato un video a %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'maniere Altri modi di aggiungere video...',
        'FROM_YOUTUBE_OR_GOOGLE' => '...da YouTube o Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Prendi il codice HTML \'incorporato\' da qualsiasi sito popolare di video e aggiungilo a questo social network.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Aggiungi un video da YouTube o Google',
        'PASTE_IN_EMBED' => 'Incolla il codice \'incorporato\' per il video qui:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Aggiungi video attraverso il telefono o la posta elettronica',
        'VIDEO' => 'video',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Non ci sono video che corrispondono alle impostazioni selezionate.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Clicca su "Modifica" e cambia le impostazioni se desideri che questo riquadro sia visibile ad altre persone.',
        'PLAY_AGAIN' => 'Riproduci ancora',
        'SHARE' => 'Condividi',
        'EMBED' => 'Incorpora',
        'REWIND' => 'Riavvolgi',
        'CHANGE_SIZE' => 'Cambia dimensioni',
        'FULLSCREEN' => 'Schermo intero',
        'EXIT_FULLSCREEN' => 'Esci Schermo intero',
        'HIDE' => 'Chiudi',
        'COPY_AND_PASTE_LINK' => 'Copia e incolla questo collegamento in un\'e-mail o un messaggio istantaneo.',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Trovi altri video come questi su <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Guarda questo video su %s',
        'GET_EMBED_CODE' => 'Prendi il codice incorporato',
        'MORE_PHOTOS' => 'Altre fotografie',
        'THIS_ALBUM' => 'Questo album',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Questo network non ha ancora nessuna fotografia.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Questa persona non ha ancora nessuna fotografia.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Questo album non ha ancora nessuna fotografia.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Trovi altre fotografie come questa su <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'In questo momento non ci sono fotografie disponibili in questo album.  <a %s>Fai clic qui per vedere tutti gli album</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Questo album non può essere visualizzato da altre persone nel network, perchè le sue fotografie possono essere viste solo da te oppure non è stato ancora approvato.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Personalizza il tuo lettore di presentazioni!',
        'ADD_SLIDESHOW_LOGO' => 'Aggiungi un logo alla presentazione del tuo social network.  <a %s>Impostalo adesso! </a>',
        'PHOTO_BY_X' => 'Fotografia di %s',
        'UPLOAD_PHOTOS' => 'Carica fotografie',
        'PLAYER_COLOR' => 'Colore lettore',
        'SLIDESHOW_PLAYER' => 'lettore presentazioni',
        'SLIDESHOW' => 'presentazione',
        'FILTER' => 'Filtra',
        'SAVE_ALBUM' => 'Salva album',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Applica questa informazione alle seguenti fotografie',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'Fai clic per aggiungere una descrizione',
        'CHECK' => 'Controlla',
        'YOU_NEED_TO_BE_X' => 'Devi essere %s per poterlo fare.',
        'ALL_PHOTOS' => 'Tutte le fotografie',
        'POPULAR_PHOTOS' => 'Fotografie popolari',
        'FEATURED_PHOTOS' => 'Fotografie selezionate',
        'PHOTOS_HOME' => 'Home Fotografie',
        'ALL_ALBUMS' => 'Tutti gli album',
        'MY_PHOTOS' => 'Fotografie',
        'MY_ALBUMS' => 'Album',
        'ADD_PHOTOS' => 'Aggiungi fotografie',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Aggiungi fotografie',
        'EDIT' => 'Modifica',
        'CHOOSE_PHOTOS' => 'Scegli fotografie',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Aggiungi le fotografie trascinandole </strong> sul tuo album a destra.  Rimuovile trascinandole indietro.',
        'TITLE_YOUR_ALBUM' => '<strong>Dai un titolo al tuo album. </strong> Copertina e descrizione.',
        'SAVE_YOUR_ALBUM' => 'Salva il tuo album!',
        'CHOOSE_FROM' => 'Scegli da:',
        'EVERYONES_PHOTOS' => 'Fotografie di tutti',
        'TAGGED' => 'Taggate:',
        'OLDER_PHOTOS' => 'Fotografie più vecchie',
        'MORE_RECENT_PHOTOS' => 'Fotografie più recenti',
        'YOUR_ALBUM' => 'Il tuo album',
        'DRAG_ALBUM_COVER_HERE' => 'Trascina qui la copertina dell\'album',
        'ALBUM_TITLE' => 'Titolo album:',
        'ALBUM' => 'album',
        'DRAG_PHOTOS_HERE' => 'Trascina le tue fotografie qui',
        'PREVIOUS_ALBUM_PAGE' => 'Pagina precedente dell\'album',
        'NEXT_ALBUM_PAGE' => 'Pagina successiva dell\'album',
        'ADDED_ON_DATE' => 'Aggiunta %s',
        'VIEW_AS_SLIDESHOW' => 'Visualizza come presentazione',
        'CREATED_BY_ME' => 'Creato da <a %s>Me</a>',
        'CREATED_BY_X' => 'Creato da %s',
        'OUR_APOLOGIES' => 'Spiacenti',
        'ADD_PHOTOS_TO_ALBUM' => 'Aggiungi altre fotografie a questo album scegliendo fra le opzioni sottostanti.',
        'YOU_CAN_ADD_PHOTOS' => 'Puoi <a %s>aggiungere fotografie a questo album adesso</a>.',
        'SITE_IS_GETTING_STARTED' => 'Questo social network è appena agli inizi!',
        'NO_ONE_CREATED_ALBUMS' => 'Sembra che ancora non sia stato creato nessun album.  Puoi <a %s>creare un album adesso</a>.',
        'EDIT_YOUR_ALBUM' => 'Modifica il tuo album',
        'ALBUMS_WITH_THIS_PHOTO' => 'Tutti gli album con questa fotografia',
        'ALBUMS_WITH_X' => 'Tutti gli album con \'%s\'',
        'ALBUMS_WITH_X_2' => 'Tutti gli album con <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Non c\'è nessun album che contenga questa fotografia.  Puoi <a %s>creare un nuovo album</a>.',
        'XS_ALBUMS' => 'Album di %s',
        'CREATE_AN_ALBUM' => 'Crea un Album',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Non hai ancora creato nessun album di fotografie.  Puoi <a %s>creare un album adesso</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s non ha ancora creato nessun album di fotografie.',
        'MAKE_AN_ALBUM' => 'Crea un album',
        'ABOUT_THIS_ALBUM' => 'Informazioni su questo Album',
        'ABOUT_YOUR_ALBUM' => 'Informazioni sul tuo Album',
        'EDIT_ALBUM' => 'Modifica album',
        'DELETE_THIS_ALBUM' => 'Eliminare questo album?',
        'DELETE_ALBUM' => 'Elimina album',
        'START_SLIDESHOW' => 'Avvia presentazione',
        'ALBUM_IS_NOW_EMPTY' => 'Questo album in questo momento è vuoto.',
        'YOU_ARE_GETTING_STARTED' => 'Sei appena agli inizi!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Non hai ancora aggiunto nessuna fotografia!',
        'ADD_PHOTOS_AND_SHARE' => 'Aggiungi fotografie e condividile con i tuoi amici, la tua famiglia e il resto del mondo!',
        'ADD_A_PHOTO' => 'Aggiungi una fotografia',
        'NO_PHOTOS_ON_SITE' => 'In questo momento non ci sono fotografie nel tuo social network.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Questo riquadro non sarà  visibile ad altre persone finchè non ci saranno fotografie da mostrare. Perché non ne aggiungi uno?',
        'VIEW_EMBED_CODE' => 'Vis. codice incorporato',
        'VIEW_SLIDESHOW' => 'Visualizza presentazione',
        'VIEW_PHOTOS' => 'Visualizza fotografie',
        'ADD_YOUR_FIRST_PHOTOS' => 'Aggiungi le tue prime fotografie',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Puoi <a %s>aggiungere le tue fotografie</a> a %s!',
        'UPLOAD_PHOTOS_FROM' => 'Carica fotografie dal tuo computer:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Aggiungi un titolo e la descrizione per le tue fotografie',
        'EDIT_PHOTO_INFORMATION' => 'Modifica le informazioni delle fotografie',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Aggiungi un titolo, la descrizione e altre informazioni alle fotografie che hai appena caricato.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Aggiungi un titolo, la descrizione e altre informazioni per questa fotografia.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Annulla e ritorna a fotografia',
        'WHO_CAN_VIEW_PHOTO' => 'Chi può visualizzare questa fotografia?',
        'CAN_BE_VIEWED_BY' => 'Può essere visualizzata da:',
        'BY_ME' => 'da <a %s>Me</a>',
        'RSS_FEED_LABEL' => '<a %s>Feed RSS</a> - %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'In questo momento non ci sono video in corso d\'approvazione.  Se stai cercando qualcosa da fare, perché non guardi le <a %s>fotografie più recenti</a>?',
        'APPROVE_ALL_PHOTOS' => 'Approvare tutte le fotografie?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Sei sicuro di voler approvare tutte le fotografie?  Questo potrebbe impiegare qualche minuto.',
        'DELETE_ALL_PHOTOS' => 'Eliminare tutte le fotografie?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Sei sicuro di voler eliminare tutte le fotografie non approvate?  Questo potrebbe impiegare qualche minuto.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Mantieni questa finestra del browser aperta durante l\'approvazione delle fotografie.  Questo processo potrebbe impiegare qualche minuto.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Mantieni questa finestra del browser aperta durante l\'eliminazione delle fotografie.  Questo processo potrebbe impiegare qualche minuto.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Applica a tutte le fotografie aggiunte da %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Nessuno ha aggiunto fotografie al tuo social network.  Puoi essere il primo ad <a %s>aggiungere fotografie. </a>',
        'UNTITLED' => 'Senza titolo',
        'A_PROBLEM_OCCURRED' => 'Si è verificato un problema',
        'PHOTOS_EXCEEDED_LIMIT' => 'La(le) fotografia(e) sembrano aver superato il limite di 10 MB per fotografia.',
        'GET_A_SLIDESHOW_OF' => 'Ottieni una presentazione di  %s',
        'GET_A_SLIDESHOW' => 'Ottieni una presentazione!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Ottieni una presentazione di queste fotografie',
        'COPY_AND_PASTE_SLIDESHOW' => 'Copia e incolla il codice più in basso per mettere una presentazione di queste fotografie sul tuo sito web, sulla tua pagina di MySpace o su altri network Ning.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Copia e incolla il codice più in basso per mettere una presentazione di questo album sul tuo sito web, sulla tua pagina di MySpace o altri network Ning.',
        'LARGE_VERSION' => 'Versione grande',
        'SMALL_VERSION' => 'Versione ridotta',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Visualizza questa presentazione a grandezza naturale',
        'PHOTOS' => 'Fotografie',
        'XS_PHOTOS' => 'Fotografie di %s',
        'XS_PHOTO' => 'Fotografia di %s',
        'YOU_CAN_MARK_PHOTO' => 'Puoi contrassegnare qualsiasi fotografia come preferita. Fai clic sull\'icona "Aggiungi a Preferiti" quando la vedi su una fotografia.',
        'VIEW_RECENT_PHOTOS' => 'Visualizza fotografie recenti',
        'APPROVE_PHOTOS' => 'Approva fotografie',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Eliminare tutte le fotografie di %s?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Sei sicuro di voler eliminare tutte le fotografie di %s?  Questo processo potrebbe impiegare qualche minuto.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Rimuovi %1$s e tutto il contenuto di %1$s dal tuo social network',
        'SUCCESS' => 'Successo.',
        'DELETING_CONTENT' => 'Eliminazione contenuto...',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Mantieni questa finestra del browser aperta durante l\'eliminazione del contenuto.  Questo processo potrebbe impiegare qualche minuto.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Mantieni questa finestra del browser aperta durante l\'eliminazione dei membri.  Questo processo potrebbe impiegare qualche minuto.',
        'DELETE_ALL_XS_PHOTOS' => 'Elimina tutte le fotografie di %s',
        'CREATE_A_NEW_ALBUM' => 'Crea un nuovo album',
        'VIEW_ALL_XS_ALBUMS' => 'Visualizza tutti gli Album di %s',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Non hai ancora aggiunto nessuna fotografia.  Aggiungi qualche fotografia per iniziare!',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s non ha ancora aggiunto nessuna fotografia.',
        'MY_FRIENDS_PHOTOS' => 'Fotografie dei miei amici',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Visualizza queste fotografie in una presentazione!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'I tuoi amici non hanno ancora nessuna fotografia',
        'ALL_PHOTOS_TAGGED_X' => 'Tutte le fotografie contrassegnate \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Tutte le fotografie contrassegnate <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'Non c\'è nessuna fotografia contrassegnata "%1$s".  Guarda<a %2$s>discussioni contrassegnate "%1$s"</a> o <a %3$s>video contrassegnati"%1$s"</a>.  O aggiungi e contrassegna le tue fotografie!',
        'SELECT_YOUR_PHOTOS' => 'Seleziona le tue fotografie',
        'PHOTO_MAY_BE_10MB' => 'Ogni fotografia può avere una dimensione massima di 10 MB, ma il caricamento delle fotografie più piccole sarà  più veloce!',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Tieni questa pagina aperta per concludere la fase di caricamento delle tue fotografie e ti faremo sapere quando saranno approvate!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Nel frattempo, puoi <a %s>aprire una nuova finestra del browser</a> e continuare ad usare %s.  Quando il caricamento sarà stato completato potrai aggiungere titoli e descrizioni alle tue fotografie in questa finestra.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Questa fotografia è <strong>in corso d\'approvazione</strong> da parte dell\'autore di %s.',
        'ADD_TO_FAVORITES' => 'Aggiungi a Preferiti',
        'EDIT_PHOTO' => 'Modifica fotografia',
        'DELETE_PHOTO' => 'Elimina fotografia',
        'ABOUT_THIS_PHOTO' => 'Informazioni su questa fotografia',
        'LOCATION_OF_PHOTO' => 'Posizione di questa fotografia:',
        'ALBUMS_FEATURING_PHOTO' => 'Album che contengono questa fotografia',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Visualizza tutti gli album con questa fotografia',
        'RETURN_TO_X' => 'Ritorna a %s',
        'RETURN_TO_PHOTOS_HOME' => 'Ritorna a Home Fotografie',
        'WE_COULD_NOT_FIND_ANYONE' => 'Spiacenti, non siamo riusciti a trovare nessuna',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Nessuno ha ancora aggiunto fotografie!  Aggiungi qualche fotografia per iniziare.',
        'DEFAULT_TITLE' => 'Titolo',
        'DEFAULT_DESCRIPTION' => 'Descrizione',
        'UPLOAD_LIMIT_EXCEEDED' => 'Il limite della dimensione del file da caricare è stato superato.',
        'SLOW_DOWN_THERE_CHIEF' => 'Spiacenti',
        'I_DO_NOT_KNOW_USER' => 'Spiacente, non conosco questa persona.',
        'I_DO_NOT_HAVE_PHOTO' => 'Spiacente, non ho questa fotografia.',
        'I_DO_NOT_HAVE_ALBUM' => 'Spiacente, non ho questo album.',
        'ALBUM_BY_X_ON_X' => 'Album di %s su %s',
        'SENT' => 'Inviato!',
        'I_HAVE_RECENTLY_ADDED' => 'Ho aggiunto recentemente',
        'FROM_THE_BAZEL' => 'Da questo network',
        'RECENTLY_ADDED' => 'Aggiunto recentemente',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Fotografie pubbliche recenti su %s',
        'X_ALL_PHOTOS' => '%s - Tutte le fotografie',
        'NO_TAG_WAS_SPECIFIED' => 'Non è stato specificato nessun tag',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Fotografie pubbliche contrassegnate con %s su %s',
        'XS_PUBLIC_PHOTOS_ON_X' => '%s\'s fotografie pubbliche su %s',
        'WE_DO_NOT_KNOW_USER' => 'Non conosciamo questa persona.',
        'XS_FRIENDS_PHOTOS' => 'Fotografie di amici di %s',
        'XS_FAVORITE_PHOTOS_ON_X' => 'Fotografie preferite di %s su %s',
        'PHOTO_UPLOADED_ON_X' => 'Fotografia caricata su %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'Il file ha superato la dimensione massima',
        'PART_OF_FILE_WAS_UPLOADED' => 'Il file è stato caricato solo in parte',
        'NO_FILE_WAS_UPLOADED' => 'Il caricamento non è riuscito;  Il nome del file potrebbe non essere corretto',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Si è verificato un problema durante il caricamento.',
        'ALPHABETICAL' => 'alfabetico',
        'MOST_VIEWS' => 'La maggior parte delle viste',
        'RATING_NOT_RATED_YET' => '<strong>Classificazione:</strong> Non ancora classificato',
        'NOT_RATED_YET' => 'Non ancora classificato',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm... qualcosa è andato storto',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Non è stato possibile aggiungere la tua fotografia dal titolo "%s" a %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Non è stato possibile aggiungere la tua fotografia a %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Hai appena cercato di inviare una fotografia a %s.  Purtroppo non sei un membro di %s e non possiamo fornire questa fotografia.',
        'ONLY_MY_FRIENDS' => 'Solo i miei amici',
        'ANYBODY' => 'Chiunque',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Solo i miei amici possono vedere questa fotografia',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Solo gli amici di %s possono vedere questa fotografia',
        'ONLY_I_CAN_SEE_PHOTO' => 'Solo io posso vedere questa fotografia',
        'ONLY_X_CAN_SEE_PHOTO' => 'Solo %s può vedere questa fotografia',
        'EVERYONE_CAN_SEE_PHOTO' => 'Tutti possono vedere questa fotografia',
        'PRIVATE_PHOTO' => 'Fotografia <strong>privata</strong>',
        'HOWDY_STRANGER' => 'Ciao, straniero!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Devi effettuare l\'accesso a Ning prima di poterlo fare.',
        'JUST_CLICK_ON_SIGN_IN' => 'Fai clic su "Accedi", o se non hai ancora un account Ning fai clic su "Registrati".',
        'YOU_NEED_TO_BE_' => 'Devi essere %s per poterlo fare.',
        'YOU_NEED_TO_BE_OWNER' => 'Devi essere un creatore di network per fare quello.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Quella fotografia è in attesa di approvazione.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Devi essere un amico di %s per fare quello.',
        'MOST_ACTIVE' => 'Il più attivo',
        'HOW_IT_WORKS' => 'Come funziona',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Altri modi di aggiungere fotografie...',
        'BY_PHONE_OR_EMAIL' => '...per telefono o e-mail',
        'FROM_FLICKR' => '...da Flickr',
        'FROM_YOUR_COMPUTER' => '...dal tuo computer',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Aggiungi fotografie dal tuo account Flickr.',
        'MORE_INFORMATION' => 'Altra informazione',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Aggiungi fotografie per telefono o e-mail',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Invia una fotografia o un video per e-mail.  L\'oggetto dell\'e-mail diventa il titolo della fotografia o del video e il corpo diventa la descrizione.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Fai clic qui per registrare un nuovo indirizzo e-mail',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Carica fotografie dal tuo computer.',
        'PHOTO' => 'fotografia',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Attualmente non stai visualizzando nessuna fotografia.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Questo riquadro non sarà visibile ad altre persone se non selezioni almeno una fotografia.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'C\'è un nuovo commento alla tua fotografia "%s" su %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'C\'è un nuovo commento a una delle tue fotografie su %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'Qualcuno ha fatto un commento a una fotografia che hai aggiunto a %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'Qualcuno ha caricato una fotografia a %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Aggiungi fotografie o video a %s direttamente dal tuo telefonino mandandole a un indirizzo e-mail.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Vuoi veramente rimuovere questo articolo dai tuoi preferiti?',
        'DELETE_THIS_PHOTO_Q' => 'Eliminare questa fotografia?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Sei sicuro di voler eliminare questa fotografia?  Questo processo potrebbe impiegare qualche minuto.',
        'PHOTO_SLIDESHOW' => 'Presentazione',
        'THUMBNAILS' => 'Anteprima',
        'DETAIL' => 'Dettaglio',
        'TAG' => 'Tag',
        'RATE' => 'Valuta',
        'ALL_SIZES' => 'Tutte le dimensioni',
        'ADD_TO_ALBUM' => 'Aggiungi all\'Album',
        'ROTATE_PHOTO' => 'Ruota fotografia',
        'ABOUT_YOUR_PHOTO' => 'Informazioni sulla tua fotografia',
        'SEE_PHOTOS_ON_NETWORK' => 'Guarda queste fotografie su %s',
        'EMBED_CODE' => 'Codice incorporato',
        'IMPORT_PHOTOS_FLICKR' => 'Prendi le tue fotografie da Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Fai clic qui per passare a Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Per ottenere le tue fotografie da Flickr, devi prima permettere a %S di creare un collegamento al tuo account Flickr.',
        'IMPORT_PHOTOS' => 'Importa fotografie',
        'GET_MY' => 'Prendi le mie',
        'GET_PHOTOS' => 'Prendi fotografie',
        'MOST_RECENT_PHOTOS' => 'Fotografie più recenti',
        'GET_ALL_MY_FLICKR' => 'Prendi tutte le mie fotografie da Flickr (potrebbe impiegare un po\' di tempo)',
        'GET_ALL_MY_TAGGED' => 'Assegna un tag a tutte le mie fotografie',
        'GET_PHOTOS_FROM_SET' => 'Prendi le fotografie da un insieme:',
        'GET_STARTED_BY_IMPORT' => 'Prenderemo automaticamente i tuoi file, tag e le informazione di mapping che siano a disposizione. <br/>Quanto tempo impiegherà? </p> <p><ul style="padding-top:10px; "><li>10 fotografie: <em>meno di 30 secondi</em>. </li><li>50 fotografie: <em>circa 2 minuti</em>. </li><li>200 fotografie: <em>circa 6 minuti</em>. </li><li>500 fotografie: <em>circa 15 minuti</em>. </li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Se non hai effettuato l\'accesso a Flickr, ti verrà richiesto di accedere.  Una volta effettuato l\'accesso, fai clic sul pulsante che dice "OK, lo permetto”.',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Prendi anche le descrizioni (questo raddoppierà  il tempo necessario).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Tieni questa pagina aperta per permetterci di finire di importare le tue fotografie.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Ottieni la versione a grandezza naturale di ogni fotografia (questo aumenterà  significativamente il tempo di importazione e non è consigliato per più di 20 fotografie).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Clicca su "modifica" per aggiungere testo, video o qualunque widget in questo riquadro. È un altro modo per personalizzare la tua pagina %s.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Clicca su "Modifica" per aggiungere testo, HTML, video, fotografie, o qualsiasi <a %1$s> widget esterno</a> in questo riquadro. È un altro modo per personalizzare la tua pagina %2$s.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Questo riquadro non sarà visibile ad altre persone finché non ne aggiorni il contenuto.',
        'YOUR_X_BOX' => 'Il tuo riquadro %s',
        'ABOUT_WIDGETS' => 'Informazione sui Widget',
        'HELP' => '?',
        'WIDGETS' => 'Widget',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Cerchi di aggiungere più funzionalità al tuo social network?  Forse un calendario, le previsioni del tempo locali, conto alla rovescia per un evento o la webcam?  Con i widget, è facile aggiungere funzionalità addizionali a qualsiasi casella di testo sul tuo  network.',
        'GETTING_STARTED' => 'Guida introduttiva',
        'BELOW_IS_LIST_OF_WIDGET' => 'Sotto trovi <a %s>un elenco di widget provider</a> che ti può interessare.  Abbiamo selezionato alcuni widget da <a %s>yourminis. com</a> per iniziare.  Imposta uno dei widget che trovi a continuazione, copia il codice incorporato e incollalo direttamente dentro la casella di testo.  Prova!',
        'CALENDAR' => 'Calendario',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'Nel widget calendario non solo si visualizza la data, ma ti permette anche di cercare ed aggiungere eventi formato iCal (utilizzati dal calendario di Google e da tanti altri provider di calendari on-line).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Usa il &#8220; Modifica widget&#8221;  Pulsante per selezionare &#8220; Cerca eventi&#8221; ,quindi inserisci un termine di ricerca (prova vacanze, una squadra sportiva ecc. ). Dopo seleziona un risultato di ricerca e quegli eventi si aggiungeranno al tuo calendario.  Puoi anche inserire manualmente l\'indirizzo di qualsiasi iCal feed esistente.',
        'CUSTOMIZATION' => 'Personalizzazione',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Puoi personalizzare l\'aspetto del widget puntando il mouse sul widget, e facendo clic sull\'\'icona prelevatore di colori per modificare lo sfondo, lo stile del widget e il livello di trasparenza.  Quando hai concluso fai clic sul link &#8220; Copia su web&#8221; poi sul pulsante &#8220; copia il codice incorporato&#8221; Una volta che il codice è stato copiato, ritorna su qualunque casella di testo nel tuo network, incolla il codice e salva le modifiche. Tutto fatto!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Prendi altri widget da yourminis. com »',
        'WEATHER' => 'Meteo',
        'WEATHER_WIDGET_DISPLAYS' => 'Il widget meteo mostra le previsioni del tempo locale da Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Usa il &#8220; Modifica widget&#8221;  pulsante per selezionare la tua località e scegliere fra Fahrenheit o Centigradi.  Puoi scegliere di visualizzare il meteo solo per la giornata odierna o estenderlo a una previsione di cinque giorni.',
        'COUNTDOWN' => 'Conto alla rovescia',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Il Countdown widget ti permette di creare un conto alla rovescia per un evento specifico.  Facendo clic sul &#8220; Modifica widget&#8221;  pulsante, puoi inserire la data, l\'ora e il titolo o l\'immagine di un evento per il quale fare il conto alla rovescia.',
        'WEBCAM' => 'Webcam',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Il widget Webcam ti permette di monitorare attivamente qualsiasi webcam disponibile pubblicamente.  Usa il &#8220; Modifica widget&#8221;  Pulsante per selezionare da una lista di webcam predefinite, o inserire manualmente l\'URL di qualsiasi webcam.',
        'MORE_WIDGETS' => 'Altri widget',
        'NEED_MORE_OPTIONS' => 'Hai bisogno di altre opzioni?  Consigliamo qualsiasi dei seguenti siti web per soddisfare la vostra sete di widget:',
        'MODERATION_DENIED_ON_X' => 'La moderazione su %s su %s è stata negata',
        'MODERATION_DENIED_ON_A_X' => 'La moderazione è stata negata su un tuo %s su %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Hai ricevuto un nuovo %s da moderare su %s',
        'NEW_X_TO_MODERATE' => 'C\'è un nuovo %s per essere moderato da te.',
        'MODERATION_APPROVED_ON_X' => 'Moderazione approvata su %s su %s',
        'MODERATION_APPROVED_ON_A_X' => 'Moderazione approvata su uno dei tuoi %s su %s',
        'JOIN' => 'Aderisci',
        'WELCOME' => 'Benvenuti',
        'WELCOME_TO_X' => 'Benvenuti a %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Benvenuti a %s...',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Nuove funzionalità! </h3>
            <ul><li><strong>Gruppi</strong> &ndash;  Lascia che i tuoi membri creino gruppi nel tuo network</li>
                <li><strong>lettore musicale</strong> &ndash;  Aggiungi musica e podcast al tuo network</li></ul>
            <p><a href="%s" class="desc add">Fai clic qui per aggiungere funzionalità</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Nuove funzionalità! </h3>
            <ul><li><strong>Attività più recenti</strong> &ndash;  Segui le attività più recenti dei membri sul tuo network </li>
                <li><strong>Badge e Widget</strong> &ndash;  Promuovi il tuo network su tutto il web con badge personalizzati e widget</li></ul>
            <p><a href="%s" class="desc add">Fai clic qui per aggiungere/modificare le funzionalità</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Il tuo %2$s, %1$s, ha un nuovo commento aggiunto da qualcuno su %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Il tuo %1$s ha un nuovo commento aggiunto da qualcuno su %3$s!',
        'HERE_IS_LINK' => 'Questo è il collegamento per partecipare a: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Grazie,',
        'THANKS' => 'Grazie!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Hai modificato l\'indirizzo e-mail su %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Hai modificato l\'indirizzo e-mail su %s...',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Fare clic qui per accedere con il tuo nuovo indirizzo e-mail:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Se non hai modificato il tuo indirizzo e-mail fai clic qui:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Per non ricevere più notificazioni di nuove discussioni, vai a:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s ha iniziato una nuova discussione su %2$s...',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s ha iniziato la discussione "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Per visualizzare questa discussione, vai a:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s ti ha invitato a partecipare a %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s vuole che tu guardi "%s" su %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Guarda "%s" su %s!',
        'ABOUT_X' => 'Informazioni su %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Hai ricevuto questo messaggio perchè %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Se non desideri più ricevere notifiche e-mail da %s, <a %s>fai clic qui</a>.',
        'CLICK_HERE' => 'Fai clic qui',
        'YOU_CAN_CONTACT_US' => 'Per domande o preoccupazioni riguardanti la privacy puoi metterti in contatto con noi all\'indirizzo http://help.ning.com/?page_id=27 .',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Un messaggio a tutti i membri di %s',
        'CLICK_TO_CHECK_OUT' => 'Fai clic qui per vederlo!',
        'CLICK_TO_APPROVE_X' => 'Fai clic qui per approvare /eliminare questo %s',
        'YOUR_X_HAS_BEEN_APPROVED' => 'Il tuo %s è stato approvato su %s!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Il tuo %s non è stato approvato su %s.',
        'CLICK_TO_VIEW_X' => 'Fai clic qui per visualizzare questo %s!',
        'CLICK_TO_VIEW_IT' => 'Fai clic qui per visualizzarlo!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'Per visualizzare il profilo di %s, visita:',
        'YOU_ADDED_CONTENT' => 'Hai aggiunto contenuto su %s, un social network moderato',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s ha segnalato una preoccupazione su %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s ha segnalato il seguente problema.',
        'URL_REPORTED_COLON' => 'URL segnalato:',
        'ISSUE_COLON' => 'Problema:',
        'ADDITIONAL_INFORMATION_COLON' => 'Ulteriori informazioni:',
        'SEND_AN_INVITATION_TO_X' => 'Invia un invito a %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'qualcuno ha richiesto di partecipare a %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Desideri aggiungere un messaggio di benvenuto per %s nel loro profilo?   Vai a:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s ti ha inviato un messaggio.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Per leggere questo messaggio visita:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s ha inviato un messaggio su %s...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s ti ha aggiunto come amico...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s ti ha aggiunto come amico su %s.',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s ha accettato la tua richiesta amico su %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Per accettare questa richiesta amico, visita:',
        'VIEW_XS_PAGE_ON_Y' => 'Visualizza la pagina di %s su %s',
        'MEMBER_OF_X_ACCEPTED' => 'un membro di %s ha accettato la tua richiesta amico',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Se non desideri più ricevere notifiche e-mail di richieste amici da %s, <a %s>fai clic qui</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Hai ricevuto questo invito da un membro di %1$s.  Se non desideri ricevere inviti da %1$s, contattaci all\'indirizzo http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => 'Su %s:',
        'ON_X' => 'su %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s ha richiesto di diventare membro di %s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s ha richiesto di diventare membro di %2$s su %3$s...',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s ti ha invitato a partecipare al Gruppo "%2$s"',
        'VISIT_GROUP_AT' => 'Visita %s al:',
        'ABOUT_GROUP' => 'Informazioni su %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Un messaggio %s a tutti i membri di %s su %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Puoi accedere utilizzando il tuo indirizzo e-mail qui:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s ha fatto un commento sul blog \'%s\' su %s',
        'SEND_X_A_MESSAGE_HERE' => 'Invia %s un messaggio qui:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Hai un nuovo membro da approvare su %s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Hai un nuovo membro da approvare.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Per approvare il profilo di %s, visita:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Non riesci a fare clic sul collegamento che trovi sopra?  Copia e incolla l\'URL nel tuo browser web .',
        'CLICK_HERE_TO_JOIN_COLON' => 'Fai clic qui per partecipare:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Fai clic qui per partecipare!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'La tua %s adesione è stata approvata...',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Congratulazioni!   La tua %s adesione è stata approvata.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Adesso puoi accedere utilizzando il tuo indirizzo e-mail qui:',
        'VISIT_X_AT_Y' => 'Visita %1$s al: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Per controllare quali e-mail ricevi su %1$s, vai a:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Un membro bannato ti ha inviato un messaggio su %s...',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Un membro bannato ti ha inviato un messaggio su %1$s.   %2$s scrive:',
        'WELCOME_TO_THE_GROUP_X' => 'Benvenuto al Gruppo "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Benvenuto al %1$s su%2$s...',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Per visualizzare questo gruppo visita:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s ti invita a partecipare al %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s è un nuovo membro di %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$sà¢ è un nuovo membro di %2$s...',
        'SOMEBODY' => 'Qualcuno',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Per visualizzare il tuo nuovo commento, visita:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Per visualizzare il nuovo commento, visita:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Per visualizzare la nuova risposta, visita:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Benvenuto a %s!  Grazie per partecipare esserti iscritto.',
        'NAME_COLON' => 'Nome:',
        'EMAIL_COLON' => 'E-mail:',
        'AGE_COLON' => 'Età :',
        'GENDER_COLON' => 'Sesso:',
        'LOCATION_COLON' => 'Posizione:',
        'COUNTRY_COLON' => 'Paese:',
        'GET_NETWORK_BADGE' => '%s Badge',
        'SPREAD_WORD_GET_BADGE' => 'Passaparola.  Ottieni il tuo %s badge per il tuo sito web o per la pagina di MySpace.  (<a %s>Ottieni Codice</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Passaparola.  <a href="%s">Ottieni il tuo %s badge</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Mostra la tua fedeltà.  Ottieni il tuo %s badge da mettere sul tuo sito web o sulla pagina di MySpace.  (<a %s>Ottieni Codice</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s ha fatto un commento sul %2$s "%4$s" su %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Spiacenti à¢â‚¬â€œ Non siamo in grado di estrarre nessun indirizzo di posta elettronica da questo file.',
        'ADMINISTRATORS' => 'Amministratori',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Il tuo invito è scaduto',
        'SORRY_INVITATION_EXPIRED' => 'Spiacenti, l\'invito che hai utilizzato è scaduto.   Avrai bisogno di un nuovo invito per partecipare a %s.',
        'DISABLE_INVITATION_LINK' => 'Disabilitare il collegamento invito?',
        'CREATING_LINK_WILL_DISABLE' => 'La creazione di un nuovo collegamento disabiliterà quello l\'attuale.  Sei sicuro di voler creare un nuovo collegamento?',
        'SHARE_LINK_WITH_PEOPLE' => 'Condividi questo collegamento con le persone che desideri partecipino a questo network:',
        'CREATE_INVITATION_LINK' => 'Crea un nuovo collegamento invito',
        'PLEASE_SELECT_SECOND_PART' => 'Seleziona la seconda parte del tuo indirizzo di posta elettronica, ad esempio, gmail. com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Assicurati che il simbolo @ non sia nella prima parte dell\'indirizzo di posta elettronica.',
        'SORRY_WE_DONT_SUPPORT' => 'Spiacenti, non supportiamo la rubrica web per il tuo indirizzo e-mail.  Prova a fare clic su \'Address Book Application\' più in basso per utilizzare gli indirizzi presenti sul tuo computer.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Inserisci la tua password per %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importazione rubrica',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Lascia aperta questa finestra </strong> mentre otteniamo gli indirizzi di posta elettronica dei tuoi amici.  Quando avremo finito, potrai scegliere quali amici invitare.',
        'SHARE_THIS_LINK' => 'Condividi questo collegamento:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Invialo con il programma di posta elettronica del tuo computer:',
        'EMAIL_THIS' => 'Spedisci questa e-mail',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(è il tuo amico)',
        'CLEAR' => 'Deseleziona',
        'SEARCH_FRIENDS_TO_INVITE' => 'Cerca amici da invitare:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'I tuoi inviti sono stati inviati',
        'WANT_TO_INVITE_MORE' => 'Vuoi invitare altri amici?  Importa contatti dalla tua rubrica web o applicazione e-mail.',
        'MESSAGE_TOO_LONG' => 'Il tuo messaggio è troppo lungo.  Usa meno di %s caratteri.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'I seguenti non sembrano essere indirizzi e-mail validi.  Gli inviti non sono stati inviati.  Correggi gli indirizzi e-mail e prova un\'altra volta.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Inserisci uno o più indirizzi di posta elettronica.',
        'ENTER_EMAIL_ADDRESSES' => 'Inserisci indirizzi e-mail',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Separa indirizzi multipli con la virgola',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Tuo messaggio</label> (opzionale)',
        'SEND_INVITATIONS' => 'Invia inviti',
        'WEB_ADDRESS_BOOK' => 'Rubrica web',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail o AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Il tuo indirizzo e-mail',
        'IMPORT_ADDRESS_BOOK' => 'Importa Rubrica',
        'DONT_WORRY_WE_WONT_SAVE' => 'Non ti preoccupare, non salveremo la tua password e tu avrai l\'opportunità  di scegliere a quali amici spedire le e-mail.',
        'EMAIL_APPLICATION' => 'Applicazione e-mail',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Address Book, . CSV, ecc.',
        'UPLOAD_CSV_OR_VCF' => 'Carica un . file csv o . vcf esportati da Microsoft Outlook o Apple Address Book.',
        'BROWSE_FOR_FILE' => 'Sfoglia per file',
        'UPLOAD' => 'Carica',
        'SELECT_ELLIPSIS' => 'seleziona...',
        'OTHER_ELLIPSIS' => 'altro...',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Non ti preoccupare, avrai l\'opportunità  di scegliere a quali amici spedire le e-mail.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Si diventa membri soltanto per invito',
        'IF_YOU_ARE_ADMIN' => 'Se sei un amministratore, <a %s>fai clic qui per accedere</a>.',
        'NAME_MUST_BE_SHORTER' => 'Il nome deve avere meno di %s caratteri',
        'CITY_NAME_MUST_BE_SHORTER' => 'Il nome della città  deve avere meno di %s caratteri',
        'EMAIL_ALREADY_REGISTERED' => 'L\'indirizzo e-mail è già stato registrato.  Scegline un altro.',
        'EMAIL_NOT_VALID' => 'L\'indirizzo e-mail non sembra essere valido.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s ti ha invitato a %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Ti stai registrando con il tuo Ning ID.',
        'NOW_ENTER_PASSWORD' => 'Adesso inserisci la tua password per continuare.',
        'OR_SIGN_IN' => 'o <a %s>Accedi</a>',
        'CHANGE_ADDRESS' => 'Cambia indirizzo',
        'CHANGE_PAGE_ADDRESS' => 'Cambia indirizzo della pagina',
        'PAGE_ADDRESS_TAKEN' => 'Spiacenti, quell\'indirizzo non è disponibile.  Scegline un altro.',
        'PAGE_ADDRESS_NOT_VALID' => 'Puoi usare soltanto le lettere A-Z, numeri e caratteri di sottolineatura (_) nel tuo indirizzo.',
        'ADD_BY_PHONE' => 'Aggiungi per telefono',
        'PAGE_ADDRESS' => 'Indirizzo della pagina',
        'PHOTO_MUST_BE_TYPE' => 'La tua fotografia deve essere un file: jpg, . gif o . png.',
        'USEFUL_ADDRESSES' => 'Indirizzi utili',
        'MY_DETAILS' => 'I miei dati',
        'NONE_I_DO_NOT_WANT' => 'Nessuna: non desidero ricevere e-mail da %s',
        'CHANGE_PASSWORD' => 'Modifica Password',
        'PROFILE_SAVED' => 'Le tue modifiche sono stati salvate.',
        'UPDATE_EMAIL_ADDRESS' => 'Aggiorna l\'indirizzo di posta elettronica',
        'EDIT_EMAIL_ADDRESS' => 'Modifica il tuo indirizzo e-mail',
        'MY_SETTINGS' => 'Le mie impostazioni',
        'ABOUT_ME' => 'Chi sono',
        'SELECT' => 'Seleziona...',
        'CITY' => 'Città ',
        'COUNTRY' => 'Paese',
        'DATE_OF_BIRTH' => 'Data di nascita',
        'DO_NOT_DISPLAY' => 'Non visualizzare',
        'GENDER' => 'Sesso',
        'CREATE_YOUR_PROFILE' => 'Crea il tuo profilo',
        'SYSTEM_REQUIREMENTS' => 'Requisiti di sistema',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Supportiamo Internet Explorer 6 e 7, Firefox 2.0 e Safari 2.0. Se stai usando un browser differente (forse uno fornito dal tuo  provider), potrebbe non essere compatibile.',
        'MAKE_SURE_COOKIES' => 'Assicurati che i cookie e JavaScript siano abilitati nel tuo browser.',
        'WHAT_IS_MY_EMAIL' => 'Qual è il mio indirizzo di posta elettronica?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Se sei membro da prima del 5 ottobre 2007 potrebbe esserti stato precedentemente chiesto un \'Ning ID\'.  Ti chiediamo di accedere con l\'indirizzo di posta elettronica col quale ti sei registrato, comunque puoi ancora inserire il tuo Ning ID in questo campo.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Fai clic qui per azzerare la tua password.',
        'STILL_HAVING_PROBLEMS' => 'Hai ancora problemi?',
        'VISIT_NING_HELP_CENTER' => 'Visita il <a %s>Centro assistenza Ning</a> per ulteriori informazioni circa la risoluzione dei problemi e l\'assistenza.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problemi nell\'accesso o registrazione',
        'WE_SENT_YOU_EMAIL' => 'Ti abbiamo inviato un\'e-mail con un collegamento per azzerare la tua password.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Azzeramento della password',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

abbiamo ricevuto una richiesta di modifica della tua password su %2$s.

Fai clic sul collegamento che trovi sotto per impostare una nuova password:

#{URL}

Se non vuoi modificare la .password, puoi ignorare questa e-mail.

Grazie,
Il "%2$s" Team

-----
%2$ utilizza il Ning ID per l\'autenticazione.',
        'SET_PASSWORD' => 'Imposta Password',
        'NEW_PASSWORD' => 'Nuova Password',
        'CREATE_NEW_PASSWORD' => 'Crea una nuova Password',
        'SET_NEW_PASSWORD' => 'Imposta una nuova password per il tuo account Ning ID.',
        'CHOOSE_NEW_PASSWORD' => 'Scegli una nuova password',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Ciao, %s</strong> (<a %s>Disconnetti</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Non c\'è nessun account con l\'indirizzo di posta elettronica %s',
        'PLEASE_ENTER_CODE' => 'Inserisci il codice che appare a destra.',
        'PROBLEMS_SIGNING_UP' => 'Problemi nella registrazione?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Registrandoti sei d\'accordo con i <a %s>Termini di Servizio</a> e la <a %s>Politica&nbsp; della Privacy</a>.',
        'FEEDBACK' => 'Commenti e suggerimenti',
        'TERMS_OF_SERVICE' => 'Termini del servizio',
        'PROBLEM_SIGNING_UP' => 'Si è verificato un problema nella registrazione',
        'ALREADY_MEMBER_SIGN_IN' => 'Sei già un membro?  <a %s>Fai clic qui per accedere</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'L\'adesione a %s è solo per invito',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Spiacenti, ma l\'amministratore ha scelto di richiedere un invito per partecipare a %s.  Se hai un invito, fai clic sul collegamento nell\'e-mail per iscriverti.',
        'PROBLEM_SIGNING_IN' => 'Si è verificato un problema durante l\'accesso',
        'WE_USE_NING_ID' => 'Noi usiamo il Ning ID per l\'autenticazione.  <a %s>Cos\'è un Ning ID? </a>',
        'PROBLEMS_SIGNING_IN' => 'Problemi durante l\'acceso?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Accedi" /> &#160; or&#160;  <strong><a %s>Registrati</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Accedi a %s',
        'WHAT_IS_A_NING_ID' => 'Cos\'è un Ning ID?',
        'LARR_BACK' => '← <a %s>Indietro</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Il sistema di autenticazione Ning ID ti permette di scegliere un indirizzo di posta elettronica e una password una volta e usarlo per iscriverti o accedere a qualsiasi social network che usi il Ning ID.',
        'WHEN_YOU_CREATE_NING_ID' => 'Quando crei un Ning ID poi anche aggiungere un insieme di dettagli basici e la tua fotografia al tuo account Ning ID.  Questi dettagli sono precompilati ogni volta che partecipi a un nuovo social network che utilizza un Ning ID per l\'autenticazione.  Ti permette anche di mantenere il contatto con i tuoi amici ed essere aggiornato sui messaggi in tutti i social network che lo usano.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Puoi accedere con il tuo indirizzo di posta elettronica e password del Ning ID ogni volta che vedi questo simbolo: %s',
        'HELLO_USER' => 'Ciao, %s',
        'TEXT_FOR_HEADER_TAB' => 'Questo testo è per una scheda di intestazione',
        'BASED_ON' => 'Basato su',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Sei sicuro di voler eliminare questa lingua?',
        'DELETE_LANGUAGE' => 'Elimina lingua',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'Il testo è stato azzerato alla versione originale.',
        'UPLOAD_LANGUAGE_FILE' => 'Carica il file di lingua',
        'ADD_TO_LANGUAGE' => 'Aggiungi a lingua.',
        'IF_YOU_CREATED_TRANSLATION' => 'Se hai creato una nuova traduzione su un altro social network Ning, puoi importare il tuo lavoro qui.  I contenuti del file saranno aggiunti alla lingua di tua scelta.  Non vedi la tua lingua nell\'elenco?  <a %s>È facile aggiungere una nuova</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Esempi: svedese (Finlandia), filippino, spagnolo (Portorico)',
        'START_FROM_SCRATCH_CREATE' => 'Comincia da zero!  Crea una nuova traduzione per il tuo network inserendo un nome per la nuova lingua e scegliendo una lingua esistente come punto di riferimento.',
        'KEY_MISSING_TEXT' => 'Chiave: <span %s>Testo Mancante</span> <span %s>Testo modificato</span>',
        'SHOW_ALL_TEXT' => 'Mostra tutto il testo',
        'SHOW_MISSING_TEXT' => 'Mostra il testo mancante',
        'SHOW_CHANGED_TEXT' => 'Mostra il testo modificato',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Esempi: Schede, Membri, Amici',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Azzera testo alla versione originale',
        'ORIGINAL_TEXT_X' => 'Testo originale - %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Modifica la lingua nel tuo network',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Personalizza qualunque parte del testo nel tuo network, includendo i nomi delle schede, i titoli in basso delle e-mail, i messaggi di errore e altro.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>La lingua attiva per il tuo network è %1$s</em>.  <a %2$s>Cambia lingua attiva</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Opzioni di lingua corrente',
        'ACTIVE' => 'Attiva',
        'MY_LANGUAGES' => 'Le mie lingue',
        'CREATE_NEW_TRANSLATION' => 'Crea una nuova traduzione',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Non vedi la tua lingua nella lista sopra?  <strong><a %s>Crea una nuova traduzione per il tuo network</strong>.',
        'ADVANCED_IMPORT' => 'Importazione avanzata',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Se hai tradotto una lingua in un social network esistente, puoi <strong><a %s>importare il tuo file di lingua</a></strong> e usarlo in questo network.',
        'LANGUAGE_EDITOR' => 'Editor lingua',
        'PUBLIC' => 'Pubblico',
        'GRANDFATHERED_PRIVACY_SETTING' => 'La tua attuale impostazione della privacy, un network dove i non membri possono solo vedere la schermata d\'accesso, non è più disponibile.   La tua impostazione della privacy non è stata modificata, ma se fai qualsiasi modifica qui, non sarai in grado di tornare indietro.   L\'equivalente attuale è un network privato al quale tutti possono accedere per diventare membri.',
        'NO_MISSING_ITEMS' => 'Non ci sono articoli mancanti - questa traduzione è completa al 100%%.  <a %s>Visualizza tutti gli articoli. </a>',
        'NO_CHANGED_ITEMS' => 'Non ci sono articoli modificati.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Spiacenti - non siamo riusciti a trovare nessun articolo che corrisponda a <em>%s</em>.  <a %s>Visualizza tutti gli articoli. </a>',
        'FILE_N' => 'File %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Un file di traduzione Ning ha un nome file come <code>en_US. txt</code>.  <a %s>Ottieni altre informazioni qui. </a>',
        'SELECT_TRANSLATION_FILE' => 'Seleziona il file di traduzione:',
        'USE_THIS_TRANSLATION' => 'Usa questa traduzione',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Nota che i seguenti non rientrano nelle regole che trovi sotto: %s',
        'ALL' => 'Tutti',
        'MISSING' => 'Mancanti',
        'VIEW' => 'Visualizza',
        'TRANSLATION_CHANGES_SAVED' => 'Le tue modifiche sono state salvate.  Questa traduzione è %s%% completa.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Le modifiche sono state salvate. Questa traduzione è %s%% completa. Ti piacerebbe usare questa come lingua corrente per il tuo network?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Il caricamento è stato eseguito.  Questa traduzione è %s%% completa.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Il caricamento è stato eseguito. Questa traduzione è %s%% completa. Ti piacerebbe usarla come lingua corrente per il tuo network?',
        'X_IS_CURRENT_LANGUAGE' => '%s è adesso la lingua del tuo network.',
        'SAVE_PAGE' => 'Salva pagina',
        'LANGUAGE_NAME_TAKEN' => 'Spiacenti, quel nome non è disponibile.  Scegli un altro nome.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Inserisci un nome per la tua nuova traduzione, per esempio, portoghese (Portogallo)',
        'CREATE' => 'Crea',
        'LANGUAGE_NAME' => 'Name lingua',
        'SAVE_ITEMS_ON_PAGE' => 'Salva gli articoli su questa pagina',
        'NEW_TRANSLATION' => 'Nuova traduzione',
        'MISMATCHED_CURLY_BRACKETS' => 'Le parentesi graffe non sono appaiate',
        'MISMATCHED_SQUARE_BRACKETS' => 'Le parentesi quadre non sono appaiate',
        'MISMATCHED_PARENTHESES' => 'Parentesi non appaiate',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Si è verificato un errore durante l\'elaborazione del codice di Regole speciali.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Si è verificato un errore durante l\'elaborazione del codice dei Nomi delle schede.',
        'SPECIAL_RULES' => 'Regole speciali',
        'TAB_NAMES' => 'Nomi delle schede',
        'SOURCE' => 'Database di origine',
        'LANGUAGE_EDITOR_X' => 'Editor lingua: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Torna all\'Editor lingua',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Personalizza il testo e i messaggi del tuo network o crea una nuova lingua.',
        'STOPWORDS' => 'un | circa | uno | sono | come | in | essere | da | com | de | en | per | da | come | i | in | è | lo | la | di | su | o | quello | il | questo | a | era | che | quando | dove | chi | con | und | il | www',
        'STOPWORDS_ARE' => '<a %s>Stopword</a> sono una lista opzionale di parole da filtrare dalla descrizione del network quando vengono creati i meta tag nella parte superiore di ogni pagina.  Opzionale.',
        'I_AM_MEMBER' => 'Sono un membro di:',
        'VIEW_PAGE_ON_APPNAME' => 'Visualizza la mia pagina su <em>%s</em>',
        'VISIT_APPNAME' => 'Visita <em>%s</em>',
        'JOIN_US' => 'Unisciti a noi',
        'CREATED_BY_COLON' => 'Creato da:',
        'GET_MORE_BADGES' => 'Ottieni altri badge',
        'SHOW_LOGO' => 'Mostra logo',
        'GALLERY' => 'Galleria',
        'BADGES' => 'Badge',
        'MEMBER_BADGE' => 'Badge di membro',
        'WEAR_IT_WITH_PRIDE' => 'Esibiscilo con orgoglio!  Ottieni un %s badge di membro che può essere visualizzato sul tuo sito web o nella pagina di MySpace.',
        'NETWORK_BADGE_LARGE' => 'Badge del network (grande)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Passaparola!  Ottieni un %s badge che si aggiorna in maniera dinamica con i membri più popolari del network.  Aggiungilo sul tuo sito web o nella pagina di MySpace.',
        'NETWORK_BADGE_SMALL' => 'Badge del network (piccolo)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Passaparola!  Ottieni un %s badge che può visualizzare sul tuo sito web o nella pagina di MySpace.',
        'PHOTO_SLIDESHOW_PROPER' => 'Presentazione fotografie',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Visualizza una selezione di tue fotografie sul sito web o sulla tua pagina di MySpace con il nostro elegante lettore presentazioni.',
        'MUSIC_PLAYER' => 'Lettore musicale',
        'PLAY_MUSIC_ON_WEBSITE' => 'Riproduci la tua musica su un sito web o sulla tua pagina di MySpace con il nostro elegante lettore musicale.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Aggiungi un video sul tuo sito web o nella pagina di MySpace.  Stai cercando altre opzioni?  <a href="%s">Visualizza tutti i video</a> su %s.',
        'LARGE_N_PIXELS_WIDE' => 'Grande - %d pixel di ampiezza',
        'MEDIUM_N_PIXELS_WIDE' => 'Medio - %d pixel di ampiezza',
        'SMALL_N_PIXELS_WIDE' => 'Piccolo - %d pixel di ampiezza',
        'MY_MOST_RECENT' => 'I miei più recenti',
        'APP_ICON' => 'Icona applicazione',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'Si diventa membri di %s solo tramite invito',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s ha fatto i seguenti commenti e suggerimenti:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s ha fatto commenti e suggerimenti su %2$s...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Grazie.   Il tuo messaggio è stato inviato.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s desideri partecipare %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s ha richiesto un invito a %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'La tua richiesta è stata inviata al creatore del network.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Per debannare %s, vai a:',
        'SEND_REQUEST' => 'Invia richiesta',
        'SEARCH' => 'Cerca',
        'SEARCH_AGAIN' => 'Cerca un\'altra volta',
        'SEND_BROADCAST_MESSAGE' => 'Invia Messaggio broadcast',
        'VERIFICATION_IMAGE' => 'Immagine di verifica',
        'UNDER_CONSTRUCTION' => 'In costruzione',
        'PROFILE_INFORMATION_SAVED' => 'Informazioni sul profilo salvate',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'Le informazioni sul profilo nella directory del tuo Network sono state salvate.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Non c\'è un account con quell\'indirizzo di posta elettronica.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Password non corretta.   Il Bloc Maiusc è attivo?',
        'OOPS_THAT' => 'Oops, non ha funzionato.',
        'OOPS_THAT_DID_NOT_WORK' => 'Oops, non ha funzionato.   Riprovare?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Oops, non ha funzionato (%s).',
        'NOT_FOUND' => 'Non trovato',
        'YOUR_SITES_FEATURE_LIST' => 'L\'elenco di funzionalità  del tuo network è stato salvato.',
        'ONE_LINE_ANSWER' => 'Risposta di una riga',
        'LONGER_ANSWER' => 'Risposta più lunga',
        'MULTIPLE_CHOICE' => 'Scelta multipla',
        'DATE' => 'Data',
        'WEBSITE_ADDRESS' => 'Indirizzo del sito web',
        'EVERYTHING' => 'Tutto',
        'JUST_THE_HOMEPAGE' => 'Solo la pagina principale',
        'JUST_THE_SIGN_UP_PAGE' => 'Solo la pagina di registrazione',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Le tue modifiche sono state salvate.',
        'JOIN_ME_ON_X' => 'Partecipa con me su %s!',
        'NOT_ALLOWED' => 'Non consentito',
        'COME_JOIN_ME_ON_X' => 'Vieni ad unirti a me su %s!',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Vieni ad unirti a me su %s...',
        'X_NOT_VALID_EMAIL' => '%s non è un indirizzo di posta elettronica valido o un Ning ID',
        'USER_BANNED_FROM_NETWORK' => '%1$s è stato bannato da questo network.  <a %2$s>Invia %1$s un messaggio</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s è già un membro di questo network.  <a %2$s>Invia %1$s un messaggio</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Puoi inviare al massimo %s alla volta.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Inserisci gli indirizzi di posta elettronica dei tuoi amici o i Ning ID',
        'THERE_HAS_BEEN_AN_ERROR' => 'Si è verificato un errore',
        'INVITATIONS_HAVE_BEEN_SENT' => 'I tuoi inviti sono stati inviati.',
        'SEARCH_RESULTS' => 'Ricerca risultati',
        'INVITE_YOUR_FRIENDS' => 'Invita i tuoi amici',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Invita i tuoi amici',
        'INVITATION' => 'Invito',
        'ADD_FROM_ADDRESS' => 'Aggiungi da Rubrica',
        'TO' => 'A:',
        'SEND_TO' => 'Invia a',
        'SUBJECT' => 'Oggetto',
        'YOUR_MESSAGE' => 'Il tuo messaggio',
        'SEND' => 'Invia',
        'REPORT_AN_ISSUE' => 'Segnala un problema',
        'TYPE_OF_ISSUE' => 'Tipo di problema',
        'ADULT' => 'Adulto',
        'ABUSIVE' => 'Offensivo',
        'BUG' => 'Bug',
        'FRAUD' => 'Frode',
        'SPAM' => 'Spam',
        'OTHER' => 'Altro',
        'DESCRIBE_YOUR_ISSUE' => 'Descrivi il tuo problema',
        'SEND_REPORT' => 'Invia rapporto',
        'ADDED_BY_X_AT_X' => 'Aggiunto da <a %s>%s</a> in %s su %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Aggiunto da <a %s>%s</a> a %s in %s su %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Clicca per visualizzare',
        'COMMENT_FOR' => 'Commenta per:',
        'COMMENT_ON' => 'Commenta su:',
        'ACTION_BUTTON_FEATURE' => 'Presenta',
        'FEATURE_THIS_ON_YOUR' => 'Presenta questo sulla pagina principale',
        'ACTION_BUTTON_REMOVE' => 'Rimuovi',
        'REMOVE' => 'Rimuovi',
        'REMOVE_THIS_FROM_YOUR' => 'Rimuovi questo dalla pagina principale',
        'FEATURE_ON_HOME' => 'Presenta sulla Principale',
        'REMOVE_FROM_HOME' => 'Rimuovi dalla Principale',
        'ITEM_WILL_APPEAR' => 'Questo articolo apparirà  adesso sui moduli selezionati nella pagina principale',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Questo articolo non apparirà  più sui moduli selezionati nella pagina principale',
        'ADD_CONTENT' => 'Aggiungi contenuto',
        'BROUGHT_TO_YOU_BY' => '%s fornito da %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Mandaci i tuoi commenti e suggerimenti',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Per ulteriori domande o per metterti in contatto con Ning, fai clic qui:',
        'SEND_FEEDBACK' => 'Invia commenti e suggerimenti',
        'SIGN_OUT' => 'Disconnetti',
        'SIGN_OUT_TITLE' => 'Disconnetti',
        'EDIT_MY_PROFILE' => 'Modifica le risposte del profilo',
        'INVITE_MORE' => 'Invita altri',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Usa questo modulo per inviare commenti e suggerimenti a<a %s>%s</a>, il creatore di <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'I tuoi commenti e suggerimenti',
        'NETWORK_INFORMATION' => 'Informazioni sul network',
        'ABOUT_YOUR_SITE' => 'Informazioni sul tuo network',
        'WELCOME_TO_YOUR_SITE' => 'Benvenuto al tuo Social Network!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Modifica il nome del tuo network, la descrizione e altre informazioni.',
        'TAGLINE' => 'Tagline',
        'APPEARS_IN_HEADER' => 'Appare nell\'intestazione del tuo network',
        'APPEARS_IN_EMAILS' => 'Appare in messaggi di posta elettronica e altrove',
        'NETWORK_NAME' => 'Nome del Network',
        'DESCRIPTION' => 'Descrizione',
        'KEYWORDS' => 'parole chiave',
        'LANGUAGE' => 'Lingua',
        'SEPARATE_EACH_KEYWORD' => 'Separa ogni parola chiave con una virgola',
        'ICON' => 'Icona',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Carica una fotografia (GIF, JPG or PNG), la quale sarà ridimensionata a un quadrato.  Questa foto potrebbe impiegare qualche minuto a comparire.',
        'SAVE_SETTINGS' => 'Salva impostazioni',
        'SUCCESS_EXCLAMATION' => 'Operazione completata con successo!',
        'FEATURES' => 'Caratteristiche',
        'ADD_FEATURES' => 'Aggiungi caratteristiche al tuo network',
        'ORGANIZE_FEATURES' => 'Organizza la tua pagina principale trascinandovi caratteristiche dall\'elenco sottostante e disponendole secondo le tue preferenze.',
        'SKIP_FEATURES' => 'Clicca su <a href="%s">Salta questa operazione</a> per proseguire con il layout e le caratteristiche predefiniti.',
        'FEATURES_FOR_ALL_PAGES' => 'Le caratteristiche inserite in questa finestra compariranno su tutte le pagine del tuo network.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Personalizza il tuo social network aggiungendo nuove caratteristiche o rimuovendone di esistenti.',
        'ADJUST_YOUR_SITES_COLORS' => 'Modifica colori, immagini e stile del tuo network.',
        'APPEARANCE' => 'Aspetto',
        'PROFILE_QUESTIONS' => 'Domande del profilo',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Modifica le domande personali per i membri.',
        'MESSAGE_SENT' => 'Messaggio inviato!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Il messaggio è stato inviato a tutti i membri del tuo network.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Il messaggio è stato inviato a tutti i membri del tuo gruppo.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Il messaggio è in corso di invio.  Resta in attesa, potrebbe essere necessario qualche minuto.',
        'BROADCAST_MESSAGE' => 'Messaggio broadcast',
        'TRACK_VISITORS_AND_TRENDS' => 'Individua visitatori e tendenze nel tuo social network.',
        'EDIT_SOURCE_CODE' => 'Modifica il codice sorgente',
        'TAKE_FULL_CONTROL' => 'Assumi il controllo totale delle funzionalità  del tuo network modificando il codice sorgente.',
        'DELETE_THIS_SITE' => 'Elimina social network',
        'MAIN_PAGE' => 'Pagina principale',
        'MAIN' => 'Pagina principale',
        'MAIN_TAB_TEXT' => 'Pagina principale',
        'MANAGE' => 'Gestisci',
        'MANAGE_TAB_TEXT' => 'Gestisci',
        'PAGE_TITLE' => 'Titolo pagina',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit.  Nunc scelerisque blandit dolor.  Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Modifica l\'aspetto della tua pagina',
        'CHOOSE_A_THEME' => 'Scegli un tema per il tuo social network',
        'NOW_CUSTOMIZE_SITE' => 'Ora personalizza il tuo social network...',
        'THEME_SETTINGS' => 'Impostazioni tema',
        'ADVANCED' => 'Avanzato',
        'TOP_BAR_AND_FOOTER' => 'Barra superiore e piè di pagina',
        'HEADER_AND_NAVIGATION' => 'Intestazione e navigazione',
        'ADD_A_LOGO' => 'Aggiungi un logo',
        'THIS_IMAGE_WILL_REPLACE' => 'Questa immagine sostituirà  il testo con il nome del network',
        'TABS' => 'Schede',
        'TAB' => 'Scheda',
        'SITE' => 'Network',
        'SIDES' => 'Barre laterali',
        'BODY' => 'Corpo',
        'SHOW_NING_LOGO' => 'Visualizzare il logo Ning?',
        'LAUNCH' => 'AVVIA!',
        'NING_ID' => 'ID Ning',
        'PASSWORD' => 'Password',
        'RETYPE_PASSWORD' => 'Inserisci nuovamente la password',
        'TYPE_CODE_ON_RIGHT' => 'Digita il codice<br />sulla destra',
        'JOIN_X' => 'Partecipa a %s',
        'SIGN_UP_FOR_X' => 'Registrati per %s',
        'HAS_INVITED_YOU_TO_X' => 'ti ha invitato a partecipare a %s.',
        'CONTENT_AWAITING_APPROVAL' => 'In attesa di approvazione',
        'NEW_MEMBER' => 'Sei un nuovo membro?',
        'JOIN_X_NOW' => 'Partecipa a %s ora!',
        'HIDE_THIS_MESSAGE' => 'Nascondi questo messaggio',
        'PAGE_NOT_FOUND' => 'Pagina non trovata',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Siamo spiacenti, la pagina non è stata trovata',
        'FOLLOW_THESE_LINKS_TO' => 'Ecco alcuni link a opzioni già  disponibili:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'In alternativa, puoi effettuare una ricerca all\'interno di questo social network:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Se questo messaggio compare di nuovi, <a %s>comunicacelo. </a>',
        'GROUP_MEMBERS' => 'Membri del gruppo',
        'VIDEOS' => 'Video',
        'BLOG' => 'Blog',
        'ACCOUNT' => 'Account',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Siamo spiacenti, si sono verificati problemi con questa pagina.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Clicca su <a %s>questo link</a> per tornare alla pagina principale.',
        'REQUEST_AN_INVITATION' => 'Richiedi un invito',
        'NAME' => 'Nome',
        'EMAIL_ADDRESS' => 'Indirizzo e-mail',
        'MESSAGE_OPTIONAL' => 'Messaggio (facoltativo)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Siamo spiacenti! </strong>  Comunque è facile creare un social network tutto tuo.',
        'GET_YOUR_OWN_BAZEL' => 'Crea il tuo social network!',
        'SITE_IS_NOT_READY' => 'Questo social network non è ancora pronto!',
        'BAZEL_IS_BEING_SET_UP' => 'Questo social network è ancora in fase di impostazione!',
        'SIGN_IN' => 'Accedi',
        'FORGOT_YOUR_PASSWORD' => 'Hai dimenticato la password?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Hai dimenticato la password?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Inserisci il tuo indirizzo e-mail e clicca su "Reimposta password".  Riceverai un\'e-mail con un link per reimpostare la tua password.',
        'RESET_PASSWORD' => 'Reimposta password',
        'EXPLORE' => 'Esplora',
        'SIGN_UP' => 'Registrati',
        'CONFIRM_PASSWORD' => 'Conferma password',
        'VERIFICATION' => 'Dimostraci di essere <br />una persona in carne e ossa',
        'YOUR_PHOTO' => 'La tua foto',
        'SUMMARY' => 'Riepilogo',
        'YOUR_SITE_IS_READY' => 'Il tuo social network è pronto per essere avviato!   Per tutte le operazioni che hai saltato saranno utilizzate le impostazioni predefinite.  Torna indietro per effettuare cambiamenti o clicca su "Avvia! " per avviare il tuo network.',
        'WHEN_YOU_ARE_FINISHED' => 'Una volta terminato, clicca su "Visualizza layout" per ammirare la tua opera!',
        'COMPLETE' => 'completo',
        'INCOMPLETE' => 'incompleto',
        'VIEW_LAYOUT' => 'Visualizza layout',
        'CLEAR_CONTENTS' => 'Cancella contenuti',
        'ADD_MODULE' => 'Aggiungi modulo...',
        'ADD_COLUMNS' => 'Aggiungi colonne...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Pubblico</strong> - Chiunque può partecipare',
        'PRIVATE_ONLY_INVITED' => '<strong>Privata</strong> - Solo chi è autorizzato può visualizzarla e partecipare',
        'INVITATIONS' => 'Inviti',
        'MEMBERS_CAN_INVITE' => 'I membri possono invitare altre persone.',
        'QUESTION_TITLE' => 'Titolo domanda',
        'ANSWER_TYPE' => 'Tipo di risposta',
        'REQUIRED' => 'Obbligatoria',
        'PRIVATE' => 'Privato',
        'CHOICES' => 'Scelte',
        'SEPARATE_EACH_CHOICE' => 'Separa ciascuna scelta con una virgola',
        'CAN_PICK_MORE' => 'àˆ possibile selezionarne più di una',
        'ADD_ANOTHER_QUESTION' => 'Aggiungi un\'altra domanda',
        'WHAT_INFORMATION' => 'A quali domande vuoi che i membri rispondano quando entrano a far parte del tuo network?  Puoi riordinare le domande in basso.  È sufficiente cliccare sulla domanda e trascinarla dove vuoi che compaia.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Se selezioni "Obbligatoria", i membri dovranno rispondere a quella domanda per partecipare.  Se selezioni "Privata", la risposta sarà visibile esclusivamente a te e agli altri amministratori.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Non abbiamo trovato elementi che corrispondano a "%s".  Perché non cerchi qualcos\'altro?',
        'GET_CUSTOM_URL' => 'Ottieni un URL personalizzato, aumenta lo spazio di archiviazione e la banda o fai comparire le pubblicità  che scegli tu.',
        'TRACK_STATISTICS' => 'Pista statistiche',
        'TRACKING_CODE' => 'Codice tracking',
        'ANY_JAVASCRIPT_CODE' => 'Qualsiasi codice JavaScript incollato qui sarà inserito a piè di pagina in tutte le pagine del tuo network.  Puoi usarlo per sistemi di site tracking esterni, come Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Per saperne di più su Google Analytics e impostare il tuo account, <a %s>clicca qui</a>.',
        'RESOURCES' => 'Risorse',
        'LINKS' => 'Link',
        'PAGE' => 'Pagina',
        'BACKGROUND' => 'in Background',
        'TEXT' => 'Testo',
        'HEADING_TEXT' => 'Intestazione',
        'FONT' => 'Carattere',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Colore',
        'LINK_COLOR' => 'Colore link',
        'BODY_TEXT' => 'Corpo del testo',
        'MIDDLE' => 'Centro',
        'FEATURE_BOXES' => 'Finestre caratteristiche',
        'TITLEBAR_TEXT_COLOR' => 'Colore testo barra del titolo',
        'TITLEBAR_BACKGROUND' => 'Sfondo barra del titolo',
        'UPLOADING_CONTENT' => 'Caricamento contenuto in corso...',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Una volta completato il caricamento puoi dare un\'occhiata al network.',
        'FINISH' => 'Finalizza',
        'FLICKR_IMPORT_SETUP' => 'Impostazione importazione da Flickr',
        'FLICKR_API_KEY' => 'La tua chiave',
        'FLICKR_SECRET' => 'Il tuo segreto',
        'FLICKR_KEY_ERROR' => 'Si è verificato un problema con la chiave o il segreto Flickr che hai inserito.   Sei pregato di verificarli e inserirli nuovamente.',
        'FLICKR_INTRO' => 'Vuoi dare ai membri la possibilità di importare le loro foto da Flickr?  Sei nel posto giusto.  Se hai già una chiave API e di un segreto di Flickr, puoi <a %s>saltare all\'operazione successiva</a>.  Ti servono chiarimenti?  Segui la procedura in basso e sarai pronto in pochi minuti.',
        'FLICKR_GET_ACCOUNT' => 'Se non hai ancora un account Flickr, creane uno <a %s>qui</a>.',
        'FLICKR_STEP1_TITLE' => 'Operazione 1: Ottieni una chiave API Flickr',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Richiedi la schermata della chiave API su Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'Schermata della chiave API su Flickr',
        'FLICKR_STEP1_INTRO' => 'Accedi a Flickr e <a %s>richiedi una nuova chiave API</a> (si aprirà  in una nuova finestra).',
        'FLICKR_STEP1_A' => 'Inserisci il <strong>tuo nome</strong> e <strong>indirizzo e-mail</strong>.',
        'FLICKR_STEP1_B' => 'Sotto <strong>Questa chiave è per… </strong> seleziona l\'opzione <em>un uso non commerciale</em>.',
        'FLICKR_STEP1_C' => 'Descrivi il tuo social network nella finestra <strong>Descrivi l\'applicazione che intendi realizzare</strong>.',
        'FLICKR_STEP1_D' => 'Spunta entrambe le caselle in cui ti si chiede di accettare.',
        'FLICKR_STEP1_APPLY' => 'Una volta terminato clicca su <strong>Applica</strong>.',
        'FLICKR_STEP1_E' => 'Sarà visualizzata una schermata con la tua nuova chiave API.  Clicca sul link <strong>Clicca qui</strong> per configurare l\'autenticazione utente per questa chiave.',
        'FLICKR_STEP2_TITLE' => 'Operazione 2: Imposta la tua chiave',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Schermata di impostazione dell\'autenticazione della chiave API su Flickr',
        'FLICKR_STEP2_F' => 'Incolla il seguente indirizzo web nel campo <strong>URL di richiamo</strong>:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Una volta terminato clicca su <strong>Salva modifiche</strong>.',
        'FLICKR_STEP3_TITLE' => 'Operazione 3: Inserisci i tuoi dati',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Schermata dei dati della chiave API su Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Congratulazioni!  Il tuo account Flickr è stato impostato.',
        'FLICKR_STEP3_COMPLETE' => 'Per completare l\'impostazione su %s, copia e incolla chiave e segreto nei seguenti campi:',
        'COMPLETE_SETUP' => 'Impostazione completa',
        'SETUP_YOUR_SITE_TO' => 'Imposta il tuo social network per l\'importazione di foto da Flickr.',
        'FLICKR_IMPORTING' => 'Importazione da Flickr',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Devi impostare il tuo social network per permettere ai membri di importare foto da Flickr.  Bastano pochi minuti, perché non <a %s>ci pensi subito? </a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Non mostrarlo di nuovo.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Sei uscito da %s.  Torna presto a trovarci!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'ha creato questo social network su <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Crea il tuo social network su Ning gratuitamente!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Per rimuovere la caratteristica trascinala qui',
        'LAYOUT' => 'Layout',
        'DRAG' => 'Trascina',
        'HERE' => 'Qui',
        'YOU' => 'Tu',
        'ADS' => 'Pubblicità ',
        'MEMBERS' => 'Membri',
        'HELLO_USERNAME' => 'Ciao, Nomeutente',
        'CREATED_BY' => 'Creato da',
        'SAVE_FEATURES' => 'Salva caratteristiche',
        'FORUM' => 'Forum',
        'CATEGORIES' => 'Categorie',
        'FORUM_CATEGORIES' => 'Categorie del forum',
        'A_THREADED_DISCUSSION_FORUM' => 'Forum con discussione in thread',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Permetti ai membri di creare i propri gruppi di interesse all\'interno del tuo network',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Inserisci post del tuo blog o di quelli di altri membri',
        'TEXT_BOX' => 'Casella di testo',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Inserisci testo, un widget o HTML nella pagina principale',
        'A_LIST_OF_MEMBERS' => 'Elenco dei membri del tuo social network',
        'ALLOW_USERS_PHOTOS' => 'Permetti ai membri di caricare e condividere foto',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Aggiungi feed dal web',
        'INFORMATION_ABOUT_THE_USER' => 'Informazioni sulla persona che ha effettuato l\'accesso',
        'ALLOW_USERS_VIDEOS' => 'Permetti ai membri di aggiungere e condividere video',
        'SHOW_NETWORK_DESCRIPTION' => 'Mostra la descrizione del tuo network',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Promuovi il tuo network sul web con badge e widget personalizzati',
        'MONETIZE_WITH_ADS' => 'Metti a frutto il tuo network con la pubblicità ',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Consenti ai membri di vedere chi ha creato questo network',
        'FOLLOW_LATEST_ACTIVITY' => 'Segui le attività recenti dei membri sul tuo network',
        'FAQ_FOR_NETWORK_CREATORS' => 'Domande frequenti per gli autori di network',
        'ANSWERS_TO_FAQS' => 'Rispondi alle domande frequenti sulla personalizzazione del tuo social network.',
        'MEET_OTHER_LIKEMINDED' => 'Incontra altri autori di network come te, condividi idee e richiedi assistenza al team di Ning.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Personalizza l\'aspetto del tuo social network aggiungendo i tuoi fogli di stile a cascata (CSS) nel campo a sinistra.  (<a href="%s">Cosa sono i CSS? </a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Personalizza l\'aspetto della tua pagina aggiungendo i tuoi fogli di stile a cascata (CSS) nel campo a sinistra.  (<a href="%s">Cosa sono i CSS? </a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS sul tuo social network',
        'CSS_ON_YOUR_PAGE' => 'CSS sulla tua pagina',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Aggiungere i tuoi CSS ti permette di avere totale controllo su caratteri, colore, spaziatura e stile del tuo network.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Aggiungere i tuoi CSS ti permette di avere totale controllo su caratteri, colore, spaziatura e stile della tua pagina.',
        'CSS_STYLES_WILL_OVERRIDE' => 'Gli stili CSS che aggiungi qui subentreranno a eventuali stili CSS che hai scelto in precedenza.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Hai bisogno di aiuto per scoprire il nome di una classe CSS specifica sul tuo network?  Consigliamo la funzione "Inspect" dell\'estensione gratuita <a href="%s">Firebug</a> (per il browser Firefox).',
        'WANT_TO_LEARN_MORE' => 'Vuoi saperne di più?  Dà un\'occhiata alla nostra sezione <a href="%s">Personalizzazione avanzata</a>.',
        'APPLY_XS_THEME' => 'Applica il tema di %s',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'È già presente un ID Ning registrato con l\'indirizzo e-mail %s.  Per entrare, inserisci nello spazio sottostante il tuo ID Ning o indirizzo e-mail.  Se hai dimenticato la password, <a href="%s">clicca qui per reimpostarla</a>.',
        'INVITED' => 'Invitato',
        'REQUESTED_INVITE' => 'Invito richiesto',
        'BAN_FROM_NETWORK' => 'Banna dal network',
        'REMOVE_BAN' => 'Rimuovi ban',
        'CANCEL_INVITATION' => 'Cancella invito',
        'IGNORE' => 'Rifiuta',
        'PROMOTE_TO_ADMINISTRATOR' => 'Promuovi ad amministratore',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Rimuovi da amministratore',
        'STATUS' => 'Stato',
        'DATE_JOINED' => 'Data primo accesso',
        'DATE_INVITED' => 'Data invito',
        'DATE_REQUESTED' => 'Data richiesta',
        'DATE_APPLIED' => 'Data domanda',
        'NETWORK_CREATOR' => 'Creatore del network',
        'NETWORK_ADMINISTRATOR' => 'Amministratore',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Gli amministratori hanno un livello di controllo simile al creatore del network.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Esporta tutti i dati dei membri (. CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'I dati dei membri sono stati esportati.   Clicca con il tasto destro su <a %s>questo link</a> e seleziona "Salva con nome" per salvarlo sul tuo desktop.',
        'CLICK_GO_TO_START_EXPORT' => 'Clicca su Vai per avviare l\'esportazione.   Se sono presenti molti membri, l\'operazione potrebbe richiedere qualche minuto.',
        'MEMBER' => 'Membro',
        'INVITED_BY_X' => 'Invitato da %s',
        'DONE' => 'Fatto',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Sei stato bannato da %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Messaggio all\'amministratore',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Siamo spiacenti, %s, non puoi accedere a %s perchè sei stato bannato.  Se ritieni di essere stato bannato per errore, puoi contattare l\'amministratore.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Siamo spiacenti, %s, non puoi accedere a %s perchè sei stato bannato.',
        'SORRY_USERNAME' => 'Siamo spiacenti, %s',
        'PENDING' => 'In sospeso',
        'ACCEPT' => 'Accetta',
        'PENDING_APPROVAL' => 'In attesa di approvazione',
        'ACCEPT_MEMBERSHIP' => 'Accetta membership',
        'DECLINE_MEMBERSHIP' => 'Rifiuta membership',
        'NO_PAGE_YET' => 'Pagina ancora inesistente',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'La tua membership a %s è in attesa di approvazione da parte degli amministratori.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Iscrizione in corso di approvazione',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Il tuo profilo è in attesa di approvazione',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'I dati del tuo profilo devono essere approvati dall\'amministratore prima che tu possa diventare membro di %s.  Riceverai un\'e-mail quando il tuo profilo sarà stato approvato.',
        'CONTINUE_ARROW' => 'Continua → \'',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Torna ai membri in attesa di approvazione',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s è in attesa di approvazione per diventare membro di %s.',
        'VIEW_PAGE' => 'Visualizza pagina',
        'MESSAGE' => 'Messaggio',
        'SEND_MESSAGE' => 'Invia messaggio',
        'MANAGE_FORUM_CATEGORIES' => 'Gestisci le categorie del forum',
        'START_DISCUSSIONS' => 'Avvia discussioni',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Benvenuto nel tuo nuovo social network',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Ora non devi fare altro che <a %s>invitare i tuoi amici</a>!',
        'CONTRIBUTE' => 'Collabora.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Personalizza. </strong> Modifica <a %1$s>l\'aspetto del network</a> e crea <a %2$s>badge e widget</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Controlla. </strong> Nella pagina <a %s>gestisci</a> trovi una serie di opzioni di configurazione.',
        'CREATE_GROUPS' => 'Crea gruppi',
        'INVITE_MORE_PEOPLE' => 'Invita altre persone',
        'VIEW_THREAD' => 'Visualizza thread',
        'COMMENT_THREAD' => 'Commenta thread',
        'COMMENT_BACK' => 'Rispondi al commento',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Ciao! Devi abilitare JavaScript per usare questo network.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Verifica le impostazioni del tuo browser o contatta l\'amministratore di sistema.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Gestisci membri, amministratori, persone invitate e bannate.',
        'MANAGE_MEMBERS' => 'Gestisci membri',
        'MANAGE_INVITED_PEOPLE' => 'Gestisci persone invitate',
        'NETWORK_SETTINGS' => 'Impostazioni network',
        'PROMOTE_YOUR_NETWORK' => 'Promuovi il tuo network',
        'NING_RESOURCES' => 'Risorse Ning',
        'ADD_PREMIUM_SERVICES' => 'Aggiungi servizi premium',
        'REQUEST_SOURCE_CODE' => 'Richiedi accesso al codice sorgente',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Sei uno sviluppatore? Richiedi accesso al codice sorgente alla base del tuo network.',
        'JOIN_NETWORK_CREATORS' => 'Diventa autore di network',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Invia un messaggio a tutti i membri di questo network.',
        'CREATE_ANOTHER_NETWORK' => 'Crea un altro network',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Hai un\'altra grande idea per un social network?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Permetti agli utenti Facebook di inserire i widget del tuo network nelle pagine del proprio profilo.',
        'BADGES_AND_WIDGETS' => 'Badge e widget',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Personalizza l\'aspetto dei widget e dei badge del tuo network.',
        'GET_BADGES' => 'Ottieni badge',
        'CUSTOM_TEXT' => 'Testo personalizzato',
        'IM_A_MEMBER_OF' => 'Sono un membro di:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Non visualizzare alcuna caratterizzazione',
        'WATERMARK_OR_LOGO_IMAGE' => 'Filigrana o immagine logo:',
        'NETWORK_BRANDING_BADGES' => 'Caratterizzazione del network: badge',
        'NETWORK_BRANDING_WIDGETS' => 'Caratterizzazione del network: widget',
        'LOGO_IMAGE' => 'Immagine logo',
        'SMALL_NETWORK_BADGE' => 'Badge network piccolo',
        'LARGE_NETWORK_BADGE' => 'Badge network grande',
        'REFRESH' => 'Aggiorna',
        'HTML_EMBED_CODE' => 'Codice HTML incorporato:',
        'CUSTOMIZE' => 'Personalizza',
        'SHARE_TITLE' => 'Condividi "%s"',
        'SHARE_TYPE' => 'Condividi %s',
        'YOUR_MESSAGE_SENT' => 'Il tuo messaggio è stato inviato.',
        'YOUR_MESSAGES_SENT' => 'I tuoi messaggi sono stati inviati.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Puoi condividere questo %s in due modi&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Dà  un\'occhiata a questo %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Dà  un\'occhiata a questo %s',
        'PHOTO_ALBUM' => 'album fotografico',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Personalizza badge e widget con colori e immagini scelti da te.  Potranno essere necessarie fino a 4 ore perché le tue modifiche siano visibili su altri siti web.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Immagine e colore sfondo',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Usa questo modulo per segnalare un problema a <a %s>%s</a>, l\'autore di <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Siamo spiacenti, gli autori di network non possono cambiare indirizzo e-mail attraverso network non propri.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Siamo spiacenti, gli autori di network non possono cambiare password attraverso network non propri.',
        'GO' => 'Vai',
        'LARGE_THUMBNAILS' => 'Anteprima grande',
        'SMALL_THUMBNAILS' => 'Anteprima piccola',
        'RECENTLY_JOINED' => 'Più recente',
        'MOST_POPULAR_MEMBERS' => 'Più popolare',
        'NO_MEMBERS_TO_DISPLAY' => 'Attualmente non visualizzi alcun membro',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Questa finestra non sarà  visualizzabile da altri se non selezioni almeno una riga.',
        'DETAIL_VIEW' => 'Vista dettaglio',
        'TITLES_ONLY' => 'Solo titoli',
        'RECENTLY_ADDED_POSTS' => 'Aggiunto recentemente',
        'POPULAR_POSTS' => 'Maggior numero di commenti',
        'PROMOTED_POSTS' => 'Selezionato',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Questa finestra non sarà  visualizzabile da altri se non selezioni almeno un post.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Mantieni questa finestra del browser aperta durante il caricamento.',
        'CANCEL_UPLOAD' => 'Annulla caricamento',
        'YOU_DO_NOT_HAVE_POSTS' => 'Non hai ancora scritto alcun post.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Non hai alcun commento da approvare.',
        'REQUIRED_FIELD' => '(Campo obbligatorio)',
        'BLOG_POST_BY_X' => 'Post sul blog di %s',
        'HELLO' => 'Ciao,',
        'ADDED_BY_X' => 'Aggiunto da %s',
        'CLICK_TO_ADD_A_TITLE' => 'clicca per aggiungere un titolo',
        'DELETE_BLOG_POST' => 'Cancella post',
        'DELETE_THIS_BLOG_POST_Q' => 'Vuoi cancellare questo post sul blog?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Sei sicuro di voler cancellare questo post sul blog?  Questo processo potrebbe impiegare qualche minuto.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Inserisci qualcosa per: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Seleziona un\'opzione per: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Fornisci una data valida per: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Fornisci una data per: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => 'Post sul blog di %s per %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Post sul blog presenti per %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Post sul blog per %s %s',
        'FEATURED_BLOG_POSTS' => 'Post sul blog presenti',
        'EVERYONES_POSTS' => 'Post sul blog di tutti',
        'PUBLISHED_N_OF_N' => '%d pubblicato di %d',
        'DOWNLOAD_X' => 'Scarica %s',
        'UPLOAD_DID_NOT_WORK' => 'Siamo spiacenti, il caricamento non è andato a buon fine',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'j. M, Y',
        'XS_POSTS' => 'Post di %s',
        'USERNAMES_COMMENTS' => 'Commenti di %s',
        'ADD_COMMENT' => 'Aggiungi commento',
        'XS_PAGE' => 'Pagina di %s',
        'XS_BLOG' => 'Blog di %s',
        'XS_FRIENDS' => 'Amici di %s',
        'VIEW_XS_ELLIPSIS' => 'Visualizza i di %s\'s...',
        'DRAFT_BRACKETS' => '[ Bozza ]',
        'FEATURED' => 'Selezionato',
        'MY_POSTS' => 'I miei post',
        'MY_POSTS_ONLY' => 'Solo i miei post',
        'OWNER_POSTS_ONLY' => 'Solo i post dell\'autore',
        'JANUARY' => 'Gennaio',
        'FEBRUARY' => 'Febbraio',
        'MARCH' => 'Marzo',
        'APRIL' => 'Aprile',
        'MAY' => 'Maggio',
        'JUNE' => 'Giugno',
        'JULY' => 'Luglio',
        'AUGUST' => 'Agosto',
        'SEPTEMBER' => 'Settembre',
        'OCTOBER' => 'Ottobre',
        'NOVEMBER' => 'Novembre',
        'DECEMBER' => 'Dicembre',
        'MY_COMMENTS' => 'I miei commenti',
        'AM' => 'libreria AM (Analysis Management Objects)',
        'PM' => 'MP',
        'MY_PAGE' => 'La mia pagina',
        'MY_PAGE_TAB_TEXT' => 'La mia pagina',
        'BLOG_POSTS' => 'Post sul blog',
        'MY_BLOG' => 'Il mio blog',
        'MONTH' => 'Mese',
        'DAY' => 'Giorno',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Scegli un\'opzione valida per la visibilità  predefinita',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Scegli un\'opzione valida relativamente a chi può commentare',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Scegli un\'opzione valida per la moderazione dei commenti sul blog',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Scegli un\'opzione valida per la notifica delle attività ',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Scegli un\'opzione valida per la notifica delle attività  di moderazione',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Scegli un\'opzione valida per la notifica delle approvazioni',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Scegli un\'opzione valida per la notifica dell\'accesso di una persona invitata',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Scegli un\'opzione valida per non ricevere mai notifiche',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Scegli un\'opzione valida per la notifica delle richieste di amici',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Scegli un\'opzione valida per la notifica di nuovi messaggi',
        'APPROVE_COMMENT' => 'Approva commento',
        'MANAGE_BLOG' => 'Gestisci blog',
        'COMMENTS_POSTED_ON_BLOG' => 'Commenti postati sul mio blog',
        'COMMENT' => 'Commento',
        'COMMENTER' => 'Autore commento',
        'POST' => 'POST',
        'M_J_Y_G_IA' => 'j M, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Il post è stato cancellato',
        'COMMENTS_ARE_CLOSED' => 'I commenti per questo post sul blog sono bloccati',
        'NO_COMMENTS' => 'Nessun commento',
        'FLAG' => 'Contrassegno',
        'POST_TITLE' => 'Titolo post',
        'DRAFT_PARENTHESES' => '(Bozza)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Pubblicazione programmata il: %s',
        'EDIT_2' => 'modifica',
        'NONE' => 'Nessuno',
        'N_NEW' => '%s nuovo',
        'NO_POSTS' => 'Nessun post',
        'ADD_NEW_BLOG_POST' => 'Aggiungi un nuovo post sul blog',
        'HAPPY' => 'Felice',
        'SAD' => 'Triste',
        'COOL' => 'Fico',
        'EVIL' => 'Malvagio',
        'MAD' => 'Arrabbiato',
        'ENVIOUS' => 'Invidioso',
        'ENTRY' => 'Immissione',
        'WHAT_DATE_FOR_YOUR_POST' => 'Che data desideri per il tuo post?',
        'NOW' => 'Adesso',
        'CHOOSE_DATE_AND_TIME' => 'Scegli data e ora (se scegli una data nel futuro, il tuo post sarà  pubblicato in quella data)',
        'PRIVACY_AND_COMMENTS' => 'Privacy e commenti',
        'WHO_CAN_VIEW_POST' => 'Chi può vedere questo post?',
        'EVERYONE' => 'Tutti',
        'ALLOW_COMMENTS' => 'Vuoi consentire di commentare questo post?',
        'YES' => 'Si',
        'NO' => 'No',
        'COMMENT_MODERATION' => 'Moderazione commenti',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Stai moderando i commenti sul blog.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Non stai moderando i commenti sul blog.',
        'SAVE_AS_DRAFT' => 'Salva come bozza',
        'PREVIEW' => 'Anteprima',
        'PUBLISH_POST' => 'Pubblica post',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Questa è un\'anteprima di come sarà il tuo post sul blog una volta pubblicato.  Clicca su Indietro per modificarlo o su Pubblica se va bene così!',
        'BACK' => 'Indietro',
        'PUBLISH' => 'Pubblica!',
        'BLOG_POST' => 'Post (sul Blog)',
        'PROFILE' => 'Profilo',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Questa è una bozza non pubblicata',
        'WILL_BE_PUBLISHED_ON_X' => 'Sarà  pubblicata su %s <small>%s</small>',
        'POSTED_ON_X' => '<strong>%s</strong> <small>%s</small> postato',
        'POSTED_ON_X_BY' => '<strong>%s</strong> <small>%s</small> postato da:',
        'ABOUT_THIS_POST' => 'Informazioni su questo post',
        'ABOUT_YOUR_POST' => 'Informazioni sul tuo post',
        'ADDED_BY' => 'Aggiunto da:',
        'JUST_FRIENDS' => 'Solo amici',
        'RECENT_POSTS' => 'Post recenti',
        'THERE_ARE_NO_RECENT_POSTS' => 'Non ci sono post recenti.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Il tuo commento è stato aggiunto, ma deve essere approvato affinché tutti possano vederlo.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'Alle %s di %s, %s ha detto...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s per ora non ha amici in questo social network.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Per ora non hai amici in questo social network.',
        'EDIT_PAGE_APPEARANCE' => 'Modifica aspetto pagina',
        'VIEW_PAGE_AS_OTHERS' => 'Visualizza pagina come viene vista dagli altri',
        'ADD_BLOG_POST' => 'Aggiungi post sul blog',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Mantieni questa finestra del browser aperta durante la cancellazione dell\'intero contenuto di %s.  Questo processo potrebbe impiegare qualche minuto.',
        'BAN_MEMBER_FROM_NETWORK' => 'Banna membro dal network',
        'BAN_USERNAME' => 'Vuoi bannare %s?',
        'BLOCK' => 'bloccare',
        'CREATE_NEW_BLOG_POST' => 'Crea un nuovo post sul blog!',
        'EDIT_POST' => 'Modifica post',
        'EDIT_POST_COLON' => 'Modifica post:',
        'CONTINUE_READING' => 'Continua a leggere...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Inviato da <a %s>me</a> il %s alle %s —',
        'POSTED_BY_X_ON_X_AT_X' => 'Inviato da %s il %s alle %s —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Inviato da me il %s alle %s —',
        'ADD' => 'Aggiungi',
        'SUBSCRIBE' => 'Sottoscrivi',
        'VIEW_ARCHIVES' => 'Visualizza archivi',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Le tue impostazioni sono state salvate.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Correggi quanto segue:',
        'PRIVACY' => 'Privacy',
        'NETWORK_PRIVACY' => 'Privacy network',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Questo network è <strong>visibile a tutti</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Tutti possono registrarsi per diventare membri.  I visitatori possono…',
        'SEE_EVERYTHING' => 'Vedere tutto',
        'SEE_JUST_THE_MAIN_PAGE' => 'Vedere solo la pagina principale',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Vedere solo la pagina di registrazione',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Questo network è <strong>visibile solo ai membri</strong>.',
        'WHO_CAN_SIGN_UP' => 'Chi può registrarsi per diventare membro?',
        'MODERATION' => 'Moderazione',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Approva i nuovi membri per consentire loro di partecipare',
        'APPROVE_PHOTOS_VIDEOS' => 'Approva foto e video perchè possano apparire',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Mostra le attività recenti sul tuo network!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Inserisci nella pagina principale del tuo network un flusso sempre aggiornato delle attività  recenti.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Clicca qui per aggiungere le Attività Recenti al tuo network.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Queste opzioni sono disabilitate perchè non hai Attività Recenti sul tuo network.',
        'ACTIVITY' => 'Attività ',
        'DISPLAY_PREFERENCES' => 'Mostra preferenze',
        'NEW_CONTENT' => 'Nuovo contenuto',
        'NEW_COMMENTS' => 'Nuovi commenti',
        'NEW_MEMBERS' => 'Nuovi membri?',
        'MEMBER_UPDATES' => 'Aggiornamenti membri',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Cosa compare sul tuo network in<br />Attività Recenti?',
        'LATEST_ACTIVITY' => 'Attività Recenti',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s ha risposto alla discussione %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>ha risposto</a> alla discussione <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => '<a %1$s>Hai risposto</a> alla discussione <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s ha commentato il post sul blog %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>ha commentato</a> il post sul blog <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '<a %1$s>Hai commentato</a> il post sul blog <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s ha avviato una discussione intitolata %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Hai avviato una discussione intitolata %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s ha aggiunto il post sul blog "%s"',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Hai aggiunto il post sul blog "%s"',
        'X_JOINED_THE_GROUP_Y' => '%s è entrato a far parte del gruppo %s',
        'YOU_JOINED_THE_GROUP_X' => 'Sei entrato a far parte del gruppo %s',
        'X_JOINED_Y_GROUPS' => '%s è entrato a far parte dei gruppi %s',
        'YOU_JOINED_X_GROUPS' => 'Sei entrato a far parte dei gruppi %s',
        'X_JOINED_APPNAME' => '%s è entrato a far parte di %s.  <a %s>Lascia un messaggio</a> per %s.',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Benvenuto, %1$s!  Sei il membro #%2$s di %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Benvenuto, %1$s!  Sei il membro #%2$s di %3$s.  <a %4$s>Cerca subito degli amici</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s è il membro #%2$s di %3$s.',
        'XS_PROFILE_CHANGED' => 'Profilo di %s modificato',
        'YOUR_PROFILE_CHANGED' => 'Tuo profilo modificato',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s ha lasciato un commento per %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Hai lasciato un commento per %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s ha lasciato un commento per te',
        'X_CREATED_A_GROUP_Y' => '%s ha creato il gruppo %s',
        'YOU_CREATED_A_GROUP_Y' => 'Hai creato il gruppo %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s ha creato %s nuovi gruppi',
        'X_STARTED_Y_FORUM_POSTS' => '%s ha avviato %s nuove discussioni nel forum',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Hai avviato %s nuove discussioni nel forum',
        'X_ADDED_Y_BLOG_POSTS' => '%s ha aggiunto %s nuovi post sul blog',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Hai aggiunto %s nuovi post sul blog',
        'VIEW_XS_BLOG_POSTS' => 'Visualizza i post sul blog di %s',
        'VIEW_YOUR_BLOG_POSTS' => 'Visualizza i tuoi post sul blog',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s ha <a %s>nuove domande del profilo</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s ora ha un lettore musicale',
        'APPNAME_NOW_HAS_GROUPS' => '%s ora ha dei <a %s>gruppi</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s ora ha dei <a %s>video</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s ora ha un <a %s>forum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s ora ha delle <a %s>foto</a>',
        'DID_YOU_KNOW' => 'Lo sapevi che',
        'ANNOUNCEMENT' => 'Annuncio',
        'CONGRATULATIONS' => 'Complimenti',
        'YOU_CREATED_APPNAME' => 'Hai creato il network %s.',
        'USER_CREATED_APPNAME' => '%s ha creato il network %s.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Aggiungi messaggi e scegli cosa mostrare nel feed delle attività  del tuo network.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Quali azioni vuoi mostrare<br i>in Attività Recenti?',
        'NEW_CONTENT_I_ADD' => 'Nuovi contenuti aggiunti da me',
        'NEW_COMMENTS_I_ADD' => 'Nuovi commenti aggiunti da me',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Quando aggiorno il mio profilo',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Attività Recenti non mostrerà mai i messaggi che invii, le pagine o i membri che visualizzi, gli inviti che rifiuti, le persone che elimini o non accetti nell\'elenco dei tuoi amici o gli elementi che cancelli.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Non hai attività recenti. Perché non ti metti a fare qualcosa?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Hai disattivato la visualizzazione delle tue attività.  <a %s>Clicca qui per riattivarla. </a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'Il creatore del network ha disattivato la visualizzazione di tutte le attività .',
        'NO_ACTIVITY_TO_DISPLAY' => 'Attualmente non mostri alcuna attività .',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Questa finestra non sarà  visualizzabile da altri se non selezioni almeno un\'attività .',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Non ci sono attività recenti.  Perché non ti metti a fare qualcosa?',
        'MY_ACTIVITY_PREFERENCES' => 'Le mie preferenze attività ',
        'DELETE_ACTIVITY_ITEM' => 'Rimuovi messaggio attività ',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Vuoi rimuovere questo messaggio attività ?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Cià² impedirà  a chiunque di vedere questo messaggio attività ',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s ha postato il maggior numero di %2$sfoto%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s è la foto più popolare finora',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s ha postato il maggior numero di %2$svideo%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s è il video più popolare finora',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s ha postato il maggior numero di canzoni',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s è la canzone più popolare finora',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s è il post sul forum più popolare finora',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s è il post sul blog più popolare finora',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => 'Attività Recenti di %s su %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Attività Recenti su %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Aggiungi messaggio ad Attività Recenti',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Aggiungi fatti relativi al network...',
        'ADD_MESSAGE' => 'Aggiungi messaggio',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '... o scrivi un messaggio tuo',
        'NETWORK' => 'Network',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Chi è in grado di vedere le tue foto, video<br/> e post sul blog per impostazione predefinita?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Puoi ignorare questa impostazione per una foto, un video o un post sul blog quando la aggiungi).',
        'MODERATE_COMMENTS_ON_BLOG' => 'Vuoi approvare i commenti<br/>prima che appaiano sul tuo blog?',
        'YES_LET_ME_APPROVE' => 'Sì, voglio poter approvare i commenti',
        'NO_PUBLISH_COMMENTS' => 'No, pubblica i commenti direttamente',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Chi è in grado di commentare le tue foto,<br/> video e blog?',
        'SAVE' => 'Salva',
        'EMAIL' => 'E-mail',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'La tua privacy ci sta a cuore.  Se hai domande sulle notifiche via e-mail, inviacele attraverso l\'<a href="http://help.ning.com/?page_id=27">Help Center</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Aggiungi foto e video a %s inviandoli a questo indirizzo e-mail:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Aggiungi foto e video a %s dal tuo telefonino inviandoli a questo indirizzo e-mail:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Genera un nuovo indirizzo e-mail',
        'SUPPORTS_TEXT_EMBEDDED' => 'Supporta testo, video, foto e widget incorporati',
        'POST_COMMENT' => 'Posta commento',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Devi essere un membro di %s per aggiungere commenti!',
        'MONTHLY_ARCHIVES' => 'Archivi mensili',
        'NO_FRIENDS_ON_SITE' => 'Non ci sono ancora amici in questo social network.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Nessun amico in questo social network corrisponde ai tuoi criteri di ricerca.',
        'MEMBERS_TAB_TEXT' => 'Membri',
        'SITE_HAS_NO_MEMBERS' => 'Questo social network non ha ancora alcun membro!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Questo social network non ha ancora alcun membro che corrisponda ai tuoi criteri di ricerca.',
        'NO_COMMENTS_YET' => 'Ancora nessun commento!',
        'VIEW_ALL_COMMENTS' => 'Visualizza tutti i commenti!',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Non hai ancora aggiunto post sul blog!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Puoi scrivere su qualsiasi argomento, parlare dei video, delle foto e della musica che preferisci e incorporarli.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Scrivi il tuo primo post!',
        'THERE_ARE_NO_BLOG_POSTS' => 'Attualmente non ci sono post sui blog del tuo social network.',
        'THERE_ARE_NO_FEATURED_X' => 'Non ci sono %s sul tuo social network.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Non ci sono %s che corrispondano alle impostazioni che hai selezionato.',
        'START_FEATURING_X_CLICK_Y' => 'Inizia a inserire %s dove vedi l\'opzione Caratteristica.  Per saperne di più sulle caratteristiche, <a %s>clicca qui</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Questa finestra non sarà  visualizzabile da altri finchè non ci saranno post sui blog.  Perchè non ne aggiungi uno?',
        'YOUR_FRIEND' => 'Il tuo amico',
        'REQUEST_SENT' => 'Richiesta inviata!',
        'BLOCKED' => 'Bloccato',
        'BANNED' => 'Bannato',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Aggiungi il tuo primo post sul blog',
        'MY_FIRST_BLOG_POST' => 'Il mio primo post sul blog!',
        'TELL_THE_PEOPLE_ON' => 'Racconta ai membri di %s qualcos\'altro su di te.  Le domande contrassegnate da un <span %s>lucchetto</span> sono private e visibili solo agli amministratori.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Scegli un tema per la tua pagina',
        'NOW_CUSTOMIZE_PAGE' => 'Ora personalizza la tua pagina...',
        'NO_POSTS_TO_DISPLAY' => 'Non ci sono post da mostrare.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'Attualmente non mostri alcun post.',
        'DATE_COLON' => 'Data:',
        'TIME_COLON' => 'Ora:',
        'CHANGE' => 'Modifica',
        'UPLOAD_A_PHOTO' => 'Carica una fotografia',
        'OPTIONS' => 'Opzioni',
        'PIXELS' => 'Pixel',
        'CANCEL' => 'Annulla',
        'UPLOAD_A_FILE' => 'Carica un file:',
        'TO_INSERT_A_FILE' => 'Per inserire un file, clicca su "Sfoglia" o "Scegli" in alto per individuare il file sul tuo computer.',
        'UPLOADING' => 'Caricamento in corso...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Membri popolari',
        'INVITE_FRIENDS' => 'Invita amici',
        'VIEW_ALL' => 'Visualizza tutti',
        'REMOVE_X' => 'Rimuovi %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Sei sicuro di voler bannare %1$s dal tuo social network e cancellare tutti i contenuti che ha aggiunto?  Questo processo potrebbe impiegare qualche minuto.',
        'REMOVING_X' => 'Rimozione di %s in corso',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Sei sicuro di voler bannare il/i membro/i selezionato/i dal tuo social network e cancellare tutti i contenuti che hanno aggiunto?  Questo processo potrebbe impiegare qualche minuto.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Sei sicuro di voler bannare il/i membro/i selezionato/i dal tuo social network?  Questo processo potrebbe impiegare qualche minuto.',
        'BAN' => 'Banna',
        'REMOVING_MEMBERS' => 'Rimozione membri in corso',
        'FEMALE' => 'Femmina',
        'MALE' => 'Maschio',
        'UNITED_STATES' => 'Stati Uniti',
        'AND' => 'e',
        'FROM' => 'da',
        'GENDER_M' => 'Maschio',
        'GENDER_F' => 'Femmina',
        'XS_PAGE_ON_Y' => 'Pagina di %s su %s',
        'SEARCH_MEMBERS' => 'Cerca membri',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'qualcuno ha commentato un post sul blog che hai aggiunto a %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Hai un nuovo commento nella tua pagina.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Hai un nuovo commento nella tua pagina su %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Hai un nuovo commento nella tua pagina su %s...',
        'A_BLOG_POST' => 'un post sul blog',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Ora che sei diventato membro, <strong><a %s>invita i tuoi amici</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'Questo è il tuo profilo:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Inizia <a %s>personalizzandone l\'aspetto</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Usalo per <a %1$s>tenere un blog</a> e visualizzare le <a %2$s>tue risposte del profilo</a>.',
        'START_CONTRIBUTING' => 'Inizia a collaborare:',
        'UPLOAD_VIDEOS' => 'Carica video',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Collabora alle discussioni',
        'JOIN_GROUPS' => 'Partecipa ai gruppi',
        'ADD_A_BLOG_POST' => 'Aggiungi un post sul blog',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Clicca qui per visualizzare le tue richieste di amici.',
        'LEAVE_X' => 'Abbandona %s',
        'LEAVE_X_Q' => 'Vuoi abbandonare %s?',
        'ARE_YOU_SURE_LEAVE_X' => 'Sei sicuro di voler abbandonare %s e cancellare tutti i tuoi contenuti?  Questo processo potrebbe impiegare qualche minuto.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592;  Torna alla pagina di %s',
        'BACK_TO_MY_PAGE' => '&#8592;  Torna alla mia pagina',
        'COMMENT_WALL' => 'Spazio commenti',
        'ONLINE' => 'In linea',
        'MEMBER_IS_ONLINE' => 'Il membro è in linea',
        'ONLINE_NOW' => 'In linea ora',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Scegli chi può vedere, partecipare e collaborare al tuo network.',
        'EMAIL_NOTIFICATIONS' => 'Notifiche e-mail',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Per quali attività  del network vuoi ricevere notifiche via e-mail?',
        'NETWORK_MESSAGES' => 'Messaggi network',
        'MEMBER_ACTIVITY' => 'Attività  membri',
        'APPROVAL' => 'Approvazione',
        'FRIEND_REQUESTS' => 'Richieste di amici',
        'PEOPLE_IVE_INVITED_JOIN' => 'Persone che ho invitato a partecipare al network',
        'MESSAGES_SENT_TO_ME' => 'Messaggi inviati a me',
        'MESSAGES_SENT_TO_GROUPS' => 'Messaggi inviati a gruppi a cui appartengo',
        'MESSAGES_SENT_TO_NETWORK' => 'Messaggi inviati all\'intero network',
        'I_HAVE_NEW_COMMENTS' => 'Ho nuovi commenti da approvare',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Ho nuovi contenuti da approvare per il network',
        'CONTENT_ACTIVITY' => 'Attività  contenuti',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Attività  su elementi che ho aggiunto',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Segui automaticamente le discussioni a cui rispondo',
        'THINGS_IVE_ADDED_APPROVED' => 'Gli elemento che ho aggiunto sono stati approvati',
        'NOTIFICATIONS' => 'Notifiche',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Inviami un\'e-mail quando qualcuno risponde',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Non inviarmi un\'e-mail quando qualcuno risponde',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'Per smettere di seguire questa %s, <a %s>clicca qui</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Non stai più seguendo questa %s.',
        'NOTIFY' => 'Notifica',
        'STOP_NOTIFYING' => 'Interrompi le notifiche',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Inviami un\'e-mail quando ci sono nuove discussioni',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Non inviarmi e-mail quando ci sono nuove discussioni',
        'STOP_FOLLOWING_ALL' => 'Smetti di seguire tutte le discussioni e i commenti sui blog',
        'CHANGE_MY_PHOTO' => 'Cambia la foto',
        'COUNTRY_AF' => 'Afghanistan',
        'COUNTRY_AX' => 'Isole à…land',
        'COUNTRY_AL' => 'Albania',
        'COUNTRY_DZ' => 'Algeria',
        'COUNTRY_AS' => 'Samoa Americane',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antartide',
        'COUNTRY_AG' => 'Antigua e Barbuda',
        'COUNTRY_AR' => 'Argentina',
        'COUNTRY_AM' => 'Armenia',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australia',
        'COUNTRY_AT' => 'Austria',
        'COUNTRY_AZ' => 'Azerbaigian',
        'COUNTRY_BS' => 'Bahamas',
        'COUNTRY_BH' => 'Bahrain',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Bielorussia',
        'COUNTRY_BE' => 'Belgio',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermuda',
        'COUNTRY_BT' => 'Bhutan',
        'COUNTRY_BO' => 'Bolivia',
        'COUNTRY_BA' => 'Bosnia ed Erzegovina',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Isola Bouvet',
        'COUNTRY_BR' => 'Brasile',
        'COUNTRY_IO' => 'Territorio britannico dell\'Oceano indiano',
        'COUNTRY_BN' => 'Sultanato del Brunei',
        'COUNTRY_BG' => 'Bulgaria',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Cambogia',
        'COUNTRY_CM' => 'Camerun',
        'COUNTRY_CA' => 'Canada',
        'COUNTRY_CV' => 'Capo Verde',
        'COUNTRY_KY' => '"Cayman, Isole Cayman"',
        'COUNTRY_CF' => 'Repubblica Centrafricana',
        'COUNTRY_TD' => 'Ciad',
        'COUNTRY_CL' => 'Cile',
        'COUNTRY_CN' => 'Cina',
        'COUNTRY_CX' => 'Isola di Natale',
        'COUNTRY_CC' => 'Isole Cocos (Keeling)',
        'COUNTRY_CO' => 'Colombia',
        'COUNTRY_KM' => 'Comore',
        'COUNTRY_CG' => 'Congo, Repubblica del',
        'COUNTRY_CD' => 'Congo, Repubblica Democratica del',
        'COUNTRY_CK' => 'Isole Cook',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Costa d\'Avorio',
        'COUNTRY_HR' => 'Croazia',
        'COUNTRY_CU' => 'Cuba',
        'COUNTRY_CY' => 'Cipro',
        'COUNTRY_CZ' => 'Repubblica Ceca',
        'COUNTRY_DK' => 'Danimarca',
        'COUNTRY_DJ' => 'Gibuti',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'Repubblica dominicana',
        'COUNTRY_EC' => 'Ecuador',
        'COUNTRY_EG' => 'Egitto',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_GQ' => 'Guinea Equatoriale',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_EE' => 'Estonia',
        'COUNTRY_ET' => 'Etiopia',
        'COUNTRY_EU' => 'Unione Europea',
        'COUNTRY_FK' => 'Isole Falkland',
        'COUNTRY_FO' => 'Fà¦r à˜er',
        'COUNTRY_FJ' => 'Figi',
        'COUNTRY_FI' => 'Finlandia',
        'COUNTRY_FR' => 'Francia',
        'COUNTRY_GF' => 'Guayana francese',
        'COUNTRY_PF' => 'Polinesia Francese',
        'COUNTRY_TF' => 'Territori francesi meridionali',
        'COUNTRY_GA' => 'Gabon',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GE' => 'Georgia',
        'COUNTRY_DE' => 'Germania',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibilterra',
        'COUNTRY_GR' => 'Grecia',
        'COUNTRY_GL' => 'Groenlandia',
        'COUNTRY_GD' => 'Grenada',
        'COUNTRY_GP' => 'Guadalupa',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guinea',
        'COUNTRY_GW' => 'Guinea-Bissau',
        'COUNTRY_GY' => 'Guyana',
        'COUNTRY_HT' => 'Haiti',
        'COUNTRY_HM' => 'Heard e McDonald',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Ungheria',
        'COUNTRY_IS' => 'Islanda',
        'COUNTRY_IN' => 'India',
        'COUNTRY_ID' => 'Indonesia',
        'COUNTRY_IR' => 'Iran, Repubblica Islamica dell\'',
        'COUNTRY_IQ' => 'Iraq',
        'COUNTRY_IE' => 'Irlanda',
        'COUNTRY_IL' => 'Israele',
        'COUNTRY_IT' => 'Italia',
        'COUNTRY_JM' => 'Giamaica',
        'COUNTRY_JP' => 'Giappone',
        'COUNTRY_JO' => 'Giordania',
        'COUNTRY_KZ' => 'Kazakistan',
        'COUNTRY_KE' => 'Kenya',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Corea, Repubblica Democratica Popolare di',
        'COUNTRY_KR' => 'Corea, Repubblica di',
        'COUNTRY_KW' => 'Kuwait',
        'COUNTRY_KG' => 'Kirghizistan',
        'COUNTRY_LA' => 'Laos',
        'COUNTRY_LV' => 'Lettonia',
        'COUNTRY_LB' => 'Libano',
        'COUNTRY_LS' => 'Lesotho',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LY' => 'Libia',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Lituania',
        'COUNTRY_LU' => 'Lussemburgo',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Macedonia, Repubblica di',
        'COUNTRY_MG' => 'Madagascar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malaysia',
        'COUNTRY_MV' => 'Maldive',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Isole Marshall',
        'COUNTRY_MQ' => 'Martinica',
        'COUNTRY_MR' => 'Mauritania',
        'COUNTRY_MU' => 'Mauritius',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'Messico',
        'COUNTRY_FM' => 'Micronesia, Stati Federati di',
        'COUNTRY_MD' => 'Moldavia',
        'COUNTRY_MC' => 'Monaco',
        'COUNTRY_MN' => 'Mongolia',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Marocco',
        'COUNTRY_MZ' => 'Mozambico',
        'COUNTRY_MM' => 'Birmania',
        'COUNTRY_NA' => 'Namibia',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Paesi Bassi',
        'COUNTRY_AN' => 'Antille olandesi',
        'COUNTRY_NC' => 'Nuova Caledonia',
        'COUNTRY_NZ' => 'Nuova Zelanda',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Isola Norfolk',
        'COUNTRY_MP' => 'Marianne Settentrionali',
        'COUNTRY_NO' => 'Norvegia',
        'COUNTRY_OM' => 'Oman',
        'COUNTRY_PK' => 'Pakistan',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Palestina',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PG' => 'Papua Nuova Guinea',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Perù',
        'COUNTRY_PH' => 'Filippine',
        'COUNTRY_PN' => 'Isole Pitcairn',
        'COUNTRY_PL' => 'Polonia',
        'COUNTRY_PT' => 'Portogallo',
        'COUNTRY_PR' => 'Portorico',
        'COUNTRY_QA' => 'Qatar',
        'COUNTRY_RE' => 'Riunione',
        'COUNTRY_RO' => 'Romania',
        'COUNTRY_RU' => 'Federazione Russa',
        'COUNTRY_RW' => 'Ruanda',
        'COUNTRY_SH' => 'Saint Helena',
        'COUNTRY_KN' => 'Saint Christopher e Nevis',
        'COUNTRY_LC' => 'Santa Lucia',
        'COUNTRY_PM' => 'Saint-Pierre and Miquelon',
        'COUNTRY_VC' => 'Saint Vincent e Grenadine',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Sà£o Tomè e Prà­ncipe',
        'COUNTRY_SA' => 'Arabia Saudita',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Serbia e Montenegro',
        'COUNTRY_SC' => 'Seychelles',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SG' => 'Singapore',
        'COUNTRY_SK' => 'Slovacchia',
        'COUNTRY_SI' => 'Slovenia',
        'COUNTRY_SB' => 'Isole Salomone',
        'COUNTRY_SO' => 'Somalia',
        'COUNTRY_ZA' => 'Sudafrica',
        'COUNTRY_GS' => 'Georgia del Sud e isole Sandwich meridionali',
        'COUNTRY_ES' => 'Spagna',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Sudan',
        'COUNTRY_SR' => 'Suriname',
        'COUNTRY_SJ' => 'Svalbard e isola Jan Mayen',
        'COUNTRY_SZ' => 'Swaziland',
        'COUNTRY_SE' => 'Svezia',
        'COUNTRY_CH' => 'Svizzera',
        'COUNTRY_SY' => 'Siria, Repubblica Araba di',
        'COUNTRY_TW' => 'Taiwan',
        'COUNTRY_TJ' => 'Tagikistan',
        'COUNTRY_TZ' => 'Tanzania, Repubblica Unita di',
        'COUNTRY_TH' => 'Thailandia',
        'COUNTRY_TL' => 'Timor Est',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad e Tobago',
        'COUNTRY_TN' => 'Tunisia',
        'COUNTRY_TR' => 'Turchia',
        'COUNTRY_TM' => 'Turkmenistan',
        'COUNTRY_TC' => 'Turks e Caicos',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ucraina',
        'COUNTRY_AE' => 'Emirati Arabi Uniti',
        'COUNTRY_GB' => 'Regno Unito',
        'COUNTRY_US' => 'Stati Uniti',
        'COUNTRY_UM' => 'Altre isole americane del Pacifico',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Uzbekistan',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Città  del Vaticano',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VG' => 'Isole Vergini britanniche',
        'COUNTRY_VI' => 'Isole Vergini americane',
        'COUNTRY_WF' => 'Wallis e Futuna',
        'COUNTRY_EH' => 'Sahara Occidentale',
        'COUNTRY_YE' => 'Yemen',
        'COUNTRY_ZM' => 'Zambia',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Registro errori',
        'CANNOT_READ_ERROR_LOG' => 'Impossibile leggere il registro errori',
        'CANNOT_OPEN_ERROR_LOG' => 'Impossibile aprire il registro errori',
        'CANNOT_SCAN_ERROR_LOG' => 'Impossibile effettuare la scansione del registro errori',
        'MODELS_RESET' => 'Reimpostazione modelli:',
        'NO_MODELS_RESET' => 'nessuna reimpostazione modelli.',
        'NO_FEED_TO_DISPLAY' => 'Attualmente non mostri alcun elemento.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Questa finestra non sarà  visualizzabile da altri se non selezioni almeno un elemento.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Clicca su Modifica per specificare il feed RSS per questa finestra.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Si è verificato un problema nel recuperare questo feed RSS.',
        'MORE_ELLIPSIS' => 'Altro...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Siamo spiacenti, questo sito presenta un problema.',
        'PLEASE_TRY_REFRESHING' => 'Prova ad aggiornare la pagina fra 30 secondi o <a %s>informaci</a> se viene visualizzato nuovamente questo messaggio.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Non ci sono discussioni con tag "%1$s".',
        'PAGE_TITLE_COLON' => 'Titolo pagina:',
        'PAGE_CONTENT' => 'Contenuto:',
        'CREATE_PAGE' => 'Crea pagina',
        'CREATE_NEW_PAGE' => 'Crea una nuova pagina',
        'YOUR_COMMENT' => 'Il tuo commento',
        'ADD_YOUR_COMMENT' => 'Aggiungi il tuo commento',
        'DELETE_PAGE' => 'Elimina questa pagina',
        'DELETE_THIS_PAGE_Q' => 'Eliminare questa pagina?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Sei sicuro di voler eliminare questa pagina (inclusi tutti i commenti)?  Questo processo potrebbe impiegare qualche minuto.',
        'SEARCH_PAGES' => 'Cerca pagine',
        'ALL_PAGES' => 'Tutte le pagine',
        'SUBSCRIBE_TO_PAGES' => 'Sottoscrivi queste pagine',
        'NOBODY_HAS_ADDED_PAGES' => 'Nessuno ha ancora aggiunto pagine!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Crea una pagina per cominciare.',
        'CREATE_A_PAGE' => 'Crea una pagina',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Inserisci il contenuto della pagina',
        'SEARCH_RESULTS_FOR_X' => 'Cerca risultati per <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Modifica la tua pagina',
        'UPDATE_PAGE' => 'Aggiorna pagina',
        'CLOSE_DISCUSSION' => 'Chiudi discussione',
        'REOPEN_DISCUSSION' => 'Riapri discussione',
        'CLOSING_DISCUSSION_PREVENTS' => 'Chiudere una discussione impedisce ulteriori risposte',
        'NO_DISCUSSION_TO_DISPLAY' => 'Attualmente non mostri alcuna discussione.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Questa finestra non sarà  visualizzabile da altri se non selezioni almeno una discussione.',
        'NEWEST_DISCUSSIONS' => 'Discussioni recenti',
        'LATEST_REPLIES' => 'Risposte recenti',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Le risposte a questa discussione sono chiuse.',
        'SORRY_DISCUSSION_CLOSED' => 'Siamo spiacenti, ma questa discussione è appena stata chiusa.',
        'MOST_REPLIES' => 'Massimo numero di risposte',
        'OWNER_DISCUSSIONS_ONLY' => 'Solo le discussioni dell\'autore',
        'MY_DISCUSSIONS_ONLY' => 'Solo le mie discussioni',
        'DISCUSSION_DELETED' => 'Discussione cancellata',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Questa discussione non è più disponibile.',
        'REPLY_DELETED' => 'Risposta eliminata',
        'REPLY_HAS_BEEN_DELETED' => 'Questa risposta è stata eliminata.  <a %s>Torna alla discussione. </a>',
        'VIEW_ALL_DISCUSSIONS' => 'Visualizza tutte le discussioni',
        'ADD_CATEGORIES' => 'Aggiungi categorie',
        'CATEGORY' => 'Categoria:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'Non ci sono ancora discussioni in questa categoria.',
        'ADD_MANAGE_CATEGORIES' => 'Aggiungi/Gestisci categorie',
        'VIEW_ALL_N_CATEGORIES' => 'Visualizza tutte le categorie %s',
        'UNTITLED_CATEGORY' => 'Categoria senza titolo',
        'SAMPLE_TITLE' => 'Titolo di esempio',
        'UNCATEGORIZED' => 'Fuori categoria',
        'EXISTING_DISCUSSIONS' => 'Discussioni esistenti a cui non è stata assegnata una categoria.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Attualmente non ci sono categorie.  Aggiungi una categoria per iniziare!',
        'ADD_A_CATEGORY' => 'Aggiungi una categoria',
        'ADD_ANOTHER_CATEGORY' => 'Aggiungi un\'altra categoria',
        'MANAGE_CATEGORIES' => 'Gestisci le categorie',
        'CATEGORY_TITLE' => 'Titolo categoria',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Consenti ai membri di avviare discussioni in questa categoria',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Solo io posso avviare discussioni in questa categoria',
        'ALLOW_MEMBERS_TO_REPLY' => 'Consenti ai membri di rispondere',
        'SUGGESTIONS' => 'Suggerimenti:',
        'TRY_DIFFERENT_KEYWORDS' => 'Prova con parole chiave diverse o più generiche',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Visualizza tutte le discussioni</a> o <a %s>Avvia una nuova discussione</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Accertati che tutte le parole siano scritte correttamente',
        'REPLY_WAS_DELETED' => 'Questa risposta è stata cancellata',
        'TAGS_X' => '<strong>Tag:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Invia messaggio privato',
        'PERMALINK_TO_REPLY' => 'Permalink a questa risposta',
        'PERMALINK' => 'Permalink',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Siamo spiacenti, non abbiamo trovato discussioni che corrispondano alla tua ricerca.',
        'DISCUSSIONS_MATCHING_X' => 'Discussioni corrispondenti a <em>"%s"</em>',
        'SEARCH_DISCUSSIONS' => 'Cerca discussioni',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Non hai ancora aggiunto discussioni!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Aggiungi discussioni e condividile con amici, familiari o altre persone in tutto il mondo!',
        'DISCUSSION' => 'Discussione',
        'DISCUSSIONS' => 'Discussioni',
        'KEEP_PAGE_OPEN_FORUM' => 'Mantieni aperta questa pagina per permetterci di completare il caricamento dei tuoi file sul forum.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Nel frattempo, puoi <a %s>aprire una nuova finestra del browser</a> e continuare ad usare %s.',
        'START_A_NEW_DISCUSSION' => 'Avvia una nuova discussione',
        'DISCUSSION_TITLE' => 'Titolo discussione',
        'FIRST_POST' => 'Post:',
        'UPLOAD_FILES' => 'Allega file:',
        'START_DISCUSSION' => 'Avvia discussione',
        'EDIT_DISCUSSION' => 'Modifica discussione',
        'START_A_DISCUSSION' => 'Avvia una discussione',
        'ALL_DISCUSSIONS' => 'Home page forum',
        'CONTRIBUTORS' => 'Collaboratori',
        'MY_DISCUSSIONS' => 'Le mie discussioni',
        'READ_MORE' => 'Continua a leggere',
        'STARTED_T_BY' => 'Avviata <strong>%s</strong> da:',
        'ADDED_BY_X_T' => 'Aggiunta da %s',
        'STARTED_BY_X_T' => 'Avviata da %s %s',
        'REPLY_BY_X_T' => 'Risposta di <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Avviata da %s.  Ultima <a %s>risposta</a> di %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Ha avviato questa discussione. </strong> Ultima <a %s>risposta</a> di %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>Ha avviato questa discussione</strong> %s',
        'ADDED_REPLY_T' => '<strong>Ha aggiunto una risposta</strong> %s',
        'ADDED_POST_T' => '<strong>Ha aggiunto un post</strong> %s',
        'STARTED_BY_X_ON' => 'Avviata da %s su %s',
        'STARTED_DISCUSSION_ON' => '<strong>Ha avviato questa discussione</strong> %s',
        'STARTED_ON' => '<strong>Avviata</strong> %s',
        'ADDED_REPLY_ON' => '<strong>Ha aggiunto una risposta</strong> %s',
        'ADDED_POST_ON' => '<strong>Ha aggiunto un post</strong> %s',
        'XS_DISCUSSIONS' => 'Discussioni di %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'Discussioni di %s',
        'VIEW_XS_DISCUSSIONS' => 'Visualizza discussioni di %s',
        'VIEW_YOUR_DISCUSSIONS' => 'Visualizza le tue discussioni',
        'TAGGED_X' => 'Taggata: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Sottoscrivi queste discussioni',
        'SUBSCRIBE_TO_DISCUSSION' => 'Sottoscrivi questa discussione',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Sottoscrivi le discussioni di %s',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Tutte le discussioni taggate <em>"%s"</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Sottoscrivi le discussioni taggate "%s"',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Caricamento file',
        'ATTACHMENTS' => 'Allegati',
        'YOUR_POST' => 'Il tuo post:',
        'YOUR_REPLY' => 'La tua risposta:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Desideri caricare dei file?',
        'ADD_YOUR_REPLY' => 'Aggiungi la tua risposta',
        'REPLIES_TO_THIS_DISCUSSION' => 'Risposte a questa discussione',
        'POSTED_BY_X_ON' => 'Postata da %s %s',
        'PLEASE_ENTER_TITLE' => 'Inserisci un titolo per la discussione',
        'PLEASE_ENTER_FIRST_POST' => 'Scrivi il primo post della discussione.',
        'REPLY_TO_THIS' => 'Rispondi',
        'DELETE_ATTACHMENT' => 'Elimina allegato',
        'DELETE_ATTACHMENT_Q' => 'Vuoi eliminare l\'allegato?',
        'DELETE_REPLY' => 'Elimina risposta',
        'DELETE_THIS_DISCUSSION_Q' => 'Vuoi eliminare questa discussione?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Sei sicuro di voler eliminare questa discussione (incluse tutte le risposte)?  Questo processo potrebbe impiegare qualche minuto.',
        'DELETE_DISCUSSION' => 'Elimina discussione',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Nessuno ha ancora aggiunto discussioni.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Nessuno ha ancora aggiunto discussioni!  Aggiungi una discussione per cominciare.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Non hai ancora aggiunto discussioni.  Aggiungi una discussione per cominciare!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Non hai ancora avviato discussioni.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Non hai ancora contribuito ad alcuna discussione.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s non ha ancora aggiunto discussioni.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s non ha ancora avviato discussioni.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s non ha ancora contribuito ad alcuna discussione.',
        'VIEW_DISCUSSIONS' => 'Visualizza discussioni',
        'VIEW_ALL_PEOPLE_ON_X' => 'Visualizza tutte le persone in %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'Attualmente non ci sono discussioni sul tuo network.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Questo gruppo non ha ancora discussioni.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Visualizza le discussioni nel <a %s>forum %s</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Non ci sono discussioni con tag "%1$s".  Dai un\'occhiata alle <a %2$s>foto taggate "%1$s"</a> o ai <a %3$s>video taggati "%1$s"</a>.  O aggiungi e tagga discussioni in prima persona!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Non ci sono discussioni con tag "%1$s".  Dai un\'occhiata alle <a %2$s>foto taggate "%1$s"</a> o ai <a %3$s>video taggati "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Questa finestra non sarà visualizzabile da altri finché non ci saranno discussioni da mostrare.  Perché non ne avvii una?',
        'DISCUSSIONS_I_STARTED' => 'Discussioni avviate da me',
        'DISCUSSIONS_X_STARTED' => 'Discussioni avviate da %s',
        'DISCUSSIONS_I_REPLIED_TO' => 'Discussioni a cui ho risposto',
        'DISCUSSIONS_X_REPLIED_TO' => 'Discussioni a cui %s ha risposto',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Scrivi qualcosa per il tuo post.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Scrivi qualcosa per la tua risposta.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'C\'è un nuovo commento alla tua discussione "%s" in %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'C\'è un nuovo commento alle tue discussioni in %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'qualcuno ha commentato una discussione che hai avviato in %s',
        'ABOUT_YOUR_DISCUSSION' => 'Informazioni sulla tua discussione',
        'ABOUT_THIS_DISCUSSION' => 'Informazioni su questa discussione',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s ha risposto a una discussione in %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s ha risposto alla discussione "%s" in %s',
        'PROBLEM_WITH_ICON' => 'Si è verificato un problema con il file icona',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Gli amministratori del gruppo hanno un livello di controllo simile all\'autore del gruppo.',
        'CREATE_NEW_GROUP' => 'Crea nuovo gruppo',
        'CREATE_A_NEW_GROUP' => 'Crea un nuovo gruppo',
        'CREATE_A_GROUP' => 'Crea un gruppo',
        'VIEW_GROUPS' => 'Visualizza gruppi',
        'CREATE_GROUP' => 'Crea gruppo',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Scegli un nome per il tuo gruppo.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Scegli un indirizzo Web per il tuo gruppo.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'L\'indirizzo Web può contenere solo lettere e numeri (non spazi).',
        'NAME_TAKEN' => 'Spiacenti, quel nome non è disponibile.  Scegli un altro nome.',
        'URL_TAKEN' => 'Spiacente, quell\'indirizzo Web non è disponibile.  Scegli un altro indirizzo Web.',
        'GROUP_INFORMATION' => 'Informazioni gruppo',
        'EXTERNAL_WEBSITE' => 'Sito web esterno',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Il gruppo ha un altro sito web?',
        'URL' => 'URL',
        'GROUPS' => 'Gruppi',
        'SEARCH_GROUPS' => 'Cerca gruppi',
        'NOBODY_HAS_CREATED_GROUPS' => 'Nessuno ha ancora creato altri gruppi.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Nessuno ha ancora creato altri gruppi!  Crea un gruppo per cominciare.',
        'MY_GROUPS' => 'I miei gruppi',
        'FEATURED_GROUPS' => 'Gruppi presenti',
        'YOU_CAN_CREATE_GROUP' => 'Puoi <a %s>creare un nuovo gruppo</a> in %s!',
        'GROUP_FORUM' => 'Forum %s',
        'USER_CREATED_GROUP' => '%s ha creato questo gruppo in %s.',
        'GROUP_MEMBERS_COUNT' => 'Membri %s (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Siamo spiacenti, non permesso sei autorizzato a entrare in questo gruppo.',
        'JOIN_GROUP_NOW' => 'Partecipa a %s ora!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s ti ha invitato a entrare in %s.',
        'DECLINE' => 'Rifiuta',
        'WELCOME_TO_GROUP' => 'Benvenuti a %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Ora puoi partecipare al forum %s.',
        'SEND_MESSAGE_TO_GROUP' => 'Invia messaggio al gruppo',
        'LEAVE_THIS_GROUP' => 'Abbandona gruppo',
        'EDIT_GROUP_INFO' => 'Modifica informazioni gruppo',
        'EDIT_GROUP_INFORMATION' => 'Modifica informazioni gruppo',
        'MANAGE_GROUP_MEMBERS' => 'Gestisci membri gruppo',
        'GROUP_HAS_NO_MEMBERS' => 'Questo gruppo non ha ancora alcun membro!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Questo gruppo non ha alcun membro che corrisponda ai tuoi criteri di ricerca.',
        'USERS_GROUPS' => 'Gruppi di %s',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Non hai ancora creato alcun gruppo.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s non ha ancora creato alcun gruppo.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Non ci sono gruppi presenti nel tuo social network.',
        'START_FEATURING_GROUPS' => 'Inizia a inserire gruppi dove vedi l\'opzione Caratteristica.  Per saperne di più sulle caratteristiche, <a %s>clicca qui</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'Attualmente non mostri alcun gruppo.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Questa finestra non sarà  visualizzabile da altri se non selezioni almeno un gruppo.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Non hai ancora creato alcun gruppo!',
        'CREATE_GROUPS_AND_SHARE' => 'Crea gruppi e condividili con amici, familiari o altre persone in tutto il mondo!',
        'THERE_ARE_NO_GROUPS' => 'Attualmente non ci sono gruppi nel tuo network.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Questa finestra non sarà  visualizzabile da altri finchè non ci saranno gruppi da mostrare.  Perchè non ne crei uno?',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Gruppi corrispondenti a <em>"%s"</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Siamo spiacenti, non abbiamo trovato gruppi che corrispondano alla tua ricerca.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Visualizza tutti i gruppi</a> o <a %s>Crea un nuovo gruppo</a>',
        'VIEW_ALL_GROUPS' => 'Visualizza tutti i gruppi',
        'DELETE_GROUP' => 'Elimina gruppo',
        'DELETE_GROUP_Q' => 'Sei sicuro di voler eliminare questo gruppo?',
        'GROUP_INVITATIONS' => 'Inviti gruppo',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Sei stato invitato a partecipare:',
        'VISIT' => 'Visita',
        'WHO_CAN_JOIN_GROUP' => 'Chi può entrare in questo gruppo?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'Non è possibile modificare i criteri di privacy dopo la creazione del gruppo.',
        'ONLY_INVITED_PEOPLE' => 'Solo chi è stato invitato',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Consenti di richiedere un invito',
        'ANYONE_CAN_JOIN_GROUP' => 'Chiunque può entrare in questo gruppo',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Solo chi è stato invitato può entrare in questo gruppo',
        'WHY_NOT_CREATE_GROUP' => 'Perchè non <a %s>crei un tuo gruppo</a>?',
        'PLEASE_ENTER_NAME' => 'Inserisci il tuo nome',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Inserisci il tuo indirizzo e-mail.',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Inserisci un nuovo indirizzo della pagina.',
        'PLEASE_ENTER_PASSWORD' => 'Inserisci la tua password.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Clicca qui per creare un account</a> o tenta di entrare nuovamente in basso.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Clicca qui per creare un account</a> o tenta di entrare nuovamente con il tuo ID Ning in basso.',
        'CHOOSE_SHORTER_PASSWORD' => 'Scegli una password più corta.',
        'CHOOSE_SHORTER_NAME' => 'Scegli un nome più corto.',
        'ENTER_SHORTER_CITY_NAME' => 'Inserisci un nome di città  più corto.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Inserisci nuovamente la tua password nel campo "Inserisci nuovamente la password".',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Inserisci la tua password attuale.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Inserisci la tua nuova password.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Inserisci nuovamente la tua nuova password nel campo "Conferma la password".',
        'CURRENT_PASSWORD' => 'Password attuale',
        'PASSWORDS_DO_NOT_MATCH' => 'Le due password non corrispondono.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'La nuova password e la password di conferma non corrispondono.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'La tua richiesta è stata inviata all\'autore del gruppo.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s non è un indirizzo e-mail valido',
        'COME_JOIN_ME_ON_GROUP' => 'Vieni ad unirti a me su %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Invita altre persone a %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Invita altri amici a %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Invita altre persone a iscriversi a %s.',
        'GROUPNAME_MEMBERS' => 'Membri %s',
        'GROUP_CREATOR' => 'Autore del gruppo',
        'GROUP_ADMINISTRATOR' => 'Amministratore del gruppo',
        'DATE_BANNED' => 'Data del ban',
        'BAN_FROM_GROUP' => 'Banna dal gruppo',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Sei sicuro di voler bannare il/i membro/i selezionato/i dal tuo gruppo?  Questo processo potrebbe impiegare qualche minuto.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Elimina anche i loro post e le loro risposte dal forum.',
        'GROUP_WEB_ADDRESS' => 'Indirizzo web gruppo',
        'GROUP' => 'Gruppo',
        'BACK_TO_GROUP' => '← Torna a %s',
        'USER_BANNED_FROM_GROUP' => '%1$s è stato bannato da questo gruppo.  <a %2$s>Invia %1$s un messaggio</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s è già membro di questo gruppo.  <a %2$s>Invia %1$s un messaggio</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Discussioni amministratori gruppo',
        'BACK_TO_NETWORK_GROUPS' => 'Torna a gruppi %s',
        'MOST_MEMBERS' => 'Maggior numero di membri',
        'THIS_SETS_URL_OF_GROUP' => 'Questo imposta l\'URL del tuo gruppo:<br />http://%s/<strong>indirizzowebgruppo</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Ti piace ciò che trovi su %s?  Partecipa ora!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Ti piace ciò che trovi in %s?  Partecipa ora!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Hai creato il gruppo %s.  Puoi avviare una discussione nel forum %1$s o invitare altre persone a partecipare.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Ora sei membro di %1$s.  Puoi partecipare al forum %1$s o invitare altre persone.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Questo network non ha ancora musica!',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Questa persona non ha ancora musica.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Trova altra musica simile su <em>%s</em>',
        'TRACKS' => 'Tracce',
        'ADD_MUSIC_TRACKS' => 'Aggiungi musica',
        'CHOOSE_MUSIC_TRACKS' => 'Scegli le canzoni da aggiungere',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Puoi aggiungere fino a 4 MP3 alla volta.',
        'UPLOAD_TRACKS' => 'Carica canzoni',
        'ADD_TRACKS' => 'Aggiungi canzoni',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Inserisci l\'URL di ciascun MP3 che desideri aggiungere:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Puoi caricare fino a 100 MP3!  Ciascun file MP3 può pesare fino a 20 MB, ma i file più piccoli si caricano più in fretta.',
        'BE_NICE' => 'Fa\' il bravo',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Carica una canzone solo se hai il permesso dell\'artista o del detentore dei diritti d\'autore.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Linka soltanto musica la cui distribuzione sul web è autorizzata.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Altri modi di aggiungere music...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '...da un altro sito web',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Aggiungi musica da qualsiasi sito web incollando il link all\'MP3.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Mantieni aperta questa pagina per permetterci di completare il caricamento delle tue canzoni. Ti informeremo quando saranno state approvate!',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Nel frattempo, puoi <a %s>aprire una nuova finestra del browser</a> e continuare ad usare %s.  Una volta completato il caricamento, potrai aggiungere titoli e descrizioni alle tue canzoni in questa finestra.',
        'TRACKS_EXCEEDED_LIMIT' => 'La traccia/Le tracce sembrano aver superato il limite di 10MB per canzone.',
        'EDIT_TRACK_INFORMATION' => 'Modifica informazioni canzone',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Aggiungi titolo, descrizione e altre informazioni alle canzoni che hai appena caricato.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Aggiungi titolo, descrizione e altre informazioni a questa canzone.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Annulla e ritorna alla playlist',
        'TRACK_TITLE' => 'Titolo canzone',
        'TRACK_ARTIST' => 'Artista',
        'TRACK_ALBUM' => 'Album',
        'ENABLE_DOWNLOAD_LINK' => 'Abilita il link di download',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Consenti ad altri di inserire questa canzone nelle loro pagine',
        'TRACK_ARTWORK' => 'Immagine copertina',
        'EDIT_PLAYLIST' => 'Modifica playlist',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Per riordinare la tua playlist, clicca sulla canzone e trascinala dove desideri venga riprodotta.',
        'ADD_MUSIC_ELLIPSIS' => 'Aggiungi musica...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '...dal tuo computer',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Carica MP3 dal tuo computer.',
        'DELETE_THIS_TRACK_Q' => 'Vuoi eliminare questa canzone?',
        'DELETE_TRACK' => 'Elimina canzone',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Sei sicuro di voler eliminare questa canzone?',
        'PLAY' => 'riprodurre',
        'GENRE' => 'Genere',
        'YEAR' => 'Anno',
        'LABEL' => 'Etichetta',
        'EXPLICIT_LYRICS' => 'Testi espliciti',
        'ARTIST_SITE' => 'Sito dell\'artista',
        'HOSTING_SITE' => 'Sito di hosting',
        'LABEL_SITE' => 'Sito dell\'etichetta',
        'LICENSE' => 'Licenza',
        'SELECT_LICENSE' => '— Select license —',
        'LICENSE_NAME' => 'Nome licenza',
        'LICENSE_URL' => 'URL licenza',
        'MUSIC' => 'Musica',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Permetti ad altri di caricare e condividere file audio',
        'PLAYLIST' => 'Playlist',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Più recente',
        'FEATURED_TRACKS' => 'Selezionato',
        'HIGHEST_RATED_TRACKS' => 'Più votato',
        'NO_TRACKS_TO_PLAY' => 'Attualmente non c\'è musica sul tuo network.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Questa finestra non sarà visualizzabile da altri finché non ci saranno brani musicali o podcast da riprodurre. Perché non ne aggiungi uno?',
        'NO_TRACKS_ON_PLAYLIST' => 'Attualmente non ci sono canzoni in questa playlist.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Questo lettore non sarà  visualizzabile da altri finchè non ci saranno canzoni o podcast da riprodurre.  Perchè non ne aggiungi uno?',
        'NO_FEATURED_TRACKS' => 'Non ci sono canzoni sul tuo network.',
        'START_FEATURING_TRACKS' => 'Inizia a inserire le canzoni che vorresti avere nella pagina principale.',
        'VIEW_MUSICPLAYER' => 'Visualizza lettore musicale',
        'MY_PLAYLIST' => 'La mia playlist',
        'NETWORK_PLAYLIST' => 'Playlist network',
        'COPYRIGHT' => '© Tutti i diritti riservati',
        'CC_BY_X' => 'Attribuzione Creative Commons %s',
        'CC_BY_SA_X' => 'Attribuzione Creative Commons Condividi allo stesso modo %s',
        'CC_BY_ND_X' => 'Attribuzione Creative Commons Nessun derivato %s',
        'CC_BY_NC_X' => 'Attribuzione Creative Commons Non commerciale %s',
        'CC_BY_NC_SA_X' => 'Attribuzione Creative Commons Non commerciale Condividi allo stesso modo %s',
        'CC_BY_NC_ND_X' => 'Attribuzione Creative Commons Non commerciale Nessun derivato %s',
        'PUBLICDOMAIN' => 'Dominio pubblico',
        'FACEBOOK_CONFIRM_DISABLE' => 'Sei sicuro?',
        'FACEBOOK_PLAYER_DISABLE' => 'Disabilita',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Lettore musicale',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Consenti a chiunque di aggiungere un\'applicazione che riproduca la tua selezione musicale alle pagine del proprio profilo su Facebook.',
        'FACEBOOK_MUSIC_BUTTON' => 'Crea applicazione musicale &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Lettore musicale di Facebook già abilitato.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Lettore Video',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Consenti a chiunque di aggiungere un\'applicazione che riproduca un video del tuo network alle pagine del proprio profilo Facebook.',
        'FACEBOOK_VIDEO_BUTTON' => 'Crea applicazione video &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Lettore video di Facebook già  abilitato.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Presentazione fotografie',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Consenti a chiunque di aggiungere un\'applicazione che riproduca una presentazione fotografica del tuo network alle pagine del proprio profilo Facebook.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Crea applicazione presentazione fotografica &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Presentazione fotografica di Facebook già  abilitata.',
        'FACEBOOK_PLATFORM_LOGO' => 'Logo piattaforma Facebook',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, un popolare sito di social networking, consente a sviluppatori esterni di creare applicazioni che possono essere aggiunte alle pagine del profilo dei suoi membri.  Oltre a garantire funzionalità aggiuntive delle pagine del profilo, tali applicazioni possono essere utilizzate per attirare gli utenti di Facebook verso altre destinazioni sul web.',
        'FACEBOOK_QUICK_INTRO_2' => 'Con Ning, non hai bisogno di essere uno sviluppatore per promuovere il tuo social network su Facebook.  Ci siamo occupati noi della parte più difficile: ora il tuo network possiede già l\'integrazione delle applicazioni per Facebook.  Ti basta scegliere fra le opzioni in basso e il tuo social network sarà integrato con Facebook in pochi secondi.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Aggiungi pulsante Sviluppatore',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Imposta pulsante Nuova applicazione',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Le tue applicazioni Facebook',
        'FACEBOOK_EMBEDDING' => 'Promozione Facebook',
        'FACEBOOK_SETUP' => 'Promozione Facebook',
        'FACEBOOK_PROMOTING' => 'Promuovere applicazioni su Facebook',
        'FACEBOOK_VIEW_APP' => 'Visualizza applicazione',
        'FACEBOOK_ADD_THE' => 'Aggiungi il',
        'FACEBOOK_RECENT' => 'Più recente',
        'FACEBOOK_RECENTLY_FEATURED' => 'Presentato più di recente',
        'FACEBOOK_RECENTLY_ADDED' => 'Aggiunto più di recente',
        'FACEBOOK_PROMOTED' => 'Selezionato',
        'FACEBOOK_RATED' => 'Più votato',
        'FACEBOOK_POPULAR' => 'Popolare',
        'FACEBOOK_MUSIC_WIDGET' => 'Widget musica',
        'FACEBOOK_VIDEO_WIDGET' => 'Widget video',
        'FACEBOOK_PHOTO_WIDGET' => 'Widget foto',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Primi passi',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Clicca qui per andare su Facebook e iniziare a creare la tua applicazione.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Questa operazione aprirà Facebook in una nuova finestra.  Se non sei già entrato in Facebook, dovrai farlo ora.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Se non hai creato un\'applicazione in Facebook, ti sarà chiesto di aggiungere l\'applicazione Developer di Facebook.  Una volta fatto ciò comparirà il messaggio " ". Clicca su <strong>Create one</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Se hai già creato un\'applicazione in Facebook, accederai all\'applicazione Developer di Facebook.  Clicca su <strong>Set Up New Application</strong> .',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Operazione successiva: istruzioni su come impostare la tua applicazione %s affinché funzioni in Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Istruzioni di impostazione',
        'FACEBOOK_INSTR_SETUP_1' => 'Grandioso!  Veniamo ai particolari.  Facebook necessita di alcune informazioni di base per far decollare la tua applicazione.  Effettua le seguenti operazioni.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Campi obbligatori (Required fields)',
        'FACEBOOK_INSTR_SETUP_2' => 'Scegli un nome per l\'applicazione (<strong>Application Name</strong>).',
        'FACEBOOK_INSTR_SETUP_3' => 'Spunta la casella per indicare che hai letto il documento con i termini e le condizioni di Facebook.',
        'FACEBOOK_INSTR_SETUP_4' => 'Apri la sezione dei campi facoltativi (<em>Optional Fields</em>).',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Opzioni di base (Base Options)',
        'FACEBOOK_INSTR_SETUP_5' => 'Inserisci il tuo indirizzo e-mail nel campo <strong>Support E-Mail</strong> field.',
        'FACEBOOK_INSTR_SETUP_6' => 'Incolla il seguente indirizzo web nel campo <strong>URL di richiamo</strong>:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Scegli un <strong>Canvas Page URL</strong> (ad esempio <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Seleziona <strong>Yes</strong> per la voce <em>Can your application be added on Facebook</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Opzioni di installazione',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Scrivi una descrizione dell\'applicazione (<strong>Application Description</strong>).',
        'FACEBOOK_INSTR_SETUP_9' => 'Incolla il seguente codice nel campo <strong>Default FBML</strong>:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Per <strong>Default Profile Box Column</strong>, seleziona <strong>Wide</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Per <strong>Default Profile Box Column</strong>, seleziona <strong>Narrow</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'Nel campo <strong>Side Nav URL</strong> inserisci il tuo <em>Canvas Page URL</em> (creato nell\'operazione &#8216; f&#8217;  precedente).  Accertati di includere la porzione http://apps.facebook.com/ dell\'URL.',
        'FACEBOOK_INSTR_SETUP_11' => 'Scrivi il testo di <strong>Attachment action</strong>.  È quello che comparirà se intendi includere una delle tue applicazioni nei messaggi che invierai in Facebook.  Se la tua applicazione è una presentazione fotografica, puoi inserire foto del nome network.  Se la tua applicazione è un lettore video, puoi inserire video del nome network.',
        'FACEBOOK_INSTR_SETUP_12' => 'Incolla il seguente indirizzo web nel campo <strong>URL di richiamo</strong>:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Pagina di impostazione dell\'applicazione Facebook',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Una volta terminato clicca su <strong>Submit</strong>.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Operazione successiva: Recupero di chiave API e segreto',
        'FACEBOOK_API_INFO_TITLE' => 'Informazioni API Facebook',
        'FACEBOOK_API_INFO_DESC' => 'Per completare l\'impostazione, devi inserire chiave API e segreto e l\'URL della tua applicazione nei campi in basso.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Trovi chiave API e segreto nella pagina <a %s>My Applications page on Facebook</a> (si apre in una nuova finestra, sotto il titolo dell\'applicazione che hai appena creato.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Pagina My Applications (è evidenziata la posizione delle informazioni API)',
        'FACEBOOK_API_INFO_KEY' => 'Chiave API',
        'FACEBOOK_API_INFO_SECRET' => 'Segreto API',
        'FACEBOOK_URL_INFO_TITLE' => 'URL dell\'applicazione Facebook',
        'FACEBOOK_URL_INFO_DESC' => 'L\'URL dell\'applicazione è lo stesso del <strong>Canvas Page URL</strong> che hai definito nella pagina precedente (nell\'operazione &#8216; f&#8217; ).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Le applicazioni musicali di Facebook dovrebbero riprodurre:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Le applicazioni video di Facebook dovrebbero riprodurre il video che si trova:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Le applicazioni di presentazione di Facebook dovrebbero riprodurre le foto di:',
        'FACEBOOK_PROMOTING_ON' => 'Promuovere su Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Istruzioni di impostazione',
        'FACEBOOK_API_INFO' => 'Informazioni API',
        'FACEBOOK_DISABLE' => 'Disabilita questa applicazione',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'al tuo profilo Facebook',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Torna a Promozione Facebook',
        'FACEBOOK_EMBEDDING_DESC' => 'Permetti agli utenti Facebook di inserire i widget e i badge del tuo network nelle pagine del proprio profilo.',
        'FACEBOOK_PROMOTE' => 'Per ottenere il massimo profitto quando promuovi la tua nuova applicazione, ti consigliamo di fare quanto segue.  È possibile accedere a tutte queste applicazioni dalla pagina <strong><a %s>My Applications</a></strong> di Facebook (il link si apre in una nuova finestra).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Inserisci una pagina Ulteriori informazioni (About Page)',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Fai capire agli utenti di Facebook cosa sia la tua applicazione con una chiara descrizione.  Per modificare tali informazioni clicca sul link <strong>Edit About Page</strong> accanto all\'applicazione che stai modificando.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Inserisci l\'applicazione nella directory di Facebook',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Spargi la voce dell\'esistenza della tua nuova applicazione aggiungendola alla directory di Facebook.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Per inserire la tua applicazione, clicca sul link <strong>Submit Application</strong> accanto all\'applicazione che stai modificando.  Nella pagina seguente puoi modificare la descrizione dell\'applicazione (Application Description) e aggiungere anche un logo per la tua applicazione.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Aggiungi l\'applicazione al tuo profilo Facebook',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Pubblicizza la tua applicazione aggiungendola al tuo profilo Facebook, poi aspetta con calma che i tuoi amici facciano lo stesso.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Clicca sul link <strong>View About Page</strong> accanto all\'applicazione che vuoi aggiungere al tuo profilo, poi clicca su Add Application nella pagina successiva.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'A questo punto la tua applicazione sarà  in fondo al tuo profilo Facebook!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Pagina My Applications su Facebook',
        'FACEBOOK_MY_APPS' => 'My Applications',
        'FORUM_TAB_TEXT' => 'Forum',
        'VIDEOS_TAB_TEXT' => 'Video',
        'PHOTOS_TAB_TEXT' => 'Fotografie',
        'GROUPS_TAB_TEXT' => 'Gruppi',
        'ADD_PHOTOS_LOWER' => 'Aggiungi fotografie',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Il caricamento del video su %s non è stato completato a causa di un errore di conversione.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Per aiutarci a risolvere il problema, fornisci l\'identificativo di questo video: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Il tuo video è stato caricato su %s con successo.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Per visualizzare questo video visita:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Il tuo video "%1$s" su %2$s ha ricevuto un nuovo commento.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Il tuo video su %s ha ricevuto un nuovo commento.',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'La tua fotografia "%1$s" ha ricevuto un nuovo commento su %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'La tua fotografia ha ricevuto un nuovo commento su %s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Hai un nuovo %1$s da approvare su %2$s…',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Hai un nuovo %1$s da approvare su %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Hai un nuovo %1$s "%2$s" da approvare su %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Per approvare questo %s, visita:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Il tuo %1$s su %2$s è stato approvato…',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Il tuo %1$s su %2$s ha ricevuto un nuovo commento…',
        'CLICK_HERE_TO_JOIN' => 'Fai clic qui per partecipare:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s vuole che tu guardi "%2$s" su %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Il tuo %s è stato approvato su %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Il tuo %1$s "%2$s" è stato approvato su %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'Per visualizzare il tuo %s, visita:',
        'TO_VIEW_THIS_X_VISIT' => 'Per visualizzare questo %s, visita:',
        'TO_VIEW_IT_VISIT' => 'Per visualizzarlo, visita:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s ha segnalato il seguente problema su %2$s…',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s ti ha inviato un messaggio su %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s ha richiesto di diventare membro %2$s su %3$s.',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Per approvare o rifiutare la richiesta di %s, visita:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s ha aggiunto un commento al post "%2$s" su %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s ha aggiunto un commento a un post su %2$s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Hai un nuovo membro da approvare su %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Benvenuto nel Gruppo "%1$s" su %2$s',
        'LOADING_YOUR_FRIENDS' => 'Caricamento in corso dei tuoi amici…',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Il tuo messaggio è stato inviato',
        'TO_SEND_ANOTHER_MESSAGE' => 'Per inviare un altro messaggio, inserisci il testo qui sotto.',
        'PLEASE_CHOOSE_FRIENDS' => 'Seleziona qualche amico prima di inviare il messaggio.',
        'THESE_FRIENDS' => 'Questi amici:',
        'ALL_FRIENDS' => 'Tutti gli amici',
        'ALL_FRIENDS_ON_APPNAME' => 'Tutti gli amici su %s',
        'SHARE_WITH_FRIENDS' => 'Condividi con amici',
        'SHARE_THIS_WITH_FRIENDS' => 'Condividi questo articolo con i tuoi amici',
        'COMPOSE_MESSAGE' => 'Scrivi un messaggio',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Questo link di invito è visibilr soltanto all\'autore del network e agli amministratori.  I membri che si iscrivono  tramite questo link diventeranno automaticamente amici dell\'autore del network.',
        'WE_ARE_LOADING_ADDRESSES' => 'Caricamento in corso dei tuoi indirizzi…',
        'SELECT_ALL_NONE' => 'Seleziona tutti/nessuno',
        'INVITE_TO_APPNAME' => 'Invita a \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Invita i tuoi amici a \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Già membro di questo network)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Oppure condividi questo link di invito:',
        'CLICK_TO_MAIL' => '<a %s>Fai clic qui per mandare l\'e-mail adesso</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Il tuo messaggio è stato inviato',
        'YOU_CAN_SHARE_THIS' => 'Puoi condividere con più persone a continuazione, oppure <a %s>tornare alla pagina precedente</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Spiacenti, il servizio di importazione vCard al momento non è disponibile.',
        'CSV_IMPORT_UNAVAILABLE' => 'Spiacenti, il servizio di importazione CSV al momento non è disponibile.',
        'ERROR_OCCURRED' => 'Spiacenti, si è verificato un errore.',
        'IMPORT_FAILED' => 'Spiacenti, l\'importazione non è riuscita.',
        'LOGIN_FAILED' => 'Spiacenti, l\'accesso non è riuscito.',
        'UNABLE_TO_FIND_EMAIL' => 'Spiacenti, non è stato possibile trovare il campo e-mail.',
        'CANNOT_READ_VCARDS' => 'Spiacenti, non è stato possibile leggere queste vCards.',
        'NO_ADDRESSES_FOUND' => 'Nessun indirizzo trovato',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Non è stato trovato nessun indirizzo nella rubrica importata.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Importa dalla rubrica web',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Importazione dalla rubrica applicazione',
        'PRIVACY_POLICY' => 'Politica sulla privacy',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s ha pubblicato i seguenti commenti e suggerimenti su %2$s:',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Guarda "%1$s" su %2$s…',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Guarda questo %1$s su %2$s…',
        'SEND_MESSAGE_TO_FRIENDS' => 'Invia messaggio a amici',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Scegli un opzione valida per le notifiche dei messaggi inviati a tutti gli amici',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Benvenuto, %1$s!  Sei il membro #%2$s di %3$s.  <a %4$s>Invita amici adesso</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Hai commentato la fotografia <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s ha commentato la fotografia <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Hai commentato il video <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s ha commentato il video <a %s>%s</a>',
        'THIS_IS_YOUR_PAGE' => 'Questa è la tua pagina:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Messaggi inviati a tutti gli amici',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Per smettere di seguire questa %s, vai a:',
        'CHOOSE_GADGETS' => 'Scegli uno di questi fantastici gadget OpenSocial da aggiungere alla tua pagina!  Puoi <a %s>visualizzare e valutare i gadget qui</a>, oppure <a %s>ottenere maggiori informazioni su OpenSocial qui</a>.',
        'GADGETS_UNAVAILABLE' => 'Gadget momentaneamente non disponibili',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Spiacenti, i gadget sono momentaneamente non disponibili.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Questa finestra non sarà  visualizzabile da altri se non selezioni un gadget.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Fai clic su Modifica per specificare l\'URL del gadget per questa finestra o visita la <a %s> Directory dei gadget</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Si è verificato un problema nel recuperare questo feed URL del gadget.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Aggiungi questo gadget al tuo profilo',
        'GADGETS_BETA' => 'Gadget (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Prova i gadget OpenSocial.   Avvertenza: questa funzione è in fase di sperimentazione.',
        'ADD_TO_MY_PAGE' => 'Aggiungi alla mia pagina',
        'GADGETS' => 'Gadget',
        'GADGETS_TAB_TEXT' => 'Gadget',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Il gadget è in Beta.',
        'SORRY_GADGET_UNAVAILABLE' => 'Spiacenti, questo gadget non è disponibile.  Assicurati l\'URL sia corretto.  Se si verificano ancora problemi, <a %s>faccelo sapere</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Già membro di questo gruppo)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Invita i tuoi amici a \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Unisciti a me su %1$s su %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Unisciti a me su %1$s su %2$s…',
        'INVITE_TO_GROUP' => 'Invita a \'%s\'',

        'EACH_VIDEO_MAY_BE_100MB' => 'Ogni video può avere una dimensione massima di 100 MB. Sono supportati video nei formati file .mov, .mp4, .mpg, .avi, .wmv e.3gp. ',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Sono autorizzato a caricare questo video secondo le <a %s>Condizioni di Servizio</a>. ',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'L’uploader per video multipli richiede una versione recente di Java. <strong><a %s>Fai clic qui per ottenere Java</a></strong>, o <strong><a %s>ritorna all’uploader semplice</a></strong>. ',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Carica un video dal tuo computer ',
        'HAVE_LOT_OF_VIDEOS' => 'Hai tanti video da condividere? ',
        'TRY_BULK_VIDEO_UPLOADER' => 'Prova l’uploader per video multipli ',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'I tuoi video sono stati caricati con successo. ',
        'VIDEOS_UPLOADED_AWAITING' => 'I tuoi video sono stati caricati con successo e attendono di essere approvati dall’autore di %s. ',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Aggiungi video o fotografie a %s direttamente dal tuo telefono inviandoli ad un unico indirizzo di posta elettronica. ',
        'GRAB_HTML_EMBED' => 'Prendi il codice HTML \'incorporato\' da qualsiasi sito popolare di video e aggiungilo a questo network. ',
        'GOOGLE' => 'Google ',
        'YOUTUBE' => 'YouTube ',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Se ci sono problemi con l\'uploader per video multipli  <strong><a %s>Ritorna all\'uploader semplice</a></strong>. ',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Aggiungi video da YouTube o Google ',
        'TAGS_NO_COLON' => 'Tag ',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Non ci sono video taggati "%1$s". Guarda <a %2$s>le discussioni taggate "%1$s"</a>, <a %4$s>i post sul blog taggati "%1$s"</a> o <a %3$s>le fotografie taggate "%1$s"</a>. Oppure aggiungi e assegna un tag ai tuoi video! ',
        'UPLOAD_VIDEOS_FROM' => 'Carica video dal tuo computer ',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Aggiungi video per telefono o posta elettronica ',
        //music player
        'FEATURING_ELLIPSIS' => 'Featuring...',
        'OPEN_POPUP_WINDOW' => 'Apri finestra pop-up',
        'NOW_FEATURED_ON_MAIN' => 'Adesso presente sulla Principale ',
        'DONT_FEATURE' => 'Non è presente ',
        'UNFEATURING_ELLIPSIS' => 'Rimozione dalla Principale... ',
        'REMOVED_FROM_MAIN' => 'Rimosso dalla Principale ',
        'ADDED_EXCLAMATION' => 'Aggiunto! ',
        'ERROR' => 'Errore ',
        'ADDING_ELLIPSIS' => 'Aggiunta... ',
        'TRACK_COULD_NOT_BE_LOADED' => 'Non è stato possibile caricare la canzone ',
        'INVALID_URL' => 'URL non valido ',
        'NORMAL_PLAYBACK_ON' => 'Riproduzione normale: Acceso ',
        'REPEAT_PLAYBACK_ON' => 'Riproduzione ripetuta: Acceso ',
        'SHUFFLE_PLAYBACK_ON' => 'Riproduzione casuale: Acceso ',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Caricamento playlist in corso... ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'I tuoi dati sono stati esportati. Clicca su <a %s>questo link</a> per salvarlo sul tuo desktop. ',
        'SET_NEW_PASSWORD' => 'Imposta una nuova password per il tuo account. ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Fai clic \'Modifica\' per aggiungere testo, HTML, video, fotografie, o qualsiasi <a %1$s> widget esterno</a> in questo riquadro. ',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Ogni fotografia può avere una dimensione massima di 10 MB. Supportiamo fotografie nei formati file .jpg, .gif e .png. ',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Sono autorizzato a caricare queste fotografie secondo le <a %s>Condizioni di Servizio</a>. ',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'L’uploader per fotografie multiple richiede una versione recente di Java. <strong><a %s>Fai clic qui per ottenere Java</a></strong>, o <strong><a %s>ritorna all’uploader semplice</a></strong>. ',
        'TRY_BULK_PHOTO_UPLOADER' => 'Prova l’uploader per fotografie multiple ',
        'HAVE_LOT_OF_PHOTOS' => 'Hai tante fotografie da condividere? ',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Le tue fotografie sono state caricate con successo. ',
        'PHOTOS_UPLOADED_AWAITING' => 'Le tue fotografie sono state caricate con successo e sono in attesa dell’approvazione da parte dell’autore di %s. ',
        'FLICKR' => 'Flickr ',
        'ADD_PHOTOS_FROM_FLICKR' => 'Aggiungi fotografie da Flickr ',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Aggiungi fotografie o video a %s direttamente dal tuo telefono inviandoli a un unico indirizzo e-mail. ',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Se ci sono problemi con l’uploader per fotografie multiple   <strong><a %s>Ritorna al nostro uploader semplice</a></strong>. ',
        'VIEW_SLIDESHOW' => 'Visualizza presentazione ',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Non ci sono fotografia taggate "%1$s". Guarda <a %2$s>le discussioni taggate "%1$s"</a>, <a %4$s>i post sul blog taggati "%1$s"</a> o <a %3$s>i video taggati "%1$s"</a>. Oppure aggiungi e assegna un tag alle tue fotografie! ',
        'PHOTO_MAY_BE_10MB' => 'Ogni fotografia può avere una dimensione massima di 10 MB, ma il caricamento delle fotografie più piccole sarà più veloce. Supportiamo fotografie nei formati file .jpg, .gif e .pn→g. ',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Carica fotografie dal tuo computer ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Fai clic \'Modifica\' per aggiungere testo, HTML, video, fotografie, o qualsiasi <a %1$s> widget esterno</a> in questo riquadro. ',
        'PLEASE_SELECT_A_MEMBER' => 'Seleziona uno o più membri ',
        'RESEND_INVITATION' => 'Manda di nuovo l\'invito ',
        'CHOOSE_FRIENDS' => 'Scegli amici... ',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Spiacenti, non supportiamo la rubrica web per il tuo indirizzo di posta elettronica. Prova a fare clic su \'Address Book Application\' più in basso per utilizzare gli indirizzi presenti sul tuo computer. ',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Desideri invitare altri amici? Importa i contatti dalla tua rubrica web o applicazione e-mail. ',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Address Book, .CSV, ecc. ',
        'SET_NEW_PASSWORD' => 'Imposta una nuova password per il tuo account. ',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => ' Iscriviti adesso. Sei gia un membro? <a %s>Clicca qui per entrare</a>. ',
        'FEATURED_MEMBERS' => 'Membri selezionati ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'I tuoi dati sono stati esportati. Clicca su <a %s>questo link</a> per salvarlo sul tuo desktop. ',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Spiacenti, non è stato trovato nessun membro corrispondente a "%s". ',
        'WHO_CAN_COMMENT_ON_POST' => 'Chi può fare commenti su questo post? ',
        'PREVIOUS_POST' => '←  Post precedente ',
        'NEXT_POST' => 'Prossimo Post  →',
        'PREVIOUS_POSTS' => '← Post precedenti ',
        'NEXT_POSTS' => 'Prossimi Post  →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Non ci sono blog taggati "%1$s". Guarda <a %2$s>le discussioni taggate "%1$s"</a>, <a %4$s>le fotografie tagate "%1$s"</a> o <a %3$s>i video taggati "%1$s"</a>. Oppure aggiungi e assegna un tag ai tuoi post sul blog! ',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Tutti i post sul blog contrassegnati <em>\'%s\'</em> per %s %s ',
        'ALL_POSTS_TAGGED_X' => 'Tutti i post contrassegnati <em>\'%s\'</em> ',
        'MY_BLOG_POSTS_FOR_M_Y' => 'I miei post per %s %s ',
        'MY_BLOG_POSTS' => 'I miei post ',
        'PRIVACY_CONTENT_CONTROL' => 'Privacy e controllo dei contenuti ',
        'MODERATION' => 'Controllo dei contenuti ',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Abilita i link di download del riproduttore musicale ',
        'NOTIFY_BLOG_PING_SERVICES' => 'Desideri notificare a terzi i servizi di tracking quando aggiungi un nuovo post? ',
        'YES_NOTIFY_BLOG_SERVICES' => 'Sì  –  Notifica <a %s>servizi di aggiornamento del sito</a> quando aggiungo un nuovo post ',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Non ci sono membri selezionati sul tuo social network. ',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Inizia a selezionare membri quando vedi l’opzione. Per saperne di più sulla selezione <a %s>fai clic qui</a>. ',
        'SHOW_ALL' => 'Mostra tutto ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Non ci sono discussioni taggate "%1$s". Guarda <a %2$s>le fotografie taggate "%1$s"</a>, <a %4$s>i post sul blog taggati "%1$s"</a> o <a %3$s>i video taggati"%1$s"</a>. Oppure aggiungi e assegna un tag alle tue discussioni! ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Non ci sono discussioni taggate "%1$s". Guarda <a %2$s>le fotografie taggate "%1$s"</a>, <a %4$s>i post sul blog taggati "%1$s"</a> o <a %3$s>i video taggati "%1$s"</a>. ',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Hai creato il gruppo %1$s. Puoi avviare una discussione nel forum %1$s o invitare altre persone a partecipare. ',
        'YOU_CAN_ADD_100_SONGS' => 'Puoi aggiungere un totale di 100 canzoni e ognuna può avere una dimensione massima di 20 MB. Supportiamo canzoni nel formato file.mp3. ',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Ho il diritto di caricare queste canzoni secondo le <a %s>Condizioni di Servizio</a>. ',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'L’uploader per brani musicali multipli richiede una versione recente di Java. <strong><a %s>Fai clic qui per ottenere Java</a></strong>, o <strong><a %s>ritorna all’uploader semplice ',
        'HAVE_LOT_OF_MUSIC' => 'Hai tanta musica da condividere? ',
        'TRY_BULK_MUSIC_UPLOADER' => 'Prova l’uploader per brani musicali multipli ',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Le tue canzoni sono state caricate con successo. ',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Spiacenti, puoi soltanto avere %s canzoni sul tuo playlist. Rimuovi alcune delle canzoni esistenti prima di aggiungerne altre. ',
        'ADD_MUSIC_FROM_WEBSITE' => 'Aggiungi musica da un altro sito web ',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Se hai problemi con questo uploader per brani musicali  <strong><a %s>Ritorna al nostro uploader semplice</a></strong>. ',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Carica musica dal tuo computer ',
        'ADD_MUSIC' => 'Aggiungi musica ',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Seleziona <strong>Utenti</strong> e <strong>Tutte le pagine</strong>. ',



    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}
