<?php
XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the English (United States) locale.
 *
 * @see Bazel I18N Guidelines for tips on choosing key names
 */
class XG_MessageCatalog_en_US extends XG_AbstractMessageCatalog {
    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['FAVORITE_OF_N_PEOPLE']['1'] = 'Favorite of 1 person';
            $a['FAVORITE_OF_N_PEOPLE']['n'] = 'Favorite of %s people';
            $a['N_STARS_OUT_OF_5']['1'] = '1 star out of 5';
            $a['N_STARS_OUT_OF_5']['n'] = '%s stars out of 5';
            $a['CURRENTLY_N_STARS']['1'] = 'Currently 1/5 stars.';
            $a['CURRENTLY_N_STARS']['n'] = 'Currently %s/5 stars.';
            $a['N_INVITATIONS_RESENT']['1'] = '1 invitation has been resent.';
            $a['N_INVITATIONS_RESENT']['n'] = '%s invitations have been resent.';
            $a['N_SECONDS_AGO']['1'] = '1 second ago';
            $a['N_SECONDS_AGO']['n'] = '%s seconds ago';
            $a['N_MINUTES_AGO']['1'] = '1 minute ago';
            $a['N_MINUTES_AGO']['n'] = '%s minutes ago';
            $a['N_HOURS_AGO']['1'] = '1 hour ago';
            $a['N_HOURS_AGO']['n'] = '%s hours ago';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> Video';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> Videos';
            $a['N_VIDEOS_2']['1'] = '1 video';
            $a['N_VIDEOS_2']['n'] = '%s videos';
            $a['N_VIEWS']['1'] = '1 view';
            $a['N_VIEWS']['n'] = '%s views';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> Comment';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> Comments';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'This video is a <strong>favorite</strong> of <strong>1 person</strong>.';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'This video is a <strong>favorite</strong> of <strong>%s people</strong>.';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s added a video:';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s added %s videos.';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'You added a video:';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'You added %s videos.';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'There is 1 video on %2$s';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'There are %1$s videos on %2$s';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'There is 1 <a href="%3$s">video</a> on %2$s';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">videos</a> on %2$s';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 photo from this album has been deleted or made private, so it can\'t be displayed.';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s photos from this album have been deleted or made private, so they can\'t be displayed.';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> Photo';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> Photos';
            $a['N_PHOTOS_2']['1'] = '1 photo';
            $a['N_PHOTOS_2']['n'] = '%s photos';
            $a['N_MUSIC']['1'] = '1 music track';
            $a['N_MUSIC']['n'] = '%s music tracks';
            $a['N_EVENTS']['1'] = '1 event';
            $a['N_EVENTS']['n'] = '%s events';
            $a['N_BLOG_POSTS']['1'] = '1 blog post';
            $a['N_BLOG_POSTS']['n'] = '%s blog posts';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'and 1 other person';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'and %s other people';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'There was a problem uploading the following file:';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'There was a problem uploading the following files:';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'This photo is a <strong>favorite</strong> of <strong>1 person</strong>.';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'This photo is a <strong>favorite</strong> of <strong>%s people</strong>.';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Rating:</strong> %2$s after 1 vote';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Rating:</strong> %2$s after %s votes';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s after 1 vote';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s after %s votes';
            $a['N_PEOPLE']['1'] = '1 person';
            $a['N_PEOPLE']['n'] = '%s people';
            $a['N_FRIENDS']['1'] = '1 friend';
            $a['N_FRIENDS']['n'] = '%s friends';
            $a['N_OF_5_STARS']['1'] = '1/5 star';
            $a['N_OF_5_STARS']['n'] = '%s/5 stars';
            $a['YOUR_RATING_X_STARS']['1'] = 'Your rating: 1 star';
            $a['YOUR_RATING_X_STARS']['n'] = 'Your rating: %s stars';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s added a photo:';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s added %s photos.';
            $a['Y_ADDED_X_ALBUMS']['1'] = '%2$s added an album:';
            $a['Y_ADDED_X_ALBUMS']['n'] = '%2$s added %s albums.';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'You added a photo:';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'You added %s photos.';
            $a['YOU_ADDED_X_ALBUMS']['1'] = 'You added an album:';
            $a['YOU_ADDED_X_ALBUMS']['n'] = 'You added %s albums.';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'There is 1 photo on %2$s';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'There are %1$s photos on %2$s';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'There is %1$s <a href="%3$s">photo</a> on %2$s';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">photos</a> on %2$s';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Profile Comment';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Profile Comments';
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> Blog Comment';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> Blog Comments';
            $a['N_YEARS_OLD']['1'] = '1 year old';
            $a['N_YEARS_OLD']['n'] = '%s years old';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'You have 1 friend request!';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'You have %s friend requests!';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Comment Wall (1 comment)';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Comment Wall (%s comments)';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 new member joined during the past week';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s new members joined during the past week';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">new member</a> joined during the past week';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">new members</a> joined during the past week';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'There is 1 member on %2$s';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'There are %1$s members on %2$s';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'There is 1 <a href="%3$s">member</a> on %2$s';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">members</a> on %2$s';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'There is 1 blog post on %2$s';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'There are %1$s blog posts on %2$s';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> New Member';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> New Members';
            $a['N_REPLIES']['1'] = '1 Reply';
            $a['N_REPLIES']['n'] = '%s Replies';
            $a['N_MINUTES']['1'] = '1 minute left to edit your comment.';
            $a['N_MINUTES']['n'] = '%s minutes left to edit your comment.';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'There is 1 forum topic on %2$s';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'There are %1$s forum topics on %2$s';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'There is 1 <a href="%3$s">forum topic</a> on %2$s';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">forum topics</a> on %2$s';
            $a['N_INVITES']['1'] = '%s invite';
            $a['N_INVITES']['n'] = '%s invites';
            $a['N_MEMBERS']['1'] = '1 member';
            $a['N_MEMBERS']['n'] = '%s members';
            $a['N_DISCUSSIONS']['1'] = '1 discussion';
            $a['N_DISCUSSIONS']['n'] = '%s discussions';
            $a['N_COMMENTS_LC']['1'] = '1 comment';
            $a['N_COMMENTS_LC']['n'] = '%s comments';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 member)';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s members)';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'There is 1 group on %2$s';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'There are %1$s groups on %2$s';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'There is %1$s <a href="%3$s">group</a> on %2$s';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">groups</a> on %2$s';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 song from this playlist can\'t be displayed because it has been deleted or is no longer shared.';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s songs from this playlist can\'t be displayed because they have been deleted or are no longer shared.';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'A new song has been added to %2$s';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s new songs have been added to %2$s';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s added a song:';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s added %s songs.';
            $a['YOU_ADDED_X_SONGS']['1'] = 'You added a song:';
            $a['YOU_ADDED_X_SONGS']['n'] = 'You added %s songs.';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 song added to this playlist.';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s songs added to this playlist.';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'There is 1 song on %2$s';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'There are %1$s songs on %2$s';
            $a['WRONG_EVENT_END3']['1'] = 'Event cannot be longer than %d day';
            $a['WRONG_EVENT_END3']['n'] = 'Event cannot be longer than %d days';
            $a['FROM_TO_OF_N_NOTES']['1']                   = '%2$d-%3$d of %1$d note';
            $a['FROM_TO_OF_N_NOTES']['n']                   = '%2$d-%3$d of %1$d notes';
            $a['THERE_ARE_X_EVENTS_ON_APPNAME']['1'] = 'There is 1 event on %2$s';
            $a['THERE_ARE_X_EVENTS_ON_APPNAME']['n'] = 'There are %1$s events on %2$s';
            $a['THERE_ARE_X_LINK_EVENTS_ON_APPNAME']['1'] = 'There is 1 <a href="%3$s">event</a> on %2$s';
            $a['THERE_ARE_X_LINK_EVENTS_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">events</a> on %2$s';
        }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }

        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(

        // Video widget
        'RATING' => 'Rating:',
        'RATE_COLON' => 'Rate:',
        'LATEST_VIDEOS' => 'Latest Videos',
        'EACH_VIDEO_MAY_BE_100MB' => 'Each video may be up to 100MB in size. We support videos in the .mov, .mpg, .avi, .wmv and .3gp file formats.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'I have the right to upload this video under the <a %s>Terms of Service</a>.',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'The bulk video uploader requires a recent version of Java. <strong><a %s>Click here to get Java</a></strong>, or <strong><a %s>return to the simple uploader</a></strong>.',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Upload a Video From Your Computer',
        'HAVE_LOT_OF_VIDEOS' => 'Have a lot of videos you want to share?',
        'TRY_BULK_VIDEO_UPLOADER' => 'Try the bulk video uploader',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Your videos were successfully uploaded.',
        'VIDEOS_UPLOADED_AWAITING' => 'Your videos were successfully uploaded and are awaiting approval from %s\'s creator.',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Add videos or photos to %s directly from your phone by sending them to a unique email address.',
        'GRAB_HTML_EMBED' => 'Grab the HTML \'embed\' code from any popular video site and add that video to this network.',
        'GOOGLE' => 'Google',
        'YOUTUBE' => 'YouTube',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Having problems with the bulk video uploader?  <strong><a %s>Return to our simple uploader</a></strong>.',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Add videos from YouTube or Google',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'This network doesn\'t have any videos yet.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'This network doesn\'t have any featured videos yet.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'This person doesn\'t have any videos yet.',
        'COPY_TO_CLIPBOARD' => 'Copy to Clipboard',
        'COPIED_TO_CLIPBOARD' => 'Copied to Clipboard!',
        'NO_VIDEOS_TO_DISPLAY' => 'You are currently displaying no videos.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'This box won\'t show up for other people unless you select at least one video. ',
        'WATERMARK_LOGO' => 'Watermark Logo',
        'CHOOSE_HEADER_OR_WATERMARK' => 'You can choose either a header or watermark logo for your video player.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'The logo appears at the top of your %s. If you don\'t add a logo, the network name will be displayed instead. Your logo should be in .jpg, .gif or .png format. Logos taller than 20 pixels will be resized to fit.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'The watermark logo appears above the bottom right corner of the video clip.',
        'HEADER_LOGO' => 'Header Logo',
        'WATERMARK' => 'Watermark',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Customize Your Video Player!',
        'VIDEO_PLAYER' => 'Video Player',
        'HEADER' => 'Header',
        'SAVE_CHANGES' => 'Save Changes',
        'THUMBNAIL' => 'Thumbnail',
        'CONVERSION_FAILED' => 'Conversion Failed',
        'CONVERSION_IN_PROGRESS' => 'Conversion in Progress',
        'WHAT_IS_THIS' => 'What\'s This?',
        'EDIT_VIDEO_INFORMATION' => 'Edit Video Information',
        'VIDEOS_HOME' => 'Videos Home',
        'MY_VIDEOS' => 'My Videos',
        'MY_FRIENDS_VIDEOS' => 'My Friends\' Videos',
        'MY_FAVORITES' => 'My Favorites',
        'XS_FAVORITES' => '%s\'s Favorites',
        'ADD_A_VIDEO' => 'Add Videos',
        'JUST_NOW' => 'just now',
        '1_DAY_AGO' => '1 day ago',
        'M_J' => 'M j',
        'ME' => 'Me',
        'X_SAID' => '%s said…',
        'DELETE_COMMENT' => 'Delete Comment',
        'ADD_VIDEOS' => 'Add Videos',
        'VIEW_VIDEOS' => 'View Videos',
        'YIKES' => 'Yikes!',
        'A_PROBLEM_SEEMS' => 'A problem seems to have occurred.',
        'FOR_FURTHER_ASSISTANCE' => 'For further assistance, please <a %s>contact us</a>.',
        'OR_YOU_CAN_GO' => 'Or you can go back to the <a %s>%s main page</a> or browse <a %s>other Ning Social Networks</a>',
        'TAGS' => 'Tags:',
        'MY_FRIENDS' => 'My Friends',
        'MY_FRIENDS_N' => 'My Friends (%s)',
        'VIEW_ALL_MY_FRIENDS' => 'View All My Friends',
        'VIEW_ALL_XS_FRIENDS' => 'View All %s\'s Friends',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Our apologies - we couldn\'t find anyone matching your search.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'View Popular Contributors',
        'POPULAR_CONTRIBUTORS' => 'Popular Contributors',
        'VIEW_MORE_CONTRIBUTORS' => 'View More Contributors',
        'ADD_AS_FRIEND' => 'Add as friend',
        'SEND_A_MESSAGE' => 'Send a Message',
        'IS_YOUR_FRIEND' => 'Is Your Friend',
        'IS_BLOCKED' => 'Is Blocked',
        'SORT_BY' => 'Sort by:',
        'CLOSE' => 'Close',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Nobody has added any videos yet. Add a video to get started.',
        'SEARCH_PEOPLE' => 'Search People:',
        'SEARCH_VIDEOS' => 'Search Videos',
        'INVITE_YOUR_FRIENDS_TO' => 'Invite your friends to %s.',
        'INVITE' => 'Invite',
        'INVITE_TAB_TEXT' => 'Invite',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'You haven\'t added any friends on %s yet.',
        'SEARCH_FRIENDS' => 'Search Friends:',
        'SEARCH_FRIENDS_NO_COLON' => 'Search Friends',
        'ADD_YOUR_FIRST_VIDEO' => 'Add Your First Video',
        'USE_HTML_EMBED_CODE' => 'Use HTML Embed Code',
        'WE_SUPPORT_MOV' => 'We support .mov, .mpg, .avi, .3gp and .wmv file formats. Files must be 100MB or smaller.',
        'NEED_HELP_HERE_ARE' => 'Need help? Here are instructions for <a %s>YouTube</a> and <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Add a title and description',
        'DESCRIPTION_COLON' => 'Description:',
        'GROUP_DESCRIPTION' => 'Group Description',
        'GROUP_TITLE' => 'Group Title',
        'BLOG_POST_TEXT' => 'Blog Post Text',
        'BLOG_POST_TITLE' => 'Blog Post Title',
        'DISCUSSION_TEXT' => 'Discussion Text',
        'DISCUSSION_TITLE2' => 'Discussion Title',
        'VIDEO_DESCRIPTION' => 'Video Description',
        'VIDEO_TITLE' => 'Video Title',
        'ALBUM_DESCRIPTION' => 'Album Description',
        'PHOTO_DESCRIPTION' => 'Photo Description',
        'PHOTO_TITLE' => 'Photo Title',
        'NETWORK_TAGLINE' => 'Network Tagline',
        'NETWORK_DESCRIPTION' => 'Network Description',
        'EVENT_TITLE' => 'Event Title',

        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Add a title, description, and other information to the video you just uploaded.',
        'EVERYTHING_IS_OPTIONAL' => 'Everything is optional; if you don\'t want to add anything, just click "Skip this step" on the right.',
        'SKIP_THIS_STEP' => 'Skip this step',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Add a title, description, and other information for this video.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Cancel and return to video',
        'TITLE' => 'Title:',
        'TITLE_NO_COLON' => 'Title',
        'TAGS_ARE_SHORT_DESCRIPTIONS_VIDEO' => 'Tags are short descriptions that let you find your videos. Separate tags with commas or put multiple-word tags in quotes, such as "San Francisco".',
        'TAGS_ARE_SHORT_DESCRIPTIONS_POST' => 'Tags are short descriptions that let you find your posts. Separate tags with commas or put multiple-word tags in quotes, such as "San Francisco".',
        'TAGS_ARE_SHORT_DESCRIPTIONS_DISCUSSION' => 'Tags are short descriptions that let you find your discussions. Separate tags with commas or put multiple-word tags in quotes, such as "San Francisco".',
        'TAGS_ARE_SHORT_DESCRIPTIONS_PHOTO' => 'Tags are short descriptions that let you find your photos. Separate tags with commas or put multiple-word tags in quotes, such as "San Francisco".',
        'TAGS_ARE_SHORT_DESCRIPTIONS_PAGE' => 'Tags are short descriptions that let you find your pages. Separate tags with commas or put multiple-word tags in quotes, such as "San Francisco".',

        'WHO_CAN_VIEW_VIDEO' => 'Who can view this video?',
        'MOST_POPULAR' => 'Most Popular',
        'HIGHEST_RATED' => 'Highest Rated',
        'MOST_RECENT' => 'Most Recent',
        'MOST_FAVORITED' => 'Most Favorited',
        'MOST_VIEWED_VIDEOS_N' => 'Most Viewed Videos (%s)',
        'FEATURED_VIDEOS' => 'Featured Videos',
        'RANDOM_VIDEOS_N' => 'Random Videos (%s)',
        'RANDOM' => 'Random',
        'TOP_RATED_VIDEOS_N' => 'Top Rated Videos (%s)',
        'LATEST_VIDEOS_N' => 'Latest Videos (%s)',
        'ANYONE' => 'Anyone',
        'JUST_MY_FRIENDS' => 'Just My Friends',
        'JUST_ME' => 'Just Me',
        'VIEWABLE_BY_FRIENDS' => 'Viewable by <strong>Friends</strong>',
        'PRIVATE_VIDEO' => '<strong>Private</strong> video',
        'VIEWABLE_BY_EVERYONE' => 'Viewable by <strong>Everyone</strong>',
        'LOCATION' => 'Location',
        'LOCATION_COLON' => 'Location:',
        'APPROVE' => 'Approve',
        'DELETE' => 'Delete',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Apply to all Videos added by %s',
        'NO_TITLE' => 'No Title',
        'ADDED_BY_STRONG_X' => 'Added by <strong>%s</strong>',
        'NO_DESCRIPTION' => 'No Description',
        'BY_X' => 'by %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'You\'ve Finished Moderating',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'There are currently no videos awaiting approval. If you\'re looking for something to do, why not check out the <a %s>latest videos</a>?',
        'ADDED_ON_DATE_BY_X' => 'Added %s by %s.',
        'REMOVE_FROM_FAVORITES' => 'Remove from Favorites',
        'ADD_FAVORITES' => 'Add Favorites',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s hasn\'t added any favorites yet.',
        'YOU_HAVE_NOT_ADDED_FAVORITES' => 'You haven\'t added any favorites yet.',
        'APPROVE_VIDEOS' => 'Approve Videos',
        'YOUR_SITE_REQUIRES_YOU' => 'You have asked to moderate photos and videos on your social network before they are posted. To change this setting, <a %s>click here to go to the Privacy page</a> and turn off \'Approve New Photos And Videos\'.',
        'YOUR_SITE_ALLOWS_USERS' => 'You have asked not to moderate photos and videos on your social network before they are posted. To change this setting, <a %s>click here to go to the Privacy page</a> and turn on \'Approve New Photos And Videos\'.',
        'APPROVE_ALL_VIDEOS' => 'Approve All Videos?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Are you sure you want to approve all videos? This may take a few minutes.',
        'APPROVING' => 'Approving…',
        'APPROVE_ALL' => 'Approve All',
        'DELETE_ALL_VIDEOS' => 'Delete All Videos?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Are you sure you want to delete all unapproved videos? This may take a few minutes.',
        'DELETING' => 'Deleting…',
        'DELETE_ALL' => 'Delete All',
        'XS_VIDEOS' => '%s\'s Videos',
        'XS_VIDEOS_N' => '<a %s>%s\'s</a> Videos (%s)',
        'MY_VIDEOS_N' => 'My Videos (%s)',
        'FEATURED_VIDEOS_N' => 'Featured Videos (%s)',
        'DELETE_THIS_VIDEO_Q' => 'Delete This Video?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Are you sure you want to delete this video? This process may take a few minutes.',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s hasn\'t added any videos yet.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Your friends don\'t have any videos yet.',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'There aren\'t any videos tagged "%1$s". Check out <a %2$s>discussions tagged "%1$s"</a>, <a %4$s>blog posts tagged "%1$s"</a> or <a %3$s>photos tagged "%1$s"</a>. Or add and tag your own videos!',
        'FILES_MUST_BE_100MB' => 'Files must be 100MB or smaller. We support .mov, .mpg, .avi, .3gp and .wmv file formats.',
        'NEED_HELP' => 'Need help?',
        'HERE_ARE_INSTRUCTIONS' => 'Here are instructions for <a %s>YouTube</a> and <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'The person in charge of %s wants to see your handiwork before showing it to the world.',
        'LEAVE_WINDOW_OPEN' => 'Please leave this window open while the uploading process completes.',
        'KEEP_PAGE_OPEN' => 'Please keep this page open so we can finish uploading your video and we\'ll let you know when it\'s been approved!',
        'MEANWHILE_FEEL_FREE' => 'Meanwhile, feel free to <a %s>open a new browser window</a> and continue using %s. When uploading is complete, you\'ll be able to add a title and description to your video in this window.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'This video is <strong>waiting for approval</strong> from %s\'s creator.',
        'LOADING' => 'Loading…',
        'EDIT_VIDEO' => 'Edit Video',
        'DELETE_VIDEO' => 'Delete Video',
        'YOU_NEED_TO_BE_MEMBER' => 'You need to be a member of %s to add comments!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Join this network</a>',
        'ADD_A_COMMENT' => 'Add a Comment',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Leave a Comment for %s',
        'MORE' => 'More',
        'PREVIOUS' => 'Previous',
        'NEXT' => 'Next',
        'VIEWS' => 'Views:',
        'COMMENTS' => 'Comments',
        'RELATED_VIDEOS' => 'Related Videos',
        'ALL_VIDEOS_TAGGED_X_X' => 'All Videos Tagged %s (%s)',
        'XS_VIDEOS_X' => '%s\'s Videos (%s)',
        'XS_FAVORITES_X' => '%s\'s Favorites (%s)',
        'VIDEO_DETAILS' => 'Video Details',
        'UPLOAD_A_VIDEO_FROM' => 'Upload a video from your computer. We accept all the popular formats!',
        'UPLOAD_VIDEOS_FROM' => 'Upload Videos From Your Computer',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Neither a file nor embed code was specified.',
        'VIDEO_UPLOADED_ON_X' => 'Video uploaded on %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'A problem occurred while converting the video to Flash format: %s',
        'STATUS_N' => 'Status %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Your video titled "%s" could not be added to %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Your video could not be added to %s',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Your video upload on %s did not complete due to a conversion error.',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'You just tried to send a video in to %s. Unfortunately, you’re not a member of %s and we can’t deliver this video.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Your video upload on %s did not complete',
        'FOR_FURTHER_ASSISTANCE_2' => 'For further assistance, visit:',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'To help troubleshoot, provide this video ID: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Your video was successfully uploaded to %s.',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Video transcoding failed for video %s in %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s uploaded a video that failed transcoding.',
        'ERROR_MESSAGE' => 'Error message:',
        'APPLICATION_NAME' => 'Application name:',
        'APPLICATION_ID' => 'Application ID:',
        'VIDEO_ID' => 'Video ID:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Your video upload on %s is complete',
        'TO_VIEW_THE_VIDEO_VISIT' => 'To view the video visit:',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'That video is awaiting approval.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'This video is still being processed.',
        'ADD_VIDEO' => 'Add Video',
        'VIDEO_BY_X' => 'Video by %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'somebody commented on a video you\'ve added to %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'somebody has uploaded a video to %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'More ways to add videos…',
        'FROM_YOUTUBE_OR_GOOGLE' => '…from YouTube or Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Grab the HTML \'embed\' code from any popular video site and add that video to this social network.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Add a video from YouTube or Google',
        'PASTE_IN_EMBED' => 'Paste the \'embed\' code for the video here:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Add video by phone or email',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Add videos by phone or email',
        'VIDEO' => 'video',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Click \'Edit\' and change settings if you would like this box to show up for other people.',
        'MY_FAVORITE_VIDEOS_N' => 'My Favorite Videos (%s)',
        'XS_FAVORITE_VIDEOS_N' => '%s\'s Favorite Videos (%s)',
        'MAP_IT' => 'Map It',
        'HIDE_EMBED_CODE' => 'Hide embed code',
        'VIDEOS_FOR_LOCATION_COUNT' => 'Videos for <em>%1$s</em> (%2$s)',
        'VIDEOS_FOR_LOCATION' => 'Videos for %s',
        'NO_VIDEOS_FOR_LOCATION' => 'There aren\'t any videos for \'%s\'.',

        //video player
        'PLAY_AGAIN' => 'Play Again',
        'SHARE' => 'Share',
        'EMBED' => 'Embed',
        'REWIND' => 'Rewind',
        'CHANGE_SIZE' => 'Change Size',
        'FULLSCREEN' => 'Fullscreen',
        'EXIT_FULLSCREEN' => 'Exit Fullscreen',
        'COPY_AND_PASTE_LINK' => 'Copy and paste this link into an email or instant message:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Find more videos like this on <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'See this video on %s',
        'GET_EMBED_CODE' => 'Get embed code',

        //music player
        'FEATURING_ELLIPSIS' => 'Featuring…',
        'NOW_FEATURED_ON_MAIN' => 'Now Featured',
        'DONT_FEATURE' => 'Stop Featuring',
        'UNFEATURING_ELLIPSIS' => 'Removing…',
        'REMOVED_FROM_MAIN' => 'Not Featured',
        'ADDED_EXCLAMATION' => 'Added!',
        'ERROR' => 'Error',
        'ADDING_ELLIPSIS' => 'Adding…',
        'TRACK_COULD_NOT_BE_LOADED' => 'Song could not be loaded',
        'INVALID_URL' => 'Invalid URL',
        'NORMAL_PLAYBACK_ON' => 'Normal Playback: On',
        'REPEAT_PLAYBACK_ON' => 'Repeat Playback: On',
        'SHUFFLE_PLAYBACK_ON' => 'Shuffle Playback: On',
        'OPEN_POPUP_WINDOW' => 'Open Popup Window',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Loading Playlist…',

        // Photo widget
        'NO_LONGER_FOLLOWING_ALBUM' => 'You are no longer following this album.',
        'FIND' => 'Find',
        'X_ADDED_A_COMMENT_TO_THE_ALBUM_Y_ON_Z' => '%1$s added a comment to the album "%2$s" on %3$s.',
        'ADDED_DATE_AT_TIME' => 'Added %1$s at %2$s',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'This photo is <strong>waiting for approval</strong> from %s\'s creator.',
        'RANDOM_PHOTOS' => 'Random Photos',
        'RANDOM_ALBUMS' => 'Random Albums',
        'SEARCH_PHOTOS' => 'Search Photos',
        'SEARCH_ALBUMS' => 'Search Albums',
        'NO_PHOTOS_FOR_LOCATION' => 'There aren\'t  any photos for \'%s\'.',
        'PHOTOS_FOR_LOCATION_COUNT' => 'Photos for <em>%1$s</em> (%2$s)',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Each photo may be up to 10MB in size. We support photos in the .jpg, .gif and .png file formats. ',
        'NO_FEATURED_PHOTOS' => 'There are no featured photos on this social network.',
        'NO_FEATURED_ALBUMS' => 'There are no featured albums on this social network.',
        'LOCATION_LINK_SHOW_MAP' => '%1$s (<a %2$s>Show Map</a>)',
        'SHOW_MAP' => '(<a %1$s>Show Map</a>)',
        'VIEW_FULL_SIZE' => 'View Full Size',
        'ALBUMS' => 'Albums:',
        'ALBUMS_NO_COLON' => 'Albums',
        'ADDED_BY_USER_ON_DATE_AT_TIME' => 'Added by %1$s on %2$s at %3$s',
        'USER_PHOTOS_N' => '<a %1$s>%2$s\'s</a> Photos (%3$s)',
        'USER_ALBUMS_N' => '<a %1$s>%2$s\'s</a> Albums (%3$s)',
        'MY_PHOTOS_N' => 'My Photos (%s)',
        'MY_ALBUMS_N' => 'My Albums (%s)',
        'USER_FAVORITES_N' => '<a %1$s>%2$s\'s</a> Favorites (%3$s)',
        'MY_FAVORITES_N' => 'My Favorites (%s)',
        'MOST_VIEWED' => 'Most Viewed',
        'TOP_RATED' => 'Top Rated',
        'LATEST_PHOTOS' => 'Latest Photos',
        'MOST_VIEWED_PHOTOS_N' => 'Most Viewed Photos (%s)',
        'MOST_VIEWED_ALBUMS_N' => 'Most Viewed Albums (%s)',
        'TOP_RATED_PHOTOS_N' => 'Top Rated Photos (%s)',
        'LATEST_PHOTOS_N' => 'Latest Photos (%s)',
        'LATEST_ALBUMS_N' => 'Latest Albums (%s)',
        'SEARCH_RESULTS_N' => 'Search Results (%s)',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'I have the right to upload these photos under the <a %s>Terms of Service</a>.',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'The bulk photo uploader requires a recent version of Java. <strong><a %s>Click here to get Java</a></strong>, or <strong><a %s>return to the simple uploader</a></strong>.',
        'TRY_BULK_PHOTO_UPLOADER' => 'Try the bulk photo uploader',
        'HAVE_LOT_OF_PHOTOS' => 'Have a lot of photos you want to share?',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Your photos were successfully uploaded.',
        'PHOTOS_UPLOADED_AWAITING' => 'Your photos were successfully uploaded and are awaiting approval from %s\'s creator.',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => 'Add photos from Flickr',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Add photos or videos to %s directly from your phone by sending them to a unique email address.',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Having problems with the bulk photo uploader?  <strong><a %s>Return to our simple uploader</a></strong>.',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'This network doesn\'t have any photos yet.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'This person doesn\'t have any photos yet.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'This album doesn\'t have any photos yet.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Find more photos like this on <em>%s</em>',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Customize Your Slideshow Player!',
        'UPLOAD_PHOTOS' => 'Upload Photos',
        'PLAYER_COLOR' => 'Player Color',
        'SLIDESHOW_PLAYER' => 'slideshow player',
        'FILTER' => 'Filter',
        'SAVE_ALBUM' => 'Save Album',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Apply this info to the following photos',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'click to add a description',
        'CHECK' => 'Check',
        'YOU_NEED_TO_BE_X' => 'You need to be %s to do that.',
        'ALL_PHOTOS' => 'All Photos',
        'POPULAR_PHOTOS' => 'Popular Photos',
        'FEATURED_PHOTOS' => 'Featured Photos',
        'FEATURED_ALBUMS' => 'Featured Albums',
        'PHOTOS_HOME' =>'Photos Home',
        'ALL_ALBUMS' => 'All Albums',
        'MY_PHOTOS' => 'My Photos',
        'MY_ALBUMS' => 'My Albums',
        'ADD_PHOTOS' => 'Add Photos',
        'ADD_ALBUMS' => 'Add Albums',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Add photos',
        'EDIT' => 'Edit',
        'CHOOSE_PHOTOS' => 'Choose Photos',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Add photos by dragging them</strong> to your album on the right. Remove them by dragging them back.',
        'TITLE_YOUR_ALBUM' => '<strong>Title your album.</strong> Give it a cover and description.',
        'SAVE_YOUR_ALBUM' => 'Save your album!',
        'CHOOSE_FROM' => 'Choose from:',
        'EVERYONES_PHOTOS' => 'Everyone\'s Photos',
        'TAGGED' => 'Tagged:',
        'OLDER_PHOTOS' => 'Older Photos',
        'MORE_RECENT_PHOTOS' => 'More Recent Photos',
        'YOUR_ALBUM' => 'Your Album',
        'DRAG_ALBUM_COVER_HERE' => 'Drag album cover here',
        'ALBUM_TITLE' => 'Album Title:',
        'ALBUM' => 'album',
        'DRAG_PHOTOS_HERE' => 'Drag Your Photos Here',
        'PREVIOUS_ALBUM_PAGE' => 'Previous Album Page',
        'NEXT_ALBUM_PAGE' => 'Next Album Page',
        'VIEW_AS_SLIDESHOW' => 'View as Slideshow',
        'VIEW_SLIDESHOW' => 'View Slideshow',
        'OUR_APOLOGIES' => 'Our apologies',
        'ADD_PHOTOS_TO_ALBUM' => 'Add more photos to this album by choosing from the options below.',
        'YOU_CAN_ADD_PHOTOS' => 'You can <a %s>add photos to this album now</a>.',
        'EDIT_YOUR_ALBUM' => 'Edit Your Album',
        'ALBUMS_WITH_THIS_PHOTO' => 'All Albums with This Photo',
        'ALBUMS_WITH_X' => 'All Albums With \'%s\'',
        'THERE_ARE_NO_ALBUMS_CONTAINING_PHOTO' => 'There aren\'t any albums containing this photo.',
        'CREATE_AN_ALBUM' => 'Create an Album',
        'MAKE_AN_ALBUM' => 'Make an Album',
        'EDIT_ALBUM' => 'Edit Album',
        'DELETE_THIS_ALBUM' => 'Delete this album?',
        'DELETE_ALBUM' => 'Delete Album',
        'START_SLIDESHOW' => 'Start Slideshow',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'You haven\'t added any photos yet!',
        'ADD_PHOTOS_AND_SHARE' => 'Add photos and share them with your friends, family or the rest of the world!',
        'ADD_A_PHOTO' => 'Add a Photo',
        'VIEW_PHOTOS' => 'View Photos',
        'VIEW_ALBUMS' => 'View Albums',
        'ADD_YOUR_FIRST_PHOTOS' => 'Add Your First Photos',
        'UPLOAD_PHOTOS_FROM' => 'Upload photos from your computer:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Add a title and description for your photos',
        'EDIT_PHOTO_INFORMATION' => 'Edit Photo Information',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Add a title, description, and other information to the photos you just uploaded.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Add a title, description, and other information for this photo.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Cancel and return to photo',
        'WHO_CAN_VIEW_PHOTO' => 'Who can view this photo?',
        'BY_ME' => 'by <a %s>Me</a>',
        'RSS_FEED_LABEL' => '<a %s>RSS Feed</a> – %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'There are currently no photos awaiting approval. If you\'re looking for something to do, why not check out the <a %s>latest photos</a>?',
        'APPROVE_ALL_PHOTOS' => 'Approve All Photos?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Are you sure you want to approve all photos? This may take a few minutes.',
        'DELETE_ALL_PHOTOS' => 'Delete All Photos?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Are you sure you want to delete all unapproved photos? This may take a few minutes.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Please keep this browser window open while photos are being approved. This process may take a few minutes.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Please keep this browser window open while photos are being deleted. This process may take a few minutes.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Apply to all Photos added by %s',
        'UNTITLED' => 'Untitled',
        'A_PROBLEM_OCCURRED' => 'A problem occurred',
        'PHOTOS_EXCEEDED_LIMIT' => 'The photo(s) seem to have exceeded the limit of 10 MB per photo.',
        'PHOTOS' => 'Photos',
        'XS_PHOTOS' => '%s\'s Photos',
        'XS_PHOTO' => '%s\'s Photo',
        'YOU_CAN_MARK_PHOTO' => 'You can mark any photo as a favorite. Just click the "Add To Favorites" icon when you see it on a photo.',
        'VIEW_RECENT_PHOTOS' => 'View Recent Photos',
        'APPROVE_PHOTOS' => 'Approve Photos',
        'DELETING_CONTENT' => 'Deleting Content…',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Please keep this browser window open while content is deleted. This process may take a few minutes.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Please keep this browser window open while members are deleted. This process may take a few minutes.',
        'MY_FRIENDS_PHOTOS' => 'My Friends\' Photos',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'View these photos in a slideshow!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Your friends don\'t have any photos yet',
        'ALL_PHOTOS_TAGGED_X' => 'All Photos Tagged \'%s\'',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'There aren\'t any photos tagged "%1$s". Check out <a %2$s>discussions tagged "%1$s"</a>, <a %4$s>blog posts tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>. Or add and tag your own photos!',
        'PHOTO_MAY_BE_10MB' => 'Each photo may be up to 10MB in size, but smaller photos will upload faster. We support photos in the .jpg, .gif and .png file formats.',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Please keep this page open so we can finish uploading your photos and we\'ll let you know when they\'ve been approved!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Meanwhile, feel free to <a %s>open a new browser window</a> and continue using %s. When uploading is complete, you\'ll be able to add titles and descriptions to your photos in this window.',
        'ADD_TO_FAVORITES' => 'Add to Favorites',
        'EDIT_PHOTO' => 'Edit Photo',
        'DELETE_PHOTO' => 'Delete Photo',
        'RETURN_TO_X' => 'Return to %s',
        'RETURN_TO_PHOTOS_HOME' => 'Return to Photos Home',
        'WE_COULD_NOT_FIND_ANYONE' => 'Our apologies - we couldn\'t find anyone',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Nobody has added any photos yet. Add photos to get started.',
        'YOU_HAVENT_ADDED_PHOTOS' => 'You haven\'t added any photos yet. Add photos to get started.',
        'YOU_HAVENT_ADDED_ALBUMS' => 'You haven\'t added any albums yet. Add albums to get started.',
        'USER_HAS_NOT_ADDED_PHOTOS' => '%s hasn\'t added any photos yet.',
        'USER_HAS_NOT_ADDED_ALBUMS' => '%s hasn\'t added any albums yet.',
        'DEFAULT_TITLE' => 'Title',
        'DEFAULT_DESCRIPTION' => 'Description',
        'UPLOAD_LIMIT_EXCEEDED' => 'The upload file size limit was exceeded.',
        'SLOW_DOWN_THERE_CHIEF' => 'Our Apologies',
        'I_DO_NOT_KNOW_USER' => 'Sorry, I don\'t know this person.',
        'I_DO_NOT_HAVE_PHOTO' => 'Sorry, I don\'t have this photo.',
        'I_DO_NOT_HAVE_ALBUM' => 'Sorry, I don\'t have this album.',
        'ALBUM_BY_X_ON_X' => 'Album by %s on %s',
        'I_HAVE_RECENTLY_ADDED' => 'I\'ve Recently Added',
        'FROM_THE_BAZEL' => 'From This Network',
        'RECENTLY_ADDED' => 'Recently Added',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Recent public photos on %s',
        'X_ALL_PHOTOS' => '%s - All Photos',
        'NO_TAG_WAS_SPECIFIED' => 'No tag was specified',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Public photos tagged with %s on %s',
        'XS_PUBLIC_PHOTOS_ON_X' => '%s\'s public photos on %s',
        'WE_DO_NOT_KNOW_USER' => 'We don\'t know this person.',
        'XS_FRIENDS_PHOTOS' => '%s\'s Friends\' Photos',
        'XS_FAVORITE_PHOTOS_ON_X' => '%s\'s favorite photos on %s',
        'PHOTO_UPLOADED_ON_X' => 'Photo uploaded on %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'The file exceeded the maximum size',
        'PART_OF_FILE_WAS_UPLOADED' => 'Only part of the file was uploaded',
        'NO_FILE_WAS_UPLOADED' => 'The upload failed; the filename may have been incorrect',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'A problem occurred during the upload.',
        'ALPHABETICAL' => 'Alphabetical',
        'RATING_NOT_RATED_YET' => '<strong>Rating:</strong> Not rated yet',
        'NOT_RATED_YET' => 'Not rated yet',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm… something went awry',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Your photo titled "%s" could not be added to %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Your photo could not be added to %s',
        'YOU_JUST_TRIED_TO_SEND' => 'You just tried to send a photo in to %s. Unfortunately, you’re not a member of %s and we can’t deliver this photo.',
        'ONLY_MY_FRIENDS' => 'Only My Friends',
        'ANYBODY' => 'Anybody',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Only my friends can see this photo',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Only %s\'s friends can see this photo',
        'ONLY_I_CAN_SEE_PHOTO' => 'Only  I can see this photo',
        'ONLY_X_CAN_SEE_PHOTO' => 'Only %s can see this photo',
        'EVERYONE_CAN_SEE_PHOTO' => 'Everyone can see this photo',
        'PRIVATE_PHOTO' => '<strong>Private</strong> photo',
        'HOWDY_STRANGER' => 'Howdy, Stranger!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'You need to be signed into Ning before you can do that.',
        'JUST_CLICK_ON_SIGN_IN' => 'Just click on "Sign In" above, or if you don\'t yet have a Ning account, click "Sign Up".',
        'YOU_NEED_TO_BE_OWNER' => 'You need to be the network creator to do that.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'That photo is awaiting approval.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'You need to be a friend of %s to do that.',
        'MOST_ACTIVE' => 'Most Active',
        'HOW_IT_WORKS' => 'How it works',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'More ways to add photos…',
        'BY_PHONE_OR_EMAIL' => '…by phone or email',
        'FROM_FLICKR' => '…from Flickr',
        'FROM_YOUR_COMPUTER' => '…from your computer',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Add photos from your Flickr account.',
        'MORE_INFORMATION' => 'More Information',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Add photos by phone or email',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Send one photo or video per email. The subject of the email becomes the title of the photo or video, and the body becomes the description.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Click here to get a new email address',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Upload photos from your computer.',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Upload Photos From Your Computer',
        'PHOTO' => 'photo',
        'CURRENTLY_DISPLAYING_NO_ALBUMS' => 'You are currently displaying no albums.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_ALBUM' => 'This box won\'t show up for other people unless you select at least one album.',
        'THERE_ARE_NO_FEATURED_ALBUMS' => 'There are no featured albums on your social network.',
        'START_FEATURING_ALBUMS' => 'Start featuring albums where you see the Feature option. To learn more about featuring, <a %s>click here</a>.',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'You are currently displaying no photos.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'This box won\'t show up for other people unless you select at least one photo.',

        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'somebody commented on a photo you\'ve added to %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'somebody has uploaded a photo to %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Add photos or videos to %s directly from your phone by sending them to an email address.',
        'DELETE_THIS_PHOTO_Q' => 'Delete This Photo?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Are you sure you want to delete this photo? This process may take a few minutes.',
        'PHOTO_SLIDESHOW' => 'Slideshow',
        'THUMBNAILS' => 'Thumbnails',
        'ROTATE_PHOTO' => 'Rotate Photo',

        //slideshow player
        'SEE_PHOTOS_ON_NETWORK' => 'See these photos on %s',
        'EMBED_CODE' => 'Embed Code',

        // flickr import
        'IMPORT_PHOTOS_FLICKR' => 'Get Your Photos from Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Click here to continue to Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'To get your photos from Flickr, you first need to allow %S to link to your Flickr account.',
        'GET_MY' => 'Get my',
        'GET_PHOTOS' => 'Get Photos',
        'MOST_RECENT_PHOTOS' => 'most recent photos',
        'GET_ALL_MY_FLICKR' => 'Get all of my photos from Flickr (may take a while)',
        'GET_ALL_MY_TAGGED' => 'Get all of my photos tagged',
        'GET_PHOTOS_FROM_SET' => 'Get photos from a set:',
        'GET_STARTED_BY_IMPORT' => 'We\'ll automatically get your titles, tags and any mapping information you have.<br/>How long will it take?</p> <p><ul style="padding-top:10px;"><li>10 Photos: <em>less than 30 seconds</em>.</li><li>50 Photos: <em>about 2 minutes</em>.</li><li>200 Photos: <em>about 6 minutes</em>.</li><li>500 photos: <em>about 15 minutes</em>.</li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'If you\'re not signed in to Flickr, you will be asked to sign in. Once you\'re signed in, click the button that says "OK, I\'ll allow it".',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Get descriptions too (this will double the time it takes).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Please keep this page open so we can finish importing your photos.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Get the full-size version of each photo (this will increase import time significantly and we don\'t recommend it for more than 20 photos).',




        // HTML widget
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Click "edit" to add text, videos, photos, or any widget to this box. It\'s another way you can make your %s page your own.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Click \'Edit\' to add text, HTML, videos, photos, or any <a %1$s>third-party widgets</a> to this box.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'This box won\'t show up for other people until you update its content.',
        'YOUR_X_BOX' => 'Your %s Box',
        'ABOUT_WIDGETS' => 'About Widgets',
        'WIDGETS' => 'Widgets',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Looking to add more functionality to your social network? Perhaps a calendar, local weather report, event countdown or webcam? With widgets, it\'s easy to add additional features to any Text Box on your network.',
        'GETTING_STARTED' => 'Getting Started',
        'BELOW_IS_LIST_OF_WIDGET' => 'Below is a <a %s>list of widget providers</a> you may want to check out. We\'ve selected a few widgets from <a %s>yourminis.com</a> to get you started. Just set up a widget below, copy the embed code and paste it directly into the Text Box. Go for it!',
        'CALENDAR' => 'Calendar',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'The Calendar widget not only displays the date, but also allows you to search for and add iCal format events (used by Google Calendar and many other online calendar providers).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Use the &#8220;edit widget&#8221; button to select &#8220;search for events&#8221;, then enter a search term (try holidays, a sports team, etc.). Then just select a search result to have those events added to your calendar. You can also manually enter the address of any existing iCal feed.',
        'CUSTOMIZATION' => 'Customization',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'You can customize the appearance of the widget by mousing over the widget, then clicking the color picker icon to change the background, widget style and transparency level. When you\'re done, click the &#8220;copy to web&#8221; link, then the &#8220;copy embed code&#8221; button. Once the code is copied, just return to any Text Box on your network, paste the code in and save your changes. All set!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Get more widgets from yourminis.com »',
        'WEATHER' => 'Weather',
        'WEATHER_WIDGET_DISPLAYS' => 'The Weather widget displays local weather forecasts from the Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Use the &#8220;edit widget&#8221; button to select your location and choose Fahrenheit or Celsius. You can choose to display weather for just the current day, or expand it to a five-day forecast.',
        'COUNTDOWN' => 'Countdown',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'The Countdown widget lets you create a countdown to a specific event. By clicking the &#8220;edit widget&#8221; button, you can enter the date, time and title or image of an event to count down to.',
        'WEBCAM' => 'Webcam',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'The Webcam widget allows you to actively monitor any publicly-available webcams. Use the &#8220;edit widget&#8221; button to select from a list of pre-defined webcams, or manually enter any webcam\'s URL.',
        'MORE_WIDGETS' => 'More Widgets',
        'NEED_MORE_OPTIONS' => 'Need more options? We recommend any of the following sites to quench your widget thirst:',

        // lib files
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'You have a new %1$s to approve on %2$s…',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'You have a new %1$s to approve on %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'You have a new %1$s "%2$s" to approve on %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'To approve this %s, visit:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Your %1$s on %2$s has been approved…',
        'WELCOME' => 'Welcome',
        'WELCOME_TO_X' => 'Welcome to %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Welcome to %s…',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">New Features!</h3>
            <ul><li><strong>Groups</strong> &ndash; Let your members create groups on your network</li>
                <li><strong>Music Player</strong> &ndash; Add music and podcasts to your network</li></ul>
            <p><a href="%s" class="desc add">Click here to add features</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">New Features!</h3>
            <ul><li><strong>Latest Activity</strong> &ndash; Follow the latest member activity on your network</li>
                <li><strong>Badges & Widgets</strong> &ndash; Promote your network across the web with custom badges and widgets</li></ul>
            <p><a href="%s" class="desc add">Click here to add/edit features</a></p>',
        'USER_COMMENTED_ON_YOUR_OBJECT_ON_X' => '%1$s commented on your %2$s on %3$s.',
        'USER_COMMENTED_ON_YOUR_OBJECT_TITLE_ON_X' => '%1$s commented on your %2$s "%3$s" on %4$s.',

        // Email messages (/lib/XG_Message/*)
        'CLICK_HERE_TO_JOIN' => 'Click here to join:',
        'THANKS_VALEDICTION' => 'Thanks,',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'You changed your email address on %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'You changed your email address on %s…',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Click here to sign in with your new email address:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'If you did not change your email address, click here:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'To stop being notified of new discussions, go to:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s started a new discussion on %2$s…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s started the discussion "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'To view this discussion, go to:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s has invited you to join %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s wants you to check out "%2$s" on %3$s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Check out "%s" on %s!',
		'CHECK_OUT_UNTITLED_ON_APPNAME' => 'Check this out on %s!',//!!
        'ABOUT_X' => 'About %s',
        'ABOUT_X_ELLIPSIS' => 'About %s…',
        'USER_WANTS_YOU_CHECK_OUT_PHOTO' => '%1$s wants you to check out the photo \'%2$s\'…',
		'USER_WANTS_YOU_CHECK_OUT_THIS_PHOTO' => '%1$s wants you to check out this photo…',
        'PHOTO_DESCRIPTION_COLON' => 'Photo description:',
        'PHOTO_LINK' => 'Photo link:',
        'USER_WANTS_YOU_CHECK_OUT_ALBUM' => '%1$s wants you to check out the album \'%2$s\'…',
		'USER_WANTS_YOU_CHECK_OUT_THIS_ALBUM' => '%1$s wants you to check out this album…',
        'ALBUM_DESCRIPTION_COLON' => 'Album description:',
        'ALBUM_LINK' => 'Album link:',
        'USER_WANTS_YOU_CHECK_OUT_VIDEO' => '%1$s wants you to check out the video \'%2$s\'…',
		'USER_WANTS_YOU_CHECK_OUT_THIS_VIDEO' => '%1$s wants you to check out this video…',
        'VIDEO_DESCRIPTION_COLON' => 'Video description:',
        'VIDEO_LINK' => 'Video link:',
        'USER_WANTS_YOU_CHECK_OUT_DISCUSSION' => '%1$s wants you to check out the discussion \'%2$s\'…',
		'USER_WANTS_YOU_CHECK_OUT_THIS_DISCUSSION' => '%1$s wants you to check out this discussion…',
        'DISCUSSION_DESCRIPTION' => 'Discussion posted by <a %1$s>%2$s</a>:',
        'DISCUSSION_LINK' => 'Discussion link:',
        'USER_WANTS_YOU_CHECK_OUT_POST' => '%1$s wants you to check out the blog post \'%2$s\'…',
		'USER_WANTS_YOU_CHECK_OUT_THIS_POST' => '%1$s wants you to check out this blog post…',
        'POST_DESCRIPTION' => 'Blog post added by <a %1$s>%2$s</a>:',
        'POST_LINK' => 'Blog post link:',
        'USER_SAYS_ELLIPSIS' => '%s says…',
        'USER_WANTS_YOU_CHECK_OUT_PROFILE' => '%1$s wants you to check out %s\'s profile…',
        'USER_WANTS_YOU_CHECK_OUT_THIS_PROFILE' => '%1$s wants you to check out this profile…',
        'PROFILE_HAS' => '%s has:',
        'PROFILE_LINK_HAS' => '<a %1$s>%2$s</a> has:',
        'PROFILE_LINK' => 'Profile link:',
        'SEE_DETAILS_AND_RSVP' => 'See more details and RSVP on %s:',
        'USER_INVITED_YOU_TO_EVENT' => '%1$s has invited you to the event \'%2$s\' on %3$s!',

        'ABOUT_X_ON_Y' => 'About %1$s on %2$s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'You have received this email because %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'If you no longer wish to receive notification emails from %s, <a %s>please click here</a>.',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'A message to all members of %s',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Your %s has been approved on %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Your %1$s "%2$s" has been approved on %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'To view your %s, visit:',
        'TO_VIEW_THIS_X_VISIT' => 'To view this %s, visit:',
        'TO_VIEW_IT_VISIT' => 'To view it, visit:',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s has reported an issue on %2$s…',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s reported the following issue on %2$s…',
        'URL_REPORTED_COLON' => 'URL Reported:',
        'ISSUE_COLON' => 'Issue:',
        'ADDITIONAL_INFORMATION_COLON' => 'Additional Information:',
        'SEND_AN_INVITATION_TO_X' => 'Send an invitation to %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'somebody has requested to join %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Want to add a welcome message for %s on their profile?  Go to:',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s has sent you a message on %2$s.',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s has sent you a message on %s…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s has added you as a friend on %s…',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s has accepted your friend request on %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'To accept this friend request, visit:',
        'VIEW_XS_PAGE_ON_Y' => 'View %s\'s page on %s',
        'MEMBER_OF_X_ACCEPTED' => 'a member of %s accepted your friend request',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'If you no longer wish to receive friend request notification emails from %s, <a %s>please click here</a>.',
        'ON_X_COLON' => 'On %s:',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s has requested to join %2$s on %3$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s has requested to join %2$s on %3$s…',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'To approve or deny %s\'s request, visit:',
        'VISIT_GROUP_AT' => 'Visit %s at:',
        'VISIT_EVENT_AT' => 'Visit %s at:',
        'SEARCH_GROUPS' => 'Search Groups',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'A message from %s to all members of %s on %s!',
        'A_MESSAGE_FROM_USERNAME_TO_EVENTNAME_ON_APPNAME' => 'A message from %1$s to guests of %2$s on %3$s!',
        'A_MESSAGE_FROM_USERNAME_TO_EVENTNAME' => 'A message from %1$s to guests of %2$s',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'You can sign in using your email address here:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s added a comment to the blog post "%2$s" on %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s added a comment to a blog post on %2$s…',
        'SEND_X_A_MESSAGE_HERE' => 'Send %s a message here:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'You have a new member to approve on %s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'You have a new member to approve on %s.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'To approve %s\'s profile, visit:',
        'CLICK_HERE_TO_JOIN_COLON' => 'Click here to join:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Click here to join!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Your %s membership has been approved…',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Congratulations!  Your %s membership has been approved.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'You can now sign in using your email address here:',
        'VISIT_X_AT_Y' => 'Visit %1$s at: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'To control which emails you receive on %1$s, go to:',
		'TO_REPLY_CLICK_HERE_COLON' => 'To reply to this message, click here:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'A banned member has sent you a message on %s…',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'A banned member has sent you a message on %1$s.  %2$s writes:',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Welcome to the Group "%1$s" on %2$s',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Welcome to %1$s on %2$s…',
        'TO_VIEW_THIS_GROUP_VISIT' => 'To view this group visit:',
        'COME_JOIN_ME_ON_X' => 'Come join me on %s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s is now a member of %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s is now a member of %2$s…',
        'SOMEBODY' => 'Somebody',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'To view your new comment, visit:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'To view the new comment, visit:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'To view the new reply, visit:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Welcome to %s! Thank you for joining.',
        'NAME_COLON' => 'Name:',
        'EMAIL_COLON' => 'Email:',
        'GENDER_COLON' => 'Gender:',
        'COUNTRY_COLON' => 'Country:',
        'MOST_ACTIVE_GROUPS' => 'Most Active Groups',
        'GROUPS_BY_LATEST_ACTIVITY' => 'Groups by Latest Activity',
        'GROUPS_BY_MOST_MEMBERS' => 'Groups by the Most Members',
        'LATEST' => 'Latest',
        'LATEST_GROUPS' => 'Latest Groups',
        'PLEASE_SELECT_A_MEMBER' => 'Please select one or more members',
        'ANYONE_CAN_JOIN_GROUP' => 'Anyone can join this group',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Only invited people can join this group',

        // Index widget
        'CLICK_HERE' => 'Click Here',
        'PROFILE_ICON' => 'Profile Icon',
        'COMMENTS_TITLE' => 'Comments - %s',
        'NO_RESULTS_FOR_SEARCH_TERM' => 'No results for <em>%s</em>',
        'NO_RESULTS_FOUND_FOR_SEARCH_TERM' => 'No results were found for \'%s\'.',
        'AWAITING_APPROVAL_APPROVE_DELETE' => '<strong>Awaiting Approval</strong>: <a %1$s>Approve</a> or <a %2$s>Delete</a>',
        'AWAITING_APPROVAL_APPROVE' => '<strong>Awaiting Approval</strong>: <a %1$s>Approve</a>',
        'COMMENT_BY_USER_WHEN' => 'Comment by %1$s %2$s',
        'COMMENT_BY_USER_DATE_TIME' => 'Comment by %1$s on %2$s at %3$s',
        'LOADING_YOUR_FRIENDS' => 'We\'re loading your friends…',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Your Message Has Been Sent',
        'TO_SEND_ANOTHER_MESSAGE' => 'To send another message, please enter your text below.',
        'PLEASE_CHOOSE_FRIENDS' => 'Please select some friends before sending your message.',
        'RESEND_INVITATION' => 'Resend Invitation',
        'CHOOSE_FRIENDS' => 'Choose Friends…',
        'ALL_FRIENDS' => 'All Friends',
        'ALL_FRIENDS_ON_APPNAME' => 'All Friends on %s',
        'SHARE_WITH_FRIENDS' => 'Share with Friends',
        'SHARE_THIS_WITH_FRIENDS' => 'Share This Item With Your Friends',
        'COMPOSE_MESSAGE' => 'Compose Message',
        'INVITATION_LINK_ONLY_VISIBLE' => 'This invitation link is only visible to the Network Creator and Administrators. Members who join with this link will automatically become friends with the Network Creator.',
        'WE_ARE_LOADING_ADDRESSES' => 'We\'re loading your addresses…',
        'SELECT_ALL_NONE' => 'Select All/None',
        'INVITE_TO_APPNAME' => 'Invite to \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Invite Your Friends to \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Already a member of this network)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Or share this invitation link:',
        'CLICK_TO_MAIL' => '<a %s>Click here to mail now</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Your Message Has Been Sent',
        'YOU_CAN_SHARE_THIS' => 'You can share with more people below, or <a %s>go back to the previous page</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'We\'re sorry, but the vCard import service is currently unavailable. ',
        'CSV_IMPORT_UNAVAILABLE' => 'We\'re sorry, but the CSV import service is currently unavailable. ',
        'ERROR_OCCURRED' => 'We\'re sorry, but an error has occurred.',
        'IMPORT_FAILED' => 'We\'re sorry, but the import failed.',
        'LOGIN_FAILED' => 'We\'re sorry, but the login failed.',
        'UNABLE_TO_FIND_EMAIL' => 'We\'re sorry, but we\'re unable to find the email field. ',
        'CANNOT_READ_VCARDS' => 'We\'re sorry, but we can\'t read these vCards.',
        'GET_NETWORK_BADGE' => '%s Badge',
        'SPREAD_WORD_GET_BADGE' => 'Spread the word. Get your own %s badge for your website or MySpace page. (<a %s>Get Code</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Spread the word. <a href="%s">Get your own %s badge</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Show your allegiance. Get your own %s badge to put on your website or MySpace page. (<a %s>Get Code</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s commented on the %2$s "%4$s" on %3$s',
        'ADMINISTRATORS' => 'Administrators',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Your Invitation Has Expired',
        'SORRY_INVITATION_EXPIRED' => 'We\'re sorry, the invitation you\'ve used has expired.  You will need a new invitation to join %s.',
        'DISABLE_INVITATION_LINK' => 'Disable Invitation Link?',
        'CREATING_LINK_WILL_DISABLE' => 'Creating a new invitation link will disable the current link. Are you sure you want to create a new link?',
        'SHARE_LINK_WITH_PEOPLE' => 'Share this link with people you want to join this network:',
        'CREATE_INVITATION_LINK' => 'Create New Invitation Link',
        'PLEASE_SELECT_SECOND_PART' => 'Please select the second part of your email address, e.g., gmail.com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Please ensure that the @ symbol is not in the first part of the email address.',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Sorry, we don\'t support the web address book for your email address. Try clicking \'Address Book Application\' below to use addresses from your computer.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Please enter your password for %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importing Address Book',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Please leave this window open</strong> while we get your friends\' email addresses. When we\'ve finished, you can choose which friends to invite.',
        'SHARE_THIS_LINK' => 'Share this link:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Send it with your computer\'s email program:',
        'EMAIL_THIS' => 'Email this',
        'SEARCH_FRIENDS_TO_INVITE' => 'Search Friends to Invite:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Your Invitations Have Been Sent',
        'NO_ADDRESSES_FOUND' => 'No Addresses Found',
        'WE_DID_NOT_FIND_ADDRESSES' => 'We didn\'t find any addresses in the address book we imported.',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Want to invite more friends? Import contacts from your web or desktop address book application.',
        'MESSAGE_TOO_LONG' => 'Your message is too long. Please use less than %s characters.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'The following do not seem to be valid email addresses. The invitations were not sent. Please correct the email addresses and try again.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Please enter one or more email addresses.',
        'ENTER_EMAIL_ADDRESSES' => 'Enter Email Addresses',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Separate multiple addresses with commas',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Your Message</label> (Optional)',
        'SEND_INVITATIONS' => 'Send Invitations',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Import from Web Address Book',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail or AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Your Email Address',
        'IMPORT_ADDRESS_BOOK' => 'Import Address Book',
        'DONT_WORRY_WE_WONT_SAVE' => 'Don\'t worry, we won\'t save your password and you\'ll get a chance to choose which friends to email.',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Import from Address Book Application',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Address Book, .CSV, etc.',
        'UPLOAD_CSV_OR_VCF' => 'Upload a .csv or .vcf file exported from Microsoft Outlook or Apple Address Book.',
        'BROWSE_FOR_FILE' => 'Browse For File',
        'UPLOAD' => 'Upload',
        'SELECT_ELLIPSIS' => 'select…',
        'OTHER_ELLIPSIS' => 'other…',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Don\'t worry, you\'ll get a chance to choose which friends to email.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Membership by Invitation Only',
        'IF_YOU_ARE_ADMIN' => 'If you are the Network Creator, <a %s>click here to sign in</a>.',
        'NAME_MUST_BE_SHORTER' => 'Name has to be shorter than %s characters',
        'CITY_NAME_MUST_BE_SHORTER' => 'City name has to be shorter than %s characters',
        'EMAIL_ALREADY_REGISTERED' => 'The email address has already been registered. Please choose another.',
        'EMAIL_NOT_VALID' => 'The email address does not seem to be valid.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s invited you to %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'You are signing up with your Ning ID.',
        'NOW_ENTER_PASSWORD' => 'Now just enter your password to continue.',
        'OR_SIGN_IN' => 'or <a %s>Sign In</a>',
        'CHANGE_ADDRESS' => 'Change Address',
        'CHANGE_PAGE_ADDRESS' => 'Change Page Address',
        'PAGE_ADDRESS_TAKEN' => 'Our apologies - that address has already been taken. Please choose another.',
        'PAGE_ADDRESS_NOT_VALID' => 'You may only use the letters A-Z, numbers and underscores (_) in your address.',
        'ADD_BY_PHONE' => 'Add By Phone',
        'PAGE_ADDRESS' => 'Page Address',
        'PHOTO_MUST_BE_TYPE' => 'Your photo must be a .jpg, .gif or .png file.',
        'USEFUL_ADDRESSES' => 'Useful Addresses',
        'MY_DETAILS' => 'My Details',
        'NONE_I_DO_NOT_WANT' => 'None: I don\'t want to receive emails from %s',
        'CHANGE_PASSWORD' => 'Change Password',
        'PROFILE_SAVED' => 'Your changes were saved successfully.',
        'UPDATE_EMAIL_ADDRESS' => 'Update Email Address',
        'EDIT_EMAIL_ADDRESS' => 'Edit Your Email Address',
        'MY_SETTINGS' => 'My Settings',
        'ABOUT_ME' => 'About Me',
        'SELECT' => 'Select…',
        'CITY' => 'City',
        'COUNTRY' => 'Country',
        'DATE_OF_BIRTH' => 'Date of Birth',
        'DO_NOT_DISPLAY' => 'Don\'t Display',
        'GENDER' => 'Gender',
        'CREATE_YOUR_PROFILE' => 'Create Your Profile',
        'SYSTEM_REQUIREMENTS' => 'System Requirements',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'We support Internet Explorer 6 & 7, Firefox 2.0 and Safari 2.0. If you\'re using a different browser (perhaps one provided by your internet service provider) it might not be compatible.',
        'MAKE_SURE_COOKIES' => 'Make sure cookies and JavaScript are enabled on your browser.',
        'WHAT_IS_MY_EMAIL' => 'What is my Email Address?',
        'IF_JOINED_BEFORE_OCTOBER' => 'If you joined before October 5th 2007, you may previously have been prompted for a \'Ning ID\'. We now ask for you to sign in with the email address you registered with, however you can still enter your Ning ID in this field.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Click here to reset your password.',
        'STILL_HAVING_PROBLEMS' => 'Still having problems?',
        'VISIT_NING_HELP_CENTER' => 'Visit the <a %s>Ning Help Center</a> for more troubleshooting information and support.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problems Signing Up or Signing In',
        'WE_SENT_YOU_EMAIL' => 'We\'ve sent you an email with a link to reset your password.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Password Reset',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

We received a request to change your password on %2$s.

Click the link below to set a new password:

#{URL}

If you don\'t want to change your password, you can ignore this email.

Thanks,
The "%2$s" Team

-----
%2$s uses the Ning ID for authentication.',
        'SET_PASSWORD' => 'Set Password',
        'NEW_PASSWORD' => 'New Password',
        'CREATE_NEW_PASSWORD' => 'Create a New Password',
        'SET_NEW_PASSWORD' => 'Set a new password for your account.',
        'CHOOSE_NEW_PASSWORD' => 'Please choose a new password',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Hello, %s</strong> (<a %s>Sign Out</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'There is no account with the email address %s',
        'PLEASE_ENTER_CODE' => 'Please enter the code that appears on the right-hand side.',
        'PROBLEMS_SIGNING_UP' => 'Problems signing up?',
        'BY_SIGNING_UP_YOU_AGREE' => 'By signing up, you agree to the <a %s>Terms of Service</a> and <a %s>Privacy&nbsp;Policy</a>.',
        'FEEDBACK' => 'Feedback',
        'TERMS_OF_SERVICE' => 'Terms of Service',
        'PRIVACY_POLICY' => 'Privacy Policy',
        'PROBLEM_SIGNING_UP' => 'There was a problem signing up',
        'ALREADY_MEMBER_SIGN_IN' => 'Already a member? <a %s>Click here to sign in</a>.',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => ' Apply for membership now. Already a member? <a %s>Click here to sign in</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Membership to %s is By Invitation Only',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'We\'re sorry, but the administrator has chosen to require an invitation to join %s. If you have an invitation, click the link in the email to join.',
        'PROBLEM_SIGNING_IN' => 'There was a problem signing in',
        'WE_USE_NING_ID' => 'We use Ning ID for authentication. <a %s>What is a Ning ID?</a>',
        'PROBLEMS_SIGNING_IN' => 'Problems signing in?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Sign In" /> &#160;or&#160; <strong><a %s>Sign Up</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Sign in to %s',
        'WHAT_IS_A_NING_ID' => 'What is a Ning ID?',
        'LARR_BACK' => '← <a %s>Back</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'The Ning ID authentication system lets you choose an email address and password once and use it to join or sign into any social network that uses the Ning ID.',
        'WHEN_YOU_CREATE_NING_ID' => 'When you create a Ning ID, you can also add a set of basic details and your photo to your Ning ID account. These details are then pre-populated whenever you join a new social network that uses the Ning ID for authentication. It also enables you to keep track of your friends and messages across all the social networks that use it.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'You can sign in with your Ning ID email address and password whenever you see this symbol: %s',
        'HELLO_USER' => 'Hello, %s',
        'TEXT_FOR_HEADER_TAB' => 'This text is for a header tab',
        'BASED_ON' => 'Based on',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Are you sure you want to delete this language?',
        'DELETE_LANGUAGE' => 'Delete Language',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'The text has been reset to the original version.',
        'UPLOAD_LANGUAGE_FILE' => 'Upload Language File',
        'ADD_TO_LANGUAGE' => 'Add to Language:',
        'IF_YOU_CREATED_TRANSLATION' => 'If you\'ve created a new translation on another Ning social network, you can import your work here. The contents of the file will be added to the language of your choice. Don\'t see your language listed? <a %s>It\'s easy to add a new one</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Examples: Swedish (Finland), Filipino, Spanish (Puerto Rico)',
        'START_FROM_SCRATCH_CREATE' => 'Start from scratch! Create a new translation for your network by entering a name for the new language, then picking an existing language as a reference point.',
        'KEY_MISSING_TEXT' => 'Key: <span %s>Missing Text</span> <span %s>Changed Text</span>',
        'SHOW_ALL_TEXT' => 'Show All Text',
        'SHOW_MISSING_TEXT' => 'Show Missing Text',
        'SHOW_CHANGED_TEXT' => 'Show Changed Text',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Examples: Tabs, Members, Friends',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Reset Text to Original Version',
        'ORIGINAL_TEXT_X' => 'Original Text – %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Edit the Language on Your Network',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Customize any of the text on your network, including tab names, email footers, error messages and more.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>The active language for your network is %1$s</em>. <a %2$s>Change Active Language</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Current Language Options',
        'MY_LANGUAGES' => 'My Languages',
        'CREATE_NEW_TRANSLATION' => 'Create a New Translation',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Don\'t see your language listed above? <strong><a %s>Create a new translation for your network</a></strong>.',
        'ADVANCED_IMPORT' => 'Advanced Import',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'If you\'ve translated a language on an existing social network, you can <strong><a %s>import your language file</a></strong> and use it on this network.',
        'LANGUAGE_EDITOR' => 'Language Editor',
        'PUBLIC' => 'Public',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Your current privacy setting, a public network where non-members can only view the login screen, is no longer available.  Your privacy setting has not been changed, but if you make any changes here, you will not be able to return.  The current equivalent is a private network that anyone can sign up to become a member.',
        'NO_MISSING_ITEMS' => 'There are no missing items – this translation is 100%% complete. <a %s>View all items.</a>',
        'NO_CHANGED_ITEMS' => 'There are no changed items.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Our apologies – we couldn\'t find any items matching <em>%s</em>. <a %s>View all items.</a>',
        'FILE_N' => 'File %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'A Ning translation file has a filename like <code>en_US.txt</code>. <a %s>Learn more here.</a>',
        'SELECT_TRANSLATION_FILE' => 'Select Translation File:',
        'USE_THIS_TRANSLATION' => 'Use This Translation',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Note that the following are missing from the rules below: %s',
        'TRANSLATION_CHANGES_SAVED' => 'Your changes have been saved. This translation is %s%% complete.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Your changes have been saved. This translation is %s%% complete. Would you like to use this as the current language for your network?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Your upload was successful. This translation is %s%% complete.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Your upload was successful. This translation is %s%% complete. Would you like to use this as the current language for your network?',
        'X_IS_CURRENT_LANGUAGE' => '%s is now the language of your network.',
        'SAVE_PAGE' => 'Save Page',
        'LANGUAGE_NAME_TAKEN' => 'Our apologies - that name has already been taken. Please choose another name.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Please enter a name for your new translation, e.g., Portuguese (Portugal)',
        'CREATE' => 'Create',
        'LANGUAGE_NAME' => 'Language Name',
        'SAVE_ITEMS_ON_PAGE' => 'Save the items on this page',
        'MISMATCHED_CURLY_BRACKETS' => 'Mismatched curly brackets',
        'MISMATCHED_SQUARE_BRACKETS' => 'Mismatched square brackets',
        'MISMATCHED_PARENTHESES' => 'Mismatched parentheses',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'An error occurred while processing the Special Rules code.',
        'ERROR_PROCESSING_TAB_NAMES' => 'An error occurred while processing the Tab Names code.',
        'SPECIAL_RULES' => 'Special Rules',
        'TAB_NAMES' => 'Tab Names',
        'LANGUAGE_EDITOR_X' => 'Language Editor: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Back to Language Editor',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Customize your network\'s text and messages or create a new language.',
        'STOPWORDS' => 'a | about | an | are | as | at | be | by | com | de | en | for | from | how | i | in | is | it | la | of | on | or | that | the | this | to | was | what | when | where | who | will | with | und | the | www',
        'STOPWORDS_ARE' => '<a %s>Stopwords</a> are an optional list of words to filter out of the network description when creating the meta tag at the top of each page. Optional.',
        'I_AM_MEMBER' => 'I\'m a member of:',
        'VIEW_PAGE_ON_APPNAME' => 'View my page on <em>%s</em>',
        'VISIT_APPNAME' => 'Visit <em>%s</em>',
        'JOIN_US' => 'Join Us',
        'CREATED_BY_COLON' => 'Created By:',
        'GET_MORE_BADGES' => 'Get More Badges',
        'GALLERY' => 'Gallery',
        'BADGES' => 'Badges',
        'MEMBER_BADGE' => 'Member Badge',
        'WEAR_IT_WITH_PRIDE' => 'Wear it with pride! Get a %s member badge that you can display on your website or MySpace page.',
        'NETWORK_BADGE_LARGE' => 'Network Badge (Large)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Spread the word! Get a %s badge that dynamically updates with the networks most popular members. Add it to your website or MySpace page.',
        'NETWORK_BADGE_SMALL' => 'Network Badge (Small)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Spread the word! Get a %s badge that you can display on your website or MySpace page.',
        'PHOTO_SLIDESHOW_PROPER' => 'Photo Slideshow',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Display a selection of your photos on a website or MySpace page with our stylish photo slideshow player.',
        'MUSIC_PLAYER' => 'Music Player',
        'PLAY_MUSIC_ON_WEBSITE' => 'Play your music on a website or MySpace page with our stylish music player.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Add a video to your website or MySpace page. Looking for more options? <a href="%s">View all videos</a> on %s.',
        'LARGE_N_PIXELS_WIDE' => 'Large - %d pixels wide',
        'MEDIUM_N_PIXELS_WIDE' => 'Medium - %d pixels wide',
        'SMALL_N_PIXELS_WIDE' => 'Small - %d pixels wide',
        'MY_MOST_RECENT' => 'My Most Recent',
        'APP_ICON' => 'App Icon',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s provided the following feedback on %2$s:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s provided feedback on %2$s…',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Thank you.  Your message has been sent.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s would like to join %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s has requested an invitation to %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Your request has been sent to the network creator.',
        'TO_UNBAN_USERNAME_GO_TO' => 'To unban %s, go to:',
        'SEARCH' => 'Search',
        'SEARCH_AGAIN' => 'Search Again',
        'SEND_BROADCAST_MESSAGE' => 'Send Broadcast Message',
        'VERIFICATION_IMAGE' => 'Verification Image',
        'UNDER_CONSTRUCTION' => 'Under Construction',
        'PROFILE_INFORMATION_SAVED' => 'Profile Information Saved',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'Your Network\'s directory profile information has been saved.',
        'NO_ACCOUNT_WITH_EMAIL' => 'There is no account with that email address.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Wrong password.  Is Caps Lock on?',
        'OOPS_THAT' => 'Oops – that didn\'t work.',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Oops – that didn\'t work (%s).',
        'YOUR_SITES_FEATURE_LIST' => 'Your Network\'s feature list has been saved.',
        'ONE_LINE_ANSWER' => 'One Line Answer',
        'LONGER_ANSWER' => 'Longer Answer',
        'MULTIPLE_CHOICE' => 'Multiple Choice',
        'DATE' => 'Date',
        'WEBSITE_ADDRESS' => 'Website Address',
        'EVERYTHING' => 'Everything',
        'JUST_THE_HOMEPAGE' => 'Just the main page',
        'JUST_THE_SIGN_UP_PAGE' => 'Just the sign-up page',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Your changes have been saved.',
        'NOT_ALLOWED' => 'Not Allowed',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Come join me on %s…',
        'THERE_HAS_BEEN_AN_ERROR' => 'There has been an error',
        'SEARCH_RESULTS' => 'Search Results',
        'SEND_TO' => 'Send To',
        'SUBJECT' => 'Subject',
        'SEND' => 'Send',
        'REPORT_AN_ISSUE' => 'Report an Issue',
        'TYPE_OF_ISSUE' => 'Type of Issue',
        'ADULT' => 'Adult',
        'ABUSIVE' => 'Abusive',
        'BUG' => 'Bug',
        'FRAUD' => 'Fraud',
        'SPAM' => 'Spam',
        'OTHER' => 'Other',
        'DESCRIBE_YOUR_ISSUE' => 'Describe Your Issue',
        'SEND_REPORT' => 'Send Report',
        'ADDED_BY_X_AT_X' => 'Added by <a %s>%s</a> at %s on %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Added by <a %s>%s</a> to %s at %s on %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Click to View',
        'COMMENT_FOR' => 'Comment for:',
        'COMMENT_ON' => 'Comment on:',
        'ACTION_BUTTON_FEATURE' => 'Feature',
        'FEATURE_THIS_ON_YOUR' => 'Feature this on the main page',
        'ACTION_BUTTON_REMOVE' => 'Remove',
        'REMOVE' => 'Remove',
        'REMOVE_THIS_FROM_YOUR' => 'Remove this from the main page',
        'FEATURE_ON_HOME' => 'Feature',
        'REMOVE_FROM_HOME' => 'Stop Featuring',
        'ITEM_WILL_APPEAR' => 'This item will now appear on selected modules on the main page',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'This item will no longer appear on selected modules on the main page',
        'ADD_CONTENT' => 'Add Content',
        'BROUGHT_TO_YOU_BY' => '%s brought to you by %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Give Us Your Feedback',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'For additional questions or to contact Ning, please click here:',
        'SEND_FEEDBACK' => 'Send Feedback',
        'SIGN_OUT' => 'sign out',
        'SIGN_OUT_TITLE' => 'Sign Out',
        'INVITE_MORE' => 'Invite More',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Use this form to send feedback to <a %s>%s</a>, the creator of <a %s>%s</a>.',
        'NETWORK_INFORMATION' => 'Network Information',
        'ABOUT_YOUR_SITE' => 'About Your Network',
        'WELCOME_TO_YOUR_SITE' => 'Welcome to Your Social Network!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Edit your network\'s name, description and other information.',
        'TAGLINE' => 'Tagline',
        'APPEARS_IN_HEADER' => 'Appears in the header of your network',
        'APPEARS_IN_EMAILS' => 'Appears in emails and elsewhere',
        'NETWORK_NAME' => 'Network Name',
        'DESCRIPTION' => 'Description',
        'KEYWORDS' => 'Keywords',
        'LANGUAGE' => 'Language',
        'SEPARATE_EACH_KEYWORD' => 'Separate each keyword with a comma',
        'SET_NETWORK_ICON' => 'Set Network Icon',
        'SET_DEFAULT_AVATAR' => 'Set Default Profile Photo',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Upload a photo (GIF, JPG or PNG), which will be resized to a square. It may take a few minutes for this photo to appear.',
        'SAVE_SETTINGS' => 'Save Settings',
        'SUCCESS_EXCLAMATION' => 'Success!',
        'FEATURES' => 'Features',
        'ADD_FEATURES' => 'Add Features to Your Network',
        'ORGANIZE_FEATURES' => 'Organize your main page by dragging in features from the list below, then arranging them any way you\'d like.',
        'SKIP_FEATURES' => 'Click <a href="%s">Skip This Step</a> to continue with the default layout and features.',
        'FEATURES_FOR_ALL_PAGES' => 'Features added to this box will appear on all pages of your network.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Customize your social network by adding new features or removing existing ones.',
        'ADJUST_YOUR_SITES_COLORS' => 'Adjust your network\'s colors, images and overall style.',
        'APPEARANCE' => 'Appearance',
        'PROFILE_QUESTIONS' => 'Profile Questions',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Edit the questions that members answer about themselves.',
        'CLICK_EDIT_TO_COMPLETE_PROFILE' => 'Click \'Edit\' to complete your profile questions. This box won\'t show up for other people until you update its content.',
        'MESSAGE_SENT' => 'Message Sent!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Your message has been sent to all the members of your network.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Your message has been sent to all the members of your group.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Your message is being sent. Please wait, as it may take a few minutes.',
        'BROADCAST_MESSAGE' => 'Broadcast Message',
        'TRACK_VISITORS_AND_TRENDS' => 'Track visitors and trends on your social network.',
        'EDIT_SOURCE_CODE' => 'Edit Source Code',
        'TAKE_FULL_CONTROL' => 'Take full control of your network\'s functionality by editing the source code.',
        'DELETE_THIS_SITE' => 'Delete Your Social Network',
        'MAIN_PAGE' => 'Main Page',
        'MAIN' => 'Main',
        'MAIN_TAB_TEXT' => 'Main',
        'MANAGE' => 'Manage',
        'MANAGE_TAB_TEXT' => 'Manage',
        'PAGE_TITLE' => 'Page Title',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Edit the Appearance of Your Page',
        'CHOOSE_A_THEME' => 'Choose a Theme for Your Social Network',
        'NOW_CUSTOMIZE_SITE' => 'Now Customize Your Social Network…',
        'THEME_SETTINGS' => 'Theme Settings',
        'ADVANCED' => 'Advanced',
        'TO_FILL_THE_HEADER_USE_AN_IMAGE_955_PIXELS_WIDE' => 'To fill the header use an image 955 pixels wide',
        'TOP_BAR_AND_FOOTER' => 'Top Bar & Footer',
        'BODY_AND_CONTENT_AREA' => 'Body & Content Area',
        'HEADER_FOOTER_AND_SIDES' => 'Header, Footer & Sides',
        'ADD_A_LOGO' => 'Add a Logo',
        'THIS_IMAGE_WILL_REPLACE' => 'This image replaces the network name',
        'TABS' => 'Tabs',
        'TAB' => 'Tab',
        'SIDES' => 'Sides',
        'SHOW_NING_LOGO' => 'Show Ning Logo?',
        'LAUNCH' => 'LAUNCH!',
        'PASSWORD' => 'Password',
        'RETYPE_PASSWORD' => 'Retype Password',
        'TYPE_CODE_ON_RIGHT' => 'Type the Code<br />on the Right',
        'SIGN_UP_FOR_X' => 'Sign Up for %s',
        'HAS_INVITED_YOU_TO_X' => 'has invited you to join %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Awaiting Approval',
        'JOIN_X_NOW' => 'Join %s Now!',
        'HIDE_THIS_MESSAGE' => 'Hide this message',
        'PAGE_NOT_FOUND' => 'Page Not Found',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Our apologies – this page was not found',
        'FOLLOW_THESE_LINKS_TO' => 'Follow these links to a few things we know are available:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Alternatively, you can search this social network:',
        'IF_YOU_GET_THIS_MESSAGE' => 'If you get this message again, <a %s>please let us know.</a>',
        'GROUP_MEMBERS' => 'Group Members',
        'VIDEOS' => 'Videos',
        'BLOG' => 'Blog',
        'ACCOUNT' => 'Account',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'We\'re sorry, we are having an issue with this page.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Follow <a %s>this link</a> to the main page.',
        'APPEARS_FOR_MEMBERS_PROFILE_PHOTO' => 'Appears for members of your network who do not have a profile photo. This GIF, JPG or PNG image will be resized to a 175x175-pixel square.',
        // Messages below are used in Groups as well [Jon Aquino 2007-04-26]
        'NAME' => 'Name',
        'EMAIL_ADDRESS' => 'Email Address',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Sorry!</strong>  However, it\'s easy to start your own social network.',
        'GET_YOUR_OWN_BAZEL' => 'Create Your Own Social Network!',
        'SITE_IS_NOT_READY' => 'This social network\'s not ready yet!',
        'BAZEL_IS_BEING_SET_UP' => 'This social network is still being set up!',
        'SIGN_IN' => 'Sign In',
        'FORGOT_YOUR_PASSWORD' => 'Forgot your password?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Forgot Your Password?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Enter your email address and click \'Reset Password\'. You will get an email with a link to reset your password.',
        'RESET_PASSWORD' => 'Reset Password',
        'SIGN_UP' => 'Sign Up',
        'CONFIRM_PASSWORD' => 'Confirm Password',
        'YOUR_PHOTO' => 'Your Photo',
        'SUMMARY' => 'Summary',
        'YOUR_SITE_IS_READY' => 'Your social network is ready to launch!  Default settings will be used for any steps that you skipped. Go back to make changes, or click \'Launch!\' to launch your network.',
        'COMPLETE' => 'complete',
        'INCOMPLETE' => 'incomplete',
		'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Public</strong> – Anybody can see or join it',
        'PRIVATE_ONLY_INVITED' => '<strong>Private</strong> – Only invited people can join and see it',
        'INVITATIONS' => 'Invitations',
        'MEMBERS_CAN_INVITE' => 'Members can invite other people to join.', // Used in Groups as well [Jon Aquino 2007-04-25]
        'QUESTION_TITLE' => 'Question Title',
        'ANSWER_TYPE' => 'Answer Type',
        'REQUIRED' => 'Required',
        'PRIVATE' => 'Private',
        'CHOICES' => 'Choices',
        'SEPARATE_EACH_CHOICE' => 'Separate each choice with a comma',
        'CAN_PICK_MORE' => 'Can pick more than one',
        'ADD_ANOTHER_QUESTION' => 'Add Another Question',
        'WHAT_INFORMATION' => 'What questions would you like your members to answer when they join your network? You can re-order the questions below. Simply click on the question and drag it to where you want it to appear.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'If you select "Required," members will have to answer the question to join. If you select "Private," the answer will only be visible to you and other administrators.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'We couldn\'t find anything that matches "%s". Why not search for something else?',
        'GET_CUSTOM_URL' => 'Get your own custom URL, add storage and bandwidth, or run your own ads.',
        'TRACK_STATISTICS' => 'Track Statistics',
        'TRACKING_CODE' => 'Tracking Code',
        'ANY_JAVASCRIPT_CODE' => 'Any JavaScript code you paste here is inserted at the bottom of every page of your network. You can use this for external site-tracking systems, such as Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'To learn more about Google Analytics and set up your own account, <a %s>click here</a>.',
        'RESOURCES' => 'Resources',
        'LINK_COLOR' => 'Link Color',
        'PAGE' => 'Page',
        'BODY_BACKGROUND' => 'Body Background',
        'HEADER_BACKGROUND' => 'Header Background',
        'HEADING_FONT' => 'Heading Font',
        'FONT_SIZE' => 'Font Size',
        'FONT_SIZE_SMALL' => 'Small',
        'FONT_SIZE_DEFAULT' => 'Default',
        'FONT_SIZE_LARGE' => 'Large',
        'AABBCC' => 'AaBbCc',
        'BODY_FONT' => 'Body Text',
        'TEXT_COLOR' => 'Text Color',
        'SUBHEADER_COLOR' => 'Subheader Color',
        'SUBHEADER_BACKGROUND' => 'Subheader Background',
        'UPLOADING_CONTENT' => 'Uploading Content…',
        'WHEN_UPLOADING_IS_COMPLETE' => 'When uploading is complete, you can check out the network.',
        'FLICKR_IMPORT_SETUP' => 'Flickr Import Setup',
        'FLICKR_API_KEY' => 'Your Key',
        'FLICKR_SECRET' => 'Your Secret',
        'FLICKR_KEY_ERROR' => 'There was a problem with the Flickr key or secret that you entered.  Can you check them and try entering them again?',
        'FLICKR_INTRO' => 'Want to let your members import their photos from Flickr? You\'ve come to the right place. If you already have a Flickr API Key and Secret, you can <a %s>skip ahead</a>. Not sure what that means? Just follow the steps below and you\'ll be up and running in just a few minutes.',
        'FLICKR_GET_ACCOUNT' => 'If you don\'t already have a Flickr account, get one <a %s>here</a>.',
        'FLICKR_STEP1_TITLE' => 'Step 1: Get a Flickr API Key',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Apply for your API Key screen on Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'API Key screen on Flickr',
        'FLICKR_STEP1_INTRO' => 'Log in to Flickr and <a %s>apply for a new API key</a> (opens in a new window).',
        'FLICKR_STEP1_A' => 'Fill in <strong>Your Name</strong> and <strong>Email Address</strong>.',
        'FLICKR_STEP1_B' => 'Under <strong>This key is for&hellip;</strong> choose the <em>non-commercial use</em> option.',
        'FLICKR_STEP1_C' => 'Describe your social network in the <strong>Describe the application are you planning to build</strong> box.',
        'FLICKR_STEP1_D' => 'Check both acceptance boxes.',
        'FLICKR_STEP1_APPLY' => 'When you are done click the <strong>Apply</strong> button.',
        'FLICKR_STEP1_E' => 'You will land on a screen displaying your new API key. Click the <strong>Click here</strong> link to configure user authentication for this key.',
        'FLICKR_STEP2_TITLE' => 'Step 2: Setup Your Key',
        'FLICKR_STEP2_SETUP_SCREEN' => 'API Key Authentication Setup screen on Flickr',
        'FLICKR_STEP2_F' => 'Paste the following web address into the <strong>Callback URL</strong> field:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'When you are done click the <strong>Save Changes</strong> button.',
        'FLICKR_STEP3_TITLE' => 'Step 3: Enter Your Information',
        'FLICKR_STEP3_KEYS_SCREEN' => 'API Key information screen on Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Congratulations! You\'re now set up on Flickr.',
        'FLICKR_STEP3_COMPLETE' => 'To complete setup on %s, simply copy and paste your key and secret into the following fields:',
        'COMPLETE_SETUP' => 'Complete Setup',
        'SETUP_YOUR_SITE_TO' => 'Set up your social network to import photos from Flickr.',
        'FLICKR_IMPORTING' => 'Flickr Importing',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'You need to set up your social network to let people import their photos from Flickr. It only takes a few minutes so why not <a %s>set it up now?</a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Please don\'t show me this again.',
        'YOUVE_SIGNED_OUT_OF_X' => 'You\'ve successfully signed out of %s. Please come back and join us again soon!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'created this social network on <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Create your own social network!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Drag Here to Remove Feature',
        'LAYOUT' => 'Layout',
        'ADS' => 'Ads',
        'MEMBERS' => 'Members',
        'FEATURED_MEMBERS' => 'Featured Members',
        'HELLO_USERNAME' => 'Hello, Username',
        'CREATED_BY' => 'Created By',
        'SAVE_FEATURES' => 'Save Features',
        'FORUM' => 'Forum',
        'DISCUSSION_FORUM' => 'Discussion Forum',
        'CATEGORIES' => 'Categories',
        'FORUM_CATEGORIES' => 'Forum Categories',
        'A_THREADED_DISCUSSION_FORUM' =>'A threaded discussion forum',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Allow members to create their own interest groups within your network',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Feature posts from your blog or other members\' blogs',
        'BLOGS' => 'Blogs',
        'TEXT_BOX' => 'Text Box',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Put any text, widget or HTML on the main page',
        'A_LIST_OF_MEMBERS' => 'A list of your social network\'s members',
        'ALLOW_USERS_PHOTOS' => 'Allow people to upload and share photos',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Add feeds from across the web',
        'INFORMATION_ABOUT_THE_USER' => 'Information about the person currently signed in',
        'ALLOW_USERS_VIDEOS' => 'Allow people to add and share videos',
        'SHOW_NETWORK_DESCRIPTION' => 'Show your network description',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Promote your network across the web with custom badges and widgets',
        'MONETIZE_WITH_ADS' => 'Monetize your network with advertising',
        'ALLOW_PEOPLE_ORGANIZE_RSVP_EVENTS' => 'Allow people to organize and RSVP to events',
        'ALLOW_ADMINS_CREATE_EDIT_FEATURE_NOTES' => 'Allow admins to create, edit and feature notes',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Let your members know who created this network',
        'FOLLOW_LATEST_ACTIVITY' => 'Follow the latest member activity on your network',
        'FAQ_FOR_NETWORK_CREATORS' => 'FAQ for Network Creators',
        'ANSWERS_TO_FAQS' => 'Answers to frequently asked questions about customizing your Social Network.',
        'MEET_OTHER_LIKEMINDED' => 'Meet other like-minded network creators, share ideas and get support from the Ning team.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Customize the appearance of your social network by adding your own Cascading Style Sheets (CSS) in the field on the left. (<a href="%s">What is CSS?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Customize the appearance of your page by adding your own Cascading Style Sheets (CSS) in the field on the left. (<a href="%s">What is CSS?</a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS on your Social Network',
        'CSS_ON_YOUR_PAGE' => 'CSS on your page',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Adding your own CSS gives you full control over the fonts, color, spacing, and general style of your network.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Adding your own CSS to your page gives you full control over the fonts, color, spacing, and general style of your page.',
        'CSS_STYLES_WILL_OVERRIDE' => 'The CSS styles you add here will override any existing CSS styles you may have chosen earlier.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Need help figuring out the name of a specific CSS class on your network? We recommend the "Inspect" feature of the free <a href="%s">Firebug</a> extension (for the Firefox browser).',
        'WANT_TO_LEARN_MORE' => 'Want to learn more? Check out our <a href="%s">Advanced Customization</a> section.',
        'APPLY_XS_THEME' => 'Apply %s\'s theme',
        'INVITED' => 'Invited',
        'REQUESTED_INVITE' => 'Requested Invite',
        'BAN_FROM_NETWORK' => 'Ban from Network',
        'REMOVE_BAN' => 'Remove Ban',
        'CANCEL_INVITATION' => 'Cancel Invitation',
        'IGNORE' => 'Ignore',
        'PROMOTE_TO_ADMINISTRATOR' => 'Promote to Administrator',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Demote from Administrator',
        'STATUS' => 'Status',
        'DATE_JOINED' => 'Date Joined',
        'DATE_INVITED' => 'Date Invited',
        'DATE_REQUESTED' => 'Date Requested',
        'DATE_APPLIED' => 'Date Applied',
        'NETWORK_CREATOR' => 'Network Creator',
        'NETWORK_ADMINISTRATOR' => 'Administrator',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Administrators have a similar level of control to the Network Creator.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Export All Member Data (.CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Your Member Data has been exported.  Click <a %s>this link</a> in order to save it to your desktop.',
        'CLICK_GO_TO_START_EXPORT' => 'Click Go to start the export.  If you have a lot of members, the process might take a few minutes.',
        'MEMBER' => 'Member',
        'INVITED_BY_X' => 'Invited by %s',
        'DONE' => 'Done',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'You have been banned from %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Message to the Administrator',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Sorry, %s, you can not access %s as you have been banned. If you think you\'ve been banned in error, you can contact the administrator.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Sorry, %s, you can not access %s as you have been banned.',
        'PENDING' => 'Pending',
        'ACCEPT' => 'Accept',
        'PENDING_APPROVAL' => 'Pending Approval',
        'ACCEPT_MEMBERSHIP' => 'Accept Membership',
        'DECLINE_MEMBERSHIP' => 'Decline Membership',
        'NO_PAGE_YET' => 'No Page Yet',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Your membership to %s is pending approval from the administrators.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Membership Pending Approval',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Your Profile is Pending Approval',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Your profile details must be approved by the Administrator before you can become a member of %s. You will receive an email once your profile is approved.',
        'CONTINUE_ARROW' => 'Continue →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Back to Pending Members',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s is awaiting approval to become a member of %s.',
        'VIEW_PAGE' => 'View Page',
        'MESSAGE' => 'Message',
        'SEND_MESSAGE' => 'Send Message',
        'MANAGE_FORUM_CATEGORIES' => 'Manage forum categories',
        'START_DISCUSSIONS' => 'Start discussions',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Welcome to your new social network',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Now all you need to do is <a %s>invite your friends</a>!',
        'CONTRIBUTE' => 'Contribute.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Customize.</strong> Adjust <a %1$s>network appearance</a> and design <a %2$s>badges and widgets</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Control.</strong>  The <a %s>manage</a> page is home to a host of configuration options.',
        'CREATE_GROUPS' => 'Create groups',
        'INVITE_MORE_PEOPLE' => 'Invite More People',
        'VIEW_THREAD' => 'View Thread',
        'COMMENT_THREAD' => 'Comment Thread',
        'COMMENT_BACK' => 'Comment Back',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Hello, you need to enable JavaScript to use this network.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Please check your browser settings or contact your system administrator.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Manage members, Administrators, invited people and banned people.',
        'MANAGE_MEMBERS' => 'Manage Members',
        'NETWORK_SETTINGS' => 'Network Settings',
        'PROMOTE_YOUR_NETWORK' => 'Promote Your Network',
        'NING_RESOURCES' => 'Ning Resources',
        'ADD_PREMIUM_SERVICES' => 'Add Premium Services',
        'REQUEST_SOURCE_CODE' => 'Request Source Code Access',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Developers: request access to the source code running your network.',
        'JOIN_NETWORK_CREATORS' => 'Join Network Creators',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Send a message to all the members of this network.',
        'CREATE_ANOTHER_NETWORK' => 'Create Another Network',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Have another great idea for a Social Network?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Allow Facebook users to put your network\'s widgets on their profile pages.',
        'BADGES_AND_WIDGETS' => 'Badges & Widgets',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Customize the look of your network\'s widgets and badges.',
        'GET_BADGES' => 'Get Badges',
        'CUSTOM_TEXT' => 'Custom Text',
        'IM_A_MEMBER_OF' => 'I\'m a member of:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Don\'t Display Any Branding',
        'WATERMARK_OR_LOGO_IMAGE' => 'Watermark or Logo Image:',
        'NETWORK_BRANDING_BADGES' => 'Network Branding: Badges',
        'NETWORK_BRANDING_WIDGETS' => 'Network Branding: Widgets',
        'LOGO_IMAGE' => 'Logo Image',
        'SMALL_NETWORK_BADGE' => 'Small Network Badge',
        'LARGE_NETWORK_BADGE' => 'Large Network Badge',
        'REFRESH' => 'Refresh',
        'HTML_EMBED_CODE' => 'HTML Embed Code:',
        'CUSTOMIZE' => 'Customize',
        'SHARE_TITLE' => 'Share \'%s\'',
        'SHARE_TYPE' => 'Share %s',
        'YOUR_MESSAGE_SENT' => 'Your message has been sent successfully.',
        'YOUR_MESSAGES_SENT' => 'Your messages have been sent successfully.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'You can share this %s in two ways&#8230;',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Check out "%1$s" on %2$s…',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Check out this %1$s on %2$s…',
        'PHOTO_ALBUM' => 'photo album',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Customize your badges and widgets with your own color and image choices. Your changes may take up to 4 hours to be reflected on other websites.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Background Image & Color',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Use this form to report an issue to <a %s>%s</a>, the creator of <a %s>%s</a>.',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Sorry, no members matching "%s" were found.',

        // Profile widget
        'NO_LONGER_FOLLOWING_BLOG_POST' => 'You are no longer following this blog post.',
        'NOBODY_HAS_WRITTEN_POSTS' => 'Nobody has written any blog posts yet.',
        'YOU_HAVE_NOT_WRITTEN_POSTS' => 'You haven\'t written any blog posts yet.',
        'USER_HAS_NOT_WRITTEN_POSTS' => '%s hasn\'t written any blog posts yet.',
        'USER_HAS_NOT_WRITTEN_POSTS_TAGGED_X' => '%s hasn\'t written any blog posts tagged \'%s\'.',
        'YOU_HAVE_NOT_WRITTEN_POSTS_TAGGED_X' => 'You haven\'t written any blog posts tagged \'%s\'.',
        'NO_POSTS_FEATURED' => 'No blog posts have been featured yet. ',
        'PREVIOUS_POST' => 'Previous Post',
        'NEXT_POST' => 'Next Post',
        'ALL_BLOG_POSTS' => 'All Blog Posts',
        'FRIENDS' => 'Friends',
        'MOST_POPULAR_BLOG_POSTS' => 'Most Popular Blog Posts',
        'MOST_POPULAR_FEATURED_BLOG_POSTS' => 'Most Popular Featured Blog Posts',
        'TAG_COUNT' => '<a %1$s>%2$s</a> (%3$s)',
        'BLOG_TOPICS_BY_TAGS' => 'Blog Topics by Tags',
        'ARROW_PREVIOUS' => '< Previous',
        'NEXT_ARROW' => 'Next >',
        'VIEW_BLOG_POSTS' => 'View Blog Posts',
        'WHO_CAN_COMMENT_ON_POST' => 'Who can comment on this post?',
        'SEND_MESSAGE_TO_FRIENDS' => 'Send Message to Friends',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'There aren\'t any blog posts tagged "%1$s". Check out <a %2$s>discussions tagged "%1$s"</a>, <a %4$s>photos tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>. Or add and tag your own blog posts!',
        'ALL_BLOG_POSTS_TAGGED_X_M_Y_ARCHIVE' => 'All Blog Posts Tagged <em>\'%s\'</em> – %s %s Archive',
        'USERS_BLOG_POSTS_TAGGED_X_M_Y_ARCHIVE' => '%s\'s Blog Posts Tagged <em>\'%s\'</em> – %s %s Archive',
        'MY_BLOG_POSTS_TAGGED_X_M_Y_ARCHIVE' => 'My Blog Posts Tagged <em>\'%s\'</em> – %s %s Archive',
        'ALL_BLOG_POSTS_TAGGED_X' => 'All Blog Posts Tagged <em>\'%s\'</em>',
        'USERS_BLOG_POSTS_TAGGED_X' => '%s\'s Blog Posts Tagged <em>\'%s\'</em>',
        'MY_BLOG_POSTS_TAGGED_X' => 'My Blog Posts Tagged <em>\'%s\'</em>',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Sorry, Network Creators cannot change their email addresses through networks they don\'t own.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Sorry, Network Creators cannot change their passwords through networks they don\'t own.',
        'GO' => 'Go',
        'LARGE_THUMBNAILS' => 'Large Thumbnails',
        'SMALL_THUMBNAILS' => 'Small Thumbnails',
        'RECENTLY_JOINED' => 'Newest',
        'MOST_POPULAR_MEMBERS' => 'Most Popular',
        'NO_MEMBERS_TO_DISPLAY' => 'You are currently displaying no members',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'This box won\'t show up for other people unless you select at least one row.',
        'DETAIL_VIEW' => 'Detail View',
        'TITLES_ONLY' => 'Titles Only',
        'RECENTLY_ADDED_POSTS' => 'Recently Added',
        'POPULAR_POSTS' => 'Most Comments',
        'PROMOTED_POSTS' => 'Featured ',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'This box won\'t show up for other people unless you select at least one post.',
        'YOU_DO_NOT_HAVE_POSTS' => 'You haven\'t written any posts yet.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'You don\'t have any comments to approve.',
        'REQUIRED_FIELD' => '(Required field)',
        'BLOG_POST_BY_X' => 'Blog Post by %s',
        'HELLO' => 'Hello,',
        'ADDED_BY_X' => 'Added by %s',
        'CLICK_TO_ADD_A_TITLE' => 'click to add a title',
        'DELETE_BLOG_POST' =>'Delete Post',
        'DELETE_THIS_BLOG_POST_Q' => 'Delete This Blog Post?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' =>  'Are you sure you want to delete this blog post? This process may take a few minutes.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Please enter something for: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Please select an option for: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Please provide a valid date for: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Please provide a date for: %s',
        'XS_BLOG_M_Y_ARCHIVE' => '%s\'s Blog – %s %s Archive',
        'MY_BLOG_M_Y_ARCHIVE' => 'My Blog – %s %s Archive',
        'FEATURED_BLOG_POSTS_M_Y_ARCHIVE' => 'Featured Blog Posts – %s %s Archive',
        'FEATURED_BLOG_POSTS' => 'Featured Blog Posts',
        'EVERYONES_POSTS' => 'Everyone\'s Blog Posts',
        'BLOG_POSTS_ACROSS_APPNAME' => 'Blog Posts Across %s',
        'M_Y_ARCHIVE' => '%s %s Archive',
        'PUBLISHED_N_OF_N' => 'Published %d of %d',
        'UPLOAD_DID_NOT_WORK' => 'Sorry, that upload didn\'t work',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M. j, Y',
        'XS_POSTS' => '%s\'s Posts',
        'USERNAMES_COMMENTS' => '%s\'s Comments',
        'ADD_COMMENT' => 'Add Comment',
        'XS_PAGE' => '%s\'s Page',
        'XS_BLOG' => '%s\'s Blog',
        'XS_FRIENDS' => '%s\'s Friends',
        'XS_FRIENDS_N' => '%1$s\'s Friends (%2$s)',
        'DRAFT_BRACKETS' => '[ Draft ]',
        'FEATURED' => 'Featured',
        'MY_POSTS' => 'My Posts',
        'MY_POSTS_ONLY' => 'My Posts Only',
        'OWNER_POSTS_ONLY' => 'Creator Posts Only',
        'JANUARY' => 'January',
        'FEBRUARY' => 'February',
        'MARCH' => 'March',
        'APRIL' => 'April',
        'MAY' => 'May',
        'JUNE' => 'June',
        'JULY' => 'July',
        'AUGUST' => 'August',
        'SEPTEMBER' => 'September',
        'OCTOBER' => 'October',
        'NOVEMBER' => 'November',
        'DECEMBER' => 'December',
        'MY_COMMENTS' => 'My Comments',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => 'My Page',
        'MY_PAGE_TAB_TEXT' => 'My Page',
        'BLOG_POSTS' => 'Blog Posts',
        'MY_BLOG' => 'My Blog',
        'MONTH' => 'Month',
        'DAY' => 'Day',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Please pick a valid choice for default visibility',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Please pick a valid choice for who can comment',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Please pick a valid choice for blog comment moderation',
        'PICK_VALID_COMMENTWALL_COMMENT_MODERATION' => 'Please pick a valid choice for comment wall moderation',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Please pick a valid choice for activity notification',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Please pick a valid choice for moderation notification',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Please pick a valid choice for approval notification',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Please pick a valid choice for invitee joining notification',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Please pick a valid choice for never receiving notifications',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Please pick a valid choice for notifications of messages sent to all friends',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Please pick a valid choice for friend request notifications',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Please pick a valid choice for new message notifications',
        'PICK_VALID_ADMIN_MESSAGES_NOTIFICATION' => 'Please pick a valid choice for feedback and reported problem notifications',
        'MANAGE_BLOG' => 'Manage Blog',
        'COMMENTS_POSTED_ON_BLOG' => 'Comments posted on my blog',
        'COMMENT' => 'Comment',
        'COMMENTER' => 'Commenter',
        'POST' => 'POST',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Post has been deleted',
        'COMMENTS_ARE_CLOSED' => 'Comments are closed for this blog post',
        'NO_COMMENTS' => 'No Comments',
        'FLAG' => 'Flag',
        'POST_TITLE' => 'Post Title',
        'DRAFT_PARENTHESES' => '(Draft)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Scheduled to publish on: %s',
        'EDIT_2' => 'edit',
        'N_NEW' => '%s New',
        'NO_POSTS' => 'No Posts',
        'ADD_NEW_BLOG_POST' => 'Add a New Blog Post',
        'ADD_NEW_POST' => 'Add New Blog Post',
        'HAPPY' => 'Happy',
        'SAD' => 'Sad',
        'COOL' => 'Cool',
        'EVIL' => 'Evil',
        'MAD' => 'Mad',
        'ENVIOUS' => 'Envious',
        'ENTRY' => 'Entry',
        'WHAT_DATE_FOR_YOUR_POST' => 'What date would you like for your post?',
        'NOW' => 'Now',
        'CHOOSE_DATE_AND_TIME' => 'Choose a date and time (if you choose a future date, your post will publish at that time)',
        'PRIVACY_AND_COMMENTS' => 'Privacy & Comments',
        'WHO_CAN_VIEW_POST' => 'Who can view this post?',
        'EVERYONE' => 'Everyone',
        'COMMENT_MODERATION' => 'Comment Moderation',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'You are currently moderating blog comments.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'You are not currently moderating blog comments.',
        'SAVE_AS_DRAFT' => 'Save as Draft',
        'PREVIEW' => 'Preview',
        'PUBLISH_POST' => 'Publish Post',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'This is a preview of what your blog post will look like when you publish it. Click Back to edit the post, or Publish if it\'s ready!',
        'BACK' => 'Back',
        'PUBLISH' => 'Publish!',
        'BLOG_POST' => 'Blog Post',
        'PROFILE' => 'Profile',
        'ADDED_BY' => 'Added by:',
        'LATEST_BLOG_POSTS' => 'Latest Blog Posts',
        'LATEST_FEATURED_BLOG_POSTS' => 'Latest Featured Blog Posts',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Your comment has been added but needs to be approved before everyone can see it.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'At %s on %s, %s said…',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s doesn\'t have any friends on this social network yet.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'You don\'t have any friends on this social network yet.',
        'ADD_BLOG_POST' => 'Add Blog Post',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Please keep this browser window open while all of %s\'s content is deleted. This process may take a few minutes.',
        'BAN_MEMBER_FROM_NETWORK' => 'Ban Member from Network',
        'BAN_USERNAME' => 'Ban %s?',
        'EDIT_POST' => 'Edit Post',
        'EDIT_POST_COLON' => 'Edit Post: ',
        'CONTINUE' => 'Continue',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Posted by <a %s>me</a> on %s at %s —',
        'POSTED_BY_X_ON_X_AT_X' => 'Posted by %s on %s at %s —',
        'POSTED_ON_X_AT_X' => 'Posted on %s at %s —',
        'ADD' => 'Add',
        'VIEW_ARCHIVES' => 'View Archives',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Your settings have been saved.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Please correct the following:',
        'PRIVACY' => 'Privacy',
        'PRIVACY_CONTENT_CONTROL' => 'Privacy & Content Control',
        'NETWORK_PRIVACY' => 'Network Privacy',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'This network is <strong>visible to everyone</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Anyone can sign up to become a member. Visitors can…',
        'SEE_EVERYTHING' => 'See everything',
        'SEE_JUST_THE_MAIN_PAGE' => 'See just the main page',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'See just the sign up page',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'This network is <strong>visible to members only</strong>.',
        'WHO_CAN_SIGN_UP' => 'Who can sign up to become a member?',
        'MODERATION' => 'Feature Controls',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Approve new members before they can join',
        'ALLOW_MEMBERS_CREATE_GROUPS' => 'Allow members to create groups',
        'ALLOW_MEMBERS_CREATE_EVENTS' => 'Allow members to create events',
        'APPROVE_PHOTOS_VIDEOS' => 'Approve photos and videos before they appear',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Enable Music Player download links',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Show Latest Activity on Your Network!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Put a constantly updated stream of recent activity on your network\'s main page.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Click here to add Latest Activity to your network.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'These options are disabled since you don\'t have Latest Activity on your network.',
        'ACTIVITY' => 'Activity',
        'DISPLAY_PREFERENCES' => 'Display Preferences',
        'NEW_CONTENT' => 'New content',
        'NEW_COMMENTS' => 'New comments',
        'NEW_MEMBERS' => 'New members',
        'MEMBER_UPDATES' => 'Member updates',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'What displays in your network\'s<br />Latest Activity?',
        'LATEST_ACTIVITY' => 'Latest Activity',
        'LATEST_ACTIVITY_COLON_TIME' => 'Latest Activity: %s',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s replied to the discussion %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>replied</a> to the discussion <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'You <a %1$s>replied</a> to the discussion <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s commented on the blog post %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>commented</a> on the blog post <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'You <a %1$s>commented</a> on the blog post <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s started a discussion called %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'You started a discussion called %s',
        'X_STARTED_A_DISCUSSION_Y_IN_GROUP' => '%s started a discussion called %s in %s',
        'YOU_STARTED_A_DISCUSSION_Y_IN_GROUP' => 'You started a discussion called %s in %s',
        'X_STARTED_Y_FORUM_POSTS_IN_GROUP' => '%s started %s discussions in %s',
        'YOU_STARTED_Y_FORUM_POSTS_IN_GROUP' => 'You started %s discussions in %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s added the blog post \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'You added the blog post \'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s joined the group %s',
        'YOU_JOINED_THE_GROUP_X' => 'You joined the group %s',
        'X_JOINED_Y_GROUPS' => '%s joined %s groups',
        'YOU_JOINED_X_GROUPS' => 'You joined %s groups',
        'X_JOINED_APPNAME' => '%s joined %s. <a %s>Leave a Comment</a> for %s.',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Welcome, %1$s! You are member #%2$s of %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Welcome, %1$s! You are member #%2$s of %3$s. <a %4$s>Invite friends now</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s is member #%2$s of %3$s.',
        'XS_PROFILE_CHANGED' => '%s\'s profile changed',
        'YOUR_PROFILE_CHANGED' => 'Your profile changed',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s left a comment for %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'You left a comment for %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s left a comment for you',
        'X_CREATED_A_GROUP_Y' => '%s created a group called %s',
        'YOU_CREATED_A_GROUP_Y' => 'You created a group called %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s created %s new groups',
        'X_STARTED_Y_FORUM_POSTS' => '%s started %s new forum discussions',
        'YOU_STARTED_Y_FORUM_POSTS' => 'You started %s new forum discussions',
        'X_ADDED_Y_BLOG_POSTS' => '%s added %s new blog posts',
        'YOU_ADDED_Y_BLOG_POSTS' => 'You added %s new blog posts',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'You commented on the photo <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s commented on the photo <a %s>%s</a>',
        'YOU_COMMENTED_ON_ALBUM_TITLE' => 'You commented on the album <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_ALBUM_TITLE' => '%s commented on the album <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'You commented on the video <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s commented on the video <a %s>%s</a>',
        'VIEW_XS_BLOG_POSTS' => 'View %s\'s blog posts',
        'VIEW_YOUR_BLOG_POSTS' => 'View your blog posts',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s has <a %s>new profile questions</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s now has a music player',
        'APPNAME_NOW_HAS_GROUPS' => '%s now has <a %s>groups</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s now has <a %s>videos</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s now has a <a %s>forum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s now has <a %s>photos</a>',
        'APPNAME_NOW_HAS_EVENTS' => '%s now has <a %s>events</a>',
        'APPNAME_NOW_HAS_NOTES' => '%s now has <a %s>notes</a>',
        'DID_YOU_KNOW' => 'Did you know',
        'ANNOUNCEMENT' => 'Announcement',
        'CONGRATULATIONS' => 'Congratulations',
        'YOU_CREATED_APPNAME' => 'You created the %s network.',
        'USER_CREATED_APPNAME' => '%s created the %s network.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Add messages and choose what\'s displayed in your network\'s activity feed.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Which of your actions should display<br />on Latest Activity?',
        'NEW_CONTENT_I_ADD' => 'New content I add',
        'NEW_COMMENTS_I_ADD' => 'New comments I add',
        'WHEN_I_UPDATE_MY_PROFILE' => 'When I update my profile',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Latest Activity will never display messages you send, pages or members you view, invitations you decline, people you de-friend or decline, or things you delete.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'You have no recent activity. Why not start something?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'You\'ve turned off the display of your activity. <a %s>Click here to turn it back on.</a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'The network creator has turned off the display of all activity.',
        'NO_ACTIVITY_TO_DISPLAY' => 'You are currently displaying no activity.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'This box won\'t show up for other people unless you select at least one activity item.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'There is no recent activity. Why not start something?',
        'DELETE_ACTIVITY_ITEM' => 'Remove Activity Message',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Remove this activity message?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'This will prevent anyone from seeing this activity message',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s has posted the most %2$sphotos%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s is the most popular photo to date',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s has posted the most %2$svideos%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s is the most popular video to date',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s has posted the most songs',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s is the most popular song to date',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s is the most popular forum post to date',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s is the most popular blog post to date',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s\'s Latest Activity on %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Latest Activity on  %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Add Message to Latest Activity',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Add facts about the network…',
        'ADD_MESSAGE' => 'Add Message',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '…or write your own message',
        'NETWORK' => 'Network',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Who can view your photos, videos,<br/> and blog posts by default?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(You can override this setting for a photo, video, or blog post when you add it.)',
        'MODERATE_COMMENTS_ON_BLOG' => 'Do you want to approve comments<br />before they appear on your blog?',
        'MODERATE_COMMENTS_ON_COMMENTWALL' => 'Do you want to approve comments before they appear on your comment wall?',
        'NOTIFY_BLOG_PING_SERVICES' => 'Do you want to notify 3rd-party blog tracking services when you add a new post?',
        'YES_NOTIFY_BLOG_SERVICES' => 'Yes – Notify <a %s>site update services</a> when I add a new blog post',
        'YES_LET_ME_APPROVE' => 'Yes – Let me approve comments first',
        'NO_PUBLISH_COMMENTS' => 'No – Publish comments immediately',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Who can comment on your photos,<br/> videos and blog?',
        'SAVE' => 'Save',
        'EMAIL' => 'Email',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Your privacy is important to us. If you have any questions on your email notifications, please send us a note via the <a href="http://help.ning.com/?page_id=27">Help Center</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Add photos and videos to %s by sending them to this email address:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Add photos and videos to %s from your phone by sending them to this email address:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Generate New Email Address',
        'SUPPORTS_TEXT_EMBEDDED' => 'Supports text, embedded videos, photos, and widgets',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'You need to be a member of %s to add comments!',
        'MONTHLY_ARCHIVES' => 'Monthly Archives',
        'FEATURED_MONTHLY_ARCHIVES' => 'Featured Monthly Archives',
        'NO_FRIENDS_ON_SITE' => 'No friends on this social network yet.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'No friends on this social network that match your search.',
        'MEMBERS_TAB_TEXT' => 'Members',
        'SITE_HAS_NO_MEMBERS' => 'This social network doesn\'t have any members yet!',
        'NO_COMMENTS_YET' => 'No comments yet!',
        'VIEW_ALL_COMMENTS' => 'View All Comments',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'You haven\'t added any blog posts yet!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'You can write about anything you want, talk about and embed your favorite videos, photos and music.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Write your first entry!',
        'THERE_ARE_NO_FEATURED_X' => 'There are no featured %s on your social network.',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'There are no Featured Members on your social network.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'There are no %s that match the settings you have selected.',
        'START_FEATURING_X_CLICK_Y' => 'Start featuring %s where you see the Feature option. To learn more about featuring, <a %s>click here</a>.',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Start featuring Members where you see the Feature option. To learn more about featuring, <a %s>click here</a>.',
        'REQUEST_SENT' => 'Request Sent!',
        'BANNED' => 'Banned',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Add Your First Blog Post',
        'MY_FIRST_BLOG_POST' => 'My first blog post!',
        'TELL_THE_PEOPLE_ON' => 'Tell the people on %s more about yourself. Questions marked with a <span %s>lock</span> are private and only visible to Administrators.',
        'NOW_CUSTOMIZE_PAGE' => 'Now Customize Your Page…',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'You are currently displaying no posts.',
        'DATE_COLON' => 'Date:',
        'TIME_COLON' => 'Time:',
        'CHANGE' => 'Change',
        'CANCEL' => 'Cancel',
        'UPLOADING' => 'Uploading…',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Popular Members',
        'INVITE_FRIENDS' => 'Invite Friends',
        'VIEW_ALL' => 'View All',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Are you sure you want to ban %1$s from your social network and delete all content %1$s has added? This process may take a few minutes.',
        'REMOVING_X' => 'Removing %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Are you sure you want to ban the selected member(s) from your social network and delete all content they have added? This process may take a few minutes.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Are you sure you want to ban the selected member(s) from your social network? This process may take a few minutes.',
        'BAN' => 'Ban',
        'REMOVING_MEMBERS' => 'Removing Members',
        'FEMALE' => 'Female',
        'MALE' => 'Male',
        'UNITED_STATES' => 'United States',
        'AND' => 'and',
        'GENDER_M' => 'Male',
        'GENDER_F' => 'Female',
        'XS_PAGE_ON_Y' => '%s\'s Page on %s',
        'SEARCH_MEMBERS' => 'Search Members',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'somebody commented on a blog post you\'ve added to %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'You have a new comment on your page on %s.',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Now that you\'ve joined, <strong><a %s>invite your friends</a></strong>!',
        'THIS_IS_YOUR_PAGE' => 'This is Your Page:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Start by <a %s>customizing its appearance</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Use it to <a %1$s>keep a blog</a>, and display <a %2$s>your profile answers</a>.',
        'START_CONTRIBUTING' => 'Start contributing:',
        'UPLOAD_VIDEOS' => 'Upload videos',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Contribute to discussions',
        'JOIN_GROUPS' => 'Join groups',
        'ADD_A_BLOG_POST' => 'Add a blog post',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Click here to view your friend requests.',
        'LEAVE_X' => 'Leave %s',
        'LEAVE_X_Q' => 'Leave %s?',
        'ARE_YOU_SURE_LEAVE_X' => 'Are you sure you want to leave %s and delete all your content? This process may take a few minutes.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592; Back to %s\'s Page',
        'BACK_TO_MY_PAGE' => '&#8592; Back to My Page',
        'COMMENT_WALL' => 'Comment Wall',
        'ONLINE' => 'Online',
        'MEMBER_IS_ONLINE' => 'Member is Online',
        'ONLINE_NOW' => 'Online Now',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Choose who can see, join and contribute to your network.',
        'EMAIL_NOTIFICATIONS' => 'Email Notifications',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'What network activity do you want to receive an email notification for?',
        'NETWORK_MESSAGES' => 'Network Messages',
        'MEMBER_ACTIVITY' => 'Member Activity',
        'FEEDBACK_AND_PROBLEM_REPORTS' => 'Feedback and problem reports',
        'FRIEND_REQUESTS' => 'Friend requests',
        'PEOPLE_IVE_INVITED_JOIN' => 'People that I\'ve invited to join this network',
        'MESSAGES_SENT_TO_ME' => 'Messages sent to me',
        'MESSAGES_SENT_TO_GROUPS' => 'Messages sent to groups I belong to',
        'MESSAGES_SENT_TO_EVENTS' => 'Messages sent to my events',
        'MESSAGES_SENT_TO_NETWORK' => 'Messages sent to the whole network',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Messages sent to all friends',
        'I_HAVE_NEW_COMMENTS' => 'I have new comments to approve',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'I have new network content to approve',
        'FOLLOWING_DISCUSSIONS_AND_BLOG_POSTS' => 'Following Discussions and Blog Posts',
        'FOLLOW_DISCUSSIONS_AND_BLOG_POSTS_I_ADD' => 'Follow discussions and blog posts I add',
        'FOLLOW_DISCUSSIONS_AND_BLOG_POSTS_I_REPLY_TO' => 'Follow discussions and blog posts I reply to',
        'CLEAR_MY_FOLLOW_LIST' => 'Clear My Follow List',
        'IF_YOU_CLICK_X_YOU_WILL_STOP_FOLLOWING' => 'If you click \'%s\', you will stop following all discussions and blog posts that you\'re currently following.',
        'ARE_YOU_SURE_STOP_RECEIVING_EMAILS_DISCUSSIONS_BLOG_POSTS' => 'Are you sure want to stop receiving emails about the discussions and blog posts you\'re following?',
        'YOUR_FOLLOW_LIST_HAS_BEEN_CLEARED' => 'Your follow list has been cleared.',
        'THINGS_IVE_ADDED_APPROVED' => 'Things I\'ve added have been approved',
        'NOTIFICATIONS' => 'Notifications',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Email me when people reply',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Don\'t email me when people reply',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'To stop following this %s, go to:',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'You are no longer following this %s.',
        'NOTIFY' => 'Notify',
        'STOP_NOTIFYING' => 'Stop Notifying',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Email me when there are new discussions ',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Don\'t email me when there are new discussions ',
        'SHOW_ALL' => 'Show All',
        'LATEST_MEMBERS' => 'Latest Members',
        'LATEST_FEATURED' => 'Latest Featured',
        'LATEST_MEMBERS_N' => 'Latest Members (%s)',
        'RANDOM_MEMBERS' => 'Random Members',
        'CHANGE_MY_PHOTO_OR_THEME' => 'Change <a %1$s>My Photo</a> or <a %2$s>Theme</a>',

        // Countries
        'COUNTRY_AF' => 'Afghanistan',
        'COUNTRY_AX' => 'Aland Islands',
        'COUNTRY_AL' => 'Albania',
        'COUNTRY_DZ' => 'Algeria',
        'COUNTRY_AS' => 'American Samoa',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antarctica',
        'COUNTRY_AG' => 'Antigua and Barbuda',
        'COUNTRY_AR' => 'Argentina',
        'COUNTRY_AM' => 'Armenia',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australia',
        'COUNTRY_AT' => 'Austria',
        'COUNTRY_AZ' => 'Azerbaijan',
        'COUNTRY_BS' => 'Bahamas',
        'COUNTRY_BH' => 'Bahrain',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Belarus',
        'COUNTRY_BE' => 'Belgium',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermuda',
        'COUNTRY_BT' => 'Bhutan',
        'COUNTRY_BO' => 'Bolivia',
        'COUNTRY_BA' => 'Bosnia and Herzegovina',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Bouvet Island',
        'COUNTRY_BR' => 'Brazil',
        'COUNTRY_IO' => 'British Indian Ocean Territory',
        'COUNTRY_BN' => 'Brunei Darussalam',
        'COUNTRY_BG' => 'Bulgaria',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Cambodia',
        'COUNTRY_CM' => 'Cameroon',
        'COUNTRY_CA' => 'Canada',
        'COUNTRY_CV' => 'Cape Verde',
        'COUNTRY_KY' => 'Cayman Islands',
        'COUNTRY_CF' => 'Central African Republic',
        'COUNTRY_TD' => 'Chad',
        'COUNTRY_CL' => 'Chile',
        'COUNTRY_CN' => 'China, mainland',
        'COUNTRY_CX' => 'Christmas Island',
        'COUNTRY_CC' => 'Cocos (Keeling) Islands',
        'COUNTRY_CO' => 'Colombia',
        'COUNTRY_KM' => 'Comoros',
        'COUNTRY_CG' => 'Congo, Republic of the',
        'COUNTRY_CD' => 'Congo, The Democratic Republic Of The',
        'COUNTRY_CK' => 'Cook Islands',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Cote d Ivoire',
        'COUNTRY_HR' => 'Croatia',
        'COUNTRY_CU' => 'Cuba',
        'COUNTRY_CY' => 'Cyprus',
        'COUNTRY_CZ' => 'Czech Republic',
        'COUNTRY_DK' => 'Denmark',
        'COUNTRY_DJ' => 'Djibouti',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'Dominican Republic',
        'COUNTRY_EC' => 'Ecuador',
        'COUNTRY_EG' => 'Egypt',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_GQ' => 'Equatorial Guinea',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_EE' => 'Estonia',
        'COUNTRY_ET' => 'Ethiopia',
        'COUNTRY_EU' => 'European Union',
        'COUNTRY_FK' => 'Falkland Islands',
        'COUNTRY_FO' => 'Faroe Islands',
        'COUNTRY_FJ' => 'Fiji',
        'COUNTRY_FI' => 'Finland',
        'COUNTRY_FR' => 'France',
        'COUNTRY_GF' => 'French Guiana',
        'COUNTRY_PF' => 'French Polynesia',
        'COUNTRY_TF' => 'French Southern Territories',
        'COUNTRY_GA' => 'Gabon',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GE' => 'Georgia',
        'COUNTRY_DE' => 'Germany',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Greece',
        'COUNTRY_GL' => 'Greenland',
        'COUNTRY_GD' => 'Grenada',
        'COUNTRY_GP' => 'Guadeloupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guinea',
        'COUNTRY_GW' => 'Guinea-Bissau',
        'COUNTRY_GY' => 'Guyana',
        'COUNTRY_HT' => 'Haiti',
        'COUNTRY_HM' => 'Heard Island and McDonald Islands',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Hungary',
        'COUNTRY_IS' => 'Iceland',
        'COUNTRY_IN' => 'India',
        'COUNTRY_ID' => 'Indonesia',
        'COUNTRY_IR' => 'Iran, Islamic Republic of',
        'COUNTRY_IQ' => 'Iraq',
        'COUNTRY_IE' => 'Ireland',
        'COUNTRY_IL' => 'Israel',
        'COUNTRY_IT' => 'Italy',
        'COUNTRY_JM' => 'Jamaica',
        'COUNTRY_JP' => 'Japan',
        'COUNTRY_JO' => 'Jordan',
        'COUNTRY_KZ' => 'Kazakhstan',
        'COUNTRY_KE' => 'Kenya',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Korea, Democratic Peoples Republic of',
        'COUNTRY_KR' => 'Korea, Republic of',
        'COUNTRY_KW' => 'Kuwait',
        'COUNTRY_KG' => 'Kyrgyzstan',
        'COUNTRY_LA' => 'Lao Peoples Democratic Republic',
        'COUNTRY_LV' => 'Latvia',
        'COUNTRY_LB' => 'Lebanon',
        'COUNTRY_LS' => 'Lesotho',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LY' => 'Libyan Arab Jamahiriya',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Lithuania',
        'COUNTRY_LU' => 'Luxembourg',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Macedonia, The Former Yugoslav Republic of',
        'COUNTRY_MG' => 'Madagascar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malaysia',
        'COUNTRY_MV' => 'Maldives',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Marshall Islands',
        'COUNTRY_MQ' => 'Martinique',
        'COUNTRY_MR' => 'Mauritania',
        'COUNTRY_MU' => 'Mauritius',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'Mexico',
        'COUNTRY_FM' => 'Micronesia, Federated States of',
        'COUNTRY_MD' => 'Moldova, Republic of',
        'COUNTRY_MC' => 'Monaco',
        'COUNTRY_MN' => 'Mongolia',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Morocco',
        'COUNTRY_MZ' => 'Mozambique',
        'COUNTRY_MM' => 'Myanmar',
        'COUNTRY_NA' => 'Namibia',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Netherlands',
        'COUNTRY_AN' => 'Netherlands Antilles',
        'COUNTRY_NC' => 'New Caledonia',
        'COUNTRY_NZ' => 'New Zealand',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Norfolk Island',
        'COUNTRY_MP' => 'Northern Mariana Islands',
        'COUNTRY_NO' => 'Norway',
        'COUNTRY_OM' => 'Oman',
        'COUNTRY_PK' => 'Pakistan',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Palestinian Territory, Occupied',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PG' => 'Papua New Guinea',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Peru',
        'COUNTRY_PH' => 'Philippines',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Poland',
        'COUNTRY_PT' => 'Portugal',
        'COUNTRY_PR' => 'Puerto Rico',
        'COUNTRY_QA' => 'Qatar',
        'COUNTRY_RE' => 'Reunion',
        'COUNTRY_RO' => 'Romania',
        'COUNTRY_RU' => 'Russian Federation',
        'COUNTRY_RW' => 'Rwanda',
        'COUNTRY_SH' => 'Saint Helena',
        'COUNTRY_KN' => 'Saint Kitts and Nevis',
        'COUNTRY_LC' => 'Saint Lucia',
        'COUNTRY_PM' => 'Saint-Pierre and Miquelon',
        'COUNTRY_VC' => 'Saint Vincent and the Grenadines',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Sao Tome and Principe',
        'COUNTRY_SA' => 'Saudi Arabia',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Serbia and Montenegro',
        'COUNTRY_SC' => 'Seychelles',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SG' => 'Singapore',
        'COUNTRY_SK' => 'Slovakia',
        'COUNTRY_SI' => 'Slovenia',
        'COUNTRY_SB' => 'Solomon Islands',
        'COUNTRY_SO' => 'Somalia',
        'COUNTRY_ZA' => 'South Africa',
        'COUNTRY_GS' => 'South Georgia and the South Sandwich Islands',
        'COUNTRY_ES' => 'Spain',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Sudan',
        'COUNTRY_SR' => 'Suriname',
        'COUNTRY_SJ' => 'Svalbard and Jan Mayen',
        'COUNTRY_SZ' => 'Swaziland',
        'COUNTRY_SE' => 'Sweden',
        'COUNTRY_CH' => 'Switzerland',
        'COUNTRY_SY' => 'Syrian Arab Republic',
        'COUNTRY_TW' => 'Taiwan',
        'COUNTRY_TJ' => 'Tajikistan',
        'COUNTRY_TZ' => 'Tanzania, United Republic Of',
        'COUNTRY_TH' => 'Thailand',
        'COUNTRY_TL' => 'Timor-Leste',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad and Tobago',
        'COUNTRY_TN' => 'Tunisia',
        'COUNTRY_TR' => 'Turkey',
        'COUNTRY_TM' => 'Turkmenistan',
        'COUNTRY_TC' => 'Turks and Caicos Islands',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ukraine',
        'COUNTRY_AE' => 'United Arab Emirates',
        'COUNTRY_GB' => 'United Kingdom',
        'COUNTRY_US' => 'United States',
        'COUNTRY_UM' => 'United States Minor Outlying Islands',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Uzbekistan',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Vatican City State',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Viet Nam',
        'COUNTRY_VG' => 'Virgin Islands, British',
        'COUNTRY_VI' => 'Virgin Islands, U.S.',
        'COUNTRY_WF' => 'Wallis and Futuna',
        'COUNTRY_EH' => 'Western Sahara',
        'COUNTRY_YE' => 'Yemen',
        'COUNTRY_ZM' => 'Zambia',
        'COUNTRY_ZW' => 'Zimbabwe',

        // Admin widget
        'ERROR_LOG' => 'Error Log',
        'CANNOT_READ_ERROR_LOG' => 'Can\'t read error log',
        'CANNOT_OPEN_ERROR_LOG' => 'Can\'t open error log',
        'CANNOT_SCAN_ERROR_LOG' => 'Can\'t scan error log',
        'MODELS_RESET' => 'Models reset:',
        'NO_MODELS_RESET' => 'No models reset.',

        // Feed widget
        'NO_FEED_TO_DISPLAY' => 'You are currently displaying no items.',
        'BOX_WILL_NOT_SHOW_FEED' => 'This box won\'t show up for other people unless you select at least one item.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Please click Edit to specify the RSS feed for this box.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'A problem occurred retrieving this RSS feed.',
        'MORE_ELLIPSIS' => 'More…',
        'RSS' => 'RSS',

        // GADGETS
        'CHOOSE_GADGETS' => 'Choose one of these great OpenSocial gadgets to add to your profile page! You can <a %s>view and rate gadgets here</a>, or <a %s>learn more about OpenSocial here</a>.',
        'GADGETS_UNAVAILABLE' => 'Gadgets temporarily unavailable',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Our apologies - gadgets are temporarily unavailable.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'This box won\'t show up for other people unless you select a Gadget.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Please click Edit to specify the Gadget URL for this box or visit the <a %s>Gadget Directory</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'A problem occurred retrieving this Gadget URL feed.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Add this gadget to your profile',
        'GADGETS_BETA' => 'Gadgets (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Try out OpenSocial Gadgets.  Warning: this feature is experimental.',
        'ADD_TO_MY_PAGE' => 'Add to My Page',
        'GADGETS' => 'Gadgets',
        'GADGETS_TAB_TEXT' => 'Gadgets',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Gadgets is in Beta.',
        'SORRY_GADGET_UNAVAILABLE' => 'We\'re sorry, but this Gadget is unavailable. Please check to ensure that you have the right URL. If you are still having issues, <a %s>please let us know</a>.',

        // error.php
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'We\'re sorry, this site has an issue.',
        'PLEASE_TRY_REFRESHING' => 'Please try refreshing the page in 30 seconds, or <a %s>let us know</a> if you get this message again.',

        // Page Widget
        'NO_DISCUSSIONS_TAGGED_X' => 'There aren\'t any discussions tagged "%1$s".',
        'PAGE_TITLE_COLON' => 'Page Title:',
        'PAGE_CONTENT' => 'Content:',
        'CREATE_PAGE' => 'Create Page',
        'CREATE_NEW_PAGE' => 'Create a New Page',
        'YOUR_COMMENT' => 'Your Comment',
        'ADD_YOUR_COMMENT' => 'Add Your Comment',
        'DELETE_PAGE' => 'Delete this Page',
        'DELETE_THIS_PAGE_Q' => 'Delete This Page?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Are you sure you want to delete this page (including all comments)? This process may take a few minutes.',
        'SEARCH_PAGES' => 'Search Pages',
        'ALL_PAGES' => 'All Pages',
        'SUBSCRIBE_TO_PAGES' => 'Subscribe to these pages',
        'NOBODY_HAS_ADDED_PAGES' => 'Nobody has added any pages yet!',
        'ADD_PAGES_CALL_TO_ACTION' => ' Create a Page to get started.',
        'CREATE_A_PAGE' => 'Create a Page',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Please enter the page content',
        'SEARCH_RESULTS_FOR_X' => 'Search Results for <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Edit Your Page',
        'UPDATE_PAGE' => 'Update Page',

        // Forum widget
        'ADMIN_OPTIONS' => 'Admin Options',
        'POSTED_BY_USER_ON_DATE_AT_TIME' => 'Posted by %1$s on %2$s at %3$s',
        'POSTED_BY_USER_ON_DATE_AT_TIME_IN_GROUP' => 'Posted by %1$s on %2$s at %3$s in <a %4$s>%5$s</a>',
        'POSTED_BY_USER_ON_DATE_AT_TIME_IN_CATEGORY' => 'Posted by %1$s on %2$s at %3$s in <a %4$s>%5$s</a>',
        'POSTED_BY_USER_ON_DATE_AT_TIME_IN_CATEGORY_CHANGE' => 'Posted by %1$s on %2$s at %3$s in <span><a %4$s>%5$s</a> (<a %6$s>Change</a>)</span>',
        'CLOSE_DISCUSSION' => 'Close Discussion',
        'REOPEN_DISCUSSION' => 'Re-open Discussion',
        'CLOSING_DISCUSSION_PREVENTS' => 'Closing a discussion prevents any further replies',
        'NO_DISCUSSION_TO_DISPLAY' => 'You are currently displaying no discussions.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'This box won\'t show up for other people unless you select at least one discussion.',
        'NEWEST_DISCUSSIONS' => 'Newest Discussions',
        'LATEST_REPLIES' => 'Latest Replies',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Replies are closed for this discussion.',
        'SORRY_DISCUSSION_CLOSED' => 'We\'re sorry, but this discussion has just been closed to further replies.',
        'MOST_REPLIES' => 'Most Replies',
        'OWNER_DISCUSSIONS_ONLY' => 'Creator Discussions Only',
        'MY_DISCUSSIONS_ONLY' => 'My Discussions Only',
        'DISCUSSION_DELETED' => 'Discussion Deleted',
        'DISCUSSION_HAS_BEEN_DELETED' => 'This discussion is no longer available.',
        'REPLY_DELETED' => 'Reply Deleted',
        'REPLY_HAS_BEEN_DELETED' => 'This reply has been deleted. <a %s>Return to the discussion.</a>',
        'VIEW_ALL_DISCUSSIONS' => 'View All Discussions',
        'ADD_CATEGORIES' => 'Add Categories',
        'CATEGORY' => 'Category:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'There are no discussions in this category yet.',
        'ADD_MANAGE_CATEGORIES' => 'Add/Manage Categories',
        'VIEW_ALL_N_CATEGORIES' => 'View All %s Categories', //TODO do we need to use the pluralize function here for i18n reasons?
        'UNTITLED_CATEGORY' => 'Untitled Category',
        'SAMPLE_TITLE' => 'Sample Title',
        'UNCATEGORIZED' => 'Uncategorized',
        'EXISTING_DISCUSSIONS' => 'Existing discussions that have not been assigned a category.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'There aren\'t any categories at the moment. Add a category to get started!',
        'ADD_A_CATEGORY' => 'Add a Category',
        'ADD_ANOTHER_CATEGORY' => 'Add Another Category',
        'MANAGE_CATEGORIES' => 'Manage Categories',
        'CATEGORY_TITLE' => 'Category Title',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Allow members to start discussions in this category',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Only I can start discussions in this category',
        'ALLOW_MEMBERS_TO_REPLY' => 'Allow members to reply',
        'SUGGESTIONS' => 'Suggestions:',
        'TRY_DIFFERENT_KEYWORDS' => 'Try different or more general keywords',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>View All Discussions</a> or <a %s>Start a New Discussion</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Make sure all words are spelled correctly',
        'REPLY_WAS_DELETED' => 'This reply was deleted',
        'TAGS_X_NO_STRONG' => 'Tags: %s',
        'PERMALINK_TO_REPLY' => 'Permalink to this Reply',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Our apologies - we couldn\'t find any discussions matching your search.',
        'DISCUSSIONS_MATCHING_X' => 'Discussions matching <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Search Discussions',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'You haven\'t added any discussions yet!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Add discussions and share them with your friends, family or the rest of the world!',
        'DISCUSSION' => 'Discussion',
        'DISCUSSIONS' => 'Discussions',
        'KEEP_PAGE_OPEN_FORUM' => 'Please keep this page open so we can finish uploading your files to the forum.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Meanwhile, feel free to <a %s>open a new browser window</a> and continue using %s.',
        'START_A_NEW_DISCUSSION' => 'Start a New Discussion',
        'DISCUSSION_TITLE' => 'Discussion Title:',
        'FIRST_POST' => 'Post:',
        'UPLOAD_FILES' => 'Attach File(s):',
        'START_DISCUSSION' => 'Start Discussion',
        'EDIT_DISCUSSION' => 'Edit Discussion',
        'START_A_DISCUSSION' => 'Start a Discussion',
        'ALL_DISCUSSIONS' => 'Forum Home',
        'MY_DISCUSSIONS' => 'My Discussions',
        'READ_MORE' => 'Read More',
        // _T is for "time elapsed" - see xg_elapsed_time [Jon Aquino 2007-03-13]
        'ADDED_BY_X_T' => 'Added by %s %s',
        'STARTED_BY_X_T' => 'Started by %s %s',
        'REPLY_BY_USER_WHEN' => '<a %1$s>Permalink</a> Reply by %2$s <span %3$s>%4$s</span>',
        'REPLY_BY_USER_DATE_TIME' => '<a %1$s>Permalink</a> Reply by %2$s on <span %3$s>%4$s at %5$s</span>',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Started by %s. Last <a %s>reply</a> by %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => 'Started this discussion. Last <a %s>reply</a> by %s %s.',
        'STARTED_DISCUSSION_T' => 'Started this discussion %s',
        'ADDED_REPLY_T' => 'Added a reply %s',
        'ADDED_POST_T' => 'Added a post %s',
        'STARTED_BY_X_ON' => 'Started by %s on %s',
        'STARTED_DISCUSSION_ON' => 'Started this discussion %s',
        'STARTED_ON' => 'Started</strong> %s',
        'ADDED_REPLY_ON' => 'Added a reply %s',
        'ADDED_POST_ON' => 'Added a post %s',
        'XS_DISCUSSIONS' => '%s\'s discussions',
        'XS_DISCUSSIONS_LOWERCASE' => '%s\'s discussions',
        'VIEW_XS_DISCUSSIONS' => 'View %s\'s discussions',
        'VIEW_YOUR_DISCUSSIONS' => 'View your discussions',
        'TAGGED_X' => 'Tagged: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Subscribe to these discussions',
        'SUBSCRIBE_TO_DISCUSSION' => 'Subscribe to this discussion',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Subscribe to %s\'s discussions',
        'ALL_DISCUSSIONS_TAGGED_X' => 'All Discussions Tagged <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Subscribe to Discussions Tagged \'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Uploading Files',
        'ATTACHMENTS' => 'Attachments:',
        'YOUR_REPLY' => 'Your Reply:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Upload Files',
        'ADD_YOUR_REPLY' => 'Add Reply',
        'ADD_YOUR_POST' => 'Add Your Post',
        'REPLIES_TO_THIS_DISCUSSION' => 'Replies to This Discussion',
        'PLEASE_ENTER_TITLE' => 'Please enter a title for the discussion',
        'PLEASE_ENTER_FIRST_POST' => 'Please write the first post for the discussion.',
        'REPLY_TO_THIS' => 'Reply to This',
        'DELETE_ATTACHMENT' => 'Delete Attachment',
        'DELETE_ATTACHMENT_Q' => 'Delete this attachment?',
        'DELETE_THIS_DISCUSSION_Q' => 'Delete This Discussion?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Are you sure you want to delete this discussion (including all replies)? This process may take a few minutes.',
        'DELETE_DISCUSSION' => 'Delete Discussion',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Nobody has added any discussions yet.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Nobody has added any discussions yet! Add a discussion to get started.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'You haven\'t added any discussions yet. Add a discussion to get started!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS'  => 'You haven\'t started any discussions yet.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS'  => 'You haven\'t added to any discussions yet.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s hasn\'t added any discussions yet.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s hasn\'t started any discussions yet.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s hasn\'t added to any discussions yet.',
        'VIEW_DISCUSSIONS' => 'View Discussions',
        'VIEW_ALL_PEOPLE_ON_X' => 'View All People on %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'There are currently no discussions on your network.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'This group does not have any discussions yet.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'View discussions in the <a %s>%s forum</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'There aren\'t any discussions tagged "%1$s". Check out <a %2$s>photos tagged "%1$s"</a>, <a %4$s>blog posts tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>. Or add and tag your own discussions!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'There aren\'t any discussions tagged "%1$s". Check out <a %2$s>photos tagged "%1$s"</a>, <a %4$s>blog posts tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'This box won\'t show up for other people until there are discussions to show. Why not start one?',
        'DISCUSSIONS_I_STARTED' => 'Discussions I Started',
        'DISCUSSIONS_X_STARTED' => 'Discussions %s Started',
        'DISCUSSIONS_I_REPLIED_TO' => 'Discussions I Replied To',
        'DISCUSSIONS_X_REPLIED_TO' => 'Discussions %s Replied To',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Please write something for your post.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Please write something for your reply.',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s replied to a discussion on %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s replied to the discussion "%s" on %s',
        'ADD_TAGS' => 'Add Tags',
        'EDIT_YOUR_TAGS' => 'Edit Your Tags',


        // Groups widget
        'GROUPS_HOME' => 'Groups Home',
        'OR' => 'or',
        'MEMBERS_N' => 'Members (%s)',
        'ALREADY_MEMBER_OF_GROUP' => '(Already a member of this group)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Invite Your Friends to \'%s\'',
        'PROBLEM_WITH_ICON' => 'There was a problem with the icon file',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Group Administrators have a similar level of control to the Group Creator.',
        'CREATE_NEW_GROUP' => 'Create New Group',
        'CREATE_A_GROUP' => 'Create a Group',
        'VIEW_GROUPS' => 'View Groups',
        'CREATE_GROUP' => 'Create Group',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Please choose a name for your group.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Please choose a web address for your group.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'The web address can contain only letters and numbers (no spaces).',
        'NAME_TAKEN' => 'Our apologies - that name has already been taken. Please choose another name.',
        'URL_TAKEN' => 'Our apologies - that web address has already been taken. Please choose another web address.',
        'GROUP_INFORMATION' => 'Group Information',
        'URL' => 'URL',
        'GROUPS' => 'Groups',
        'NOBODY_HAS_CREATED_GROUPS' => 'Nobody has created any groups yet.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Nobody has created any groups yet! Create a group to get started.',
        'MY_GROUPS' => 'My Groups',
        'FEATURED_GROUPS' => 'Featured Groups',
        'GROUP_FORUM' => '%s Forum',
        'JOIN_GROUP' => 'Join %s',
        'USER_HAS_INVITED_YOU_TO_JOIN_NETWORK' => '%s has invited you to join %s',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s has invited you to join %s.',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP_ON_X' => '%1$s has invited you to join %2$s on %3$s',
        'DECLINE' => 'Decline',
        'WELCOME_TO_GROUP' => 'Welcome to %s',
        'EDIT_GROUP_INFO' => 'Edit Group',
        'EDIT_GROUP_INFORMATION' => 'Edit Group Information',
        'GROUP_HAS_NO_MEMBERS' => 'This group doesn\'t have any members yet!',
        'USERS_GROUPS' => '%s\'s Groups',
        'YOU_ARE_NOT_MEMBER_OF_GROUPS' => 'You\'re not currently a member of any groups.',
        'YOU_HAVE_NOT_CREATED_GROUPS'  => 'You haven\'t created any groups yet.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s hasn\'t created any groups yet.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'There are no featured groups on your social network.',
        'NO_FEATURED_GROUPS' => 'There are no featured groups on this social network.',
        'START_FEATURING_GROUPS' => 'Start featuring groups where you see the Feature option. To learn more about featuring, <a %s>click here</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'You are currently displaying no groups.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'This box won\'t show up for other people unless you select at least one group.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'You haven\'t created any groups yet!',
        'CREATE_GROUPS_AND_SHARE' => 'Create groups and share them with your friends, family or the rest of the world!',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Groups matching <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Our apologies - we couldn\'t find any groups matching your search.',
        'DELETE_GROUP' => 'Delete Group',
        'DELETE_GROUP_Q' => 'Are you sure you wish to delete this group?',
        'ONLY_INVITED_PEOPLE' => 'Only Invited People',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Allow people to request an invitation',
        'PLEASE_ENTER_NAME' => 'Please enter your name',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Please enter your email address.',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Please enter a new page address.',
        'PLEASE_ENTER_PASSWORD' => 'Please enter your password.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Click here to create an account</a> or try to sign in again below.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Click here to create an account</a> or try to join with your Ning ID again below.',
        'CHOOSE_SHORTER_PASSWORD' => 'Please choose a shorter password.',
        'CHOOSE_SHORTER_NAME' => 'Please choose a shorter name.',
        'ENTER_SHORTER_CITY_NAME' => 'Please enter a shorter city name.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Please enter your password again in the "Retype Password" box.',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Please enter your current password.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Please enter your new password.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Please enter your new password again in the "Confirm Password" box.',
        'CURRENT_PASSWORD' => 'Current Password',
        'PASSWORDS_DO_NOT_MATCH' => 'The two passwords do not match.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'The new password and the confirmation password do not match.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s is not a valid email address',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Come join me on %1$s on %2$s…',
        'X_INCLUDES_COLON' => '%s includes:',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Come join me on %1$s on %2$s!',
        'COME_JOIN_ME_ON_X_EXCL' => 'Come join me on %1$s!',
        'IF_YOUR_CLIENT_NOLINKS' => 'If your email program doesn\'t recognize the web address above as an active link,
please copy and paste it into your web browser',
        'TO_CONTROL_WHICH_EMAILS' => 'To control which emails you receive on the corner, or to opt-out, go to:',
        'INVITE_TO_GROUP' => 'Invite to \'%s\'',
        'THANX_USERNAME' => 'Thanks,

- %s',
        'CHECK_OUT_X_ON_Y_COLON' => 'Check out %1$s on %2$s:',
        'CHECK_OUT_X_COLON' => 'Check out %1$s:',
        'USERNAME_AND_OTHER_ARE_ALREADY_MEMBERS' => '%1$s and others are already members of %2$s on %3$s…',
        'MEMBERS_ALREADY_ON_X' => 'Members already on %s',
        'GROUPNAME_MEMBERS' => '%s Members',
        'GROUP_CREATOR' => 'Group Creator',
        'GROUP_ADMINISTRATOR' => 'Group Administrator',
        'DATE_BANNED' => 'Date Banned',
        'BAN_FROM_GROUP' => 'Ban from Group',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Are you sure you want to ban the selected member(s) from your group? This process may take a few minutes.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Also delete their forum postings and replies.',
        'GROUP_WEB_ADDRESS' => 'Group Address',
        'IF_GROUP_HAS_WEBSITE' => 'If your group has another website, add it here',
        'GROUP' => 'Group',
        'BACK_TO_GROUP' => '← Back to %s',
        'GROUP_ADMIN_DISCUSSIONS' => 'Group Admin Discussions',
        'MOST_MEMBERS' => 'Most Members',
        'THIS_SETS_URL_OF_GROUP' => 'This sets the URL of your group:<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Like what you see on %s? Join Now!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Like what you see in %s? Join Now!',
        'MEMBERS_COLON' => 'Members:',
        'INFORMATION' => 'Information',
        'WEBSITE_COLON' => 'Website:',
        'STEP_ONE_GROUP_INFORMATION' => 'Step 1: Set up your group\'s information',
        'STEP_TWO_INVITE_MEMBERS' => 'Step 2: Invite members',
        'WEBSITE' => 'Website',
        'IF_GROUP_HAS_LOCATION' => 'If your group is based somewhere, add your town or city',
        'CHOOSE_THE_GROUP_FEATURES' => 'Choose the features you want on your group page.',
        'RSS_READER' => 'RSS Reader',
        'WHO_CAN_JOIN_GROUP_PRIVACY' => 'Choose who can join this group. Privacy can\'t be changed after the group is created.',
        'MESSAGES' => 'Messages',
        'ALLOW_MEMBERS_TO_MESSAGE' => 'Allow members to send messages to the entire group',
        'IMAGE' => 'Image',
        'SEND_MESSAGE_TO_GROUP' => 'Send Message to Group',
        'MANAGE_GROUP_MEMBERS' => 'Manage Group Members',
        'JOIN_NOW' => 'Join Now',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'You are now a member of %1$s. You can participate in the %1$s forum or invite more people to join. ',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'You are now a member of %s!',
        'LEAVE_GROUP' => 'Leave Group',
        'WERE_SORRY' => 'We\'re Sorry.',
        'GROUP_OWNER_LIMITED_ACCESS' => 'The Group Owner has limited membership to this group.',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'You have created the group %1$s. You can start a discussion in the %1$s forum or invite more people to join.',
        'MEMBERSHIP_BY_INVITATION_ONLY_FS' => 'Membership is by invitation only.',
        'MEMBERSHIP_IS_BY_INVITATION_ONLY' => 'Membership is by invitation only',
        'WHY_NOT_CREATE_YOUR_OWN' => 'Why not <a %s>create your own group</a>?',
        'GROUP_IS_ACCEPTING_MEMBERS' => '%s is accepting new members. If you would like to join, <a %s>click here to request an invitation</a> from the Group Creator.',
        'OPTIONAL_PARENTHASIES' => '(Optional)',
        'SEND_REQUEST' => 'Send Request',
        'YOUR_GROUP_REQUEST_SENT' => 'Your request has been sent to the Group Creator.',
        'GO_BACK' => '← Go Back',
        'SKIP' => 'Skip →',
        'PLEASE_PROVIDE_GROUP_IMAGE' => 'Please provide a group image.',
        'ALL_GROUPS_IN_X' => 'All Groups in %s',

        // Music widget
        'MUSIC_PLAYER_WILL_LINK' => 'The music player will link to the external MP3s you add.',
        'MY_MUSIC' => 'My Music',
        'YOU_CAN_ADD_100_SONGS' => 'You can add 100 total songs, and each may be up to 20MB in size. We support songs in the .mp3 file format. ',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'I have the right to upload these songs under the <a %s">Terms of Service</a>.',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'The bulk music uploader requires a recent version of Java. <strong><a %s>Click here to get Java</a></strong>, or <strong><a %s>return to the simple uploader</a></strong>.',
        'HAVE_LOT_OF_MUSIC' => 'Have a lot of music you want to share?',
        'TRY_BULK_MUSIC_UPLOADER' => 'Try the bulk music uploader',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Your songs were successfully uploaded.',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Sorry, you can only have %s songs in your playlist. Please remove some existing songs before adding more.',
        'ADD_MUSIC_FROM_WEBSITE' => 'Add music from another website',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Having problems with this music uploader?  <strong><a %s>Return to our simple uploader</a></strong>.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Upload Music From Your Computer',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'This network doesn\'t have any music yet.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'This person doesn\'t have any music yet.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Find more music like this on <em>%s</em>',
        'ADD_MUSIC' => 'Add Music',
        'ADD_MUSIC_TRACKS'                              => 'Add Music',
        'CHOOSE_MUSIC_TRACKS'                           => 'Choose Songs to Add',
        'UPLOAD_TRACKS'                                 => 'Upload Songs',
        'ADD_TRACKS'                                    => 'Add Songs',
        'ENTER_THE_URL_MP3_TO_ADD'                      => 'Enter the URL to each MP3 you\'d like to add:',
        'EACH_MP3_FILE_MAY_BE_UP_TO'                    => 'You can upload up to 100 MP3s! Each MP3 file may be up to 20MB in size, but smaller files will upload more quickly.',
        'BE_NICE'                                       => 'Be nice',
        'PLEASE_UPLOAD_ONLY_TRACKS'                     => 'Please only upload songs if you have permission to do so from the artist or copyright holder.',
        'PLEASE_LINK_ONLY_TRACKS'                       => 'Please link only to music which has been authorized for distribution on the web.',
        'MORE_WAY_TO_ADD_MUSIC'                         => 'More ways to add music…',
        'ELLIP_FROM_ANOTHER_WEBSITE'                    => '…from another website',
        'ADD_MUSIC_FROM_ANY_WEBSITE'                    => 'Add music from any website by pasting in a link to the MP3.',
        'KEEP_PAGE_OPEN_MUSIC'                          => 'Please keep this page open so we can finish uploading your songs and we\'ll let you know when they\'ve been approved!',
        'MEANWHILE_FEEL_FREE_MUSIC'                     => 'Meanwhile, feel free to <a %s>open a new browser window</a> and continue using %s. When uploading is complete, you\'ll be able to add titles and descriptions to your songs in this window.',
        'TRACKS_EXCEEDED_LIMIT'                         => 'The track(s) seem to have exceeded the limit of 10 MB per song.',
        'EDIT_TRACK_INFORMATION'                        => 'Edit Song Information',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1'    => 'Add a title, description, and other information to the songs you just uploaded.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2'    => 'Add a title, description, and other information for this song.',
        'CANCEL_AND_RETURN_TO_PLAYLIST'                 => '« Cancel and return to playlist',
        'TRACK_TITLE'                                   => 'Song Title',
        'TRACK_ARTIST'                                  => 'Artist',
        'TRACK_ALBUM'                                   => 'Album',
        'ENABLE_DOWNLOAD_LINK'                          => 'Enable download link',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE'          => 'Allow people to put this song on their pages',
        'TRACK_ARTWORK'                                 => 'Artwork',
        'EDIT_PLAYLIST'                                 => 'Edit Playlist',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST'                 => 'To re-order your playlist, click on the song and drag it to where you want it to play.',
        'ADD_MUSIC_ELLIPSIS'                            => 'Add music…',
        'ELLIPSIS_FROM_YOUR_COMPUTER'                   => '…from your computer',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER'                 => 'Upload MP3s from your computer.',
        'DELETE_THIS_TRACK_Q'                           => 'Delete This Song?',
        'DELETE_TRACK'                                  => 'Delete Song',
        'ARE_YOU_SURE_DELETE_THIS_TRACK'                => 'Are you sure you want to delete this song?',
        'PLAY'                                          => 'play',
        'GENRE'                                         => 'Genre',
        'YEAR'                                          => 'Year',
        'LABEL'                                         => 'Label',
        'EXPLICIT_LYRICS'                               => 'Explicit Lyrics',
        'ARTIST_SITE'                                   => 'Artist Site',
        'HOSTING_SITE'                                  => 'Hosting Site',
        'LABEL_SITE'                                    => 'Label Site',
        'LICENSE'                                       => 'License',
        'SELECT_LICENSE'                                => '— Select license —',
        'LICENSE_NAME'                                  => 'License Name',
        'LICENSE_URL'                                   => 'License URL',
        'MUSIC'                                         => 'Music',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO'        => 'Allow people to upload and share audio',
        'PLAYLIST'                                      => 'Playlist',
        'PODCAST'                                       => 'Podcast',
        'MOST_RECENT_TRACKS'                            => 'Most Recent',
        'FEATURED_TRACKS'                               => 'Featured',
        'HIGHEST_RATED_TRACKS'                          => 'Highest Rated',
        'NO_TRACKS_TO_PLAY'                             => 'There is currently no music on your network.',
        'BOX_WILL_NOT_SHOW_TRACKS'                      => 'This box won\'t show up for anyone else until until there is a song or podcast to play. Why not add one?',
        'NO_FEATURED_TRACKS'                            => 'There are no featured songs on your network.',
        'START_FEATURING_TRACKS'                        => 'Start featuring songs when you hear one you would like to appear on the Main page.',
        'MY_PLAYLIST'                                   => 'My Playlist',
        'NETWORK_PLAYLIST'                              => 'Network Playlist',

        //license names
        'COPYRIGHT'                                     => '© All Rights Reserved',
        'CC_BY_X'                                       => 'Creative Commons Attribution %s',
        'CC_BY_SA_X'                                    => 'Creative Commons Attribution Share Alike %s',
        'CC_BY_ND_X'                                    => 'Creative Commons Attribution No Derivatives %s',
        'CC_BY_NC_X'                                    => 'Creative Commons Attribution Non-commercial %s',
        'CC_BY_NC_SA_X'                                 => 'Creative Commons Attribution Non-commercial Share Alike %s',
        'CC_BY_NC_ND_X'                                 => 'Creative Commons Attribution Non-commercial No Derivatives %s',
        'PUBLICDOMAIN'                                  => 'Public Domain',

        //facebook
        'FACEBOOK_CONFIRM_DISABLE'                      => 'Are you sure?',

        'FACEBOOK_MUSIC_PLAYER_TITLE'                   => 'Music Player',
        'FACEBOOK_MUSIC_PLAYER_DESC'                    => 'Allow anyone to add an application to their Facebook profile pages that plays your music selection.',
        'FACEBOOK_MUSIC_BUTTON'                         => 'Create Music Application &raquo;',

        'FACEBOOK_VIDEO_PLAYER_TITLE'                   => 'Video Player',
        'FACEBOOK_VIDEO_PLAYER_DESC'                    => 'Allow anyone to add an application to their Facebook profile pages that plays a video from your network.',
        'FACEBOOK_VIDEO_BUTTON'                         => 'Create Video Application &raquo;',

        'FACEBOOK_SLIDESHOW_PLAYER_TITLE'               => 'Photo Slideshow',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC'                => 'Allow anyone to add an application to their Facebook profile pages that plays a slideshow of photos from your network.',
        'FACEBOOK_SLIDESHOW_BUTTON'                     => 'Create Photo Slideshow Application &raquo;',

        'FACEBOOK_PLATFORM_LOGO'                        => 'Facebook Platform logo',
        'FACEBOOK_QUICK_INTRO_1'                        => 'Facebook, a popular social networking site, allows third-party developers to create applications that can be added to Facebook member profile pages. In addition to providing added profile page functionality, these applications can be used to drive Facebook users to other web destinations.',
        'FACEBOOK_QUICK_INTRO_2'                        => 'With Ning, you don\'t need to be a developer to promote your social network on Facebook. We\'ve done all the heaving lifting, and your network comes pre-built with Facebook application integration. Just choose from the options below, and your social network will be integrated with Facebook in seconds.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON'                 => 'Add Developer button',
        'FACEBOOK_SETUP_NEW_APP_BUTTON'                 => 'Set up New Application button',

        'FACEBOOK_YOUR_APPLICATIONS'                    => 'Your Facebook Applications',
        'FACEBOOK_EMBEDDING'                            => 'Facebook Promotion',
        'FACEBOOK_SETUP'                                => 'Facebook Promotion',
        'FACEBOOK_PROMOTING'                            => 'Promoting Applications on Facebook',
        'FACEBOOK_VIEW_APP'                             => 'View Application',
        'FACEBOOK_ADD_TO_FACEBOOK'                              => 'Add to Facebook',
        'FACEBOOK_RECENT'                               => 'Most Recent',
        'FACEBOOK_RECENTLY_FEATURED'                    => 'Most Recently Featured',
        'FACEBOOK_RECENTLY_ADDED'                       => 'Most Recently Added',
        'FACEBOOK_PROMOTED'                             => 'Featured',
        'FACEBOOK_RATED'                                => 'Highest Rated',

        'FACEBOOK_INSTR_FIRST_STEPS'                    => 'First Steps',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK'   => 'Click here to go to Facebook and start creating your application.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW'    => 'This will open Facebook in a new window. If you\'re not already logged in to Facebook, you will need to log in now.',
        'FACEBOOK_INSTR_FIRST_STEPS_1'                  => 'If you haven\'t created an application on Facebook, you\'ll be asked to add Facebook\'s Developer application. Once you\'ve done that, it says "You have no applications." Click <strong>Create one</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2'                  => 'If you have already created an application on Facebook, you\'ll land on Facebook\'s Developer application. Click the <strong>Set Up New Application</strong> button.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT'               => 'Next: Instructions on how to setup your %s application for it to work on Facebook.',
        'FACEBOOK_INSTR_SETUP'                          => 'Setup Instructions',
        'FACEBOOK_INSTR_SETUP_1'                        => 'Great! Now for the details. Facebook needs to know some basic information to get your application off the ground. Just follow the steps below.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS'               => 'Required Fields',
        'FACEBOOK_INSTR_SETUP_2'                        => 'Choose an <strong>Application Name</strong>.',
        'FACEBOOK_INSTR_SETUP_3'                        => 'Check to indicate that you\'ve read the Facebook terms document.',
        'FACEBOOK_INSTR_SETUP_4'                        => 'Open the <em>Optional Fields</em> section.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT'                 => 'Base Options',
        'FACEBOOK_INSTR_SETUP_5'                        => 'Put your email address in the <strong>Support E-Mail</strong> field.',
        'FACEBOOK_INSTR_SETUP_6'                        => 'Paste the following web address into the <strong>Callback URL</strong> field:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X'                      => 'Choose a <strong>Canvas Page URL</strong> (e.g. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8'                        => 'Select <strong>Yes</strong> for <em>Can your application be added on Facebook</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT'                 => 'Installation Options',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION'               => 'Select <strong>Users</strong> and <strong>All Pages</strong>.',
        'FACEBOOK_INSTR_SETUP_APP_DESC'                 => 'Write an <strong>Application Description</strong>.',
        'FACEBOOK_INSTR_SETUP_9'                        => 'Paste the following code into the <strong>Default FBML</strong> field:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE'                      => 'For <strong>Default Profile Box Column</strong>, select <strong>Wide</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW'                    => 'For <strong>Default Profile Box Column</strong>, select <strong>Narrow</strong>.',
        'FACEBOOK_INSTR_SETUP_10'                       => 'In the <strong>Side Nav URL</strong> field, enter your <em>Canvas Page URL</em> (as created in step &#8216;f&#8217; above). Be sure to include the http://apps.facebook.com/ portion of the URL.',
        'FACEBOOK_INSTR_SETUP_11'                       => 'Write text for the <strong>Attachment action</strong>. This is what will appear if you\'re sending someone a message on Facebook and want to include one of your applications. If your application is a Photo Slideshow, you might enter Photos from Network Name. If your application is a Video Player, you might enter Videos from Network Name.',
        'FACEBOOK_INSTR_SETUP_12'                       => 'Paste the following web address into the <strong>Callback URL</strong> field:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE'         => 'Facebook application setup page',
        'FACEBOOK_INSTR_SETUP_DONE'                     => 'When you are done, click the <strong>Submit</strong> button.',
        'FACEBOOK_INSTR_SETUP_NEXT'                     => 'Next: Retrieving your API Key and Secret.',

        'FACEBOOK_API_INFO_TITLE'                       => 'Facebook API Information',
        'FACEBOOK_API_INFO_DESC'                        => 'In order to complete setup, you need to enter your API Key and Secret, and your Application URL in the fields below.',
        'FACEBOOK_API_INFO_FIND_KEY'                    => 'You can find the API Key and Secret on your <a %s>My Applications page on Facebook</a> (opens in new window) under the title of the application you have just created.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE'        => 'My Applications page (highlighting location of API information)',
        'FACEBOOK_API_INFO_KEY'                         => 'API Key',
        'FACEBOOK_API_INFO_SECRET'                      => 'API Secret',
        'FACEBOOK_URL_INFO_TITLE'                       => 'Facebook Application URL',
        'FACEBOOK_URL_INFO_DESC'                        => 'The Application URL is the same as the <strong>Canvas Page URL</strong> that you defined on the previous page (in step &#8216;f&#8217;).',

        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM'               => 'Facebook music applications should play:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM'               => 'Facebook video applications should play the video that is:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM'               => 'Facebook slideshow applications should play photos from:',
        'FACEBOOK_PROMOTING_ON'                         => 'Promoting on Facebook',
        'FACEBOOK_SETUP_INSTR'                          => 'Setup Instructions',
        'FACEBOOK_API_INFO'                             => 'API Information',
        'FACEBOOK_DISABLE'                              => 'Disable this Application',
        'FACEBOOK_BACK_TO_EMBEDDING'                    => 'Back to Facebook Promotion',
        'FACEBOOK_PROMOTE'                              => 'To get the most bang for your buck when it comes to promoting your new application, we recommend taking the following steps. These options can all be accessed from Facebook\'s <strong><a %s>My Applications</a></strong> page (link opens in new window).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE'             => 'Provide an About Page',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE'              => 'Let Facebook users know what your application is all about by providing a clear description. To edit this information, click the <strong>Edit About Page</strong> link next to the application you\'re modifying.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT'                 => 'Submit the Application to the Facebook Directory',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1'                => 'Spread the word about your new application by adding it to the Facebook directory.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2'                => 'To submit your application, click on the <strong>Submit Application</strong> link next to the application you\'re modifying. On the following page you can edit the Application Description and also add a logo for your App.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE'                => 'Add the Application to your Facebook Profile',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1'               => 'Show off your application by adding it to your Facebook profile page, then sit back and watch your friends do the same.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2'               => 'Just click the <strong>View About Page</strong> link next to the application you want to add to your profile, then choose the Add Application button on the next page.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3'               => 'Your application is now on the bottom of your Facebook profile page!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE'         => 'My Applications page on Facebook',

        // Tabs
        'FORUM_TAB_TEXT' => 'Forum',
        'VIDEOS_TAB_TEXT' => 'Videos',
        'PHOTOS_TAB_TEXT' => 'Photos',
        'GROUPS_TAB_TEXT' => 'Groups',

        // Events widget
        'EVENT' => 'event',
        'EVENT_COLON' => 'Event:',
        'EVENT_NAME' => 'Name',
        'EVENTS_TAB_TEXT' => 'Events',
        'EVENTS' => 'Events',
        'FEATURED_EVENTS'                               => 'Featured Events',
        'NOBODY_HAS_ADDED_EVENTS'                       => 'Nobody has added any Events yet. Add an Event to get started.',
        'NO_MATCHING_EVENTS_FOUND'                      => 'No matching events were found',
        'ADD_EVENTS'                                    => 'Add Events',
        'ADD_AN_EVENT'                                  => 'Add an Event',
        'CREATE_NEW_EVENT'                              => 'Create New Event',
        'EDIT_EVENT_INFORMATION'                        => 'Edit Event Information',
        'EVENT_INFORMATION'                             => 'Event Information',
        'EVENT_CREATE_STEP1'                            => 'Step 1: Create an Event',
        'EVENT_CREATE_STEP2'                            => 'Step 2: Invite members',
        'EVENT_IMAGE'                                   => 'Event Image',
        'EVENT_IMAGE_HINT'            => 'Add a photo or image as part of your event display',
        'EVENT_TYPE'                                    => 'Event Type',
        'DEFINE_EVENT_TYPE'                             => 'Example: Fundraiser, "Birthday Party"',
        'PROVIDE_THE_LOCATION'                          => 'Add a general location such as "The Fillmore" so your event will show up in area results',
        'IF_YOU_HOST'                                   => 'If you want the host to be someone other than you',
        'EVENTS_HOME' => 'Events Home',
        'DATE_IN_LOCATION' => '%1$s – %2$s',
        'LAST_MONTH' => 'Last Month',
        'NEXT_MONTH' => 'Next Month',
        'FEATURED_EVENT' => 'Featured Event',
        'ORGANIZED_BY_TYPE' => 'Organized by %1$s | Type: %2$s',
        'ADD_END_TIME' => 'Add End Time',
        'X_ADDED_A_COMMENT_TO_THE_EVENT_Y_ON_Z' => '%1$s added a comment to the event "%2$s" on %3$s.',
        'NO_LONGER_FOLLOWING_EVENT' => 'You are no longer following this event.',
        'YOU_COMMENTED_ON_EVENT_TITLE' => 'You commented on the event <a %1$s>%2$s</a>',
        'YOU_NEED_TO_RSVP_EVENT' => 'RSVP for %s to add comments!',
        'SURE_UNINVITE_PERSON' => 'Are you sure you want to uninvite this person?',
        'UNINVITE' => 'Uninvite',
        'UNINVITE_USER' => 'Uninvite %s',
        'DESCRIPTION_MUST_BE_SHORTER' => 'The description has to be shorter than %s characters.',
        'THERE_ARE_NO_FEATURED_EVENTS' => 'There are no featured events on your social network.',
        'START_FEATURING_EVENTS' => 'Start featuring events where you see the Feature option. To learn more about featuring, <a %s>click here</a>.',

        'YOU_CREATED_EVENT' => 'You created the event <a %1$s>%2$s</a>',
        'X_CREATED_EVENT_TITLE' => '%1$s created the event <a %2$s>%3$s</a>',
        'YOU_UPDATED_EVENT' => 'You updated the event <a %1$s>%2$s</a>',
        'X_UPDATED_EVENT_TITLE' => '%1$s updated the event <a %2$s>%3$s</a>',
        'YOU_CHANGED_EVENT_STATUS_ATTEND' => 'You decided to attend the event <a %1$s>%2$s</a>',
        'YOU_CHANGED_EVENT_STATUS_MIGHT' => 'You decided that you might attend the event <a %1$s>%2$s</a>',
        'X_CHANGED_EVENT_STATUS_ATTEND' => '%1$s decided to attend the event <a %2$s>%3$s</a>',
        'X_CHANGED_EVENT_STATUS_MIGHT' => '%1$s is undecided about attending the event <a %2$s>%3$s</a>',

        'X_LINK_COMMENTED_ON_EVENT_TITLE' => '%1$s commented on the event <a %2$s>%3$s</a>',
        'INVITE_TO_EVENT' => 'Invite to \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_EVENTNAME' => 'Invite Your Friends to \'%s\'',
        'USER_HAS_INVITED_YOU_TO_JOIN_EVENT' => '%s has invited you to join "%s" on %s.',
        'USER_HAS_INVITED_YOU_TO_EVENT' => '%s has invited you to %s.',
        'COME_JOIN_ME_AT_EVENT' => 'Come join me at %1$s on %2$s…',
        'CLICK_HERE_TO_RSVP_COLON' => 'Click here to RSVP:',
        'CLICK_HERE_TO_RSVP' => '<a %s>Click here to RSVP</a>',
        'ALREADY_RSVPED' => '(Already RSVPed)',
        'START_TIME'        => 'Start Time',
        'END_TIME'          => 'End Time',
        'REMOVE_END_TIME' => 'Remove End Time',
        'STREET'        => 'Street',
        'CITY_TOWN'     => 'City/Town',
        'WEBSITE_OR_MAP'    => 'Website or Map',
        'ADD_WEB_ADDRESS' => 'Add the web address for the venue or link to a <a %s>Google Map</a>',
        'PHONE' => 'Phone',
        'ORGANIZED_BY'  => 'Organized By',
        'EDIT_EVENT_TYPE' => 'Edit Event Type',
        'EDIT_LOCATION' => 'Edit Location',
        'ANYONE_CAN_SEE'        => 'Public: Anyone can see and RSVP',
        'ONLY_INVITED_EVENT'    => 'Private: Only invited people can RSVP',
        'CLOSE_EVENT'           => 'Close this event to new attendees',
        'HIDE_GUEST_LIST'		=> 'Hide Guest List',
        'DISABLE_RSVP'      => 'Disable RSVP',
        'THIS_WILL_PUBLICLY'    => 'This will hide your confirmed attendees, maybes, and nos',
        'CREATE_EVENT'          => 'Create Event',
        'NO_EVENT_TITLE' => 'Please enter a title for the event',
        'NO_EVENT_IMAGE' => 'Please upload an image for the event',
        'EVENT_IMAGE_IS_NOT_IMAGE' => 'Please upload a valid image for the event. We support JPEG, GIF, PNG, BMP and other popular formats',
        'NO_EVENT_DESCRIPTION' => 'Please enter a description for the event',
        'NO_EVENT_LOCATION' => 'Please enter a location for the event',
        'NO_EVENT_TYPE' => 'Please choose a type of the event',
        'WRONG_EVENT_START'     => 'Please enter a correct start date',
        'WRONG_EVENT_END'       => 'Please enter a correct end date',
        'WRONG_EVENT_END2'      => 'End time must be later than the start time',
        'UPCOMING_EVENTS'       => 'Upcoming Events',
        'TODAY'                 => 'Today',

        'EVENT_DATE_FMT'			=> 'F j, Y', // date()
        'EVENT_TIME_FMT'			=> 'g:ia', // date()
        'EVENT_START'				=> '<a %1$s>%2$s</a> at %3$s', // DATE at TIME
        'EVENT_START_FROM_TO_TIME'	=> '<a %1$s>%2$s</a> from %3$s to %4$s', // DATE from TIME to TIME
        'EVENT_START_FROM_TO_DATE'	=> '<a %1$s>%2$s</a> at %3$s to <a %4$s>%5$s</a> at %6$s', // DATE at TIME to DATE at TIME

        'CANCELLED_EVENT'			=> 'Cancelled Event',
        'WE_ARE_SORRY_EVENT_CANCELLED'=> 'We\'re sorry but this event has been cancelled by the Event Creator.',

        'EVENT_TM_FMT2'         => 'F j',
        'EVENT_TITLE_FMT'       => 'l, F j, Y',
        'POPULAR_EVENT_TYPES'   => 'Popular Event Types',
        'ALL_TYPE_EVENTS'       => 'All %s Events',
        'ALL_MY_TYPE_EVENTS'    => 'All My %s Events',
        'EVENT_DESCRIPTION'     => 'Event Description',
        'EVENT_LOCATION'		=> 'Event Location',
        'EVENT_DESCRIPTION_COLON'     => 'Event Description:',
        'EVENT_DETAILS'         => 'Event Details',
        'ALL_EVENTS_IN'         => 'All Events in %s',
        'ALL_FEATURED_EVENTS'   => 'All Featured Events',
        'MY_UPCOMING_EVENTS'    => 'My Upcoming Events',
        'MY_EVENT_TYPES'        => 'My Event Types',
        'MY_EVENTS'             => 'My Events',
        'EVENTS_I_AM_NOT_ATTENDING'  => 'Events I\'m Not Attending',
        'YOU_MIGHT_ATTEND'      => 'You might attend.',
        'YOU_ARE_ATTENDING'     => 'You are attending.',
        'YOU_WILL_NOT_ATTEND'   => 'You will not attend.',
        'YOU_HAVE_NOT_RSVPED'   => 'You have not responded.',
        'YOU_ARE_NOT_INVITED'   => 'You are not invited.',
        'USER_EVENTS' 			=> '%s\'s Events',
        'USER_EVENT_TYPES'		=> '%s\'s Event Types',
        'ALL_USER_TYPE_EVENTS' => 'All %1$s %2$s Events',
        'EVENTS_USER_NOT_ATTENDING' => 'Events %s is not attending',
        'ALL_USER_EVENTS_AT'	=> 'All %1$s Events at %2$s',
        'ATTENDING'             => 'Attending',
        'I_AM_ATTENDING'		=> 'I\'m Attending',
        'ALL_MY_EVENTS'			=> 'All My Events',
        'ALL_MY_EVENTS_AT'		=> 'All My Events at %s', // date
        'NOT_ATTENDING'         => 'Not Attending',
        'NOT_YET_RSVP'          => 'Not Yet RSVPed',
        'CHANGE_RSVP'           => 'Change RSVP',
        'YOUR_RSVP'             => 'Your RSVP',
        'YOU_COLON'             => 'You:',
        'ATTEND'                => 'Will attend',           // in form "You: ..."
        'MIGHT_ATTEND'          => 'Might attend',      // in form "You: ..."
        'NOT_ATTEND'            => 'Will not attend',       // in form "You: ..."
        'GUEST_LISTS'           => 'Guest Lists',
        'BACK_TO_EVENT'         => 'Back to Event Details',
        'PRIVATE_GUEST_LIST'    => 'Private Guest List',
        'USER_MADE_EVENT_PRIVATE'=> '%s has made this Event private. Please contact %s for further information.',
        'USER_HID_GUESTS'       => '%s has decided to hide the list of guests.',
        'EDIT_EVENT'            => 'Edit Event',
        'SEND_MSG_TO_GUESTS'    => 'Send Message to Guests',
        'DELETE_EVENT'          => 'Delete Event',
        'ARE_YOU_SURE_DELETE_EVENT' => 'Are you sure that you want to delete this Event?',
        'SEARCH_EVENTS'         => 'Search events',
        'FOR_MORE_VISIT_URL'    => 'For more information visit %s',
        'WELCOME_TO_EVENT_X'    => 'Welcome to %s',
        'EVENT_TYPE_COLON'      => 'Event Type:',
        'STREET_COLON'          => 'Street:',
        'CITY_COLON'            => 'City/Town:',
        'WEBSITE_OR_MAP_COLON'  => 'Website or Map:',
        'CONTACT_INFO_COLON'    => 'Contact Info:',
        'ORGANIZED_BY_COLON'    => 'Organized By:',
        'EXPORT_TO_OUTLOOK'     => 'Export to Outlook or iCal (.ics)',
        'EVENT_IS_FULL'         => 'This event is full. Please contact the Event Organizer for further information.',
        'EVENT_X_IS_HAPPENING_TODAY'	=> '%s is happening today',
        'EVENT_X_IS_HAPPENING_TOMORROW'	=> '%s is happening tomorrow',

        'YOU_ARE_ATTENDING_EVENT'   => 'You are attending %s.',
        'YOU_MIGHT_ATTEND_EVENT'    => 'You might attend %s.',
        'YOU_WONT_ATTEND_EVENT'     => 'You will not attend %s.',
        'NO_EVENTS_TO_DISPLAY'      => 'You are currently displaying no events.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_EVENTS' => 'This box won\'t show up for other people unless you have at least one event.',
        'ALL_EVENT_TYPES'		=> 'All Event Types',
        'ALL_MY_EVENT_TYPES'	=> 'All My Event Types',
        'ALL_USER_EVENT_TYPES'	=> 'All %s\'s Event Types',
        'THERE_ARE_NO_TYPES_YET' => 'There are no Event Types yet',
        'LATEST_EVENTS'         => 'Latest Events',

        'LIST'                  => 'List',
        'SHOW_EVENTS'           => 'event(s)',
        'OPTION_FROM'           => 'From',
        'OPTION_DISPLAY'        => 'Display',
        'OPTION_SHOW'           => 'Show',
        'WHO_CAN_VIEW_EVENTS'	=> 'Who can view your events?',
        'MY_EVENTS_AND_RSVP'	=> 'My events and my RSVPs',
        'NEW_EVENTS'			=> 'New events',

        '_FIRST_WEEKDAY'        => '7',                 // First day of the week. [1-7]. Monday is 1, Sunday is 7.
        'MONDAY'                => 'Monday',
        'TUESDAY'               => 'Tuesday',
        'WEDNESDAY'             => 'Wednesday',
        'THURSDAY'              => 'Thursday',
        'FRIDAY'                => 'Friday',
        'SATURDAY'              => 'Saturday',
        'SUNDAY'                => 'Sunday',
        'JANUARY_SHORT'			=> 'Jan',
        'FEBRUARY_SHORT'		=> 'Feb',
        'MARCH_SHORT'			=> 'Mar',
        'APRIL_SHORT'			=> 'Apr',
        'MAY_SHORT'				=> 'May',
        'JUNE_SHORT'			=> 'Jun',
        'JULY_SHORT'			=> 'Jul',
        'AUGUST_SHORT'			=> 'Aug',
        'SEPTEMBER_SHORT'		=> 'Sep',
        'OCTOBER_SHORT'			=> 'Oct',
        'NOVEMBER_SHORT'		=> 'Nov',
        'DECEMBER_SHORT'		=> 'Dec',

        'MONDAY_SHORT'			=> 'M',
        'TUESDAY_SHORT'			=> 'T',
        'WEDNESDAY_SHORT'		=> 'W',
        'THURSDAY_SHORT'		=> 'T',
        'FRIDAY_SHORT'			=> 'F',
        'SATURDAY_SHORT'		=> 'S',
        'SUNDAY_SHORT'			=> 'S',

        // Notes widget
        'NOTES_TAB_TEXT'				=> 'Notes',
        'NOTES_HOME_NOT_EXISTS'     	=> 'Welcome to Notes.',
        'NOTE_NOT_EXISTS'          		=> 'There is no note for <em>%s</em>.',
        'CREATE_THIS_NOTE'         		=> 'Create This Note',
        'NOTE_ACCESS_DENIED'            => 'Only administrators can read <em>%s</em>.',
        'NO_NOTES_FOUND'           		=> 'No matching notes were found',
        'THERE_ARE_NO_NOTES'       		=> 'There are no notes yet.',
        'THERE_ARE_NO_FEATURED_NOTES'=> 'There are no featured notes.',
        'NOTE_CREATED_UPDATED'     => 'Created by %2$s %1$s. Last updated by %4$s %3$s.', // 1,3 - time; 2,4 - user name
        'MOST_RECENTLY_CREATED'         => 'Most Recently Created',
        'MOST_RECENTLY_UPDATED'         => 'Most Recently Updated',
        'ALPHABETICALLY'                => 'Alphabetically',
        'NOTES'                         => 'Notes',
        'NOTES_HOME'                     => 'Notes Home',
        'OPTION_TITLE'                  => 'Title',
        'SINGLE_NOTE'                   => 'Single note',
        'SHOW_NOTES'               		=> 'note(s)',
        'CREATE_NOTE'              		=> 'Create a Note',
        'ALL_NOTES'                		=> 'All Notes',
        'FEATURED_NOTES'           		=> 'Featured Notes',
        'ADD_NOTE'                 		=> 'Add Note',
        'ALL_NOTES_CREATED_BY_USER'=> '%1$s\'s Notes (%2$d)',
        'USER_X_HAS_NO_NOTES'           => '%s hasn\'t created any notes yet.',
        'SEARCH_NOTES'             		=> 'Search',
        'ENTER_NOTE_TITLE'              => 'What do you want to call the note?',
        'DELETE_NOTE'              		=> 'Delete note',
        'ARE_YOU_SURE_DELETE_NOTE' 		=> 'Are you sure that you want to delete this note?',
        'EDIT_NOTE'                		=> 'Edit Note',
        'NOTE_EXISTS'              => 'Note <em>%s</em> that you want to create already exists. Do you want to edit it?',
        'RECENTLY_UPDATED'              => 'Recently Updated',
        'NO_NOTES_TO_DISPLAY'      => 'You are currently displaying no notes.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_NOTES' => 'This box won\'t show up for other people unless you select at least one existing note.',
        'CANNOT_SAVE_NOTE'			=> 'Cannot save note',
        'SAVE_NOTE'					=> 'Save Note',
        'NOTE_LOCKED'				=> 'Note is locked. Please try again later',
        'NOTE_TOO_LONG'			=> 'Note is too long. Maximum length is 100 Kb.',
        'NOTE_DATE'						=> 'M j, Y \\a\\t g:ia',

        'RICH_TEXT' => 'Rich Text',
        'SOURCE' => 'Source',
        'DISCARD' => 'Discard',

        'ENTER_THE_NOTE_TITLE' => 'Enter the title of the note to link to:',
        'ENTER_A_LINK_URL' => 'Enter a link URL:',

        'NOTE_HAS_BEEN_CHANGED'			=> 'Note has been changed',
        'YOU_ENTERED_INVALID_CHAR' => 'You entered an invalid character. Invalid characters are < > [ ] | { } #. Please try again.',

        'YOU_MUST_BE_ADMIN'				=> 'You must be Admin',
        'BAD_REQUEST'					=> 'Wrong request',
        'NOTE_TITLE_TOO_LONG'		=> 'Note title is too long',
        'NOTE_HAS_BEEN_SAVED'		=> 'Note has been updated on %1$s.',
        'NOTE_HAS_BEEN_UPDATED' 	=> 'This note has been updated by %1$s at %2$s (%3$s).
<ul>
    <li><b>Save</b> your changes, and overwrite the updates made by %1$s</li>
    <li><b>Discard</b> your changes and return to the note page</li>
    <li><b>Cancel</b> and return to the note editor to continue editing without saving</li>
</ul>',
        'NOTE_HAS_BEEN_DELETED' 	=> 'This note has been deleted.
<ul>
    <li><b>Save</b> your note, which will re-create "%1$s"</li>
    <li><b>Discard</b> your changes, and leave the note deleted</li>
    <li><b>Cancel</b> and return to the note editor to continue editing without saving</li>
</ul>',
        'NOTES_QUICK_HELP' 			=> 'Add text, some HTML, videos, photos, or any third-party widgets to this Note',

        'TOGGLE_BOLD'				=> 'Toggle Bold',
        'TOGGLE_ITALIC'				=> 'Toggle Italic',
        'TOGGLE_UNDERLINE'			=> 'Toggle Underline',
        'JUSTIFY_LEFT'				=> 'Justify Left',
        'JUSTIFY_CENTER'			=> 'Justify Center',
        'JUSTIFY_RIGHT'				=> 'Justify Right',
        'TOGGLE_STRIKETHROUGH'		=> 'Toggle Strikethrough',
        'INDENT_LEFT'				=> 'Indent Left',
        'INDENT_RIGHT'				=> 'Indent Right',
        'INSERT_HR'					=> 'Insert Horizontal Rule',
        'INSERT_OL'					=> 'Insert Ordered List',
        'INSERT_UL'					=> 'Insert Unordered List',
        'INSERT_IMAGE'				=> 'Insert Image',
        'CREATE_NOTELINK'			=> 'Create Link to Note',
        'CREATE_LINK'				=> 'Create Link',
        'REMOVE_LINK'				=> 'Remove Link',
        'REMOVE_FORMATTING'			=> 'Remove Formatting',
        'SIZE'						=> 'Size',
        'XXSMALL'					=> 'XX-Small',
        'XSMALL'					=> 'X-Small',
        'SMALL'						=> 'Small',
        'MEDIUM'					=> 'Medium',
        'LARGE'						=> 'Large',
        'XLARGE'					=> 'X-Large',
        'XXLARGE'					=> 'XX-Large',
        'FONT'						=> 'Font',
    );

  /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     *
     * @deprecated  Use XG_LanguageHelper::translateDefaultWidgetTitle instead
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {
        return $widgetTitle;
    }

  /**
   * Returns the value of the $messages variable, for unit testing.
   *
   * @return array  message-name => message
   */
  public static function getMessagesForTesting() {
      return self::$messages;
  }

    /**
     * Returns an array of XN_Profile country-codes.
     *
     * @return array  the country codes, e.g., AU
     */
    public static function countryCodes() {
        $countryCodes = array();
        foreach (self::$messages as $name => $message) {
            if (mb_strpos($name, 'COUNTRY_') === 0 && mb_strlen($name) == 10) {
                $countryCodes[] = mb_substr($name, -2);
            }
        }
        return $countryCodes;
    }

}
