<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the Greek
 */
class XG_MessageCatalog_el_GR extends XG_AbstractMessageCatalog {


    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param array $args the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = 'Πριν από 1 δευτερόλεπτο ';
            $a['N_SECONDS_AGO']['n'] = 'Πριν από %s δευτερόλεπτα ';
            $a['N_MINUTES_AGO']['1'] = 'Πριν από 1 λεπτό ';
            $a['N_MINUTES_AGO']['n'] = 'Πριν από %s λεπτά ';
            $a['N_HOURS_AGO']['1'] = 'Πριν από 1 ώρα ';
            $a['N_HOURS_AGO']['n'] = 'Πριν από %s ώρες ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> βίντεο ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> βίντεο ';
            $a['N_VIEWS']['1'] = '1 προβολή ';
            $a['N_VIEWS']['n'] = '%s προβολές ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> σχόλιο ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> σχόλια ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Αυτό το βίντεο είναι το <strong>αγαπημένο</strong> <strong>1 ατόμου</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Αυτό το βίντεο είναι το <strong>αγαπημένο</strong> <strong>%s ατόμων</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = 'Ο/Η %2$s πρόσθεσε ένα βίντεο: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = 'Ο/Η %2$s πρόσθεσε %s βίντεο. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Προσθέσατε ένα βίντεο: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Προσθέσατε %s βίντεο. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Υπάρχει 1 βίντεο στο %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Υπάρχουν %1$s βίντεο στο %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Υπάρχει 1 <a href="%3$s">βίντεο</a> στο %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Υπάρχουν %1$s <a href="%3$s">βίντεο</a> στο %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 φωτογραφία από αυτό το άλμπουμ έχει διαγραφεί ή έχει γίνει ιδιωτική και έτσι δεν είναι δυνατή η εμφάνισή της. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s φωτογραφίες από αυτό το άλμπουμ έχουν διαγραφεί ή έχουν γίνει ιδιωτικές και έτσι δεν είναι δυνατή η εμφάνισή τους. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> φωτογραφία ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> φωτογραφίες ';
            $a['N_PHOTOS_2']['1'] = '1 φωτογραφία ';
            $a['N_PHOTOS_2']['n'] = '%s φωτογραφίες ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Παρουσιάστηκε πρόβλημα στην αποστολή του παρακάτω αρχείου: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Παρουσιάστηκε πρόβλημα στην αποστολή των παρακάτω αρχείων: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Αυτή η φωτογραφία είναι η <strong>αγαπημένη</strong> <strong>1 ατόμου</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Αυτή η φωτογραφία είναι η <strong>αγαπημένη</strong> <strong>%s ατόμων</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Αξιολόγηση:</strong> %2$s μετά από 1 ψήφο ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Αξιολόγηση:</strong> %2$s μετά από %s ψήφους ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s μετά από 1 ψήφο ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s μετά από %s ψήφους ';
            $a['N_PEOPLE']['1'] = '1 άτομο ';
            $a['N_PEOPLE']['n'] = '%s άτομα ';
            $a['N_OF_5_STARS']['1'] = '1/5 αστέρι ';
            $a['N_OF_5_STARS']['n'] = '%s/5 αστέρια ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Η αξιολόγησή σας: 1 αστέρι ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Η αξιολόγησή σας: %s αστέρια ';
            $a['Y_ADDED_X_PHOTOS']['1'] = 'Ο/Η %2$s πρόσθεσε μια φωτογραφία: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = 'Ο/Η %2$s πρόσθεσε %s φωτογραφίες. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Προσθέσατε μια φωτογραφία: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Προσθέσατε %s φωτογραφίες. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Υπάρχει 1 φωτογραφία στο %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Υπάρχουν %1$s φωτογραφίες στο %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Υπάρχει %1$s <a href="%3$s">φωτογραφία</a> στο %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Υπάρχουν %1$s <a href="%3$s">φωτογραφίες</a> στο %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = 'Έχει σταλεί πάλι 1 πρόσκληση. ';
            $a['N_INVITATIONS_RESENT']['n'] = 'Έχουν σταλεί πάλι %s προσκλήσεις. ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'και 1 άλλο άτομο ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'και %s άλλα άτομα ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> σχόλιο στο προφίλ ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> σχόλια στο προφίλ ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> σχόλια στο ιστολόγιο ';
            $a['N_YEARS_OLD']['1'] = '1 έτους ';
            $a['N_YEARS_OLD']['n'] = '%s ετών ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Έχετε 1 αίτηση φίλου! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Έχετε %s αιτήσεις φίλων! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Πίνακας σχολίων (1 σχόλιο) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Πίνακας σχολίων (%s σχόλια) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 νέο μέλος απέκτησε συμμετοχή μέσα στην τελευταία εβδομάδα ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s νέα μέλη απέκτησαν συμμετοχή μέσα στην τελευταία εβδομάδα ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">νέο μέλος</a> απέκτησε συμμετοχή μέσα στην τελευταία εβδομάδα ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">νέα μέλη</a> απέκτησαν συμμετοχή μέσα στην τελευταία εβδομάδα ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Υπάρχει 1 μέλος στο %2$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Υπάρχουν %1$s μέλη στο %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Υπάρχει 1 <a href="%3$s">μέλος</a> στο %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Υπάρχουν %1$s <a href="%3$s">μέλη</a> στο %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Υπάρχει 1 καταχώρηση ιστολογίου στο %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Υπάρχουν %1$s καταχωρήσεις ιστολογίου στο %2$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> νέο μέλος ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> νέα μέλη ';
            $a['N_REPLIES']['1'] = '1 απάντηση ';
            $a['N_REPLIES']['n'] = '%s απαντήσεις ';
            $a['N_MINUTES']['1'] = 'Απομένει 1 λεπτό για να επεξεργαστείτε το σχόλιό σας. ';
            $a['N_MINUTES']['n'] = 'Απομένουν %s λεπτά για να επεξεργαστείτε το σχόλιό σας. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Υπάρχει 1 θέμα φόρουμ στο %2$s ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Υπάρχουν %1$s θέματα φόρουμ στο %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Υπάρχει 1 <a href="%3$s">θέμα φόρουμ</a> στο %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Υπάρχουν %1$s <a href="%3$s">θέματα φόρουμ</a> στο %2$s ';
            $a['N_INVITES']['1'] = '%s πρόσκληση ';
            $a['N_INVITES']['n'] = '%s προσκλήσεις ';
            $a['N_MEMBERS']['1'] = '1 μέλος ';
            $a['N_MEMBERS']['n'] = '%s μέλη ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 μέλος) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s μέλη) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Υπάρχει 1 ομάδα στο %2$s ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Υπάρχουν %1$s ομάδες στο %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Υπάρχει %1$s <a href="%3$s">ομάδα</a> στο %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Υπάρχουν %1$s <a href="%3$s">ομάδες</a> στο %2$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 τραγούδι από αυτή τη λίστα αναπαραγωγής δεν είναι δυνατό να εμφανιστεί επειδή έχει διαγραφεί ή δεν είναι πια κοινόχρηστο. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s τραγούδια από αυτή τη λίστα αναπαραγωγής δεν είναι δυνατό να εμφανιστούν επειδή έχουν διαγραφεί ή δεν είναι πια κοινόχρηστα. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Ένα νέο τραγούδι έχει προστεθεί στο %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s νέα τραγούδια έχουν προστεθεί στο %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = 'Ο/Η %2$s πρόσθεσε ένα τραγούδι: ';
            $a['Y_ADDED_X_SONGS']['n'] = 'Ο/Η %2$s πρόσθεσε %s τραγούδια. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Προσθέσατε ένα τραγούδι: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Προσθέσατε %s τραγούδια. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 τραγούδι προστέθηκε στη λίστα αναπαραγωγής. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s τραγούδια προστέθηκαν στη λίστα αναπαραγωγής. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Υπάρχει 1 τραγούδι στο %2$s ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Υπάρχουν %1$s τραγούδια στο %2$s ';
        }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Αναζήτηση',
        'MORE_VIDEOS' => 'Περισσότερα βίντεο',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Αυτό το δίκτυο δεν έχει ακόμα βίντεο.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Αυτό το δίκτυο δεν έχει ακόμα προβεβλημένο βίντεο.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Αυτό το άτομο δεν έχει ακόμα βίντεο.',
        'COPY_TO_CLIPBOARD' => 'Αντιγραφή στο πρόχειρο',
        'COPIED_TO_CLIPBOARD' => 'Έγινε αντιγραφή στο πρόχειρο!',
        'NO_VIDEOS_TO_DISPLAY' => 'Προς το παρόν, δεν εμφανίζετε κανένα βίντεο.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί για άλλα άτομα εκτός και αν επιλέξετε τουλάχιστον ένα βίντεο.',
        'WATERMARK_LOGO' => 'Λογότυπο υδατογραφήματος',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Μπορείτε να επιλέξετε μια κεφαλίδα ή ένα λογότυπο υδατογραφήματος για το πρόγραμμα αναπαραγωγής βίντεο.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Το λογότυπο εμφανίζεται στο πάνω μέρος του %s.  Αν δεν προσθέσετε λογότυπο, στη θέση του θα εμφανιστεί το όνομα δικτύου.  Το λογότυπό σας πρέπει να είναι σε μορφή . jpg, . gif ή . png.  Το μέγεθος των λογοτύπων με ύψος μεγαλύτερο από 20 pixel θα προσαρμοστεί ανάλογα.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'Το λογότυπο υδατογραφήματος εμφανίζεται πάνω από την κάτω δεξιά γωνία του βίντεο κλιπ.',
        'HEADER_LOGO' => 'Λογότυπο κεφαλίδας',
        'WATERMARK' => 'Υδατογράφημα',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Προσαρμόστε το πρόγραμμα αναπαραγωγής βίντεο!',
        'VIDEO_PLAYER' => 'Πρόγραμμα αναπαραγωγής βίντεο',
        'HEADER' => 'Κεφαλίδα',
        'SAVE_CHANGES' => 'Αποθήκευση αλλαγών',
        'THUMBNAIL' => 'Μικρογραφία',
        'CONVERSION_FAILED' => 'Η μετατροπή απέτυχε',
        'CONVERSION_IN_PROGRESS' => 'Μετατροπή σε εξέλιξη',
        'MAP' => 'Αντιστοίχιση',
        'WHAT_IS_THIS' => 'Τι είναι αυτό;',
        'EDIT_VIDEO_INFORMATION' => 'Επεξεργασία πληροφοριών βίντεο',
        'ALL_VIDEOS' => 'Όλα τα βίντεο',
        'VIDEOS_HOME' => 'Αρχική σελίδα βίντεο',
        'MY_VIDEOS' => 'Τα βίντεό μου',
        'MY_FRIENDS_VIDEOS' => 'Τα βίντεο των φίλων μου',
        'MY_FAVORITES' => 'Τα αγαπημένα μου',
        'XS_FAVORITES' => 'Αγαπημένα του/της %s',
        'ADD_A_VIDEO' => 'Προσθήκη βίντεο',
        'JUST_NOW' => 'μόλις τώρα',
        '1_DAY_AGO' => 'Πριν από 1 μέρα',
        'M_J' => 'M j',
        'ME' => 'εμένα',
        'X_SAID' => 'Ο/Η %s είπε...',
        'DELETE_COMMENT' => 'Διαγραφή σχολίου',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Δεν έχετε προσθέσει ακόμα βίντεο!',
        'ADD_VIDEOS_AND_SHARE' => 'Προσθέστε βίντεο και μοιραστείτε τα με τους φίλους, τους συγγενείς σας ή τον υπόλοιπο κόσμο!',
        'THERE_ARE_NO_VIDEOS' => 'Προς το παρόν, δεν υπάρχουν βίντεο στο κοινωνικό σας δίκτυο.',
        'THIS_BOX_WILL_NOT_SHOW' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί για άλλα άτομα εκτός και αν υπάρχουν βίντεο προς προβολή.  Γιατί δεν προσθέτετε ένα;',
        'ADD_VIDEOS' => 'Προσθήκη βίντεο',
        'VIEW_VIDEOS' => 'Προβολή βίντεο',
        'YIKES' => 'Ωχ!',
        'A_PROBLEM_SEEMS' => 'Φαίνεται ότι παρουσιάστηκε πρόβλημα.',
        'FOR_FURTHER_ASSISTANCE' => 'Για περισσότερη βοήθεια, <a %s>επικοινωνήστε μαζί μας</a>.',
        'OR_YOU_CAN_GO' => 'Ή, μπορείτε να επιστρέψετε στην <a %s>αρχική σελίδα %s</a> ή να αναζητήσετε <a %s>άλλα κοινωνικά δίκτυα Ning</a>',
        'TAGS' => 'Ετικέτες;',
        'POPULAR_TAGS' => 'Δημοφιλείς ετικέτες',
        'MY_FRIENDS' => 'Οι φίλοι μου',
        'VIEW_ALL_MY_FRIENDS' => 'Προβολή όλων των φίλων μου',
        'VIEW_ALL_XS_FRIENDS' => 'Προβολή όλων των φίλων του/της %s',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Λυπούμαστε, αλλά δεν μπορούμε να βρούμε κάποιο άτομο που να ταιριάζει στην αναζήτησή σας.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Προβολή δημοφιλών συμβαλλόντων',
        'POPULAR_CONTRIBUTORS' => 'Δημοφιλείς συμβάλλοντες',
        'VIEW_MORE_CONTRIBUTORS' => 'Προβολή περισσότερων συμβαλλόντων',
        'ADD_AS_FRIEND' => 'Προσθήκη ως φίλος',
        'SEND_A_MESSAGE' => 'Αποστολή μηνύματος',
        'IS_YOUR_FRIEND' => 'Είναι ο φίλος σας',
        'IS_BLOCKED' => 'Είναι αποκλεισμένος',
        'SORT_BY' => 'Ταξινόμηση κατά:',
        'CLOSE' => 'Κλείσιμο',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Κανένας δεν έχει προσθέσει βίντεο ακόμα!  Προσθέστε μερικά βίντεο για να ξεκινήσετε.',
        'SEARCH_PEOPLE' => 'Αναζήτηση ατόμων:',
        'INVITE_YOUR_FRIENDS_TO' => 'Προσκαλέστε τους φίλους σας στο %s.',
        'INVITE' => 'Πρόσκληση',
        'INVITE_TAB_TEXT' => 'Πρόσκληση',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Δεν έχετε προσθέσει ακόμα φίλους στο %s.',
        'SEARCH_FRIENDS' => 'Αναζήτηση φίλων:',
        'ADD_YOUR_FIRST_VIDEO' => 'Προσθήκη του πρώτου σας βίντεο',
        'USE_HTML_EMBED_CODE' => 'Χρήση ενσωματωμένου κώδικα HTML',
        'UPLOAD_A_VIDEO_FROM' => 'Αποστείλετε ένα βίντεο από τον υπολογιστή σας. Αποδεχόμαστε όλες τις ευρέως γνωστές μορφές!',
        'WE_SUPPORT_MOV' => 'Υποστηρίζουμε τις μορφές αρχείων .mov, .mpg, .avi, .3gp και .wmv. Τα αρχεία πρέπει να είναι μεγέθους 100 ΜΒ ή μικρότερα.',
        'NEED_HELP_HERE_ARE' => 'Χρειάζεστε βοήθεια;  Δείτε τις οδηγίες για το <a %s>YouTube</a> και το <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Προσθήκη τίτλου και περιγραφής',
        'DESCRIPTION_COLON' => 'Περιγραφή:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Προσθέστε τίτλο, περιγραφή και άλλες πληροφορίες στο βίντεο που έχετε αποστείλει.',
        'EVERYTHING_IS_OPTIONAL' => 'Όλα είναι προαιρετικά.  Εάν δεν θέλετε να προσθέστε κάτι, απλώς κάντε κλικ στο "Παράλειψη αυτού του βήματος" στα δεξιά.',
        'SKIP_THIS_STEP' => 'Παράλειψη αυτού του βήματος',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Προσθέστε τίτλο, περιγραφή και άλλες πληροφορίες για το βίντεο.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Ακύρωση και επιστροφή στο βίντεο',
        'TITLE' => 'Τίτλος:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Οι ετικέτες είναι σύντομες περιγραφές για να μπορείτε να βρίσκετε τα βίντεό σας.  Διαχωρίστε τις ετικέτες με κόμμα ή τοποθετήστε πολυλεκτικές ετικέτες μεταξύ εισαγωγικών, π.χ. "Σαν Φρανσίσκο".',
        'WHO_CAN_VIEW_VIDEO' => 'Ποιος μπορεί να προβάλει αυτό το βίντεο;',
        'MOST_POPULAR' => 'Πιο δημοφιλές',
        'HIGHEST_RATED' => 'Με την υψηλότερη αξιολόγηση',
        'MOST_RECENT' => 'Πιο πρόσφατο',
        'MOST_FAVORITED' => 'Πιο αγαπημένο',
        'MOST_POPULAR_VIDEOS' => 'Τα πιο δημοφιλή βίντεο',
        'HIGHEST_RATED_VIDEOS' => 'Βίντεο με την υψηλότερη αξιολόγηση',
        'MOST_RECENT_VIDEOS' => 'Πιο πρόσφατα βίντεο',
        'MOST_FAVORITED_VIDEOS' => 'Πιο αγαπημένα βίντεο',
        'ANYONE' => 'Οποιοσδήποτε',
        'JUST_MY_FRIENDS' => 'Μόνο οι φίλοι μου',
        'JUST_ME' => 'Μόνο εγώ',
        'VIEWABLE_BY_FRIENDS' => 'Δυνατότητα προβολής από <strong>φίλους</strong>',
        'PRIVATE_VIDEO' => '<strong>Ιδιωτικό</strong> βίντεο',
        'VIEWABLE_BY_EVERYONE' => 'Δυνατότητα προβολής από <strong>όλους</strong>',
        'LOCATION' => 'Θέση:',
        'NO_LOCATION' => 'Καμία θέση',
        'CLICK_ON_LOCATION' => 'Κάντε κλικ σε μία θέση στην αντιστοίχιση:',
        'FIND_AN_ADDRESS' => 'Εύρεση διεύθυνσης:',
        'LOCATE' => 'Εντοπισμός',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Μπορείτε να <a %s>προσθέσετε το δικό σας βίντεο</a> στο %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Προσθέστε ένα λογότυπο ή μια εικόνα υδατογραφήματος στο πρόγραμμα αναπαραγωγής βίντεο του δικτύου σας.  <a %s>Εγκαταστήστε το τώρα! </a>',
        'APPROVE' => 'Έγκριση',
        'DELETE' => 'Διαγραφή',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Εφαρμογή σε όλα τα βίντεο που προστέθηκαν από τον/την %s',
        'NO_TITLE' => 'Χωρίς τίτλο',
        'ADDED_BY_STRONG_X' => 'Προστέθηκε από <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Χωρίς περιγραφή',
        'BY_X' => 'από %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Τελειώσατε τον συντονισμό',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Προς το παρόν, δεν υπάρχουν βίντεο σε αναμονή έγκρισης.  Εάν ψάχνετε να βρείτε κάτι να κάνετε, γιατί δεν ρίχνετε μια ματιά στα <a %s>τελευταία βίντεο</a>;',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Κανένας δεν έχει προσθέσει βίντεο στο κοινωνικό σας δίκτυο.  Γίνεται ο πρώτος που θα προσθέσει ένα βίντεο!',
        'ADDED_ON_DATE_BY_X' => 'Προστέθηκε %s από %s.',
        'REMOVE_FROM_FAVORITES' => 'Κατάργηση από τα Αγαπημένα',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Κατάργηση αυτού του βίντεο από τα αγαπημένα σας;',
        'COLLECTED_BY_X' => 'Συλλέχθηκε από %s',
        'ADD_FAVORITES' => 'Προσθήκη αγαπημένων',
        'YOU_CAN_MARK_VIDEO' => 'Μπορείτε να επισημάνετε οποιοδήποτε βίντεο ως αγαπημένο.  Απλώς κάντε κλικ στο εικονίδιο "Προσθήκη στα Αγαπημένα" όταν το δείτε σε βίντεο.',
        'VIEW_RECENT_VIDEOS' => 'Προβολή πρόσφατων βίντεο',
        'X_HAS_NOT_ADDED_FAVORITES' => 'Ο/Η %s δεν έχει προσθέσει ακόμα αγαπημένα.',
        'APPROVE_VIDEOS' => 'Έγκριση βίντεο',
        'YOUR_SITE_REQUIRES_YOU' => 'Έχετε ζητήσει τον συντονισμό φωτογραφιών και βίντεο στο κοινωνικό σας δίκτυο πριν από την καταχώρησή τους.  Για να αλλάξετε αυτή τη ρύθμιση, <a %s>κάντε κλικ εδώ για να μεταβείτε στη σελίδα Απορρήτου</a> και απενεργοποιήστε την επιλογή \'Έγκριση νέων φωτογραφιών και βίντεο\'.',
        'YOUR_SITE_ALLOWS_USERS' => 'Έχετε ζητήσει να μην συντονίσετε φωτογραφίες και βίντεο στο κοινωνικό σας δίκτυο πριν από την καταχώρησή τους.  Για να αλλάξετε αυτή τη ρύθμιση, <a %s>κάντε κλικ εδώ για να μεταβείτε στη σελίδα Απορρήτου</a> και ενεργοποιήστε την επιλογή \'Έγκριση νέων φωτογραφιών και βίντεο\'.',
        'APPROVE_ALL_VIDEOS' => 'Έγκριση όλων των βίντεο;',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Είστε σίγουροι ότι θέλετε να εγκρίνετε όλα τα βίντεο;  Αυτή η διαδικασία ίσως να διαρκέσει μερικά λεπτά.',
        'APPROVING' => 'Γίνεται έγκριση...',
        'APPROVE_ALL' => 'Έγκριση όλων',
        'DELETE_ALL_VIDEOS' => 'Διαγραφή όλων των βίντεο;',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Είστε σίγουροι ότι θέλετε να διαγράψετε όλα τα μη εγκεκριμένα βίντεο;  Αυτή η διαδικασία ίσως να διαρκέσει μερικά λεπτά.',
        'DELETING' => 'Γίνεται διαγραφή...',
        'DELETE_ALL' => 'Διαγραφή όλων',
        'XS_VIDEOS' => 'Βίντεο του/της %s',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Να γίνει διαγραφή όλων των βίντεο του/της %s;',
        'DELETE_ALL_XS_VIDEOS' => 'Διαγραφή όλων των βίντεο του/της %s',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Είστε σίγουροι ότι θέλετε να διαγράψετε όλα τα βίντεο του/της %s;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'DELETE_THIS_VIDEO_Q' => 'Να γίνει διαγραφή του βίντεο;',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Είστε σίγουροι ότι θέλετε να διαγράψετε αυτό το βίντεο;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Δεν έχετε προσθέσει ακόμα βίντεο.  Προσθέστε μερικά βίντεο για να ξεκινήσετε!',
        'X_HAS_NOT_ADDED_VIDEOS' => 'Ο/Η %s δεν έχει προσθέσει ακόμα βίντεο.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Οι φίλοι σας δεν έχουν ακόμα βίντεο.',
        'ALL_VIDEOS_TAGGED_X' => 'Όλα τα βίντεο με ετικέτα \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Όλα τα βίντεο με ετικέτα <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'Δεν υπάρχουν βίντεο με ετικέτα "%1$s".  Δείτε τις <a %2$s>συζητήσεις με ετικέτα "%1$s"</a> ή τις <a %3$s>φωτογραφίες με ετικέτα "%1$s"</a>.  Ή προσθέστε και τοποθετήστε ετικέτα στα δικά σας βίντεο!',
        'FILES_MUST_BE_100MB' => 'Τα αρχεία πρέπει να είναι 100 MB ή μικρότερα.  Υποστηρίζουμε μορφές αρχείων . mov, . mpg, . avi, . 3gp και . wmv.',
        'NEED_HELP' => 'Χρειάζεστε βοήθεια;',
        'HERE_ARE_INSTRUCTIONS' => 'Δείτε τις οδηγίες για το <a %s>YouTube</a> και το <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'Το άτομο που είναι υπεύθυνο για το %s, θέλει να δει την δουλειά σας πριν από την παρουσίασή της στον κόσμο.',
        'LEAVE_WINDOW_OPEN' => 'Αφήστε αυτό το παράθυρο ανοικτό όσο ολοκληρώνεται η διαδικασία αποστολής.',
        'KEEP_PAGE_OPEN' => 'Αφήστε αυτή τη σελίδα ανοικτή έτσι ώστε να μπορέσουμε να ολοκληρώσουμε την αποστολή του βίντεό σας και θα σας ενημερώσουμε όταν εγκριθεί!',
        'MEANWHILE_FEEL_FREE' => 'Στο μεταξύ, μπορείτε να <a %s>ανοίξετε ένα νέο παράθυρο στο πρόγραμμα περιήγησης</a> και να συνεχίσετε τη χρήση του %s.  Όταν η αποστολή ολοκληρωθεί, θα μπορέσετε να προσθέσετε έναν τίτλο και μια περιγραφή στο βίντεό σας σε αυτό το παράθυρο.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Αυτό το βίντεο είναι σε <strong>αναμονή για έγκριση</strong> από το δημιουργό του %s\\.',
        'LOADING' => 'Γίνεται φόρτωση...',
        'EDIT_VIDEO' => 'Επεξεργασία βίντεο',
        'DELETE_VIDEO' => 'Διαγραφή βίντεο',
        'YOU_NEED_TO_BE_MEMBER' => 'Πρέπει να είστε μέλος του %s για να προσθέσετε σχόλια!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Γίνετε μέλος αυτού του δικτύου</a>',
        'ADD_A_COMMENT' => 'Προσθήκη σχολίου',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Αφήστε σχόλιο για %s',
        'MORE' => 'Περισσότερα',
        'PREVIOUS' => 'Προηγούμενο',
        'NEXT' => 'Επόμενο',
        'ABOUT_THIS_VIDEO' => 'Πληροφορίες για το βίντεο',
        'ABOUT_YOUR_VIDEO' => 'Πληροφορίες για το βίντεο',
        'ADDED_ON_DATE_BY' => 'Προστέθηκε <strong>%s</strong> από:',
        'VIEWS' => 'Προβολές:',
        'COMMENTS' => 'Σχόλια',
        'COMMENTS_COLON' => 'Σχόλια:',
        'LOCATION_OF_VIDEO' => 'Θέση του βίντεο:',
        'RELATED_VIDEOS' => 'Σχετικά βίντεο',
        'ALL_VIDEOS_TAGGED_X_X' => 'Όλα τα βίντεο με ετικέτα %s (%s)',
        'XS_VIDEOS_X' => 'Βίντεο του/της %s (%s)',
        'XS_FAVORITES_X' => 'Αγαπημένα του/της %s (%s)',
        'VIDEO_DETAILS' => 'Λεπτομέρειες βίντεο',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Δεν έχει καθοριστεί ούτε αρχείο ούτε ενσωματωμένος κώδικας.',
        'VIDEO_UPLOADED_ON_X' => 'Έγινε αποστολή βίντεο στο %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Παρουσιάστηκε πρόβλημα κατά τη μετατροπή του βίντεο σε μορφή Flash: %s',
        'STATUS_N' => 'Κατάσταση %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Δεν ήταν δυνατή η προσθήκη του βίντεό σας με τίτλο "%s" στο %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Δεν ήταν δυνατή η προσθήκη του βίντεό σας στο %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Μόλις προσπαθήσατε να στείλετε ένα βίντεο στο %s.  Δυστυχώς, δεν είστε μέλος του %s και δεν μπορούμε να παραδώσουμε αυτό το βίντεο.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Η αποστολή του βίντεό σας στο %s δεν ολοκληρώθηκε.',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'η αποστολή του βίντεό σας δεν ολοκληρώθηκε στο %s.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Παρουσιάστηκε πρόβλημα κατά την αποστολή του βίντεό σας στο %s',
        'THE_PROBLEM_WAS_X' => 'Το πρόβλημα ήταν: %s',
        'FOR_FURTHER_ASSISTANCE_2' => 'Για περαιτέρω βοήθεια, επισκεφτείτε:',
        'ID' => 'Αναγνωριστικό:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Η μετατροπή απέτυχε για το βίντεο %s στο %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => 'Ο %s απέστειλε ένα βίντεο του οποίου η μετατροπή απέτυχε.',
        'ERROR_MESSAGE' => 'Μήνυμα σφάλματος:',
        'APPLICATION_NAME' => 'Όνομα εφαρμογής:',
        'APPLICATION_ID' => 'Αναγνωριστικό εφαρμογής:',
        'VIDEO_ID' => 'Αναγνωριστικό βίντεο:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Ολοκληρώθηκε η αποστολή του βίντεό σας στο %s',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'ολοκληρώθηκε η αποστολή του βίντεό σας στο %s',
        'YOUR_VIDEO_WAS_UPLOADED' => 'Το βίντεό σας απεστάλη με επιτυχία στο %s!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Αυτό το βίντεο είναι σε αναμονή για έγκριση.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Συνεχίζεται η επεξεργασία αυτού του βίντεο.',
        'ADD_VIDEO' => 'Προσθήκη βίντεο',
        'VIDEO_BY_X' => 'Βίντεο από %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'Υπάρχει νέο σχόλιο για το βίντεό σας "%s" στο %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'Υπάρχει νέο σχόλιο για ένα από τα βίντεό σας στο %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'κάποιος σχολίασε ένα βίντεο που έχετε προσθέσει στο %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'κάποιος απέστειλε ένα βίντεο στο %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Περισσότεροι τρόποι προσθήκης βίντεο...',
        'FROM_YOUTUBE_OR_GOOGLE' => '...από το YouTube ή το Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Μπορείτε να πάρετε τον \'ενσωματωμένο\' κώδικα HTML από οποιαδήποτε τοποθεσία δημοφιλών βίντεο και να προσθέσετε το βίντεο σε αυτό το κοινωνικό δίκτυο.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Προσθήκη βίντεο από το YouTube ή το Google',
        'PASTE_IN_EMBED' => 'Επικολλήστε εδώ τον \'ενσωματωμένο\' κώδικα για το βίντεο:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Προσθήκη βίντεο μέσω τηλεφώνου ή ηλεκτρονικού ταχυδρομείου',
        'VIDEO' => 'βίντεο',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Δεν υπάρχουν βίντεο τα οποία ταιριάζουν με τις ρυθμίσεις που έχετε επιλέξει.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Κάντε κλικ στο \'Επεξεργασία\' και αλλάξτε τις ρυθμίσεις εάν θέλετε αυτό το πλαίσιο να εμφανίζεται και για άλλα άτομα.',
        'PLAY_AGAIN' => 'Επανάληψη αναπαραγωγής',
        'SHARE' => 'Κοινή χρήση',
        'EMBED' => 'Ενσωμάτωση',
        'REWIND' => 'Επαναφορά',
        'CHANGE_SIZE' => 'Αλλαγή μεγέθους',
        'FULLSCREEN' => 'πλήρης οθόνη',
        'EXIT_FULLSCREEN' => 'Έξοδος από τη λειτουργία πλήρους οθόνης',
        'HIDE' => 'Κλείσιμο',
        'COPY_AND_PASTE_LINK' => 'Αντιγράψτε και επικολλήστε αυτή τη σύνδεση σε ένα μήνυμα ηλεκτρονικού ταχυδρομείου ή άμεσο μήνυμα:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Βρείτε περισσότερα βίντεο σαν αυτό στο <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Δείτε αυτό το βίντεο στο %s',
        'GET_EMBED_CODE' => 'Λήψη ενσωματωμένου κώδικα',
        'MORE_PHOTOS' => 'Περισσότερες φωτογραφίες',
        'THIS_ALBUM' => 'Αυτό το άλμπουμ',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Αυτό το δίκτυο δεν έχει ακόμα φωτογραφίες.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Αυτό το άτομο δεν έχει ακόμα φωτογραφίες.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Αυτό το άλμπουμ δεν έχει ακόμα φωτογραφίες.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Βρείτε περισσότερες φωτογραφίες σαν αυτή στο <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'Προς το παρόν, δεν υπάρχουν διαθέσιμες φωτογραφίες σε αυτό το άλμπουμ.  <a %s>Κάντε κλικ εδώ για να δείτε όλα τα άλμπουμ</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Αυτό το άλμπουμ δεν είναι ορατό σε άλλα άτομα του δικτύου επειδή οι φωτογραφίες του είναι ορατές μόνο σε εσάς ή επειδή πρέπει πρώτα να εγκριθούν.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Προσαρμόστε το πρόγραμμα αναπαραγωγής της προβολής παρουσίασης!',
        'ADD_SLIDESHOW_LOGO' => 'Προσθέστε ένα λογότυπο στην προβολή παρουσίασης του κοινωνικού δικτύου σας.  <a %s>Εγκαταστήστε το τώρα! </a>',
        'PHOTO_BY_X' => 'Φωτογραφία από %s',
        'UPLOAD_PHOTOS' => 'Αποστολή φωτογραφιών',
        'PLAYER_COLOR' => 'Χρώμα προγράμματος αναπαραγωγής',
        'SLIDESHOW_PLAYER' => 'πρόγραμμα αναπαραγωγής προβολής παρουσίασης',
        'SLIDESHOW' => 'προβολή παρουσίασης',
        'FILTER' => 'Φίλτρο',
        'SAVE_ALBUM' => 'Αποθήκευση άλμπουμ',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Εφαρμογή αυτών των πληροφοριών στις εξής φωτογραφίες',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'κάντε κλικ για να προσθέσετε μια περιγραφή',
        'CHECK' => 'Έλεγχος',
        'YOU_NEED_TO_BE_X' => 'Πρέπει να είστε %s για να το κάνετε.',
        'ALL_PHOTOS' => 'Όλες οι φωτογραφίες',
        'POPULAR_PHOTOS' => 'Δημοφιλείς φωτογραφίες',
        'FEATURED_PHOTOS' => 'Προβεβλημένες φωτογραφίες',
        'PHOTOS_HOME' => 'Αρχική σελίδα φωτογραφιών',
        'ALL_ALBUMS' => 'Όλα τα άλμπουμ',
        'MY_PHOTOS' => 'Οι φωτογραφίες μου',
        'MY_ALBUMS' => 'Τα άλμπουμ μου',
        'ADD_PHOTOS' => 'Προσθήκη φωτογραφιών',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Προσθήκη φωτογραφιών',
        'EDIT' => 'Επεξεργασία',
        'CHOOSE_PHOTOS' => 'Επιλογή φωτογραφιών',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Προσθέστε φωτογραφίες σύροντάς τις</strong> στο άλμπουμ σας στα δεξιά.  Καταργήστε τις σύροντάς τις στην αρχική τους θέση.',
        'TITLE_YOUR_ALBUM' => '<strong>Δώστε τίτλο στο άλμπουμ σας. </strong> Δώστε του ένα εξώφυλλο και μια περιγραφή.',
        'SAVE_YOUR_ALBUM' => 'Αποθηκεύστε το άλμπουμ σας!',
        'CHOOSE_FROM' => 'Επιλέξτε από τα παρακάτω:',
        'EVERYONES_PHOTOS' => 'Οι φωτογραφίες όλων',
        'TAGGED' => 'Με ετικέτα:',
        'OLDER_PHOTOS' => 'Παλαιότερες φωτογραφίες',
        'MORE_RECENT_PHOTOS' => 'Πιο πρόσφατες φωτογραφίες',
        'YOUR_ALBUM' => 'Το άλμπουμ σας',
        'DRAG_ALBUM_COVER_HERE' => 'Σύρετε εδώ το εξώφυλλο του άλμπουμ',
        'ALBUM_TITLE' => 'Τίτλος άλμπουμ:',
        'ALBUM' => 'άλμπουμ',
        'DRAG_PHOTOS_HERE' => 'Σύρετε εδώ τις φωτογραφίες σας',
        'PREVIOUS_ALBUM_PAGE' => 'Προηγούμενη σελίδα άλμπουμ',
        'NEXT_ALBUM_PAGE' => 'Επόμενη σελίδα άλμπουμ',
        'ADDED_ON_DATE' => 'Προστέθηκαν %s',
        'VIEW_AS_SLIDESHOW' => 'Προβολή ως παρουσίαση',
        'CREATED_BY_ME' => 'Δημιουργήθηκε από <a %s>εμένα</a>',
        'CREATED_BY_X' => 'Δημιουργήθηκε από %s',
        'OUR_APOLOGIES' => 'Λυπούμαστε',
        'ADD_PHOTOS_TO_ALBUM' => 'Προσθέστε και άλλες φωτογραφίες σε αυτό το άλμπουμ επιλέγοντας ένα από τα παρακάτω.',
        'YOU_CAN_ADD_PHOTOS' => 'Μπορείτε να <a %s>προσθέσετε φωτογραφίες σε αυτό το άλμπουμ τώρα</a>.',
        'SITE_IS_GETTING_STARTED' => 'Αυτό το κοινωνικό δίκτυο μόλις ξεκίνησε!',
        'NO_ONE_CREATED_ALBUMS' => 'Δεν φαίνεται να έχει δημιουργήσει κανείς άλμπουμ.  Μπορείτε να <a %s>δημιουργήσετε ένα άλμπουμ τώρα</a>.',
        'EDIT_YOUR_ALBUM' => 'Επεξεργασία του άλμπουμ σας',
        'ALBUMS_WITH_THIS_PHOTO' => 'Όλα τα άλμπουμ με αυτή τη φωτογραφία',
        'ALBUMS_WITH_X' => 'Όλα τα άλμπουμ με \'%s\'',
        'ALBUMS_WITH_X_2' => 'Όλα τα άλμπουμ με <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Δεν υπάρχουν άλμπουμ τα οποία περιέχουν αυτή τη φωτογραφία.  Μπορείτε να <a %s>δημιουργήσετε ένα νέο άλμπουμ</a>.',
        'XS_ALBUMS' => 'Άλμπουμ του/της %s',
        'CREATE_AN_ALBUM' => 'Δημιουργία άλμπουμ',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Δεν έχετε δημιουργήσει ακόμα άλμπουμ φωτογραφιών.  Μπορείτε να <a %s>δημιουργήσετε ένα άλμπουμ τώρα</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => 'Ο/Η %s δεν έχει δημιουργήσει ακόμα άλμπουμ φωτογραφιών.',
        'MAKE_AN_ALBUM' => 'Δημιουργήστε ένα άλμπουμ',
        'ABOUT_THIS_ALBUM' => 'Πληροφορίες για αυτό το άλμπουμ',
        'ABOUT_YOUR_ALBUM' => 'Πληροφορίες για το άλμπουμ σας',
        'EDIT_ALBUM' => 'Επεξεργασία άλμπουμ',
        'DELETE_THIS_ALBUM' => 'Να γίνει διαγραφή του άλμπουμ;',
        'DELETE_ALBUM' => 'Διαγραφή άλμπουμ',
        'START_SLIDESHOW' => 'Εκκίνηση προβολής παρουσίασης',
        'ALBUM_IS_NOW_EMPTY' => 'Αυτό το άλμπουμ είναι τώρα κενό.',
        'YOU_ARE_GETTING_STARTED' => 'Μόλις ξεκινήσατε!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Δεν έχετε προσθέσει ακόμα φωτογραφίες!',
        'ADD_PHOTOS_AND_SHARE' => 'Προσθέστε φωτογραφίες και μοιραστείτε τις με τους φίλους, τους συγγενείς σας ή τον υπόλοιπο κόσμο!',
        'ADD_A_PHOTO' => 'Προσθήκη φωτογραφίας',
        'NO_PHOTOS_ON_SITE' => 'Προς το παρόν, δεν υπάρχουν φωτογραφίες στο κοινωνικό σας δίκτυο.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί για άλλα άτομα εκτός και αν υπάρχουν φωτογραφίες προς εμφάνιση.  Γιατί δεν προσθέτετε ένα;',
        'VIEW_EMBED_CODE' => 'Προβολή ενσωματωμένου κώδικα',
        'VIEW_SLIDESHOW' => 'Προβολή παρουσίασης διαφανειών',
        'VIEW_PHOTOS' => 'Προβολή φωτογραφιών',
        'ADD_YOUR_FIRST_PHOTOS' => 'Προσθήκη των πρώτων σας φωτογραφιών',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Μπορείτε να <a %s>προσθέσετε τις δικές σας φωτογραφίες</a> στο %s!',
        'UPLOAD_PHOTOS_FROM' => 'Αποστολή φωτογραφιών από τον υπολογιστή σας:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Προσθέστε τίτλο και περιγραφή για τις φωτογραφίες σας',
        'EDIT_PHOTO_INFORMATION' => 'Επεξεργασία πληροφοριών φωτογραφίας',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Προσθέστε τίτλο, περιγραφή και άλλες πληροφορίες στις φωτογραφίες που έχετε αποστείλει.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Προσθέστε τίτλο, περιγραφή και άλλες πληροφορίες για τη φωτογραφία.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Ακύρωση και επιστροφή στη φωτογραφία',
        'WHO_CAN_VIEW_PHOTO' => 'Ποιος μπορεί να προβάλει αυτή τη φωτογραφία;',
        'CAN_BE_VIEWED_BY' => 'Μπορεί να προβληθεί από:',
        'BY_ME' => 'από <a %s>εμένα</a>',
        'RSS_FEED_LABEL' => '<a %s>Τροφοδοσία RSS</a> – %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Προς το παρόν, δεν υπάρχουν φωτογραφίες σε αναμονή έγκρισης.  Εάν ψάχνετε να βρείτε κάτι να κάνετε, γιατί δεν ρίχνετε μια ματιά στις <a %s>τελευταίες φωτογραφίες</a>;',
        'APPROVE_ALL_PHOTOS' => 'Έγκριση όλων των φωτογραφιών;',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Είστε σίγουροι ότι θέλετε να εγκρίνετε όλες τις φωτογραφίες;  Αυτή η διαδικασία ίσως να διαρκέσει μερικά λεπτά.',
        'DELETE_ALL_PHOTOS' => 'Επιλογή όλων των φωτογραφιών;',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Είστε σίγουροι ότι θέλετε να διαγράψετε όλες τις μη εγκεκριμένες φωτογραφίες;  Αυτή η διαδικασία ίσως να διαρκέσει μερικά λεπτά.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Κρατήστε ανοικτό αυτό το παράθυρο του προγράμματος περιήγησης όσο διαρκεί η έγκριση φωτογραφιών.  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Κρατήστε ανοικτό αυτό το παράθυρο του προγράμματος περιήγησης όσο διαρκεί η διαγραφή φωτογραφιών.  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Εφαρμογή σε όλες τις φωτογραφίες που προστέθηκαν από τον %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Κανένας δεν έχει προσθέσει φωτογραφίες στο κοινωνικό σας δίκτυο.  Μπορείτε να είστε ο πρώτος που θα <a %s>προσθέσει φωτογραφίες. </a>',
        'UNTITLED' => 'Χωρίς τίτλο',
        'A_PROBLEM_OCCURRED' => 'Παρουσιάστηκε πρόβλημα',
        'PHOTOS_EXCEEDED_LIMIT' => 'Οι φωτογραφίες φαίνεται να ξεπερνούν το όριο των 10 MB ανά φωτογραφία.',
        'GET_A_SLIDESHOW_OF' => 'Λήψη προβολής παρουσίασης του %s',
        'GET_A_SLIDESHOW' => 'Λήψη προβολής παρουσίασης!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Λήψη προβολής αυτών των φωτογραφιών',
        'COPY_AND_PASTE_SLIDESHOW' => 'Αντιγράψτε και επικολλήστε τον παρακάτω κώδικα για να τοποθετήσετε μια προβολή παρουσίασης αυτών των φωτογραφιών στην τοποθεσία σας στο Web, τη σελίδα MySpace ή άλλα δίκτυα Ning.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Αντιγράψτε και επικολλήστε τον παρακάτω κώδικα για να τοποθετήσετε μια προβολή παρουσίασης αυτού του άλμπουμ στην τοποθεσία σας στο Web, τη σελίδα MySpace ή άλλα δίκτυα Ning.',
        'LARGE_VERSION' => 'Μεγάλη έκδοση',
        'SMALL_VERSION' => 'Μικρή έκδοση',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Προβολή της προβολής παρουσίασης σε πλήρες μέγεθος',
        'PHOTOS' => 'Φωτογραφίες',
        'XS_PHOTOS' => 'Φωτογραφίες του/της %s',
        'XS_PHOTO' => 'Φωτογραφία του/της %s',
        'YOU_CAN_MARK_PHOTO' => 'Μπορείτε να επισημάνετε οποιαδήποτε φωτογραφία ως αγαπημένη.  Απλώς κάντε κλικ στο εικονίδιο "Προσθήκη στα Αγαπημένα" όταν το δείτε σε φωτογραφία.',
        'VIEW_RECENT_PHOTOS' => 'Προβολή πρόσφατων φωτογραφιών',
        'APPROVE_PHOTOS' => 'Έγκριση φωτογραφιών',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Να γίνει διαγραφή όλων των φωτογραφιών του/της %s;',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Είστε σίγουροι ότι θέλετε να διαγράψετε όλες τις φωτογραφίες με %s;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Καταργήστε τον %1$s και όλα τα περιεχόμενα του/της %1$s από το κοινωνικό δίκτυό σας',
        'SUCCESS' => 'Ολοκληρώθηκε με επιτυχία.',
        'DELETING_CONTENT' => 'Γίνεται διαγραφή περιεχομένου...',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Κρατήστε ανοικτό αυτό το παράθυρο του προγράμματος περιήγησης όσο διαρκεί η διαγραφή περιεχομένου.  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Κρατήστε ανοικτό αυτό το παράθυρο του προγράμματος περιήγησης όσο διαρκεί η διαγραφή μελών.  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'DELETE_ALL_XS_PHOTOS' => 'Διαγραφή όλων των φωτογραφιών του/της %s',
        'CREATE_A_NEW_ALBUM' => 'Δημιουργία νέου άλμπουμ',
        'VIEW_ALL_XS_ALBUMS' => 'Προβολή όλων των άλμπουμ του/της %s',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Δεν έχετε προσθέσει ακόμα φωτογραφίες.  Προσθέστε μερικές φωτογραφίες για να ξεκινήσετε!.',
        'X_HAS_NOT_ADDED_PHOTOS' => 'Ο/Η %s δεν έχει προσθέσει ακόμα φωτογραφίες.',
        'MY_FRIENDS_PHOTOS' => 'Οι φωτογραφίες των φίλων μου',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Προβολή αυτών των φωτογραφιών ως παρουσίαση!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Οι φίλοι σας δεν έχουν ακόμα φωτογραφίες',
        'ALL_PHOTOS_TAGGED_X' => 'Όλες οι φωτογραφίες με ετικέτα \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Όλες οι φωτογραφίες με ετικέτα <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'Δεν υπάρχουν φωτογραφίες με ετικέτα "%1$s".  Ελέγξτε τις <a %2$s>συζητήσεις με ετικέτα "%1$s"</a> ή τα <a %3$s>βίντεο με ετικέτα "%1$s"</a>.  Ή προσθέστε και τοποθετήστε ετικέτα στις δικές σας φωτογραφίες!',
        'SELECT_YOUR_PHOTOS' => 'Επιλέξτε τις φωτογραφίες σας',
        'PHOTO_MAY_BE_10MB' => 'Η κάθε φωτογραφία μπορεί να έχει μέγεθος έως και 10 ΜΒ, αλλά οι μικρότερες φωτογραφίες θα αποσταλθούν γρηγορότερα. Υποστηρίζουμε φωτογραφίες με μορφές αρχείων .jpg, .gif και .png.',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Αφήστε αυτή τη σελίδα ανοικτή έτσι ώστε να μπορέσουμε να ολοκληρώσουμε την αποστολή των φωτογραφιών σας και θα σας ενημερώσουμε όταν εγκριθούν!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Στο μεταξύ, μπορείτε να <a %s>ανοίξετε ένα νέο παράθυρο στο πρόγραμμα περιήγησης</a> και να συνεχίσετε τη χρήση του %s.  Όταν η αποστολή ολοκληρωθεί, θα μπορέσετε να προσθέσετε τίτλους και περιγραφές στις φωτογραφίες σας σε αυτό το παράθυρο.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Αυτή η φωτογραφία είναι σε <strong>αναμονή για έγκριση</strong> από το δημιουργό του %s.',
        'ADD_TO_FAVORITES' => 'Προσθήκη στα Αγαπημένα',
        'EDIT_PHOTO' => 'Επεξεργασία φωτογραφίας',
        'DELETE_PHOTO' => 'Διαγραφή φωτογραφίας',
        'ABOUT_THIS_PHOTO' => 'Πληροφορίες για τη φωτογραφία',
        'LOCATION_OF_PHOTO' => 'Θέση της φωτογραφίας:',
        'ALBUMS_FEATURING_PHOTO' => 'Άλμπουμ που έχουν αυτή τη φωτογραφία',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Προβολή όλων των άλμπουμ με αυτή τη φωτογραφία',
        'RETURN_TO_X' => 'Επιστροφή στο %s',
        'RETURN_TO_PHOTOS_HOME' => 'Επιστροφή στην αρχική σελίδα των φωτογραφιών',
        'WE_COULD_NOT_FIND_ANYONE' => 'Λυπούμαστε, αλλά δεν μπορέσαμε να βρούμε κανέναν',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Κανένας δεν έχει προσθέσει φωτογραφίες ακόμα!  Προσθέστε μερικές φωτογραφίες για να ξεκινήσετε.',
        'DEFAULT_TITLE' => 'Τίτλος',
        'DEFAULT_DESCRIPTION' => 'Περιγραφή',
        'UPLOAD_LIMIT_EXCEEDED' => 'Έχει ξεπεραστεί το όριο μεγέθους του αρχείου αποστολής.',
        'SLOW_DOWN_THERE_CHIEF' => 'Λυπούμαστε',
        'I_DO_NOT_KNOW_USER' => 'Λυπάμαι, δεν γνωρίζω αυτό το άτομο.',
        'I_DO_NOT_HAVE_PHOTO' => 'Λυπάμαι, δεν έχω αυτή την φωτογραφία.',
        'I_DO_NOT_HAVE_ALBUM' => 'Λυπάμαι, δεν έχω αυτό το άλμπουμ.',
        'ALBUM_BY_X_ON_X' => 'Άλμπουμ από τον %s στο %s',
        'SENT' => 'Εστάλη!',
        'I_HAVE_RECENTLY_ADDED' => 'Πρόσφατα πρόσθεσα',
        'FROM_THE_BAZEL' => 'Από αυτό το δίκτυο',
        'RECENTLY_ADDED' => 'Προστέθηκε πρόσφατα',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Πρόσφατες δημόσιες φωτογραφίες στο %s',
        'X_ALL_PHOTOS' => '%s – Όλες οι φωτογραφίες',
        'NO_TAG_WAS_SPECIFIED' => 'Δεν καθορίστηκε καμία ετικέτα',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Δημόσιες φωτογραφίες με ετικέτα %s στο %s',
        'XS_PUBLIC_PHOTOS_ON_X' => 'Δημόσιες φωτογραφίες του %s στο %s',
        'WE_DO_NOT_KNOW_USER' => 'Δεν γνωρίζουμε αυτό το άτομο.',
        'XS_FRIENDS_PHOTOS' => 'Φωτογραφίες φίλων του/της %s',
        'XS_FAVORITE_PHOTOS_ON_X' => 'Αγαπημένες φωτογραφίες του/της %s στο %s',
        'PHOTO_UPLOADED_ON_X' => 'Έγινε αποστολή φωτογραφίας στο %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'Το αρχείο ξεπέρασε το μέγιστο μέγεθος',
        'PART_OF_FILE_WAS_UPLOADED' => 'Απεστάλη μόνο ένα τμήμα του αρχείου',
        'NO_FILE_WAS_UPLOADED' => 'Η αποστολή απέτυχε.  Το όνομα του αρχείου ενδέχεται να ήταν λανθασμένο.',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Παρουσιάστηκε πρόβλημα κατά την αποστολή.',
        'ALPHABETICAL' => 'Αλφαβητική',
        'MOST_VIEWS' => 'Οι περισσότερες προβολές',
        'RATING_NOT_RATED_YET' => '<strong>Αξιολόγηση:</strong> Δεν έχει αξιολογηθεί ακόμα',
        'NOT_RATED_YET' => 'Δεν έχει αξιολογηθεί ακόμα',
        'HMM_SOMETHING_WENT_AWRY' => 'Φαίνεται ότι κάτι δεν πήγε καλά',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Δεν ήταν δυνατή η προσθήκη της φωτογραφίας σας με τίτλο "%s" στο %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Δεν ήταν δυνατή η προσθήκη της φωτογραφίας σας στο %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Μόλις προσπαθήσατε να στείλετε μια φωτογραφία στο %s.  Δυστυχώς, δεν είστε μέλος του %s και δεν μπορούμε να παραδώσουμε αυτή τη φωτογραφία.',
        'ONLY_MY_FRIENDS' => 'Μόνο οι φίλοι μου',
        'ANYBODY' => 'Οποιοσδήποτε',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Μόνο οι φίλοι μου μπορούν να δουν αυτή τη φωτογραφία',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Μόνο οι φίλοι του/της %s μπορούν να δουν αυτή τη φωτογραφία',
        'ONLY_I_CAN_SEE_PHOTO' => 'Μόνο εγώ μπορώ να δω αυτή τη φωτογραφία',
        'ONLY_X_CAN_SEE_PHOTO' => 'Μόνο ο/η %s μπορεί να δει αυτή τη φωτογραφία',
        'EVERYONE_CAN_SEE_PHOTO' => 'Όλοι μπορούν να δουν αυτή τη φωτογραφία',
        'PRIVATE_PHOTO' => '<strong>Ιδιωτική</strong> φωτογραφία',
        'HOWDY_STRANGER' => 'Γεια σου ξένε!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Για να κάνετε αυτό, πρέπει πρώτα να συνδεθείτε στο Ning.',
        'JUST_CLICK_ON_SIGN_IN' => 'Απλώς κάντε κλικ στο "Είσοδος" παραπάνω, ή αν δεν έχετε ήδη ένα λογαριασμό Ning, κάντε κλικ στο "Εγγραφή".',
        'YOU_NEED_TO_BE_' => 'Πρέπει να είστε %s για να το κάνετε.',
        'YOU_NEED_TO_BE_OWNER' => 'Πρέπει να είστε ο δημιουργός του δικτύου για να το κάνετε.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Αυτή η φωτογραφία είναι σε αναμονή για έγκριση.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Πρέπει να είστε φίλος του/της %s για να το κάνετε.',
        'MOST_ACTIVE' => 'Πιο ενεργές',
        'HOW_IT_WORKS' => 'Τρόπος λειτουργίας',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Περισσότεροι τρόποι προσθήκης φωτογραφιών...',
        'BY_PHONE_OR_EMAIL' => '...μέσω τηλεφώνου ή ηλεκτρονικού ταχυδρομείου',
        'FROM_FLICKR' => '...από το Flickr',
        'FROM_YOUR_COMPUTER' => '...από τον υπολογιστή σας',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Προσθέστε φωτογραφίες από το λογαριασμό σας στο Flickr.',
        'MORE_INFORMATION' => 'Περισσότερες πληροφορίες',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Προσθήκη φωτογραφιών μέσω τηλεφώνου ή ηλεκτρονικού ταχυδρομείου',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Στείλτε μία φωτογραφία ή ένα βίντεο μέσω ηλεκτρονικού ταχυδρομείου.  Το θέμα του μηνύματος ηλεκτρονικού ταχυδρομείου γίνεται ο τίτλος της φωτογραφίας ή του βίντεο και το σώμα του κειμένου γίνεται η περιγραφή.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Κάντε κλικ εδώ για να λάβετε μια νέα διεύθυνση ηλεκτρονικού ταχυδρομείου',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Πραγματοποιήστε αποστολή φωτογραφιών από τον υπολογιστή σας.',
        'PHOTO' => 'φωτογραφία',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Προς το παρόν, δεν εμφανίζετε καμία φωτογραφία.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί για άλλα άτομα εκτός και αν επιλέξετε τουλάχιστον μία φωτογραφία.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'Υπάρχει νέο σχόλιο για τη φωτογραφία σας "%s" στο %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'Υπάρχει νέο σχόλιο για μία από τις φωτογραφίες σας στο %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'κάποιος σχολίασε μια φωτογραφία που έχετε προσθέσει στο %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'κάποιος απέστειλε μια φωτογραφία στο %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Προσθέστε φωτογραφίες ή βίντεο στο %s απευθείας από το τηλέφωνό σας, με απευθείας αποστολή σε μια διεύθυνση ηλεκτρονικού ταχυδρομείου.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Θέλετε πραγματικά να καταργήσετε αυτό το στοιχείο από τα αγαπημένα σας;',
        'DELETE_THIS_PHOTO_Q' => 'Να γίνει διαγραφή της φωτογραφίας;',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή τη φωτογραφία;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'PHOTO_SLIDESHOW' => 'Προβολή παρουσίασης',
        'THUMBNAILS' => 'Μικρογραφίες',
        'DETAIL' => 'Λεπτομέρεια',
        'TAG' => 'Ετικέτα',
        'RATE' => 'Αξιολόγηση',
        'ALL_SIZES' => 'Όλα τα μεγέθη',
        'ADD_TO_ALBUM' => 'Προσθήκη στο άλμπουμ',
        'ROTATE_PHOTO' => 'Περιστροφή φωτογραφιών',
        'ABOUT_YOUR_PHOTO' => 'Πληροφορίες για τη φωτογραφία σας',
        'SEE_PHOTOS_ON_NETWORK' => 'Δείτε αυτές τις φωτογραφίες στο %s',
        'EMBED_CODE' => 'Ενσωμάτωση κώδικα',
        'IMPORT_PHOTOS_FLICKR' => 'Λήψη των φωτογραφιών σας από το Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Κάντε κλικ εδώ για να συνεχίσετε στο Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Για να λάβετε τις φωτογραφίες σας από το Flickr, πρέπει πρώτα να επιτρέψετε στον %S να συνδεθεί στο λογαριασμό σας στο Flickr.',
        'IMPORT_PHOTOS' => 'Εισαγωγή φωτογραφιών',
        'GET_MY' => 'Λήψη των δικών μου',
        'GET_PHOTOS' => 'Λήψη φωτογραφιών',
        'MOST_RECENT_PHOTOS' => 'πιο πρόσφατες φωτογραφίες',
        'GET_ALL_MY_FLICKR' => 'Λήψη όλων των φωτογραφιών μου από το Flickr (μπορεί να διαρκέσει λίγο)',
        'GET_ALL_MY_TAGGED' => 'Λήψη όλων των φωτογραφιών μου με ετικέτα',
        'GET_PHOTOS_FROM_SET' => 'Λήψη φωτογραφιών από ένα σύνολο:',
        'GET_STARTED_BY_IMPORT' => 'Θα γίνει αυτόματη λήψη των τίτλων, των ετικετών και οποιωνδήποτε πληροφοριών αντιστοίχισης έχετε. <br/>Πόσο θα διαρκέσει; </p> <p><ul style="padding-top:10px; "><li>10 φωτογραφίες: <em>λιγότερο από 30 δευτερόλεπτα</em>. </li><li>50 φωτογραφίες: <em>περίπου 2 λεπτά</em>. </li><li>200 φωτογραφίες: <em>περίπου 6 λεπτά</em>. </li><li>500 φωτογραφίες: <em>περίπου 15 λεπτά</em>. </li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Εάν δεν έχετε συνδεθεί στο Flickr, θα σας ζητηθεί να το κάνετε.  Όταν συνδεθείτε, κάντε κλικ στο κουμπί "OK, θα το επιτρέψω".',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Λάβετε και περιγραφές (αυτό θα διπλασιάσει το χρόνο).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Κρατήστε αυτή τη σελίδα ανοικτή έτσι ώστε να μπορέσουμε να ολοκληρώσουμε την εισαγωγή των φωτογραφιών σας.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Λάβετε την έκδοση πλήρους μεγέθους κάθε φωτογραφίας (αυτό θα αυξήσει σημαντικά το χρόνο εισαγωγής και δεν το συνιστούμε για περισσότερες από 20 φωτογραφίες).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Κάντε κλικ στο "επεξεργασία" για να προσθέσετε κείμενο, βίντεο, φωτογραφίες ή οποιοδήποτε γραφικό στοιχείο σε αυτό το πλαίσιο.  Είναι ένας άλλος τρόπος για να κάνετε δική σας τη σελίδα %s.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Κάντε κλικ στο \'Επεξεργασία\' για να προσθέσετε κείμενο, HTML, βίντεο, φωτογραφίες ή οποιαδήποτε γραφικά στοιχεία τρίτων <a %1$s> </a> σε αυτό το πλαίσιο.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί για άλλα άτομα μέχρι να ενημερώσετε το περιεχόμενό του.',
        'YOUR_X_BOX' => 'Το πλαίσιό σας %s',
        'ABOUT_WIDGETS' => 'Πληροφορίες για τα γραφικά στοιχεία',
        'HELP' => 'Βοήθεια',
        'WIDGETS' => 'Γραφικά στοιχεία',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Θέλετε να κάνετε το κοινωνικό δίκτυό σας πιο λειτουργικό;  Ίσως ένα ημερολόγιο, τοπικό δελτίο καιρού, αντίστροφη μέτρηση συμβάντος ή κάμερα Web;  Με τα γραφικά στοιχεία, είναι εύκολο να προσθέσετε επιπλέον χαρακτηριστικά σε οποιοδήποτε Πλαίσιο κειμένου στο δίκτυό σας.',
        'GETTING_STARTED' => 'Ξεκινώντας',
        'BELOW_IS_LIST_OF_WIDGET' => 'Δείτε, αν θέλετε, παρακάτω μια <a %s>λίστα παροχέων γραφικών στοιχείων</a>.  Επιλέξαμε μερικά γραφικά στοιχεία από το <a %s>yourminis. com</a> για να ξεκινήσετε.  Απλώς εγκαταστήστε παρακάτω ένα γραφικό στοιχείο, αντιγράψτε τον ενσωματωμένο κώδικα και επικολλήστε τον απευθείας στο Πλαίσιο κειμένου.  Κάντε το!',
        'CALENDAR' => 'Ημερολόγιο',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'Το γραφικό στοιχείο ημερολογίου δεν εμφανίζει μόνο την ημερομηνία, αλλά επίσης σας επιτρέπει να αναζητήσετε και να προσθέσετε συμβάντα μορφής iCal (που χρησιμοποιούνται από το Google Calendar και από πολλούς άλλους παροχείς ηλεκτρονικών ημερολογίων).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Χρησιμοποιήστε το κουμπί &#8220; επεξεργασία γραφικού στοιχείου&#8221;  για να επιλέξετε &#8220; να αναζητήσετε συμβάντα&#8221; , και στη συνέχεια να εισάγετε έναν όρο αναζήτησης (δοκιμάστε διακοπές, μια αθλητική ομάδα κ.ά. ). Μετά, απλώς επιλέξτε ένα αποτέλεσμα της αναζήτησης για να προσθέσετε αυτά τα συμβάντα στο ημερολόγιό σας.  Επίσης, μπορείτε να εισάγετε με μη αυτόματο τρόπο τη διεύθυνση μιας υπάρχουσας τροφοδοσίας iCal.',
        'CUSTOMIZATION' => 'Προσαρμογή',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Μπορείτε να προσαρμόσετε την εμφάνιση του γραφικού στοιχείου μετακινώντας το ποντίκι επάνω στο γραφικό στοιχείο και στη συνέχεια κάντε κλικ στο εικονίδιο επιλογής χρωμάτων για να αλλάξετε το φόντο, το στυλ γραφικού στοιχείου και το επίπεδο διαφάνειας.  Όταν τελειώσετε, κάντε κλικ στη σύνδεση &#8220; αντιγραφή στο Web&#8221;  , και στη συνέχεια στο κουμπί &#8220; αντιγραφή ενσωματωμένου κώδικα&#8221;  .  Όταν γίνει η αντιγραφή του κώδικα, απλώς επιστρέψτε σε οποιοδήποτε Πλαίσιο κειμένου στο δίκτυό σας, επικολλήστε τον κώδικα και αποθηκεύστε τις αλλαγές σας.  Όλα ρυθμίστηκαν!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Μπορείτε να λάβετε περισσότερα γραφικά στοιχεία από το yourminis. com »',
        'WEATHER' => 'Καιρός',
        'WEATHER_WIDGET_DISPLAYS' => 'Το γραφικό στοιχείο καιρού εμφανίζει τις τοπικές καιρικές προβλέψεις από το κανάλι Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Χρησιμοποιήστε το κουμπί &#8220; επεξεργασία γραφικού στοιχείου&#8221;  για να επιλέξετε τη θέση σας και επιλέξτε την κλίμακα Φαρενάιτ ή Κελσίου.  Μπορείτε να επιλέξετε την εμφάνιση του καιρού μόνο για την τρέχουσα ημέρα, ή να την εκτείνετε σε μια πενθήμερη πρόβλεψη.',
        'COUNTDOWN' => 'Αντίστροφη μέτρηση',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Το γραφικό στοιχείο αντίστροφης μέτρησης σας επιτρέπει να δημιουργήσετε μια αντίστροφη μέτρηση σε ένα συγκεκριμένο συμβάν.  Εάν κάνετε κλικ στο κουμπί &#8220; επεξεργασία γραφικού στοιχείου&#8221;  , μπορείτε να εισάγετε την ημερομηνία, την ώρα και το τίτλο ή την εικόνα ενός συμβάντος για αντίστροφη μέτρηση.',
        'WEBCAM' => 'Κάμερα Web',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Το γραφικό στοιχείο κάμερας Web σας επιτρέπει να παρακολουθείτε ενεργά οποιεσδήποτε δημόσια διαθέσιμες κάμερες Web.  Χρησιμοποιήστε το κουμπί &#8220; επεξεργασία γραφικού στοιχείου&#8221;  για να επιλέξετε από μια λίστα με προκαθορισμένες κάμερες διαδικτύου ή για τη μη αυτόματη εισαγωγή οποιασδήποτε διεύθυνσης URL της κάμερας Web.',
        'MORE_WIDGETS' => 'Περισσότερα γραφικά στοιχεία',
        'NEED_MORE_OPTIONS' => 'Χρειάζεστε περισσότερες επιλογές;  Σας συνιστάμε οποιαδήποτε από τις παρακάτω τοποθεσίες για την εξυπηρέτησή σας όσον αφορά τα γραφικά στοιχεία:',
        'MODERATION_DENIED_ON_X' => 'Άρνηση συντονισμού στο %s στο %s',
        'MODERATION_DENIED_ON_A_X' => 'Άρνηση συντονισμού στο %s σας του %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Έχετε ένα καινούργιο %s να συντονίσετε στο %s',
        'NEW_X_TO_MODERATE' => 'Υπάρχει ένα καινούργιο %s για να το συντονίσετε.',
        'MODERATION_APPROVED_ON_X' => 'Εγκρίθηκε ο συντονισμός στο %s στο %s',
        'MODERATION_APPROVED_ON_A_X' => 'Εγκρίθηκε ο συντονισμός στο %s σας του %s',
        'JOIN' => 'Γίνετε μέλος',
        'WELCOME' => 'Καλωσορίσατε',
        'WELCOME_TO_X' => 'Καλωσορίσατε στο %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Καλωσορίσατε στο %s...',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Νέα χαρακτηριστικά! </h3>
            <ul><li><strong>Ομάδες</strong> &ndash.  Επιτρέψετε στα μέλη σας να δημιουργήσουν ομάδες στο δίκτυο σας</li>
                <li><strong>Πρόγραμμα αναπαραγωγής μουσικής</strong> &ndash.  Προσθέστε μουσική και podcast στο δίκτυό σας </li></ul>
            <p><a href="%s" class="desc add">Κάνετε κλικ εδώ για να προσθέσετε χαρακτηριστικά</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Νέα χαρακτηριστικά! </h3>
            <ul><li><strong>Πρόσφατες δραστηριότητες</strong>.  Ακολουθήστε την πιο πρόσφατη δραστηριότητα μέλους στο δίκτυό σας</li>
                <li><strong>Διακριτικά & Γραφικά Στοιχεία</strong>. Προωθήστε το δίκτυο σας στο διαδίκτυο με εξατομικευμένα διακριτικά και γραφικά στοιχεία</li></ul>
            <p><a href="%s" class="desc add">Κάνετε κλικ εδώ για να προσθέσετε/επεξεργαστείτε χαρακτηριστικά</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Στο %2$s, %1$s σας, έχει προστεθεί ένα καινούργιο σχόλιο από κάποιον στο %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Στο %1$s σας, έχει προστεθεί ένα καινούργιο σχόλιο από κάποιον στο %2$s!',
        'HERE_IS_LINK' => 'Αυτή είναι η σύνδεση για τη συμμετοχή: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Ευχαριστούμε,',
        'THANKS' => 'Ευχαριστούμε!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Αλλάξατε τη διεύθυνση του ηλεκτρονικού ταχυδρομείου σας στο %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Αλλάξατε τη διεύθυνση του ηλεκτρονικού ταχυδρομείου σας στο %s...',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Κάνετε κλικ εδώ για να συνδεθείτε με την καινούργια διεύθυνση του ηλεκτρονικού ταχυδρομείου σας:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Εάν δεν αλλάξατε τη διεύθυνση του ηλεκτρονικού ταχυδρομείου σας κάνετε κλικ εδώ:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Για να μη λαμβάνετε ειδοποιήσεις σχετικά με νέες συζητήσεις, μεταβείτε στο:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => 'Ο/Η %1$s ξεκίνησε μια καινούργια συζήτηση στο %2$s...',
        'X_STARTED_THE_DISCUSSION_Y' => 'Ο/Η %1$s ξεκίνησε τη συζήτηση "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Για την προβολή της συζήτησης, μεταβείτε στο:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => 'Ο/Η %s σας έχει προσκαλέσει να γίνετε μέλος στο %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => 'Ο/Η %s επιθυμεί να δοκιμάσετε το "%s" στο %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Δοκιμάστε το "%s" στο %s!',
        'ABOUT_X' => 'Πληροφορίες – %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Έχετε λάβει αυτό το μήνυμα ηλεκτρονικού ταχυδρομείου επειδή %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Εάν δεν επιθυμείτε να λαμβάνετε πλέον ειδοποιήσεις μέσω ηλεκτρονικού ταχυδρομείου από το %s, <a %s>κάνετε κλικ εδώ</a>.',
        'CLICK_HERE' => 'Κάνετε κλικ εδώ',
        'YOU_CAN_CONTACT_US' => 'Μπορείτε να επικοινωνήσετε μαζί μας για οποιεσδήποτε ερωτήσεις ή απορίες σχετικά με το ιδιωτικό σας απόρρητο στη διεύθυνση http://help.ning.com/?page_id=27 .',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Ένα μήνυμα για όλα τα μέλη του %s',
        'CLICK_TO_CHECK_OUT' => 'Κάνετε κλικ εδώ για να το δοκιμάσετε!',
        'CLICK_TO_APPROVE_X' => 'Κάνετε κλικ εδώ για την έγκριση/διαγραφή του %s',
        'YOUR_X_HAS_BEEN_APPROVED' => 'Το %s σας έχει εγκριθεί στο %s!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Το %s σας δεν εγκρίθηκε στο %s.',
        'CLICK_TO_VIEW_X' => 'Κάνετε κλικ εδώ για την προβολή αυτού του %s!',
        'CLICK_TO_VIEW_IT' => 'Κάνετε εδώ κλικ για να το προβάλετε!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'Για την προβολή του προφίλ του/της %s\'s, επισκεφτείτε:',
        'YOU_ADDED_CONTENT' => 'προσθέσατε περιεχόμενο στο %s, ένα κοινωνικό δίκτυο με περιορισμένη πρόσβαση',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => 'Ο/Η %1$s έχει αναφέρει ένα πρόβλημα με το %2$s…',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => 'Ο/Η %s ανέφερε το παρακάτω θέμα.',
        'URL_REPORTED_COLON' => 'Αναφερόμενη URL:',
        'ISSUE_COLON' => 'Θέμα:',
        'ADDITIONAL_INFORMATION_COLON' => 'Πρόσθετες πληροφορίες:',
        'SEND_AN_INVITATION_TO_X' => 'Αποστολή πρόσκλησης στον/στην %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'Κάποιος ζήτησε να γίνει μέλος στο %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Θέλετε να προσθέσετε ένα μήνυμα καλωσορίσματος για το %s στο προφίλ τους;   Μεταβείτε στο:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => 'Ο/Η %s σας έχει στείλει μήνυμα.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Για να διαβάσετε αυτό το μήνυμα, επισκεφτείτε:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => 'Ο/Η %s σας έχει στείλει μήνυμα στο %s...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => 'Ο/Η %s σας πρόσθεσε στους φίλους του...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => 'Ο/Η %s σας πρόσθεσε στους φίλους του στο %s...',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => 'Ο/Η %s έχει κάνει αποδεκτή την αίτησή σας για να προστεθείτε στους φίλους του/της στο %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Για να αποδεχτείτε την αίτηση, επισκεφτείτε:',
        'VIEW_XS_PAGE_ON_Y' => 'Προβολή της σελίδας του/της %s στο %s',
        'MEMBER_OF_X_ACCEPTED' => 'ένα μέλος του %s δέχτηκε την αίτησή σας να προστεθείτε στους φίλους του',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Εάν δεν επιθυμείτε να λαμβάνετε ειδοποιήσεις με αιτήσεις για να προστεθείτε ως φίλος μέσω ηλεκτρονικού ταχυδρομείου από %s, <a %s>κάνετε κλικ εδώ</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Έχετε λάβει αυτή την πρόσκληση από ένα μέλος του %1$s.  Εάν δεν επιθυμείτε να λαμβάνετε προσκλήσεις από %1$s, επικοινωνήστε μαζί μας στο http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => 'Στο %s:',
        'ON_X' => 'στο %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => 'Ο/Η %s έχει ζητήσει να γίνει μέλος στο %s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => 'Ο/Η %1$s ζήτησε να συμμετάσχει στο %2$s στο %3$s...',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => 'Ο/Η %1$s σας έχει προσκαλέσει να συμμετάσχετε στην Ομάδα "%2$s"',
        'VISIT_GROUP_AT' => 'Επισκεφτείτε το %s στο:',
        'ABOUT_GROUP' => 'Σχετικά με %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Ένα μήνυμα από το %s προς όλα τα μέλη του %s στο %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Μπορείτε να συνδεθείτε χρησιμοποιώντας την διεύθυνση ηλεκτρονικού ταχυδρομείου σας εδώ:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => 'Ο/Η %s εισήγαγε σχόλιο στην καταχώρηση ιστολογίου \'%s\' στο %s',
        'SEND_X_A_MESSAGE_HERE' => 'Στείλτε στο %s ένα μήνυμα εδώ:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Υπάρχει ένα καινούργιο μέλος για να το εγκρίνετε στο %s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Υπάρχει ένα καινούργιο μέλος για να το εγκρίνετε.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Για να εγκρίνετε το προφίλ του/της %s, επισκεφτείτε:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Δεν μπορείτε να κάνετε κλικ στην παραπάνω σύνδεση;  Απλά αντιγράψετε και επικολλήστε την διεύθυνση URL στο δικό σας πρόγραμμα περιήγησης Web.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Κάνετε κλικ εδώ για να γίνετε μέλος:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Κάνετε κλικ εδώ για να γίνετε μέλος!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Έχετε εγκριθεί ως μέλος στο %s...',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Συγχαρητήρια!   Έχετε εγκριθεί ως μέλος στο %s.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Μπορείτε τώρα να συνδεθείτε χρησιμοποιώντας τη διεύθυνση του ηλεκτρονικού ταχυδρομείου σας εδώ:',
        'VISIT_X_AT_Y' => 'Επισκεφτείτε το %1$s στο: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Για να ελέγξετε ποια μηνύματα ηλεκτρονικού ταχυδρομείου λαμβάνετε στο %1$s, μεταβείτε στο:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Ένα αποκλεισμένο μέλος σας έστειλε ένα μήνυμα στο %s...',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Ένα αποκλεισμένο μέλος σας έστειλε ένα μήνυμα στο %1$s.   Ο/Η %2$s γράφει:',
        'WELCOME_TO_THE_GROUP_X' => 'Καλωσορίσατε στην ομάδα "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Καλωσορίσατε στο %1$s στο %2$s...',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Για την προβολή αυτής της ομάδας επισκεφτείτε:',
        'X_INVITES_YOU_TO_JOIN_Y' => 'Ο/Η %1$s σας προσκαλεί να συμμετάσχετε στο %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => 'Ο/Η %1$s είναι τώρα μέλος του %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => 'Ο/Η %1$sâ είναι τώρα μέλος του %2$s...',
        'SOMEBODY' => 'Κάποιος',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Για την προβολή του νέου σας σχολίου, επισκεφτείτε:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Για την προβολή του νέου σας σχολίου, επισκεφτείτε:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Για την προβολή της καινούργιας απάντησης, επισκεφτείτε:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Καλωσορίσατε στο %s!  Σας ευχαριστούμε που γίνατε μέλος.',
        'NAME_COLON' => 'Όνομα:',
        'EMAIL_COLON' => 'E-mail:',
        'AGE_COLON' => 'Ηλικία:',
        'GENDER_COLON' => 'Φύλο:',
        'LOCATION_COLON' => 'Θέση:',
        'COUNTRY_COLON' => 'Χώρα:',
        'GET_NETWORK_BADGE' => 'Διακριτικό %s',
        'SPREAD_WORD_GET_BADGE' => 'Διαδώστε τα νέα.  Αποκτήστε το δικό σας διακριτικό %s της τοποθεσίας Web ή της σελίδας MySpace.  (<a %s>Αποκτήστε τον κωδικό</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Διαδώστε τα νέα.  <a href="%s">Αποκτήστε το δικό σας %s διακριτικό</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Δείξτε την εμπιστοσύνη σας.  Αποκτήστε το δικό σας διακριτικό %s για να το βάλετε στην τοποθεσία σας Web ή στην σελίδα MySpace.  (<a %s>Αποκτήστε τον κωδικό</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => 'Ο/Η %1$s εισήγαγε σχόλιο στο %2$s "%4$s" στο %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Λυπούμαστε -・Δεν μπορέσαμε να εξάγουμε καμία διεύθυνση ηλεκτρονικού ταχυδρομείου από το αρχείο.',
        'ADMINISTRATORS' => 'Διαχειριστές',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Η πρόσκλησή σας έχει λήξει.',
        'SORRY_INVITATION_EXPIRED' => 'Λυπούμαστε, η πρόσκληση που χρησιμοποιήσατε έχει λήξει..   Θα χρειαστείτε μια καινούργια πρόσκληση για να συμμετάσχετε στο %s.',
        'DISABLE_INVITATION_LINK' => 'Απενεργοποίηση της σύνδεσης για πρόσκληση;',
        'CREATING_LINK_WILL_DISABLE' => 'Η δημιουργία μιας καινούργιας σύνδεσης για πρόσκληση θα απενεργοποιήσει την τρέχουσα σύνδεση.  Είστε βέβαιοι ότι επιθυμείτε να δημιουργήσετε μια καινούργια σύνδεση;',
        'SHARE_LINK_WITH_PEOPLE' => 'Μοιραστείτε αυτή την σύνδεση με τους ανθρώπους που επιθυμείτε να συμμετάσχουν σε αυτό το δίκτυο:',
        'CREATE_INVITATION_LINK' => 'Δημιουργήστε μια καινούργια σύνδεση πρόσκλησης',
        'PLEASE_SELECT_SECOND_PART' => 'Επιλέξτε το δεύτερο μέρος της διεύθυνσης ηλεκτρονικού ταχυδρομείου, π.χ. gmail. com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Βεβαιωθείτε ότι το σύμβολο @ δεν υπάρχει στο πρώτο μέρος της διεύθυνσης ηλεκτρονικού ταχυδρομείου.',
        'SORRY_WE_DONT_SUPPORT' => 'Λυπούμαστε, δεν υποστηρίζουμε το βιβλίο διευθύνσεων Web για τη δική σας διεύθυνση ηλεκτρονικού ταχυδρομείου.  Κάντε κλικ στο \'Εφαρμογή ηλεκτρονικού ταχυδρομείου\' παρακάτω για να χρησιμοποιήσετε διευθύνσεις από τον υπολογιστή σας.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Παρακαλώ εισάγετε τον κωδικό πρόσβασής σας για το %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Εισαγωγή βιβλίου διευθύνσεων',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Παρακαλώ αφήσετε αυτό το παράθυρο ανοικτό</strong> όσο διαρκεί η λήψη των διευθύνσεων του ηλεκτρονικού ταχυδρομείου των φίλων σας.  Όταν τελειώσουμε θα μπορείτε να επιλέξετε ποιους φίλους να προσκαλέσετε.',
        'SHARE_THIS_LINK' => 'Μοιραστείτε αυτή τη σύνδεση:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Στείλτε την με το πρόγραμμα ηλεκτρονικού ταχυδρομείου του υπολογιστή σας:',
        'EMAIL_THIS' => 'Στείλτε με ηλεκτρονικό ταχυδρομείο αυτό',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(είναι ο φίλος σας)',
        'CLEAR' => 'Απαλοιφή',
        'SEARCH_FRIENDS_TO_INVITE' => 'Αναζητήστε φίλους για να προσκαλέσετε:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Οι προσκλήσεις σας έχουν σταλεί',
        'WANT_TO_INVITE_MORE' => 'Θέλετε να καλέσετε περισσότερους φίλους;  Καλέστε και άλλους φίλους εισάγοντας επαφές από το βιβλίο διευθύνσεων σας Web ή από το πρόγραμμα του ηλεκτρονικού ταχυδρομείου.',
        'MESSAGE_TOO_LONG' => 'Το μήνυμά σας είναι πολύ μεγάλο. Παρακαλούμε χρησιμοποιήστε λιγότερους από %s χαρακτήρες.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Οι παρακάτω διευθύνσεις ηλεκτρονικού ταχυδρομείου φαίνεται ότι δεν είναι έγκυρες.  Οι προσκλήσεις δεν στάλθηκαν  Διορθώστε τις διευθύνσεις ηλεκτρονικού ταχυδρομείου και προσπαθήστε ξανά.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Παρακαλώ εισάγετε μια ή περισσότερες διευθύνσεις ηλεκτρονικού ταχυδρομείου.',
        'ENTER_EMAIL_ADDRESSES' => 'Εισάγετε διευθύνσεις ηλεκτρονικού ταχυδρομείου',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Διαχωρισμός πολλαπλών διευθύνσεων με κόμμα',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Το μήνυμά σας</label> (Προαιρετικό)',
        'SEND_INVITATIONS' => 'Στείλτε προσκλήσεις',
        'WEB_ADDRESS_BOOK' => 'Βιβλίο διευθύνσεων Web',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail ή AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Η διεύθυνση του ηλεκτρονικού σας ταχυδρομείου',
        'IMPORT_ADDRESS_BOOK' => 'Εισάγετε το βιβλίο διευθύνσεων',
        'DONT_WORRY_WE_WONT_SAVE' => 'Μην ανησυχείτε, δεν θα αποθηκεύσουμε τον κωδικό σας πρόσβασης και θα έχετε την ευκαιρία να επιλέξετε σε ποιούς φίλους θα στείλετε μήνυμα ηλεκτρονικού ταχυδρομείου.',
        'EMAIL_APPLICATION' => 'Εφαρμογή ηλεκτρονικού ταχυδρομείου',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, . CSV, κ.λ.π.',
        'UPLOAD_CSV_OR_VCF' => 'Αποστολή ενός αρχείου . csv ή . vcf που έχει εξαχθεί από το Microsoft Outlook ή από το Apple Address Book.',
        'BROWSE_FOR_FILE' => 'Περιηγηθείτε για εύρεση αρχείου',
        'UPLOAD' => 'Αποστολή',
        'SELECT_ELLIPSIS' => 'Επιλέξετε...',
        'OTHER_ELLIPSIS' => 'άλλο...',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Μην ανησυχείτε, θα έχετε την ευκαιρία να επιλέξετε σε ποιούς φίλους θα στείλετε μήνυμα ηλεκτρονικού ταχυδρομείου.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Γίνεται μέλος μέσω πρόσκλησης μόνο',
        'IF_YOU_ARE_ADMIN' => 'Εάν είστε διαχειριστής, <a %s>κάνετε κλικ εδώ για να συνδεθείτε</a>.',
        'NAME_MUST_BE_SHORTER' => 'Το όνομα πρέπει να είναι μικρότερο από %s χαρακτήρες',
        'CITY_NAME_MUST_BE_SHORTER' => 'Το όνομα της πόλης πρέπει να είναι μικρότερο από %s χαρακτήρες',
        'EMAIL_ALREADY_REGISTERED' => 'Η διεύθυνση του ηλεκτρονικού ταχυδρομείου έχει ήδη καταχωρηθεί.  Παρακαλώ επιλέξετε μια άλλη.',
        'EMAIL_NOT_VALID' => 'Η διεύθυνση του ηλεκτρονικού ταχυδρομείου φαίνεται ότι δεν είναι έγκυρη.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => 'Ο/Η %s σας κάλεσε στο %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Εγγράφεστε με το αναγνωριστικό σας Ning.',
        'NOW_ENTER_PASSWORD' => 'Τώρα απλά εισάγετε τον κωδικό πρόσβασή σας για να συνεχίσετε.',
        'OR_SIGN_IN' => 'ή <a %s>Είσοδος</a>',
        'CHANGE_ADDRESS' => 'Αλλαγή διεύθυνσης',
        'CHANGE_PAGE_ADDRESS' => 'Αλλάξετε τη διεύθυνση της σελίδας',
        'PAGE_ADDRESS_TAKEN' => 'Λυπούμαστε, αυτή η διεύθυνση ηλεκτρονικού ταχυδρομείου έχει ήδη καταχωρηθεί.  Παρακαλώ επιλέξετε μια άλλη.',
        'PAGE_ADDRESS_NOT_VALID' => 'Μπορείτε να χρησιμοποιήσετε μόνο τους χαρακτήρες A-Z, τους αριθμούς και την κάτω παύλα (_) στη διεύθυνσή σας.',
        'ADD_BY_PHONE' => 'Προσθήκη μέσω τηλεφώνου',
        'PAGE_ADDRESS' => 'Διεύθυνση σελίδας',
        'PHOTO_MUST_BE_TYPE' => 'Η φωτογραφία σας πρέπει να είναι ένα αρχείο . jpg, . gif ή . png.',
        'USEFUL_ADDRESSES' => 'Χρήσιμες διευθύνσεις',
        'MY_DETAILS' => 'Τα στοιχεία μου',
        'NONE_I_DO_NOT_WANT' => 'Κανένα: Δεν επιθυμώ να λαμβάνω μηνύματα ηλεκτρονικού ταχυδρομείου από το %s',
        'CHANGE_PASSWORD' => 'Αλλάξετε τον κωδικό πρόσβασης',
        'PROFILE_SAVED' => 'Οι αλλαγές σας έχουν αποθηκευτεί επιτυχώς.',
        'UPDATE_EMAIL_ADDRESS' => 'Ενημέρωση της διεύθυνσης ηλεκτρονικού ταχυδρομείου',
        'EDIT_EMAIL_ADDRESS' => 'Επεξεργαστείτε τη διεύθυνση του ηλεκτρονικού ταχυδρομείου σας',
        'MY_SETTINGS' => 'Οι ρυθμίσεις μου',
        'ABOUT_ME' => 'Πληροφορίες για μένα',
        'SELECT' => 'Επιλέξτε...',
        'CITY' => 'Πόλη',
        'COUNTRY' => 'Χώρα',
        'DATE_OF_BIRTH' => 'Ημερομηνία γέννησης',
        'DO_NOT_DISPLAY' => 'Μην εμφανίζετε',
        'GENDER' => 'Φύλο',
        'CREATE_YOUR_PROFILE' => 'Δημιουργήστε το προφίλ σας',
        'SYSTEM_REQUIREMENTS' => 'Απαιτήσεις συστήματος',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Υποστηρίζουμε τον Internet Explorer 6 & 7, το Firefox 2.0 και το Safari 2.0. Εάν χρησιμοποιείτε ένα διαφορετικό πρόγραμμα περιήγησης (πιθανόν κάποιο που σας παρασχέθηκε από τον παροχέα υπηρεσιών διαδικτύου), αυτό ενδέχεται να μην είναι συμβατό.',
        'MAKE_SURE_COOKIES' => 'Βεβαιωθείτε ότι είναι ενεργοποιημένα στο πρόγραμμα περιήγησης τα cookies και το JavaScript.',
        'WHAT_IS_MY_EMAIL' => 'Ποια είναι η διεύθυνση του ηλεκτρονικού ταχυδρομείου μου;',
        'IF_JOINED_BEFORE_OCTOBER' => 'Εάν γίνατε μέλος πριν τη 5ην Οκτωβρίου 2007, ίσως προηγουμένως να σας είχε ζητηθεί ένα \'Αναγνωριστικό Ning\'.  Σας ζητάμε τώρα να συνδεθείτε με την διεύθυνση του ηλεκτρονικού ταχυδρομείου με την οποία εγγραφήκατε, εντούτοις μπορείτε ακόμη να εισάγετε το αναγνωριστικό σας Ning σε αυτό το πεδίο.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Κάνετε κλικ εδώ για να επαναφέρετε τον κωδικό πρόσβασής σας.',
        'STILL_HAVING_PROBLEMS' => 'Ακόμη αντιμετωπίζετε προβλήματα;',
        'VISIT_NING_HELP_CENTER' => 'Επισκεφτείτε το <a %s>Κέντρο Βοήθειας της Ning </a> για περισσότερες πληροφορίες σχετικά με την επίλυση προβλημάτων και υποστήριξη.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Προβλήματα με την εγγραφή ή με τη σύνδεση',
        'WE_SENT_YOU_EMAIL' => 'Σας έχουμε στείλει ένα μήνυμα ηλεκτρονικού ταχυδρομείου με μια σύνδεση για να επαναφέρετε τον κωδικό σύνδεσή σας.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Επαναφορά κωδικού πρόσβασης',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

 Έχουμε λάβει ένα αίτημα για αλλαγή του κωδικού πρόσβασής σας στο %2$s.

Κάνετε κλικ στην παρακάτω σύνδεση για να ορίσετε έναν καινούργιο κωδικό πρόσβασης:

#{URL}

Εάν δεν επιθυμείτε να αλλάξετε τον κωδικό πρόσβασής σας, μπορείτε να αγνοήσετε αυτό το μήνυμα ηλεκτρονικού ταχυδρομείου.

Ευχαριστούμε,
Η "%2$s" Ομάδα

-----
%2$s χρησιμοποιεί το αναγνωριστικό Ning για τον έλεγχο ταυτότητας.',
        'SET_PASSWORD' => 'Ορισμός κωδικού πρόσβασης',
        'NEW_PASSWORD' => 'Καινούργιος κωδικός πρόσβασης',
        'CREATE_NEW_PASSWORD' => 'Δημιουργία καινούργιου κωδικού πρόσβασης',
        'SET_NEW_PASSWORD' => 'Ορίστε έναν νέο κωδικό πρόσβασης για τον λογαριασμό σας.',
        'CHOOSE_NEW_PASSWORD' => 'Παρακαλώ επιλέξετε έναν καινούργιο κωδικό πρόσβασης',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Γεια σου %s</strong> (<a %s>Έξοδος</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Δεν υπάρχει λογαριασμός με την διεύθυνση του ηλεκτρονικού ταχυδρομείου %s',
        'PLEASE_ENTER_CODE' => 'Παρακαλώ εισάγετε τον κωδικό που εμφανίζεται στη δεξιά πλευρά.',
        'PROBLEMS_SIGNING_UP' => 'Αντιμετωπίζετε προβλήματα με την εγγραφή σας;',
        'BY_SIGNING_UP_YOU_AGREE' => 'Με την εγγραφή σας, συμφωνείτε με τους <a %s>Όρους χρήσης</a> και την <a %s>Πολιτική απορρήτου&nbsp; </a>.',
        'FEEDBACK' => 'Σχόλια',
        'TERMS_OF_SERVICE' => 'Όροι χρήσης',
        'PROBLEM_SIGNING_UP' => 'Υπήρξε πρόβλημα με την εγγραφή',
        'ALREADY_MEMBER_SIGN_IN' => 'Είσαστε ήδη μέλος;  <a %s>Κάνετε κλικ εδώ για να συνδεθείτε</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Μπορείτε να γίνετε μέλος στο %s μόνο μέσω πρόσκλησης',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Λυπούμαστε, αλλά ο διαχειριστής έχει επιλέξει να απαιτείται πρόσκληση για να γίνετε μέλος στο %s.  Εάν έχετε πρόσκληση, κάνετε κλικ στη σύνδεση μέσα στο μήνυμα του ηλεκτρονικού ταχυδρομείου για να γίνετε μέλος.',
        'PROBLEM_SIGNING_IN' => 'Υπήρξε πρόβλημα με την σύνδεση',
        'WE_USE_NING_ID' => 'Χρησιμοποιούμε αναγνωριστικό Ning για τον έλεγχος ταυτότηας.  <a %s>Τί είναι το αναγνωριστικό Ning; </a>',
        'PROBLEMS_SIGNING_IN' => 'Αντιμετωπίζετε προβλήματα με την σύνδεση;',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Είσοδος" /> &#160; ή&#160;  <strong><a %s>Εγγραφή</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Είσοδος στο %s',
        'WHAT_IS_A_NING_ID' => 'Τί είναι το αναγνωριστικό Ning;',
        'LARR_BACK' => '← <a %s>Πίσω</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Το σύστημα ελέγχου ταυτότητας του αναγνωριστικού Ning σας επιτρέπει να επιλέξετε μια διεύθυνση ηλεκτρονικού ταχυδρομείου και ένα κωδικό πρόσβασης μια φορά και να τον χρησιμοποιήσετε για να γίνετε μέλος ή να συνδεθείτε σε οποιοδήποτε κοινωνικό δίκτυο που χρησιμοποιεί το αναγνωριστικό Ning.',
        'WHEN_YOU_CREATE_NING_ID' => 'Όταν δημιουργήσετε ένα αναγνωριστικό Ning, μπορείτε και να προσθέσετε ένα σύνολο από βασικές πληροφορίες και την φωτογραφία σας στον λογαριασμό του αναγνωριστικού Ning σας.  Αυτές οι λεπτομέρειες προ-συμπληρώνονται όποτε γίνετε μέλος σε ένα καινούργιο κοινωνικό δίκτυο που χρησιμοποιεί το αναγνωριστικό Ning για τον έλεγχο ταυτότητας.  Επίσης σας δίνει τη δυνατότητα να παρακολουθείτε τους φίλους σας και τα μηνύματά σας σε όλα τα κοινωνικά δίκτυα που το χρησιμοποιούν.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Μπορείτε να συνδεθείτε με την διεύθυνση του ηλεκτρονικού ταχυδρομείου του αναγνωριστικού Ning σας και με τον κωδικό πρόσβασή σας οποτεδήποτε δείτε αυτό το σύμβολο. %s',
        'HELLO_USER' => 'Γεια σου %s',
        'TEXT_FOR_HEADER_TAB' => 'Αυτό το κείμενο είναι για την καρτέλα της κεφαλίδας',
        'BASED_ON' => 'Βασίζεται στα',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Είστε σίγουροι ότι επιθυμείτε τη διαγραφή αυτής της γλώσσας;',
        'DELETE_LANGUAGE' => 'Διαγραφή γλώσσας',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'Έγινε επαναφορά του κειμένου στην αρχική του έκδοση.',
        'UPLOAD_LANGUAGE_FILE' => 'Αποστολή αρχείου γλώσσας',
        'ADD_TO_LANGUAGE' => 'Προσθήκη γλώσσας:',
        'IF_YOU_CREATED_TRANSLATION' => 'Εάν έχετε δημιουργήσει μια καινούργια μετάφραση σε ένα άλλο κοινωνικό δίκτυο Ning, μπορείτε να εισάγετε την εργασία σας εδώ.  Το περιεχόμενο του αρχείου θα προστεθεί στην γλώσσα της επιλογής σας.  Δεν βλέπετε την γλώσσα σας στην λίστα;  <a %s>Είναι εύκολο να προσθέσετε μια καινούργια</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Παραδείγματα: Σουηδικά (Φιλανδία), Φιλιπινέζικα, Ισπανικά (Πουέρτο Ρίκο)',
        'START_FROM_SCRATCH_CREATE' => 'Ξεκινήστε από την αρχή!  Δημιουργήστε μια καινούργια μετάφραση για το δίκτυό σας εισάγοντας ένα όνομα για την καινούργια γλώσσα, μετά επιλέξτε μια υπάρχουσα γλώσσα ως σημείο αναφοράς.',
        'KEY_MISSING_TEXT' => 'Κλειδί: <span %s>Ελλιπές κείμενο</span> <span %s>Αλλαγμένο Κείμενο</span>',
        'SHOW_ALL_TEXT' => 'Εμφάνιση όλου του κειμένου',
        'SHOW_MISSING_TEXT' => 'Εμφάνιση ελλιπούς κειμένου',
        'SHOW_CHANGED_TEXT' => 'Εμφάνιση αλλαγμένου κειμένου',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Παραδείγματα: Καρτέλες, Μέλη, Φίλοι',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Επαναφορά του κειμένου στην αρχική έκδοση',
        'ORIGINAL_TEXT_X' => 'Αρχικό κείμενο – %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Επεξεργαστείτε τη γλώσσα στο δίκτυό σας',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Εξατομικεύσετε οποιοδήποτε τμήμα του κειμένου σας στο δίκτυό σας, συμπεριλαμβανομένων και των ονομάτων των καρτελών, υποσέλιδων μηνυμάτων ηλεκτρονικού ταχυδρομείου, μηνυμάτων σφαλμάτων και άλλων.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>Η ενεργή γλώσσα για το δίκτυό σας είναι η %1$s</em>.  <a %2$s>Αλλαγή ενεργής γλώσσας</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Επιλογές τρέχουσας γλώσσας',
        'ACTIVE' => 'Ενεργή',
        'MY_LANGUAGES' => 'Οι γλώσσες μου',
        'CREATE_NEW_TRANSLATION' => 'Δημιουργία καινούργιας μετάφρασης',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Δεν βλέπετε τη γλώσσα σας στην παραπάνω λίστα;  <strong><a %s>Δημιουργήστε μια καινούργια μετάφραση για το δίκτυό σας</a></strong>.',
        'ADVANCED_IMPORT' => 'Προηγμένη εισαγωγή',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Εάν έχετε μεταφράσει μια γλώσσα σε ένα υπάρχον κοινωνικό δίκτυο, μπορείτε να <strong><a %s>εισάγετε το αρχείο της γλώσσας σας</a></strong> και να το χρησιμοποιήσετε σε αυτό το δίκτυο.',
        'LANGUAGE_EDITOR' => 'Επεξεργαστής Γλώσσας',
        'PUBLIC' => 'Δημόσιο',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Η τρέχουσα ρύθμιση απορρήτου σας, ένα δημόσιο δίκτυο όπου όσοι δεν είναι μέλη μπορούν μόνο να δουν την οθόνη σύνδεσης, δεν είναι πλέον διαθέσιμη.   Η ρύθμιση απορρήτου σας δεν έχει αλλάξει, αλλά εάν κάνετε οποιεσδήποτε αλλαγές εδώ, δεν θα είστε σε θέση να επιστρέψετε.   Το τρέχον ισοδύναμο είναι ένα ιδιωτικό δίκτυο όπου ο καθένας μπορεί να εγγραφεί για να γίνει μέλος.',
        'NO_MISSING_ITEMS' => '‘Δεν υπάρχει κανένα ελλιπές στοιχείο. Aυτή η μετάφραση είναι 100%% ολοκληρωμένη.  <a %s>Προβολή όλων των στοιχείων. </a>',
        'NO_CHANGED_ITEMS' => 'Δεν υπάρχει κανένα αλλαγμένο στοιχείο.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Λυπούμαστε, δεν μπορέσαμε να βρούμε στοιχεία που να ταιριάζουν στο <em>%s</em>.  <a %s>Προβολή όλων των στοιχείων. </a>',
        'FILE_N' => 'Αρχείο %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Ένα αρχείο μετάφρασης Ning έχει ένα όνομα αρχείου όπως <code>en_US. txt</code>.  <a %s>Μάθετε περισσότερα εδώ. </a>',
        'SELECT_TRANSLATION_FILE' => 'Επιλέξτε το αρχείο μετάφρασης:',
        'USE_THIS_TRANSLATION' => 'Χρησιμοποιήστε αυτή τη μετάφραση',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Σημειωτέον ότι τα ακόλουθα λείπουν από τους παρακάτω κανόνες: %s',
        'ALL' => 'Όλα',
        'MISSING' => 'Λείπει',
        'VIEW' => 'Προβολή',
        'TRANSLATION_CHANGES_SAVED' => 'Οι αλλαγές σας έχουν αποθηκευτεί.  Αυτή η μετάφραση είναι %s%% ολοκληρωμένη.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Οι αλλαγές σας έχουν αποθηκευτεί.  Αυτή η μετάφραση είναι %s%% ολοκληρωμένη.  Θα θέλατε να χρησιμοποιήσετε αυτή ως τρέχουσα γλώσσα για το δίκτυό σας;',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Η αποστολή σας ήταν επιτυχής.  Αυτή η μετάφραση είναι %s%% ολοκληρωμένη.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Η αποστολή σας ήταν επιτυχής.  Αυτή η μετάφραση είναι %s%% ολοκληρωμένη.  Θα θέλατε να χρησιμοποιήσετε αυτή ως τρέχουσα γλώσσα για το δίκτυό σας;',
        'X_IS_CURRENT_LANGUAGE' => 'Η %s είναι τώρα η γλώσσα του δικτύου σας.',
        'SAVE_PAGE' => 'Αποθήκευση σελίδας',
        'LANGUAGE_NAME_TAKEN' => 'Λυπούμαστε, αλλά αυτό το όνομα χρησιμοποιείται ήδη από άλλον.  Επιλέξτε διαφορετικό όνομα.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Παρακαλώ εισάγετε ένα όνομα για την καινούργια μετάφρασή σας, π.χ., Πορτογαλικά (Πορτογαλία)',
        'CREATE' => 'Δημιουργία',
        'LANGUAGE_NAME' => 'Όνομα γλώσσας',
        'SAVE_ITEMS_ON_PAGE' => 'Αποθήκευση των στοιχείων αυτής της σελίδας',
        'NEW_TRANSLATION' => 'Καινούργια Μετάφραση',
        'MISMATCHED_CURLY_BRACKETS' => 'Αταίριαστα άγκιστρα.',
        'MISMATCHED_SQUARE_BRACKETS' => 'Αταίριαστες αγκύλες',
        'MISMATCHED_PARENTHESES' => 'Αταίριαστες παρενθέσεις',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Παρουσιάστηκε σφάλμα κατά την επεξεργασία του κωδικού των Ειδικών κανόνων.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Παρουσιάστηκε σφάλμα κατά την επεξεργασία του κωδικού των ονομάτων καρτελών.',
        'SPECIAL_RULES' => 'Ειδικοί κανόνες',
        'TAB_NAMES' => 'Ονόματα καρτελών',
        'SOURCE' => 'Πηγή',
        'LANGUAGE_EDITOR_X' => 'Επεξεργαστής γλώσσας: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Πίσω στον Επεξεργαστή Γλώσσας',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Προσαρμόστε το κείμενο του δικτύου σας και τα μηνύματα ή δημιουργήστε μια καινούργια γλώσσα.',
        'STOPWORDS' => 'ένα | για | ένα | είναι | ως | σε | είναι | από | com | de | en | για | από | πώς | i | σε | είναι | αυτό | la | του | σε | ή | ότι | το | αυτό | σε | ήταν | τι | πότε | που | ποιος | θα | με | und | το | www',
        'STOPWORDS_ARE' => '<a %s>Εξαιρούμενες λέξεις </a> είναι ένας προαιρετικός κατάλογος λέξεων που δεν λαμβάνονται υπόψη στην περιγραφή του δικτύου κατά τη δημιουργία των μετα-ετικετών στο πάνω μέρος κάθε σελίδας.  Προαιρετικό.',
        'I_AM_MEMBER' => 'Είμαι μέλος του:',
        'VIEW_PAGE_ON_APPNAME' => 'Προβάλετε την σελίδα μου στο <em>%s</em>',
        'VISIT_APPNAME' => 'Επισκεφτείτε το <em>%s</em>',
        'JOIN_US' => 'Γίνετε μέλος',
        'CREATED_BY_COLON' => 'Δημιουργήθηκε από:',
        'GET_MORE_BADGES' => 'Αποκτήσετε περισσότερα διακριτικά',
        'SHOW_LOGO' => 'Εμφάνιση λογότυπου',
        'GALLERY' => 'Γκαλερί',
        'BADGES' => 'Διακριτικά',
        'MEMBER_BADGE' => 'Διακριτικό μέλους',
        'WEAR_IT_WITH_PRIDE' => 'Φορέστε το με περηφάνεια!  Πάρτε ένα %s διακριτικό μέλους που μπορείτε να εμφανίσετε στην τοποθεσία σας Web ή στη σελίδα σας στο MySpace.',
        'NETWORK_BADGE_LARGE' => 'Διακριτικό δικτύου (Μεγάλο)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Διαδώστε τα νέα!  Πάρτε ένα διακριτικό %s που ενημερώνει δυναμικά με τα δίκτυα τα περισσότερα δημοφιλή μέλη.  Προσθέστε το στην τοποθεσία Web σας ή στη σελίδα σας στο MySpace.',
        'NETWORK_BADGE_SMALL' => 'Διακριτικό δικτύου (Μικρό)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Διαδώστε τα νέα!  Αποκτήστε ένα διακριτικό %s που μπορείτε να το εμφανίσετε στην τοποθεσία Web ή στη σελίδα σας στο MySpace.',
        'PHOTO_SLIDESHOW_PROPER' => 'Προβολή παρουσίασης φωτογραφιών',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Εμφανίστε μια επιλογή των φωτογραφιών σας σε τοποθεσία Web ή σε μια σελίδα σας στο MySpace με το μοντέρνο μας πρόγραμμα αναπαραγωγής για προβολή παρουσιάσεων φωτογραφιών.',
        'MUSIC_PLAYER' => 'Πρόγραμμα αναπαραγωγής μουσικής',
        'PLAY_MUSIC_ON_WEBSITE' => 'Αναπαράγετε τη μουσική σας σε τοποθεσία Web ή στη σελίδα σας στο MySpace με το μοντέρνο μας πρόγραμμα αναπαραγωγής μουσικής.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Προσθέστε ένα βίντεο στην τοποθεσία σας Web ή στη σελίδα σας στο MySpace.  Αναζητάτε περισσότερες επιλογές;  <a href="%s">Προβολή όλων των βίντεο</a> στο %s.',
        'LARGE_N_PIXELS_WIDE' => 'Μεγάλο - πλάτους %d pixel',
        'MEDIUM_N_PIXELS_WIDE' => 'Μεσαίο - πλάτους %d pixel',
        'SMALL_N_PIXELS_WIDE' => 'Μικρό - πλάτους %d pixel',
        'MY_MOST_RECENT' => 'Τα πιο πρόσφατα μου',
        'APP_ICON' => 'Εικονίδιο εφαρμογής',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'Μπορείτε να γίνετε μέλος στο %s μόνο μέσω πρόσκλησης',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => 'Ο/Η %s παρείχε το ακόλουθο σχόλιο:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => 'Ο/Η %1$s παρείχε σχόλιο σχετικά με το %2$s...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Ευχαριστούμε.   Το μήνυμά σας έχει σταλεί.',
        'X_WOULD_LIKE_TO_JOIN_X' => 'O/H %s επιθυμεί να γίνει μέλος στο %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => 'Ο/Η %s έχει ζητήσει μια πρόσκληση στο %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Η αίτησή σας έχει αποσταλεί στον δημιουργό του δικτύου.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Για την ακύρωση της απαγόρευσης %s, μεταβείτε στο:',
        'SEND_REQUEST' => 'Αποστολή αίτησης',
        'SEARCH' => 'Αναζήτηση',
        'SEARCH_AGAIN' => 'Επανάληψη αναζήτησης',
        'SEND_BROADCAST_MESSAGE' => 'Αποστολή εκπεμπόμενου μηνύματος',
        'VERIFICATION_IMAGE' => 'Εικόνα επιβεβαίωσης',
        'UNDER_CONSTRUCTION' => 'Υπό κατασκευή',
        'PROFILE_INFORMATION_SAVED' => 'Αποθηκεύτηκαν οι πληροφορίες του προφίλ',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'Έχουν αποθηκευτεί οι πληροφορίες του προφίλ του καταλόγου του δικτύου σας.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Δεν υπάρχει λογαριασμός με αυτή τη διεύθυνση του ηλεκτρονικού ταχυδρομείου.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Εσφαλμένος κωδικός πρόσβασης.   Είναι ενεργό το πλήκτρο Caps Lock;',
        'OOPS_THAT' => 'Δυστυχώς, αυτό δεν λειτούργησε.',
        'OOPS_THAT_DID_NOT_WORK' => 'Δυστυχώς, αυτό δεν λειτούργησε.   Να προσπαθήσουμε ξανά;',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Δυστυχώς, αυτό δεν λειτούργησε (%s).',
        'NOT_FOUND' => 'Δεν βρέθηκε',
        'YOUR_SITES_FEATURE_LIST' => 'Η λίστα χαρακτηριστικών του δικτύου σας έχει αποθηκευτεί.',
        'ONE_LINE_ANSWER' => 'Απάντηση μιας γραμμής',
        'LONGER_ANSWER' => 'Μεγαλύτερη απάντηση',
        'MULTIPLE_CHOICE' => 'Πολλαπλής επιλογής',
        'DATE' => 'Ημερομηνία',
        'WEBSITE_ADDRESS' => 'Διεύθυνση τοποθεσίας Web',
        'EVERYTHING' => 'Όλα',
        'JUST_THE_HOMEPAGE' => 'Μόνο η αρχική σελίδα',
        'JUST_THE_SIGN_UP_PAGE' => 'Μόνο η σελίδα εγγραφής',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Οι αλλαγές σας έχουν αποθηκευτεί.',
        'JOIN_ME_ON_X' => 'Συμμετάσχετε μαζί μου στο %s!',
        'NOT_ALLOWED' => 'Δεν επιτρέπεται',
        'COME_JOIN_ME_ON_X' => 'Ελάτε να συμμετάσχετε μαζί μου στο %s.',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Ελάτε να γίνετε μέλος μαζί μου στο %s...',
        'X_NOT_VALID_EMAIL' => 'Το %s δεν είναι μια έγκυρη διεύθυνση ηλεκτρονικού ταχυδρομείου ή ένα αναγνωριστικό Ning',
        'USER_BANNED_FROM_NETWORK' => 'Ο/Η %1$s έχει αποκλειστεί από αυτό το δίκτυο.  <a %2$s>Στείλτε στον/στην %1$s ένα μήνυμα</a>',
        'USER_ALREADY_NETWORK_MEMBER' => 'Ο/Η %1$s είναι ήδη μέλος αυτού του δικτύου.  <a %2$s>Στείλτε στον/στην %1$s ένα μήνυμα</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Μπορείτε να στείλετε μέχρι %s ταυτόχρονα.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Εισάγετε τις διευθύνσεις ηλεκτρονικού ταχυδρομείου των φίλων σας ή τα αναγνωριστικά Ning',
        'THERE_HAS_BEEN_AN_ERROR' => 'Παρουσιάστηκε σφάλμα',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Οι προσκλήσεις σας έχουν σταλεί.',
        'SEARCH_RESULTS' => 'Αναζήτηση αποτελεσμάτων',
        'INVITE_YOUR_FRIENDS' => 'Προσκαλέστε τους φίλους σας',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Στείλτε προσκλήσεις στους φίλους σας για να γίνουν μέλη στο',
        'INVITATION' => 'Πρόσκληση',
        'ADD_FROM_ADDRESS' => 'Προσθέστε από το βιβλίο διευθύνσεων',
        'TO' => 'Προς:',
        'SEND_TO' => 'Αποστολή προς',
        'SUBJECT' => 'Θέμα',
        'YOUR_MESSAGE' => 'Το μήνυμά σας',
        'SEND' => 'Αποστολή',
        'REPORT_AN_ISSUE' => 'Αναφορά προβλήματος',
        'TYPE_OF_ISSUE' => 'Τύπος προβλήματος',
        'ADULT' => 'Πορνογραφικό',
        'ABUSIVE' => 'Υβριστικό',
        'BUG' => 'Σφάλμα',
        'FRAUD' => 'Απάτη',
        'SPAM' => 'Ανεπιθύμητη ηλεκτρονική αλληλογραφία',
        'OTHER' => 'Άλλο',
        'DESCRIBE_YOUR_ISSUE' => 'Περιγράψτε το πρόβλημά σας',
        'SEND_REPORT' => 'Αποστολή αναφοράς',
        'ADDED_BY_X_AT_X' => 'Προστέθηκε από τον/την <a %s>%s</a> στο %s στο %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Προστέθηκε από τον/την <a %s>%s</a> στο %s στο %s στο %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Κάνετε κλικ για προβολή',
        'COMMENT_FOR' => 'Σχόλιο για:',
        'COMMENT_ON' => 'Σχόλιο σχετικά με:',
        'ACTION_BUTTON_FEATURE' => 'Χαρακτηριστικό',
        'FEATURE_THIS_ON_YOUR' => 'Προβάλετέ το στην αρχική σελίδα',
        'ACTION_BUTTON_REMOVE' => 'Κατάργηση',
        'REMOVE' => 'Κατάργηση',
        'REMOVE_THIS_FROM_YOUR' => 'Καταργήστε το από την αρχική σελίδα',
        'FEATURE_ON_HOME' => 'Προβάλλετε στη αρχική σελίδα',
        'REMOVE_FROM_HOME' => 'Κατάργηση από την αρχική σελίδα',
        'ITEM_WILL_APPEAR' => 'Αυτό το στοιχείο θα εμφανιστεί τώρα στις επιλεγμένες ενότητες στην αρχική σελίδα',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Αυτό το στοιχείο δεν θα εμφανιστεί πλέον στις επιλεγμένες ενότητες στην αρχική σελίδα',
        'ADD_CONTENT' => 'Προσθήκη περιεχομένου',
        'BROUGHT_TO_YOU_BY' => 'Το %s είναι προσφορά της %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Στείλτε μας τα σχόλιά σας',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Για επιπλέον ερωτήσεις ή για να επικοινωνήσετε με τη Ning, κάνετε κλικ εδώ:',
        'SEND_FEEDBACK' => 'Αποστολή σχολίου',
        'SIGN_OUT' => 'έξοδος',
        'SIGN_OUT_TITLE' => 'Έξοδος',
        'EDIT_MY_PROFILE' => 'Επεξεργασία απαντήσεων προφίλ',
        'INVITE_MORE' => 'Προσκαλέστε περισσότερους',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Χρησιμοποιήστε αυτή τη φόρμα για να στείλετε σχόλια στον/στην <a %s>%s</a>, δημιουργό του <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Το σχόλιό σας',
        'NETWORK_INFORMATION' => 'Πληροφορίες δικτύου',
        'ABOUT_YOUR_SITE' => 'Πληροφορίες για το δίκτυο σας',
        'WELCOME_TO_YOUR_SITE' => 'Καλωσορίσατε στο κοινωνικό σας δίκτυο!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Επεξεργαστείτε το όνομα του δικτύου σας, την περιγραφή και άλλες πληροφορίες.',
        'TAGLINE' => 'Γραμμή ετικέτας',
        'APPEARS_IN_HEADER' => 'Εμφανίζεται στην κεφαλίδα του δικτύου σας.',
        'APPEARS_IN_EMAILS' => 'Εμφανίζεται στα μηνύματα του ηλεκτρονικού ταχυδρομείου και αλλού',
        'NETWORK_NAME' => 'Όνομα δικτύου',
        'DESCRIPTION' => 'Περιγραφή',
        'KEYWORDS' => 'Λέξεις-κλειδιά',
        'LANGUAGE' => 'Γλώσσα',
        'SEPARATE_EACH_KEYWORD' => 'Διαχωρίστε την κάθε λέξη-κλειδί με κόμμα.',
        'ICON' => 'Εικονίδιο',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Στείλτε μια φωτογραφία (GIF, JPG ή PNG), της οποίας το μέγεθος θα αλλάξει σε τετράγωνο.  Μπορεί να χρειαστεί να περάσουν ορισμένα λεπτά μέχρι να εμφανιστεί αυτή η φωτογραφία.',
        'SAVE_SETTINGS' => 'Αποθήκευση ρυθμίσεων',
        'SUCCESS_EXCLAMATION' => 'Επιτυχία!',
        'FEATURES' => 'Χαρακτηριστικά',
        'ADD_FEATURES' => 'Προσθέστε χαρακτηριστικά στο δίκτυό σας',
        'ORGANIZE_FEATURES' => 'Οργανώστε την αρχική σελίδα σας σύροντας χαρακτηριστικά από την παρακάτω λίστα, έπειτα τακτοποιήστε τα όπως επιθυμείτε.',
        'SKIP_FEATURES' => 'Κάνετε κλικ <a href="%s">Παράλειψη αυτού του βήματος</a> για να συνεχίσετε με την προεπιλεγμένη διάταξη και χαρακτηριστικά.',
        'FEATURES_FOR_ALL_PAGES' => 'Τα χαρακτηριστικά που προστέθηκαν σε αυτό το πλαίσιο θα εμφανιστούν σε όλες τις σελίδες του δικτύου σας.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Προσαρμόστε το κοινωνικό σας δίκτυο προσθέτοντας καινούργια χαρακτηριστικά ή καταργώντας τα υπάρχοντα.',
        'ADJUST_YOUR_SITES_COLORS' => 'Ρυθμίστε τα χρώματα, τις εικόνες και το γενικό στυλ του δικτύου σας.',
        'APPEARANCE' => 'Εμφάνιση',
        'PROFILE_QUESTIONS' => 'Ερωτήσεις του προφίλ',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Επεξεργαστείτε τις ερωτήσεις που απάντησαν τα μέλη σχετικά με τους ίδιους.',
        'MESSAGE_SENT' => 'Το μήνυμα εστάλη!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Το μήνυμά σας έχει σταλεί σε όλα τα μέλη του δικτύου.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Το μήνυμά σας έχει σταλεί σε όλα τα μέλη της ομάδας σας.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Το μήνυμά σας αποστέλλεται.  Περιμένετε επειδή μπορεί να χρειαστεί να περάσουν ορισμένα λεπτά.',
        'BROADCAST_MESSAGE' => 'Εκπεμπόμενο μήνυμα',
        'TRACK_VISITORS_AND_TRENDS' => 'Παρακολουθήστε επισκέπτες και τάσεις στο κοινωνικό σας δίκτυο.',
        'EDIT_SOURCE_CODE' => 'Επεξεργαστείτε τον κωδικό τροφοδοσίας',
        'TAKE_FULL_CONTROL' => 'Αποκτήστε τον πλήρη έλεγχο της λειτουργικότητας του δικτύου σας με την επεξεργασία του πηγαίου κώδικα.',
        'DELETE_THIS_SITE' => 'Διαγράψετε το κοινωνικό σας δίκτυο',
        'MAIN_PAGE' => 'Αρχική σελίδα',
        'MAIN' => 'Αρχική',
        'MAIN_TAB_TEXT' => 'Αρχική',
        'MANAGE' => 'Διαχείριση',
        'MANAGE_TAB_TEXT' => 'Διαχείριση',
        'PAGE_TITLE' => 'Τίτλος σελίδας',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit.  Nunc scelerisque blandit dolor.  Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Επεξεργαστείτε την εμφάνιση της σελίδας σας',
        'CHOOSE_A_THEME' => 'Επιλέξτε ένα θέμα για το κοινωνικό σας δίκτυο',
        'NOW_CUSTOMIZE_SITE' => 'Τώρα προσαρμόστε το κοινωνικό σας δίκτυο...',
        'THEME_SETTINGS' => 'Ρυθμίσεις θέματος',
        'ADVANCED' => 'Για προχωρημένους',
        'TOP_BAR_AND_FOOTER' => 'Πάνω γραμμή & υποσέλιδο',
        'HEADER_AND_NAVIGATION' => 'Κεφαλίδα & Πλοήγηση',
        'ADD_A_LOGO' => 'Προσθήκη λογότυπου',
        'THIS_IMAGE_WILL_REPLACE' => 'Αυτή η εικόνα θα αντικαταστήσει το κείμενο του ονόματος του δικτύου',
        'TABS' => 'Καρτέλες',
        'TAB' => 'Καρτέλα',
        'SITE' => 'Δίκτυο',
        'SIDES' => 'Πλευρές',
        'BODY' => 'Σώμα',
        'SHOW_NING_LOGO' => 'Εμφάνιση του λογότυπου Ning;',
        'LAUNCH' => 'ΕΚΚΙΝΗΣΗ!',
        'NING_ID' => 'Αναγνωριστικό Ning',
        'PASSWORD' => 'Κωδικός πρόσβασης',
        'RETYPE_PASSWORD' => 'Πληκτρολογήστε ξανά τον κωδικό πρόσβασης',
        'TYPE_CODE_ON_RIGHT' => 'Πληκτρολογήστε τον κωδικό<br />στα δεξιά',
        'JOIN_X' => 'Γίνετε μέλος στο %s',
        'SIGN_UP_FOR_X' => 'Εγγραφή στο %s',
        'HAS_INVITED_YOU_TO_X' => 'σας έχει προσκαλέσει να γίνετε μέλος στο %s',
        'CONTENT_AWAITING_APPROVAL' => 'Αναμονή έγκρισης',
        'NEW_MEMBER' => 'Νέο μέλος;',
        'JOIN_X_NOW' => 'Γίνετε μέλος στο %s τώρα!',
        'HIDE_THIS_MESSAGE' => 'Αποκρύψτε αυτό το μήνυμα',
        'PAGE_NOT_FOUND' => 'Η σελίδα δεν βρέθηκε',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Λυπούμαστε, δεν βρέθηκε αυτή η σελίδα',
        'FOLLOW_THESE_LINKS_TO' => 'Ακολουθήστε αυτές τις συνδέσεις σε ορισμένα καινούργια στοιχεία που ξέρουμε ότι είναι διαθέσιμα:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Εναλλακτικά, μπορείτε να προβείτε σε αναζήτηση σε αυτό το κοινωνικό δίκτυο:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Εάν λάβετε αυτό το μήνυμα ξανά, <a %s>ενημερώστε μας. </a>',
        'GROUP_MEMBERS' => 'Μέλη ομάδας',
        'VIDEOS' => 'Βίντεο',
        'BLOG' => 'Ιστολόγιο',
        'ACCOUNT' => 'Λογαριασμός',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Λυπούμαστε, αντιμετωπίζουμε πρόβλημα με αυτή τη σελίδα.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Ακολουθήστε <a %s>αυτή τη σύνδεση</a> στην αρχική σελίδα.',
        'REQUEST_AN_INVITATION' => 'Ζητήστε μια πρόσκληση',
        'NAME' => 'Όνομα',
        'EMAIL_ADDRESS' => 'Διεύθυνση ηλεκτρονικού ταχυδρομείου',
        'MESSAGE_OPTIONAL' => 'Μήνυμα (Προαιρετικό)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Λυπούμαστε! </strong>  Είναι εύκολο, ωστόσο, να αρχίσετε το δικό σας κοινωνικό δίκτυο.',
        'GET_YOUR_OWN_BAZEL' => 'Δημιουργήστε το δικό σας κοινωνικό δίκτυο!',
        'SITE_IS_NOT_READY' => 'Αυτό το κοινωνικό δίκτυο δεν είναι έτοιμο ακόμη!',
        'BAZEL_IS_BEING_SET_UP' => 'Αυτό το κοινωνικό δίκτυο βρίσκεται ακόμη υπό δημιουργία!',
        'SIGN_IN' => 'Είσοδος',
        'FORGOT_YOUR_PASSWORD' => 'Ξεχάσετε τον κωδικό πρόσβασή σας;',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Ξεχάσετε τον κωδικό πρόσβασή σας;',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Εισάγετε την διεύθυνση του ηλεκτρονικού ταχυδρομείου σας και κάνετε κλικ στο \'Επαναφορά κωδικού πρόσβασης\'.  Θα λάβετε ένα μήνυμα ηλεκτρονικού ταχυδρομείου με μια σύνδεση για να επαναφέρετε τον κωδικό πρόσβασής σας.',
        'RESET_PASSWORD' => 'Επαναφορά κωδικού πρόσβασης',
        'EXPLORE' => 'Εξερεύνηση',
        'SIGN_UP' => 'Εγγραφή',
        'CONFIRM_PASSWORD' => 'Επιβεβαίωση κωδικού πρόσβασης',
        'VERIFICATION' => 'Ενημερώστε μας ότι είστε <br />ένα άτομο',
        'YOUR_PHOTO' => 'Η φωτογραφία σας',
        'SUMMARY' => 'Σύνοψη',
        'YOUR_SITE_IS_READY' => 'Το κοινωνικό σας δίκτυο είναι έτοιμο να ξεκινήσει!   Οι προεπιλεγμένες ρυθμίσεις θα χρησιμοποιηθούν για όποια βήματα έχετε παραλείψει.  Επιστρέψτε πίσω για να κάνετε αλλαγές, ή κάντε κλικ στο \'Εκκίνηση! \' για να γίνει εκκίνηση του δικτύου σας.',
        'WHEN_YOU_ARE_FINISHED' => 'Όταν τελειώσετε, κάνετε κλικ \'Προβολή διάταξης\' για να δείτε τη δουλειά σας!',
        'COMPLETE' => 'ολοκληρωμένο',
        'INCOMPLETE' => 'ατελές',
        'VIEW_LAYOUT' => 'Προβολή διάταξης',
        'CLEAR_CONTENTS' => 'Απαλοιφή σχολίων',
        'ADD_MODULE' => 'Προσθήκη ενότητας...',
        'ADD_COLUMNS' => 'Προσθήκη στηλών...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Δημόσιο</strong>  – Μπορεί οποιοσδήποτε να γίνει μέλος',
        'PRIVATE_ONLY_INVITED' => '<strong>Ιδιωτικό</strong> – Μπορεί να προβληθεί και να γίνουν μέλη σε αυτό μόνο προσκεκλημένα άτομα',
        'INVITATIONS' => 'Προσκλήσεις',
        'MEMBERS_CAN_INVITE' => 'Τα μέλη μπορούν να προσκαλέσουν άλλα άτομα για να γίνουν μέλη.',
        'QUESTION_TITLE' => 'Τίτλος ερώτησης',
        'ANSWER_TYPE' => 'Τύπος απάντησης',
        'REQUIRED' => 'Απαιτείται',
        'PRIVATE' => 'Ιδιωτικό',
        'CHOICES' => 'Επιλογές',
        'SEPARATE_EACH_CHOICE' => 'Διαχωρίστε την κάθε επιλογή με κόμμα.',
        'CAN_PICK_MORE' => 'Μπορεί να επιλεγούν περισσότερα από ένα',
        'ADD_ANOTHER_QUESTION' => 'Προσθέστε και άλλη ερώτηση',
        'WHAT_INFORMATION' => 'Σε ποιες ερωτήσεις θα επιθυμούσατε να απαντήσουν τα μέλη σας όταν γίνουν μέλη στο δίκτυό σας;  Μπορείτε να αλλάξετε τη σειρά των παρακάτω ερωτήσεων.  Απλά κάνετε κλικ στην ερώτηση και σύρετέ την εκεί όπου θέλετε να εμφανιστεί.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Εάν επιλέξετε "Απαιτείται", τα μέλη θα πρέπει να απαντήσουν στην ερώτηση για να γίνουν μέλη.  Εάν επιλέξετε "Ιδιωτικό", η απάντηση θα είναι ορατή μόνο σε σας και τους άλλους διαχειριστές.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Δεν μπορέσαμε να βρούμε κάτι που να ταιριάζει στο "%s".  Γιατί δεν κάνετε αναζήτηση για κάτι άλλο;',
        'GET_CUSTOM_URL' => 'Αποκτήστε την δική σας προσαρμοσμένη διεύθυνση URL, προσθέστε χώρο αποθήκευσης και εύρος ζώνης ή τρέξτε τις δικές διαφημίσεις.',
        'VIEW_STATISTICS' => 'Προβολή στατιστικών στοιχείων',
        'ADD_TRACKING_CODE' => '<a %s>Προσθέστε το δικό σας κωδικό παρακολούθησης</a>.',
        'TRACKING_CODE' => 'Κωδικός παρακολούθησης',
        'ANY_JAVASCRIPT_CODE' => 'Ο οποιοδήποτε κωδικός JavaScript που επικολλάτε εδώ μπαίνει στο κάτω μέρος κάθε σελίδας του δικτύου σας.  Μπορείτε να το χρησιμοποιήσετε για συστήματα εξωτερικής παρακολούθησης της τοποθεσίας, όπως το Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Για να μάθετε περισσότερα σχετικά με το Google Analytics και να δημιουργήσετε το δικό σας λογαριασμό, <a %s>κάντε κλικ εδώ</a>.',
        'RESOURCES' => 'Πόροι',
        'LINKS' => 'Συνδέσεις',
        'PAGE' => 'Σελίδα',
        'BACKGROUND' => 'Φόντο',
        'TEXT' => 'Κείμενο',
        'HEADING_TEXT' => 'Κείμενο τίτλου',
        'FONT' => 'Γραμματοσειρά',
        'AABBCC' => 'AαBβΓγ',
        'COLOR' => 'Χρώμα',
        'LINK_COLOR' => 'Χρώμα σύνδεσης',
        'BODY_TEXT' => 'Σώμα κειμένου',
        'MIDDLE' => 'Μέσον',
        'FEATURE_BOXES' => 'Πλαίσια χαρακτηριστικών',
        'TITLEBAR_TEXT_COLOR' => 'Χρώμα κειμένου γραμμής τίτλου',
        'TITLEBAR_BACKGROUND' => 'Φόντο γραμμής τίτλου',
        'UPLOADING_CONTENT' => 'Αποστολή περιεχομένου...',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Όταν ολοκληρωθεί η αποστολή, μπορείτε να δοκιμάσετε το δίκτυο',
        'FINISH' => 'Τέλος',
        'FLICKR_IMPORT_SETUP' => 'Διαμόρφωση εισαγωγής Flickr',
        'FLICKR_API_KEY' => 'Το κλειδί σας',
        'FLICKR_SECRET' => 'Ο Κρυφός κωδικός σας',
        'FLICKR_KEY_ERROR' => 'Υπήρξε πρόβλημα με το κλειδί Flickr ή με τον κρυφό κωδικό που εισαγάγατε.   Μπορείτε να τα ελέγξετε και να προσπαθήστε να τα εισάγετε ξανά;',
        'FLICKR_INTRO' => 'Επιθυμείτε να επιτρέψετε στα μέλη σας να εισάγουν τις φωτογραφίες τους από το Flickr;  Έχετε έρθει στο σωστό μέρος.  Εάν ήδη έχετε ένα Κλειδί και Κρυφό κωδικό Flickr API, μπορείτε να <a %s>παραλείψετε αυτό το βήμα και να προχωρήσετε</a>.  Δεν είστε σίγουροι τί σημαίνει αυτό;  Απλά ακολουθήστε τα παρακάτω βήματα και θα είστε έτοιμοι να ξεκινήσετε μέσα σε μόλις λίγα λεπτά.',
        'FLICKR_GET_ACCOUNT' => 'Εάν δεν έχετε ήδη ένα λογαριασμό Flickr, αποκτήστε έναν <a %s>εδώ</a>.',
        'FLICKR_STEP1_TITLE' => 'Βήμα 1: Αποκτήστε ένα Κλειδί Flickr API',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Ζητήστε την εικόνα του API κλειδιού σας στο Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'Οθόνη κλειδιού API στο Flickr',
        'FLICKR_STEP1_INTRO' => 'Συνδεθείτε στο Flickr και <a %s>κάντε αίτηση για ένα καινούργιο κλειδί API </a> (ανοίγει σε καινούργιο παράθυρο).',
        'FLICKR_STEP1_A' => 'Συμπληρώστε <strong>Το όνομά σας</strong> και την <strong>Διεύθυνση ηλεκτρονικού ταχυδρομείου</strong>.',
        'FLICKR_STEP1_B' => 'Κάτω <strong>Αυτό το κλειδί είναι για&hellip. </strong> επιλέξτε την επιλογή<em>μη εμπορική χρήση</em> option.',
        'FLICKR_STEP1_C' => 'Περιγράψετε το κοινωνικό σας δίκτυο στο πλαίσιο <strong>Περιγράψετε την εφαρμογή που πρόκειται να δημιουργήσετε</strong>.',
        'FLICKR_STEP1_D' => 'Επιλέξτε και τα δυο πλαίσια αποδοχής.',
        'FLICKR_STEP1_APPLY' => 'Όταν τελειώσετε, κάντε κλικ στο κουμπί <strong>Εφαρμογή</strong>.',
        'FLICKR_STEP1_E' => 'Θα μεταβείτε σε μια οθόνη που εμφανίζει το καινούργιο σας κλειδί API.  Κάνετε κλικ στη σύνδεση<strong>Κάντε κλικ εδώ</strong> για την διαμόρφωση του ελέγχου ταυτότητας του χρήστη για αυτό το κλειδί.',
        'FLICKR_STEP2_TITLE' => 'Βήμα 2: Διαμορφώστε το κλειδί σας',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Οθόνη διαμόρφωσης ελέγχου ταυτότητας κλειδιού API στο Flickr',
        'FLICKR_STEP2_F' => 'Επικολλήστε την παρακάτω διεύθυνση Web στο πεδίο <strong>Επανάκληση διεύθυνσης URL</strong>:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Όταν τελειώσετε, κάντε κλικ στο κουμπί <strong>Αποθήκευση αλλαγών</strong>.',
        'FLICKR_STEP3_TITLE' => 'Βήμα 3: Εισάγετε τα στοιχεία σας',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Οθόνη πληροφοριών κλειδιού API στο Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Συγχαρητήρια!  Τώρα είναι έτοιμη η διαμόρφωση σας στο Flickr.',
        'FLICKR_STEP3_COMPLETE' => 'Για να ολοκληρώσετε τη διαμόρφωση στο %s, απλά αντιγράψετε και επικολλήστε το κλειδί σας και τον κρυφό κωδικό στα παρακάτω πεδία:',
        'COMPLETE_SETUP' => 'Ολοκλήρωση διαμόρφωσης',
        'SETUP_YOUR_SITE_TO' => 'Διαμορφώστε το κοινωνικό σας δίκτυο για την εισαγωγή φωτογραφιών από το Flickr.',
        'FLICKR_IMPORTING' => 'Εισαγωγή Flickr',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Πρέπει να διαμορφώσετε το κοινωνικό σας δίκτυο για να επιτρέψετε στα άτομα να εισάγουν τις φωτογραφίες τους από το Flickr.  Απαιτεί μόνο μερικά λεπτά, γιατί δεν <a %s>το διαμορφώνετε τώρα; </a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Μη μου το δείξετε αυτό ξανά.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Έχετε αποσυνδεθεί από το %s με επιτυχία.  Παρακαλώ επιστρέψτε και γίνετε πάλι μέλη στο δίκτυό μας σύντομα!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'δημιούργησε αυτό το κοινωνικό δίκτυο στο <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Δημιουργήστε το δικό σας κοινωνικό δίκτυο στο Ning δωρεάν!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Σύρετε εδώ για να καταργήσετε το χαρακτηριστικό',
        'LAYOUT' => 'Διάταξη',
        'DRAG' => 'Σύρετε',
        'HERE' => 'Εδώ',
        'YOU' => 'Εσείς',
        'ADS' => 'Διαφημιστικά',
        'MEMBERS' => 'Μέλη',
        'HELLO_USERNAME' => 'Γεια σου Όνομα χρήστη',
        'CREATED_BY' => 'Δημιουργήθηκε από',
        'SAVE_FEATURES' => 'Αποθήκευση χαρακτηριστικών',
        'FORUM' => 'Φόρουμ',
        'CATEGORIES' => 'Κατηγορίες',
        'FORUM_CATEGORIES' => 'Κατηγορίες φόρουμ',
        'A_THREADED_DISCUSSION_FORUM' => 'Φόρουμ συζήτησης με νήματα',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Δώστε την δυνατότητα στα μέλη να δημιουργήσουν τις δικές τους ομάδες ενδιαφέροντος μέσα στο δίκτυό σας.',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Προβάλετε καταχωρήσεις από το δικό σας ιστολόγιο ή από τα ιστολόγια άλλων μελών',
        'TEXT_BOX' => 'Πλαίσιο κειμένου',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Εισάγετε οποιοδήποτε κείμενο, γραφικό στοιχείο ή HTML στην αρχική σελίδα',
        'A_LIST_OF_MEMBERS' => 'Λίστα με τα μέλη του κοινωνικού σας δικτύου',
        'ALLOW_USERS_PHOTOS' => 'Δώστε τη δυνατότητα σε άτομα να αποστέλλουν και να μοιράζονται φωτογραφίες',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Προσθέστε τροφοδοσίες από το Web',
        'INFORMATION_ABOUT_THE_USER' => 'Πληροφορίες για το άτομο που είναι τώρα συνδεδεμένο',
        'ALLOW_USERS_VIDEOS' => 'Δώστε τη δυνατότητα στα άτομα να αποστέλλουν και να μοιράζονται βίντεο',
        'SHOW_NETWORK_DESCRIPTION' => 'Εμφανίστε την περιγραφή του δικτύου σας',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Προωθείστε το δίκτυό σας στο Web με προσαρμοσμένα διακριτικά και γραφικά στοιχεία',
        'MONETIZE_WITH_ADS' => 'Αξιοποιήστε οικονομικά το δίκτυό σας μέσω της διαφήμισης',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Γνωστοποιήστε στα μέλη σας ποιος δημιούργησε αυτό το δίκτυο',
        'FOLLOW_LATEST_ACTIVITY' => 'Ακολουθήστε την δραστηριότητα του τελευταίου μέλους στο δίκτυό σας',
        'FAQ_FOR_NETWORK_CREATORS' => 'Συχνές ερωτήσεις για τους δημιουργούς του δικτύου',
        'ANSWERS_TO_FAQS' => 'Απαντήσεις στις συχνές ερωτήσεις σχετικά με την προσαρμογή του κοινωνικού σας δικτύου',
        'MEET_OTHER_LIKEMINDED' => 'Συναντήστε άλλους δημιουργούς δικτύων με ανάλογη δημιουργική σκέψη, μοιραστείτε ιδέες και λάβετε υποστήριξη από την ομάδα της Ning',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Προσαρμόστε την εμφάνιση του κοινωνικού σας δικτύου προσθέτοντας τα δικά σας επικαλυπτόμενα φύλλα στυλ (CSS) στο πεδίο αριστερά.  (<a href="%s">Τί είναι τα επικαλυπτόμενα φύλλα στυλ (CSS)</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Προσαρμόστε την εμφάνιση της σελίδας σας προσθέτοντας τα δικά σας επικαλυπτόμενα φύλλα στυλ (CSS) στο πεδίο αριστερά.  (<a href="%s">Τί είναι τα επικαλυπτόμενα φύλλα στυλ (CSS) </a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'Τα επικαλυπτόμενα φύλλα στυλ στο κοινωνικό σας δίκτυο',
        'CSS_ON_YOUR_PAGE' => 'Τα επικαλυπτόμενα φύλλα στυλ στη σελίδα σας',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Η προσθήκη των δικών σας επικαλυπτόμενων φύλλων στυλ σας δίνει τον πλήρη έλεγχο των γραμματοσειρών, του χρώματος, των διαστημάτων και του γενικού στυλ του δικτύου σας.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Η προσθήκη των δικών σας επικαλυπτόμενων φύλλων στυλ στη σελίδα σας, σας δίνει τον πλήρη έλεγχο των γραμματοσειρών, του χρώματος, των διαστημάτων και του γενικού στυλ της σελίδας σας.',
        'CSS_STYLES_WILL_OVERRIDE' => 'Τα επικαλυπτόμενα φύλλα στυλ που προσθέσατε εδώ θα παρακάμψουν οποιαδήποτε υπάρχοντα επικαλυπτόμενα φύλλα στυλ που μπορεί να είχατε ήδη επιλέξει.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Χρειάζεστε βοήθεια για να σκεφτείτε το όνομα μιας ειδικής κατηγορίας επικαλυπτόμενων φύλλων στυλ στο δίκτυό σας;  Σας προτείνουμε το χαρακτηριστικό "Επιθεώρηση" της δωρεάν <a href="%s">Firebug</a> επέκτασης (για το πρόγραμμα περιήγησης Firefox).',
        'WANT_TO_LEARN_MORE' => 'Θέλετε να μάθετε περισσότερα;  Δοκιμάστε την ενότητα <a href="%s">Προηγμένη προσαρμογή</a>.',
        'APPLY_XS_THEME' => 'Εφαρμόστε το θέμα του %s',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'Υπάρχει ήδη ένα αναγνωριστικό Ning καταχωρημένο με την διεύθυνση ηλεκτρονικού ταχυδρομείου %s.  Συνδεθείτε παρακάτω με το αναγνωριστικό Ning σας ή με την διεύθυνση του ηλεκτρονικού ταχυδρομείου σας.  Εάν έχετε ξεχάσει τον κωδικό πρόσβασής σας, <a href="%s">κάντε κλικ εδώ για να επαναφέρετε τον κωδικό σας</a>.',
        'INVITED' => 'Προσκεκλημένος',
        'REQUESTED_INVITE' => 'Ζητήθηκε πρόσκληση',
        'BAN_FROM_NETWORK' => 'Απαγόρευση από το δίκτυο',
        'REMOVE_BAN' => 'Κατάργηση απαγόρευσης',
        'CANCEL_INVITATION' => 'Ακύρωση πρόσκλησης',
        'IGNORE' => 'Αγνόηση',
        'PROMOTE_TO_ADMINISTRATOR' => 'Προαγωγή σε διαχειριστή',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Υποβίβαση από διαχειριστή',
        'STATUS' => 'Κατάσταση',
        'DATE_JOINED' => 'Ημερομηνία ιδιότητας μέλους',
        'DATE_INVITED' => 'Ημερομηνία πρόσκλησης',
        'DATE_REQUESTED' => 'Ημερομηνία αίτησης',
        'DATE_APPLIED' => 'Ημερομηνία εφαρμογής',
        'NETWORK_CREATOR' => 'Δημιουργός δικτύου',
        'NETWORK_ADMINISTRATOR' => 'Διαχειριστής',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Οι διαχειριστές έχουν παρόμοιο επίπεδο ελέγχου με τον δημιουργό του δικτύου.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Εξαγωγή όλων των δεδομένων των μελών (. CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Τα δεδομένα μέλους σας έχουν εξαχθεί. Κάνετε κλικ σε <a %s>αυτή τη σύνδεση</a> για να τα αποθηκεύσετε στην επιφάνεια εργασίας σας.',
        'CLICK_GO_TO_START_EXPORT' => 'Κάνετε κλικ στο Μετάβαση για να αρχίσει η εξαγωγή.   Εάν έχετε πολλά μέλη, η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'MEMBER' => 'Μέλος',
        'INVITED_BY_X' => 'Προσκλήθηκε από %s',
        'DONE' => 'Τέλος',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Έχετε αποκλειστεί από το %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Μήνυμα στο διαχειριστή',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Λυπούμαστε, %s, δεν έχετε πρόσβαση στο %s καθώς έχετε αποκλειστεί. Εάν νομίζετε ότι έχετε αποκλειστεί κατά λάθος, μπορείτε να επικοινωνήσετε με το διαχειριστή.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Λυπούμαστε, %s, δεν σας επιτρέπεται η πρόσβαση στο %s επειδή έχετε αποκλειστεί.',
        'SORRY_USERNAME' => 'Λυπούμαστε, %s',
        'PENDING' => 'Σε εκκρεμότητα',
        'ACCEPT' => 'Αποδοχή',
        'PENDING_APPROVAL' => 'Έγκριση σε εκκρεμότητα',
        'ACCEPT_MEMBERSHIP' => 'Έγκριση ιδιότητας μέλους',
        'DECLINE_MEMBERSHIP' => 'Απόρριψη ιδιότητας μέλους',
        'NO_PAGE_YET' => 'Καμιά σελίδα ακόμη',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Εκκρεμεί η έγκρισή σας να γίνεται μέλος στο %s από τους διαχειριστές.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Έγκριση ιδιότητας μέλους σε εκκρεμότητα',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Η έγκριση του προφίλ σας βρίσκεται σε εκκρεμότητα.',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Οι λεπτομέρειες του προφίλ σας πρέπει να εγκριθούν από το διαχειριστή πριν γίνετε μέλος του %s.  Θα λάβετε ένα μήνυμα ηλεκτρονικού ταχυδρομείου μόλις εγκριθεί το προφίλ σας.',
        'CONTINUE_ARROW' => 'Continue →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Επιστροφή στα μέλη υπό εκκρεμότητα',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => 'Ο/Η %s περιμένει έγκριση για να γίνει μέλος του %s.',
        'VIEW_PAGE' => 'Προβολή σελίδας',
        'MESSAGE' => 'Μήνυμα',
        'SEND_MESSAGE' => 'Αποστολή μηνύματος',
        'MANAGE_FORUM_CATEGORIES' => 'Διαχειριστείτε τις κατηγορίες των τόπων συζήτησης',
        'START_DISCUSSIONS' => 'Εκκίνηση συζητήσεων',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Καλωσορίσατε στο δικό σας νέο κοινωνικό δίκτυο.',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Τώρα το μόνο που χρειάζεται να κάνετε είναι να <a %s>προσκαλέσετε τους φίλους σας</a>!',
        'CONTRIBUTE' => 'Συνεισφορά.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Προσαρμογή. </strong> Προσαρμόστε <a %1$s>την εμφάνιση του δικτύου</a> και σχεδιάστε <a %2$s>διακριτικά και γραφικά στοιχεία</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Έλεγχος. </strong>  Η σελίδα <a %s>διαχείρισης</a> φιλοξενεί διάφορες επιλογές διαμόρφωσης.',
        'CREATE_GROUPS' => 'Δημιουργία ομάδων',
        'INVITE_MORE_PEOPLE' => 'Προσκαλέστε περισσότερα άτομα',
        'VIEW_THREAD' => 'Προβολή νήματος',
        'COMMENT_THREAD' => 'Νήμα σχολίων',
        'COMMENT_BACK' => 'Απάντηση σε σχόλιο',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Γεια σας, χρειάζεται να ενεργοποιήσετε το JavaScript για να χρησιμοποιήσετε αυτό το δίκτυο.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Παρακαλώ ελέγξτε τις ρυθμίσεις του προγράμματος περιήγησης σας ή επικοινωνήστε με τον διαχειριστή του συστήματός σας.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Διαχείριση μελών, Διαχειριστών, προσκεκλημένων και αποκλεισμένων ατόμων.',
        'MANAGE_MEMBERS' => 'Διαχείριση μελών',
        'MANAGE_INVITED_PEOPLE' => 'Διαχείριση προσκεκλημένων ατόμων',
        'NETWORK_SETTINGS' => 'Ρυθμίσεις δικτύου',
        'PROMOTE_YOUR_NETWORK' => 'Προώθηση του δικτύου σας',
        'NING_RESOURCES' => 'Πόροι Ning',
        'ADD_PREMIUM_SERVICES' => 'Προσθέστε διακεκριμένες υπηρεσίες',
        'REQUEST_SOURCE_CODE' => 'Ζητήστε πρόσβαση στον πηγαίο κώδικα',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Μηχανικοί λογισμικού: Ζητήστε πρόσβαση στον πηγαίο κώδικα με τον οποίο λειτουργεί το δίκτυό σας',
        'JOIN_NETWORK_CREATORS' => 'Γίνετε μέλος των δημιουργών δικτύου',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Στείλτε μήνυμα σε όλα τα μέλη αυτού του δικτύου.',
        'CREATE_ANOTHER_NETWORK' => 'Δημιουργήστε ένα άλλο δίκτυο',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Έχετε κάποια άλλη καταπληκτική ιδέα για κοινωνικό δίκτυο;',
        'ALLOW_FACEBOOK_USERS_TO' => 'Επιτρέψετε στους χρήστες του Facebook να βάλουν τα γραφικά στοιχεία του δικτύου σας στις σελίδες του προφίλ τους.',
        'BADGES_AND_WIDGETS' => 'Διακριτικά & γραφικά στοιχεία',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Προσαρμόστε την εμφάνιση των γραφικών στοιχείων και των διακριτικών του δικτύου σας.',
        'GET_BADGES' => 'Απόκτηση διακριτικών',
        'CUSTOM_TEXT' => 'Προσαρμογή κειμένου',
        'IM_A_MEMBER_OF' => 'Είμαι μέλος του:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Μην εμφανίσετε κανένα εμπορικό σήμα',
        'WATERMARK_OR_LOGO_IMAGE' => 'Εικόνα Υδατογραφήματος ή λογότυπου:',
        'NETWORK_BRANDING_BADGES' => 'Εμπορικά σήματα δικτύου: Διακριτικά',
        'NETWORK_BRANDING_WIDGETS' => 'Εμπορικά σήματα δικτύου: Γραφικά στοιχεία',
        'LOGO_IMAGE' => 'Εικόνα λογοτύπου',
        'SMALL_NETWORK_BADGE' => 'Διακριτικό μικρού δικτύου',
        'LARGE_NETWORK_BADGE' => 'Διακριτικό μεγάλου δικτύου',
        'REFRESH' => 'Ανανέωση',
        'HTML_EMBED_CODE' => 'Ενσωματωμένος κώδικας HTML:',
        'CUSTOMIZE' => 'Προσαρμογή',
        'SHARE_TITLE' => 'Κοινή χρήση \'%s\'',
        'SHARE_TYPE' => 'Κοινή χρήση %s',
        'YOUR_MESSAGE_SENT' => 'Το μήνυμά σας έχει σταλεί με επιτυχία.',
        'YOUR_MESSAGES_SENT' => 'Τα μηνύματά σας έχουν σταλεί με επιτυχία.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Μπορείτε να κάνετε κοινή χρήση αυτού του %s με δυο τρόπους &#8230.',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Δοκιμάστε αυτό το %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Δοκιμάστε αυτό το %s',
        'PHOTO_ALBUM' => 'άλμπουμ φωτογραφιών',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Προσαρμόστε τα διακριτικά και τα γραφικά στοιχεία σας με τις δικές σας επιλογές χρώματος και εικόνων.  Μπορεί να χρειαστούν έως 4 ώρες για να εμφανιστούν οι αλλαγές σας σε άλλες τοποθεσίες Web.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Εικόνα & χρώμα φόντου',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Χρησιμοποιήστε αυτή τη φόρμα για να αναφέρετε ένα πρόβλημα στον/στην <a %s>%s</a>, δημιουργό του <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Λυπούμαστε, οι δημιουργοί του δικτύου δεν μπορούν να αλλάξουν τις διευθύνσεις του ηλεκτρονικού ταχυδρομείου τους μέσω δικτύων που δεν τους ανήκουν.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Λυπούμαστε, οι δημιουργοί του δικτύου δεν μπορούν να αλλάξουν τους κωδικούς πρόσβασής τους μέσω δικτύων που δεν τους ανήκουν.',
        'GO' => 'Μετάβαση',
        'LARGE_THUMBNAILS' => 'Μεγάλες μικρογραφίες',
        'SMALL_THUMBNAILS' => 'Μικρές μικρογραφίες',
        'RECENTLY_JOINED' => 'Το πιο πρόσφατο',
        'MOST_POPULAR_MEMBERS' => 'Πιο δημοφιλές',
        'NO_MEMBERS_TO_DISPLAY' => 'Προς το παρόν, δεν εμφανίζετε κανένα μέλος',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί σε άλλα άτομα εκτός και αν επιλέξετε τουλάχιστον μια σειρά.',
        'DETAIL_VIEW' => 'Προβολή λεπτομερειών',
        'TITLES_ONLY' => 'Μόνο τίτλοι',
        'RECENTLY_ADDED_POSTS' => 'Προστέθηκε πρόσφατα',
        'POPULAR_POSTS' => 'Περισσότερα σχόλια',
        'PROMOTED_POSTS' => 'Χαρακτηριστικό',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί για άλλα άτομα εκτός και αν επιλέξετε τουλάχιστον μια καταχώρηση.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Κρατήστε ανοικτό αυτό το παράθυρο του προγράμματος περιήγησης όσο συνεχίζεται η αποστολή.',
        'CANCEL_UPLOAD' => 'Ακύρωση αποστολής',
        'YOU_DO_NOT_HAVE_POSTS' => 'Δεν έχετε γράψει καμία καταχώρηση ακόμη.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Δεν έχετε σχόλια για έγκριση.',
        'REQUIRED_FIELD' => '(Απαιτούμενο πεδίο)',
        'BLOG_POST_BY_X' => 'Καταχώρηση ιστολογίου από τον/την %s',
        'HELLO' => 'Γεια σας,',
        'ADDED_BY_X' => 'Προστέθηκε από τον/την %s',
        'CLICK_TO_ADD_A_TITLE' => 'κάντε κλικ για να προσθέσετε τίτλο',
        'DELETE_BLOG_POST' => 'Διαγραφή καταχώρησης',
        'DELETE_THIS_BLOG_POST_Q' => 'Διαγραφή της καταχώρησης ιστολογίου;',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτή την καταχώρηση ιστολογίου;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Εισαγάγετε κάτι για το: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Ορίστε μια επιλογή για το: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Εισάγετε μια έγκυρη ημερομηνία για το: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Εισάγετε μια ημερομηνία για το: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => 'Καταχωρήσεις ιστολογίου του/της %s για %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Προβεβλημένες καταχωρήσεις ιστολογίου για %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Καταχωρήσεις ιστολογίου για %s %s',
        'FEATURED_BLOG_POSTS' => 'Προβεβλημένες καταχωρήσεις ιστολογίου',
        'EVERYONES_POSTS' => 'Καταχωρήσεις ιστολογίου όλων',
        'PUBLISHED_N_OF_N' => 'Δημοσιεύθηκαν %d από %d',
        'DOWNLOAD_X' => 'Λήψη %s',
        'UPLOAD_DID_NOT_WORK' => 'Λυπούμαστε, η αποστολή δεν ήταν δυνατή',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M. j, Y',
        'XS_POSTS' => 'Καταχωρήσεις του/της %s',
        'USERNAMES_COMMENTS' => 'Σχόλια του/της %s',
        'ADD_COMMENT' => 'Προσθήκη σχολίου',
        'XS_PAGE' => 'Σελίδα του/της %s',
        'XS_BLOG' => 'Ιστολόγιο του/της %s',
        'XS_FRIENDS' => 'Φίλοι του/της %s',
        'VIEW_XS_ELLIPSIS' => 'Προβολή του/της %s\'s...',
        'DRAFT_BRACKETS' => '[Προσχέδιο]',
        'FEATURED' => 'Χαρακτηριστικό',
        'MY_POSTS' => 'Οι καταχωρήσεις μου',
        'MY_POSTS_ONLY' => 'Μόνο οι καταχωρήσεις μου',
        'OWNER_POSTS_ONLY' => 'Μόνο καταχωρήσεις του δημιουργού',
        'JANUARY' => 'Ιανουάριος',
        'FEBRUARY' => 'Φεβρουάριος',
        'MARCH' => 'Μάρτιος',
        'APRIL' => 'Απρίλιος',
        'MAY' => 'Μάιος',
        'JUNE' => 'Ιούνιος',
        'JULY' => 'Ιούλιος',
        'AUGUST' => 'Αύγουστος',
        'SEPTEMBER' => 'Σεπτέμβριος',
        'OCTOBER' => 'Οκτώβριος',
        'NOVEMBER' => 'Νοέμβριος',
        'DECEMBER' => 'Δεκέμβριος',
        'MY_COMMENTS' => 'Τα σχόλιά μου',
        'AM' => 'π.μ.',
        'PM' => 'μ.μ.',
        'MY_PAGE' => 'Η σελίδα μου',
        'MY_PAGE_TAB_TEXT' => 'Η σελίδα μου',
        'BLOG_POSTS' => 'Καταχωρήσεις ιστολογίου',
        'MY_BLOG' => 'Το ιστολόγιό μου',
        'MONTH' => 'Μήνας',
        'DAY' => 'Ημέρα',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Ορίστε μια έγκυρη επιλογή για την προεπιλεγμένη ορατότητα',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Ορίστε μια έγκυρη επιλογή για το ποιος μπορεί να συντάσσει σχόλια',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Ορίστε μια έγκυρη επιλογή για το συντονισμό των σχολίων στο ιστολόγιο',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Ορίστε μια έγκυρη επιλογή για την ειδοποίηση δραστηριοτήτων',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Ορίστε μια έγκυρη επιλογή για την ειδοποίηση συντονισμού',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Ορίστε μια έγκυρη επιλογή για την ειδοποίηση έγκρισης',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Ορίστε μια έγκυρη επιλογή για την ειδοποίηση του προσκεκλημένου ότι έγινε μέλος',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Ορίστε μια έγκυρη επιλογή για να μην λαμβάνετε ποτέ ειδοποιήσεις',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Ορίστε μια έγκυρη επιλογή για τις ειδοποιήσεις αιτήσεων για προσθήκη ως φίλος',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Ορίστε μια έγκυρη επιλογή για τις ειδοποιήσεις νέων μηνυμάτων',
        'APPROVE_COMMENT' => 'Έγκριση σχολίου',
        'MANAGE_BLOG' => 'Διαχείριση ιστολογίου',
        'COMMENTS_POSTED_ON_BLOG' => 'Σχόλια που δημοσιεύθηκαν στο ιστολόγιό μου',
        'COMMENT' => 'Σχόλιο',
        'COMMENTER' => 'Συντάκτης σχολίου',
        'POST' => 'ΚΑΤΑΧΩΡΗΣΗ',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Η καταχώρηση έχει διαγραφεί',
        'COMMENTS_ARE_CLOSED' => 'Τα σχόλια είναι κλειστά για αυτή την καταχώρηση ιστολογίου',
        'NO_COMMENTS' => 'Χωρίς σχόλια',
        'FLAG' => 'Σημαία',
        'POST_TITLE' => 'Τίτλος καταχώρησης',
        'DRAFT_PARENTHESES' => '(Προσχέδιο)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Προγραμματίστηκε για δημοσίευση την: %s',
        'EDIT_2' => 'επεξεργασία',
        'NONE' => 'Καμία',
        'N_NEW' => '%s νέα',
        'NO_POSTS' => 'Χωρίς καταχωρήσεις',
        'ADD_NEW_BLOG_POST' => 'Προσθήκη νέας καταχώρησης ιστολογίου',
        'HAPPY' => 'Χαρούμενος',
        'SAD' => 'Λυπημένος',
        'COOL' => 'Ψύχραιμος',
        'EVIL' => 'Κακός',
        'MAD' => 'Έξαλλος',
        'ENVIOUS' => 'Ζηλιάρης',
        'ENTRY' => 'Καταχώρηση',
        'WHAT_DATE_FOR_YOUR_POST' => 'Ποια ημερομηνία θα θέλατε για την καταχώρησή σας;',
        'NOW' => 'Τώρα',
        'CHOOSE_DATE_AND_TIME' => 'Επιλέξτε ημερομηνία και ώρα (εάν επιλέξετε μια μελλοντική ημερομηνία, τότε θα δημοσιευθεί η καταχώρησή σας)',
        'PRIVACY_AND_COMMENTS' => 'Απόρρητο & σχόλια',
        'WHO_CAN_VIEW_POST' => 'Ποιος μπορεί να προβάλει αυτή την καταχώρηση;',
        'EVERYONE' => 'Όλοι',
        'ALLOW_COMMENTS' => 'Αποδοχή σχολίων σε αυτή την καταχώρηση;',
        'YES' => 'Ναι',
        'NO' => 'Όχι',
        'COMMENT_MODERATION' => 'Συντονισμός σχολίων',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Προς το παρόν, συντονίζετε τα σχόλια του ιστολογίου.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Δεν συντονίζετε, προς το παρόν, τα σχόλια του ιστολογίου.',
        'SAVE_AS_DRAFT' => 'Αποθήκευση ως προσχέδιο',
        'PREVIEW' => 'Προεπισκόπηση',
        'PUBLISH_POST' => 'Δημοσίευση καταχώρησης',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Αυτή είναι μια προεπισκόπηση της πραγματικής εμφάνισης της καταχώρησης ιστολογίου σας μετά τη δημοσίευση.  Κάντε κλικ στο Πίσω για να επεξεργαστείτε την καταχώρηση ή στο Δημοσίευση, εάν είναι έτοιμη!',
        'BACK' => 'Πίσω',
        'PUBLISH' => 'Δημοσίευση!',
        'BLOG_POST' => 'Καταχώρηση ιστολογίου',
        'PROFILE' => 'Προφίλ',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Αυτό είναι ένα μη δημοσιευμένο προσχέδιο',
        'WILL_BE_PUBLISHED_ON_X' => 'Πρόκειται να δημοσιευθεί την %s <small>%s</small>',
        'POSTED_ON_X' => 'Καταχωρήθηκε την <strong>%s</strong> <small>%s</small>',
        'POSTED_ON_X_BY' => 'Καταχωρήθηκε την <strong>%s</strong> <small>%s</small> από τον/την:',
        'ABOUT_THIS_POST' => 'Πληροφορίες για την καταχώρηση',
        'ABOUT_YOUR_POST' => 'Πληροφορίες για την καταχώρησή σας',
        'ADDED_BY' => 'Προστέθηκε από:',
        'JUST_FRIENDS' => 'Μόνο φίλοι',
        'RECENT_POSTS' => 'Πρόσφατες καταχωρήσεις',
        'THERE_ARE_NO_RECENT_POSTS' => 'Δεν υπάρχουν πρόσφατες καταχωρήσεις.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Το σχόλιό σας προστέθηκε, αλλά πρέπει να εγκριθεί πριν γίνει ορατό σε όλους.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'Στο %s στο %s, ο/η %s είπε...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => 'Ο/Η %s δεν έχει ακόμα φίλους σε αυτό το κοινωνικό δίκτυο.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Δεν έχετε ακόμα φίλους σε αυτό το κοινωνικό δίκτυο.',
        'EDIT_PAGE_APPEARANCE' => 'Επεξεργασία εμφάνισης σελίδας',
        'VIEW_PAGE_AS_OTHERS' => 'Προβολή σελίδας όπως τη βλέπουν οι άλλοι',
        'ADD_BLOG_POST' => 'Προσθήκη καταχώρησης ιστολογίου',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Διατηρήστε ανοικτό το παράθυρο του προγράμματος περιήγησης, όσο διαρκεί η διαγραφή όλου του περιεχομένου του/της %s.  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'BAN_MEMBER_FROM_NETWORK' => 'Απαγόρευση μέλους από το δίκτυο',
        'BAN_USERNAME' => 'Απαγόρευση του/της %s;',
        'BLOCK' => 'αποκλεισμός',
        'CREATE_NEW_BLOG_POST' => 'Δημιουργία νέας καταχώρησης ιστολογίου!',
        'EDIT_POST' => 'Επεξεργασία καταχώρησης',
        'EDIT_POST_COLON' => 'Επεξεργασία καταχώρησης:',
        'CONTINUE_READING' => 'Συνέχιση ανάγνωσης...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Καταχωρήθηκε από <a %s>εμένα</a> στις %s στο %s —',
        'POSTED_BY_X_ON_X_AT_X' => 'Καταχωρήθηκε από τον/την %s στις %s στο %s —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Καταχωρήθηκε από εμένα στις %s στο %s —',
        'ADD' => 'Προσθήκη',
        'SUBSCRIBE' => 'Εγγραφή',
        'VIEW_ARCHIVES' => 'Προβολή αρχειοθηκών',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Οι ρυθμίσεις σας αποθηκεύθηκαν.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Διορθώστε τα εξής:',
        'PRIVACY' => 'Απόρρητο',
        'NETWORK_PRIVACY' => 'Απόρρητο δικτύου',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Αυτό το δίκτυο είναι <strong>ορατό σε όλους</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Όλοι μπορούν να εγγραφούν και να γίνουν μέλη.  Οι επισκέπτες μπορούν...',
        'SEE_EVERYTHING' => 'Να δουν τα πάντα',
        'SEE_JUST_THE_MAIN_PAGE' => 'Να δουν μόνο την αρχική σελίδα',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Να δουν μόνο τη σελίδα εγγραφής',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Αυτό το δίκτυο είναι <strong>ορατό μόνο στα μέλη</strong>.',
        'WHO_CAN_SIGN_UP' => 'Ποιος μπορεί να εγγραφεί και να γίνει μέλος;',
        'MODERATION' => 'Έλεγχος περιεχομένου',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Έγκριση νέων μελών πριν γίνουν μέλη',
        'APPROVE_PHOTOS_VIDEOS' => 'Έγκριση φωτογραφιών και βίντεο πριν την εμφάνιση',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Εμφάνιση της τελευταίας δραστηριότητας στο δίκτυό σας!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Τοποθετήστε μια διαρκώς ενημερούμενη ροή πρόσφατων δραστηριοτήτων στην αρχική σελίδα του δικτύου σας.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Κάντε κλικ εδώ για να προσθέσετε Πρόσφατες δραστηριότητες στο δίκτυό σας.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Αυτές οι επιλογές είναι απενεργοποιημένες, επειδή δεν διαθέτετε Πρόσφατες δραστηριότητες στο δίκτυό σας.',
        'ACTIVITY' => 'Δραστηριότητα',
        'DISPLAY_PREFERENCES' => 'Εμφάνιση προτιμήσεων',
        'NEW_CONTENT' => 'Νέο περιεχόμενο',
        'NEW_COMMENTS' => 'Νέα σχόλια',
        'NEW_MEMBERS' => 'Νέα μέλη',
        'MEMBER_UPDATES' => 'Ενημέρωση μελών',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Τι εμφανίζεται στις<br />Πρόσφατες δραστηριότητες του δικτύου σας;',
        'LATEST_ACTIVITY' => 'Πρόσφατες δραστηριότητες',
        'X_COMMENTED_ON_POST_TITLE' => 'Ο/Η %1$s απάντησε στη συζήτηση %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'Ο/Η %1$s <a %2$s>απάντησε</a> στη συζήτηση <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => '<a %1$s>Απαντήσατε</a> στη συζήτηση <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => 'Ο/Η %1$s εισήγαγε σχόλιο στην καταχώρηση ιστολογίου %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'Ο/Η %1$s <a %2$s>εισήγαγε σχόλιο</a> στην καταχώρηση ιστολογίου <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '<a %1$s>Εισαγάγατε σχόλιο</a> στην καταχώρηση ιστολογίου <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => 'Ο/Η %s έχει ξεκινήσει μια συζήτηση με τίτλο %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Έχετε ξεκινήσει μια συζήτηση με τίτλο %s',
        'X_ADDED_THE_BLOG_POST_Y' => 'Ο/Η %s πρόσθεσε την καταχώρηση ιστολογίου \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Προσθέσατε την καταχώρηση ιστολογίου \'%s\'',
        'X_JOINED_THE_GROUP_Y' => 'Ο/Η %s έγινε μέλος στην ομάδα %s',
        'YOU_JOINED_THE_GROUP_X' => 'Γίνατε μέλη στην ομάδα %s',
        'X_JOINED_Y_GROUPS' => 'Ο/Η %s έγινε μέλος σε %s ομάδες',
        'YOU_JOINED_X_GROUPS' => 'Γίνατε μέλος σε %s ομάδες',
        'X_JOINED_APPNAME' => 'Ο/Η %s έγινε μέλος στο %s. <a %s>Αφήστε ένα σχόλιο</a> για το %s.',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Καλωσόρισες %1$s!  Είσαι το μέλος αρ. %2$s του %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Καλωσορίσατε, %1$s!  Είστε το μέλος #%2$s από %3$s.  <a %4$s>Εύρεση φίλων τώρα</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => 'Ο/Η %1$s είναι το μέλος #%2$s από %3$s.',
        'XS_PROFILE_CHANGED' => 'Το προφίλ του/της %s άλλαξε',
        'YOUR_PROFILE_CHANGED' => 'Το προφίλ σας άλλαξε',
        'X_LEFT_A_COMMENT_FOR_Y' => 'Ο/Η %s έχει αφήσει σχόλιο για τον/την %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Έχετε αφήσει ένα σχόλιο για τον/την %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => 'Ο/Η %s έχει αφήσει σχόλιο για εσάς',
        'X_CREATED_A_GROUP_Y' => 'Ο/Η %s δημιούργησε μια ομάδα με τίτλο %s',
        'YOU_CREATED_A_GROUP_Y' => 'Δημιουργήσατε μια ομάδα με τίτλο %s',
        'X_CREATED_Y_NEW_GROUPS' => 'Ο/Η %s δημιούργησε %s νέες ομάδες',
        'X_STARTED_Y_FORUM_POSTS' => 'Ο/Η %s ξεκίνησε %s νέες συζητήσεις στο φόρουμ',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Έχετε ξεκινήσει %s νέες συζητήσεις στο φόρουμ',
        'X_ADDED_Y_BLOG_POSTS' => 'Ο/Η %s πρόσθεσε %s νέες καταχωρήσεις ιστολογίου',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Προσθέσατε %s νέες καταχωρήσεις ιστολογίου',
        'VIEW_XS_BLOG_POSTS' => 'Προβολή των καταχωρήσεων ιστολογίου του/της %s',
        'VIEW_YOUR_BLOG_POSTS' => 'Προβολή των δικών σας καταχωρήσεων ιστολογίου',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => 'Ο/Η %s έχει <a %s>νέες ερωτήσεις για το προφίλ</a>',
        'APPNAME_NOW_HAS_MUSIC' => 'Ο/Η %s διαθέτει τώρα πρόγραμμα αναπαραγωγής μουσικής',
        'APPNAME_NOW_HAS_GROUPS' => 'Ο/Η %s έχει τώρα <a %s>ομάδες</a>',
        'APPNAME_NOW_HAS_VIDEO' => 'Ο/Η %s έχει τώρα <a %s>βίντεο</a>',
        'APPNAME_NOW_HAS_FORUM' => 'Ο/Η %s έχει τώρα ένα <a %s>φόρουμ</a>',
        'APPNAME_NOW_HAS_PHOTO' => 'Ο/Η %s έχει τώρα <a %s>φωτογραφίες</a>',
        'DID_YOU_KNOW' => 'Γνωριζατε οτι',
        'ANNOUNCEMENT' => 'Ανακοίνωση',
        'CONGRATULATIONS' => 'Συγχαρητήρια',
        'YOU_CREATED_APPNAME' => 'Δημιουργήσατε το δίκτυο %s.',
        'USER_CREATED_APPNAME' => 'Ο/Η %s δημιούργησε το δίκτυο %s.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Προσθέστε μηνύματα και επιλέξτε τι θα εμφανιστεί στην τροφοδοσία δραστηριοτήτων του δικτύου σας.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Ποιες από τις ενέργειές σας θα πρέπει να εμφανίζονται<br />στις Πρόσφατες δραστηριότητες;',
        'NEW_CONTENT_I_ADD' => 'Το νέο περιεχόμενο που προσθέτω',
        'NEW_COMMENTS_I_ADD' => 'Τα νέα σχόλια που προσθέτω',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Πότε ενημερώνω το προφίλ μου',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Οι Πρόσφατες δραστηριότητες δεν θα εμφανίζουν ποτέ τα μηνύματα που αποστέλλετε, τις σελίδες ή τα μέλη που προβάλλετε, τις προσκλήσεις που απορρίπτετε, τα άτομα που καταργείτε από φίλους σας ή απορρίπτετε ή τα πράγματα που διαγράφετε.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Δεν έχετε πρόσφατες δραστηριότητες.  Γιατί δεν ξεκινάτε κάτι;',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Έχετε απενεργοποιήσει την εμφάνιση των δραστηριοτήτων σας.  <a %s>Κάντε κλικ εδώ για να την ενεργοποιήσετε ξανά. </a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'Ο δημιουργός του δικτύου έχει απενεργοποιήσει την εμφάνιση όλων των δραστηριοτήτων.',
        'NO_ACTIVITY_TO_DISPLAY' => 'Προς το παρόν, δεν εμφανίζετε καμία δραστηριότητα.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί σε άλλα άτομα, εκτός εάν επιλέξετε τουλάχιστον ένα στοιχείο δραστηριότητας.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Δεν υπάρχουν πρόσφατες δραστηριότητες.  Γιατί δεν ξεκινάτε κάτι;',
        'MY_ACTIVITY_PREFERENCES' => 'Οι προτιμήσεις δραστηριοτήτων μου',
        'DELETE_ACTIVITY_ITEM' => 'Κατάργηση μηνύματος δραστηριότητας',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Να καταργηθεί αυτό το μήνυμα δραστηριότητας;',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Αυτό δεν θα επιτρέψει σε κανέναν να δει αυτό το μήνυμα δραστηριότητας',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => 'Ο/η %1$s έχει καταχωρήσει τις περισσότερες %2$sφωτογραφίες%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => 'Η %s είναι η πιο δημοφιλής φωτογραφία έως σήμερα',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => 'Ο/η %1$s έχει καταχωρήσει τα περισσότερα %2$sβίντεο%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => 'Το %s είναι το πιο δημοφιλές βίντεο έως σήμερα',
        'X_HAS_POSTED_THE_MOST_MUSIC' => 'Ο/η %s έχει καταχωρήσει τα περισσότερα τραγούδια',
        'X_IS_THE_MOST_POPULAR_MUSIC' => 'Το %s είναι το πιο δημοφιλές τραγούδι έως σήμερα',
        'X_IS_THE_MOST_POPULAR_TOPIC' => 'Η %s είναι η πιο δημοφιλής καταχώρηση σε φόρουμ έως σήμερα',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => 'Η %s είναι η πιο δημοφιλής καταχώρηση ιστολογίου έως σήμερα',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => 'Πρόσφατες δραστηριότητες του/της %s στο %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Πρόσφατες δραστηριότητες στο %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Προσθήκη μηνύματος στις Πρόσφατες δραστηριότητες',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Προσθέστε στοιχεία για το δίκτυο...',
        'ADD_MESSAGE' => 'Προσθέστε μήνυμα',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '...ή γράψτε το δικό σας μήνυμα',
        'NETWORK' => 'Δίκτυο',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Ποιος μπορεί να προβάλλει τις φωτογραφίες, τα βίντεο,<br/> και τις καταχωρήσεις ιστολογίου σας από προεπιλογή;',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Μπορείτε να παρακάμψετε αυτή τη ρύθμιση για μια φωτογραφία, ένα βίντεο ή μια καταχώρηση ιστολογίου κατά την προσθήκη τους.)',
        'MODERATE_COMMENTS_ON_BLOG' => 'Θέλετε να εγκρίνετε τα σχόλια<br />πριν εμφανιστούν στο ιστολόγιό σας;',
        'YES_LET_ME_APPROVE' => 'Ναι – Θα ήθελα να εγκρίνω πρώτα τα σχόλια',
        'NO_PUBLISH_COMMENTS' => 'Όχι – Άμεση δημοσίευση των σχολίων',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Ποιος μπορεί να σχολιάζει τις φωτογραφίες,<br/> τα βίντεο και το ιστολόγιό σας;',
        'SAVE' => 'Αποθήκευση',
        'EMAIL' => 'Email',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Η τήρηση του απορρήτου σας είναι σημαντική για μας.  Εάν έχετε ερωτήσεις σχετικά με τις ειδοποιήσεις του ηλεκτρονικού σας ταχυδρομείου, αποστείλετέ μας ένα σημείωμα μέσω της ιστοσελίδας <a href="http://help.ning.com/?page_id=27">Κέντρο Βοήθειας</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Προσθέστε φωτογραφίες και βίντεο στο %s αποστέλλοντάς τις σε αυτή τη διεύθυνση ηλεκτρονικού ταχυδρομείου:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Προσθέστε φωτογραφίες και βίντεο στο %s από το τηλέφωνό σας αποστέλλοντάς τις σε αυτή τη διεύθυνση ηλεκτρονικού ταχυδρομείου:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Δημιουργία νέας διεύθυνσης ηλεκτρονικού ταχυδρομείου',
        'SUPPORTS_TEXT_EMBEDDED' => 'Υποστηρίζει κείμενο, ενσωματωμένα βίντεο, φωτογραφίες και γραφικά στοιχεία',
        'POST_COMMENT' => 'Καταχώρηση σχολίου',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Πρέπει να είστε μέλος του %s για να προσθέσετε σχόλια!',
        'MONTHLY_ARCHIVES' => 'Μηνιαίες αρχειοθήκες',
        'NO_FRIENDS_ON_SITE' => 'Δεν υπάρχουν ακόμα φίλοι σε αυτό το κοινωνικό δίκτυο.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Σε αυτό το κοινωνικό δίκτυο δεν υπάρχουν φίλοι που να ταιριάζουν στην αναζήτησή σας.',
        'MEMBERS_TAB_TEXT' => 'Μέλη',
        'SITE_HAS_NO_MEMBERS' => 'Αυτό το κοινωνικό δίκτυο δεν έχει ακόμα μέλη!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Αυτό το κοινωνικό δίκτυο δεν έχει μέλη που να ταιριάζουν στην αναζήτησή σας.',
        'NO_COMMENTS_YET' => 'Δεν υπάρχουν ακόμα σχόλια!',
        'VIEW_ALL_COMMENTS' => 'Προβολή όλων των σχολίων',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Δεν έχετε προσθέσει ακόμη καταχωρήσεις ιστολογίου!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Μπορείτε να γράψετε για ο,τιδήποτε θέλετε, να μιλήσετε για τα αγαπημένα σας βίντεο, τις αγαπημένες σας φωτογραφίες και την αγαπημένη σας μουσική και να τα ενσωματώσετε.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Γράψτε την πρώτη σας καταχώρηση!',
        'THERE_ARE_NO_BLOG_POSTS' => 'Προς το παρόν, δεν υπάρχουν καταχωρήσεις ιστολογίου στο κοινωνικό σας δίκτυο.',
        'THERE_ARE_NO_FEATURED_X' => 'Δεν υπάρχουν προβεβλημένα %s στο κοινωνικό σας δίκτυο.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Δεν υπάρχουν %s που να ταιριάζουν με τις ρυθμίσεις που επιλέξατε.',
        'START_FEATURING_X_CLICK_Y' => 'Αρχίστε να προβάλλετε %s, όταν δείτε την επιλογή Χαρακτηριστικό.  Για να μάθετε περισσότερα σχετικά με την προβολή χαρακτηριστικών, <a %s>κάντε κλικ εδώ</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί σε τρίτους, εάν δεν υπάρχουν καταχωρήσεις ιστολογίου για εμφάνιση.  Γιατί δεν προσθέτετε ένα;',
        'YOUR_FRIEND' => 'Ο φίλος σας',
        'REQUEST_SENT' => 'Αίτηση εστάλη!',
        'BLOCKED' => 'Αποκλεισμένο',
        'BANNED' => 'Απαγορευμένο',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Προσθήκη της πρώτης καταχώρησης στο ιστολόγιό σας',
        'MY_FIRST_BLOG_POST' => 'Η πρώτη μου καταχώρηση ιστολογίου!',
        'TELL_THE_PEOPLE_ON' => 'Πείτε σε άλλους στο %s περισσότερα για τον εαυτό σας.  Οι ερωτήσεις που επισημαίνονται με μια <span %s>κλειδαριά</span> είναι προσωπικές και είναι ορατές μόνο στους διαχειριστές.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Επιλέξτε ένα θέμα για τη σελίδα σας',
        'NOW_CUSTOMIZE_PAGE' => 'Τώρα προσαρμόστε τη σελίδα σας...',
        'NO_POSTS_TO_DISPLAY' => 'Δεν υπάρχουν καταχωρήσεις προς εμφάνιση.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'Προς το παρόν, δεν εμφανίζετε καταχωρήσεις.',
        'DATE_COLON' => 'Ημερομηνία:',
        'TIME_COLON' => 'Ώρα:',
        'CHANGE' => 'Αλλαγή',
        'UPLOAD_A_PHOTO' => 'Αποστολή φωτογραφίας',
        'OPTIONS' => 'Επιλογές',
        'PIXELS' => 'Pixel',
        'CANCEL' => 'Άκυρο',
        'UPLOAD_A_FILE' => 'Αποστολή αρχείου:',
        'TO_INSERT_A_FILE' => 'Για να εισάγετε ένα αρχείο, κάντε κλικ στα κουμπιά "Αναζήτηση" ή "Επιλογή" παραπάνω, για να εντοπίσετε το αρχείο στον υπολογιστή σας.',
        'UPLOADING' => 'Αποστολή...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Δημοφιλή μέλη',
        'INVITE_FRIENDS' => 'Πρόσκληση φίλων',
        'VIEW_ALL' => 'Προβολή όλων',
        'REMOVE_X' => 'Κατάργηση %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Είστε βέβαιοι ότι θέλετε να απαγορεύσετε τον/την %1$s από το κοινωνικό σας δίκτυο και να διαγράψετε όλο το περιεχόμενο που έχει προσθέσει ο/η %1$s;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'REMOVING_X' => 'Γίνεται κατάργηση του %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Είστε βέβαιοι ότι θέλετε να απαγορεύσετε τα επιλεγμένα μέλη από το κοινωνικό σας δίκτυο και να διαγράψετε όλο το περιεχόμενο που έχουν προσθέσει;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Είστε βέβαιοι ότι θέλετε να απαγορεύσετε τα επιλεγμένα μέλη από το κοινωνικό σας δίκτυο;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'BAN' => 'Απαγόρευση',
        'REMOVING_MEMBERS' => 'Γίνεται κατάργηση μελών',
        'FEMALE' => 'Γυναίκα',
        'MALE' => 'Άντρας',
        'UNITED_STATES' => 'Ηνωμένες Πολιτείες',
        'AND' => 'και',
        'FROM' => 'από',
        'GENDER_M' => 'Άντρας',
        'GENDER_F' => 'Γυναίκα',
        'XS_PAGE_ON_Y' => 'Σελίδα του/της %s στο %s',
        'SEARCH_MEMBERS' => 'Αναζήτηση μελών',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'κάποιος έχει σχολιάσει μια καταχώρηση ιστολογίου που έχετε προσθέσει στο %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Έχετε ένα νέο σχόλιο στη σελίδα σας.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Έχετε ένα νέο σχόλιο στη σελίδα σας στο %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Έχετε ένα νέο σχόλιο στη σελίδα σας στο %s...',
        'A_BLOG_POST' => 'μια καταχώρηση ιστολογίου',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Τώρα που γίνατε μέλος, <strong><a %s>προσκαλέστε τους φίλους σας</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'Αυτό είναι το προφίλ σας:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Ξεκινήστε <a %s>προσαρμόζοντας την εμφάνισή του</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Χρησιμοποιήστε το για να <a %1$s>διατηρείτε ένα ιστολόγιο</a> και να εμφανίζετε τις <a %2$s>απαντήσεις του προφίλ σας</a>.',
        'START_CONTRIBUTING' => 'Εκκίνηση συμβολής:',
        'UPLOAD_VIDEOS' => 'Αποστολή βίντεο',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Συμβολή σε συζητήσεις',
        'JOIN_GROUPS' => 'Γίνετε μέλος σε ομάδες',
        'ADD_A_BLOG_POST' => 'Προσθήκη καταχώρησης ιστολογίου',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Κάντε κλικ εδώ για να προβάλετε τις αιτήσεις των φίλων σας.',
        'LEAVE_X' => 'Έξοδος από το %s',
        'LEAVE_X_Q' => 'Έξοδος από το %s;',
        'ARE_YOU_SURE_LEAVE_X' => 'Είστε σίγουροι ότι θέλετε έξοδο από το %s και διαγραφή όλου του περιεχόμενού σας;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592;  Επιστροφή στη σελίδα του/της %s',
        'BACK_TO_MY_PAGE' => '&#8592;  Επιστροφή στη σελίδα μου',
        'COMMENT_WALL' => 'Πίνακας σχολίων',
        'ONLINE' => 'Σε σύνδεση',
        'MEMBER_IS_ONLINE' => 'Το μέλος είναι σε σύνδεση',
        'ONLINE_NOW' => 'Σε σύνδεση τώρα',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Επιλέξτε ποιος μπορεί να δει, να γίνει μέλος και να συμβάλλει στο δίκτυό σας.',
        'EMAIL_NOTIFICATIONS' => 'Ειδοποιήσεις ηλεκτρονικού ταχυδρομείου',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Για ποιες δραστηριότητες του δικτύου θέλετε να λαμβάνετε ειδοποιήσεις ηλεκτρονικού ταχυδρομείου;',
        'NETWORK_MESSAGES' => 'Μηνύματα δικτύου',
        'MEMBER_ACTIVITY' => 'Δραστηριότητες μέλους',
        'APPROVAL' => 'Έγκριση',
        'FRIEND_REQUESTS' => 'Αιτήσεις φίλων',
        'PEOPLE_IVE_INVITED_JOIN' => 'Άτομα που έχω προσκαλέσει για να γίνουν μέλη σε αυτό το δίκτυο',
        'MESSAGES_SENT_TO_ME' => 'Μηνύματα που μου έχουν αποσταλεί',
        'MESSAGES_SENT_TO_GROUPS' => 'Μηνύματα που έχουν αποσταλεί σε ομάδες στις οποίες ανήκω',
        'MESSAGES_SENT_TO_NETWORK' => 'Μηνύματα που έχουν αποσταλεί σε ολόκληρο το δίκτυο',
        'I_HAVE_NEW_COMMENTS' => 'Έχω νέα σχόλια για έγκριση',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Έχω νέο περιεχόμενο δικτύου για έγκριση',
        'CONTENT_ACTIVITY' => 'Δραστηριότητες περιεχομένου',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Δραστηριότητες σχετικές με πράγματα που έχω προσθέσει',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Αυτόματη παρακολούθηση των συζητήσεων στις οποίες απαντώ',
        'THINGS_IVE_ADDED_APPROVED' => 'Πράγματα που πρόσθεσα έχουν εγκριθεί',
        'NOTIFICATIONS' => 'Ειδοποιήσεις',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Να λαμβάνω μήνυμα ηλεκτρονικού ταχυδρομείου όταν μου απαντούν',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Να μην λαμβάνω μήνυμα ηλεκτρονικού ταχυδρομείου όταν μου απαντούν',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'Για να διακόψετε την παρακολούθηση αυτού του %s, <a %s>κάντε κλικ εδώ</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Δεν παρακολουθείτε πια αυτό το %s.',
        'NOTIFY' => 'Ειδοποίηση',
        'STOP_NOTIFYING' => 'Διακοπή ειδοποιήσεων',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Να λαμβάνω μήνυμα ηλεκτρονικού ταχυδρομείου όταν υπάρχουν νέες συζητήσεις',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Να μην λαμβάνω μήνυμα ηλεκτρονικού ταχυδρομείου όταν υπάρχουν νέες συζητήσεις',
        'STOP_FOLLOWING_ALL' => 'Διακοπή παρακολούθησης όλων των συζητήσεων και των σχολίων ιστολογίου',
        'CHANGE_MY_PHOTO' => 'Αλλαγή της φωτογραφίας μου',
        'COUNTRY_AF' => 'Αφγανιστάν',
        'COUNTRY_AX' => 'Νησιά Άλαντ',
        'COUNTRY_AL' => 'Αλβανία',
        'COUNTRY_DZ' => 'Αλγερία',
        'COUNTRY_AS' => 'Αμερικανικές Σαμόα',
        'COUNTRY_AD' => 'Ανδόρρα',
        'COUNTRY_AO' => 'Ανγκόλα',
        'COUNTRY_AI' => 'Ανγκουίλα',
        'COUNTRY_AQ' => 'Ανταρκτική',
        'COUNTRY_AG' => 'Αντίγκουα και Μπαρμπούντα',
        'COUNTRY_AR' => 'Αργεντινή',
        'COUNTRY_AM' => 'Αρμενία',
        'COUNTRY_AW' => 'Αρούμπα',
        'COUNTRY_AU' => 'Αυστραλία',
        'COUNTRY_AT' => 'Αυστρία',
        'COUNTRY_AZ' => 'Αζερμπαϊτζάν',
        'COUNTRY_BS' => 'Μπαχάμες',
        'COUNTRY_BH' => 'Μπαχρέιν',
        'COUNTRY_BD' => 'Μπανγκλαντές',
        'COUNTRY_BB' => 'Μπαρμπάντος',
        'COUNTRY_BY' => 'Λευκορωσία',
        'COUNTRY_BE' => 'Βέλγιο',
        'COUNTRY_BZ' => 'Μπελίζε',
        'COUNTRY_BJ' => 'Μπενίν',
        'COUNTRY_BM' => 'Βερμούδες',
        'COUNTRY_BT' => 'Μπουτάν',
        'COUNTRY_BO' => 'Βολιβία',
        'COUNTRY_BA' => 'Βοσνία - Ερζεγοβίνη',
        'COUNTRY_BW' => 'Μποτσουάνα',
        'COUNTRY_BV' => 'Νησί Μπουβέ',
        'COUNTRY_BR' => 'Βραζιλία',
        'COUNTRY_IO' => 'Βρετανικό Έδαφος του Ινδικού Ωκεανού',
        'COUNTRY_BN' => 'Μπρουνέι Νταρουσαλάμ',
        'COUNTRY_BG' => 'Βουλγαρία',
        'COUNTRY_BF' => 'Μπουρκίνα Φάσο',
        'COUNTRY_BI' => 'Μπουρούντι',
        'COUNTRY_KH' => 'Καμπότζη',
        'COUNTRY_CM' => 'Καμερούν',
        'COUNTRY_CA' => 'Καναδάς',
        'COUNTRY_CV' => 'Πράσινο Ακρωτήριο',
        'COUNTRY_KY' => 'Νησιά Κάυμαν',
        'COUNTRY_CF' => 'Κεντροαφρικανική Δημοκρατία',
        'COUNTRY_TD' => 'Τσαντ',
        'COUNTRY_CL' => 'Χιλή',
        'COUNTRY_CN' => 'Κίνα, ηπειρωτική',
        'COUNTRY_CX' => 'Νήσος των Χριστουγέννων',
        'COUNTRY_CC' => 'Νήσοι Κόκος (Κήλινγκ)',
        'COUNTRY_CO' => 'Κολομβία',
        'COUNTRY_KM' => 'Κομόρες',
        'COUNTRY_CG' => 'Κονγκό',
        'COUNTRY_CD' => 'Λαϊκή Δημοκρατία του Κονγκό',
        'COUNTRY_CK' => 'Νήσοι Κουκ',
        'COUNTRY_CR' => 'Κόστα Ρίκα',
        'COUNTRY_CI' => 'Ακτή Ελεφαντοστού',
        'COUNTRY_HR' => 'Κροατία',
        'COUNTRY_CU' => 'Κούβα',
        'COUNTRY_CY' => 'Κύπρος',
        'COUNTRY_CZ' => 'Τσεχία',
        'COUNTRY_DK' => 'Δανία',
        'COUNTRY_DJ' => 'Τζιμπουτί',
        'COUNTRY_DM' => 'Ντομίνικα',
        'COUNTRY_DO' => 'Δομινικανή Δημοκρατία',
        'COUNTRY_EC' => 'Ισημερινός',
        'COUNTRY_EG' => 'Αίγυπτος',
        'COUNTRY_SV' => 'Ελ Σαλβαδόρ',
        'COUNTRY_GQ' => 'Ισημερινή Γουινέα',
        'COUNTRY_ER' => 'Ερυθραία',
        'COUNTRY_EE' => 'Εσθονία',
        'COUNTRY_ET' => 'Αιθιοπία',
        'COUNTRY_EU' => 'Ευρωπαϊκή Ένωση',
        'COUNTRY_FK' => 'Νήσοι Φώκλαντ',
        'COUNTRY_FO' => 'Νήσοι Φερόες',
        'COUNTRY_FJ' => 'Φίτζι',
        'COUNTRY_FI' => 'Φινλανδία',
        'COUNTRY_FR' => 'Γαλλία',
        'COUNTRY_GF' => 'Γαλλική Γουιάνα',
        'COUNTRY_PF' => 'Γαλλική Πολυνησία',
        'COUNTRY_TF' => 'Γαλλικά Νότια Εδάφη',
        'COUNTRY_GA' => 'Γκαμπόν',
        'COUNTRY_GM' => 'Γκάμπια',
        'COUNTRY_GE' => 'Γεωργία',
        'COUNTRY_DE' => 'Γερμανία',
        'COUNTRY_GH' => 'Γκάνα',
        'COUNTRY_GI' => 'Γιβραλτάρ',
        'COUNTRY_GR' => 'Ελλάδα',
        'COUNTRY_GL' => 'Γροιλανδία',
        'COUNTRY_GD' => 'Γρενάδα',
        'COUNTRY_GP' => 'Γουαδελούπη',
        'COUNTRY_GU' => 'Γκουάμ',
        'COUNTRY_GT' => 'Γουατεμάλα',
        'COUNTRY_GN' => 'Γουινέα',
        'COUNTRY_GW' => 'Γουινέα-Μπισσάου',
        'COUNTRY_GY' => 'Γουιάνα',
        'COUNTRY_HT' => 'Αϊτή',
        'COUNTRY_HM' => 'Νήσοι Χερντ και Μακντόναλντ',
        'COUNTRY_HN' => 'Ονδούρα',
        'COUNTRY_HK' => 'Χονγκ Κονγκ',
        'COUNTRY_HU' => 'Ουγγαρία',
        'COUNTRY_IS' => 'Ισλανδία',
        'COUNTRY_IN' => 'Ινδία',
        'COUNTRY_ID' => 'Ινδονησία',
        'COUNTRY_IR' => 'Ιράν',
        'COUNTRY_IQ' => 'Ιράκ',
        'COUNTRY_IE' => 'Ιρλανδία',
        'COUNTRY_IL' => 'Ισραήλ',
        'COUNTRY_IT' => 'Ιταλία',
        'COUNTRY_JM' => 'Τζαμάϊκα',
        'COUNTRY_JP' => 'Ιαπωνία',
        'COUNTRY_JO' => 'Ιορδανία',
        'COUNTRY_KZ' => 'Καζαχστάν',
        'COUNTRY_KE' => 'Κένυα',
        'COUNTRY_KI' => 'Κιριμπάτι',
        'COUNTRY_KP' => 'Βόρεια Κορέα',
        'COUNTRY_KR' => 'Νότια Κορέα',
        'COUNTRY_KW' => 'Κουβέιτ',
        'COUNTRY_KG' => 'Κιργιζία',
        'COUNTRY_LA' => 'Λάος',
        'COUNTRY_LV' => 'Λεττονία',
        'COUNTRY_LB' => 'Λίβανος',
        'COUNTRY_LS' => 'Λεσόθο',
        'COUNTRY_LR' => 'Λιβερία',
        'COUNTRY_LY' => 'Λιβύη',
        'COUNTRY_LI' => 'Λιχτενστάϊν',
        'COUNTRY_LT' => 'Λιθουανία',
        'COUNTRY_LU' => 'Λουξεμβούργο',
        'COUNTRY_MO' => 'Μακάο',
        'COUNTRY_MK' => 'Πρώην Γιουγκοσλαβική Δημοκρατία της Μακεδονίας',
        'COUNTRY_MG' => 'Μαδαγασκάρη',
        'COUNTRY_MW' => 'Μαλάουι',
        'COUNTRY_MY' => 'Μαλαισία',
        'COUNTRY_MV' => 'Μαλδίβες',
        'COUNTRY_ML' => 'Μάλι',
        'COUNTRY_MT' => 'Μάλτα',
        'COUNTRY_MH' => 'Νήσοι Μάρσαλ',
        'COUNTRY_MQ' => 'Μαρτινίκα',
        'COUNTRY_MR' => 'Μαυριτανία',
        'COUNTRY_MU' => 'Μαυρίκιος',
        'COUNTRY_YT' => 'Μαγιότ',
        'COUNTRY_MX' => 'Μεξικό',
        'COUNTRY_FM' => 'Μικρονησία',
        'COUNTRY_MD' => 'Μολδαβία',
        'COUNTRY_MC' => 'Μονακό',
        'COUNTRY_MN' => 'Μογγολία',
        'COUNTRY_MS' => 'Μοντσεράτ',
        'COUNTRY_MA' => 'Μαρόκο',
        'COUNTRY_MZ' => 'Μοζαμβίκη',
        'COUNTRY_MM' => 'Μιανμάρ',
        'COUNTRY_NA' => 'Ναμίμπια',
        'COUNTRY_NR' => 'Ναουρού',
        'COUNTRY_NP' => 'Νεπάλ',
        'COUNTRY_NL' => 'Κάτω Χώρες',
        'COUNTRY_AN' => 'Ολλανδικές Αντίλλες',
        'COUNTRY_NC' => 'Νέα Καληδονία',
        'COUNTRY_NZ' => 'Νέα Ζηλανδία',
        'COUNTRY_NI' => 'Νικαράγουα',
        'COUNTRY_NE' => 'Νίγηρας',
        'COUNTRY_NG' => 'Νιγηρία',
        'COUNTRY_NU' => 'Νιούε',
        'COUNTRY_NF' => 'Νήσος Νόρφοκ',
        'COUNTRY_MP' => 'Νήσοι Βόρειες Μαριάνες',
        'COUNTRY_NO' => 'Νορβηγία',
        'COUNTRY_OM' => 'Ομάν',
        'COUNTRY_PK' => 'Πακιστάν',
        'COUNTRY_PW' => 'Παλάου',
        'COUNTRY_PS' => 'Κατεχόμενα Παλαιστινιακά Εδάφη',
        'COUNTRY_PA' => 'Παναμάς',
        'COUNTRY_PG' => 'Παπούα - Νέα Γουινέα',
        'COUNTRY_PY' => 'Παραγουάη',
        'COUNTRY_PE' => 'Περού',
        'COUNTRY_PH' => 'Φιλιππίνες',
        'COUNTRY_PN' => 'Νήσοι Πίτκαιρν',
        'COUNTRY_PL' => 'Πολωνία',
        'COUNTRY_PT' => 'Πορτογαλία',
        'COUNTRY_PR' => 'Πουέρτο Ρίκο',
        'COUNTRY_QA' => 'Κατάρ',
        'COUNTRY_RE' => 'Ρεϋνιόν',
        'COUNTRY_RO' => 'Ρουμανία',
        'COUNTRY_RU' => 'Ρωσία',
        'COUNTRY_RW' => 'Ρουάντα',
        'COUNTRY_SH' => 'Αγία Ελένη',
        'COUNTRY_KN' => 'Άγιος Χριστόφορος και Νέβις',
        'COUNTRY_LC' => 'Αγία Λουκία',
        'COUNTRY_PM' => 'Άγιος Πέτρος και Μικελόν',
        'COUNTRY_VC' => 'Άγιος Βικέντιος και Γρεναδίνες',
        'COUNTRY_WS' => 'Σαμόα',
        'COUNTRY_SM' => 'Άγιος Μαρίνος',
        'COUNTRY_ST' => 'Σάο Τομέ και Πρίνσιπε',
        'COUNTRY_SA' => 'Σαουδική Αραβία',
        'COUNTRY_SN' => 'Σενεγάλη',
        'COUNTRY_CS' => 'Σερβία και Μαυροβούνιο',
        'COUNTRY_SC' => 'Σεϋχέλλες',
        'COUNTRY_SL' => 'Σιέρρα Λεόνε',
        'COUNTRY_SG' => 'Σιγκαπούρη',
        'COUNTRY_SK' => 'Σλοβακία',
        'COUNTRY_SI' => 'Σλοβενία',
        'COUNTRY_SB' => 'Νήσοι Σολομώντος',
        'COUNTRY_SO' => 'Σομαλία',
        'COUNTRY_ZA' => 'Νότια Αφρική',
        'COUNTRY_GS' => 'Νήσοι Νότια Γεωργία και Νότιες Σάντουιτς',
        'COUNTRY_ES' => 'Ισπανία',
        'COUNTRY_LK' => 'Σρι Λάνκα',
        'COUNTRY_SD' => 'Σουδάν',
        'COUNTRY_SR' => 'Σουρινάμ',
        'COUNTRY_SJ' => 'Νήσοι Σφάλμπαρ και Γιαν Μαϋέν',
        'COUNTRY_SZ' => 'Σουαζιλάνδη',
        'COUNTRY_SE' => 'Σουηδία',
        'COUNTRY_CH' => 'Ελβετία',
        'COUNTRY_SY' => 'Συρία',
        'COUNTRY_TW' => 'Ταϊβάν',
        'COUNTRY_TJ' => 'Τατζικιστάν',
        'COUNTRY_TZ' => 'Τανζανία',
        'COUNTRY_TH' => 'Ταϊλάνδη',
        'COUNTRY_TL' => 'Ανατολικό Τιμόρ',
        'COUNTRY_TG' => 'Τόγκο',
        'COUNTRY_TK' => 'Τοκελάου',
        'COUNTRY_TO' => 'Τόνγκα',
        'COUNTRY_TT' => 'Τρινιντάντ και Τομπάγκο',
        'COUNTRY_TN' => 'Τυνησία',
        'COUNTRY_TR' => 'Τουρκία',
        'COUNTRY_TM' => 'Τουρκμενιστάν',
        'COUNTRY_TC' => 'Νήσοι Τέρκς και Κάικος',
        'COUNTRY_TV' => 'Τουβαλού',
        'COUNTRY_UG' => 'Ουγκάντα',
        'COUNTRY_UA' => 'Ουκρανία',
        'COUNTRY_AE' => 'Ηνωμένα Αραβικά Εμιράτα',
        'COUNTRY_GB' => 'Ηνωμένο Βασίλειο',
        'COUNTRY_US' => 'Ηνωμένες Πολιτείες',
        'COUNTRY_UM' => 'Απομακρυσμένες Νησίδες των Ηνωμένων Πολιτειών',
        'COUNTRY_UY' => 'Ουρουγουάη',
        'COUNTRY_UZ' => 'Ουζμπεκιστάν',
        'COUNTRY_VU' => 'Βανουάτου',
        'COUNTRY_VA' => 'Βατικανό',
        'COUNTRY_VE' => 'Βενεζουέλα',
        'COUNTRY_VN' => 'Βιετνάμ',
        'COUNTRY_VG' => 'Βρετανικές Παρθένοι Νήσοι',
        'COUNTRY_VI' => 'Αμερικανικές Παρθένες Νήσοι',
        'COUNTRY_WF' => 'Ουάλλις και Φουτούνα',
        'COUNTRY_EH' => 'Δυτική Σαχάρα',
        'COUNTRY_YE' => 'Υεμένη',
        'COUNTRY_ZM' => 'Ζάμπια',
        'COUNTRY_ZW' => 'Ζιμπάμπουε',
        'ERROR_LOG' => 'Αρχείο καταγραφής σφαλμάτων',
        'CANNOT_READ_ERROR_LOG' => 'Δεν είναι δυνατή η ανάγνωση του αρχείου καταγραφής σφαλμάτων',
        'CANNOT_OPEN_ERROR_LOG' => 'Δεν είναι δυνατό το άνοιγμα του αρχείου καταγραφής σφαλμάτων',
        'CANNOT_SCAN_ERROR_LOG' => 'Δεν είναι δυνατή η σάρωση του αρχείου καταγραφής σφαλμάτων',
        'MODELS_RESET' => 'Επαναφορά μοντέλων:',
        'NO_MODELS_RESET' => 'Χωρίς επαναφορά μοντέλων.',
        'NO_FEED_TO_DISPLAY' => 'Προς το παρόν δεν εμφανίζετε στοιχεία.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Αυτό το πλαίσιο δεν θα εμφανίζεται σε άλλα άτομα, εκτός εάν επιλέξετε τουλάχιστον ένα στοιχείο.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Κάντε κλικ στο Επεξεργασία για να καθορίσετε την τροφοδοσία RSS για αυτό το πλαίσιο.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Παρουσιάστηκε πρόβλημα κατά την ανάκτηση της τροφοδοσίας RSS.',
        'MORE_ELLIPSIS' => 'Περισσότερα...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Λυπούμαστε, αυτή η τοποθεσία έχει κάποιο πρόβλημα.',
        'PLEASE_TRY_REFRESHING' => 'Δοκιμάστε να ανανεώσετε τη σελίδα σε 30 δευτερόλεπτα ή <a %s>ενημερώστε μας</a> εάν λάβετε ξανά αυτό το μήνυμα.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Δεν υπάρχουν συζητήσεις με ετικέτα "%1$s".',
        'PAGE_TITLE_COLON' => 'Τίτλος σελίδας:',
        'PAGE_CONTENT' => 'Περιεχόμενο:',
        'CREATE_PAGE' => 'Δημιουργία σελίδας',
        'CREATE_NEW_PAGE' => 'Δημιουργία νέας σελίδας',
        'YOUR_COMMENT' => 'Το σχόλιό σας',
        'ADD_YOUR_COMMENT' => 'Προσθήκη του σχολίου σας',
        'DELETE_PAGE' => 'Διαγραφή της σελίδας',
        'DELETE_THIS_PAGE_Q' => 'Να γίνει διαγραφή της σελίδας;',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτή τη σελίδα (συμπεριλαμβανομένων όλων των σχολίων)  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'SEARCH_PAGES' => 'Αναζήτηση σελίδων',
        'ALL_PAGES' => 'Όλες οι σελίδες',
        'SUBSCRIBE_TO_PAGES' => 'Εγγραφή σε αυτές τις σελίδες',
        'NOBODY_HAS_ADDED_PAGES' => 'Κανείς δεν έχει προσθέσει σελίδες έως αυτή τη στιγμή!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Δημιουργήστε μια σελίδα για να ξεκινήσετε.',
        'CREATE_A_PAGE' => 'Δημιουργία σελίδας',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Εισάγετε το περιεχόμενο σελίδας',
        'SEARCH_RESULTS_FOR_X' => 'Αποτελέσματα αναζήτησης για <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Επεξεργασία της σελίδας σας',
        'UPDATE_PAGE' => 'Ενημέρωση σελίδας',
        'CLOSE_DISCUSSION' => 'Κλείσιμο συζήτησης',
        'REOPEN_DISCUSSION' => 'Νέο άνοιγμα της συζήτησης',
        'CLOSING_DISCUSSION_PREVENTS' => 'Το κλείσιμο μιας συζήτησης δεν επιτρέπει περαιτέρω απαντήσεις',
        'NO_DISCUSSION_TO_DISPLAY' => 'Προς το παρόν, δεν εμφανίζετε συζητήσεις.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί σε άλλα άτομα, εκτός εάν επιλέξετε τουλάχιστον μια συζήτηση.',
        'NEWEST_DISCUSSIONS' => 'Πιο καινούργιες συζητήσεις',
        'LATEST_REPLIES' => 'Πιο πρόσφατες απαντήσεις',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Οι απαντήσεις σε αυτή τη συζήτηση έχουν κλείσει.',
        'SORRY_DISCUSSION_CLOSED' => 'Λυπούμαστε, αυτή η συζήτηση έχει μόλις κλείσει και δεν γίνονται δεκτές περαιτέρω απαντήσεις.',
        'MOST_REPLIES' => 'Οι περισσότερες απαντήσεις',
        'OWNER_DISCUSSIONS_ONLY' => 'Μόνο συζητήσεις του δημιουργού',
        'MY_DISCUSSIONS_ONLY' => 'Μόνο οι συζητήσεις μου',
        'DISCUSSION_DELETED' => 'Η συζήτηση έχει διαγραφεί',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Αυτή η συζήτηση δεν είναι πλέον διαθέσιμη.',
        'REPLY_DELETED' => 'Η απάντηση έχει διαγραφεί',
        'REPLY_HAS_BEEN_DELETED' => 'Αυτή η απάντηση έχει διαγραφεί.  <a %s>Επιστροφή στη συζήτηση. </a>',
        'VIEW_ALL_DISCUSSIONS' => 'Προβολή όλων των συζητήσεων',
        'ADD_CATEGORIES' => 'Προσθήκη κατηγοριών',
        'CATEGORY' => 'Κατηγορία:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'Δεν υπάρχουν ακόμα συζητήσεις σε αυτή την κατηγορία.',
        'ADD_MANAGE_CATEGORIES' => 'Προσθήκη/Διαχείριση κατηγοριών',
        'VIEW_ALL_N_CATEGORIES' => 'Προβολή όλων των κατηγοριών %s',
        'UNTITLED_CATEGORY' => 'Κατηγορία χωρίς τίτλο',
        'SAMPLE_TITLE' => 'Δείγμα τίτλου',
        'UNCATEGORIZED' => 'Χωρίς κατηγορία',
        'EXISTING_DISCUSSIONS' => 'Υφιστάμενες συζητήσεις που δεν έχουν ενταχθεί σε μια κατηγορία.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Αυτή τη στιγμή δεν υπάρχουν κατηγορίες.  Προσθέστε μια κατηγορία για να ξεκινήσετε!',
        'ADD_A_CATEGORY' => 'Προσθήκη κατηγορίας',
        'ADD_ANOTHER_CATEGORY' => 'Προσθήκη άλλης κατηγορίας',
        'MANAGE_CATEGORIES' => 'Διαχείριση κατηγοριών',
        'CATEGORY_TITLE' => 'Τίτλος κατηγορίας',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Να επιτρέπεται στα μέλη να ξεκινούν συζητήσεις σε αυτή την κατηγορία',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Μόνο εγώ μπορώ να ξεκινώ συζητήσεις σε αυτή την κατηγορία',
        'ALLOW_MEMBERS_TO_REPLY' => 'Να επιτρέπεται στα μέλη να απαντούν',
        'SUGGESTIONS' => 'Προτάσεις:',
        'TRY_DIFFERENT_KEYWORDS' => 'Δοκιμάστε διαφορετικές ή πιο γενικές λέξεις-κλειδιά',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Προβολή όλων των συζητήσεων</a> ή <a %s>Εκκίνηση νέας συζήτησης</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Βεβαιωθείτε ότι όλες οι λέξεις είναι ορθογραφημένες σωστά.',
        'REPLY_WAS_DELETED' => 'Αυτή η απάντηση διαγράφηκε',
        'TAGS_X' => '<strong>Ετικέτες:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Αποστολή προσωπικού μηνύματος',
        'PERMALINK_TO_REPLY' => 'Permalink σε αυτή την απάντηση',
        'PERMALINK' => 'Permalink',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Λυπούμαστε, δεν καταφέραμε να εντοπίσουμε συζητήσεις που να ταιριάζουν στην αναζήτησή σας.',
        'DISCUSSIONS_MATCHING_X' => 'Συζητήσεις που ταιριάζουν με <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Αναζήτηση συζητήσεων',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Δεν έχετε προσθέσει ακόμη συζητήσεις!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Προσθέστε συζητήσεις και μοιραστείτε τις με τους φίλους, την οικογένεια ή τον υπόλοιπο κόσμο!',
        'DISCUSSION' => 'Συζήτηση',
        'DISCUSSIONS' => 'Συζητήσεις',
        'KEEP_PAGE_OPEN_FORUM' => 'Κρατήστε ανοικτή αυτή τη σελίδα, ώστε να μπορέσουμε να ολοκληρώσουμε την αποστολή των αρχείων σας στο φόρουμ.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Στο μεταξύ, μπορείτε να <a %s>ανοίξετε ένα νέο παράθυρο στο πρόγραμμα περιήγησης</a> και να συνεχίσετε τη χρήση του %s.',
        'START_A_NEW_DISCUSSION' => 'Εκκίνηση νέας συζήτησης',
        'DISCUSSION_TITLE' => 'Τίτλος συζήτησης:',
        'FIRST_POST' => 'Καταχώρηση:',
        'UPLOAD_FILES' => 'Επισύναψη αρχείων:',
        'START_DISCUSSION' => 'Εκκίνηση συζήτησης',
        'EDIT_DISCUSSION' => 'Επεξεργασία συζήτησης',
        'START_A_DISCUSSION' => 'Εκκίνηση μιας συζήτησης',
        'ALL_DISCUSSIONS' => 'Αρχική σελίδα φόρουμ',
        'CONTRIBUTORS' => 'Συνεργάτες',
        'MY_DISCUSSIONS' => 'Οι συζητήσεις μου',
        'READ_MORE' => 'Διαβάστε περισσότερα',
        'STARTED_T_BY' => 'Ξεκίνησε <strong>%s</strong> από τον/την:',
        'ADDED_BY_X_T' => 'Προστέθηκε από τον/την %s %s',
        'STARTED_BY_X_T' => 'Ξεκίνησε από τον/την %s %s',
        'REPLY_BY_X_T' => 'Απάντηση από τον/την <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Ξεκίνησε από τον/την %s.  Τελευταία <a %s>απάντηση</a> από %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Ξεκίνησε αυτή τη συζήτηση. </strong> Τελευταία <a %s>απάντηση</a> από %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>Ξεκίνησε αυτή τη συζήτηση</strong> %s',
        'ADDED_REPLY_T' => '<strong>Προσέθεσε απάντηση</strong> %s',
        'ADDED_POST_T' => '<strong>Προσέθεσε καταχώρηση</strong> %s',
        'STARTED_BY_X_ON' => 'Ξεκίνησε από τον/την %s στο %s',
        'STARTED_DISCUSSION_ON' => '<strong>Ξεκίνησε αυτή τη συζήτηση</strong> %s',
        'STARTED_ON' => '<strong>Ξεκίνησε</strong> %s',
        'ADDED_REPLY_ON' => '<strong>Προσέθεσε απάντηση</strong> %s',
        'ADDED_POST_ON' => '<strong>Προσέθεσε καταχώρηση</strong> %s',
        'XS_DISCUSSIONS' => 'Συζητήσεις του/της %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'Συζητήσεις του/της %s',
        'VIEW_XS_DISCUSSIONS' => 'Προβολή συζητήσεων του/της %s',
        'VIEW_YOUR_DISCUSSIONS' => 'Προβολή των συζητήσεών σας',
        'TAGGED_X' => 'Επισήμανση με ετικέτα: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Εγγραφή σε αυτές τις συζητήσεις',
        'SUBSCRIBE_TO_DISCUSSION' => 'Εγγραφή σε αυτή τη συζήτηση',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Εγγραφή στις συζητήσεις του/της %s',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Όλες οι συζητήσεις με ετικέτα <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Εγγραφή σε συζητήσεις με ετικέτα \'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Γίνεται αποστολή αρχείων',
        'ATTACHMENTS' => 'Συνημμένα',
        'YOUR_POST' => 'Η καταχώρησή σας:',
        'YOUR_REPLY' => 'Η απάντησή σας:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Θα θέλατε να αποστείλετε αρχεία;',
        'ADD_YOUR_REPLY' => 'Προσθέστε την απάντησή σας',
        'REPLIES_TO_THIS_DISCUSSION' => 'Απαντήσεις σε αυτή τη συζήτηση',
        'POSTED_BY_X_ON' => 'Καταχωρήθηκε από τον/την %s %s',
        'PLEASE_ENTER_TITLE' => 'Εισάγετε έναν τίτλο για τη συζήτηση',
        'PLEASE_ENTER_FIRST_POST' => 'Γράψτε την πρώτη καταχώρηση για τη συζήτηση.',
        'REPLY_TO_THIS' => 'Απάντηση σε αυτό',
        'DELETE_ATTACHMENT' => 'Διαγραφή συνημμένου',
        'DELETE_ATTACHMENT_Q' => 'Να γίνει διαγραφή του συνημμένου;',
        'DELETE_REPLY' => 'Διαγραφή απάντησης',
        'DELETE_THIS_DISCUSSION_Q' => 'Να γίνει διαγραφή της συζήτησης;',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτή τη συζήτηση (συμπεριλαμβανομένων όλων των απαντήσεων)  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'DELETE_DISCUSSION' => 'Διαγραφή συζήτησης',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Κανείς δεν έχει προσθέσει ακόμα συζητήσεις.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Κανείς δεν έχει προσθέσει ακόμα συζητήσεις!  Προσθέστε μια συζήτηση για να ξεκινήσετε.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Δεν έχετε προσθέσει ακόμη συζητήσεις.  Προσθέστε μια συζήτηση για να ξεκινήσετε!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Δεν έχετε ξεκινήσει ακόμη συζητήσεις.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Δεν έχετε προσθέσει ακόμη στοιχεία σε συζητήσεις.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => 'Ο/η %s δεν έχει προσθέσει ακόμη συζητήσεις.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => 'Ο/η %s δεν έχει ξεκινήσει ακόμη συζητήσεις.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => 'Ο/η %s δεν έχει προσθέσει ακόμη στοιχεία σε συζητήσεις.',
        'VIEW_DISCUSSIONS' => 'Προβολή συζητήσεων',
        'VIEW_ALL_PEOPLE_ON_X' => 'Προβολή όλων των ατόμων στο %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'Αυτή τη στιγμή δεν υπάρχουν συζητήσεις στο δίκτυό σας.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Αυτή η ομάδα δεν διαθέτει ακόμη συζητήσεις.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Προβάλετε τις συζητήσεις στο <a %s>φόρουμ %s</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Δεν υπάρχουν συζητήσεις με ετικέτα "%1$s".  Δείτε <a %2$s>φωτογραφίες με ετικέτα "%1$s"</a> ή <a %3$s>βίντεο με ετικέτα "%1$s"</a>.  Ή προσθέστε και επισημάνετε με ετικέτες τις δικές σας συζητήσεις!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Δεν υπάρχουν συζητήσεις με ετικέτα "%1$s".  Δείτε <a %2$s>φωτογραφίες με ετικέτα "%1$s"</a> ή <a %3$s>βίντεο με ετικέτα "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί σε τρίτους εάν δεν υπάρχουν συζητήσεις για εμφάνιση.  Γιατί δεν ξεκινάτε μία;',
        'DISCUSSIONS_I_STARTED' => 'Συζητήσεις που ξεκίνησα',
        'DISCUSSIONS_X_STARTED' => 'Συζητήσεις που ξεκίνησε ο/η %s',
        'DISCUSSIONS_I_REPLIED_TO' => 'Συζητήσεις στις οποίες απάντησα',
        'DISCUSSIONS_X_REPLIED_TO' => 'Συζητήσεις στις οποίες απάντησε ο/η %s',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Γράψτε κάτι για την καταχώρησή σας.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Γράψτε κάτι για την απάντησή σας.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Υπάρχει ένα νέο σχόλιο για τη συζήτησή σας "%s" στο %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Υπάρχει ένα νέο σχόλιο για μια από τις συζητήσεις σας στο %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'κάποιος έκανε σχόλιο για μια συζήτηση που ξεκινήσατε στο %s',
        'ABOUT_YOUR_DISCUSSION' => 'Πληροφορίες για τη συζήτησή σας',
        'ABOUT_THIS_DISCUSSION' => 'Πληροφορίες για αυτή τη συζήτηση',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => 'Ο/Η %s απάντησε σε μια συζήτηση στο %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => 'Ο/Η %s απάντησε στη συζήτηση "%s" στο %s',
        'PROBLEM_WITH_ICON' => 'Παρουσιάστηκε πρόβλημα στο αρχείο εικονιδίου',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Οι διαχειριστές ομάδας διαθέτουν παρόμοιο επίπεδο ελέγχου με το Δημιουργό ομάδας.',
        'CREATE_NEW_GROUP' => 'Δημιουργία νέας ομάδας',
        'CREATE_A_NEW_GROUP' => 'Δημιουργία νέας ομάδας',
        'CREATE_A_GROUP' => 'Δημιουργία ομάδας',
        'VIEW_GROUPS' => 'Προβολή ομάδων',
        'CREATE_GROUP' => 'Δημιουργία ομάδας',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Επιλέξτε ένα όνομα για την ομάδα σας.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Επιλέξτε μια διεύθυνση Web για την ομάδα σας.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'Η διεύθυνση Web μπορεί να περιέχει μόνο γράμματα και αριθμούς (χωρίς κενά διαστήματα).',
        'NAME_TAKEN' => 'Λυπούμαστε, αλλά αυτό το όνομα χρησιμοποιείται ήδη από άλλον.  Επιλέξτε διαφορετικό όνομα.',
        'URL_TAKEN' => 'Λυπούμαστε, αλλά αυτή η διεύθυνση Web χρησιμοποιείται ήδη από άλλον.  Επιλέξτε διαφορετική διεύθυνση Web.',
        'GROUP_INFORMATION' => 'Πληροφορίες ομάδας',
        'EXTERNAL_WEBSITE' => 'Εξωτερική τοποθεσία Web',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Έχετε ήδη κάποια τοποθεσία Web κάπου αλλού;',
        'URL' => 'Διεύθυνση URL',
        'GROUPS' => 'Ομάδες',
        'SEARCH_GROUPS' => 'Αναζήτηση ομάδων',
        'NOBODY_HAS_CREATED_GROUPS' => 'Κανείς δεν έχει δημιουργήσει ακόμα ομάδες.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Κανείς δεν έχει δημιουργήσει ακόμα ομάδες!  Δημιουργήστε μια ομάδα για να ξεκινήσετε.',
        'MY_GROUPS' => 'Οι ομάδες μου',
        'FEATURED_GROUPS' => 'Προβεβλημένες ομάδες',
        'YOU_CAN_CREATE_GROUP' => 'Μπορείτε να <a %s>δημιουργήσετε μια νέα ομάδα</a> στο %s!',
        'GROUP_FORUM' => 'Φόρουμ %s',
        'USER_CREATED_GROUP' => 'Ο/Η %s έχει δημιουργήσει αυτή την ομάδα στο %s.',
        'GROUP_MEMBERS_COUNT' => '%s μέλη (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Δυστυχώς, δεν επιτρέπεται να γίνετε μέλος σε αυτή την ομάδα.',
        'JOIN_GROUP_NOW' => 'Γίνετε μέλος στο %s τώρα!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => 'Ο/η %s σας έχει προσκαλέσει να γίνετε μέλος στο %s',
        'DECLINE' => 'Απόρριψη',
        'WELCOME_TO_GROUP' => 'Καλωσορίσατε στο %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Μπορείτε τώρα να γίνετε μέλος στο φόρουμ %s.',
        'SEND_MESSAGE_TO_GROUP' => 'Αποστολή μηνύματος στην ομάδα',
        'LEAVE_THIS_GROUP' => 'Έξοδος από την ομάδα',
        'EDIT_GROUP_INFO' => 'Επεξεργασία πληροφοριών αυτής της ομάδας',
        'EDIT_GROUP_INFORMATION' => 'Επεξεργασία πληροφοριών ομάδας',
        'MANAGE_GROUP_MEMBERS' => 'Διαχείριση μελών ομάδας',
        'GROUP_HAS_NO_MEMBERS' => 'Αυτή η ομάδα δεν έχει ακόμα μέλη!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Αυτή η ομάδα δεν έχει μέλη που να ταιριάζουν στην αναζήτησή σας.',
        'USERS_GROUPS' => 'Ομάδες του/της %s',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Δεν έχετε δημιουργήσει ακόμη ομάδες.',
        'USER_HAS_NOT_CREATED_GROUPS' => 'Ο/Η %s δεν έχει δημιουργήσει ακόμη ομάδες.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Δεν υπάρχουν προβεβλημένες ομάδες στο κοινωνικό σας δίκτυο.',
        'START_FEATURING_GROUPS' => 'Αρχίστε να προβάλλετε ομάδες, όταν δείτε την επιλογή Χαρακτηριστικό.  Για να μάθετε περισσότερα σχετικά με την προβολή χαρακτηριστικών, <a %s>κάντε κλικ εδώ</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'Προς το παρόν, δεν εμφανίζετε ομάδες.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Αυτό το πλαίσιο δεν θα εμφανίζεται σε άλλα άτομα, εκτός εάν επιλέξετε τουλάχιστον μία ομάδα.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Δεν έχετε δημιουργήσει ακόμη ομάδες!',
        'CREATE_GROUPS_AND_SHARE' => 'Δημιουργήστε ομάδες και μοιραστείτε τις με τους φίλους, την οικογένεια ή τον υπόλοιπο κόσμο!',
        'THERE_ARE_NO_GROUPS' => 'Προς το παρόν, δεν υπάρχουν ομάδες στο δίκτυό σας.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Αυτό το πλαίσιο δεν θα εμφανίζεται σε τρίτους, εάν δεν υπάρχουν ομάδες για εμφάνιση.  Γιατί δεν δημιουργείτε μια ομάδα;',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Ομάδες που ταιριάζουν με <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Λυπούμαστε, δεν καταφέραμε να εντοπίσουμε ομάδες που να ταιριάζουν στην αναζήτησή σας.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Προβολή όλων των ομάδων</a> ή <a %s>Δημιουργία νέας ομάδας</a>',
        'VIEW_ALL_GROUPS' => 'Προβολή όλων των ομάδων',
        'DELETE_GROUP' => 'Διαγραφή ομάδας',
        'DELETE_GROUP_Q' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτή την ομάδα;',
        'GROUP_INVITATIONS' => 'Προσκλήσεις ομάδας',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Σας έγινε πρόσκληση να γίνετε μέλος:',
        'VISIT' => 'Επίσκεψη',
        'WHO_CAN_JOIN_GROUP' => 'Ποιος μπορεί να γίνει μέλος σε αυτή την ομάδα;',
        'PRIVACY_CANNOT_BE_CHANGED' => 'Η πολιτική απορρήτου δεν μπορεί να αλλάξει μετά τη δημιουργία της ομάδας.',
        'ONLY_INVITED_PEOPLE' => 'Μόνο άτομα που έχουν προσκληθεί',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Να επιτρέπεται σε άλλους να ζητάνε πρόσκληση',
        'ANYONE_CAN_JOIN_GROUP' => 'Σε αυτή την ομάδα μπορούν όλοι να γίνουν μέληι',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Σε αυτή την ομάδα μπορούν να γίνουν μέλη μόνο όσα άτομα έχουν λάβει πρόσκληση',
        'WHY_NOT_CREATE_GROUP' => 'Γιατί δεν <a %s>δημιουργείτε τη δική σας ομάδα</a>;',
        'PLEASE_ENTER_NAME' => 'Εισάγετε το όνομά σας',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Εισάγετε τη διεύθυνση ηλεκτρονικού ταχυδρομείου σας.',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Πληκτρολογήστε μια νέα διεύθυνση σελίδας.',
        'PLEASE_ENTER_PASSWORD' => 'Πληκτρολογήστε τον κωδικό πρόσβασης.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Κάντε κλικ εδώ για να δημιουργήσετε ένα λογαριασμό</a> ή δοκιμάστε να συνδεθείτε ξανά παρακάτω.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Κάντε κλικ εδώ για να δημιουργήσετε ένα λογαριασμό</a> ή δοκιμάστε να γίνετε μέλος ξανά με το αναγνωριστικό Ning παρακάτω.',
        'CHOOSE_SHORTER_PASSWORD' => 'Επιλέξτε έναν μικρότερο κωδικό πρόσβασης.',
        'CHOOSE_SHORTER_NAME' => 'Επιλέξτε ένα μικρότερο όνομα.',
        'ENTER_SHORTER_CITY_NAME' => 'Πληκτρολογήστε ένα μικρότερο όνομα πόλης.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Πληκτρολογήστε ξανά τον κωδικό πρόσβασης στο πλαίσιο "Επαναπληκτρολογήστε τον κωδικό πρόσβασης"',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Πληκτρολογήστε τον τρέχοντα κωδικό πρόσβασης.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Πληκτρολογήστε το νέο κωδικό πρόσβασης.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Πληκτρολογήστε ξανά το νέο κωδικό πρόσβασης στο πλαίσιο "Επιβεβαίωση κωδικού πρόσβασης".',
        'CURRENT_PASSWORD' => 'Τρέχων κωδικός πρόσβασης',
        'PASSWORDS_DO_NOT_MATCH' => 'Οι δύο κωδικοί πρόσβασης δεν ταιριάζουν.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'Ο νέος κωδικός πρόσβασης και ο κωδικός πρόσβασης επιβεβαίωσης δεν ταιριάζουν.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Η αίτησή σας έχει αποσταλεί στο δημιουργό της ομάδας.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => 'Το %s δεν είναι έγκυρη διεύθυνση ηλεκτρονικού ταχυδρομείου',
        'COME_JOIN_ME_ON_GROUP' => 'Ελάτε να συμμετάσχετε μαζί μου στο %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Πρόσκληση σε άλλους για το %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Πρόσκληση σε φίλους για το %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Αποστείλετε προσκλήσεις σε άλλους για να γίνουν μέλη στο %s.',
        'GROUPNAME_MEMBERS' => 'Μέλη %s',
        'GROUP_CREATOR' => 'Δημιουργός ομάδας',
        'GROUP_ADMINISTRATOR' => 'Διαχειριστής ομάδας',
        'DATE_BANNED' => 'Ημερομηνία απαγόρευσης',
        'BAN_FROM_GROUP' => 'Απαγόρευση για την ομάδα',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Είστε βέβαιοι ότι θέλετε να απαγορεύσετε τα επιλεγμένα μέλη για την ομάδα σας;  Αυτή η διαδικασία μπορεί να διαρκέσει μερικά λεπτά.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Με διαγραφή των καταχωρήσεων στα φόρουμ και των απαντήσεών τους.',
        'GROUP_WEB_ADDRESS' => 'Διεύθυνση Web της ομάδας',
        'GROUP' => 'Ομάδα',
        'BACK_TO_GROUP' => '← Επιστροφή στο %s',
        'USER_BANNED_FROM_GROUP' => 'Έχει απαγορευθεί στον/στην %1$s να γίνει μέλος σε αυτή την ομάδα.  <a %2$s>Στείλτε στον/στην %1$s ένα μήνυμα</a>',
        'USER_ALREADY_GROUP_MEMBER' => 'Ο/Η %1$s είναι ήδη μέλος αυτής της ομάδας.  <a %2$s>Στείλτε στον/στην %1$s ένα μήνυμα</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Συζητήσεις διαχειριστή ομάδας',
        'BACK_TO_NETWORK_GROUPS' => 'Επιστροφή στις ομάδες %s',
        'MOST_MEMBERS' => 'Τα περισσότερα μέλη',
        'THIS_SETS_URL_OF_GROUP' => 'Εδώ ορίζεται η διεύθυνση URL της ομάδας σας:<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Σας αρέσει αυτό που βλέπετε στο %s;  Γίνετε μέλος τώρα!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Σας αρέσει αυτό που βλέπετε στο %s;  Γίεντε μέλος τώρα!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Έχετε δημιουργήσει την ομάδα %1$s. Μπορείτε να ξεκινήσετε μια συζήτηση στο φόρουμ %1$s ή να προσκαλέσετε περισσότερα άτομα να συμμετάσχουν.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Τώρα είστε μέλος του %1$s.  Μπορείτε να λάβετε μέρος στο φόρουμ %1$s ή να προσκαλέσετε περισσότερα άτομα για να γίνουν μέλη.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Αυτό το δίκτυο δεν διαθέτει ακόμη μουσική.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Αυτό το άτομο δεν διαθέτει ακόμα μουσική.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Βρείτε περισσότερη μουσική σαν κι αυτή στο <em>%s</em>',
        'TRACKS' => 'Κομμάτια',
        'ADD_MUSIC_TRACKS' => 'Προσθήκη μουσικής',
        'CHOOSE_MUSIC_TRACKS' => 'Επιλογή τραγουδιών για προσθήκη',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Μπορείτε να προσθέσετε έως 4 MP3 τη φορά.',
        'UPLOAD_TRACKS' => 'Αποστολή τραγουδιών',
        'ADD_TRACKS' => 'Προσθήκη τραγουδιών',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Πληκτρολογήστε τη διεύθυνση URL για κάθε MP3 που θέλετε να προσθέσετε:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Μπορείτε να αποστείλετε έως 100 MP3!  Κάθε αρχείο MP3 μπορεί να έχει μέγεθος έως 20 MB, αλλά τα μικρότερα αρχεία θα αποστέλλονται πιο γρήγορα.',
        'BE_NICE' => 'Να συμπεριφέρεστε σωστά',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Να αποστέλλετε τραγούδια μόνον εάν έχετε την απαιτούμενη άδεια από τον καλλιτέχνη ή τον κάτοχο των πνευματικών δικαιωμάτων.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Δημοσιεύετε συνδέσεις μόνον για μουσική, η οποία διαθέτει έγκριση για διανομή στο Web.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Περισσότεροι τρόποι προσθήκης μουσικής...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '...από άλλη τοποθεσία Web',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Προσθέστε μουσική από οποιαδήποτε τοποθεσία Web με επικόλληση μιας σύνδεσης στο ΜΡ3.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Κρατήστε αυτή τη σελίδα ανοικτή, για να μπορέσουμε να ολοκληρώσουμε την αποστολή των τραγουδιών σας και θα σας ενημερώσουμε για το χρόνο έγκρισής τους!',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Στο μεταξύ, μπορείτε να <a %s>ανοίξετε ένα νέο παράθυρο στο πρόγραμμα περιήγησης</a> και να συνεχίσετε τη χρήση του %s.  Όταν ολοκληρωθεί η αποστολή, θα μπορέσετε να προσθέσετε τίτλους και περιγραφές στα τραγούδια που βρίσκονται σε αυτό το παράθυρο.',
        'TRACKS_EXCEEDED_LIMIT' => 'Τα κομμάτια φαίνεται ότι υπερβαίνουν το όριο των 10 ΜΒ ανά τραγούδι.',
        'EDIT_TRACK_INFORMATION' => 'Επεξεργασία πληροφοριών τραγουδιού',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Προσθέστε τίτλο, περιγραφή και άλλες πληροφορίες στα τραγούδια που μόλις αποστείλατε.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Προσθέστε τίτλο, περιγραφή και άλλες πληροφορίες σε αυτό το τραγούδι.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Ακύρωση και επιστροφή στη λίστα αναπαραγωγής',
        'TRACK_TITLE' => 'Τίτλος τραγουδιού',
        'TRACK_ARTIST' => 'Καλλιτέχνης',
        'TRACK_ALBUM' => 'Άλμπουμ',
        'ENABLE_DOWNLOAD_LINK' => 'Ενεργοποίηση σύνδεσης λήψης',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Να επιτρέπεται σε άλλους να τοποθετούν αυτό το τραγούδι στις σελίδες τους',
        'TRACK_ARTWORK' => 'Γραφικό',
        'EDIT_PLAYLIST' => 'Επεξεργασία λίστας αναπαραγωγής',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Για να αλλάξετε σειρά στη λίστα αναπαραγωγής σας, κάντε κλικ στο τραγούδι και σύρετέ το εκεί όπου θέλετε να αναπαραχθεί.',
        'ADD_MUSIC_ELLIPSIS' => 'Προσθήκη μουσικής...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '...από τον υπολογιστή σας',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Αποστείλετε MP3 από τον υπολογιστή σας.',
        'DELETE_THIS_TRACK_Q' => 'Να γίνει διαγραφή του τραγουδιού;',
        'DELETE_TRACK' => 'Διαγραφή τραγουδιού',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτό το τραγούδι;',
        'PLAY' => 'αναπαραγωγή',
        'GENRE' => 'Είδος',
        'YEAR' => 'Έτος',
        'LABEL' => 'Ετικέτα',
        'EXPLICIT_LYRICS' => 'Στίχοι με σεξουαλικά υπονοούμενα',
        'ARTIST_SITE' => 'Τοποθεσία καλλιτέχνη',
        'HOSTING_SITE' => 'Κεντρική τοποθεσία',
        'LABEL_SITE' => 'Τοποθεσία ετικέτας',
        'LICENSE' => 'Άδεια χρήσης',
        'SELECT_LICENSE' => '— Select license —',
        'LICENSE_NAME' => 'Όνομα άδειας χρήσης',
        'LICENSE_URL' => 'Διεύθυνση URL άδειας χρήσης',
        'MUSIC' => 'Μουσική',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Να επιτρέπεται σε άλλους να αποστέλλουν και να μοιράζονται ήχο',
        'PLAYLIST' => 'Λίστα αναπαραγωγής',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Πιο πρόσφατο',
        'FEATURED_TRACKS' => 'Χαρακτηριστικό',
        'HIGHEST_RATED_TRACKS' => 'Με την υψηλότερη αξιολόγηση',
        'NO_TRACKS_TO_PLAY' => 'Αυτή τη στιγμή δεν υπάρχει μουσική στο δίκτυό σας.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί σε άλλους, εάν δεν υπάρχει τραγούδι ή podcast για αναπαραγωγή.  Γιατί δεν προσθέτετε ένα;',
        'NO_TRACKS_ON_PLAYLIST' => 'Αυτή τη στιγμή δεν υπάρχουν τραγούδια στη λίστα αναπαραγωγής.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Αυτό το πρόγραμμα αναπαραγωγής δεν θα εμφανιστεί σε άλλους, εάν δεν υπάρχει τραγούδι ή podcast για αναπαραγωγή.  Γιατί δεν προσθέτετε ένα;',
        'NO_FEATURED_TRACKS' => 'Δεν υπάρχουν προβεβλημένα τραγούδια στο δίκτυό σας.',
        'START_FEATURING_TRACKS' => 'Ξεκινήστε να προβάλλετε τραγούδια, εάν ακούσετε κάποιο που θα θέλατε να εμφανίζεται στην Αρχική σελίδα.',
        'VIEW_MUSICPLAYER' => 'Προβολή προγράμματος αναπαραγωγής μουσικής',
        'MY_PLAYLIST' => 'Η λίστα αναπαραγωγής μου',
        'NETWORK_PLAYLIST' => 'Λίστα αναπαραγωγής δικτύου',
        'COPYRIGHT' => '© Με επιφύλαξη παντός δικαιώματος',
        'CC_BY_X' => 'Creative Commons Attribution %s',
        'CC_BY_SA_X' => 'Creative Commons Attribution Share Alike %s',
        'CC_BY_ND_X' => 'Creative Commons Attribution No Derivatives %s',
        'CC_BY_NC_X' => 'Creative Commons Attribution Non-commercial %s',
        'CC_BY_NC_SA_X' => 'Creative Commons Attribution Non-commercial Share Alike %s',
        'CC_BY_NC_ND_X' => 'Creative Commons Attribution Non-commercial No Derivatives %s',
        'PUBLICDOMAIN' => 'Δημόσιος τομέας',
        'FACEBOOK_CONFIRM_DISABLE' => 'Είστε σίγουροι;',
        'FACEBOOK_PLAYER_DISABLE' => 'Απενεργοποίηση',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Πρόγραμμα αναπαραγωγής μουσικής',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Να επιτρέπεται σε όλους η προσθήκη στις σελίδες προφίλ του Facebook μιας εφαρμογής, η οποία αναπαράγει τη μουσική επιλογή σας.',
        'FACEBOOK_MUSIC_BUTTON' => 'Δημιουργία εφαρμογής μουσικής &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Το πρόγραμμα αναπαραγωγής μουσικής του Facebook είναι ήδη ενεργοποιημένο.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Πρόγραμμα αναπαραγωγής βίντεο',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Να επιτρέπεται σε όλους η προσθήκη στις σελίδες προφίλ του Facebook μιας εφαρμογής, η οποία αναπαράγει ένα βίντεο από το δίκτυό σας.',
        'FACEBOOK_VIDEO_BUTTON' => 'Δημιουργία εφαρμογής βίντεο &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Το πρόγραμμα αναπαραγωγής βίντεο του Facebook είναι ήδη ενεργοποιημένο.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Προβολή παρουσίασης φωτογραφιών',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Να επιτρέπεται σε όλους η προσθήκη στις σελίδες προφίλ του Facebook μιας εφαρμογής, η οποία αναπαράγει μια προβολή παρουσίασης φωτογραφιών από το δίκτυό σας.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Δημιουργία εφαρμογής προβολής παρουσίασης φωτογραφιών &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Η προβολή παρουσίασης φωτογραφιών Facebook είναι ήδη ενεργοποιημένη.',
        'FACEBOOK_PLATFORM_LOGO' => 'Λογότυπο πλατφόρμας Facebook',
        'FACEBOOK_QUICK_INTRO_1' => 'Το Facebook, μια δημοφιλής τοποθεσία κοινωνικής δικτύωσης, επιτρέπει σε ανεξάρτητους μηχανικούς λογισμικού να δημιουργήσουν εφαρμογές, οι οποίες μπορούν να προστεθούν στις σελίδες προφίλ των μελών του Facebook.  Πέραν της παροχής επιπρόσθετης λειτουργικότητας στις σελίδες προφίλ, αυτές οι εφαρμογές μπορούν να χρησιμοποιηθούν για την καθοδήγηση των χρηστών του Facebook σε άλλους προορισμούς στο Web.',
        'FACEBOOK_QUICK_INTRO_2' => 'Με το Ning δεν χρειάζεται να είστε μηχανικός λογισμικού για να προωθήσετε το κοινωνικό σας δίκτυο μέσα στο Facebook.  Έχουμε κάνει όλη την προεργασία και το δίκτυό σας διαθέτει ήδη ενσωματωμένη ενοποίηση εφαρμογών Facebook.  Απλά επιλέξτε μεταξύ των ακόλουθων επιλογών και το κοινωνικό σας δίκτυο θα ενοποιηθεί με το Facebook μέσα σε λίγα δευτερόλεπτα.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Προσθήκη κουμπιού μηχανικού λογισμικού',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Εγκατάσταση κουμπιού νέας εφαρμογής',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Οι εφαρμογές σας στο Facebook',
        'FACEBOOK_EMBEDDING' => 'Προώθηση Facebook',
        'FACEBOOK_SETUP' => 'Προώθηση Facebook',
        'FACEBOOK_PROMOTING' => 'Προώθηση εφαρμογών στο Facebook',
        'FACEBOOK_VIEW_APP' => 'Προβολή εφαρμογής',
        'FACEBOOK_ADD_THE' => 'Προσθήκη του',
        'FACEBOOK_RECENT' => 'Πιο πρόσφατο',
        'FACEBOOK_RECENTLY_FEATURED' => 'Πιο πρόσφατα προβεβλημένο',
        'FACEBOOK_RECENTLY_ADDED' => 'Πιο πρόσφατα προστεθειμένο',
        'FACEBOOK_PROMOTED' => 'Χαρακτηριστικό',
        'FACEBOOK_RATED' => 'Με την υψηλότερη αξιολόγηση',
        'FACEBOOK_POPULAR' => 'Δημοφιλές',
        'FACEBOOK_MUSIC_WIDGET' => 'Γραφικό στοιχείο μουσικής',
        'FACEBOOK_VIDEO_WIDGET' => 'Γραφικό στοιχείο βίντεο',
        'FACEBOOK_PHOTO_WIDGET' => 'Γραφικό στοιχείο φωτογραφιών',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Πρώτα βήματα',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Κάντε κλικ εδώ για να μεταβείτε στο Facebook και να αρχίσετε τη δημιουργία της εφαρμογής σας.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Έτσι το Facebook θα ανοίξει σε νέο παράθυρο.  Εάν δεν έχετε ήδη συνδεθεί με το Facebook, θα πρέπει να συνδεθείτε τώρα.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Εάν δεν έχετε δημιουργήσει μια εφαρμογή στο Facebook, θα σας ζητηθεί να προσθέσετε την εφαρμογή μηχανικού λογισμικού του Facebook.  Αφού το κάνετε αυτό, εμφανίζεται το μήνυμα "Δεν έχετε εφαρμογές. " Κάντε κλικ στο <strong>Δημιουργία εφαρμογής</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Εάν έχετε ήδη δημιουργήσει μια εφαρμογή στο Facebook, θα μεταφερθείτε στην εφαρμογή μηχανικού λογισμικού του Facebook.  Κάντε κλικ στο κουμπί <strong>Εγκατάσταση νέας εφαρμογής</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Επόμενο: Οδηγίες για τον τρόπο εγκατάστασης της εφαρμογής %s, ώστε να λειτουργήσει στο Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Οδηγίες εγκατάστασης',
        'FACEBOOK_INSTR_SETUP_1' => 'Πολύ ωραία!  Και τώρα οι λεπτομέρειες.  Το Facebook χρειάζεται να ξέρει ορισμένες βασικές πληροφορίες για να απογειώσει την εφαρμογή σας.  Απλά εκτελέστε τα ακόλουθα βήματα:',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Απαιτούμενα πεδία',
        'FACEBOOK_INSTR_SETUP_2' => 'Επιλέξτε ένα <strong>Όνομα εφαρμογής</strong>.',
        'FACEBOOK_INSTR_SETUP_3' => 'Συμπληρώστε το πλαίσιο για να δηλώσετε ότι έχετε διαβάσει το έγγραφο όρων του Facebook.',
        'FACEBOOK_INSTR_SETUP_4' => 'Ανοίξτε την ενότητα <em>Προαιρετικά πεδία</em>.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Βασικές επιλογές',
        'FACEBOOK_INSTR_SETUP_5' => 'Πληκτρολογήστε τη διεύθυνση του ηλεκτρονικού σας ταχυδρομείου στο πεδίο <strong>E-Mail υποστήριξης</strong>.',
        'FACEBOOK_INSTR_SETUP_6' => 'Επικολλήστε την παρακάτω διεύθυνση Web στο πεδίο <strong>Επανάκληση διεύθυνσης URL</strong>:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Επιλέξτε μια <strong>Διεύθυνση URL σελίδας Canvas</strong> (π.χ. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Επιλέξτε <strong>Ναι</strong> στο <em>Είναι δυνατή η προσθήκη της εφαρμογής σας στο Facebook</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Επιλογές εγκατάστασης',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Γράψτε μια <strong>Περιγραφή εφαρμογής</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Επικολλήστε τον ακόλουθο κωδικό στο πεδίο <strong>Προεπιλεγμένο FBML</strong>:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Στο <strong>Προεπιλεγμένη στήλη πλαισίου προφίλ</strong> επιλέξτε <strong>Πλατιά</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Στο <strong>Προεπιλεγμένη στήλη πλαισίου προφίλ</strong> επιλέξτε <strong>Στενή</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'Στο πεδίο <strong>Διεύθυνση URL πλευρικής περιήγησης</strong> πληκτρολογήστε τη <em>Διεύθυνση URL σελίδας Canvas</em> (όπως δημιουργήθηκε στο βήμα &#8216; f&#8217;  παραπάνω)  Βεβαιωθείτε ότι έχετε συμπεριλάβει το τμήμα http://apps.facebook.com/ της διεύθυνσης URL.',
        'FACEBOOK_INSTR_SETUP_11' => 'Γράψτε ένα κείμενο για την <strong>Ενέργεια συνημμένου</strong>.  Αυτό θα εμφανίζεται όταν αποστέλλετε σε κάποιον ένα μήνυμα μέσω του Facebook και θέλετε να συμπεριλάβετε μια από τις εφαρμογές σας.  Εάν η εφαρμογή σας είναι Προβολή παρουσίασης φωτογραφιών, μπορείτε να εισαγάγετε Φωτογραφίες από το όνομα δικτύου.  Εάν η εφαρμογή σας είναι Πρόγραμμα αναπαραγωγής βίντεο, μπορείτε να εισαγάγετε Βίντεο από το όνομα δικτύου.',
        'FACEBOOK_INSTR_SETUP_12' => 'Επικολλήστε την παρακάτω διεύθυνση Web στο πεδίο <strong>Επανάκληση διεύθυνσης URL</strong>:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Σελίδα εγκατάστασης εφαρμογής Facebook',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Όταν τελειώσετε, κάντε κλικ στο κουμπί <strong>Υποβολή</strong>.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Επόμενο: Ανάκτηση Κλειδιού και Κρυφού κωδικού ΑΡΙ.',
        'FACEBOOK_API_INFO_TITLE' => 'Πληροφορίες Facebook API',
        'FACEBOOK_API_INFO_DESC' => 'Για να ολοκληρώσετε την εγκατάσταση, πρέπει να πληκτρολογήσετε το Κλειδί και τον Κρυφό κωδικό API, καθώς και τη Διεύθυνση URL της εφαρμογής στα παρακάτω πεδία.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Μπορείτε να βρείτε το Κλειδί και τον Κρυφό κωδικό API στη σελίδα <a %s>Οι εφαρμογές μου στο Facebook</a> (ανοίγει σε νέο παράθυρο) υπό τον τίτλο της εφαρμογής που έχετε μόλις δημιουργήσει.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Σελίδα Οι εφαρμογές μου (με επισήμανση της θέσης των πληροφοριών ΑΡΙ)',
        'FACEBOOK_API_INFO_KEY' => 'Κλειδί ΑΡΙ',
        'FACEBOOK_API_INFO_SECRET' => 'Κρυφός κωδικός ΑΡΙ',
        'FACEBOOK_URL_INFO_TITLE' => 'Διεύθυνση URL εφαρμογής Facebook',
        'FACEBOOK_URL_INFO_DESC' => 'Η διεύθυνση URL της εφαρμογής είναι ίδια με τη <strong>Διεύθυνση URL σελίδας Canvas</strong>, την οποία ορίσατε στην προηγούμενη σελίδα (στο βήμα &#8216; f&#8217; ).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Οι εφαρμογές μουσικής Facebook θα πρέπει να αναπαράγουν:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Οι εφαρμογές βίντεο Facebook θα πρέπει να αναπαράγουν το βίντεο που είναι:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Οι εφαρμογές προβολής παρουσίασης Facebook θα πρέπει να αναπαράγουν φωτογραφίες από:',
        'FACEBOOK_PROMOTING_ON' => 'Προώθηση στο Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Οδηγίες εγκατάστασης',
        'FACEBOOK_API_INFO' => 'Πληροφορίες ΑΡΙ',
        'FACEBOOK_DISABLE' => 'Απενεργοποίηση αυτής της εφαρμογής',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'στο προφίλ Facebook',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Επιστροφή στην Προώθηση Facebook',
        'FACEBOOK_EMBEDDING_DESC' => 'Επιτρέψτε στους χρήστες του Facebook να τοποθετήσουν τα γραφικά στοιχεία και τα διακριτικά του δικτύου σας στις σελίδες των προφίλ τους.',
        'FACEBOOK_PROMOTE' => 'Για καλύτερα αποτελέσματα κατά την προώθηση της νέας εφαρμογής σας, συνιστούμε να εκτελέσετε τα ακόλουθα βήματα.  Όλες αυτές οι επιλογές είναι προσβάσιμες από τη σελίδα <strong><a %s>Οι εφαρμογές μου</a></strong> του Facebook (η σύνδεση ανοίγει σε νέο παράθυρο).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Ορίστε μια Σελίδα πληροφοριών',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Ενημερώστε τους χρήστες του Facebook για το αντικείμενο της εφαρμογής σας παρέχοντας μια σαφή περιγραφή.  Για να επεξεργαστείτε αυτές τις πληροφορίες, κάντε κλικ στη σύνδεση <strong>Επεξεργασία σελίδας πληροφοριών</strong> πλάι στην εφαρμογή που τροποποιείτε.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Υποβολή εφαρμογής στον Κατάλογο του Facebook',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Κάντε γνωστή τη νέα εφαρμογή σας προσθέτοντάς την στον κατάλογο του Facebook.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Για να υποβάλετε την εφαρμογή σας, κάντε κλικ στη σύνδεση <strong>Υποβολή εφαρμογής</strong> πλάι στην εφαρμογή που τροποποιείτε.  Στην ακόλουθη σελίδα μπορείτε να επεξεργαστείτε την Περιγραφή εφαρμογής, καθώς και να προσθέσετε ένα λογότυπο για την εφαρμογή σας.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Προσθήκη εφαρμογής στο προφίλ του Facebook',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Αναδείξτε την εφαρμογή σας προσθέτοντάς την στη σελίδα προφίλ του Facebook και στη συνέχεια καθίστε αναπαυτικά και παρακολουθήστε τους φίλους σας να κάνουν το ίδιο.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Απλά κάντε κλικ στη σύνδεση <strong>Προβολή σχετικά με τη σελίδα</strong> πλάι στην εφαρμογή που θέλετε να προσθέσετε στο προφίλ σας και στη συνέχεια επιλέξετε το κουμπί "Προσθήκη εφαρμογής" στην επόμενη σελίδα.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Η εφαρμογή σας βρίσκεται τώρα στο κάτω μέρος της σελίδας προφίλ του Facebook!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Σελίδα Οι εφαρμογές μου στο Facebook',
        'FACEBOOK_MY_APPS' => 'Οι εφαρμογές μου',
        'FORUM_TAB_TEXT' => 'Φόρουμ',
        'VIDEOS_TAB_TEXT' => 'Βίντεο',
        'PHOTOS_TAB_TEXT' => 'Φωτογραφίες',
        'GROUPS_TAB_TEXT' => 'Ομάδες',
        'EACH_VIDEO_MAY_BE_100MB' => 'Το κάθε βίντεο μπορεί να έχει μέγεθος έως 100 ΜΒ. Υποστηρίζουμε βίντεο με αρχεία μορφών .mov, .mpg, .avi, .wmv και .3gp.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Έχω το δικαίωμα να αποστείλω αυτό το βίντεο σύμφωνα με τους <a %s>Όρους χρήσης</a>.',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'Το πρόγραμμα μαζικής αποστολής βίντεο απαιτεί μια πρόσφατη έκδοση της Java. <strong><a %s>Κάνετε κλικ εδώ για να αποκτήστε τη Java</a></strong> ή <strong><a %s>επιστρέψτε στο απλό πρόγραμμα αποστολής </a></strong>.',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Αποστολή βίντεο από τον υπολογιστή σας',
        'HAVE_LOT_OF_VIDEOS' => 'Έχετε πολλά βίντεο που θέλετε να τα μοιραστείτε;',
        'TRY_BULK_VIDEO_UPLOADER' => 'Δοκιμάστε το πρόγραμμα μαζικής αποστολής βίντεο',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Τα βίντεό σας αποστάλθηκαν με επιτυχία.',
        'VIDEOS_UPLOADED_AWAITING' => 'Τα βίντεό σας απεστάλησαν με επιτυχία και αναμένεται η έγκρισή τους από τον δημιουργό του %s.',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Προσθέστε βίντεο ή φωτογραφίες στο %s απευθείας από το τηλέφωνό σας, με την αποστολή τους σε μια μοναδική διεύθυνση ηλεκτρονικού ταχυδρομείου.',
        'GRAB_HTML_EMBED' => 'Μπορείτε να αποτυπώστε τον κώδικα για την \'ενσωμάτωση\' της HTML από οποιαδήποτε ευρέως γνωστή τοποθεσία βίντεο και να προσθέσετε το βίντεο σε αυτό το δίκτυο.',
        'GOOGLE' => 'Google',
        'YOUTUBE' => 'YouTube',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Έχετε πρόβλημα με το πρόγραμμα μαζικής αποστολής βίντεο; <strong><a %s> Επιστροφή στο απλό πρόγραμμα αποστολής μας </a></strong>.',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Προσθήκη βίντεο από το YouTube ή το Google',
        'TAGS_NO_COLON' => 'Ετικέτες',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Δεν υπάρχουν βίντεο με ετικέτα "%1$s". Ελέγξτε τις συζητήσεις <a %2$s> με ετικέτα "%1$s"</a>, τις καταχωρίσεις ιστολογίου <a %4$s> με ετικέτα "%1$s"</a> ή τις φωτογραφίες <a %3$s> με ετικέτα "%1$s"</a>. Ή προσθέστε και χαρακτηρίστε με ετικέτες τα δικά σας βίντεο!',
        'UPLOAD_VIDEOS_FROM' => 'Αποστολή βίντεο από τον υπολογιστή σας',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Η αποστολή του βίντεό σας στο %s δεν ολοκληρώθηκε εξαιτίας λάθους μετατροπής.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Για βοήθεια στην αντιμετώπιση προβλημάτων, παρουσιάστε αυτό το αναγνωριστικό βίντεο: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Το βίντεό σας απεστάλη με επιτυχία στο %s.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Για να δείτε το βίντεο επισκεφτείτε:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Υπάρχει νέο σχόλιο για το βίντεό σας "%1$s" στο %2$s',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Υπάρχει νέο σχόλιο για το βίντεό σας στο %s.',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Προσθήκη βίντεο μέσω τηλεφώνου ή ηλεκτρονικού ταχυδρομείου',
        'FEATURING_ELLIPSIS' => 'Προβολή…',
        'NOW_FEATURED_ON_MAIN' => 'Τώρα προβάλλονται στην αρχική σελίδα',
        'DONT_FEATURE' => 'Μην προβάλλετε',
        'UNFEATURING_ELLIPSIS' => 'Γίνεται κατάργηση από την αρχική σελίδα…',
        'REMOVED_FROM_MAIN' => 'Κατάργηση από την αρχική σελίδα',
        'ADDED_EXCLAMATION' => 'Προστέθηκε!',
        'ERROR' => 'Σφάλμα',
        'ADDING_ELLIPSIS' => 'Γίνεται προσθήκη…',
        'TRACK_COULD_NOT_BE_LOADED' => 'Δεν ήταν δυνατή η φόρτωση του τραγουδιού',
        'INVALID_URL' => 'Μη έγκυρη διεύθυνση URL',
        'NORMAL_PLAYBACK_ON' => 'Κανονική αναπαραγωγή: Ενεργή',
        'REPEAT_PLAYBACK_ON' => 'Επανάληψη αναπαραγωγής: Ενεργή',
        'SHUFFLE_PLAYBACK_ON' => 'Τυχαία σειρά αναπαραγωγής: Ενεργή',
        'OPEN_POPUP_WINDOW' => 'Άνοιγμα αναδυόμενου παραθύρου',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Γίνεται φόρτωση λίστας αναπαραγωγής…',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Η κάθε φωτογραφία μπορεί να έχει μέγεθος έως και 10 ΜΒ. Υποστηρίζουμε φωτογραφίες με τις μορφές αρχείων .jpg, .gif και .png.',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Έχω το δικαίωμα να αποστείλω αυτές τις φωτογραφίες σύμφωνα με τους <a %s>Όρους χρήσης</a>.',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'Το πρόγραμμα μαζικής αποστολής φωτογραφιών απαιτεί μια πρόσφατη έκδοση της Java. <strong><a %s>  Κάνετε κλικ εδώ για να αποκτήστε την Java</a></strong>, ή επιστρέψτε στο απλό πρόγραμμα αποστολής </a></strong>.',
        'TRY_BULK_PHOTO_UPLOADER' => 'Δοκιμάστε το πρόγραμμα μαζικής αποστολής φωτογραφιών',
        'HAVE_LOT_OF_PHOTOS' => 'Έχετε πολλές φωτογραφίες που θέλετε να μοιραστείτε;',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Οι φωτογραφίες σας απεστάλησαν με επιτυχία.',
        'PHOTOS_UPLOADED_AWAITING' => 'Οι φωτογραφίες σας απεστάλησαν με επιτυχία και αναμένεται η έγκρισή τους από τον δημιουργό του %s.',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => 'Προσθήκη φωτογραφιών από το Flickr',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Προσθέστε φωτογραφίες ή βίντεο στο %s απευθείας από το τηλέφωνό σας, με αποστολή σε μια μοναδική διεύθυνση ηλεκτρονικού ταχυδρομείου.',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Έχετε προβλήματα με το πρόγραμμα μαζικής αποστολής φωτογραφιών;  <strong><a %s> Επιστρέψτε στο απλό πρόγραμμα αποστολής μας </a></strong>.',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Δεν υπάρχουν φωτογραφίες με ετικέτα "%1$s". Ελέγξτε τις συζητήσεις <a %2$s> με ετικέτα "%1$s"</a>, τις καταχωρίσεις ιστολογίου <a %4$s> με ετικέτα "%1$s"</a> ή τα βίντεο <a %3$s> με ετικέτα "%1$s"</a>. Ή προσθέστε και επισημάνετε τις δικές σας φωτογραφίες.',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Αποστολή φωτογραφιών από τον υπολογιστή σας',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Υπάρχει νέο σχόλιο για τη φωτογραφία σας "%1$s" στο %2$s',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Υπάρχει νέο σχόλιο για τη φωτογραφία σας στο %s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Υπάρχει ένα καινούργιο %1$s για να το εγκρίνετε στο %2$s...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Υπάρχει ένα καινούργιο %1$s για να το εγκρίνετε στο %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Υπάρχει ένα καινούργιο %1$s "%2$s" για να το εγκρίνετε στο %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Για να εγκρίνετε αυτό το %s, επισκεφτείτε:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Το %1$s έχει εγκριθεί στο %2$s σας…',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Υπάρχει ένα νέο σχόλιο για το %1$s σας στο %2$s…',
        'CLICK_HERE_TO_JOIN' => 'Κάνετε κλικ εδώ για να συμμετάσχετε:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => 'Ο/Η %s επιθυμεί να δοκιμάσετε το "%2$s"στο %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Το %s σας έχει εγκριθεί στο %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Το %1$s "%2$s" σας έχει εγκριθεί στο %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'Για την προβολή του %s σας, επισκεφτείτε:',
        'TO_VIEW_THIS_X_VISIT' => 'Για την προβολή του %s επισκεφτείτε:',
        'TO_VIEW_IT_VISIT' => 'Για την προβολή του, επισκεφτείτε:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => 'Ο/Η %s ανέφερε το παρακάτω πρόβλημα με το %2$s...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => 'Ο/Η %s σας έχει στείλει μήνυμα στο %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => 'Ο/Η %1$s ζήτησε να συμμετάσχει στο %2$s στο %3$s',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Για την έγκριση ή την απόρριψη της αίτησης του %s, επισκεφτείτε:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => 'Ο/Η %1$s πρόσθεσε ένα σχόλιο στην καταχώριση ιστολογίου "%2$s" στο  %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => 'Ο/Η %1$s πρόσθεσε ένα σχόλιο στην καταχώριση ιστολογίου στο %2$s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Υπάρχει ένα καινούργιο μέλος για να το εγκρίνετε στο %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Καλωσορίσατε στην ομάδα "%1$s" στο %2$s',
        'PLEASE_SELECT_A_MEMBER' => 'Επιλέξτε ένα ή περισσότερα μέλη',
        'LOADING_YOUR_FRIENDS' => 'Γίνεται φόρτωση των φίλων σας...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Το μήνυμά σας έχει αποσταλεί',
        'TO_SEND_ANOTHER_MESSAGE' => 'Για να αποστείλετε ένα ακόμη μήνυμα, παρακαλούμε εισάγετε το κείμενό σας παρακάτω.',
        'PLEASE_CHOOSE_FRIENDS' => 'Παρακαλούμε επιλέξτε μερικούς φίλους πριν στείλετε το μήνυμά σας.',
        'RESEND_INVITATION' => 'Επανάληψη αποστολής πρόσκλησης',
        'CHOOSE_FRIENDS' => 'Επιλογή φίλων…',
        'ALL_FRIENDS' => 'Όλοι οι φίλοι μου',
        'ALL_FRIENDS_ON_APPNAME' => 'Όλοι οι φίλοι μου στο %s',
        'SHARE_WITH_FRIENDS' => 'Κοινή χρήση με φίλους',
        'SHARE_THIS_WITH_FRIENDS' => 'Μοιραστείτε αυτό το στοιχείο με τους φίλους σας',
        'COMPOSE_MESSAGE' => 'Σύνθεση μηνύματος',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Αυτός η σύνδεση πρόσκλησης είναι ορατή μόνο στο δημιουργό του δικτύου και στους διαχειριστές. Τα μέλη που θα γίνουν μέλη μέσω αυτής της σύνδεσης θα γίνουν αυτόματα φίλοι με το δημιουργό του δικτύου.',
        'WE_ARE_LOADING_ADDRESSES' => 'Γίνεται φόρτωση των διευθύνσεών σας…',
        'SELECT_ALL_NONE' => 'Επιλογή Όλων/Κανενός',
        'INVITE_TO_APPNAME' => 'Πρόσκληση στο \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Προσκαλέστε τους φίλους σας στο \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Είναι ήδη μέλος αυτού του δικτύου)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Ή μοιραστείτε αυτή τη σύνδεση πρόσκλησης:',
        'CLICK_TO_MAIL' => '<a %s>Κάνετε κλικ εδώ για να αποστείλετε μήνυμα τώρα</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Το μήνυμά σας έχει αποσταλεί',
        'YOU_CAN_SHARE_THIS' => 'Μπορείτε να μοιραστείτε με περισσότερα άτομα παρακάτω ή <a %s> να επιστρέψτε στην προηγούμενη σελίδα </a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Λυπούμαστε, αλλά η υπηρεσία εισαγωγής vCard δεν είναι προς το παρόν διαθέσιμη.',
        'CSV_IMPORT_UNAVAILABLE' => 'Λυπούμαστε, αλλά η υπηρεσία εισαγωγής CSV δεν είναι προς το παρόν διαθέσιμη.',
        'ERROR_OCCURRED' => 'Λυπούμαστε, αλλά συνέβη σφάλμα.',
        'IMPORT_FAILED' => 'Λυπούμαστε, αλλά η εισαγωγή δεδομένων απέτυχε.',
        'LOGIN_FAILED' => 'Λυπούμαστε, αλλά η σύνδεση απέτυχε.',
        'UNABLE_TO_FIND_EMAIL' => 'Λυπούμαστε, αλλά αδυνατούμε να βρούμε το πεδίο ηλεκτρονικού ταχυδρομείου.',
        'CANNOT_READ_VCARDS' => 'Λυπούμαστε, αλλά δεν μπορούμε να διαβάσουμε αυτές τις vCard.',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Λυπούμαστε, δεν υποστηρίζουμε το βιβλίο διευθύνσεων web για τη διεύθυνσή σας ηλεκτρονικού ταχυδρομείου.. Προσπαθήστε να κάνετε κλικ στο \\’Εφαρμογή βιβλίου διευθύνσεων\\’ παρακάτω για να χρησιμοποιήσετε τις διευθύνσεις από τον υπολογιστή σας.',
        'NO_ADDRESSES_FOUND' => 'Δεν βρέθηκαν διευθύνσεις',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Δεν βρήκαμε καμιά διεύθυνση στο βιβλίο διευθύνσεων που εισαγάγαμε.',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Επιθυμείτε να προσκαλέσετε και άλλους φίλους; Εισάγετε επαφές από το βιβλίο διευθύνσεων σας στο διαδίκτυο ή από την εφαρμογή βιβλίου διευθύνσεων του υπολογιστή σας.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Εισαγωγή δεδομένων από το βιβλίο διευθύνσεων web',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Εισαγωγή δεδομένων από το πρόγραμμα βιβλίου διευθύνσεων',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Address Book, .CSV, κλπ.',
        'PRIVACY_POLICY' => 'Πολιτική απορρήτου',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => 'Κάνετε τώρα αίτηση για να γίνετε μέλος. Είστε ήδη μέλος; <a %s> Κάντε κλικ εδώ για να συνδεθείτε στο </a>.',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => 'Ο/Η %1$ παρείχε το ακόλουθο σχόλιο στο %2$s:',
        'TRACK_STATISTICS' => 'Ανίχνευση στατιστικών στοιχείων',
        'FEATURED_MEMBERS' => 'Προβαλλόμενα μέλη',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Δοκιμάστε το "%1$s" στο %2$s...',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Δοκιμάστε αυτό "%1$s" στο %2$s...',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Λυπούμαστε, δεν βρέθηκαν μέλη που να αντιστοιχούν στο "%s".',
        'WHO_CAN_COMMENT_ON_POST' => 'Ποιος μπορεί να σχολιάσει αυτή την καταχώριση;',
        'SEND_MESSAGE_TO_FRIENDS' => 'Αποστολή μηνύματος σε φίλους',
        'PREVIOUS_POST' => '← Προηγούμενη καταχώριση',
        'NEXT_POST' => 'Επόμενη καταχώριση →',
        'PREVIOUS_POSTS' => '←  Προηγούμενες καταχωρίσεις',
        'NEXT_POSTS' => 'Επόμενες καταχωρίσεις',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Δεν υπάρχουν καταχωρίσεις ιστολογίου με ετικέτα "%1$s". Δοκιμάστε τις συζητήσεις <a %2$s> με ετικέτα "%1$s"</a>, τις φωτογραφίες <a %4$s> με ετικέτα "%1$s"</a> ή τα βίντεο <a %3$s> με ετικέτα "%1$s"</a>. Ή προσθέστε και επισημάνετε τις δικές σας καταχωρίσεις ιστολογίου!',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Όλες οι καταχωρίσεις με ετικέτα <em>\'%s\'</em> για %s %s',
        'ALL_POSTS_TAGGED_X' => 'Όλες οι καταχωρίσεις με ετικέτα <em>\'%s\'</em>',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Οι καταχωρίσεις ιστολογίου μου για %s %s',
        'MY_BLOG_POSTS' => 'Οι καταχωρίσεις ιστολογίου μου',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Ορίστε μια έγκυρη επιλογή για τις ειδοποιήσεις των μηνυμάτων που εστάλησαν σε όλους τους φίλους',
        'PRIVACY_CONTENT_CONTROL' => 'Έλεγχος απορρήτου & περιεχομένου',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Ενεργοποίηση συνδέσεων λήψης Music Player',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Καλωσορίσατε, %1$s! Είστε μέλος με αριθμό %2$s από %3$s μέλη. <a %4$s>Προσκαλέστε φίλους τώρα</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Σχολιάσατε τη φωτογραφία <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => 'Ο/Η %s σχολίασε τη φωτογραφία <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Σχολιάσατε το βίντεο <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => 'Ο/Η %s σχολίασε το βίντεο <a %s>%s</a>',
        'NOTIFY_BLOG_PING_SERVICES' => 'Επιθυμείτε να ενημερώσετε υπηρεσίες παρακολούθησης ιστολογίων τρίτων όταν προσθέτετε μια νέα καταχώριση;',
        'YES_NOTIFY_BLOG_SERVICES' => 'Ναι – Ειδοποιήστε <a %s> τις υπηρεσίες ενημέρωσης της τοποθεσίας </a> όταν προσθέτω μια νέα καταχώριση ιστολογίου',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Δεν υπάρχουν προβεβλημένα μέλη στο κοινωνικό σας δίκτυο.',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Ξεκινήστε την προβολή μελών όπου βλέπετε την επιλογή προβολής. Για να μάθετε περισσότερα για την προβολή, <a %s>κάνετε κλικ εδώ</a>.',
        'THIS_IS_YOUR_PAGE' => 'Αυτή είναι η σελίδα σας:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Μηνύματα που έχουν αποσταλεί σε όλους τους φίλους',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Για να διακόψετε την παρακολούθηση αυτού του %s, μεταβείτε στο:',
        'SHOW_ALL' => 'Εμφάνιση όλων',
        'CHOOSE_GADGETS' => 'Επιλέξτε μία από αυτές τις εξαιρετικές μικροεφαρμογές OpenSocial για να την προσθέσετε στη σελίδα του προφίλ σας! Μπορείτε <a %s>να προβάλετε και να αξιολογήσετε τις μικροεφαρμογές εδώ</a> ή <a %s>να μάθετε περισσότερα για το OpenSocial εδώ</a>.',
        'GADGETS_UNAVAILABLE' => 'Μικροεφαρμογές προσωρινά μη διαθέσιμες',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Συγνώμη – οι μικροεφαρμογές είναι προσωρινά μη διαθέσιμες.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Αυτό το πλαίσιο δεν θα εμφανιστεί σε άλλα άτομα εκτός και αν επιλέξετε μια μικροεφαρμογή.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Παρακαλώ κάνετε κλικ στο Επεξεργασία για να καθορίσετε τη διεύθυνση URL της μικροεφαρμογής για αυτό το πλαίσιο ή επισκεφτείτε τον <a %s>Κατάλογο μικροεφαρμογών</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Παρουσιάστηκε ένα πρόβλημα κατά την ανάκτηση της τροφοδοσίας της διεύθυνσης URL αυτής της μκροεφαρμογής.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Προσθέστε αυτή την μικροεφαρμογή στο προφίλ σας',
        'GADGETS_BETA' => 'Μικροεφαρμογές (Υπό δοκιμή)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Δοκιμάστε αυτές τις μικροεφαρμογές OpenSocial. Προειδοποίηση: αυτό το χαρακτηριστικό είναι δοκιμαστικό.',
        'ADD_TO_MY_PAGE' => 'Προσθήκη στη σελίδα μου',
        'GADGETS' => 'Μικροεφαρμογές',
        'GADGETS_TAB_TEXT' => 'Μικροεφαρμογές',
        'GADGET' => 'Μικροεφαρμογή',
        'GADGETS_IS_IN_BETA' => 'Οι μικροεφαρμογές βρίσκονται υπό δοκιμή',
        'SORRY_GADGET_UNAVAILABLE' => 'Λυπούμαστε, αλλά αυτή η μικροεφαρμογή δεν είναι διαθέσιμη. Παρακαλώ ελέγξτε για να διασφαλίσετε ότι έχετε τη σωστή διεύθυνση URL. Εάν έχετε προβλήματα ακόμη, <a %s>ενημερώστε μας</a>.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Δεν υπάρχει καμία συζήτηση με ετικέτα "%1$s". Ελέγξετε τις φωτογραφίες <a %2$s> με ετικέτα "%1$s"</a>, τις καταχωρίσεις ιστολογίου <a %4$s> με ετικέτα "%1$s"</a> ή τα βίντεο <a %3$s> με ετικέτα "%1$s"</a>. Ή προσθέστε και επισημάνετε τις δικές σας συζητήσεις!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Δεν υπάρχει καμία συζήτηση με ετικέτα "%1$s". Ελέγξετε τις φωτογραφίες <a %2$s> με ετικέτα "%1$s"</a>, τις καταχωρίσεις ιστολογίου <a %4$s> με ετικέτα "%1$s"</a> ή τα βίντεο <a %3$s> με ετικέτα "%1$s"</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Είναι ήδη μέλος αυτής της ομάδας)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Προσκαλέστε τους φίλους σας στο \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Ελάτε να συμμετάσχετε μαζί μου στο %1$s στο %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Ελάτε να συμμετάσχετε μαζί μου στο %1$s στο %2$s…',
        'INVITE_TO_GROUP' => 'Πρόσκληση στο \'%s\'',
        'YOU_CAN_ADD_100_SONGS' => 'Μπορείτε να προσθέσετε συνολικά 100 τραγούδια, που το καθένα να έχει μέγεθος έως 20 ΜΒ. Υποστηρίζουμε τραγούδια με τη μορφή αρχείου .mp3.',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Έχω το δικαίωμα να στείλω αυτά τα τραγούδια σύμφωνα με τους <a %s">Όρους χρήσης</a>.',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'Το πρόγραμμα μαζικής αποστολής μουσικής απαιτεί μια πρόσφατη έκδοση της Java. <strong><a %s>Κάνετε κλικ εδώ για να αποκτήσετε τη Java</a></strong> ή <strong><a %s>επιστρέψετε στο απλό πρόγραμμα αποστολής </a></strong>.',
        'HAVE_LOT_OF_MUSIC' => 'Έχετε πολλά μουσικά κομμάτια που επιθυμείτε να μοιραστείτε;',
        'TRY_BULK_MUSIC_UPLOADER' => 'Δοκιμάστε το πρόγραμμα μαζικής αποστολής',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Τα τραγούδια σας έχουν αποσταλεί με επιτυχία',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Λυπούμαστε, μπορείτε να έχετε μόνο %s τραγούδια στη λίστα αναπαραγωγής. Καταργήστε μερικά από τα υπάρχοντα τραγούδια πριν προσθέσετε περισσότερα.',
        'ADD_MUSIC_FROM_WEBSITE' => 'Προσθέστε μουσική από μια άλλη τοποθεσία web.',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Έχετε προβλήματα με αυτό το πρόγραμμα αποστολής μουσικής; <strong><a %s>Επιστρέψετε στο απλό πρόγραμμα αποστολής μας</a></strong>.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Αποστολή μουσικής από τον υπολογιστή σας.',
        'ADD_MUSIC' => 'Προσθήκη μουσικής',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Επιλέξτε <strong>Χρήστες</strong> και <strong>Όλες οι σελίδες</strong>.',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param string $widgetTitle  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}