<?php
/**
 * An invitation to a group.
 *
 * @param $fromProfile		XN_Profile 	the person sending the invitation
 * @param $url 				string		the target URL for the message
 * @param $body				string  	the message from the sender (nl2br will be applied). If empty, default is used
 * @param $message			hash		Message common info
 * @param $sparse			bool		Display "sparse" view
 * @param $helper			XG_MessageHelper
 */
$username = $helper->userName($fromProfile->screenName);
$title = xnhtmlentities($title);
$url = xnhtmlentities($url);
if (isset($share_content_author)) {
	$authorUrl = xnhtmlentities(xg_absolute_url(User::quickProfileUrl($share_content_author)));
	$authorName = $helper->userName($share_content_author);
}

$appName = xnhtmlentities($message['appName']);

if (!$body) {
	$body = $title ? xg_html('CHECK_OUT_TITLE_ON_APPNAME', $title, $appName) : xg_html('CHECK_OUT_UNTITLED_ON_APPNAME', $appName);
	$body .= '<br /><br />' . nl2br(xg_html('THANX_USERNAME',$username));
} else {
	$body = nl2br(xnhtmlentities($body));
}

// Cannot move to XG_Message, because username/title are quoted differently for text/html
switch($share_raw_type) {
	case 'photo':
		$headerTitle = $title ? xg_html('USER_WANTS_YOU_CHECK_OUT_PHOTO', $username, $title) : xg_html('USER_WANTS_YOU_CHECK_OUT_THIS_PHOTO', $username);
		$descrTitle = xg_html('PHOTO_DESCRIPTION_COLON');
		$linkTitle = xg_html('PHOTO_LINK');
		$showThumb = 1;
		break;
	case 'album':
		$headerTitle = $title ? xg_html('USER_WANTS_YOU_CHECK_OUT_ALBUM', $username, $title) : xg_html('USER_WANTS_YOU_CHECK_OUT_THIS_ALBUM', $username);
		$descrTitle = xg_html('ALBUM_DESCRIPTION_COLON');
		$linkTitle = xg_html('ALBUM_LINK');
		$showThumb = 1;
		break;
	case 'video':
		$headerTitle = $title ? xg_html('USER_WANTS_YOU_CHECK_OUT_VIDEO', $username, $title) : xg_html('USER_WANTS_YOU_CHECK_OUT_THIS_VIDEO', $username);
		$descrTitle = xg_html('VIDEO_DESCRIPTION_COLON');
		$linkTitle = xg_html('VIDEO_LINK');
		$showThumb = 1;
		break;
	case 'topic':
		$headerTitle = $title ? xg_html('USER_WANTS_YOU_CHECK_OUT_DISCUSSION', $username, $title) : xg_html('USER_WANTS_YOU_CHECK_OUT_THIS_DISCUSSION', $username);
		$descrTitle = xg_html('DISCUSSION_DESCRIPTION', "href=\"$authorUrl\" style=\"text-decoration:none;\"", $authorName);
		$linkTitle = xg_html('DISCUSSION_LINK');
		$showThumb = 0;
		break;
	case 'post':
		$headerTitle = $title ? xg_html('USER_WANTS_YOU_CHECK_OUT_POST', $username, $title) : xg_html('USER_WANTS_YOU_CHECK_OUT_THIS_POST', $username);
		$descrTitle = xg_html('POST_DESCRIPTION', "href=\"$authorUrl\" style=\"text-decoration:none;\"", $authorName);
		$linkTitle = xg_html('POST_LINK');
		$showThumb = 0;
		break;
	case 'user':
		$headerTitle = $title ? xg_html('USER_WANTS_YOU_CHECK_OUT_PROFILE', $username, $title) : xg_html('USER_WANTS_YOU_CHECK_OUT_THIS_PROFILE', $username);
		$descrTitle = xg_html('PROFILE_HAS', $authorName);
		$linkTitle = xg_html('PROFILE_LINK');
		$showThumb = 1;
		break;
}
?>
<table width="98%" border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td bgcolor="#FFFFFF" width="100%">
			<%$helper->header()%>
			<table cellpadding="0" cellspacing="0" border="0" width="600">
				<tr>
					<td width="*" style="font-size:12px;padding-top:8px" valign="top">
						<table cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<?php if ($enableImages) {?>
								<td width="96" valign="top" style="padding-right:16px;">
									<%$helper->userUrl($fromProfile)%>
								</td>
								<?php }?>
								<td width="*" valign="top" style="font-size:12px">
									<div style="font-size:14px; font-weight:bold; padding-bottom:8px"><%=$headerTitle%></div>
									<%$helper->delimiter()%>
									<div style="font-weight:bold;font-size:12px"><%=xg_html('USER_SAYS_ELLIPSIS', $username)%></div>
									<br />
									<%=$body%><br />
									<br />
									<?php if ($showThumb) {?>
										<table cellspacing="0" cellpadding="0" width="100%" style="padding-top:8px">
											<tr>
												<?php if ($enableImages) {?>
												<td width="96" valign="top" style="padding-right:16px;">
													<a href="<%=$url%>"><img width="96" height="96" border="0" src="<%=$this->addImageByUrl(xg_url($thumb,'width=96&height=96&crop=1:1&xn_auth=no'))%>" alt="<%=$title%>"></a>
												</td>
												<?php }?>
												<td valign="top" style="font-size:12px;" width="100%">
													<?php if ($share_raw_type == 'user') {
														if ($counters) {
															echo "$descrTitle<br /><br />";
                											echo '<table cellspacing="0" cellpadding="0" border="0" width="100%">';
                											echo '<tr>';
                											$i = 0;
                											foreach($counters as $c) {
																if ($i && !($i%2)) { echo '</tr><tr>';}
																echo ($i%2) ? '<td style="font-size:12px">' : '<td width="40%" style="font-size:12px">',$c,'</td>';
																$i++;
															}
                											echo '<tr>';
                											echo '</table>';
														}
													} elseif ($share_raw_description) {
													  if ($title) { echo '<div style="font-weight:bold">' . $title . '</div>'; }
														echo xg_excerpt($share_raw_description, 140);
													} elseif (!$share_raw_description && $title) {
													  echo '<div style="font-weight:bold">' . $title . '</div>';
													}?>
												</td>
											</tr>
											<tr>
												<td colspan="2" style="font-size:12px">
													<br />
													<div style="font-weight:bold;font-size:12px"><%=$linkTitle%></div>
													<a href="<%=$url%>"><%=$url%></a><br />
												</td>
											</tr>
										</table>
									<?php } else {?>
        								<div style="font-weight:bold;"><%=$descrTitle%></div>
        								<br />
										<%=xg_excerpt($share_raw_description, 140)%><br />
            							<br /><div style="font-weight:bold;"><%=$linkTitle%></div>
            							<a href="<%=$url%>"><%=$url%></a><br />
									<?php }?>
								</td>
							</tr>
						</table>
						<%$helper->aboutNetwork($sparse)%>
						<%$helper->delimiter()%>
						<%$helper->unsubscribe()%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
