<?php
/** Message template for a notification that somebody has sent you a friend request
 *
 * @param $profile XN_Profile The profile of the friend request sender
 * @param $isMember boolean Whether or not the user is a member of the network the request is sent from
 */
if ($isMember) {
	$profileLink =  $_SERVER['HTTP_HOST'] . User::profileUrl($profile->screenName) . '?xgp=friend';
} else {
    $profileLink = $_SERVER['HTTP_HOST'] . '/?xgp=friend';
}
?>
    <div class="xg_body">
        <h3><%= xg_html('X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y', xnhtmlentities(xg_username($profile)),xnhtmlentities($message['appName'])) %></h3>
        <table width="100%">
            <tr>
                <td>
                <p><big><%= xg_html('TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT') %><br />
					<a href="http://<%= $profileLink %>">http://<%= $profileLink %></a></big></p>
                </td>
                <td><img align="right" width="96" height="96"  src="<%= xnhtmlentities(XG_HttpHelper::addParameter(XG_UserHelper::getThumbnailUrl($profile,96,96),'xn_auth','no')) %>" alt="<%= xnhtmlentities(xg_username($profile)) %>"></td>
            </tr>
        </table>
        <p class="smallprint"><small>
			<?php $unsubUrl = xnhtmlentities($message['unsubscribeUrl']); ?>
			<%= xg_html('TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO', xnhtmlentities($message['appName'])) %><br />
			<a href="<%= $unsubUrl %>"><%= $unsubUrl %></a>
        </small></p>
    </div>
