<?php

/**
 * Useful functions for working with contacts, friends, and relationships.
 */
class  XG_ContactHelper {

    /**
     * Determines the friend status for the given user list, which may contain
     * XN_Content objects, XN_Profiles, or usernames.
     *
     * @param $screenName string The screenName to test
     * @param $users object|array  A User XN_Content, User W_Content, XN_Profile, screen name, or array of the aforementioned
     * @return array  An array of screen name => status string (contact | friend | pending | requested |
     *         groupie | blocked | not-friend); or just the status if a user object (not an array) was passed in
     */
    public static function getFriendStatusFor($screenName, $users) {
        $returnScalar = false;
        if (! is_array($users)) { $returnScalar = true; $users = array($users); }
        if (mb_strlen($screenName) && (count($users) > 0)) {
            $contacts = array();
            foreach ($users as $user) {
                if ($user instanceof XN_Content && $user->type == 'User') {
                    $contacts[] = $user->title;
                } elseif ($user instanceof W_Content && $user->type == 'User') {
                    $contacts[] = $user->title;
                } elseif ($user instanceof XN_Profile) {
                    $contacts[] = $user->screenName;
                } else {
                    $contacts[] = $user;
                }
            }
            $contacts = XN_Query::create('Contact')
                                ->filter('owner', '=', $screenName)
                                ->filter('contact', 'in', $contacts)
                                ->execute();
            $result = array();
            if ($returnScalar) {
                if (count($contacts) == 1) {
                    return $contacts[0]->relationship;
                } else {
                    return null;
                }
            }
            foreach ($contacts as $contact) {
                $result[$contact->contact] = $contact->relationship;
            }
            return $result;
        } else {
            return $returnScalar ? null : array();
        }
    }

    // Index_MessageHelper has more friend functions. Move them here if they are needed
    // outside of the index widget. [Jon Aquino 2008-01-01]

}
