<!--- <cfset theURL = <!--- "http://news.google.com/news?q=google+rss&hl=en&lr=&ct=title&ie=UTF-8&output=rss" --->
"http://polonews.com/main/plugins/p47_rsssyn/rssfeed.php"
>

<cfset rss = createObject("component","rss")>

	<cfset entries = rss.getEntries(theURL)>
	<cfdump var="#entries#">
 --->	
<!--- Run this code if the feed URL form has been submitted. --->
<cfif isDefined("Form.submit")>
    <cfloop index="i" from="1" to="3">
        <!--- Use array notation and string concatenation to create a variable
                 for this feed. --->
        <cfset theFeed = Form["Feed"&i]>
        <cfif theFeed NEQ "">
            <!--- Use a separate thread to get each of the feeds. --->
            <cfthread action="run" name="t#i#" feed="#theFeed#">
                <cffeed source="#feed#" 
                    properties="thread.myProps" 
                    query="thread.myQuery">
            </cfthread>
        <cfelse>
            <!--- If the user didn't fill all fields, show an error message. --->
            <h3>This example requires three feeds.<br />
            Click the Back button and try again.</h3>
            <cfabort>
        </cfif>
    </cfloop>

    <!--- Join the three threads. Use a 6 second timeout. --->
    <cfthread action="join" name="t1,t2,t3" timeout="6000" />
    
    <!--- Use a loop to display the results from the feeds. --->
    <cfloop index="i" from="1" to="3">
        <!--- Use the cfthread scope and associative array notation to get the
                Thread scope. --->
        <cfset feedResult=cfthread["t#i#"]>
        <!--- Display feed information only if you got items,
                 for example, the feed must complete before the join. --->
        <cfif isDefined("feedResult.myQuery")>
            <cfoutput><h2>#feedResult.myProps.title#</h2></cfoutput>
            <cfoutput query="feedResult.myQuery">
                <p><a href="#RSSLINK#">#TITLE#</a></p>
            </cfoutput>
        </cfif>
    </cfloop>

</cfif>

<!--- The form for entering the feeds to aggregate. --->
<cfform>
    <h3>Enter three RSS Feeds</h3>
    <cfinput type="text" size="100" name="Feed1" validate="url"
        value="http://rss.adobe.com/events.rss?locale=en"><br />
    <cfinput type="text" size="100" name="Feed2" validate="url"
        value="http://weblogs.macromedia.com/dev_center/index.rdf"><br />
    <cfinput type="text" size="100" name="Feed3" validate="url" 
        value="http://rss.adobe.com/studio.rss?locale=en"><br />
    <cfinput type="submit" name="submit">
</cfform>
