<cffunction name="include" returntype="void">
	<cfargument name="template" type="string" required="yes">

	<cfinclude template="#arguments.template#">
</cffunction>

<cffunction name="dump" returntype="void">
	<cfargument name="var" type="any" required="yes">

	<cfdump var="#arguments.var#">
</cffunction>

<cffunction name="param" output="no" returntype="void">>
	<cfargument name="varname" type="string" required="yes">
	<cfargument name="value" type="any" required="no" default="">

	<cfif NOT isDefined(arguments.varname)>
		<cfset setVariable(arguments.varname, arguments.value)>
	</cfif>
</cffunction>

<cffunction name="printSnippet">
	<cfargument name="CONTENT_ID" type="string" required="yes">
	
	<cfset getSnippet = application.blogcfm.getSnippet(variables.blog_id, arguments.content_id)>
	<cfif getSnippet.errorCode is 0>
		<cfoutput>#getSnippet.snippetInfo.CONTENT#</cfoutput>
	<cfelse>
<cfoutput>
<!-- printSnippet() error:  #retVal.errorMessage# -->
</cfoutput>
	</cfif>
</cffunction>

<cffunction name="location" output="false" returnType="void">
	<cfargument name="urlRedirect" type="string" required="true">
	<cfargument name="addToken" type="boolean" default="false" required="false">
	<cflocation url="#arguments.urlRedirect#" addToken="#arguments.addToken#">
</cffunction>

<cffunction name="metalocation" output="true" returnType="void">
	<cfargument name="title" type="string" required="true">
	<cfargument name="urlRedirect" type="string" required="true">
<cfoutput>
<html>
<head>
	<title>#title#</title>
	<meta http-equiv="refresh" content="2; url=#urlRedirect#">
<style type="text/css">
body {
	font=face: verdana;
	font-family: sans-serif;
}
</style>
</head>
<body>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<center><H3>#title#</H3>
Please wait ...
</center>
</body>
</html>
</cfoutput>
<cfabort>
</cffunction>

<cffunction name="setCookie" output="false" returnType="void">
	<Cfargument name="cName" type="string" required="true">
	<cfargument name="cValue" type="string" required="true">
	<cfargument name="cPersist" type="Boolean" required="yes">
	<cfargument name="delete" type="boolean" required="no" default="no">
	<cfif delete>
		<cfcookie name="#arguments.cName#" value="" expires="NOW">
	<cfelseif cPersist>
		<cfcookie name="#arguments.cName#" value="#arguments.cValue#" expires="NEVER">
	<cfelse>
		<cfcookie name="#arguments.cName#" value="#arguments.cValue#">
	</cfif>
</cffunction>

<cffunction name="existingRedirect" output="false" returnType="string">
	<cfif isDefined("Session.redirect") and Session.redirect neq "">
		<cfreturn session.redirect>
	<cfelse>
		<cfreturn "">
	</cfif>
</cffunction>

<cfscript>
/**
 * Makes a row of a query into a structure.
 * 
 * @param query 	 The query to work with. 
 * @param row 	 Row number to check. Defaults to row 1. 
 * @return Returns a structure. 
 * @author Nathan Dintenfass (nathan@changemedia.com) 
 * @version 1, December 11, 2001 
 */
function queryRowToStruct(query){
	//by default, do this to the first row of the query
	var row = 1;
	//a var for looping
	var ii = 1;
	//the cols to loop over
	var cols = listToArray(query.columnList);
	//the struct to return
	var stReturn = structnew();
	//if there is a second argument, use that for the row number
	if(arrayLen(arguments) GT 1)
		row = arguments[2];
	//loop over the cols and build the struct from the query row
	for(ii = 1; ii lte arraylen(cols); ii = ii + 1){
		stReturn[cols[ii]] = query[cols[ii]][row];
	}		
	//return the struct
	return stReturn;
}
</cfscript>

<cffunction name="formatAddress">
	<cfargument name="address_type" type="string" required="yes">
	<cfargument name="linebreak" type="string" required="yes">
	<cfargument name="data" type="struct" required="yes">
	
	<cfset retVal = "">

	<cfif address_type eq "S_">
		<cfset retVal = retVal & trim(data.S_NAME) & linebreak>
		<cfif isDefined("data.S_ADDRESS1") AND trim(data.S_ADDRESS1) neq "">
			<cfset retVal = retVal & trim(data.S_ADDRESS1) & linebreak>
		</cfif>
		<cfif isDefined("data.S_ADDRESS2") AND trim(data.S_ADDRESS2) neq "">
			<cfset retVal = retVal & trim(data.S_ADDRESS2) & linebreak>
		</cfif>
		<cfset retVal = retVal & trim(data.S_CITY) & ", ">
		<cfif isDefined("data.S_STATE") AND trim(data.S_STATE) neq "">
			<cfset retVal = retVal & trim(data.S_STATE)>
		<cfelseif isDefined("data.S_STATE_OTHER") AND trim(data.S_STATE_OTHER) neq "">
			<cfset retVal = retVal & trim(data.S_STATE_OTHER)>
		</cfif>
		<cfif isDefined("data.S_POSTAL_CODE") AND trim(data.S_POSTAL_CODE) neq "">
			<cfset retVal = retVal & " " & trim(data.S_POSTAL_CODE)>
		</cfif>
		<cfset retVal = retVal & linebreak>
		<cfset retVal = retVal & trim(data.S_COUNTRY) & linebreak>
	<cfelseif address_type eq "B_">
		<cfset retVal = retVal & trim(data.B_NAME) & linebreak>
		<cfif isDefined("data.B_ADDRESS1") AND trim(data.B_ADDRESS1) neq "">
			<cfset retVal = retVal & trim(data.B_ADDRESS1) & linebreak>
		</cfif>
		<cfif isDefined("data.B_ADDRESS2") AND trim(data.B_ADDRESS2) neq "">
			<cfset retVal = retVal & trim(data.B_ADDRESS2) & linebreak>
		</cfif>
		<cfset retVal = retVal & trim(data.B_CITY) & ", ">
		<cfif isDefined("data.B_STATE") AND trim(data.B_STATE) neq "">
			<cfset retVal = retVal & trim(data.B_STATE)>
		<cfelseif isDefined("data.B_STATE_OTHER") AND trim(data.B_STATE_OTHER) neq "">
			<cfset retVal = retVal & trim(data.B_STATE_OTHER)>
		</cfif>
		<cfif isDefined("data.B_POSTAL_CODE") AND trim(data.B_POSTAL_CODE) neq "">
			<cfset retVal = retVal & " " & trim(data.B_POSTAL_CODE)>
		</cfif>
		<cfset retVal = retVal & linebreak>
		<cfset retVal = retVal & trim(data.B_COUNTRY) & linebreak>
	</cfif>
	<cfreturn retVal>
</cffunction>

<cfscript>
/**
 * Returns a string with words capitalized for a title.
 * Modified by Ray Camden to include var statements.
 * 
 * @param initText 	 String to be modified. 
 * @return Returns a string. 
 * @author Ed Hodder (ed.hodder@bowne.com) 
 * @version 2, July 27, 2001 
 */
function capFirstTitle(initText){
	
	var Words = "";
	var j = 1; var m = 1;
	var doCap = "";
	var thisWord = "";
	var excludeWords = ArrayNew(1);
	var outputString = "";
	
	initText = LCASE(initText);
	
	//Words to never capitalize
	excludeWords[1] = "an";
	excludeWords[2] = "the";
	excludeWords[3] = "at";
	excludeWords[4] = "by";
	excludeWords[5] = "for";
	excludeWords[6] = "of";
	excludeWords[7] = "in";
	excludeWords[8] = "up";
	excludeWords[9] = "on";
	excludeWords[10] = "to";
	excludeWords[11] = "and";
	excludeWords[12] = "as";
	excludeWords[13] = "but";
	excludeWords[14] = "if";
	excludeWords[15] = "or";
	excludeWords[16] = "nor";
	excludeWords[17] = "a";
	
	//Make each word in text an array variable
		
	Words = ListToArray(initText, " ");
	
	//Check words against exclude list
	for(j=1; j LTE (ArrayLen(Words)); j = j+1){
		doCap = true;
		
		//Word must be less that four characters to be in the list of excluded words
		if(LEN(Words[j]) LT 4 ){
			if(ListFind(ArrayToList(excludeWords,","),Words[j])){
				doCap = false;
			}
		}

		//Capitalize hyphenated words	
		if(ListLen(Words[j],"-") GT 1){
			for(m=2; m LTE ListLen(Words[j], "-"); m=m+1){
				thisWord = ListGetAt(Words[j], m, "-");
				thisWord = UCase(Mid(thisWord,1, 1)) & Mid(thisWord,2, LEN(thisWord)-1);
				Words[j] = ListSetAt(Words[j], m, thisWord, "-");
			}
		}
		
		//Automatically capitalize first and last words
		if(j eq 1 or j eq ArrayLen(Words)){
			doCap = true;
		}
		
		//Capitalize qualifying words
		if(doCap){
			Words[j] = UCase(Mid(Words[j],1, 1)) & Mid(Words[j],2, LEN(Words[j])-1);
		}
	}
	
	outputString = ArrayToList(Words, " ");

	return outputString;

}
</cfscript>

<cffunction name="isEmail" access="public" output="no" returnType="Boolean">
	<cfargument name="str" type="string" required="yes">

	<cfif REFindNoCase("^['_a-z0-9-]+(\.['_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*\.(([a-z]{2,3})|(aero|coop|info|museum|name))$",str)>
		<cfreturn true>
	<cfelse>
		<cfreturn false>
	</cfif>
</cffunction>

<CFFUNCTION ACCESS="public" NAME="tagStripper" OUTPUT="no" RETURNTYPE="string">
	<CFARGUMENT NAME="SOURCE" REQUIRED="YES" TYPE="string">
	<CFARGUMENT NAME="EXCLUDE" REQUIRED="YES" TYPE="string">
	


	<!-- if there are exclusions, mark them with NOSTRIP -->
	<CFIF EXCLUDE neq "">
	        <CFLOOP INDEX="ExcludeTag" LIST="#EXCLUDE#">
	                <CFSET EndLoop = 0>
	                <CFSET StartPosition = 1>
	                <CFLOOP CONDITION="EndLoop neq 1">
	                        <CFSET StartPosition = REFindNoCase("</*#EXCLUDETAG#([[:space:]]|>)",SOURCE)>
	                        <CFIF StartPosition gt 0>
	                                <CFSET SOURCE = Insert("___TEMP___NOSTRIP___",SOURCE,StartPosition)>
	                                <CFSET SOURCE = RemoveChars(SOURCE,StartPosition,1)>
	                                <CFSET StartPosition = 1>
	                        <CFELSE>
	                                <CFSET EndLoop = 1>
	                        </CFIF>
	                </CFLOOP>
	        </CFLOOP>
	</CFIF>
	<!-- loop through and strip all tags -->
	<CFSET EndLoop = 0>
	<CFSET StartPosition = 1>
	<CFLOOP CONDITION="EndLoop neq 1">
	        <CFSET StartPosition = REFindNoCase("</*[[:alpha:]]",SOURCE)>
	        <CFIF StartPosition gt 0>
	                <CFSET EndPosition = Find(">",SOURCE,StartPosition)>
	                <CFIF EndPosition gt 0>
	                        <CFSET SOURCE = RemoveChars(SOURCE,StartPosition,EndPosition-StartPosition+1)>
	                        <CFSET StartPosition = 1>
	                </CFIF>
	        <CFELSE>
	                <CFSET EndLoop = 1>
	        </CFIF>
	</CFLOOP>
	<CFIF NOT ListContains(LCase(EXCLUDE),"comments")>
	        <CFSET EndLoop = 0>
	        <CFSET StartPosition = 1>
	        <CFLOOP CONDITION="EndLoop neq 1">
	                <CFSET StartPosition = REFindNoCase("<!--",SOURCE)>
	                <CFIF StartPosition gt 0>
	                        <CFSET EndPosition = Find("-->",SOURCE,StartPosition)>
	                        <CFIF EndPosition gt 0>
	                                <CFSET SOURCE = RemoveChars(SOURCE,StartPosition,EndPosition-StartPosition+3)>
	                                <CFSET StartPosition = 1>
	                        </CFIF>
	                <CFELSE>
	                        <CFSET EndLoop = 1>
	                </CFIF>
	        </CFLOOP>
	</CFIF>
	<!--- convert excluded tags back to normal --->
	<CFSET SOURCE = Replace(SOURCE,"___TEMP___NOSTRIP___","<","ALL")>
	<CFRETURN SOURCE>

</CFFUNCTION>

<cfscript>
/**
 * Converts an IP address to a 32-bit dotted decimal IP number.
 * 
 * @param ipAddress 	 IP Address to convert. (Optional)
 * @return Returns a number. 
 * @author Jonathan Pickard (j_pickard@hotmail.com) 
 * @version 1, September 27, 2002 
 */
function IPAddress2IPDottedDecimal( ipAddress ) {
	var	ipValue = 0;
	var lBitShifts = "24,16,8,0";
	var i = 1;

	if ( ListLen( ipAddress, "." ) EQ 4 )
	{
		for ( ; i LTE 4; i = i + 1 )
		{
			ipValue = ipValue + BitSHLN( ListGetAt( ipAddress, i, "." ), ListGetAt( lBitShifts, i ) );
		}
	}

	return ipValue;
}
</cfscript>

<cfscript>
/**
 * This function takes URLs in a text string and turns them into links.
 * Version 2 by Lucas Sherwood, lucas@thebitbucket.net.
 * Version 3 Updated to allow for ;
 * 
 * @param string 	 Text to parse. (Required)
 * @param target 	 Optional target for links. Defaults to "". (Optional)
 * @param paragraph 	 Optionally add paragraphFormat to returned string. (Optional)
 * @return Returns a string. 
 * @author Joel Mueller (jmueller@swiftk.com) 
 * @version 3, August 11, 2004 
 */
function ActivateURL(string) {
	var nextMatch = 1;
	var objMatch = "";
	var outstring = "";
	var thisURL = "";
	var thisLink = "";
	var	target = IIf(arrayLen(arguments) gte 2, "arguments[2]", DE(""));
	var paragraph = IIf(arrayLen(arguments) gte 3, "arguments[3]", DE("false"));
	var nofollow = IIf(arrayLen(arguments) gte 4, "arguments[4]", DE("false"));
	
	do {
		objMatch = REFindNoCase("(((https?:|ftp:|gopher:)\/\/)|(www\.|ftp\.))[-[:alnum:]\?%,\.\/&##!;@:=\+~_]+[A-Za-z0-9\/]", string, nextMatch, true);
		if (objMatch.pos[1] GT nextMatch OR objMatch.pos[1] EQ nextMatch) {
			outString = outString & Mid(String, nextMatch, objMatch.pos[1] - nextMatch);
		} else {
			outString = outString & Mid(String, nextMatch, Len(string));
		}
		nextMatch = objMatch.pos[1] + objMatch.len[1];
		if (ArrayLen(objMatch.pos) GT 1) {
			// If the preceding character is an @, assume this is an e-mail address
			// (for addresses like admin@ftp.cdrom.com)
			if (Compare(Mid(String, Max(objMatch.pos[1] - 1, 1), 1), "@") NEQ 0) {
				thisURL = Mid(String, objMatch.pos[1], objMatch.len[1]);
				thisLink = "<A HREF=""";
				switch (LCase(Mid(String, objMatch.pos[2], objMatch.len[2]))) {
					case "www.": {
						thisLink = thisLink & "http://";
						break;
					}
					case "ftp.": {
						thisLink = thisLink & "ftp://";
						break;
					}
				}
				thisLink = thisLink & thisURL & """";
				if (Len(Target) GT 0) {
					thisLink = thisLink & " TARGET=""" & Target & """";
				}
				if (nofollow) {
					thisLink = thisLink & " rel=""nofollow""";
				}
				thisLink = thisLink & ">" & thisURL & "</A>";
				outString = outString & thisLink;
				// String = Replace(String, thisURL, thisLink);
				// nextMatch = nextMatch + Len(thisURL);
			} else {
				outString = outString & Mid(String, objMatch.pos[1], objMatch.len[1]);
			}
		}
	} while (nextMatch GT 0);
		
	// Now turn e-mail addresses into mailto: links.
	outString = REReplace(outString, "([[:alnum:]_\.\-]+@([[:alnum:]_\.\-]+\.)+[[:alpha:]]{2,4})", "<A HREF=""mailto:\1"">\1</A>", "ALL");
		
	if (paragraph) {
		outString = XHTMLParagraphFormat(outString);
	}
	return outString;
}
</cfscript>

<cffunction name="genCaptchaImage" access="public" output="no" returnType="struct">
	<cfargument name="imageDir" required="yes" type="string">
	<cfargument name="dirsep" required="yes" type="string">
	<cfargument name="fontFile" required="no" type="string">
	
	<cfscript>
		var bgImage = CreateObject("java", "java.awt.image.BufferedImage");
		var fontImage = CreateObject("java", "java.awt.image.BufferedImage");
		var captchaImage = CreateObject("java", "java.awt.image.BufferedImage");
		var imageIO = CreateObject("java", "javax.imageio.ImageIO");
		var inFile  = CreateObject("java", "java.io.File");
		var outFile = CreateObject("java", "java.io.File");
		var RenderingHints = CreateObject("java","java.awt.RenderingHints");
		var Color = CreateObject("java","java.awt.Color");
		var font = createObject("java","java.awt.Font");
		var font_stream = createObject("java","java.io.FileInputStream");
		var at = CreateObject("java", "java.awt.geom.AffineTransform");
		var op = CreateObject("java", "java.awt.image.AffineTransformOp");
		var AlphaComposite = CreateObject("Java", "java.awt.AlphaComposite");
			
		var text = "";
		var cnt = 0;
		var rnd = 0;
		var g2 = "";
		var gfx = "";
		var fc = "";
		var bounds = "";
		var width = "";
		var height = "";
		var bgColor = "";
		var fontColor = "";
				
		var captchaFilename = "";
		
		var retVal = StructNew();
		
		retVal.image = "";
		retVal.key = "";
		
		text = "";
		for (cnt = 1; cnt lte 6; cnt = cnt + 1) {
			rnd = RandRange(1,36);
			if (rnd lte 26) {
				if (rnd eq 23) { rnd = 22; } // don't use W, it's too wide
				if (rnd eq 9 or rnd eq 12) { rnd = 10; } // don't use I or L -- too confusing
				if (rnd eq 15 or rnd eq 27) { rnd = 14; } // don't use 0 or O, too confusing.
				text = text & chr(rnd+64);
			 } else {
			 	text = text & rnd-27;
			 }
		}
		if (not isDefined("arguments.fontFile")) {
			arguments.fontFile = application.blogcfm.captchaFont;
		}
		if (not fileExists(arguments.fontFile)) {
			return retVal;
		}
		
		captchaFilename = "#arguments.imageDir##arguments.dirsep#img#CreateUUID()#.png";

		bgColor = Color.init(javacast("int", 255), javacast("int", 255), javacast("int", 255));
		fontColor = Color.init(javacast("int", 0), javacast("int", 0), javacast("int", 0));
		
		font_stream.init(arguments.fontFile);
		font = font.createFont(font.TRUETYPE_FONT, font_stream);
		font = font.deriveFont(javacast("float",22));
		
		inFile.init("#arguments.imageDir##arguments.dirsep#captcha.png");
		bgImage = imageIO.read(inFile);
		
		fontImage.init(1,1,fontImage.TYPE_INT_RGB);
		g2 = fontImage.createGraphics();
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		fc = g2.getFontRenderContext();
		bounds = font.getStringBounds(text,fc);
		
		width = bgImage.getWidth();
		height = bgImage.getHeight();
		
		captchaImage.init(javacast("int",width),javacast("int",height), captchaImage.TYPE_INT_RGB);
		
		g2 = captchaImage.createGraphics();
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setFont(font);
		
		g2.setColor(bgColor);
		g2.fillRect(javacast("int",0),javacast("int",0),javacast("int",width),javacast("int",height));
		g2.setColor(fontColor);
		g2.drawString(text,javacast("int",0),javacast("int",0-bounds.getY()));
		
		
		// now watermark the background image with the captcha image
		
		gfx = bgImage.getGraphics();
		
		gfx.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.50));
		
		at.init();
		op.init(at,op.TYPE_BILINEAR);
		gfx.drawImage(captchaImage, op, javacast("int",RandRange(1,2)*5), javacast("int",RandRange(0,1)*5));
		gfx.dispose();
		
		
		outFile.init(captchaFilename);
		imageIO.write(bgImage, "png", outFile);
		
		retVal.key = hash(text);
		retVal.image = getFileFromPath(captchaFilename);
	</cfscript>
	<cfreturn retval>
</cffunction>

<cfscript>
/**
 * Converts a query object into an array of structures.
 * 
 * @param query 	 The query to be transformed 
 * @return This function returns a structure. 
 * @author Nathan Dintenfass (nathan@changemedia.com) 
 * @version 1, September 27, 2001 
 */
function QueryToArrayOfStructures(theQuery){
	var theArray = arraynew(1);
	var cols = ListtoArray(theQuery.columnlist);
	var row = 1;
	var thisRow = "";
	var col = 1;
	for(row = 1; row LTE theQuery.recordcount; row = row + 1){
		thisRow = structnew();
		for(col = 1; col LTE arraylen(cols); col = col + 1){
			thisRow[cols[col]] = theQuery[cols[col]][row];
		}
		arrayAppend(theArray,duplicate(thisRow));
	}
	return(theArray);
}
</cfscript>

<cffunction name="XHTMLParagraphFormat" returntype="string" output="false">
	<cfargument name="str" required="true" type="string">
	<cfreturn REReplace(arguments.str, "\r+\n", "<br />", "ALL")>
</cffunction>

<cffunction name="markupPlayers" access="public" output="false" returnType="string">
	<cfargument name="str" type="string" required="yes">

<cfset var player = "">
<cfset var players = StructNew()>
<cfset var playerNames = ArrayNew(1)>
<cfset var STATSID = "">
<cfset var PLAYER_NAME = "">
<cfset var playersDat = "3342	Eric Staal
1188	Cory Stillman
45	Rod Brind'Amour
3640	Andrew Ladd
587	Ray Whitney
1657	Matt Cullen
2411	Erik Cole
1916	Frantisek Kaberle
1038	Oleg Tverdovsky
2468	Justin Williams
669	Bret Hedican
2412	Josef Vasicek
497	Glen Wesley
539	Aaron Ward
2407	Mike Commodore
2598	Radim Vrbata
3265	Niklas Nordgren
1671	Kevyn Adams
2475	Craig Adams
2445	Niclas Wallin
1977	Jesse Boulerice
2114	Mike Zigomanis
2787	Andrew Hutchinson
3164	Cam Ward
3017	Martin Gerber">

<cfset players = StructNew()>
<cfloop list="#playersDat#" delimiters="#Chr(10)#" index="player">
	<cfset STATSID = listGetAt(player,1,Chr(9))>
	<cfset PLAYER_NAME = listGetAt(player,2,Chr(9))>
	<cfset players[PLAYER_NAME] = STATSID>
</cfloop>
<cfset playerNames = StructKeyArray(players)>
<cfloop from="1" to="#ArrayLen(playerNames)#" step="1" index="CNT">
	<cfset PLAYER_NAME = playerNames[CNT]>
	<cfset STATSID = players[PLAYER_NAME]>
	<cfset replaceText = "<a target=#Chr(34)#_blank#Chr(34)# href=#Chr(34)#http://sports.espn.go.com/nhl/players/profile?statsId=#STATSID##Chr(34)#>#PLAYER_NAME#</a>">
	<cfset str = replacenocase(str,PLAYER_NAME,replaceText,"ALL")>
</cfloop>
	<cfreturn str>
</cffunction>
