DROP TABLE dbo.BLOG_CONFIG;
CREATE TABLE dbo.BLOG_CONFIG (
	BLOG_ID smallint not null default 0,
	ADMIN_EMAIL varchar(255) not null default '',
	BLOG_TITLE varchar(255) not null default '',
	FLAG_HTML_EDITOR_ADMIN smallint not null,
	FLAG_HTML_EDITOR_ALL smallint not null,
	SESSION_IP_SECURITY smallint not null,
	CREATE_ENTRY_FILES smallint not null,
	REQUIRE_LOGIN smallint not null,
	MONITOR_LEVEL smallint not null,
	ENABLE_SUBSCRIPTIONS smallint not null,
	ENABLE_CAPTCHA smallint not null,
	WEBROOT varchar(255) not null,
	DISABLE_COMMENTS smallint not null,
	COMMENT_DISABLE_AGE smallint not null,
	PING_ON_UPDATE text not null default '',
	CSS_OVERRIDE text not null default '',
	primary key (BLOG_ID)
);

DROP TABLE dbo.CATEGORIES;
CREATE TABLE dbo.CATEGORIES (
  BLOG_ID integer NOT NULL,
  CATEGORY_ID char(35) NOT NULL,
  CATEGORY_TYPE_ID smallint NOT NULL default 0,
  CATEGORY_NAME varchar(100) NOT NULL default '',
  PRIMARY KEY  (BLOG_ID, CATEGORY_ID)
);

DROP TABLE dbo.USERS;
CREATE TABLE dbo.USERS (
  BLOG_ID integer NOT NULL,
  USER_ID char(35) not null,
  USER_KEY varchar(35) NOT NULL default '',
  UNAME varchar(20) NOT NULL default '',
  PWORD varchar(255) NOT NULL default '',
  EMAIL varchar(255) NOT NULL default '',
  WEBSITE varchar(255) not null default '',
  FLAG_ACTIVE smallint not null default 1,
  FLAG_SUPERUSER smallint not null default 0,
  FLAG_CONFIRMED smallint not null default 0,
  FLAG_ADMIN integer not null default 0,
  FLAG_NOTIFY smallint not null default 0,
  PRIMARY KEY  (BLOG_ID, USER_ID),
  UNIQUE (BLOG_ID, EMAIL),
  UNIQUE (BLOG_ID, UNAME)
);

DROP TABLE dbo.USER_SESSIONS;
CREATE TABLE dbo.USER_SESSIONS (
  BLOG_ID integer NOT NULL,
  SESSION_KEY char(35) NOT NULL default '',
  USER_ID char(35) not null,
  IP char(15) not null default '0.0.0.0',
  ACCESS_DATE datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (BLOG_ID, SESSION_KEY)
);

DROP TABLE dbo.BLOG_ENTRIES;
CREATE TABLE dbo.BLOG_ENTRIES (
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	GALLERY_ID int not null default 0,
	USER_ID char(35) not null default '',
	UNAME varchar(20) not null,
	ENTRY_DATE datetime not null,
	TITLE varchar(255) not null default '',
	SUBTITLE varchar(255) not null default '',
	ABSTRACT text not null default '',
	CONTENT text not null default '',
	FLAG_ALLOW_COMMENTS smallint not null default 1,
	COMMENT_DISABLE_AGE smallint not null default 0,
	ENTRY_FILENAME varchar(255) not null default '',
	totalComments integer not null,
	primary key (BLOG_ID, ENTRY_ID)
);

DROP TABLE dbo.BLOG_COMMENTS;
CREATE TABLE dbo.BLOG_COMMENTS
(
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	COMMENT_ID int not null,
	USER_ID char(35) not null default '',
	UNAME varchar(20) not null,
	EMAIL varchar(255) not null,
	WEBSITE varchar(255) not null,
	ENTRY_DATE datetime not null,
	IP char(15) not null default '0.0.0.0',
	COMMENT_TEXT text not null,
	primary key (BLOG_ID, ENTRY_ID, COMMENT_ID)
);

DROP TABLE dbo.BLOG_CATEGORIES;
CREATE TABLE dbo.BLOG_CATEGORIES
(
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	CATEGORY_ID char(35) not null,
	primary key (BLOG_ID, ENTRY_ID, CATEGORY_ID)
);

DROP TABLE dbo.BLOG_SUBSCRIPTIONS;
CREATE TABLE dbo.BLOG_SUBSCRIPTIONS
(
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	USER_ID char(35) not null,
	LAST_NOTIFY datetime null,
	LAST_ACCESS datetime not null,
	primary key (BLOG_ID, ENTRY_ID, USER_ID)
);

DROP TABLE dbo.GALLERIES;
CREATE TABLE dbo.GALLERIES (
  BLOG_ID integer not null,
  GALLERY_ID integer NOT NULL,
  CATEGORY_ID char(35) not null default '',
  CREATED datetime not null,
  LAST_UPDATED datetime null,
  GALLERY_NAME varchar(255) NOT NULL default '',
  GALLERY_DESC varchar(255) NOT NULL default '',
  PRIVATE smallint not null default 0,
  PRIMARY KEY  (BLOG_ID, GALLERY_ID)
);

DROP TABLE dbo.GALLERY_PHOTOS;
CREATE TABLE dbo.GALLERY_PHOTOS (
  BLOG_ID integer not null,
  GALLERY_ID integer NOT NULL,
  PHOTO_ID integer not null,
  FILENAME varchar(255) not null default '',
  PHOTO_DESC varchar(255) not null default '',
  ORIG_FILENAME varchar(255) not null default '',
  THUMB_FILENAME varchar(255) not null default '',
  PRIMARY KEY  (BLOG_ID, GALLERY_ID, PHOTO_ID)
);

