<cfsetting enablecfoutputonly="yes">
<cfparam name="showDate" default="#Now()#">
<cfset showDate = session.ShowDate>
<cfset showDate = dateFormat(showDate,'mm/dd/yyyy')>
<cfset linkUrl = "#variables.blogConfig.webRoot#/index.cfm?mode=archive&year=<YEAR>&month=<MONTH>&day=<DAY>">
<cfparam name="highlightDates" default="">
<cfset linkTarget = "_self">
<cfset firstDayOfWeek = DayOfWeek(CreateDate(Year(showDate),Month(showDate),1))>
<cfset BeginCalendar = 2 - FirstDayOfWeek>
	<cfset prevUrl = linkUrl>
	<cfset prevUrl = ReplaceNoCase(prevUrl,"&day=<day>","","ALL")>
	<cfset nextUrl = linkUrl>
	<cfset nextUrl = ReplaceNoCase(nextUrl,"&day=<day>","","ALL")>
		<cfset prevUrl = replaceNoCase(prevUrl,"<DAY>",Day(DateAdd('m',-1,showDate)),"ALL")>
		<cfset prevUrl = replaceNoCase(prevUrl,"<MONTH>",month(DateAdd('m',-1,showDate)),"ALL")>
		<cfset prevUrl = replaceNoCase(prevUrl,"<YEAR>",year(DateAdd('m',-1,showDate)),"ALL")>
		<cfset nextUrl = replaceNoCase(nextUrl,"<DAY>",Day(DateAdd('m',1,showDate)),"ALL")>
		<cfset nextUrl = replaceNoCase(nextUrl,"<MONTH>",month(DateAdd('m',1,showDate)),"ALL")>
		<cfset nextUrl = replaceNoCase(nextUrl,"<YEAR>",year(DateAdd('m',1,showDate)),"ALL")>
		<cfif isDefined("fullMonth")>
			<cfset prevUrl = prevUrl & "&fullMonth=1">
			<cfset nextUrl = nextUrl & "&fullMonth=1">
		</cfif>
<cfoutput>
<table class="cfmcal">
<tr class="header">
	<td><a href="#prevUrl#">&lt;&lt;</a></td>
	<td colspan="5">
	#MonthAsString(Month(showDate))#, #Year(showDate)#
	</td>
	<td><a href="#nextUrl#">&gt;&gt;</a></td>
</tr>
<tr class="weekdays">
<cfloop from="1" to="7" step="1" index="cnt"><td>#ucase(left(dayOfWeekAsString(cnt),1))#</td></cfloop>
</tr>
</cfoutput>
<cfset cnt1 = 0>
<cfloop from="#beginCalendar#" to="#daysInMonth(showDate)#" step="1" index="cnt">
	<cfif cnt1 is 0>
		<cfoutput><tr class="week"></cfoutput>
	</cfif>
	<cfif linkUrl neq "">
		<cfset thisDayUrl = replaceNoCase(linkUrl,"<DAY>",cnt,"ALL")>
		<cfset thisDayUrl = replaceNoCase(thisDayUrl,"<MONTH>",month(showDate),"ALL")>
		<cfset thisDayUrl = replaceNoCase(thisDayUrl,"<YEAR>",year(showDate),"ALL")>
		<cfset openHref = "<a href=#chr(34)##thisDayUrl##chr(34)#">
		<cfif linkTarget neq "">
			<cfset openHref = openHref & " target=#chr(34)##linkTarget##Chr(34)#">
		</cfif>
		<cfset openHref = openHref & ">">
		<cfset closeHref = "</a>">
	<cfelse>
		<cfset openHref = "">
		<cfset closeHref = "">
	</cfif>
	<cfif cnt lt 1>
		<cfoutput><td class="day_blank"></td></cfoutput>
	<cfelseif ListFind(highlightDates,cnt) gt 0>
		<cfoutput><td class="day_highlighted" onClick="window.location.href='#thisDayUrl#';">#openHref##cnt##closeHref#</td></cfoutput>
	<cfelse>
		<cfoutput><td class="day">#cnt#</td></cfoutput>
	</cfif>
	<cfif cnt1 gt 5>
		<cfoutput></tr>#Chr(10)#</cfoutput>
		<cfset cnt1 = 0>
	<cfelse>
		<cfset cnt1 = cnt1 + 1>
	</cfif>
</cfloop>
<cfif cnt1 lt 7 and cnt1 gt 0>
	<cfloop from="#cnt1#" to="6" step="1" index="cnt2">
		<cfoutput><td class="day_blank"></td></cfoutput>
	</cfloop>
	<cfoutput></tr>#Chr(10)#</cfoutput>
</cfif>
<cfoutput></table>
</cfoutput>
<cfsetting enablecfoutputonly="no">
