<cfsetting enablecfoutputonly="yes">
<cfapplication
	name="BlogCFM"
	sessionManagement="yes"
	sessionTimeout="#createTimespan(0,1,0,0)#">

<!--- ######## CONFIGURATION VARIABLES ####### --->

<!---<cfset variables.dsn = "blogcfm"> --->
<cfset variables.dsn = "iguanaDB">
<cfset variables.blog_id = 1>
<cfset variables.mapping = "/blogcfm/">
<cfset variables.editorType = "fck">
<!--- fckEditor is included.  To use TinyMCE, you simply download the tinymce
	distribution, unzip it into the admin directory in a subdirectory called "tinymce",
	and change the setting above to "mce"
--->
	<!--- 
		if you use a mapping name, make sure you specify both the preceding
		and trailing slashes, ie /blogcfm/ 
	--->
<cfset variables.reloadCFC = "yes">
	<!--- 
		set to "Yes" for development/testing 
		That will force the CFC to reload on every page request.
	--->
<cfset variables.dbtype = "access"> <!--- access, mysql, postgresql, mssql, oracle --->


<!--- ######## END OF CONFIGURATION VARIABLES ####### --->





<!--- Check CFML Server Compatibility --->
<cfif lcase(server.coldfusion.productname) contains "coldfusion">
	<cfset variables.serverType = "coldfusion">
<cfelseif lcase(server.coldfusion.productname) contains "bluedragon">
	<cfset variables.serverType = "bluedragon">
<cfelse>
	<cfset varables.serverType = "other">
</cfif>
<cfif variables.serverType is "other" or ( ListGetAt(server.coldfusion.productversion,1) lt 6 and ListGetAt(server.coldfusion.productversion,2) lt 1) >
	<cfsetting enablecfoutputonly="yes">
	<H1>ERROR</H1>
	BlogCFM works with CFMX 6.1 or higher, and Bluedragon 6.1 or higher.
	<cfabort>
</cfif>
<cfif directoryExists(GetDirectoryFromPath(getCurrentTemplatePath()) & "setup")>
	<cfoutput>
	<H1>Security Alert</H1>
	Please delete your setup directory.
	<Cfabort>
	</cfoutput>
</cfif>

<cftry>
	<cfinclude template="#variables.mapping#udf.cfm">
	<cfcatch type="Any">
		<cfoutput>
		<H1>Configuration Error!</H1>
		<p>An error occured trying to include the udf.cfm file via the configured mapping.
		This probably means the mapping is either not set up in the Coldfusion/Bluedragon Administrator,
		or it's not configured properly in the Application.cfm.  It may also mean that the udf.cfm file
		cannot be parsed properly.  See the error details below.
		</p>
		<cfdump var="#cfcatch#">
		</cfoutput>
		<cfabort>
	</cfcatch>
</cftry>
<cfscript>
	if (variables.reloadCFC OR NOT isDefined("application.blogcfm")
		or isDefined("url.init") ) {
		application.blogcfm = createObject("component","cfcs.blogcfm");
		application.blogcfm.init(
			getDirectoryFromPath(getCurrentTemplatePath()),
			variables.dsn,
			variables.mapping,
			variables.dbtype );
	}
	variables.blogConfig = application.blogcfm.getBlogConfig(variables.blog_id);
	writeOutput("<!-- BlogCFM version #application.blogcfm.version# www.blogcfm.org -->#Chr(10)#");
	request.pageName = getFileFromPath(GetBaseTemplatePath());

	param("PAGE_TITLE","");
	param("META_DESC","");
	param("META_KEYS","");

	if (cgi.path_info eq "")
	{
		request.path_info = cgi.script_name; /* APACHE */
	} else {
		request.path_info = cgi.path_info; /* IIS */
	}
	request.redirect = request.path_info;
	if (cgi.query_string neq "")
	{
		request.redirect = request.redirect & "?" & cgi.query_string;
	}
	request.redirect = replace(request.redirect,"//","/","ALL");
	
	if (isDefined("url.redirect")) {
		url.redirect = replaceNoCase(url.redirect,"logout=1","","ALL");
		session.redirect = url.redirect;
	} else if (isDefined("form.redirect")) {
		form.redirect = replaceNoCase(form.redirect,"logout=1","","ALL");
		session.redirect = form.redirect;
	}
	if (isDefined("logout")) {
		cookie.session_key = "";
		setCookie("session_key", "","True", "True");
		variables.session_key = "";
	} else if (isDefined("authorize")) {
		param("FORM.UNAME");
		param("FORM.PWORD");
		results = application.blogcfm.authUser(variables.blog_id,form.uname, form.pword, CGI.REMOTE_ADDR);
		if (results.errorCode is 0)
		{
			variables.userInfo = results.userInfo;
			variables.session_key = results.session_key;
			if (isDefined("persistentCookie")) {
				setCookie("session_key", variables.session_key,"true");
			} else {
				setCookie("session_key", variables.session_key,"false");
			}
			if (existingRedirect() neq "")
			{
				redirectUrl = existingRedirect();
				session.redirect = "";
				redirectUrl = replaceNoCase(redirectUrl,"&comment_id=","##comment","ALL");
				metalocation("Login Successful!", redirectUrl);
			} else {
				metalocation("Login Successful!", "index.cfm?NOREDIRECT");
			}
		} else {
			variables.loginError = results.errorMessage;
		}
	} else if (isDefined("register")) {
		param("FORM.UNAME");
		param("FORM.PWORD");
		param("FORM.PWORD_VERIFY");
		param("FORM.EMAIL");
		param("FORM.EMAIL_VERIFY");
		param("FORM.FLAG_NOTIFY");
		param("FORM.WEBSITE");
		if (FORM.FLAG_NOTIFY neq 1) { FORM.FLAG_NOTIFY = 0; }
		FORM = Application.blogcfm.trimElements(FORM);
		if (
			isDefined("form.captchaKey") 
			and 
			isDefined("form.captchaValue") 
			AND 
			hash(trim(ucase(form.captchaValue))) neq form.captchaKey
			)
		{
			variables.registerError = "Invalid anti-spam key.  Please try again.";
		} else if (FORM.UNAME eq "" or FORM.EMAIL eq "" or FORM.PWORD eq "")
		{
			variables.registerError = "You did not complete all of the required fields.";
		} else if (FORM.PWORD neq FORM.PWORD_VERIFY) {
			variables.registerError = "The passwords that you entered did not match.";
		} else if (lcase(FORM.EMAIL) neq lcase(FORM.EMAIL_VERIFY) ) {
			variables.registerError = "The email addresses that you entered did not match.";
		} else {
			results = application.blogcfm.createUser(variables.blog_id,FORM.UNAME, FORM.PWORD, FORM.EMAIL, FORM.WEBSITE, FORM.FLAG_NOTIFY, CGI.REMOTE_ADDR);
			if (results.errorCode gt 0)
			{
				variables.registerError = results.errorMessage;
			} else {
				authresults = application.blogcfm.authCookie(variables.blog_id,results.session_key, CGI.REMOTE_ADDR);
				if (authresults.errorCode is 0)
				{
					variables.userInfo = authresults.userInfo;
					variables.session_key = authresults.session_key;
					setCookie("session_key", variables.session_key, "false");
					if (existingRedirect() neq "")
					{
						redirectUrl = existingRedirect();
						session.redirect = "";
						redirectUrl = replaceNoCase(redirectUrl,"&comment_id=","##comment","ALL");
						metalocation("Registration Successful!", redirectUrl);
					} else {
						metalocation("Registration Successful!", "index.cfm?NOREDIRECT");
					}
				}	
			}
		}
	
	} else if ( isDefined("cookie.session_key") OR isDefined("url.session_key") ) {
		if (isDefined("url.session_key")) {
			variables.session_key = url.session_key;
		} else if (isDefined("cookie.session_key")) {
			variables.session_key = cookie.session_key;
		}
		authresults = application.blogcfm.authCookie(variables.blog_id,variables.session_key, CGI.REMOTE_ADDR);
		if (authresults.errorCode is 0)
		{
			variables.userInfo = authresults.userInfo;
			variables.session_key = authresults.session_key;
			if (not isDefined("cookie.session_key")) {
				setCookie("session_key", variables.session_key, "false");
			}
		}	
	}
	if (
		((REFindNoCase("[\\/]admin[\\/]cffm[\\/]",GetBaseTemplatePath()) gt 0) or (ReFindNoCase("[\\/]FCKeditor[\\/]",GetBaseTemplatePath()) gt 0))
		AND
		(not isDefined("variables.userInfo") OR variables.userInfo.FLAG_ADMIN IS 0)
	   )
	{
		location("#variables.blogConfig.webRoot#/access_denied.cfm");
	}
	else if ( 
		(REFindNoCase("[\\/]admin[\\/]",GetBaseTemplatePath()) gt 0 OR REFindNoCase("^admin\_",request.pagename) is 1)
		AND 
		(not isDefined("variables.userInfo") OR variables.userInfo.FLAG_ADMIN IS 0)
		
		)
	{
		location("#variables.blogConfig.webRoot#/login.cfm?REDIRECT=#urlEncodedFormat(request.redirect)#");
	}
</cfscript>
<cfparam name="session.showDate" default="#now()#">
<cfif variables.blogConfig.recordCount is 0>
	<cfoutput>
	<h1>Invalid Blog ID</h1>
	The blog_id specified in the application.cfm file, which is currently "#variables.blog_id#"
	does not exist in the configuration table.  Perhaps you haven't run the setup script yet.
	<p>
	Please refer to the documentation.
	</cfoutput>
	<cfabort>
</cfif>

<!--- CHECK FOR CFIDE mapping --->
<CFSETTING ENABLECFOUTPUTONLY="NO">
