<?php
/*
#===========================================================================
#= Script : Blog Mod
#= Version: 0.2.2
#= Author : Ryan Thian
#= Email  : ryan@bloggingdoctor.com
#= Website: http://www.bloggingdoctor.com
#===========================================================================
#= Copyright (c) 2003 Ryan Thian
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG MOD.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG MOD files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
#= Blog Mod is a modified version of Blog
#= Version: 1.51 beta
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Website: http://www.pluggedout.com/projects_blog.php
#= Support: http://www.pluggedout.com/forums/viewforum.php?f=5
#===========================================================================
*/

// Function    : html_gap
// Description : Returns the html to represent a 5 pixel vertical gap on the page
// Arguments   : None
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_gap(){
	$html = "<table border='0' cellspacing='0' cellpadding='0'><tr><td><img src='images/pix5.gif' width='5' height='5'></td></tr></table>\n";
	return $html;
}


// Function	: html_pageheader
// Description	: Returns the html to represent an html page header (everything as far as body)
// Arguments	: $site_title - Page Title
// Returns	: html data
// Author		: Jonathan Beckett
// Modified by	: Ryan Thian
// Last Change	: 2004-01-02
// Blog Mod ver.	: 0.2.1
function html_pageheader() {

	global $site_title;
	global $site_desc;
	global $site_keywords;

	$html = "<html>\n"
		."<head>\n"
		."<title>".$site_title."</title>\n"
		."<META NAME='DESCRIPTION' CONTENT='".$site_desc."'><META NAME='KEYWORDS' CONTENT='".$site_keywords."'>\n"
		."<link rel='stylesheet' href='style.css'>\n"
		."</head>\n";
	return $html;
}


// Function    : html_pagefooter
// Description : Returns the html to represent the end of the html page
// Arguments   : None
// Returns     : html data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function html_pagefooter(){
	$html = "</body>\n"
		."</html>\n";
	return $html;
}


// Function	: html_pagebody
// Description	: Returns the html to represent the body tag of the html pages
// Arguments	: None
// Returns	: html data
// Author		: Jonathan Beckett
// Last Change	: 2003-11-11
// Modified by	: Ryan Thian
// Last Change	: 2004-01-02
// Blog Mod ver.	: 0.2.1
function html_pagebody() {

	$html = "<body>\n";
	return $html;
}


// Function	: html_pagestart
// Description	: Returns the html to insert at the start of every page (typically for a banner)
// Arguments	: None
// Returns	: html data
// Author		: Jonathan Beckett
// Modified by	: Ryan Thian
// Last Change	: 2003-12-29
function html_pagestart(){

	global $banner_title;
	global $banner_subtext;

	$html = "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n"
		."  <tr><td class='body'><span class='large'>&nbsp;".$banner_title."</span></td></tr>\n"
		."  <tr><td class='title'><span class='small'>&nbsp;&nbsp;".$banner_subtext."</span></td></tr>\n"
		."  <tr><td class='background' background='images/shadow.gif'><img src='images/pix1.gif' height='1' width='1'></td></tr>\n"
		."</table>\n";

	return $html;
}


// Function	: html_pageend
// Description	: Returns the html to insert at the end of every page
//		  (typically for terms or a disclaimer)
// Arguments	: None
// Returns	: html data
// Author		: Jonathan Beckett
// Modified by	: Ryan Thian
// Last Change	: 2003-12-29
function html_pageend(){

	global $site_copyright;
	global $site_disclaimer;

	$html = "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n"
		."  <tr><td class='background' background='images/shadow.gif'><img src='images/pix1.gif' height='1' width='1'></td></tr>\n"
		."  <tr><td class='body' align='center'><span class='small'>&nbsp;&nbsp;".$site_disclaimer."</span></td></tr>\n"
		."  <tr><td class='title' align='center'><span class='small'>&nbsp;".$site_copyright."</span></td></tr>\n"
		."</table>\n";

	return $html;

	$html = "";
	return $html;
}


// Function	: html_calendar
// Description	: Returns the html to represent the calendar.
// Arguments	: $month - Month of the year (01 to 12)
//               	  $year  - Year (yyyy)
// Returns 	: html data
// Author		: Jonathan Beckett
// Last Change	: 2003-11-11
// Modified by	: Ryan Thian
// Last Change	: 2004-01-04
// Blog Mod ver.	: 0.2.2
function html_calendar($month,$year) {

	global $months;
	global $days;

	global $month;
	global $year;
	global $day;

	define ('ADAY', (60*60*24));

	// make arrays of values representing the first of the month
	$datearray = getdate(mktime(0,0,0,$month,1,$year));
	$start = mktime(0,0,0,$month,1,$year);

	$firstdayarray = getdate($start);

	// pre-populate an array with the last blogs for the month being shown
	// (add them to the array on the index of the day of the month)
	$con = db_connect();
	$sql = "SELECT *,DAYOFMONTH(dEntryDate) AS day,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE MONTH(dEntryDate)=".sql_quote($month)." AND YEAR(dEntryDate)=".sql_quote($year)." ORDER BY nIdCode;";
	$result = mysql_query($sql,$con);
	if ($result!=false) {
		while ($row = @ mysql_fetch_array($result)){
			$aBlogs[$row["day"]]=$row;
		}
	} else {
		print "<li>Problem with SQL<br>[".$sql."]";
	}

	// work out the URLs for previous and next buttons
	// default
	$prev_month = $month - 1;
	$prev_year = $year;
	$next_month = $month + 1;
	$next_year = $year;

	// handle exceptions
	// end of year
	if ($month==12) {
		$prev_month = $month - 1;
		$prev_year = $year;
		$next_month = 1;
		$next_year = $year + 1;
	}
	// start of year
	if ($month==1) {
		$prev_month = 12;
		$prev_year = $year - 1;
		$next_month = $month + 1;
		$next_year = $year;
	}
	$url_next = $_SERVER["PHP_SELF"]."?month=".$next_month."&year=".$next_year;
	$url_prev = $_SERVER["PHP_SELF"]."?month=".$prev_month."&year=".$prev_year;


	// Create the start of the Calendar Table
	$html = "<table class='general' cellpadding='1' cellspacing='1'>\n";

	// Create the row with the previous button, month name and next button
	$html .= "<tr><td colspan='7' class='title'>\n"
		."  <table width='100%' border='0' cellspacing='0' cellpadding='0'><tr>\n"
		."    <td align='center'><span class='normal'><a class='link' href='".form_url($url_prev)."'>&laquo;</a></span></td>\n"
		."    <td align='center'><span class='normal'><a class='link' href='".form_url($_SERVER["PHP_SELF"]."?year=".$year."&month=".$month)."'>".$datearray["month"]." ".$year."</a></span></td>\n"
		."    <td align='center'><span class='normal'><a class='link' href='".form_url($url_next)."'>&raquo;</a></span></td>\n"
		."  </tr></table>\n"
		."</td></tr>\n";

	// Create the row with Day Headings
	$html .= "<tr>\n";
	foreach($days as $day)
	{
		$html .= "  <td align='center' width='20' class='title'><span class='small'>".$day."</span></td>\n";
	}
	$html .= "</tr>\n";

	// Create the rows of days
	for( $count=0;$count<(6*7);$count++)
	{
		$dayarray = getdate($start);
		if((($count) % 7) == 0) {
			if($dayarray['mon'] != $datearray['mon']) break;
			$html .= "</tr>\n<tr>\n";
		}

		if($count < $firstdayarray['wday'] || $dayarray['mon'] != $month) {
			$html .= "<td class='background'><span class='small'>&nbsp;</span></td>\n";
		} else {
			// if there are entries for the day make it a link and change the color
			$d = $dayarray["mday"];
			if ($aBlogs[$d]["cBody"]!="") {
				$date_url = form_url($_SERVER["PHP_SELF"]."?year=".$dayarray["year"]."&month=".$dayarray["mon"]."&day=".$dayarray["mday"]);
				$html .= "<td align='center' class='title'><span class='small'><a class='link' href='".$date_url."'>".$dayarray[mday]."</a></span></td>\n";
			} else {
				$html .= "<td align='center' class='body'><span class='small'>".$dayarray[mday]."</span></td>\n";
			}
			$start += ADAY;
			// check that day has moved on
			$testday = getdate($start);
			if ($testday["yday"]==$dayarray["yday"]){
				$start += (ADAY/2);
			}
		}
	}

	// end the calendar table
	$html .= "</tr>\n</table>\n";

	$html .= "<table border='0' cellspacing='0' cellpadding='0'><tr><td><img src='images/pix5.gif' width='5' height='5'></td></tr></table>\n";

	$html .= "<table class='general' cellspacing='1' cellpadding='1'>\n"
		."  <tr><td class='title' align='center'><span class='small'><b>Navigation Panel</b></span></td></tr>\n"
		."  <tr><td class='background' align='center'><span class='small'>";
	
	$html .= "<p><form method='POST' action='".form_url("blog_exec.php?action=navigate")."'>\n"
		."<select name=\"month\">"
		."<option value=\"".$month."\" selected>".$datearray["month"]."</option>"
		."<option value=\"\"></option>"
		."<option value=\"1\">January</option>"
		."<option value=\"2\">February</option>"
		."<option value=\"3\">March</option>"
		."<option value=\"4\">April</option>"
		."<option value=\"5\">May</option>"
		."<option value=\"6\">June</option>"
		."<option value=\"7\">July</option>"
		."<option value=\"8\">August</option>"
		."<option value=\"9\">September</option>"
		."<option value=\"10\">October</option>"
		."<option value=\"11\">November</option>"
		."<option value=\"12\">December</option>"
		."</select>"
		."&nbsp;&nbsp;<select name=\"year\">"
		."<option value=\"".$year."\" selected>".$datearray["year"]."</option>"
		."<option value=\"\"></option>"
		."<option value=\"2003\">2003</option>"
		."<option value=\"2004\">2004</option>"
		."</select>";

	$html .= "<br><center><input type='submit' value='View'></center></form>\n"
		."</span></td></tr></table>\n";

	return $html;
}


// Function	: html_bloglist
// Description	: Returns the html to represent a list of blog entries.
// Arguments	: $list_rows - array of associative arrays containing database rows from the db
//               	  $blogid    - the selected blogid (if used)
// Returns	: html data
// Author		: Jonathan Beckett
// Modified by	: Ryan Thian
// Last Change	: 2004-01-02
// Blog Mod ver.	: 0.2.1
function html_bloglist($list_rows,$blogid){

	global $viewmode;
	global $blogid;
	global $viewcomments;
	global $pref_hits;

	global $month;
	global $year;
	global $day;
	global $months;

	$html = "<table class='general' cellspacing='1' cellpadding='1'>\n"
		."  <tr><td class='title' align='center'><span class='small'><b>";

	$search = $_GET["search"];
	if ($search) {
		$searchhtml = "&search=".$search;
		if ($list_rows[1]["nIdCode"]!=""){
			$html .= "Search for \"".$search."\"</b><br><i>Result - ".count($list_rows)." blog(s)</span></td></tr>\n";
		} else {
			$html .= "Search for \"".$search."\"</b><br><i>No Blogs Found</span></td></tr>\n";
		}
	} else {
		if ($_GET["month"]!="" || $_GET["year"]!="" || $_GET["day"]!="") {
			if ($_GET["month"]!="" && $_GET["year"]!="") {
				if ($_GET["day"]!="") {
					$html .= "Blogs for ".$_GET["year"]."-".$_GET["month"]."-".$_GET["day"];
				} else {
					$html .= "Blogs for ".$months[$_GET["month"]-1].", ".$_GET["year"];
				}
			} else {
				$html .= "Blogs for ".$months[$month-1].", ".$year;
			}
		} else {
			$html .= "Blogs for ".$months[$month-1].", ".$year;
		}
		$html .= "</b></span></td></tr>\n";
	}

	if ($list_rows[1]["nIdCode"]!=""){

	for ($i=1;$i<=count($list_rows);$i++){

		// put the admin html in if required
		if ($_SESSION["userid"]!=""){
			$html_admin = "&nbsp;[<a class='link' href='".form_url("admin.php?action=edit_blog&blogid=".$list_rows[$i]["nIdCode"])."'>Edit</a>]&nbsp;[<a class='link' href='".form_url("admin.php?action=remove_blog&blogid=".$list_rows[$i]["nIdCode"])."'>Remove</a>]";
		} else {
			$html_admin = "";
		}

		$html .= "<tr><td class='background'>\n";

		if ($viewmode=="single") {
			if (($list_rows[$i]["nIdCode"]==$blogid) && ($blogid != "")){
				$html .= "<table border='0' cellspacing='1' width='100%'><tr><td><table width='100%' cellspacing='0'><tr><td class='title'><span class='list_title'><b>".stripslashes($list_rows[$i]["cTitle"])."</b></span></td></tr><tr><td class='body'><span class='list_date'>Written on ".$list_rows[$i]["dEntryDate"];

				if ($pref_hits=="yes"){
					$html .= "<br>".$list_rows[$i]["nViews"]." views";
				}

				if ($viewcomments=="yes"){
					if ($pref_hits=="yes"){
						$html .= ", ";
					} else {
						$html .= "<br>";
					}
					$html .= $list_rows[$i]["nComments"]." comments";
				}
				$html .= "$html_admin</span></td></tr></table></td></tr></table>";

			} else {

				$html .= "<table border='0' cellspacing='1' width='100%'><tr><td><table width='100%' cellspacing='0'><tr><td class='title'><span class='list_title'><a class='link' href='".form_url("index.php?blogid=".$list_rows[$i]["nIdCode"]).$searchhtml;

				if ($_GET["year"]!=""){
					$html .= "&year=".$_GET["year"];
				}

				if ($_GET["month"]!=""){
					$html .= "&month=".$_GET["month"];
				}

				if ($_GET["day"]!=""){
					$html .= "&day=".$_GET["day"];
				}

				$html .= "'>".stripslashes($list_rows[$i]["cTitle"])."</a></span></td></tr><tr><td class='body'><span class='list_date'>Written on ".$list_rows[$i]["dEntryDate"];

				if ($pref_hits=="yes"){
					$html .= "<br>".$list_rows[$i]["nViews"]." views";
				}

				if ($viewcomments=="yes"){
					if ($pref_hits=="yes"){
						$html .= ", ";
					} else {
						$html .= "<br>";
					}
					$html .= $list_rows[$i]["nComments"]." comments";
				}

				$html .= "$html_admin</span></td></tr></table></td></tr></table>";

			}
		} else {
			$html .= "<table border='0' cellspacing='1' width='100%'><tr><td><table width='100%' cellspacing='0'><tr><td class='title'><span class='list_title'><a class='link' href='index.php?blogid=".$list_rows[$i]["nIdCode"].$searchhtml;

			if ($_GET["year"]!=""){
				$html .= "&year=".$_GET["year"];
			}

			if ($_GET["month"]!=""){
				$html .= "&month=".$_GET["month"];
			}

			if ($_GET["day"]!=""){
				$html .= "&day=".$_GET["day"];
			}

			$html .= "#".$list_rows[$i]["nIdCode"];
			$html .= "'>".stripslashes($list_rows[$i]["cTitle"])."</a></span></td></tr><tr><td class='body'><span class='list_date'>Written on ".$list_rows[$i]["dEntryDate"];

			if ($pref_hits=="yes"){
				$html .= "<br>".$list_rows[$i]["nViews"]." views";
			}

			if ($viewcomments=="yes"){
				if ($pref_hits=="yes"){
					$html .= ", ";
				} else {
					$html .= "<br>";
				}
				$html .= $list_rows[$i]["nComments"]." comments";
			}

			$html .= "$html_admin</span></td></tr></table></td></tr></table>";

		}
		$html .= "</td></tr>\n";

	}

	} else {
		if (!$search) {
			// no blogs to list
			$html .= "<tr><td class='background' align='center'><span class='small'>No Blogs to List</span></td></tr>\n";
		}
	}

	$html .= "</table>\n";

	return $html;
}


// Function	: html_blogview
// Description	: Returns the html to represent the blog bodies being shown
// Arguments	: $view_rows         - array of associative arrays containing blogs from the db
//               	  $view_comment_rows - array of array of associative arrays containing comments on each of the blogs in the view_rows array
// Returns	: html data
// Author		: Jonathan Beckett
// Modified by	: Ryan Thian
// Last Change	: 2004-01-02
// Blog Mod ver.	: 0.2.1
function html_blogview($view_rows,$view_comment_rows){

	// pull in globals
	global $viewmode;
	global $viewcomments;
	global $pref_hits;

	$search = $_GET["search"];

	// start the table containing the blog view(s)
	$html = "<table class='general' cellspacing='1' cellpadding='1'>\n";

	// loop for the number to show
	if ($viewmode=="single"){
		$view_max = 1;
	} else {
		$view_max = count($view_rows);
	}

	if ($view_rows[1]["nIdCode"]!=""){

		for ($i=1;$i<=$view_max;$i++) {

			// get date info out of the date field
			$view_year = substr($view_rows[$i]["dEntryDate"],0,4);
			$view_month = substr($view_rows[$i]["dEntryDate"],5,2);
			$view_day = substr($view_rows[$i]["dEntryDate"],8,2);
			$view_time = substr($view_rows[$i]["dEntryDate"],11,5);

			$view_datearray = getdate(mktime(0,0,0,$view_month,$view_day,$view_year));

			$view_monthname = $view_datearray["month"];

			// create the date and title table row
			$html .= "<tr>\n";

			if (($pref_hits=="yes") || ($viewcomments=="yes")){
				$html .= "<td class='title' rowspan='2'>";
			} else {
				$html .= "<td class='title' rowspan='1'>";
			}


			$html .= "<span class='large'>&nbsp;".$view_day."&nbsp;".$view_monthname.",&nbsp;".$view_time."&nbsp;</span></td>\n"
				."<td class='title' width='100%' align='center'><span class='normal'><b><a name='".$view_rows[$i]["nIdCode"]."'>".stripslashes($view_rows[$i]["cTitle"])."</a></b></span>\n";

			if ($_SESSION["userid"]!=""){
				$html_admin = "<span class='small'>&nbsp;&nbsp;&nbsp;[<a class='link' href='".form_url("admin.php?action=edit_blog&blogid=".$view_rows[$i]["nIdCode"])."'>Edit</a>]&nbsp;[<a class='link' href='".form_url("admin.php?action=remove_blog&blogid=".$view_rows[$i]["nIdCode"])."'>Remove</a>]</span>";
			} else {
				$html_admin = "";
			}

			$html .= $html_admin."</td></tr>\n";

			// create the date, and stats row
			if ($viewmode=="single"){
				if ($viewcomments=="yes"){
					if ($pref_hits=="yes"){
						$comments = ", ";
					}
					$comments = $view_rows[$i]["nComments"]." comments";
				}
			} else {

				if ($viewcomments=="yes"){
					if ($pref_hits=="yes"){
						$comments = ", ";
					}
					$comments = "<a href='#".$view_rows[$i]["nIdCode"]."' class='link' onclick=\"window.open('".form_url("comment_view.php?blogid=".$view_rows[$i]["nIdCode"]."&i=".$i);

					if ($_GET["year"]!=""){
						$comments .= "&year=".$_GET["year"];
					}

					if ($_GET["month"]!=""){
						$comments .= "&month=".$_GET["month"];
					}

					if ($_GET["day"]!=""){
						$comments .= "&day=".$_GET["day"];
					}

					$comments .= "','Comments','resizable=yes,menubar=no,scrollbars=yes,toolbar=no,fullscreen=no,width=500,height=500')\">".$view_rows[$i]["nComments"]." comments</a>";
				}
			}

			if (($pref_hits=="yes") || ($viewcomments=="yes")){
				$html .= "  <tr><td colspan='2' class='body' align='center'><span class='small'>";
			}

			if ($pref_hits=="yes"){
				$html .= $view_rows[$i]["nViews"]." views";
			}

			if ($viewcomments=="yes"){
				if ($pref_hits=="yes"){
					$html .= ", ";
				}
				$html .= $comments;
			}

			$html .= "</span></td></tr>\n";

			// create the bodytext table row
			$html .= "  <tr><td colspan='2' class='background'><table border='0' width='100%' cellpadding='5'><tr><td><p class='blog_title'>".stripslashes($view_rows[$i]["cTitle"])."</p><p class='blog_body'>".clean_text(stripslashes($view_rows[$i]["cBody"]))."</p></td></tr></table></td></tr>\n";

			// only show comments in single mode
			if ($viewmode=="single" && $viewcomments=="yes"){

				// start the cell containing comments
				$html .= "<tr><td colspan='2' class='title'>\n";

				$html .= html_commentsview($i);

				// end the cell containing comments or link to comments
				$html .= "</td></tr>\n";

			} else {
				// in multiple mode - therefore show link to view the comments in a seperate page...

			}

		}
	} else {
		// there are no blogs to show
		if (!$search) {
			$html .= "  <tr><td colspan='2' class='background'><span class='normal'>There are no blogs for this month yet. Check other months via the navigation controls on the calendar.</span></td></tr>\n";
		} else {
			$html .= "  <tr><td colspan='2' class='background'><span class='normal'>There are no blogs containing the words \"".$search."\".</span></td></tr>\n";
		}
	}

	// end the table containing the blogs
	$html .="</table>\n";

	return $html;

}


// Function	: html_commentsview
// Description	: Returns the html to represent the pop-up comments list used in multiple mode
// Arguments	: $i - index of a blog in the view array of arrays
// Returns	: html data
// Author		: Jonathan Beckett
// Modified by	: Ryan Thian
// Last Change	: 2004-01-02
// Blog Mod ver.	: 0.2.1
function html_commentsview($i){

	global $view_rows;
	global $view_comment_rows;
	global $viewmode;
	global $comment_password;

	// start the comments table
	$html .= "<table width='100%' border='0' cellspacing='1' cellpadding='2'>\n";

	// loop through the comments array
	for ($j=1;$j<=$view_rows[$i]["nComments"];$j++) {

		// put the admin html in if required
		if ($_SESSION["userid"]!=""){
			if ($viewmode=="single"){
				$html_admin = "&nbsp;&nbsp;&nbsp;[<a class='link' href='".form_url("admin.php?action=edit_blog_comment&blogidc=".$view_comment_rows[$i][$j]["nIdCode"])."'>Edit</a>]&nbsp;[<a class='link' href='".form_url("admin.php?action=remove_blog_comment&blogidc=".$view_comment_rows[$i][$j]["nIdCode"])."'>Remove</a>]";
			} else {
				$html_admin = "&nbsp;&nbsp;&nbsp;[<a class='link' href='".form_url("admin.php?action=edit_blog_comment&blogidc=".$view_comment_rows[$i][$j]["nIdCode"]."&i=".$i)."'>Edit</a>]&nbsp;[<a class='link' href='".form_url("admin.php?action=remove_blog_comment&blogidc=".$view_comment_rows[$i][$j]["nIdCode"]."&i=".$i)."'>Remove</a>]";
			}
		} else {
			$html_admin = "";
		}
		if ($view_comment_rows[$i][$j]["cURL"]!="") {
			$pos = strpos($view_comment_rows[$i][$j]["cURL"], "http://");
			if ($pos === false) {
				$url = "[<a class='link' href='http://".$view_comment_rows[$i][$j]["cURL"]."' target='_blank'>Web</a>]";
			} else {
				$url = "[<a class='link' href='".$view_comment_rows[$i][$j]["cURL"]."' target='_blank'>Web</a>]";
			}
		} else {
			$url = "";
		}
		if (is_email($view_comment_rows[$i][$j]["cEMail"])) {
			$email = "[<a class='link' href='mailto:".$view_comment_rows[$i][$j]["cEMail"]."'>E-Mail</a>]";
		} else {
			$email = "";
		}


		// create comment header row
		$html .= "<tr><td class='title'><span class='small'>".stripslashes($view_comment_rows[$i][$j]["cUsername"])." wrote...&nbsp;".$email."&nbsp;".$url.$html_admin."</span></td></tr>\n";
		// create comment bodytext row
		$html .= "<tr><td class='body'><span class='comment_body'>".clean_text(stripslashes($view_comment_rows[$i][$j]["cComment"]))."</span></td></tr>\n";
	}

	// end the comments table
	$html .= "</table>\n";

	if ($viewcomments = "yes") {
		if ($_GET["comment"] == "1") {
			// comment entry form
			$html .= "<table width='100%' border='0' cellpadding='5' cellspacing='0'><tr><td>\n"
			."<form method='POST' action='".form_url("blog_exec.php?action=add_comment")."'>\n"
			."  <input type='hidden' name='blogid' value='".$view_rows[$i]["nIdCode"]."'>\n"
			."  <table cellspacing='1' cellpadding='2' class='comment' align='center'>\n"
			."    <tr><td colspan='2' class='title' align='center'><span class='small'><b>Add Comment Form</b></span></td></tr>\n"
			."    <tr><td class='title'><span class='small'>Name</span></td><td class='body'><input type='text' name='username' size='70' class='text'></td></tr>\n"
			."    <tr><td class='title'><span class='small'>E-Mail</span></td><td class='body'><input type='text' name='email' size='70' class='text'></td></tr>\n"
			."    <tr><td class='title'><span class='small'>URL</span></td><td class='body'><input type='text' name='url' size='70' class='text'></td></tr>\n"
			."    <tr><td class='title'><span class='small'>Comment</span></td><td class='body'><textarea name='comment' cols='70' rows='3' class='text'></textarea></td></tr>\n";

			if ($comment_password != "") {
				$html .= "    <tr><td class='title'><span class='small'>Password</span></td><td class='body'><input type='text' name='comment_pass' size='70' class='text'></td></tr>\n";
			}
			$html .= "    <tr><td class='title' colspan='2' align='right'><center><input type='submit' value='Add Comment' class='button'></center></td></tr>\n"
			."  </table>\n"
			."</form>\n"
			."</td></tr></table>\n";
		} else {
			$query_string = $_SERVER["QUERY_STRING"];
			if (!$query_string) {
				$html .= "<center><span class='list_title'><a class='link' href='".form_url($_SERVER[REQUEST_URI]."?comment=1")."'>Add Comments</a></span></center>\n";
			} else {
				$html .= "<center><span class='list_title'><a class='link' href='".form_url($_SERVER[REQUEST_URI]."&comment=1")."'>Add Comments</a></span></center>\n";
			}
		}
	}
	return $html;
}


?>
