<!---

	This component builds on the work of Andrew Duckett who created the Facebook Rest Client Component.
	http://www.nearpersonal.com/code/
	
	This starter kit for ColdFusion FaceBook Apps builds on the work of Dominic Watson and Andrew Duckett
	
	Please submit any code you have found useful to Dominic or myself.

   	Created by Dominic Watson, watson.dominic@googlemail.com, http://fusion.dominicwatson.co.uk/
	Updated for new Facebook by Gavin Vincent, gavyg03@gmail.com, http://www.facehumor.com, http://apps.facebook.com/humorous/
	
--->
<cfcomponent displayname="Facebook FBML Helper component" output="false">
	<cffunction name="init" access="public" returntype="FacebookFBMLClient" output="false">
		<cfargument name="apiKey" type="string" required="yes" />
		<cfargument name="secret" type="string" required="yes" />
		<cfargument name="url" type="string" required="yes" />
		<cfargument name="callbackURL" type="string" required="yes">
		<!--- changed from calling the old server to new server
			  allows for new facebook features --->
		<cfargument name="server" type="string" required="no" default="http://api.new.facebook.com/restserver.php" />
		<cfargument name="apiVersion" type="string" required="no" default="1.0" />
		<cfargument name="format" type="string" required="no" default="xml" />

		<cfscript>
			variables._apiKey = arguments.apiKey;
			variables._secret = arguments.secret;
			variables._url = arguments.url;
			variables._callbackURL = arguments.callbackURL;
			variables._server = arguments.server;
			variables._apiVersion = arguments.apiVersion;
			variables._format = arguments.format;		
			
			return this;
		</cfscript>
	</cffunction>
<!--------------------------------------- authentication --------------------------------------->
	<cffunction name="AuthenticatePost" access="public" output="true" returntype="boolean">
		<cfargument name="st_postData" type="struct" required="true" hint="Structure containing post data">
		<cfargument name="s_sigField" type="string" required="false" default="SIG_FB" hint="The name of the form field containing the Facebook signature. Facebook sends this as FB_SIG but this causes Coldfusion to auto validate, copy the data to a new field and blanking the original fixes this. Pass the name of the new field in here.">
		<cfscript>
			var a_formFields = StructKeyArray(arguments.st_postData);
			var st_args = StructNew();
			var i = 0;
			var s_field = "";
			
			// if post does not have an authentication signature...
			if(not StructKeyExists(arguments.st_postData, arguments.s_sigField))
				return false;
			
			// loop through the facebook post fields and put them in a new structure
			// 'FB_SIG_' needs removing from their names in accordance with the Facebook authentication instructions
			for(i=1; i LTE a_formFields.size(); i=i+1)
			{
				s_field = a_formFields[i];
				if(s_field NEQ arguments.s_sigField and Compare(Left(s_field,7),'FB_SIG_') EQ 0){
					st_args[Replace(s_field,'FB_SIG_','')] = arguments.st_postData[s_field];
				}
			}
			
			// compare the supplied signature with that generated by the other post variables
			if(Compare(st_postData[arguments.s_sigField], generateSignature(st_args)))
				return false;
			
			return true;			
		</cfscript>	
	</cffunction>
<!--------------------------------------- utility methods --------------------------------------->
	<cffunction name="callMethodGet" access="public" output="false" returntype="any" hint="I act as a raw interface to the Facebook API and return the xml string response from the facebook server.">
		<cfargument name="method" type="string" required="yes" />
		<cfargument name="params" type="struct" required="no" default="#StructNew()#" />
		<cfargument name="filepath" type="string" required="no" />
		
		<cfset var result = StructNew() />
		<cfset var key = "">
		<cfset this._tickCount = TimeFormat(now(), "hh:mm:ss") >
		
		<!--- add params to the param struct --->
		<cfset StructInsert(arguments.params, "method", arguments.method) />
		<cfset StructInsert(arguments.params, "api_key", variables._apiKey) />
		<cfset StructInsert(arguments.params, "v", variables._apiVersion) />
		<cfset StructInsert(arguments.params, "call_id", this._tickCount) />
		
		<!--- add the signature [sig] --->
		<cfset StructInsert(arguments.params, "sig", generateSignature(arguments.params)) />
		
		<cfhttp url="#variables._server#" method="get" charset="utf-8" redirect="no" throwOnError="yes" resolveurl="1">
			<cfloop collection="#arguments.params#" item="key">
				<cfhttpparam name="#key#" value="#arguments.params[key]#" type="url" />
				<!--- <cfdump var="#key#=#arguments.params[key]#"> --->
			</cfloop>
			<cfif StructKeyExists(arguments, "filepath") and FileExists(arguments.filepath)>
				<cfhttpparam type="file" name="file" file="#arguments.filepath#" />
			</cfif>
			<!--- <cfabort> --->
		</cfhttp>
		
		<cfreturn cfhttp.FileContent />
	</cffunction>
	
	<cffunction name="callMethodPost" access="public" output="false" returntype="any" hint="I act as a raw interface to the Facebook API and return the xml string response from the facebook server.">
		<cfargument name="method" type="string" required="yes" />
		<cfargument name="params" type="struct" required="no" default="#StructNew()#" />
		<cfargument name="filepath" type="string" required="no" />
		
		<cfset var result = StructNew() />
		<cfset var key = "">
		<cfset this._tickCount = TimeFormat(now(), "hh:mm:ss") >
		
		<!--- add params to the param struct --->
		<cfset StructInsert(arguments.params, "method", arguments.method) />
		<cfset StructInsert(arguments.params, "api_key", variables._apiKey) />
		<cfset StructInsert(arguments.params, "v", variables._apiVersion) />
		<cfset StructInsert(arguments.params, "call_id", this._tickCount) />
		
		<!--- add the signature [sig] --->
		<cfset StructInsert(arguments.params, "sig", generateSignature(arguments.params)) />
		<cfhttp url="#variables._server#" method="post" multipart="yes" redirect="no">
			<cfloop collection="#arguments.params#" item="key">
				<cfhttpparam name="#key#" value="#arguments.params[key]#" type="formfield" />	
			</cfloop>	
			<cfhttpparam name="filename" file="#arguments.filepath#" type="file" />
		</cfhttp>
		
		<cfreturn cfhttp.FileContent />
	</cffunction>

	<cffunction name="generateSignature" access="public" output="true" returntype="string" hint="I generate and return a key.">
		<cfargument name="params" required="yes" type="struct" />

		<cfset var buffer = CreateObject("java","java.lang.StringBuffer").init("") />
		<cfset var result = "" />
		<cfset var sortedKeys = LCase(ListSort(StructKeyList(arguments.params),"textnocase", "Asc", ",")) />
		<cfset var key = "" />

		<!--- add key=value to buffer --->
		<cfloop list="#sortedKeys#" index="key" delimiters=",">
			<cfset buffer.append(key & "=" & arguments.params[key]) />
		</cfloop>

		<!--- add the secret --->
		<cfset buffer.append( variables._secret ) />
		
		<!--- hash buffer --->
		<cfset result = hash(buffer.toString()) />
		
		<cfreturn LCase(result) />
	</cffunction>
<!--------------------------------------- facebook api calls --------------------------------------->
	<cffunction name="fqlQuery" access="public" output="false" returntype="any" hint="Calls the fql.query api and pulls info based upon the query you pass in">
		<cfargument name="query" type="string" required="true" hint="The fql query of what you want to grab.">
		<cfargument name="session_key" type="string" required="true" hint="The fql query of what you want to grab.">
		<cfargument name="structParam" type="string" required="true" hint="the value of the struct key to search">
		
		<!--- local vars --->
		<cfset var params = StructNew() />
		
		<!--- the api call --->		
		<cfset params["query"] = arguments.query>
		<cfset params["session_key"] = arguments.session_key>
		
		<!--- if you don't need an array list and just want the structure, simply return the xmlToStruct() function --->
		<cfreturn xmlToStruct('facebook.fql.query',params,arguments.structParam) />
	</cffunction>
	
	<cffunction name="CreateAlbum" access="public" output="false" returntype="any" hint="Returns all friends of user">
		<cfargument name="name" type="string" required="true" hint="the name of the album being created">
		<cfargument name="session_key" type="string" required="true" hint="the session id of the logged in user">
		<cfargument name="structParam" type="string" required="true" hint="the value of the struct key to search">
		<!--- local vars --->
		<cfset var params = StructNew() />
		
		<!--- the api call --->		
		<cfset params["name"] = arguments.name />
		<cfset params["session_key"] = arguments.session_key />
		
		<!--- if you don't need an array list and just want the structure, simply return the xmlToStruct() function --->
		<cfset getArrayAID = xmlToStruct('facebook.photos.createAlbum',params,arguments.structParam) />
		
		<cfreturn getArrayAID />
	</cffunction>
	
	<cffunction name="PhotosUpload" access="public" output="false" returntype="any">
		<cfargument name="session_key" type="string" required="true" hint="The session key belonging to the user uploading the photo">
		<cfargument name="filePath" type="string" required="true" hint="Path to the image on the server">
		<cfargument name="aid" type="numeric" required="true" hint="The facebook ID of the album to which to upload the photo. If this has not been supplied, the photo will be uploaded to the application's default album.">
		<cfargument name="caption" type="string" required="false" default="" hint="Photo Caption.">
		
		<cfset var params = StructNew() />
		
		<cfset params["session_key"] = arguments.session_key />
		<cfset params["aid"] = arguments.aid />
		<cfset params["caption"] = arguments.caption />

		<cfreturn callMethodPost("facebook.photos.upload", params, arguments.filePath) />
	</cffunction>
	
	<cffunction name="hasPermission" access="public" output="false" returntype="any" hint="makes sure the user has permission to use the app">
		<cfargument name="session_key" type="string" required="true" hint="the session id of the logged in user">
		<cfargument name="ext_perm" type="string" required="true" hint="the session id of the logged in user">
		
		<!--- local vars --->
		<cfset var params = StructNew() />

		<!--- the api call --->		
		<cfset params["session_key"] = arguments.session_key />
		<cfset params["ext_perm"] = arguments.ext_perm />
		
		<cfset setPermVar = xmlToStructParam('facebook.users.hasAppPermission',params) />
		
		<cfreturn setPermVar />
	</cffunction>
	
	<cffunction name="sendNotification" access="public" output="false" returntype="any" hint="user-to-user notification that sends to any friends of that user">
		<cfargument name="session_key" type="string" required="true" hint="the session id of the logged in user">
		<cfargument name="to_ids" type="string" required="true" hint="ids of all the friends user has chosen">
		<cfargument name="notification" type="string" required="true" hint="body of the notification">
		
		<!--- local vars --->
		<cfset var params = StructNew() />

		<!--- the api call --->		
		<cfset params["session_key"] = arguments.session_key />
		<cfset params["to_ids"] = arguments.to_ids />
		<cfset params["notification"] = arguments.notification />
		
		<cfset sendNoteVar = xmlToStructParam('facebook.notifications.send',params) />
		
		<cfreturn sendNoteVar />
	</cffunction>

<!--------------------------------------- ---------------- --------------------------------------->
	<cffunction name="setFBML" access="public" output="false" returntype="any">
		<cfargument name="markup" type="string" required="yes" />
		<cfargument name="uid" type="numeric" required="yes" />
		<cfargument name="profile" type="string" required="yes" />
		<cfargument name="profile_action" type="string" required="yes" />
		<cfargument name="mobile_profile" type="string" required="yes" />
		<cfargument name="profile_main" type="string" required="yes" />
		
		<cfset var params = StructNew() />
		<cfset params["markup"] = arguments.markup />
		<cfset params["uid"] = arguments.uid />
		<cfset params["profile"] = arguments.profile />
		<cfset params["profile_action"] = arguments.profile_action />
		<cfset params["mobile_profile"] = arguments.mobile_profile />
		<cfset params["profile_main"] = arguments.profile_main />
		
		<cfreturn callMethodGet("facebook.profile.setFBML", params) />
	</cffunction>

	<cffunction name="GetFBML" access="public" output="false" returntype="any">
		<cfargument name="sess_key" type="string" required="yes" />
		<cfargument name="uid" type="string" required="yes" />
		
		<cfset var params = StructNew() />		
		<cfset params["uid"] = arguments.uid />
		<cfset params["session_key"] = arguments.sess_key />
		
		<cfreturn callMethodGet("facebook.profile.getFBML", params) />
	</cffunction>

	<cffunction name="SetFBMLRefHandle" access="public" output="false" returntype="any">
		<cfargument name="sess_key" type="string" required="yes" />  
		<cfargument name="handle" type="string" required="yes" />
		<cfargument name="fbml" type="string" required="yes" />   
		    
		<cfset var params = StructNew() />
		<cfset params["handle"] = arguments.handle />
		<cfset params["fbml"] = arguments.fbml />
		<cfset params["session_key"] = arguments.sess_key />
		
		<cfreturn callMethodGet("facebook.fbml.setRefHandle", params) />
	</cffunction>
<!--------------------------------------- xml handlers --------------------------------------->
	<cffunction name="xmlToStruct" access="public" returntype="any" output="true" hint="converts the xml parse into a useable struct">
		<cfargument name="callMethod" type="string" required="true" />
		<cfargument name="params" type="struct" required="true" />
		<cfargument name="structSearch" type="string" required="true" />
		
		<!--- parse the call method to turn into an xml object --->
		<cfset xmlResponse = XMLParse(callMethodGet(arguments.callMethod, arguments.params)) />

		<!--- if xml returns an error, dump the response for debugging --->
		<cfif find("error_response",xmlResponse)>
			<cfdump var="#xmlResponse#"><cfabort>
		</cfif>
		
		<!--- put the xml parse into a struct --->
		<cfset xmlConvertStruct = ConvertXmlToStruct(xmlResponse,StructNew()) />
		
		<!--- if the structure is not empty, find values, else skip the find as no values can be found --->
		<cfif not StructIsEmpty(xmlConvertStruct)>
			<!--- set the struct to an array --->
			<cfset xmlStruct = StructFind(xmlConvertStruct,arguments.structSearch) />
			
			<cfreturn xmlStruct />
		<cfelse>
			<cfset count = 0 />
			<cfreturn count />
		</cfif>
	</cffunction>
	
	<cffunction name="xmlToStructParam" access="public" returntype="any" output="true" hint="converts the xml parse into a useable struct">
		<cfargument name="callMethod" type="string" required="true" />
		<cfargument name="params" type="struct" required="true" />
		
		<!--- parse the call method to turn into an xml object --->
		<cfset xmlResponse = XMLParse(callMethodGet(arguments.callMethod, arguments.params)) />

		<!--- if xml returns an error, dump the response for debugging --->
		<cfif find("error_response",xmlResponse)>
			<cfdump var="#xmlResponse#"><cfabort>
		</cfif>
		
		<cfreturn xmlResponse />
	</cffunction>
	
	<cffunction name="ConvertXmlToStruct" access="public" returntype="struct" output="true" hint="Parse raw XML response body into ColdFusion structs and arrays and return it.">
		<cfargument name="xmlNode" type="string" required="true" />
		<cfargument name="str" type="struct" required="true" />
		<!---Setup local variables for recurse: --->
		<cfset var i = 0 />
		<cfset var axml = arguments.xmlNode />
		<cfset var astr = arguments.str />
		<cfset var n = "" />
		<cfset var tmpContainer = "" />
	
		<cfset axml = XmlSearch(XmlParse(arguments.xmlNode),"/node()")>
		<cfset axml = axml[1] />
		<!--- For each children of context node: --->
		<cfloop from="1" to="#arrayLen(axml.XmlChildren)#" index="i">
			<!--- Read XML node name without namespace: --->
			<cfset n = replace(axml.XmlChildren[i].XmlName, axml.XmlChildren[i].XmlNsPrefix&":", "") />
			<!--- If key with that name exists within output struct ... --->
			<cfif structKeyExists(astr, n)>
				<!--- ... and is not an array... --->
				<cfif not isArray(astr[n])>
					<!--- ... get this item into temp variable, ... --->
					<cfset tmpContainer = astr[n] />
					<!--- ... setup array for this item beacuse we have multiple items with same name, ... --->
					<cfset astr[n] = arrayNew(1) />
					<!--- ... and reassing temp item as a first element of new array: --->
					<cfset astr[n][1] = tmpContainer />
				<cfelse>
					<!--- Item is already an array: --->
					
				</cfif>
				<cfif arrayLen(axml.XmlChildren[i].XmlChildren) gt 0>
						<!--- recurse call: get complex item: --->
						<cfset astr[n][arrayLen(astr[n])+1] = ConvertXmlToStruct(axml.XmlChildren[i], structNew()) />
				<cfelse>
						<!--- else: assign node value as last element of array: --->
						<cfset astr[n][arrayLen(astr[n])+1] = axml.XmlChildren[i].XmlText />
				</cfif>
			<cfelse>
				<!---
					This is not a struct. This may be first tag with some name.
					This may also be one and only tag with this name.
				--->
				<!---
						If context child node has child nodes (which means it will be complex type): --->
				<cfif arrayLen(axml.XmlChildren[i].XmlChildren) gt 0>
					<!--- recurse call: get complex item: --->
					<cfset astr[n] = ConvertXmlToStruct(axml.XmlChildren[i], structNew()) />
				<cfelse>
					<cfif IsStruct(aXml.XmlAttributes) AND StructCount(aXml.XmlAttributes)>
						<cfset at_list = StructKeyList(aXml.XmlAttributes)>
						<cfloop from="1" to="#listLen(at_list)#" index="atr">
							 <cfif ListgetAt(at_list,atr) CONTAINS "xmlns:">
								 <!--- remove any namespace attributes--->
								<cfset Structdelete(axml.XmlAttributes, listgetAt(at_list,atr))>
							 </cfif>
						 </cfloop>
						 <!--- if there are any atributes left, append them to the response--->
						 <cfif StructCount(axml.XmlAttributes) GT 0>
							 <cfset astr['_attributes'] = axml.XmlAttributes />
						</cfif>
					</cfif>
					<!--- else: assign node value as last element of array: --->
					<!--- if there are any attributes on this element--->
					<cfif IsStruct(aXml.XmlChildren[i].XmlAttributes) AND StructCount(aXml.XmlChildren[i].XmlAttributes) GT 0>
						<!--- assign the text --->
						<cfset astr[n] = axml.XmlChildren[i].XmlText />
							<!--- check if there are no attributes with xmlns: , we dont want namespaces to be in the response--->
						 <cfset attrib_list = StructKeylist(axml.XmlChildren[i].XmlAttributes) />
						 <cfloop from="1" to="#listLen(attrib_list)#" index="attrib">
							 <cfif ListgetAt(attrib_list,attrib) CONTAINS "xmlns:">
								 <!--- remove any namespace attributes--->
								<cfset Structdelete(axml.XmlChildren[i].XmlAttributes, listgetAt(attrib_list,attrib))>
							 </cfif>
						 </cfloop>
						 <!--- if there are any atributes left, append them to the response--->
						 <cfif StructCount(axml.XmlChildren[i].XmlAttributes) GT 0>
							 <cfset astr[n&'_attributes'] = axml.XmlChildren[i].XmlAttributes />
						</cfif>
					<cfelse>
						 <cfset astr[n] = axml.XmlChildren[i].XmlText />
					</cfif>
				</cfif>
			</cfif>
		</cfloop>
		<!--- return struct: --->
		<cfreturn astr />
	</cffunction>
<!--------------------------------------- accessors --------------------------------------->
	<cffunction name="GetApiKey" access="public" output="false" returntype="string">
		<cfreturn variables._apiKey />
	</cffunction>
	
	<cffunction name="GetSecret" access="public" output="false" returntype="string">
		<cfreturn variables._secret />
	</cffunction>
	
	<cffunction name="GetURL" access="public" output="false" returntype="string">
		<cfreturn variables._url />
	</cffunction>

	<cffunction name="GetCallBackURL" access="public" output="false" returntype="string">
		<cfreturn variables._callBackURL/>
	</cffunction>
<!------------------------------------------------------------------------------------------>

</cfcomponent>