<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

#****************************************************************************
#*  Translation text used on multiple pages
#****************************************************************************
$trans["reportsCancel"]            = "\$text = 'Cancelar';";

#****************************************************************************
#*  Translation text for page index.php
#****************************************************************************
$trans["indexHdr"]                 = "\$text = 'Informes';";
$trans["indexDesc"]                = "\$text = 'Use la llista de informes de la izquierda para producir informes o etiquetas.';";

#****************************************************************************
#*  Translation text for page report_list.php
#****************************************************************************
$trans["reportListHdr"]            = "\$text = 'Lista de informes';";
$trans["reportListDesc"]           = "\$text = 'Seleccione uno de los siguientes links para producir informe.';";
$trans["reportListXmlErr"]         = "\$text = 'Error occurrido en definicion xml informe.';";
$trans["reportListCannotRead"]     = "\$text = 'No puedo leer archivo: %fileName%';";

#****************************************************************************
#*  Translation text for page label_list.php
#****************************************************************************
$trans["labelListHdr"]             = "\$text = 'Lista etiquetas';";
$trans["labelListDesc"]            = "\$text = 'Seleccione uno de los siguientes links para producir etiquetas en formato pdf.';";
$trans["displayLabelsXmlErr"]      = "\$text = 'Error occurrido en definicion xml informe.  Error = ';";

#****************************************************************************
#*  Translation text for page letter_list.php
#****************************************************************************
$trans["letterListHdr"]            = "\$text = 'Lista de cartas';";
$trans["letterListDesc"]           = "\$text = 'Seleccione uno de los siguientes links para producir cartas en formato pdf.';";
$trans["displayLettersXmlErr"]      = "\$text = 'Error occurrido en definicion xml informe..  Error = ';";

#****************************************************************************
#*  Translation text for page report_criteria.php
#****************************************************************************
$trans["reportCriteriaHead1"]      = "\$text = 'Criterio busqueda informe (opcional)';";
$trans["reportCriteriaHead2"]      = "\$text = 'Ordenamiento Informe (opcional)';";
$trans["reportCriteriaHead3"]      = "\$text = 'Tipo de salida informe';";
$trans["reportCriteriaCrit1"]      = "\$text = 'Criterio 1:';";
$trans["reportCriteriaCrit2"]      = "\$text = 'Criterio 2:';";
$trans["reportCriteriaCrit3"]      = "\$text = 'Criterio 3:';";
$trans["reportCriteriaCrit4"]      = "\$text = 'Criterio 4:';";
$trans["reportCriteriaEQ"]         = "\$text = '=';";
$trans["reportCriteriaNE"]         = "\$text = 'not =';";
$trans["reportCriteriaLT"]         = "\$text = '&lt;';";
$trans["reportCriteriaGT"]         = "\$text = '&gt;';";
$trans["reportCriteriaLE"]         = "\$text = '&lt or =';";
$trans["reportCriteriaGE"]         = "\$text = '&gt or =';";
$trans["reportCriteriaBT"]         = "\$text = 'between';";
$trans["reportCriteriaAnd"]        = "\$text = 'and';";
$trans["reportCriteriaRunReport"]  = "\$text = 'Run Report';";
$trans["reportCriteriaSortCrit1"]  = "\$text = 'Sort 1:';";
$trans["reportCriteriaSortCrit2"]  = "\$text = 'Sort 2:';";
$trans["reportCriteriaSortCrit3"]  = "\$text = 'Sort 3:';";
$trans["reportCriteriaAscending"]  = "\$text = 'ascending';";
$trans["reportCriteriaDescending"] = "\$text = 'descending';";
$trans["reportCriteriaStartOnLabel"] = "\$text = 'Start printing on label:';";
$trans["reportCriteriaOutput"]     = "\$text = 'Output Type:';";
$trans["reportCriteriaOutputHTML"] = "\$text = 'HTML';";
$trans["reportCriteriaOutputCSV"]  = "\$text = 'CSV';";

#****************************************************************************
#*  Translation text for page run_report.php
#****************************************************************************
$trans["runReportReturnLink1"]     = "\$text = 'criterio seleccion informe';";
$trans["runReportReturnLink2"]     = "\$text = 'lista informe';";
$trans["runReportTotal"]           = "\$text = 'Total Lineas:';";

#****************************************************************************
#*  Translation text for page display_labels.php
#****************************************************************************
$trans["displayLabelsStartOnLblErr"] = "\$text = 'Campo debe ser numerico.';";
$trans["displayLabelsXmlErr"]      = "\$text = 'Error ocurrido definicion xml informe.  Error = ';";
$trans["displayLabelsCannotRead"]  = "\$text = 'No puedo leer archivo etiqueta: %fileName%';";

#****************************************************************************
#*  Translation text for page noauth.php
#****************************************************************************
$trans["noauthMsg"]                = "\$text = 'Solicite autorizacion para usar solapa de informes.';";

#****************************************************************************
#*  Report Titles
#****************************************************************************
$trans["reportHolds"]              = "\$text = 'Hold Requests Containing Member Contact Info';";
$trans["reportCheckouts"]          = "\$text = 'Bibliography Checkout Listing';";
$trans["Over Due Letters"]           = "\$text = 'Over Due Letters';";
$trans["reportLabels"]             = "\$text = 'Label Printing Query (used by labels)';";
$trans["popularBiblios"]           = "\$text = 'Most Popular Bibliographies';";
$trans["overdueList"]              = "\$text = 'Over Due Member List';";
$trans["balanceDueList"]           = "\$text = 'Balance Due Member List';";

#****************************************************************************
#*  Label Titles
#****************************************************************************
$trans["labelsMulti"]              = "\$text = 'Ejemplo etiqueta mltiple';";
$trans["labelsSimple"]             = "\$text = 'Ejemplo etiqueta simple';";

#****************************************************************************
#*  Column Text
#****************************************************************************
$trans["biblio.bibid"]             = "\$text = 'Identif ID';";
$trans["biblio.create_dt"]         = "\$text = 'Fecha agregado';";
$trans["biblio.last_change_dt"]    = "\$text = 'Ult modif';";
$trans["biblio.material_cd"]       = "\$text = 'Material Cd';";
$trans["biblio.collection_cd"]     = "\$text = 'Colecion';";
$trans["biblio.call_nmbr1"]        = "\$text = 'Llamada 1';";
$trans["biblio.call_nmbr2"]        = "\$text = 'Llamada 2';";
$trans["biblio.call_nmbr3"]        = "\$text = 'Llamada 3';";
$trans["biblio.title_remainder"]   = "\$text = 'Recordar titulo';";
$trans["biblio.responsibility_stmt"] = "\$text = 'Stmt of Resp';";
$trans["biblio.opac_flg"]          = "\$text = 'Bandera aviso';";

$trans["biblio_copy.barcode_nmbr"] = "\$text = 'Cod.Barras';";
$trans["biblio.title"]             = "\$text = 'Titulo';";
$trans["biblio.author"]            = "\$text = 'Autor';";
$trans["biblio_copy.status_begin_dt"]   = "\$text = 'Status Fecha comienzo';";
$trans["biblio_copy.due_back_dt"]       = "\$text = 'Fecha vencim devoluc';";
$trans["member.mbrid"]             = "\$text = 'ID miembro';";
$trans["member.barcode_nmbr"]      = "\$text = 'Cod. barras miembro';";
$trans["member.last_name"]         = "\$text = 'Apellido';";
$trans["member.first_name"]        = "\$text = 'Nombre';";
$trans["member.address"]          = "\$text = 'Direccion';";
$trans["biblio_hold.hold_begin_dt"] = "\$text = 'Comienzo fecha ret';";
$trans["member.home_phone"]        = "\$text = 'Telf casa';";
$trans["member.work_phone"]        = "\$text = 'Telef trabajo';";
$trans["member.email"]             = "\$text = 'Email';";
$trans["biblio_status_dm.description"] = "\$text = 'Status';";
$trans["settings.library_name"]    = "\$text = 'Nombre';";
$trans["settings.library_hours"]   = "\$text = 'Horario';";
$trans["settings.library_phone"]   = "\$text = 'Telefono biblio';";
$trans["days_late"]                = "\$text = 'Dias tarde';";
$trans["title"]                    = "\$text = 'Titulo';";
$trans["author"]                   = "\$text = 'Autor';";
$trans["due_back_dt"]              = "\$text = 'Due Back';";
$trans["checkoutCount"]            = "\$text = 'Contar Checkout';";

?>
