<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

#****************************************************************************
#*  Translation text shared by various php files under the navbars dir
#****************************************************************************
$trans["login"]                    = "\$text = 'Login';";
$trans["logout"]                   = "\$text = 'Logout';";
$trans["help"]                     = "\$text = 'Help';";

#****************************************************************************
#*  Translation text for page home.php
#****************************************************************************
$trans["homeHomeLink"]             = "\$text = 'Home';";
$trans["homeLicenseLink"]          = "\$text = 'Licencia';";

#****************************************************************************
#*  Translation text for page admin.php
#****************************************************************************
$trans["adminSummary"]             = "\$text = 'Sumario admin';";
$trans["adminStaff"]               = "\$text = 'Staff Admin';";
$trans["adminSettings"]            = "\$text = 'Configuracion';";
$trans["adminMaterialTypes"]       = "\$text = 'Tipos de material';";
$trans["adminCollections"]         = "\$text = 'Colecciones';";
$trans["adminThemes"]              = "\$text = 'Thmas';";
$trans["adminTranslation"]         = "\$text = 'Traduccion';";

#****************************************************************************
#*  Translation text for page cataloging.php
#****************************************************************************
$trans["catalogSummary"]           = "\$text = 'Sumario Catalogo';";
$trans["catalogSearch1"]           = "\$text = 'Busqueda';";
$trans["catalogSearch2"]           = "\$text = 'Buscar Bibliografia';";
$trans["catalogResults"]           = "\$text = 'Resultados ';";
$trans["catalogBibInfo"]           = "\$text = 'Biblio Info';";
$trans["catalogBibEdit"]           = "\$text = 'Editar-Basic';";
$trans["catalogBibEditMarc"]       = "\$text = 'Editar-MARC';";
$trans["catalogBibMarcNewFld"]     = "\$text = 'Nuevo campo MARC';";
$trans["catalogBibMarcNewFldShrt"] = "\$text = 'Nuevo MARC';";
$trans["catalogBibMarcEditFld"]    = "\$text = 'Editar MARC Campo';";
$trans["catalogCopyNew"]           = "\$text = 'Nueva copia';";
$trans["catalogCopyEdit"]          = "\$text = 'Editar Copia';";
$trans["catalogHolds"]             = "\$text = 'Ret Requerim';";
$trans["catalogDelete"]            = "\$text = 'Borrar';";
$trans["catalogBibNewLike"]        = "\$text = 'Nuevo como';";
$trans["catalogBibNew"]            = "\$text = 'Nueva Bibliografia';";
$trans["Upload Marc Data"]         = "\$text = 'Subir Marc Data';";

#****************************************************************************
#*  Translation text for page reports.php
#****************************************************************************
$trans["reportsSummary"]           = "\$text = 'Sumario informes';";
$trans["reportsReportListLink"]    = "\$text = 'Lista informes';";
$trans["reportsLabelsLink"]        = "\$text = 'Imprimir etiquetas';";
$trans["reportsLettersLink"]        = "\$text = 'Imprimir cartas';";

#****************************************************************************
#*  Translation text for page opac.php
#****************************************************************************
$trans["catalogSearch1"]           = "\$text = 'Buscar';";
$trans["catalogSearch2"]           = "\$text = 'Buscar bibliografia';";
$trans["catalogResults"]           = "\$text = 'Resultados busqueda';";
$trans["catalogBibInfo"]           = "\$text = 'Biblio Info';";

#Added

$trans["memberInfo"]="\$text = 'Info miembro';";
$trans["memberSearch"]="\$text = 'Buscar miembro';";
$trans["editInfo"]="\$text = 'Editar Info';";
$trans["checkoutHistory"]= "\$text = 'Historia Checkout';";
$trans["account"]="\$text = 'Cuenta';";
$trans["checkIn"]="\$text = 'Check In';";
$trans["memberSearch"]= "\$text = 'Buscar miembro';";
$trans["newMember"]= "\$text = 'Nuevo miembro';";
//$trans["account"]        	= "\$text = 'Account';";
?>
