<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */


#****************************************************************************
#*  Translation text for page index.php parcial 2010-8
#****************************************************************************
$trans["indexHeading"]       = "\$text='Bienvenidos al Centro de Distribucin Publicaciones y Biblioteca';";
$trans["indexIntro"]         = "\$text=
  'Usar los items de navegacion superiores para acceder a las siguientes secciones de administracion.';";
$trans["indexTab"]           = "\$text='Tab';";
$trans["indexDesc"]          = "\$text='Descripcin';";
$trans["indexCirc"]          = "\$text='Circulacin';";
$trans["indexCircDesc1"]     = "\$text='Use esta solapa para administrar los registros de los miembros.';";
$trans["indexCircDesc2"]     = "\$text='Administracion de miembros (nuevo, buscar, editar, borrar)';";
$trans["indexCircDesc3"]     = "\$text='Miembros: retiros de biblio, retenciones, cuenta, historia';";
$trans["indexCircDesc4"]     = "\$text='Devolucin bibliografa, lista estantera';";
//$trans["indexCircDesc5"]     = "\$text='Member late fee payment';";
$trans["indexCat"]           = "\$text='Catalogar';";
$trans["indexCatDesc1"]      = "\$text='Use esta solapa para administrar los registros de bibliografa.';";
$trans["indexCatDesc2"]      = "\$text='Administracin bibliografa (nuevo, buscar, editar, borrar)';";
//$trans["indexCatDesc3"]      = "\$text='Import bibliography from USMarc record';";
$trans["indexAdmin"]         = "\$text='Admin';";
$trans["indexAdminDesc1"]    = "\$text='Use esta solapa para administrar los registros del staff y administrativos.';";
$trans["indexAdminDesc2"]    = "\$text='Administracin staff (nuevo, editar, password, borrar)';";
$trans["indexAdminDesc3"]    = "\$text='Configuraciones generales';";
$trans["indexAdminDesc5"]    = "\$text='Lista de tipos de materiales';";
$trans["indexAdminDesc4"]    = "\$text='Lista de colecciones';";
$trans["indexAdminDesc6"]    = "\$text='Editor de temas';";
$trans["indexReports"]       = "\$text='Informes';";
$trans["indexReportsDesc1"]  = "\$text='Use esta solapa para generar informes.';";
$trans["indexReportsDesc2"]  = "\$text='Informe.';";
$trans["indexReportsDesc3"]  = "\$text='Etiquetas.';";

?>
