<!--- SourceSafe $Header: /capps/template/capps/prefrncs/update.cfm 42    4/29/97 6:06p Mjruser $

	This template is included in the shared/header.cfm template. It updates
	the user preferences record every time some of the preferences was
	changed or LocalSessionTimeout occurred.

--->

<CFSET #CheckLocalSessionTimeout# = "YES">

<CFIF #IsNewSession# IS "no">
<CFIF #ParameterExists(Form.Username)# IS "no">
	<CFIF #ParameterExists(CookieAuthenticationEnabled)# IS "yes">
               <CFIF Evaluate("Parameterexists(Cookie.#CookieUser_OID#)")>
                <CFIF Evaluate("Cookie.#CookieUser_OID#") IS #CID#>
			<CFSET #CheckLocalSessionTimeout# = "NO">
		</CFIF>
		</CFIF>
	<CFELSE>
		<CFIF #User.VisitingObject_ID# IS #CID#>
			<CFSET #CheckLocalSessionTimeout# = "NO">
		</CFIF>
	</CFIF>
</CFIF>
</CFIF>


<!--- Check LocalSessionTimeout if either NewSession from the GetUser.cfm template occurred or
	cookie with capps_Object_ID doesn't exists or it is different from the current one (user just
	came to this Company from another one in this system). --->

<CFIF #CheckLocalSessionTimeout# IS "YES">

        <CFQUERY NAME="CheckLastLocalAuthenticated" DATASOURCE="#ACBMainDS#">
			SELECT
				( { fn YEAR( { fn NOW() })} - { fn YEAR( UP.TimeLastSessionBegan )} ) * 525600 +
				( { fn DAYOFYEAR( { fn NOW() })} - { fn DAYOFYEAR( UP.TimeLastSessionBegan )} ) * 1440 +
				( { fn HOUR( { fn NOW() })} - { fn HOUR( UP.TimeLastSessionBegan )} ) * 60 +
				( { fn MINUTE( { fn NOW() })} - { fn MINUTE( UP.TimeLastSessionBegan )} ) AS TimeSinceLastAuthenticated
				FROM UserPreferences UP
				WHERE UP.User_ID = #User_ID#
					AND Company_ID = #CID#

		</CFQUERY>

	<CFQUERY NAME="UpdateVisitingObject_ID" DATASOURCE="#SecurityDS#">
		UPDATE Users SET
				VisitingObject_ID = #CID#
				WHERE User_ID = #User_ID#
	</CFQUERY>

        <CFIF #CheckLastLocalAuthenticated.RecordCount# IS 0>
		<!--- create new UserPreferences record --->
                <CFQUERY NAME="InsertUserPreferences" DATASOURCE="#ACBMainDS#">
				INSERT INTO UserPreferences
					(User_ID, Company_ID, Filter, Days)
				  VALUES
				 	(#User_ID#, #CID#, '', 30 )

                </CFQUERY>

		<CFSET #TimeSinceLastLocalAuthenticated# = 0>

	<CFELSE>

		<CFSET #TimeSinceLastLocalAuthenticated# = #CheckLastLocalAuthenticated.TimeSinceLastAuthenticated#>

	</CFIF>

<CFELSE>
	<CFSET #TimeSinceLastLocalAuthenticated# = 0>

</CFIF>

<CFSET #IsNewLocalSession# = "NO">
<CFIF #SessionTimeout# LESS THAN #TimeSinceLastLocalAuthenticated#>
	<CFSET #IsNewLocalSession# = "YES">
</CFIF>

<CFSET #UpdateUserRecord# = "YES">

<CFIF #ParameterExists(Form.Filter)# IS "no">
<CFIF #ParameterExists(Form.Days)# IS "no">
<CFIF #ParameterExists(Form.Product_ID)# IS "no">
<CFIF #ParameterExists(Form.ShipSame)# IS "no">
<CFIF Evaluate("Parameterexists(Cookie.#CookieUser_LA#)")>
<CFIF #IsNewLocalSession# IS "NO">
                <CFSET #UpdateUserRecord# = "NO">
</CFIF>
</CFIF>
</CFIF>
</CFIF>
</CFIF>
</CFIF>

<!--- Update user record if any of the preference parameters changed or
	NewLocalSessionTimeout occurred --->

<CFIF #UpdateUserRecord# IS "YES">

        <CFQUERY NAME="UpdateUserPreferences" DATASOURCE="#ACBMainDS#">
		UPDATE UserPreferences SET

		<CFIF #IsNewLocalSession# IS "YES">
			TimePreviousSessionBegan=UserPreferences.TimeLastSessionBegan,
		</CFIF>

		<CFIF #ParameterExists(Form.Filter)# IS "yes">
			Filter = '#Form.Filter#',
		</CFIF>

                <CFIF #ParameterExists(Form.Days)# IS "yes">
                        Days = #Form.Days#,
		</CFIF>

		<CFIF #ParameterExists(Form.ShipSame)# IS "yes">
                        ShipSame = #Form.ShipSame#,
		</CFIF>

		<CFIF #ParameterExists(Form.Product_ID)# IS "yes">
                                        PreviousProduct_ID = #Listfirst(Form.Product_ID)#,
		</CFIF>
                TimeLastSessionBegan={fn NOW()}
                        WHERE User_ID = #User_ID# AND Company_ID = #CID#

        </CFQUERY>

</CFIF>

<CFQUERY NAME = "DS_Master" DATASOURCE = "#ACBMasterDS#">
                SELECT CompanyDataSources.CompanyDS_ID FROM CompanyDataSources
                WHERE ((CompanyDS_ID) <> #DID# AND (DataSources_ID) <> 1)
</CFQUERY>

<CFCOOKIE NAME="#CookieUser_OID#" VALUE="#CID#" > <!---  --->