<!--- SourceSafe $Header: /capps/template/capps/basket/purchase.cfm 159   4/26/97 5:22p Mjruser $

        Call this template from a product display page to add a product to the OrderDetails table.

        Template does the following in order:
                (1) Checks to see if Shipping or Taxes already exist in the basket and resets if needed
                (2) If parameterexists form.addmultiple or form.addone is Yes then
                        Create variables Product_ID_List and a QTY_List.

--->
<!-------------- CHECK FOR AN OPEN ORDER ----------------------->

<CFQUERY NAME = "CheckForOpenOrder" DATASOURCE = "#ACBMainDS#">
        Select * from Orders where User_ID=#User_ID# and Company_ID=#CID# and OrderDate IS Null <!---Date Not Assigned until final checkout--->
</CFQUERY>


<CFIF #CheckForOpenOrder.RecordCount# is 0>     <!------------ No Orders OrderID Found, Create a new Order Entry------------>

		<CFTRANSACTION>

                <CFQUERY NAME="StartNewOrder" DATASOURCE="#ACBMainDS#">
                        INSERT INTO Orders (User_ID,Company_ID)
                        VALUES (#User_ID#,#CID#)
                </CFQUERY>

                <CFQUERY NAME="FindNewId" DATASOURCE="#ACBMainDS#">
                        SELECT Max(Order_ID) As MaxOrderID
                                FROM Orders
                </CFQUERY>

		</CFTRANSACTION>

<CFELSE>

        <!--- CHECK FOR USER HITTING REFRESH IN THE SHIPPING ROUTINE LOOK FOR 99999998 or 99999999 or 99999997 in the Partnumber Field--->

                <CFQUERY NAME = "CheckForRefresh" DATASOURCE="#ACBMainDS#">
                        SELECT OrderDetails.OrderDetail_ID, OrderDetails.Order_ID, Orders.Company_ID,
                        OrderDetails.Product_ID, OrderDetails.Qty, OrderDetails.Price, OrderDetails.ProductTitle,
                        OrderDetails.Weight, OrderDetails.Opt_IDs, OrderDetails.OptTitles, OrderDetails.OptsWeight,
                        OrderDetails.OptsPrice, OrderDetails.PartNumber, Orders.User_ID,
                        Orders.Orderdate, OrderDetails.OptTitles
                                FROM Orders INNER JOIN OrderDetails ON Orders.Order_ID = OrderDetails.Order_ID
                                WHERE (((Orders.User_ID)=#User_ID#) AND ((Orders.Orderdate) Is Null))
                                AND (((OrderDetails.Product_ID)=99999998) OR ((OrderDetails.Product_ID)=99999999) OR ((OrderDetails.Product_ID)=99999997))
                </CFQUERY>

                <CFIF #CheckForRefresh.RecordCount# IS NOT 0>

                        <CFINCLUDE TEMPLATE="#Root#/basket/cancel.cfm">

                </CFIF>
</CFIF>

<!--- Create a cleanly formatted Product_ID_List and QTY_List and the product COUNT --->

<CFIF #Parameterexists(FORM.addmultiple)# is "Yes" OR #Parameterexists(FORM.addone)# is "Yes">

        <CFPARAM NAME="Count" default=0>
        <CFPARAM NAME="Product_ID_List" default ="">
        <CFPARAM NAME="QTY_List" default ="">
        <CFPARAM NAME="Sep1" default ="">

        <CFLOOP INDEX="QTY_Index" List="#form.Qty#">

                <CFSET #COUNT# = #COUNT# + 1>

                        <CFIF #QTY_INDEX# IS NOT 0 AND #IsNumeric(QTY_INDEX)#>

                                <CFSET #QTY_List# ="#QTY_List##Sep1# #QTY_INDEX#">
                                <CFSET #Product_ID_List# = "#Product_ID_List##Sep1##LISTGetAt("#FORM.Product_ID#", "#Count#")#">
                                 <CFSET #SEP1# = ",">

                       </CFIF>


        </CFLOOP>

      </CFIF>


<!------------------------------------------ Purchase a product from a single product display page ------------------------------------->



        <CFIF #parameterexists(opt_ID)# is "Yes"> <!--------------------find the 1 option--------------->

                <CFQUERY NAME="GetSelectedOptions" datasource = "#ACBMainDS#">
                        Select OptTitle,OptPrice,OptPartNumber, OrderByString, OptWeight,OptLevel from
                        Options where Opt_ID IN (#Form.Opt_ID#) ORDER BY OrderByString, OptTitle
                </CFQUERY>

                <CFQUERY NAME="GetOptionsTotals" datasource = "#ACBMainDS#">
                                SELECT Sum(OptPrice) as OptsPrice, Sum(OptWeight) As OptsWeight from
                                Options where Opt_ID IN (#Form.Opt_ID#)
                </CFQUERY>

                <CFSET #OptTitles# = "">

                <CFOUTPUT QUERY="GetSelectedOptions">
                        <CFIF #Trim(OptPartNumber)# IS not "">
                                <CFSET #InsertOption# = "#OptPartNumber# - #OptTitle#">
                        <CFELSE>
                                <CFSET #InsertOption# = "#OptTitle#">
                        </CFIF>

                        <CFIF #OptPrice# is not 0>

                                <CFSET #OptTitles# = "#OptTitles# (<B>#InsertOption#</B> #DollarFormat(OptPrice)#)">

                        <CFELSE>

                                <CFSET #OptTitles# = "#OptTitles# (<B>#InsertOption#</B>)">

                        </CFIF>

                </CFOUTPUT>

        </CFIF>

<CFIF #parameterexists(form.ProductTitle)# is "Yes">

        <CFQUERY NAME = "BuyProd" DATASOURCE = "#ACBMainDS#">
        INSERT INTO OrderDetails
        (Order_ID, Product_ID, Qty, Price, ProductTitle, Weight, Taxable, PartNumber

        <CFIF #parameterexists(opt_ID)# is "Yes">
                ,Opt_IDs, optTitles, OptsPrice , OptsWeight
        </CFIF>
        )

        <CFIF #parameterexists(FindNewId.MaxOrderID)# Is "Yes">
                Select #FindNewID.MaxOrderID# As NewOrder_ID,
        <CFELSE>
                Select #CheckForOpenOrder.Order_ID# as NewOrder_ID,

        </CFIF>

        Products.Product_ID, #qty# as Units, Products.Price, Products.ProductTitle, Products.Weight, Products.Taxable, Products.Partnumber

        <CFIF #parameterexists(opt_ID)# is "Yes">
                ,'#Form.Opt_ID#' as OptIDs, '#OptTitles#' AS OptionTs, #GetOptionsTotals.OptsPrice# AS OPTPrc, #GetOptionsTotals.OptsWeight# AS OptsWGHT

        </CFIF>
                FROM Products where Product_ID = #form.Product_ID#
        </CFQUERY>

 </CFIF>

<!------------------------ Line_ID exists from editdetl.cfm only while editing basket contents via showcott.cfm --------------------->

<CFIF #Parameterexists(Line_ID)# Is "yes">
         <CFQUERY NAME = "updateprod" DATASOURCE = "#ACBMainDS#">
		UPDATE OrderDetails
                SET qty=#qty#

        <CFIF #parameterexists(Opt_ID)# is "Yes">
		,Opt_IDs='#form.Opt_ID#' ,OptTitles='#OptTitles#', OptsPrice=#GetOptionsTotals.OptsPrice#, OptsWeight=#GetOptionsTotals.OptsWeight#

        </cfif>
                WHERE (OrderDetail_ID=#Line_ID#)
        </CFquery>

<CFELSEIF #Parameterexists(AddMultiple)# Is "Yes">

<CFSET #COUNT# = 0>

        <CFLOOP INDEX="QTY_INDEX" List="#QTY_List#">

        <CFSET #COUNT# = #COUNT# + 1>

        <CFQUERY NAME="GetProducts#count#" datasource = "#ACBMainDS#">
                Insert Into OrderDetails (Qty, Order_ID, Product_ID, Price, ProductTitle, Weight, Partnumber, Taxable)
                        Select #QTY_INDEX# AS Expr1,

                        <CFIF #parameterexists(FindNewId.MaxOrderID)# Is "Yes">

                                #FindNewId.MaxOrderID# AS Expr2,

                        <CFELSE>

                                #CheckForOpenOrder.Order_ID# AS Expr2,

                        </CFIF>

                          Products.Product_ID,
                        Products.Price, Products.ProductTitle, Products.Weight, Products.PartNumber, Products.Taxable
                        FROM Products Where Product_ID = #LISTGetAt("#Product_ID_List#","#Count#")#

           </CFQUERY>

       </CFLOOP>

</CFIF>

<!------------- SHOW THE BASKET CONTENTS ------------------>

 <CFIF #Parameterexists(Line_ID)# is "YES">

        <CFSET #BasketMessage# = "Contenido Actualizado Orden">

<CFELSE>

        <CFSET #BasketMessage# = "Contenido Orden de Compra">

</CFIF>

<CFINCLUDE TEMPLATE="#Root#/basket/showcott.cfm">