<! rev CH 31-8>
<html><head>
<title>Un Selector de backgound en JavaScript</title>
<script language="JavaScript">

<!-- copyright.t
/*
 * Copyright (C) 1995,1996 by Achille Hui (eillihca@drizzle.stanford.edu)
 *
 *  You are free to use, redistribute and modify the content of this source
 *  (excluding this copyright notice) in any manner.
 */
// -->

<!-- extracted from misc.js

function get_value(type,elem){
    var i, j, k;
    if(type == "text"){
        // return the "value" of a input field of type "text". It is
        // supposed to work with textarea too (not in 2.0b3 though)
        return (elem.value == "") ? elem.defaultValue : elem.value;
    } else if(type == "select"){
        //  return the "value" of the selected option in a "select"
        //  (doens't work with "multiple")
        j  = elem.length;
        k  = -1;
        var opts = elem.options;
        for(i = 0; i < j; i++){
            if(opts[i].selected){
                return opts[i].value;
            } else if(opts[i].defaultSelected){
                k = i;
            }
        }
        return (k >= 0) ?  ("" + opts[k].value) : null;
    } else if(type == "radio"){
        // return the "value" of a radio group
        j = elem.length;
        k = -1;
        for(i = 0; i < j; i++){
            if(elem[i].status){
                return elem[i].value;
            } else if(elem[i].defaultStatus){
                k = i;
            }
        }
        return (k >= 0) ? elem[k].value : null;
    } else {
        return null;
    }
}
// misc.ls -->

<!-- extracted from struct.js
var _pm_unique_counter = 0;
function pm_uniqueid(){
    _pm_unique_counter++;
    return _pm_unique_counter;
}

function pm_array(n,val){
   this.length = n;
   for(var i = 1; i <= n; i++)
        this[i] = val;
   return this;
}

function pm_toarray(){
   var argv = pm_toarray.arguments;
   var obj  = new Object();
   obj.length = argv.length;
   for(var i = 0; i < argv.length; i++)
        obj[i+1] = argv[i];
   return obj;
}

function pm_list() {
    this.id     = pm_uniqueid();
    this.size   = 0;
    this.first  = null;
    this.last   = null;
}

function pm_hook(id,item) {
    this.id    = (id == 0) ? pm_uniqueid() : id;
    this.prev  = null;
    this.next  = null;
    this.item  = item;
}

function pm_pushitem(list,id,item,head){
    var hook = new pm_hook(id,item);
    if((list == null)||(list.first == null)){
        list.first = list.last = hook;
    } else if(head){
        list.first.prev = hook;
        hook.next = list.first;
        list.first = hook;
    } else {
        list.last.next = hook;
        hook.prev = list.last;
        list.last = hook;
    }
    list.size += 1;
    return hook.id;
}

function pm_finditem(list,id,deleteit){
    if(list != null)
        for(var hook = list.first; hook != null; hook = hook.next)
            if(hook.id == id){
                var item = hook.item;
                if(deleteit){
                    if(hook.prev != null){
                        hook.prev.next = hook.next;
                    } else {
                        list.first = hook.next;
                    }
                    if(hook.next != null){
                        hook.next.prev = hook.prev;
                    } else {
                        list.last = hook.prev;
                    }
                    list.size -= 1;
               }
               return item;
           }
   return null;
}

// struct.js -->

<!-- extracted from colordb.js

function _pm_colordb_mkdef(){
   var a = this;
   a.aliceblue = "f0f8ff"; a.antiquewhite = "faebd7"; a.aqua = "00ffff";
   a.aquamarine = "7fffd4"; a.azure = "f0ffff"; a.beige = "f5f5dc";
   a.bisque = "ffe4c4"; a.black = "000000"; a.blanchedalmond = "ffebcd";
   a.blue = "0000ff"; a.blueviolet = "8a2be2"; a.brown = "a52a2a";
   a.burlywood = "deb887"; a.cadetblue = "5f9ea0"; a.chartreuse = "7fff00";
   a.chocolate = "d2691e"; a.coral = "ff7f50"; a.cornflowerblue = "6495ed";
   a.cornsilk = "fff8dc"; a.crimson = "dc143c"; a.cyan = "00ffff";
   a.darkblue = "00008b"; a.darkcyan = "008b8b"; a.darkgoldenrod = "b8860b";
   a.darkgray = "a9a9a9"; a.darkgreen = "006400"; a.darkkhaki = "bdb76b";
   a.darkmagenta = "8b008b"; a.darkolivegreen = "556b2f";
   a.darkorange = "ff8c00"; a.darkorchid = "9932cc"; a.darkred = "8b0000";
   a.darksalmon = "e9967a"; a.darkseagreen = "8fbc8f";
   a.darkslateblue = "483d8b"; a.darkslategray = "2f4f4f";
   a.darkturquoise = "00ced1"; a.darkviolet = "9400d3"; a.deeppink = "ff1493";
   a.deepskyblue = "00bfff"; a.dimgray = "696969"; a.dodgerblue = "1e90ff";
   a.firebrick = "b22222"; a.floralwhite = "fffaf0"; a.forestgreen = "228b22";
   a.fuchsia = "ff00ff"; a.gainsboro = "dcdcdc"; a.ghostwhite = "f8f8ff";
   a.gold = "ffd700"; a.goldenrod = "daa520"; a.gray = "808080";
   a.green = "008000"; a.greenyellow = "adff2f"; a.honeydew = "f0fff0";
   a.hotpink = "ff69b4"; a.indianred = "cd5c5c"; a.indigo = "4b0082";
   a.ivory = "fffff0"; a.khaki = "f0e68c"; a.lavender = "e6e6fa";
   a.lavenderblush = "fff0f5"; a.lawngreen = "7cfc00";
   a.lemonchiffon = "fffacd"; a.lightblue = "add8e6"; a.lightcoral = "f08080";
   a.lightcyan = "e0ffff"; a.lightgoldenrodyellow = "fafad2";
   a.lightgreen = "90ee90"; a.lightgrey = "d3d3d3"; a.lightpink = "ffb6c1";
   a.lightsalmon = "ffa07a"; a.lightseagreen = "20b2aa";
   a.lightskyblue = "87cefa"; a.lightslategray = "778899";
   a.lightsteelblue = "b0c4de"; a.lightyellow = "ffffe0"; a.lime = "00ff00";
   a.limegreen = "32cd32"; a.linen = "faf0e6"; a.magenta = "ff00ff";
   a.maroon = "800000"; a.mediumaquamarine = "66cdaa"; a.mediumblue = "0000cd";
   a.mediumorchid = "ba55d3"; a.mediumpurple = "9370db";
   a.mediumseagreen = "3cb371"; a.mediumslateblue = "7b68ee";
   a.mediumspringgreen = "00fa9a"; a.mediumturquoise = "48d1cc";
   a.mediumvioletred = "c71585"; a.midnightblue = "191970";
   a.mintcream = "f5fffa"; a.mistyrose = "ffe4e1"; a.moccasin = "ffe4b5";
   a.navajowhite = "ffdead"; a.navy = "000080"; a.oldlace = "fdf5e6";
   a.olive = "808000"; a.olivedrab = "6b8e23"; a.orange = "ffa500";
   a.orangered = "ff4500"; a.orchid = "da70d6"; a.palegoldenrod = "eee8aa";
   a.palegreen = "98fb98"; a.paleturquoise = "afeeee";
   a.palevioletred = "db7093"; a.papayawhip = "ffefd5"; a.peachpuff = "ffdab9";
   a.peru = "cd853f"; a.pink = "ffc0cb"; a.plum = "dda0dd";
   a.powderblue = "b0e0e6"; a.purple = "800080"; a.red = "ff0000";
   a.rosybrown = "bc8f8f"; a.royalblue = "4169e1"; a.saddlebrown = "8b4513";
   a.salmon = "fa8072"; a.sandybrown = "f4a460"; a.seagreen = "2e8b57";
   a.seashell = "fff5ee"; a.sienna = "a0522d"; a.silver = "c0c0c0";
   a.skyblue = "87ceeb"; a.slateblue = "6a5acd"; a.slategray = "708090";
   a.snow = "fffafa"; a.springgreen = "00ff7f"; a.steelblue = "4682b4";
   a.tan = "d2b48c"; a.teal = "008080"; a.thistle = "d8bfd8";
   a.tomato = "ff6347"; a.turquoise = "40e0d0"; a.violet = "ee82ee";
   a.wheat = "f5deb3"; a.white = "ffffff"; a.whitesmoke = "f5f5f5";
   a.yellow = "ffff00"; a.yellowgreen = "9acd32";
   return a;
}

function _pm_colordb_lookup(name,defval){
    var val;
    if((val = this.colors[name]) != null)
        return val;
    return defval;
}

function _pm_colordb_rgbval(name,defval){
    var value
    if(name.charAt(0) == ''){
        if(name.length != 7)
             return defval;
        name = name.substring(1,7);
    } else {
        if((value = this.colors[name]) != null)
            return parseInt(value,16);
        if(name.length != 6)
             return defval;
    }
    // this is not really correct.
    if(((value = parseInt(name,16)) != 0)||(name == "000000"))
        return value;
    return defval;
}
function _pm_colordb_define(name,value){
    if(this._vanilla == true){
        // it will be much better if we can clone method.
        this.colors = new _pm_colordb_mkdef();
        this._vanilla = false;
    }
    if(this.colors[name] != null)
        this.ncolor--;
    if(value != null)
        this.ncolor++;
    this.colors[name] = value;
}

function _pm_colordb_toarray(cmp_fun){
    var colorv = new pm_array(this.ncolor);
    var colors = this.colors;
    var color, cid = 0;
    for(color in colors)
        if(colors[color] != null)
           colorv[++cid] = color;
    /*
    if(cmp_fun != null)
        pm_array_qsort(colorv,1,cid,cmp_fun,this);
     */
    return colorv;
}

var _pm_colordb_def = null;
function pm_colordb(){
    if(_pm_colordb_def == null)
        _pm_colordb_def = new _pm_colordb_mkdef();
    this._vanilla= true;
    this.colors  = _pm_colordb_def;
    this.ncolor  = 140;
    this.lookup  = _pm_colordb_lookup;
    this.define  = _pm_colordb_lookup;
    this.rgbval  = _pm_colordb_rgbval;
    this.toArray = _pm_colordb_toarray;
}

// -->
<!--

var colordb = new pm_colordb();
colordb.define("aliceblue",null);

function get_color(text,literal){
    var code, color = get_value("text",text);
    if(!literal && (color.charAt(0) != '#'))
        if((code = colordb.lookup(color,null)) != null)
            return '' + code;
    return color;
}

function repaint(form){
    if(frames["display"] == null)
        return;
    var doc     = frames['display'].document;
    var literal = form.literal.checked ? true  : false;
    var mindeco = form.mindeco.checked ? true  : false;
    var bgcolor = get_color(form.bgcolor,literal);
    var fgcolor = get_color(form.text,literal);
    var ulcolor = get_color(form.link,literal);
    var vlcolor = get_color(form.vlink,literal);
    var sample  = get_value("text",form.sample);
    doc.close(); // just to be safe
    doc.open("text/html");
    doc.write(
        '<html><head>\n' +
        '<title>Un Selector de Background en JavaScript</title>\n' +
        '</head><body bgcolor="' + bgcolor + '" text="' + fgcolor + '">\n');
    if(!mindeco) doc.write(
        '<h5>A Background Selector in JavaScript\n' +
        '<hr noshade size=2>\n</h5>\n');
    doc.write(
        '<table>\n' +
        '<tr><th align=right>&lt;body bgcolor</th><th>=</th><th><tt>"' +
                 bgcolor + '"</tt></th></tr>\n' +
        '<tr><th align=right>text</th><th>=</th><th><tt>"' +
                 fgcolor + '"</tt></th><th> </th><td>...</td><td>' +
                 '<font color="' + fgcolor + '">' + sample + '</font>' +
             '</td></tr>\n' +
        '<tr><th align=right>link</th><th>=</th><th><tt>"' +
                 ulcolor + '"</tt></th><th> </th><td>...</td><td>' +
                 '<a href="http://a-never-visited-site/">' +
                 '<font color="' + ulcolor + '">' + sample + '</font></a>' +
             '</td></tr>\n' +
        '<tr><th align=right>vlink</th><th>=</th><th><tt>"' +
                 vlcolor + '"</tt></th><th>&gt;</th><td>...</td><td>' +
                 '<a href="http://a-site-visited-before/">' +
                 '<font color="' + vlcolor + '">' + sample + '</font></a>' +
             '</td></tr>\n' +
        '</table>\n<br>\n');
    if(!mindeco) doc.write(
        '<div align=right>\n<hr noshade size=2>\n' +
        '<font <i>eillihca@drizzle.stanford.edu</i>' +
        ' (<strong>Achille Hui</strong>)\n</div>\n</font>');
    doc.write(
        '</body>\n</html>\n');
    doc.close();
}
// -->
<!-- should I put make this into a module

var _pm_handler_list = null;
function pm_bind(id,handler){
    if(_pm_handler_list != null){
        pm_finditem(_pm_handler_list,id,true);
    } else {
        _pm_handler_list = new pm_list();
    }
    pm_pushitem(_pm_handler_list,id,handler,false)
}
function pm_recv(frame,id){
    var handler;
    if(frame != null)
        if((handler = pm_finditem(_pm_handler_list,id,false)) != null){
            var search = frame.location.search;
            var i      = search.indexOf(',');
            handler(parseInt(search.substring(1,i)),
                    parseInt(search.substring(i+1,search.length)));
        }
}
function pm_send(id){
    return '<body onLoad="parent.pm_recv(window,' + id  + ')">';
}
// -->
<!--
var _xy2rgb_coeff = null;
function xy2rgb_init(force){
    if(force || (_xy2rgb_coeff == null))
        _xy2rgb_coeff = pm_toarray(
            0.0,  255.0,    0.0,  -0.5,   0.8660254,
            0.0,  255.0,  255.0,  -1.0,   0.0,
            0.0,    0.0,  255.0,  -0.5,  -0.8660254,
          255.0,    0.0,  255.0,   0.5,  -0.8660254,
          255.0,    0.0,    0.0,   1.0,   0.0,
          255.0,  255.0,    0.0,   0.5,   0.8660254,
            0.0,  255.0,    0.0,  -0.5,   0.8660254,
            0.0,  255.0,  255.0,  -1.0,   0.0,
            0.0,    0.0,  255.0,  -0.5,  -0.8660254);
}

function xy2rgb_getvalue(x,y,flipped){
    var t, i, d, best_i, best_d;
    var r, g, b;

    if(flipped){
        t = x; x = y; y = t;
    }

    for(i = 0; i < 6; i++){
        t  = x - ((i & 1) ? 153 : 61);
        d  = t * t;
        t  = y - 53 * (i + 1);
        d += t * t;
        if((i == 0)||(d < best_d)){
            best_i = i;
            best_d = d;
        }
    }
    x -= ((best_i & 1) ? 153 : 61);
    y -= 53 * (best_i + 1);
    d  = 255 - 51 * best_i;
    x  =  x/60.0;
    y  = -y/60.0;

    r = g = b = d;
    if(x * x + y * y > 1.0e-6){

        xy2rgb_init(false);

        var f, i, j, k, p, s, t;
        var ax = (x < 0.0) ? -x : x;
        var ay = (y < 0.0) ? -y : y;
        var th = (ay <= ax) ?
            Math.atan(ay/ax) : ((0.5*Math.PI) - Math.atan(ax/ay));
        if(x < 0.0)
            th = Math.PI - th;
        if(y < 0.0)
            th = -th;

        f  = 4.0 + 0.95492965855137202 * th;
        i  = Math.floor(f);
        f -= i;
        i  = 5*i+1;
        p  = new Object();
        for(j = 0; j < 8; j++)
            p[j] = _xy2rgb_coeff[i+j];
        t =  p[3] * x + p[4] * y;
        y = -p[4] * x + p[3] * y;
        x =  t;
        t =  x + 0.5773503 * y;
        if((t < 0.0)||(t > 1.0))
            return null;
        f = 0.5000000 * (1.0 - x) + 0.8660254 * y;
        f = (f < 0.0) ? 0.0 : ((f > 1.0) ? 1.0 : f);
        k = Math.round(t*(f*p[5] + (1.0-f)*p[0]) + (1.0-t)*d);
        r = (k < 0) ? 0 : ((k > 255) ? 255 : k);
        k = Math.round(t*(f*p[6] + (1.0-f)*p[1]) + (1.0-t)*d);
        g = (k < 0) ? 0 : ((k > 255) ? 255 : k);
        k = Math.round(t*(f*p[7] + (1.0-f)*p[2]) + (1.0-t)*d);
        b = (k < 0) ? 0 : ((k > 255) ? 255 : k);
    }
    var h = "0123456789abcdef";
    return "" + h.charAt((r>>4)&0x0f) + h.charAt(r&0x0f) +
                 h.charAt((g>>4)&0x0f) + h.charAt(g&0x0f) +
                 h.charAt((b>>4)&0x0f) + h.charAt(b&0x0f);
}

function xy2rgb_repaint(x,y){
    var frame, main, active, value;
    if((frame = frames["main"]) != null)
        if((main = frame.document.forms[0]) != null)
            if((active = get_value("radio",main.active)) != null)
                if((value = xy2rgb_getvalue(x,y,true)) != null){
                    main[active].value = value;
                    repaint(main);
                }
}

function colordb_repaint(form){
    var frame, main, active, value;
    if((frame = frames["main"]) != null)
        if((main = frame.document.forms[0]) != null)
            if((active = get_value("radio",main.active)) != null)
                if((value = get_value("radio",form.color)) != null){
                    main[active].value = value;
                    repaint(main);
                }
}
// -->
<!-- stuff specific to this script

function getbase(){
    var tmp = location.pathname;
    if(tmp.substring(0,2) != "/~"){
        return "/";
    } else {
        tmp = tmp.substring(2);
        if((i = tmp.indexOf("/")) >= 0)
            tmp = tmp.substring(0,i);
        return "/~" + tmp + "/";
    }
}
var base = getbase();
var tar_to_url = pm_toarray(
        "home",base,
        "orig",'/nph-maps' + base + 'html/hack1/bgcolor',
        "ww3", 'http://ww3.caboose.com/',
        "www", 'http://www.caboose.com/');

function jumpto(elem){
    var tar = "" + get_value("select",elem);
    if(tar == "back"){
        history.back();
    } else {
        for(var i = 1; i < tar_to_url.length; i += 2)
            if(tar == tar_to_url[i]){
                location.href = tar_to_url[i+1];
                break;
            }
   }
}

var empty   = '\n';
var loading = '<body bgcolor="#FFFFFF" text="#000000"><h2>Cargando nombres de colores un momento please....</h2>\n';
var loading2 = '<body bgcolor="#FFFFFF" text="#000000"><h2>Elija colores y actualice....</h2>\n';
var ctrlbox = loading;
var loaded  = false;

function init(){
    pm_bind(1,xy2rgb_repaint);
    var colorv = colordb.toArray(null);
    var i, j = colorv.length, rown = 0, coln = 0;
    if(!loaded){
        ctrlbox =
            '<html><head>\n' +
            '<title>A Background Selector in JavaScript (Control)</title>\n' +
            '</head><body bgcolor="#123456" text="#ffffff">\n' +
            '<form>\n<table>\n<tr>\n';
        for(i = 1; i <= j; i++){
            color = colorv[i];
            if((coln == 0) && (rown != 0))
                ctrlbox += '</tr><tr>\n';
            ctrlbox +=
'    <th align=left>\n' +
'        <input type="radio" name="color" value="' + color + '"\n' +
'               onClick="parent.colordb_repaint(this.form);"\n' +
'        >&nbsp;<font color="' + color + '">' + color + '</font></th>\n';
            if(++coln == 4){
                coln = 0; rown++;
            }
        }
        ctrlbox += '</tr>\n</table>\n</form>\n</body>\n</html>\n';
        loaded = true;
        frames['ctrl'].location = 'javascript:parent.ctrlbox';
    }
}
// -->

</script>
</head>
<frameset rows="29%,69%,1%,1%" onLoad="init()">
   <frame src="javascript:parent.loading2" name="display">
   <frame src="<CFOUTPUT>#HTTP_string#://#DomainName##CFMLTemplate##Root#/admin/company/color/bgcolor/main.cfm#ID_String#</CFOUTPUT>"  name="main">
   <frame src="javascript:parent.loading" name="ctrl">
   <frame src="javascript:parent.empty" name="board">
<noframes>
<h1>A Background Selector in JavaScript</h1>
This is a background selector in JavaScript, if you don't have
Netscape 2.0 (beta 5 or later), forget this cool page.
</noframes>
</frameset></html>