<!---  Copy the Catagories --->

<CFIF #ParameterExists(form.a4)# is "Yes">

    <!--- Get all of the Catagories from the company that we are copying --->

    <CFQUERY NAME="GetCategoriesToCopy" DATASOURCE="#Form.CopyFrom_DS#">
            SELECT * FROM Categories WHERE Company_ID = #form.CopyCompany_ID#
    </CFQUERY>

    <!--- Set a counter for dynamic Query names. --->

    <CFPARAM NAME="CategoryCount" DEFAULT="0">

    <!--- Need to keep track of the old Category_ID so that we --->
    <!--- can attach copies of Groups if they are selected.    --->
    <!--- Also setting up some variables for looping across    --->
    <!--- large datasets.                                       --->

    <CFIF ParameterExists(form.OldCategory_ID_List) is "NO">
        <CFPARAM NAME="OldCategory_ID_List" DEFAULT="">
    <CFELSE>
        <CFSET #OldCategory_ID_List# = #form.OldCategory_ID_List#>
    </CFIF>
    <CFIF ParameterExists(form.NewCategory_ID_List) is "NO">
        <CFPARAM NAME="NewCategory_ID_List" DEFAULT="">
    <CFELSE>
        <CFSET #NewCategory_ID_List# = #form.NewCategory_ID_List#>
    </CFIF>
    <CFIF ParameterExists(form.CatStart) is "NO">
        <CFSET #CatStart# = 1>
    <CFELSE>
        <CFSET #CatStart# = #form.CatStart#>
    </CFIF>
    <CFIF ParameterExists(form.CatStop) is "NO">
        <CFSET #CatStop# = 40>
    <CFELSE>
        <CFSET #CatStop# = #form.CatStop#>
    </CFIF>
    <CFIF #CatStop# GTE #GetCategoriesToCopy.RecordCount#>
        <CFSET #CatStop# = #GetCategoriesToCopy.RecordCount#>
    </CFIF>


    <CFTRANSACTION>

        <!--- Loop across the results of the Catagories query and     --->
        <!--- insert them into the database                           --->

        <CFLOOP QUERY="GetCategoriesToCopy" STARTROW="#CatStart#" ENDROW="#CatStop#">
            <CFSET #CategoryCount# = #CategoryCount# + 1>
            <CFQUERY NAME="C#CategoryCount#" DATASOURCE="#form.CopyTo_DS#">
                    INSERT INTO Categories (Company_ID, CategoryTitle, CategoryDescription,
                                            OrderByString, CategoryPageOptions,

                                            <CFIF TRIM(TableBorderValue) is not "">
                                                TableBorderValue,
                                            </CFIF>

                                            <CFIF TRIM(CategoryIconWidth) is not "">
                                                CategoryIconWidth,
                                            </CFIF>

                                            <CFIF TRIM(CategoryIconHeight) is not "">
                                                CategoryIconHeight,
                                            </CFIF>

                                            CategoryIcon)

                            VALUES (#form.MaxCompany_ID#, '#GetCategoriesToCopy.CategoryTitle#', '#GetCategoriesToCopy.CategoryDescription#',
                            '#GetCategoriesToCopy.OrderByString#', '#GetCategoriesToCopy.CategoryPageOptions#',

                                            <CFIF TRIM(TableBorderValue) is not "">
                                                 #GetCategoriesToCopy.TableBorderValue#,
                                            </CFIF>

                                            <CFIF TRIM(CategoryIconWidth) is not "">
                                                #GetCategoriesToCopy.CategoryIconWidth#,
                                            </CFIF>

                                            <CFIF TRIM(CategoryIconHeight) is not "">
                                                #GetCategoriesToCopy.CategoryIconHeight#,
                                            </CFIF>

                                                '#GetCategoriesToCopy.CategoryIcon#')
            </CFQUERY>

            <!--- Find out the ID of the first Category inserted --->

            <CFIF #CategoryCount# is 1>
                <CFQUERY NAME="GetCurrentMaxCategory" DATASOURCE="#form.CopyTo_DS#">
                        SELECT Max(Category_ID) As MaxCategory_ID
                        FROM Categories
                </CFQUERY>
            </CFIF>
            <!--- We want the MaxCat_ID to actually be one more than the first.--->

            <CFSET #MaxCat_ID# = #GetCurrentMaxCategory.MaxCategory_ID# - 1>

            <!--- Building the look-up lists for attaching groups --->

            <CFSET #OldCategory_ID_List# = ListAppend("#OldCategory_ID_List#", "#GetCategoriesToCopy.Category_ID#")>
            <CFSET #NewCat_ID# = #MaxCat_ID# + #CategoryCount#>
            <CFSET #NewCategory_ID_List# = ListAppend("#NewCategory_ID_List#", "#NewCat_ID#")>
        </CFLOOP>

    </CFTRANSACTION>

    <HTML>
    <HEAD>
    <title>Copy Categories</title>
    </HEAD>

    <BODY bgcolor = "#ff ff ff">

    <CENTER>


    <CFIF #GetCategoriesToCopy.RecordCount# GT #CatStop#>
        <FORM ACTION = "copy4.cfm" METHOD=post>
        <INPUT TYPE=hidden NAME="a4" VALUE="1">
        <CFSET #finished# = 0>

        <CFSET #last# = #CatStop#>
        <CFSET #CatStart# = #CatStart# + 40>
        <CFSET #CatStop# = #CatStop# + 40>

    <CFELSE>
        <CFIF #GetCategoriesToCopy.RecordCount# is 0>
            <FORM ACTION = "copy9.cfm" METHOD=post>
        <CFELSE>
            <FORM ACTION = "copy5.cfm" METHOD=post>
        </CFIF>
        <CFSET #finished# = 1>
    </CFIF>

    <CFOUTPUT>
        <INPUT TYPE=hidden NAME="CatStart" VALUE="#CatStart#">
        <INPUT TYPE=hidden NAME="CatStop" VALUE="#CatStop#">
        <INPUT TYPE=hidden NAME="OldCategory_ID_List" VALUE="#OldCategory_ID_List#">
        <INPUT TYPE=hidden NAME="NewCategory_ID_List" VALUE="#NewCategory_ID_List#">
    </CFOUTPUT>

<CFELSE>
    <HTML>
    <HEAD>
    <title>Copy Categories</title>
    </HEAD>

    <BODY bgcolor = "#ff ff ff">

    <CENTER>

    <FORM ACTION = "copy5.cfm" METHOD=post>
    <CFSET #finished# = 2>

</CFIF>

<TABLE WIDTH=350 BORDER=1 CELLPADDING=2 CELLSPACING=2 ALIGN=CENTER>
<TR>
<TD ALIGN="center" BGCOLOR="#cf cF cF">

    <FONT FACE=ARIAL COLOR="#000080"><B>Copy Categories</B></FONT>

</TD>
</TR>

<TR>
<TD ALIGN=Center VALIGN="TOP">
    <FONT FACE=ARIAL COLOR="#000080">

    <CFIF #finished# is 2>
        Categories not selected for copy
    <CFELSE>
        <CFIF #finished# is 1>
            Finished copying Categories
        <CFELSE>
            Continue copying Categories<BR>
            <CFOUTPUT>
                <FONT FACE=ARIAL SIZE=2>[ #last# of #GetCategoriesToCopy.RecordCount# complete ]</FONT>
            </CFOUTPUT>
        </CFIF>
    </CFIF>

    </FONT>
</TD>
</TR>
<TR>
<TD align=center BGCOLOR="#cf cF cF" VALIGN="TOP">
<CFOUTPUT>
    <INPUT TYPE=hidden NAME="CopyCompany_ID" VALUE="#form.CopyCompany_ID#">
    <INPUT TYPE=hidden NAME="CopyFrom_DS" VALUE="#form.CopyFrom_DS#">
    <INPUT TYPE=hidden NAME="CopyTo_DS" VALUE="#form.CopyTo_DS#">
    <INPUT TYPE=hidden NAME="MaxCompany_ID" VALUE="#form.MaxCompany_ID#">
    <INPUT TYPE=hidden NAME="CopyIntoDS_ID" VALUE="#form.CopyIntoDS_ID#">
    <CFIF ParameterExists(OldCategory_ID_List) is "NO">
        <INPUT TYPE=hidden NAME="OldCategory_ID_List" VALUE="">
    </CFIF>
    <CFIF ParameterExists(NewCategory_ID_List) is "NO">
        <INPUT TYPE=hidden NAME="NewCategory_ID_List" VALUE="">
    </CFIF>

    <CFIF #ParameterExists(form.a5)# is "Yes">
        <INPUT TYPE=hidden NAME="a5" VALUE="1">
    </CFIF>
    <CFIF #ParameterExists(form.a6)# is "Yes">
        <INPUT TYPE=hidden NAME="a6" VALUE="1">
    </CFIF>
    <CFIF #ParameterExists(form.a3)# is "Yes">
        <INPUT TYPE=hidden NAME="a3" VALUE="1">
    </CFIF>
    <CFIF #ParameterExists(form.a2)# is "Yes">
        <INPUT TYPE=hidden NAME="a2" VALUE="1">
    </CFIF>
    <INPUT TYPE=submit VALUE="Continue">

</CFOUTPUT>

</TD>
</TR>
</TABLE>
</CENTER>
</FORM>
</BODY>
</HTML>