/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.uploadlist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractListModel;
import ning.uploader.model.UploadItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadListModel
extends AbstractListModel
implements Iterable<UploadItem> {
    private List<UploadItem> backingList = new CopyOnWriteArrayList<UploadItem>();

    @Override
    public int getSize() {
        return this.backingList.size();
    }

    public synchronized void addElementsAt(int index, UploadItem ... values) {
        this.addElementsAt(index, Arrays.asList(values));
    }

    public synchronized void addElementsAt(int index, List<UploadItem> values) {
        index = this.constrain(index, 0, this.backingList.size());
        this.backingList.addAll(index, values);
        this.fireIntervalAdded(this, index, index + values.size() - 1);
    }

    public synchronized void removeElements(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            int index = indices[i];
            if (index < 0 || index > this.backingList.size()) continue;
            this.backingList.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public synchronized void moveElementsTo(int insertionPoint, int[] indices) {
        insertionPoint = this.constrain(insertionPoint, 0, this.backingList.size());
        Arrays.sort(indices);
        ArrayList<UploadItem> elements = new ArrayList<UploadItem>();
        for (int i = indices.length - 1; i >= 0; --i) {
            int index = indices[i];
            if (insertionPoint >= index) {
                --insertionPoint;
            }
            elements.add(this.backingList.remove(index));
            this.fireIntervalRemoved(this, index, index);
        }
        insertionPoint = this.constrain(insertionPoint, 0, this.backingList.size() + 1);
        for (UploadItem element : elements) {
            this.backingList.add(insertionPoint, element);
            this.fireIntervalAdded(this, insertionPoint, insertionPoint);
        }
    }

    public int size() {
        return this.backingList.size();
    }

    @Override
    public synchronized Object getElementAt(int index) {
        index = this.constrain(index, 0, this.backingList.size() - 1);
        return this.backingList.get(index);
    }

    public synchronized void remove(UploadItem item) {
        int index = this.backingList.indexOf(item);
        if (index != -1) {
            this.removeElements(new int[]{index});
        }
    }

    @Override
    public Iterator<UploadItem> iterator() {
        final Iterator<UploadItem> baseIter = this.backingList.iterator();
        return new Iterator<UploadItem>(){
            private UploadItem current = null;

            @Override
            public boolean hasNext() {
                return baseIter.hasNext();
            }

            @Override
            public UploadItem next() {
                this.current = (UploadItem)baseIter.next();
                return this.current;
            }

            @Override
            public void remove() {
                UploadListModel.this.remove(this.current);
            }
        };
    }

    private int constrain(int i, int min, int max) {
        return i > max ? max : (i < min ? min : i);
    }
}

