/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import ning.uploader.swing.FourSidedBorder;

public class MessagePanel
extends JPanel {
    private final Pattern linkPattern = Pattern.compile("<a[^<]+</a>");
    private final JEditorPane htmlMessage;
    private final JLabel textMessage;

    public MessagePanel(String text, final HyperlinkListener listener) {
        super(new BorderLayout());
        this.setBorder(new FourSidedBorder(new Insets(0, 0, 1, 0), Color.WHITE));
        Font font = UIManager.getFont("TableHeader.font");
        if (font != null) {
            this.setFont(font.deriveFont(10.0f));
        }
        this.textMessage = new JLabel();
        this.textMessage.setFont(this.getFont());
        this.textMessage.setForeground(new Color(51, 51, 51));
        this.textMessage.setHorizontalAlignment(4);
        this.textMessage.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.htmlMessage = new JEditorPane("text/html", "");
        this.htmlMessage.setEditable(false);
        this.htmlMessage.setBackground(new Color(223, 223, 223));
        this.htmlMessage.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setText(text);
        this.htmlMessage.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent event) {
                listener.hyperlinkUpdate(event);
            }
        });
        JPanel paddingPanel = new JPanel(new BorderLayout());
        paddingPanel.setBorder(new FourSidedBorder(new Insets(0, 0, 1, 0), new Color(193, 193, 193)));
        paddingPanel.setBackground(new Color(223, 223, 223));
        paddingPanel.setOpaque(true);
        paddingPanel.add((Component)this.htmlMessage, "East");
        paddingPanel.add((Component)this.textMessage, "Center");
        this.add((Component)paddingPanel, "Center");
    }

    public void setText(String text) {
        if (text.contains("</a>")) {
            Matcher m = this.linkPattern.matcher(text);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, String.format("<font color='#0000FF'>%s</font>", m.group(0)));
            }
            m.appendTail(sb);
            text = sb.toString();
            text = String.format("<font face='%s' size='2' color='#333333'>%s</font>", this.getFont(), text);
            this.htmlMessage.setText(text);
            this.textMessage.setVisible(false);
            this.htmlMessage.setVisible(true);
        } else {
            this.textMessage.setText(text);
            this.textMessage.setVisible(true);
            this.htmlMessage.setVisible(false);
        }
    }
}

