/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.RootPaneContainer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Beardifier
extends JPanel {
    private final BufferedImage image;
    private final Graphics2D imageGraphics;
    private final JComponent canvas;
    private final Random rand = new Random();
    private int size = 15;
    private float[] hsb = new float[3];
    private Color color = new Color(10978620);
    private RootPaneContainer rootPane = null;
    private Component oldGlassPane = null;

    public Beardifier(final BufferedImage image) {
        super(new BorderLayout(), true);
        this.image = image;
        this.imageGraphics = image.createGraphics();
        this.imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.canvas = new JComponent(){

            protected void paintComponent(Graphics graphics) {
                Graphics2D g2 = (Graphics2D)graphics;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getWidth();
                int height = this.getHeight();
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, width, height);
                Rectangle bounds = Beardifier.this.getImageRect();
                g2.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, null);
            }
        };
        final MouseMotionAdapter motionAdapter = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent event) {
                for (int i = 0; i < 1; ++i) {
                    Point p = Beardifier.this.randomPointAround(Beardifier.this.convertCanvasToImage(event.getPoint()), (int)(1.5 * (double)Beardifier.this.size));
                    Beardifier.this.imageGraphics.setColor(Beardifier.this.randomBrightness(Beardifier.this.color));
                    Beardifier.this.imageGraphics.draw(Beardifier.this.createHair(p, Beardifier.this.size));
                    Beardifier.this.canvas.repaint();
                }
            }
        };
        this.canvas.setDoubleBuffered(true);
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if ((event.getModifiers() & 1) != 0) {
                    Point p = Beardifier.this.convertCanvasToImage(event.getPoint());
                    Beardifier.this.color = new Color(image.getRGB(p.x, p.y));
                } else {
                    motionAdapter.mouseDragged(event);
                    Beardifier.this.canvas.addMouseMotionListener(motionAdapter);
                }
            }

            public void mouseReleased(MouseEvent event) {
                Beardifier.this.canvas.removeMouseMotionListener(motionAdapter);
            }
        });
        final JSlider slider = new JSlider(1, 2, 50, this.size);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Beardifier.this.size = slider.getValue();
            }
        });
        JButton close = new JButton("close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Beardifier.this.detach();
            }
        });
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("Congratutalations, Paul Lloyd!"), "Center");
        topPanel.add((Component)close, "East");
        this.add((Component)topPanel, "North");
        this.add((Component)this.canvas, "Center");
        this.add((Component)slider, "East");
    }

    public void attach(Component c) {
        while (c != null && !(c instanceof RootPaneContainer)) {
            c = c.getParent();
        }
        if (c != null) {
            this.rootPane = (RootPaneContainer)((Object)c);
            this.oldGlassPane = this.rootPane.getGlassPane();
            this.rootPane.setGlassPane(this);
            this.setVisible(true);
        }
    }

    public void detach() {
        if (this.rootPane != null) {
            boolean visible = this.oldGlassPane.isVisible();
            this.rootPane.setGlassPane(this.oldGlassPane);
            this.oldGlassPane.setVisible(visible);
            this.rootPane = null;
        }
    }

    private Rectangle getImageRect() {
        int width = this.canvas.getWidth();
        int height = this.canvas.getHeight();
        int imageWidth = this.image.getWidth();
        int imageHeight = this.image.getHeight();
        if (imageHeight * width / imageWidth > height) {
            imageWidth = (int)((double)imageWidth * ((double)height / (double)imageHeight));
            imageHeight = height;
        } else {
            imageHeight = (int)((double)imageHeight * ((double)width / (double)imageWidth));
            imageWidth = width;
        }
        return new Rectangle((width - imageWidth) / 2, (height - imageHeight) / 2, imageWidth, imageHeight);
    }

    private Point convertCanvasToImage(Point canvasPoint) {
        Rectangle bounds = this.getImageRect();
        return new Point((canvasPoint.x - bounds.x) * this.image.getWidth() / (this.canvas.getWidth() - 2 * bounds.x), (canvasPoint.y - bounds.y) * this.image.getHeight() / (this.canvas.getHeight() - 2 * bounds.y));
    }

    private GeneralPath createHair(Point p, int size) {
        GeneralPath path = new GeneralPath();
        Point p1 = this.randomPointAround(p, size);
        Point p2 = this.randomPointAround(p, size);
        Point p3 = this.randomPointAround(p, size);
        Point p4 = this.randomPointAround(p, size);
        path.moveTo(p1.x, p1.y);
        path.curveTo(p2.x, p2.y, p3.x, p3.y, p4.x, p4.y);
        return path;
    }

    private Point randomPointAround(Point p, int size) {
        int radius = this.rand.nextInt(size);
        double angle = this.rand.nextDouble() * 2.0 * Math.PI;
        return new Point((int)((double)p.x + (double)radius * Math.cos(angle)), (int)((double)p.y + (double)radius * Math.sin(angle)));
    }

    private Color randomBrightness(Color baseColor) {
        Color.RGBtoHSB(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), this.hsb);
        this.hsb[2] = (float)((double)this.hsb[2] * ((double)(this.rand.nextFloat() / 2.0f) + 0.5));
        int rgb = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
        return new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, 127 + this.rand.nextInt(64));
    }
}

