/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ImageIcon;
import ning.uploader.icon.ScaledFileIcon;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconCreator {
    private static final Logger log = Logger.getLogger(IconCreator.class);
    private final Map<Key, ImageIcon> iconMap = new HashMap<Key, ImageIcon>();
    private final Map<Key, List<IconListener>> pendingListeners = new HashMap<Key, List<IconListener>>();
    private final Set<ScalingParameters> registeredParameters = new CopyOnWriteArraySet<ScalingParameters>();
    private ExecutorService executor = Executors.newFixedThreadPool(3);

    public void registerParameters(ScalingParameters params) {
        this.registeredParameters.add(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageIcon getIcon(File file, ScalingParameters params, ImageIcon defaultIcon, ImageIcon errorIcon, IconListener listener) {
        boolean isPending;
        Key key = new Key(file, params);
        Map<Key, ImageIcon> map = this.iconMap;
        synchronized (map) {
            ImageIcon icon = this.iconMap.get(key);
            if (icon != null) {
                return icon;
            }
            Map<Key, List<IconListener>> map2 = this.pendingListeners;
            synchronized (map2) {
                List<IconListener> listeners = this.pendingListeners.get(key);
                if (listeners == null) {
                    listeners = new ArrayList<IconListener>();
                    this.pendingListeners.put(key, listeners);
                    isPending = false;
                } else {
                    isPending = true;
                }
                listeners.add(listener);
            }
        }
        if (!isPending) {
            this.createIcon(file, params, errorIcon);
            for (ScalingParameters p : this.registeredParameters) {
                if (p.equals(params)) continue;
                this.createIcon(file, p, errorIcon);
            }
        }
        return defaultIcon;
    }

    private void createIcon(final File file, final ScalingParameters params, final ImageIcon errorIcon) {
        this.executor.submit(new Runnable(){

            public void run() {
                try {
                    ScaledFileIcon icon = new ScaledFileIcon(file, params);
                    log.debug("Notifying of icon creation");
                    IconCreator.this.notifyListeners(new Key(file, params), IconCreator.this.iconMap, icon);
                }
                catch (Exception e) {
                    log.warn(String.format("Icon creation failed for %s", file), e);
                    IconCreator.this.notifyListeners(new Key(file, params), IconCreator.this.iconMap, errorIcon);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Key key, Map<Key, ImageIcon> iconMap, ImageIcon icon) {
        List<IconListener> listeners;
        Map<Key, ImageIcon> map = iconMap;
        synchronized (map) {
            iconMap.put(key, icon);
            Map<Key, List<IconListener>> map2 = this.pendingListeners;
            synchronized (map2) {
                listeners = this.pendingListeners.get(key);
                this.pendingListeners.remove(key);
            }
        }
        if (listeners != null) {
            for (IconListener listener : listeners) {
                listener.iconUpdated(icon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<Key, ImageIcon> map = this.iconMap;
        synchronized (map) {
            this.iconMap.clear();
        }
    }

    private static class Key {
        private final File file;
        private final ScalingParameters params;

        public Key(File file, ScalingParameters params) {
            this.file = file;
            this.params = params;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return !(this.file == null ? key.file != null : !this.file.equals(key.file)) && !(this.params == null ? key.params != null : !this.params.equals(key.params));
        }

        public int hashCode() {
            int result = this.file != null ? this.file.hashCode() : 0;
            result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
            return result;
        }
    }

    public static interface IconListener {
        public void iconUpdated(ImageIcon var1);
    }
}

