/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.model;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import ning.uploader.UploaderApplet;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.model.property.Property;
import ning.uploader.resources.IconCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadItem {
    private String name;
    private File file;
    private boolean isImage;
    private ImageIcon defaultIcon;
    private ImageIcon errorIcon;
    private final UploaderApplet.Type type;
    private final Map<Property, Object> properties = new LinkedHashMap<Property, Object>();

    public static String generateNameForFile(File file) {
        String name = file == null ? "" : file.getName();
        int extensionIndex = name.lastIndexOf(".");
        if (extensionIndex != -1) {
            name = name.substring(0, extensionIndex);
        }
        name = name.replace('_', ' ');
        return name;
    }

    public UploadItem(UploaderApplet.Type type, File file, ImageIcon defaultIcon, ImageIcon errorIcon, boolean isImage) {
        this(type, UploadItem.generateNameForFile(file), file, defaultIcon, errorIcon, isImage);
    }

    public UploadItem(UploaderApplet.Type type, String name, File file, ImageIcon defaultIcon, ImageIcon errorIcon, boolean isImage) {
        this.type = type;
        this.name = name;
        this.file = file;
        this.isImage = isImage;
        this.defaultIcon = defaultIcon;
        this.errorIcon = errorIcon;
    }

    public UploaderApplet.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public long getSize() {
        return this.file.length();
    }

    public boolean isImage() {
        return this.isImage;
    }

    public String toString() {
        return this.name;
    }

    public String get(Property property) {
        Object result = this.properties.get((Object)property);
        return result == null ? "" : result.toString();
    }

    public <T> T get(Property property, Class<T> clazz) {
        Object result = this.properties.get((Object)property);
        return clazz.cast(result);
    }

    public void set(Property property, Object value) {
        if (value != null && !property.isCompatibleWith(value.getClass())) {
            throw new ClassCastException(String.format("Expected %s but got %s", property.getClazz(), value.getClass()));
        }
        this.properties.put(property, value);
    }

    public Map<String, String> getPostParameters() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<Property, Object> entry : this.properties.entrySet()) {
            Object value = entry.getValue();
            String postValue = "";
            if (value != null) {
                postValue = value.toString();
            }
            result.put(entry.getKey().getPostParameter(), postValue);
        }
        return result;
    }

    public ImageIcon getIcon(IconCreator creator, ScalingParameters iconParams, IconCreator.IconListener listener) {
        return this.isImage ? creator.getIcon(this.file, iconParams, this.defaultIcon, this.errorIcon, listener) : this.defaultIcon;
    }
}

