/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.model;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import ning.uploader.UploaderApplet;
import ning.uploader.model.UploadItem;
import ning.uploader.model.UploadItemFactory;
import ning.uploader.model.property.Property;
import ning.uploader.model.property.Visibility;
import ning.uploader.resources.ResourceLoader;

public class PhotoItemFactory
implements UploadItemFactory {
    private static final DataFlavor JAVA_IMAGE_FLAVOR = new DataFlavor("image/x-java-image; class=java.awt.Image", "image/x-java-image");
    private static final DataFlavor[] IMAGE_FLAVORS = new DataFlavor[]{DataFlavor.javaFileListFlavor, JAVA_IMAGE_FLAVOR};
    private static final ImageIcon DEFAULT_ICON = new ImageIcon(ResourceLoader.getUrlFor("spinner.gif"));
    private static final ImageIcon ERROR_ICON = new ImageIcon(ResourceLoader.getUrlFor("file-photo.png"));

    public UploadItem createItem(File file) {
        UploadItem item = new UploadItem(UploaderApplet.Type.PHOTOS, file, DEFAULT_ICON, ERROR_ICON, true);
        item.set(Property.TITLE, item.getName());
        item.set(Property.VISIBILITY, (Object)Visibility.ALL);
        return item;
    }

    public UploadItem createItem(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (transferable.isDataFlavorSupported(JAVA_IMAGE_FLAVOR)) {
            File tempFile = File.createTempFile("uploader", "tmp");
            System.out.println(tempFile.getAbsolutePath());
            tempFile.deleteOnExit();
            Image image = (Image)transferable.getTransferData(JAVA_IMAGE_FLAVOR);
            if (image instanceof RenderedImage) {
                ImageIO.write((RenderedImage)((Object)image), "png", tempFile);
                return new UploadItem(UploaderApplet.Type.PHOTOS, "", tempFile, DEFAULT_ICON, ERROR_ICON, true);
            }
        }
        return null;
    }

    public DataFlavor[] getSupportedFlavors() {
        return IMAGE_FLAVORS;
    }
}

