/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.info;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ning.uploader.info.AttributeComponentCreator;

public class FileAttributeList
extends JPanel {
    private final GridBagConstraints c = new GridBagConstraints();
    private final AttributeComponentCreator componentCreator;
    private Font nameFont;
    private Font valueFont;

    public FileAttributeList(AttributeComponentCreator componentCreator, Insets insets) {
        super(new GridBagLayout());
        this.c.insets = insets;
        this.c.fill = 2;
        this.componentCreator = componentCreator;
    }

    public FileAttributeList(AttributeComponentCreator componentCreator) {
        this(componentCreator, new Insets(0, 2, 0, 2));
    }

    public void setFont(Font nameFont, Font valueFont) {
        this.nameFont = nameFont;
        this.valueFont = valueFont;
    }

    public void addComponent(String name, JComponent component) {
        this.c.ipadx = 5;
        this.c.weightx = 0.0;
        this.c.gridwidth = 1;
        JComponent nameComponent = this.componentCreator.createNameComponent(name, null);
        if (this.nameFont != null) {
            nameComponent.setFont(this.nameFont);
        }
        this.add((Component)nameComponent, this.c);
        this.c.ipadx = 0;
        this.c.weightx = 1.0;
        this.c.gridwidth = 0;
        JComponent valueComponent = this.componentCreator.createValueComponent(name, component);
        if (this.valueFont != null) {
            valueComponent.setFont(this.valueFont);
        }
        this.add((Component)valueComponent, this.c);
    }

    public void addComponent(JComponent component) {
        this.c.gridwidth = 2;
        this.c.gridwidth = 0;
        JComponent valueComponent = this.componentCreator.createValueComponent(component);
        if (this.valueFont != null) {
            valueComponent.setFont(this.valueFont);
        }
        this.add((Component)valueComponent, this.c);
        this.c.gridwidth = 1;
    }

    public void addAttribute(String name, String value) {
        this.c.ipadx = 5;
        this.c.weightx = 0.0;
        this.c.gridwidth = 1;
        JComponent nameComponent = this.componentCreator.createNameComponent(name, value);
        if (this.nameFont != null) {
            nameComponent.setFont(this.nameFont);
        }
        this.add((Component)nameComponent, this.c);
        this.c.ipadx = 0;
        this.c.weightx = 1.0;
        this.c.gridwidth = 0;
        JComponent valueComponent = this.componentCreator.createValueComponent(name, value);
        if (this.valueFont != null) {
            valueComponent.setFont(this.valueFont);
        }
        this.add((Component)valueComponent, this.c);
    }
}

