/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.info;

import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import ning.uploader.editor.ValueChangeAnnouncer;
import ning.uploader.editor.ValueChangeListener;
import ning.uploader.focus.FocusableTextField;
import ning.uploader.info.AttributeComponentCreator;

public class EditableAttributeCreator
implements AttributeComponentCreator,
ValueChangeAnnouncer {
    private final int MAX_LENGTH = 512;
    private final List<ValueChangeListener> listeners = new CopyOnWriteArrayList<ValueChangeListener>();

    public JComponent createNameComponent(String name, String value) {
        JLabel nameLabel = new JLabel(name);
        nameLabel.setHorizontalAlignment(4);
        nameLabel.setVerticalAlignment(1);
        return nameLabel;
    }

    public JComponent createValueComponent(final String name, String value) {
        final FocusableTextField valueField = new FocusableTextField(new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet attr) throws BadLocationException {
                if (str != null) {
                    str = str.substring(0, Math.min(str.length(), 512 - this.getLength()));
                }
                super.insertString(offs, str, attr);
            }
        }, value, 0);
        valueField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.fireEvent();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.fireEvent();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.fireEvent();
            }

            public void fireEvent() {
                for (ValueChangeListener listener : EditableAttributeCreator.this.listeners) {
                    listener.onValueChanged(name, valueField.getText());
                }
            }
        });
        valueField.setEditable(true);
        valueField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                for (Container parent = valueField.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof JComponent)) continue;
                    ((JComponent)parent).scrollRectToVisible(valueField.getBounds());
                    return;
                }
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        return valueField;
    }

    public JComponent createValueComponent(String name, JComponent component) {
        return component;
    }

    public JComponent createValueComponent(JComponent component) {
        return component;
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listeners.remove(listener);
    }
}

