/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.info;

import java.awt.Font;
import java.io.File;
import java.io.FileFilter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ning.uploader.info.AttributeComponentCreator;
import ning.uploader.info.FileAttributeList;
import ning.uploader.info.FileInfoRenderer;
import ning.uploader.info.Formatter;
import ning.uploader.resources.ResourceLoader;
import ning.uploader.resources.Strings;

public class DefaultFileInfoRenderer
implements FileInfoRenderer {
    private static final ImageIcon LOADING_ICON = new ImageIcon(ResourceLoader.getUrlFor("spinner.gif"));
    private static final long UPDATE_INTERVAL_MS = 500L;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final List<Future> inFlight = new ArrayList<Future>();
    private FileFilter filter;
    private Font font;

    public DefaultFileInfoRenderer(FileFilter filter) {
        this.filter = filter;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void cancelPendingCalculations() {
        for (Future f : this.inFlight) {
            f.cancel(true);
        }
    }

    public JComponent getComponentForFiles(File ... files) {
        FileAttributeList component = new FileAttributeList(AttributeComponentCreator.FIXED_ATTRIBUTE_CREATOR);
        component.setFont(this.font, this.font);
        if (files == null || files.length == 0) {
            this.addEmptyAttributes(component);
        } else if (files.length == 1 && !files[0].isDirectory()) {
            this.addSingleFileAttributes(component, files[0]);
        } else {
            this.addMultipleFileAttributes(component, files);
        }
        return component;
    }

    protected void addEmptyAttributes(FileAttributeList component) {
        component.addAttribute(Strings.FILE_NAME.get(), "--");
        component.addAttribute(Strings.FILE_SIZE.get(), "--");
    }

    protected void addSingleFileAttributes(FileAttributeList component, File file) {
        component.addAttribute(Strings.FILE_NAME.get(), file.getName());
        component.addAttribute(Strings.FILE_SIZE.get(), Formatter.toHumanReadable(file.length()));
    }

    protected void addMultipleFileAttributes(FileAttributeList component, final File ... files) {
        final JLabel selectedLabel = new JLabel();
        selectedLabel.setHorizontalTextPosition(2);
        final JLabel sizeLabel = new JLabel();
        sizeLabel.setHorizontalTextPosition(2);
        this.inFlight.add(this.executor.submit(new Runnable(){

            public void run() {
                DefaultFileInfoRenderer.this.calculateSize(selectedLabel, sizeLabel, files);
            }
        }));
        component.addComponent(Strings.FILES.get(), selectedLabel);
        component.addComponent(Strings.TOTAL_SIZE.get(), sizeLabel);
    }

    private void calculateSize(JLabel selectedLabel, JLabel sizeLabel, File ... files) {
        NumberFormat format = NumberFormat.getNumberInstance();
        ArrayList<File> toVisit = new ArrayList<File>(Arrays.asList(files));
        HashSet<File> visited = new HashSet<File>();
        int count = 0;
        long size = 0L;
        long lastUpdate = System.currentTimeMillis();
        selectedLabel.setIcon(LOADING_ICON);
        selectedLabel.setText("0");
        sizeLabel.setIcon(LOADING_ICON);
        sizeLabel.setText(Formatter.toHumanReadable(size));
        while (!toVisit.isEmpty()) {
            if (Thread.interrupted()) {
                return;
            }
            File f = (File)toVisit.remove(0);
            if (f.isDirectory()) {
                if (visited.contains(f)) continue;
                visited.add(f);
                toVisit.addAll(Arrays.asList(f.listFiles()));
                continue;
            }
            if (!this.filter.accept(f)) continue;
            size += f.length();
            ++count;
            if (System.currentTimeMillis() - lastUpdate <= 500L) continue;
            selectedLabel.setIcon(LOADING_ICON);
            selectedLabel.setText(format.format(count));
            sizeLabel.setIcon(LOADING_ICON);
            sizeLabel.setText(Formatter.toHumanReadable(size));
            lastUpdate = System.currentTimeMillis();
        }
        selectedLabel.setIcon(null);
        selectedLabel.setText(format.format(count));
        sizeLabel.setIcon(null);
        sizeLabel.setText(Formatter.toHumanReadable(size));
    }
}

