/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.icon;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.Kernel;
import java.io.File;
import java.util.Arrays;
import javax.swing.ImageIcon;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.image.AutoscaleFilter;
import ning.uploader.image.BufferedImageCreatingConsumer;

public class ScaledFileIcon
extends ImageIcon {
    public ScaledFileIcon(File sourceFile, ScalingParameters params) throws InterruptedException {
        Image baseImage = Toolkit.getDefaultToolkit().createImage(sourceFile.getAbsolutePath());
        int shadowSize = params.getShadowSize();
        int width = params.getTargetWidth() - 2 * (params.getPadding() + shadowSize);
        int height = params.getTargetHeight() - 2 * (params.getPadding() + shadowSize);
        FilteredImageSource source = new FilteredImageSource(baseImage.getSource(), new AutoscaleFilter(width, height));
        BufferedImage sourceImage = BufferedImageCreatingConsumer.getFilteredBufferedImage(source);
        BufferedImage image = new BufferedImage(sourceImage.getWidth() + 2 * shadowSize, sourceImage.getHeight() + 2 * shadowSize, 3);
        Graphics2D graphics = image.createGraphics();
        if (shadowSize > 0) {
            this.drawShadow(graphics, sourceImage, image.getWidth(), image.getHeight(), shadowSize);
        }
        graphics.drawImage((Image)sourceImage, shadowSize, shadowSize, null);
        graphics.dispose();
        this.setImage(image);
    }

    private void drawShadow(Graphics2D graphics, BufferedImage image, int width, int height, int shadowSize) throws InterruptedException {
        BufferedImage stencilImage = new BufferedImage(width, height, 3);
        Graphics2D stencilGraphics = stencilImage.createGraphics();
        stencilGraphics.translate(shadowSize, shadowSize);
        stencilGraphics.drawImage((Image)image, 0, 0, null);
        stencilGraphics.dispose();
        int[] pixels = new int[width * height];
        stencilImage.getRGB(0, 0, width, height, pixels, 0, width);
        int i = 0;
        while (i < pixels.length) {
            int n = i++;
            pixels[n] = pixels[n] & 0x3F000000;
        }
        stencilImage.setRGB(0, 0, width, height, pixels, 0, width);
        float[] convolution = new float[shadowSize];
        Arrays.fill(convolution, 1.0f / (float)convolution.length);
        ConvolveOp gaussianX = new ConvolveOp(new Kernel(convolution.length, 1, convolution));
        ConvolveOp gaussianY = new ConvolveOp(new Kernel(1, convolution.length, convolution));
        BufferedImage tmpImage = new BufferedImage(width, height, 3);
        BufferedImage blurredImage = new BufferedImage(width, height, 3);
        for (int i2 = 0; i2 < 2; ++i2) {
            tmpImage = gaussianX.filter(stencilImage, tmpImage);
            stencilImage = gaussianY.filter(tmpImage, blurredImage);
        }
        graphics.drawImage((Image)blurredImage, 2, 2, null);
    }
}

