/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.http;

import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import ning.uploader.http.HttpPost;
import ning.uploader.http.HttpResponse;
import ning.uploader.http.UploadFailedException;
import ning.uploader.http.UploadStatus;
import ning.uploader.model.UploadItem;
import ning.uploader.uploadlist.UploadListModel;

public abstract class UploadItemPoster {
    private final Executor executor = Executors.newCachedThreadPool();
    private final AtomicBoolean uploadInProgress = new AtomicBoolean(false);
    private final HttpPost httpPost;
    private final UploadListModel model;

    protected UploadItemPoster(HttpPost httpPost, UploadListModel model) {
        this.httpPost = httpPost;
        this.model = model;
    }

    public UploadItemPoster(URL target, UploadListModel model) {
        this(new HttpPost(target), model);
    }

    public void doPost() {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                if (UploadItemPoster.this.uploadInProgress.getAndSet(true)) {
                    return;
                }
                try {
                    int totalBytesSent;
                    int itemCount;
                    int totalBytes;
                    int totalCount;
                    boolean pendingApproval;
                    block19: {
                        pendingApproval = false;
                        totalCount = UploadItemPoster.this.model.getSize();
                        totalBytes = 0;
                        for (UploadItem item2 : UploadItemPoster.this.model) {
                            totalBytes = (int)((long)totalBytes + item2.getSize());
                        }
                        UploadItemPoster.this.onStart(new UploadStatus(0, totalCount, 0, totalBytes));
                        itemCount = 0;
                        totalBytesSent = 0;
                        Iterator<UploadItem> iter = UploadItemPoster.this.model.iterator();
                        do {
                            UploadItem item;
                            try {
                                if (!iter.hasNext()) break block19;
                                item = iter.next();
                                UploadItemPoster.this.onItemStart(new UploadStatus(++itemCount, totalCount, totalBytesSent, totalBytes), item);
                                try {
                                    final UploadStatus status = new UploadStatus(itemCount, totalCount, totalBytesSent, totalBytes);
                                    HttpResponse result = UploadItemPoster.this.httpPost.post(item, new HttpPost.ProgressListener(){

                                        public void updateProgress(HttpPost post, long totalBytesSent) {
                                            UploadStatus update = new UploadStatus(status.getSent(), totalCount, (int)((long)status.getBytesSent() + totalBytesSent), status.getTotalBytes());
                                            UploadItemPoster.this.onItemProgress(update, item);
                                        }
                                    });
                                    switch (result.getCode()) {
                                        case PENDING_APPROVAL: {
                                            pendingApproval = true;
                                            break;
                                        }
                                        case SUCCESSFUL: {
                                            break;
                                        }
                                        default: {
                                            UploadItemPoster.this.onItemError(new UploadStatus(itemCount, totalCount, totalBytesSent, totalBytes), item, new UploadFailedException(result));
                                            return;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    UploadItemPoster.this.onItemError(new UploadStatus(itemCount, totalCount, totalBytesSent, totalBytes), item, e);
                                    return;
                                }
                            }
                            catch (Exception e) {
                                UploadItemPoster.this.onError(new UploadStatus(itemCount, totalCount, totalBytesSent, totalBytes), e);
                                return;
                            }
                            totalBytesSent = (int)((long)totalBytesSent + item.getSize());
                            iter.remove();
                            UploadItemPoster.this.onItemSuccess(new UploadStatus(itemCount, totalCount, totalBytesSent, totalBytes), item);
                        } while (!UploadItemPoster.this.httpPost.isCancelled());
                        return;
                    }
                    UploadItemPoster.this.onSuccess(new UploadStatus(itemCount, totalCount, totalBytesSent, totalBytes), pendingApproval);
                    return;
                }
                finally {
                    UploadItemPoster.this.uploadInProgress.set(false);
                }
            }
        });
    }

    protected abstract void onStart(UploadStatus var1);

    protected abstract void onSuccess(UploadStatus var1, boolean var2);

    protected abstract void onError(UploadStatus var1, Exception var2);

    protected abstract void onItemStart(UploadStatus var1, UploadItem var2);

    protected abstract void onItemProgress(UploadStatus var1, UploadItem var2);

    protected abstract void onItemSuccess(UploadStatus var1, UploadItem var2);

    protected abstract void onItemError(UploadStatus var1, UploadItem var2, Exception var3);
}

