/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import ning.uploader.http.HttpResponse;
import ning.uploader.http.MimeTypes;
import ning.uploader.http.UploadCancelledException;
import ning.uploader.logging.Logger;
import ning.uploader.model.UploadItem;

public class HttpPost {
    private static final Logger log = Logger.getLogger(HttpPost.class);
    private URL uploadUrl;
    private final MimeTypes mimeTypes = new MimeTypes();
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicReference<Thread> uploadThread = new AtomicReference();

    public HttpPost(URL target) {
        this.uploadUrl = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse post(UploadItem item, ProgressListener progressListener) throws UploadCancelledException, InterruptedException {
        HttpURLConnection conn = null;
        HttpResponse result = new HttpResponse(HttpResponse.Code.UNEXPECTED, null);
        AtomicReference<Thread> atomicReference = this.uploadThread;
        synchronized (atomicReference) {
            block18: {
                this.uploadThread.getAndSet(Thread.currentThread());
                this.cancelled.set(false);
                try {
                    InputStream is;
                    conn = (HttpURLConnection)this.uploadUrl.openConnection();
                    conn.setInstanceFollowRedirects(false);
                    conn.setAllowUserInteraction(false);
                    conn.setUseCaches(false);
                    conn.setConnectTimeout(90000);
                    conn.setReadTimeout(90000);
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    String separator = "__NING-UPLOADER__";
                    conn.setRequestProperty("Content-Encoding", "multipart/form-data");
                    conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + separator);
                    CountingOutputStream countOut = new CountingOutputStream();
                    this.write(countOut, item, separator, null);
                    conn.setFixedLengthStreamingMode((int)countOut.getCount());
                    OutputStream out = conn.getOutputStream();
                    try {
                        this.write(out, item, separator, progressListener);
                    }
                    finally {
                        out.flush();
                        out.close();
                    }
                    int code = conn.getResponseCode();
                    InputStream inputStream = is = code >= 200 && code < 300 ? conn.getInputStream() : conn.getErrorStream();
                    if (is == null) break block18;
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        this.copy(is, bos, null);
                        result = new HttpResponse(code, bos.toString());
                    }
                    finally {
                        is.close();
                    }
                }
                catch (InterruptedException e) {
                    if (this.isCancelled()) {
                        throw new UploadCancelledException(item);
                    }
                    throw e;
                }
                catch (Exception e) {
                    log.info("Exception posting photo", e);
                }
                finally {
                    this.uploadThread.set(null);
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
        }
        return result;
    }

    public void cancel() {
        this.cancelled.set(true);
        this.uploadThread.get().interrupt();
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    private void write(OutputStream out, UploadItem item, String separator, ProgressListener progressListener) throws IOException, InterruptedException {
        for (Map.Entry<String, String> entry : item.getPostParameters().entrySet()) {
            this.writeSection(out, entry.getKey(), entry.getValue(), separator);
        }
        this.writeFile(out, "content", item.getFile(), separator, progressListener);
    }

    private void writeSection(OutputStream out, String name, String value, String separator) throws IOException {
        out.write(String.format("--%s\r\n", separator).getBytes("UTF-8"));
        out.write(String.format("Content-Disposition: form-data; name=\"%s\"\r\n\r\n", name).getBytes("UTF-8"));
        out.write(value.getBytes("UTF-8"));
        out.write(String.format("\r\n--%s\r\n", separator).getBytes("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(OutputStream out, String name, File file, String separator, ProgressListener progressListener) throws IOException, InterruptedException {
        out.write(String.format("--%s\r\n", separator).getBytes("UTF-8"));
        out.write(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n", name, file.getName()).getBytes("UTF-8"));
        out.write(String.format("Content-Type: %s\r\n", this.mimeTypes.getMimeType(file)).getBytes("UTF-8"));
        out.write("Content-Transfer-Encoding: binary\r\n\r\n".getBytes("UTF-8"));
        if (out instanceof CountingOutputStream) {
            ((CountingOutputStream)out).addToCount(file.length());
        } else {
            FileInputStream fin = new FileInputStream(file);
            try {
                this.copy(fin, out, progressListener);
            }
            finally {
                fin.close();
            }
        }
        out.write(String.format("\r\n--%s--\r\n", separator).getBytes("UTF-8"));
    }

    private long copy(InputStream in, OutputStream out, ProgressListener progressListener) throws IOException, InterruptedException {
        int read;
        byte[] buffer = new byte[16384];
        long total = 0L;
        while ((read = in.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, read);
            total += (long)read;
            if (progressListener == null) continue;
            progressListener.updateProgress(this, total);
        }
        return total;
    }

    private static class CountingOutputStream
    extends OutputStream {
        private long count = 0L;

        private CountingOutputStream() {
        }

        public long getCount() {
            return this.count;
        }

        public void addToCount(long length) {
            this.count += length;
        }

        public void write(byte[] bytes) throws IOException {
            this.count += (long)bytes.length;
        }

        public void write(byte[] bytes, int offset, int length) throws IOException {
            this.count += (long)length;
        }

        public void write(int c) throws IOException {
            ++this.count;
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    public static interface ProgressListener {
        public void updateProgress(HttpPost var1, long var2);
    }
}

