/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExtensionFilter
implements FileFilter {
    private static final Pattern EXTENSION_PATTERN = Pattern.compile(".*\\.([^.]+)");
    private final Set<String> acceptableExtensions = new HashSet<String>();

    public FileExtensionFilter(Set<String> acceptableExtensions) {
        for (String ext : acceptableExtensions) {
            this.acceptableExtensions.add(ext.toLowerCase());
        }
    }

    @Override
    public boolean accept(File f) {
        Matcher extension = EXTENSION_PATTERN.matcher(f.getName());
        return f.isFile() && extension.matches() && this.acceptableExtensions.contains(extension.group(1).toLowerCase());
    }
}

