/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.filetree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import ning.uploader.filebrowser.FileElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeSelectionModel
extends DefaultTreeSelectionModel {
    @Override
    public void setSelectionPath(TreePath treePath) {
        if (((FileElement)treePath.getLastPathComponent()).isDraggable()) {
            super.setSelectionPath(treePath);
        } else {
            this.clearSelection();
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] treePaths) {
        List<TreePath> selectablePaths = this.getSelectablePaths(treePaths);
        if (!selectablePaths.isEmpty()) {
            super.setSelectionPaths(selectablePaths.toArray(new TreePath[0]));
        } else {
            super.clearSelection();
        }
    }

    @Override
    public void addSelectionPath(TreePath treePath) {
        if (((FileElement)treePath.getLastPathComponent()).isDraggable()) {
            super.addSelectionPath(treePath);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] treePaths) {
        List<TreePath> selectablePaths = this.getSelectablePaths(treePaths);
        if (!selectablePaths.isEmpty()) {
            super.addSelectionPaths(selectablePaths.toArray(new TreePath[0]));
        }
    }

    private List<TreePath> getSelectablePaths(TreePath ... paths) {
        ArrayList<TreePath> selectablePaths = new ArrayList<TreePath>();
        for (TreePath p : paths) {
            if (!((FileElement)p.getLastPathComponent()).isDraggable()) continue;
            selectablePaths.add(p);
        }
        return selectablePaths;
    }
}

