/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.filetree;

import java.io.File;
import java.io.FileFilter;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ning.uploader.filebrowser.FileElement;

public class FileTreeModel
implements TreeModel {
    private final FileFilter filter;
    private final FileElement root;
    private final boolean singleRoot;

    public FileTreeModel(FileFilter filter) {
        this.filter = filter;
        File[] roots = File.listRoots();
        this.singleRoot = roots.length == 1;
        this.root = this.singleRoot ? new FileElement(filter, roots[0]) : new FileElement(filter, roots);
    }

    public Object getRoot() {
        return this.root;
    }

    public TreePath getPathForFile(File f) {
        if (f == null) {
            return null;
        }
        if (f.getParent() == null) {
            if (this.singleRoot) {
                return new TreePath(new FileElement(this.filter, f));
            }
            return new TreePath(this.root).pathByAddingChild(new FileElement(this.filter, f));
        }
        return this.getPathForFile(new File(f.getParent())).pathByAddingChild(new FileElement(this.filter, f));
    }

    public Object getChild(Object parent, int index) {
        return ((FileElement)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((FileElement)parent).getChildCount();
    }

    public boolean isLeaf(Object node) {
        return ((FileElement)node).isLeaf();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((FileElement)parent).getIndexOf((FileElement)child);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }
}

