/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.filetree;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ning.uploader.dnd.AbstractDragInsteadOfSelect;
import ning.uploader.dnd.FileDragSource;
import ning.uploader.dnd.FileDragSourceDelegate;
import ning.uploader.filebrowser.FileChoiceListener;
import ning.uploader.filebrowser.FileElement;
import ning.uploader.filebrowser.FileListenerHandler;
import ning.uploader.filebrowser.FileSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTree
extends JTree {
    private final FileListenerHandler listeners = new FileListenerHandler();
    private AbstractDragInsteadOfSelect<TreePath> dragInsteadOfSelect = new AbstractDragInsteadOfSelect<TreePath>(){

        @Override
        public void setSelection(TreePath pendingSelection) {
            FileTree.this.setSelectionPath(pendingSelection);
        }
    };

    public FileTree(TreeModel newModel) {
        super(newModel);
        this.setToggleClickCount(1);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ArrayList<File> files = new ArrayList<File>();
                for (FileElement element : FileTree.this.getSelectedElements().values()) {
                    files.add(element.getFile());
                }
                FileTree.this.listeners.fireFileSelectionChanged(files.toArray(new File[0]));
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath path;
                if (e.getClickCount() == 2 && (path = FileTree.this.getPathForLocation(e.getX(), e.getY())).getLastPathComponent() instanceof FileElement) {
                    FileTree.this.listeners.fireFilesChosen(((FileElement)path.getLastPathComponent()).getFile());
                }
            }
        });
        this.dragInsteadOfSelect.install(this);
        FileDragSource.install(this, new FileDragSourceDelegate<Map.Entry<TreePath, FileElement>>(){

            @Override
            public Iterable<Map.Entry<TreePath, FileElement>> getSelectedValues() {
                return FileTree.this.getSelectedElements().entrySet();
            }

            @Override
            public Rectangle getValueBounds(Map.Entry<TreePath, FileElement> value) {
                return FileTree.this.getPathBounds(value.getKey());
            }

            @Override
            public void renderValue(Graphics2D g2, Rectangle bounds, Map.Entry<TreePath, FileElement> value) {
                TreePath p = value.getKey();
                JComponent cell = (JComponent)FileTree.this.getCellRenderer().getTreeCellRendererComponent(FileTree.this, p.getLastPathComponent(), false, FileTree.this.isExpanded(p), FileTree.this.getModel().isLeaf(p.getLastPathComponent()), 0, false);
                cell.setBounds(bounds);
                cell.setOpaque(false);
                cell.paint(g2);
            }

            @Override
            public File getFileForValue(Map.Entry<TreePath, FileElement> value) {
                return value.getValue().getFile();
            }

            @Override
            public void startDrag(Iterable<Map.Entry<TreePath, FileElement>> selectedValues) {
                FileTree.this.dragInsteadOfSelect.clearPending();
            }

            @Override
            public void completeDrag(Iterable<Map.Entry<TreePath, FileElement>> selectedValues) {
            }
        });
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (!this.dragInsteadOfSelect.delaySelect(path, this.isPathSelected(path))) {
            super.setSelectionPath(path);
        }
    }

    private Map<TreePath, FileElement> getSelectedElements() {
        LinkedHashMap<TreePath, FileElement> selectedElements = new LinkedHashMap<TreePath, FileElement>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return selectedElements;
        }
        for (TreePath p : paths) {
            FileElement element;
            if (!(p.getLastPathComponent() instanceof FileElement) || !(element = (FileElement)p.getLastPathComponent()).isDraggable()) continue;
            selectedElements.put(p, element);
        }
        return selectedElements;
    }

    public void addSelectionListener(FileSelectionListener listener) {
        this.listeners.addSelectionListener(listener);
    }

    public void removeSelectionListener(FileSelectionListener listener) {
        this.listeners.removeSelectionListener(listener);
    }

    public void addChoiceListener(FileChoiceListener listener) {
        this.listeners.addChoiceListener(listener);
    }

    public void removeChoiceActionListener(FileChoiceListener listener) {
        this.listeners.removeChoiceListener(listener);
    }
}

