/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.filebrowser;

import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import ning.uploader.filebrowser.DirectoryContextListener;
import ning.uploader.filebrowser.FileChoiceListener;
import ning.uploader.filebrowser.FileSelectionListener;

public class FileListenerHandler {
    private final List<FileSelectionListener> selectionListeners = new CopyOnWriteArrayList<FileSelectionListener>();
    private final List<FileChoiceListener> choiceListeners = new CopyOnWriteArrayList<FileChoiceListener>();
    private final List<DirectoryContextListener> contextListeners = new CopyOnWriteArrayList<DirectoryContextListener>();

    public void fireFileSelectionChanged(File ... files) {
        for (FileSelectionListener listener : this.selectionListeners) {
            listener.onFileSelectionChanged(files);
        }
    }

    public void fireFilesChosen(File ... files) {
        for (FileChoiceListener listener : this.choiceListeners) {
            listener.onFilesChosen(files);
        }
    }

    public void fireContextChanged(File context) {
        for (DirectoryContextListener listener : this.contextListeners) {
            listener.onDirectoryContextChanged(context);
        }
    }

    public void addSelectionListener(FileSelectionListener listener) {
        if (listener != null) {
            this.selectionListeners.add(listener);
        }
    }

    public void removeSelectionListener(FileSelectionListener listener) {
        if (listener != null) {
            this.selectionListeners.remove(listener);
        }
    }

    public void addChoiceListener(FileChoiceListener listener) {
        if (listener != null) {
            this.choiceListeners.add(listener);
        }
    }

    public void removeChoiceListener(FileChoiceListener listener) {
        if (listener != null) {
            this.choiceListeners.remove(listener);
        }
    }

    public void addContextListener(DirectoryContextListener listener) {
        if (listener != null) {
            this.contextListeners.add(listener);
        }
    }

    public void removeContextListener(DirectoryContextListener listener) {
        if (listener != null) {
            this.contextListeners.remove(listener);
        }
    }
}

