/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.filebrowser;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import ning.uploader.logging.Logger;

public class FileElement {
    private static final Logger log = Logger.getLogger(FileElement.class);
    private static final FileView fileView;
    private static final File ROOT;
    private static final Icon ROOT_ICON;
    private static final boolean IS_WINDOWS;
    private static boolean DEFAULT_SHOW_DISABLED_FILES;
    private FileFilter filter;
    private File file;
    private Icon icon = null;
    private boolean draggable = false;
    private boolean showDisabledFiles = DEFAULT_SHOW_DISABLED_FILES;
    private FileElement[] children = null;

    public static void setDefaultShowDisabledFiles(boolean defaultShowDisabledFiles) {
        DEFAULT_SHOW_DISABLED_FILES = defaultShowDisabledFiles;
    }

    public FileElement(FileFilter filter, File file) {
        this.filter = filter;
        this.file = file;
        if (fileView != null) {
            try {
                this.icon = fileView.getIcon(file);
            }
            catch (Exception e) {
                log.debug(String.format("Failed to retrieve icon for %s", file), e);
            }
        }
        if (filter.accept(file) || file.isDirectory()) {
            this.draggable = true;
        }
    }

    public FileElement(FileFilter filter, File ... files) {
        this.filter = filter;
        this.file = ROOT;
        this.initializeChildren(files);
    }

    public static Icon getRootIcon() {
        return ROOT_ICON;
    }

    public File getFile() {
        return this.file;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public boolean isSelectable() {
        return this.file.isDirectory() || this.draggable;
    }

    public boolean isEnabled() {
        return this.draggable || !this.isLeaf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeChildren(File ... files) {
        if (this.children == null) {
            FileElement fileElement = this;
            synchronized (fileElement) {
                if (files.length == 0) {
                    files = this.file.listFiles();
                }
                this.children = new FileElement[0];
                if (files != null && files.length > 0) {
                    ArrayList<FileElement> childList = new ArrayList<FileElement>();
                    for (File f : files) {
                        if (this.file != ROOT && (f.isHidden() || !this.showDisabledFiles && !f.isDirectory() && !this.filter.accept(f))) continue;
                        childList.add(new FileElement(this.filter, f));
                    }
                    if (IS_WINDOWS) {
                        final HashMap<FileElement, Integer> order = new HashMap<FileElement, Integer>();
                        int rank = 0;
                        for (FileElement element : childList) {
                            order.put(element, rank);
                            ++rank;
                        }
                        Collections.sort(childList, new Comparator<FileElement>(){

                            @Override
                            public int compare(FileElement e1, FileElement e2) {
                                File f1 = e1.getFile();
                                File f2 = e2.getFile();
                                if (f1.isDirectory()) {
                                    if (!f2.isDirectory()) {
                                        return -1;
                                    }
                                } else if (f2.isDirectory()) {
                                    return 1;
                                }
                                return (Integer)order.get(e1) - (Integer)order.get(e2);
                            }
                        });
                    }
                    this.children = childList.toArray(this.children);
                }
            }
        }
    }

    public FileElement getChildAt(int childIndex) {
        this.initializeChildren(new File[0]);
        return this.children[childIndex];
    }

    public int getChildCount() {
        this.initializeChildren(new File[0]);
        return this.children.length;
    }

    public int getIndexOf(FileElement child) {
        this.initializeChildren(new File[0]);
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].equals(child)) continue;
            return i;
        }
        return -1;
    }

    public boolean isLeaf() {
        if (this.file == ROOT) {
            return false;
        }
        if (this.children == null || this.children.length == 0) {
            if (!this.file.isDirectory() || this.file.listFiles() == null || this.file.listFiles().length == 0) {
                return true;
            }
            try {
                return fileView != null && fileView.isTraversable(this.file) == false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public FileElement[] getChildren() {
        this.initializeChildren(new File[0]);
        return this.children;
    }

    public String toString() {
        String name = this.file.getName();
        if (name.length() == 0 && (name = this.file.getPath()).endsWith(File.separator)) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileElement that = (FileElement)o;
        return !(this.file == null ? that.file != null : !this.file.equals(that.file));
    }

    public int hashCode() {
        return this.file != null ? this.file.hashCode() : 0;
    }

    static {
        ROOT = new File("/");
        IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
        FileView fv = null;
        try {
            JFileChooser dummy = new JFileChooser();
            ComponentUI ui = UIManager.getUI(dummy);
            if (ui != null && ui instanceof FileChooserUI) {
                fv = ((FileChooserUI)ui).getFileView(dummy);
            }
        }
        catch (Throwable t) {
            log.warn("Filed to get file view -- using boring icons :(", t);
        }
        fileView = fv;
        Icon rootIcon = null;
        try {
            if (fileView != null) {
                rootIcon = fileView.getIcon(ROOT);
            }
        }
        catch (Throwable t) {
            log.debug("Failed to retrieve icon for root", t);
            rootIcon = UIManager.getIcon("Tree.closedIcon");
        }
        ROOT_ICON = rootIcon;
        DEFAULT_SHOW_DISABLED_FILES = false;
    }
}

