/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.editor;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ning.uploader.editor.MutableComponent;
import ning.uploader.editor.ValueChangeAnnouncer;
import ning.uploader.editor.ValueChangeListener;
import ning.uploader.focus.TabFocus;

public class RadioButtonComponent
extends JPanel
implements ValueChangeAnnouncer,
MutableComponent {
    private final List<JRadioButton> buttons = new ArrayList<JRadioButton>();
    private JRadioButton notSelected = new JRadioButton();
    private ButtonGroup group = new ButtonGroup();
    private final List<ValueChangeListener> listeners = new CopyOnWriteArrayList<ValueChangeListener>();

    public RadioButtonComponent(String name, String defaultValue, String[] choices) {
        this.initialize(name, defaultValue, choices);
    }

    private void initialize(final String name, String defaultValue, String[] choices) {
        this.setLayout(new BoxLayout(this, 0));
        for (String choice : choices) {
            final TabFocusRadioButton button = new TabFocusRadioButton(choice);
            this.buttons.add(button);
            this.group.add(button);
            this.add(button);
            if (choice.equals(defaultValue)) {
                button.setSelected(true);
            }
            button.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (button.isSelected()) {
                        for (ValueChangeListener listener : RadioButtonComponent.this.listeners) {
                            listener.onValueChanged(name, button.getText());
                        }
                    }
                }
            });
            button.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    for (Container parent = button.getParent(); parent != null; parent = parent.getParent()) {
                        if (!(parent instanceof JComponent)) continue;
                        ((JComponent)parent).scrollRectToVisible(button.getBounds());
                        return;
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            });
        }
        this.notSelected.setVisible(false);
        this.group.add(this.notSelected);
    }

    public boolean isButtonSelected() {
        return !this.notSelected.isSelected();
    }

    public void selectButton(int index) {
        this.buttons.get(index).setSelected(true);
    }

    public void deselectAll() {
        this.notSelected.setSelected(true);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.buttons != null) {
            for (JRadioButton c : this.buttons) {
                c.setFont(font);
            }
        }
        this.repaint();
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.buttons != null) {
            for (JRadioButton c : this.buttons) {
                c.setBackground(background);
            }
        }
        this.repaint();
    }

    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        if (this.buttons != null) {
            for (JRadioButton c : this.buttons) {
                c.setOpaque(opaque);
            }
        }
        this.repaint();
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setText(String text) {
        for (JRadioButton b : this.buttons) {
            if (!b.getText().equals(text) || b.isSelected()) continue;
            b.setSelected(true);
        }
    }

    private class TabFocusRadioButton
    extends JRadioButton
    implements TabFocus {
        public TabFocusRadioButton(String choice) {
            super(choice);
        }
    }
}

