/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import ning.uploader.editor.BatchEditor;
import ning.uploader.editor.ItemEditor;
import ning.uploader.editor.MutableComponent;
import ning.uploader.editor.ValueChangeListener;
import ning.uploader.focus.TabFocusTraversalPolicy;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.info.EditableAttributeCreator;
import ning.uploader.logging.Logger;
import ning.uploader.model.UploadItem;
import ning.uploader.resources.IconCreator;
import ning.uploader.resources.ResourceLoader;
import ning.uploader.resources.Strings;
import ning.uploader.swing.FooterPanel;
import ning.uploader.swing.FourSidedBorder;
import ning.uploader.swing.MessagePanel;
import ning.uploader.uploadlist.UploadListModel;

public class EditorList
extends JPanel {
    private final Logger log = Logger.getLogger(EditorList.class);
    private final ImageIcon killIcon = new ImageIcon(ResourceLoader.loadImage("close.png"));
    private final ImageIcon altKillIcon = new ImageIcon(ResourceLoader.loadImage("close-alt.png"));
    private final IconCreator iconCreator;
    private final ScalingParameters iconParams;
    private final UploadListModel backingList;
    private final JPanel itemPanel = new JPanel();
    private final ArrayList<Item> editorItems = new ArrayList();
    private final List<UploadListener> uploadListeners = new CopyOnWriteArrayList<UploadListener>();
    private final List<CancelListener> cancelListeners = new CopyOnWriteArrayList<CancelListener>();

    public EditorList(IconCreator iconCreator, ScalingParameters iconParams, final UploadListModel backingList, UploadItem item, HyperlinkListener listener) {
        super(new BorderLayout());
        this.iconCreator = iconCreator;
        this.iconParams = iconParams;
        this.backingList = backingList;
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new TabFocusTraversalPolicy());
        this.itemPanel.setLayout(new BoxLayout(this.itemPanel, 1));
        FourSidedBorder batchBorder = new FourSidedBorder(new Insets(1, 1, 0, 1), new Color(221, 221, 221));
        batchBorder.setBottomColor(new Color(163, 163, 163));
        final BatchEditor batchEditor = new BatchEditor(item, iconParams);
        batchEditor.setBorder(batchBorder);
        batchEditor.addValueChangeListener(new ValueChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onValueChanged(String name, String value) {
                Object object = EditorList.this.getTreeLock();
                synchronized (object) {
                    for (Item editorItem : EditorList.this.editorItems) {
                        editorItem.setValue(name, value);
                    }
                }
                EditorList.this.repaint();
            }
        });
        backingList.addListDataListener(new ListDataListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void intervalAdded(ListDataEvent e) {
                Object object = EditorList.this.getTreeLock();
                synchronized (object) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        Item editorItem = new Item((UploadItem)backingList.getElementAt(i));
                        EditorList.this.editorItems.add(editorItem);
                        EditorList.this.itemPanel.add((Component)editorItem.getEditorPanel(), i);
                    }
                    if (e.getType() != -1) {
                        EditorList.this.updateBackground();
                    }
                    batchEditor.setVisible(backingList.size() > 1);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void intervalRemoved(ListDataEvent e) {
                Object object = EditorList.this.getTreeLock();
                synchronized (object) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        EditorList.this.editorItems.remove(i);
                        EditorList.this.itemPanel.remove(i);
                    }
                    if (e.getType() != -1) {
                        EditorList.this.updateBackground();
                    }
                    batchEditor.setVisible(backingList.size() > 1);
                }
            }

            public void contentsChanged(ListDataEvent e) {
                this.intervalRemoved(new ListDataEvent(backingList, -1, 0, backingList.size()));
                this.intervalAdded(new ListDataEvent(backingList, -1, 0, backingList.size()));
            }
        });
        ListWrapper itemPanelWrapper = new ListWrapper();
        itemPanelWrapper.add((Component)this.itemPanel, "North");
        itemPanelWrapper.setBackground(Color.WHITE);
        JScrollPane itemScrollPane = new JScrollPane(itemPanelWrapper);
        itemScrollPane.setBorder(BorderFactory.createEmptyBorder());
        itemScrollPane.getVerticalScrollBar().setUnitIncrement(25);
        itemScrollPane.setHorizontalScrollBarPolicy(31);
        JButton uploadButton = new JButton(Strings.UPLOAD_BUTTON.get());
        uploadButton.setOpaque(false);
        uploadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (UploadListener listener : EditorList.this.uploadListeners) {
                    listener.onUpload();
                }
            }
        });
        JButton backButton = new JButton(Strings.BACK_BUTTON.get());
        backButton.setOpaque(false);
        backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (CancelListener listener : EditorList.this.cancelListeners) {
                    listener.onCancel();
                }
            }
        });
        FooterPanel footer = new FooterPanel();
        footer.add((Component)uploadButton, "East");
        footer.add((Component)backButton, "West");
        JPanel panelContainer = new JPanel(new BorderLayout());
        panelContainer.setBorder(new FourSidedBorder(new Insets(1, 1, 0, 1), new Color(195, 195, 195)));
        panelContainer.add((Component)batchEditor, "North");
        panelContainer.add((Component)itemScrollPane, "Center");
        panelContainer.add((Component)new MessagePanel(Strings.I_HAVE_THE_RIGHT.get(), listener), "South");
        this.add((Component)panelContainer, "Center");
        this.add((Component)footer, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackground() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Color stripe = new Color(239, 243, 249);
            int index = 0;
            boolean mulitpleItems = this.backingList.size() > 1;
            for (Item editor : this.editorItems) {
                if (index++ % 2 == 0) {
                    editor.setBackground(Color.WHITE);
                    editor.setIcon(mulitpleItems ? this.killIcon : null);
                    continue;
                }
                editor.setBackground(stripe);
                editor.setIcon(this.altKillIcon);
            }
        }
    }

    public void addUploadListener(UploadListener listener) {
        this.uploadListeners.add(listener);
    }

    public void removeUploadListener(UploadListener listener) {
        this.uploadListeners.remove(listener);
    }

    public void addCancelListener(CancelListener listener) {
        this.cancelListeners.add(listener);
    }

    public void removeCancelListener(CancelListener listener) {
        this.cancelListeners.remove(listener);
    }

    private class Item {
        private final UploadItem item;
        private final ItemEditor editor;
        private final JPanel editorPanel;
        private final JPanel killButtonSpacer;
        private final Map<String, MutableComponent> components;
        private JButton killButton;

        public Item(UploadItem item) {
            this.item = item;
            this.components = new HashMap<String, MutableComponent>();
            this.editor = new ItemEditor(item, EditorList.this.iconCreator, EditorList.this.iconParams, new EditableAttributeCreator(){

                public JComponent createValueComponent(String name, String value) {
                    final JComponent result = super.createValueComponent(name, value);
                    if (result instanceof MutableComponent) {
                        Item.this.components.put(name, (MutableComponent)((Object)result));
                    } else if (result instanceof JTextField) {
                        Item.this.components.put(name, new MutableComponent(){
                            private final JTextField field;
                            {
                                this.field = (JTextField)result;
                            }

                            public void setText(String text) {
                                if (!this.field.getText().equals(text)) {
                                    this.field.setText(text);
                                }
                            }
                        });
                    }
                    return result;
                }

                public JComponent createValueComponent(String name, JComponent component) {
                    JComponent result = super.createValueComponent(name, component);
                    if ("".equals(name)) {
                        name = result.getName();
                    }
                    if (result instanceof MutableComponent) {
                        Item.this.components.put(name, (MutableComponent)((Object)result));
                    }
                    return result;
                }
            });
            this.editor.addValueChangeListener(new ValueChangeListener(){

                public void onValueChanged(String name, String value) {
                    EditorList.this.repaint();
                }
            });
            this.killButtonSpacer = new JPanel(new BorderLayout());
            this.killButtonSpacer.setOpaque(true);
            this.killButtonSpacer.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
            this.editorPanel = new JPanel(new BorderLayout());
            this.editorPanel.setOpaque(false);
            this.editorPanel.add((Component)this.killButtonSpacer, "East");
            this.editorPanel.add((Component)this.editor, "Center");
        }

        public void setBackground(Color background) {
            this.editor.setBackground(background);
            this.killButtonSpacer.setBackground(background);
        }

        public void setIcon(Icon icon) {
            if (icon == null) {
                if (this.killButton != null && this.killButtonSpacer.equals(this.killButton.getParent())) {
                    this.killButtonSpacer.remove(this.killButton);
                    this.killButton = null;
                }
            } else if (this.killButton != null) {
                this.killButton.setIcon(icon);
            } else {
                this.killButton = new JButton(icon);
                this.killButton.setVerticalAlignment(1);
                this.killButton.setAlignmentY(0.0f);
                this.killButton.setBorderPainted(false);
                this.killButton.setOpaque(false);
                this.killButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        EditorList.this.backingList.remove(Item.this.item);
                    }
                });
                this.killButtonSpacer.add((Component)this.killButton, "North");
            }
        }

        public void setValue(String name, String value) {
            this.editor.setValue(name, value);
            MutableComponent component = this.components.get(name);
            if (component != null) {
                component.setText(value);
            } else {
                EditorList.this.log.warn(String.format("Tried to set %s => %s on immutable component", name, value));
            }
        }

        public JPanel getEditorPanel() {
            return this.editorPanel;
        }
    }

    private class ListWrapper
    extends JPanel
    implements Scrollable {
        public ListWrapper() {
            super(new BorderLayout());
        }

        public Dimension getPreferredScrollableViewportSize() {
            return EditorList.this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 1;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return visibleRect.height;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    public static interface CancelListener {
        public void onCancel();
    }

    public static interface UploadListener {
        public void onUpload();
    }
}

