/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import ning.uploader.editor.CheckBoxComponent;
import ning.uploader.editor.ItemEditor;
import ning.uploader.editor.RadioButtonComponent;
import ning.uploader.editor.ValueChangeAnnouncer;
import ning.uploader.editor.ValueChangeListener;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.info.EditableAttributeCreator;
import ning.uploader.model.UploadItem;
import ning.uploader.resources.ResourceLoader;
import ning.uploader.resources.Strings;

public class BatchEditor
extends JPanel
implements ValueChangeAnnouncer {
    private final ItemEditor editor;
    private final ImageIcon icon = new ImageIcon(ResourceLoader.loadImage("batch.png"));
    private final Color backgroundColor = new Color(223, 223, 223);
    private final JLabel label;
    private ImageIcon closedIcon = new ImageIcon(ResourceLoader.loadImage("batch-closed.png"));
    private ImageIcon expandedIcon = new ImageIcon(ResourceLoader.loadImage("batch-expanded.png"));
    private boolean expanded = false;
    private final Map<String, JCheckBox> propertyCheckBox = new HashMap<String, JCheckBox>();
    private final List<ValueChangeListener> listeners = new CopyOnWriteArrayList<ValueChangeListener>();

    public BatchEditor(UploadItem item, ScalingParameters iconParams) {
        super(new BorderLayout(), true);
        this.setOpaque(false);
        this.label = new JLabel(Strings.BATCH_EDITOR_LABEL.get());
        this.label.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        this.label.setHorizontalAlignment(2);
        this.label.setOpaque(false);
        this.label.setIcon(this.closedIcon);
        this.label.setIconTextGap(5);
        Font font = UIManager.getFont("TableHeader.font");
        if (font != null) {
            this.label.setFont(font.deriveFont(1));
        }
        this.label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BatchEditor.this.setExpanded(!BatchEditor.this.expanded);
            }
        });
        final JPanel applyPanel = new JPanel(new BorderLayout());
        JButton applyButton = new JButton(Strings.APPLY_THIS_INFO.get());
        applyPanel.add((Component)applyButton, "West");
        applyPanel.setOpaque(false);
        if (font != null) {
            applyButton.setFont(font);
        }
        applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                for (ValueChangeListener listener : BatchEditor.this.listeners) {
                    for (Map.Entry<String, String> entry : BatchEditor.this.editor.getValues().entrySet()) {
                        JCheckBox checkBox = (JCheckBox)BatchEditor.this.propertyCheckBox.get(entry.getKey());
                        if (checkBox != null && !checkBox.isSelected()) continue;
                        listener.onValueChanged(entry.getKey(), entry.getValue());
                    }
                }
            }
        });
        final ValueChangeListener listener = new ValueChangeListener(){

            public void onValueChanged(String name, String value) {
                JCheckBox checkBox = (JCheckBox)BatchEditor.this.propertyCheckBox.get(name);
                if (checkBox != null) {
                    checkBox.setSelected(true);
                }
            }
        };
        this.editor = new ItemEditor(item, iconParams, new EditableAttributeCreator(){

            public JComponent createValueComponent(String name, String value) {
                return this.wrapComponent(name, super.createValueComponent(name, value));
            }

            public JComponent createValueComponent(String name, JComponent component) {
                return component == applyPanel ? component : this.wrapComponent(name, super.createValueComponent(name, component));
            }

            private JComponent wrapComponent(String name, final JComponent component) {
                if (component instanceof CheckBoxComponent) {
                    return component;
                }
                final JCheckBox checkBox = new JCheckBox();
                BatchEditor.this.propertyCheckBox.put(name, checkBox);
                JPanel panel = new JPanel(new BorderLayout()){

                    public void setFont(Font font) {
                        component.setFont(font);
                        super.setFont(font);
                    }
                };
                panel.setOpaque(false);
                panel.add((Component)checkBox, "West");
                panel.add((Component)component, "Center");
                if (component instanceof ValueChangeAnnouncer) {
                    ((ValueChangeAnnouncer)((Object)component)).addValueChangeListener(listener);
                }
                if (component instanceof RadioButtonComponent) {
                    final RadioButtonComponent radioComponent = (RadioButtonComponent)component;
                    radioComponent.deselectAll();
                    checkBox.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            if (!checkBox.isSelected()) {
                                radioComponent.deselectAll();
                            } else if (!radioComponent.isButtonSelected()) {
                                radioComponent.selectButton(0);
                            }
                        }
                    });
                }
                return panel;
            }
        });
        this.editor.addValueChangeListener(listener);
        this.editor.setIcon(this.icon);
        this.editor.setOpaque(false);
        this.editor.addComponent("", applyPanel);
        this.setExpanded(true);
        this.add((Component)this.label, "North");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExpanded(boolean expanded) {
        ItemEditor itemEditor = this.editor;
        synchronized (itemEditor) {
            this.expanded = expanded;
            if (expanded) {
                this.label.setIcon(this.expandedIcon);
                this.add((Component)this.editor, "Center");
            } else {
                this.label.setIcon(this.closedIcon);
                this.remove(this.editor);
            }
            if (this.getParent() != null) {
                this.getParent().validate();
            }
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(new GradientPaint(this.getWidth() / 2, 0.0f, Color.WHITE, this.getWidth() / 2, this.getHeight(), this.backgroundColor));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.dispose();
        super.paintComponent(g);
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listeners.remove(listener);
    }
}

