/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader;

import java.applet.AppletContext;
import java.net.URL;
import ning.uploader.alerter.Alerter;
import ning.uploader.alerter.AlerterHelper;
import ning.uploader.alerter.Callback;
import ning.uploader.alerter.Choices;
import ning.uploader.alerter.Chosen;
import ning.uploader.alerter.Popup;
import ning.uploader.http.HttpPost;
import ning.uploader.http.UploadCancelledException;
import ning.uploader.http.UploadFailedException;
import ning.uploader.http.UploadItemPoster;
import ning.uploader.http.UploadStatus;
import ning.uploader.model.UploadItem;
import ning.uploader.resources.Strings;
import ning.uploader.uploadlist.UploadListModel;

public class ProgressDialog
extends UploadItemPoster {
    private final HttpPost httpPost;
    private final Alerter alerter;
    private final AppletContext context;
    private final URL successUrl;
    private final UploadListModel model;
    private Popup popup = null;

    public ProgressDialog(HttpPost httpPost, UploadListModel model, Alerter alerter, AppletContext context, URL successUrl) {
        super(httpPost, model);
        this.httpPost = httpPost;
        this.model = model;
        this.alerter = alerter;
        this.context = context;
        this.successUrl = successUrl;
    }

    protected void onStart(UploadStatus status) {
        this.popup = this.alerter.status(Strings.UPLOADING_LABEL.get(), Strings.UPLOADING_INSTRUCTIONS.get(), Choices.CANCEL, new Callback(){

            public void onChosen(Chosen chosen) {
                if (chosen == Chosen.CANCEL) {
                    ProgressDialog.this.httpPost.cancel();
                }
            }
        });
    }

    protected void onItemStart(UploadStatus status, UploadItem item) {
        this.popup.setMessage(String.format("%s\n\n%s", Strings.UPLOADING_STATUS.get(Integer.toString(status.getSent()), Integer.toString(status.getTotal())), Strings.UPLOADING_INSTRUCTIONS.get()));
    }

    protected void onItemProgress(UploadStatus status, UploadItem item) {
        this.popup.setProgress((double)status.getBytesSent() / (double)status.getTotalBytes());
    }

    protected void onItemSuccess(UploadStatus status, UploadItem item) {
        this.model.remove(item);
    }

    protected void onSuccess(UploadStatus status, boolean pendingApproval) {
        this.popup.setProgress(1.0);
        this.popup.close();
        if (pendingApproval) {
            AlerterHelper.info(this.alerter, Strings.UPLOAD_SUCCESSFUL_TITLE, Strings.UPLOAD_PENDING_DESCRIPTION, Choices.OKAY, new Callback(){

                public void onChosen(Chosen chosen) {
                    ProgressDialog.this.gotoSuccessUrl();
                }
            }, new String[0]);
        } else {
            this.gotoSuccessUrl();
        }
    }

    protected void onError(UploadStatus status, Exception e) {
        if (!(e instanceof UploadCancelledException)) {
            AlerterHelper.error(this.alerter, Strings.ERROR_UNEXPECTED_TITLE, Strings.ERROR_UNEXPECTED_DESCRIPTION, new String[0]);
            this.popup.close();
        }
    }

    protected void onItemError(UploadStatus status, UploadItem item, Exception e) {
        if (e instanceof UploadFailedException) {
            switch (((UploadFailedException)e).getResponse().getCode()) {
                case NOT_A_MEMBER: {
                    AlerterHelper.warning(this.alerter, Strings.ERROR_NOT_A_MEMBER_TITLE, Strings.ERROR_NOT_A_MEMBER_DESCRIPTION, Choices.OKAY, Callback.NO_OP, new String[0]);
                    break;
                }
                case CONTENT_TYPE_NOT_ALLOWED: {
                    AlerterHelper.warning(this.alerter, Strings.ERROR_CONTENT_TYPE_NOT_ALLOWED_TITLE, Strings.ERROR_CONTENT_TYPE_NOT_ALLOWED_DESCRIPTION, Choices.OKAY, Callback.NO_OP, new String[0]);
                    break;
                }
                case UNSUPPORTED_FORMAT: {
                    AlerterHelper.warning(this.alerter, Strings.ERROR_UNSUPPORTED_FORMAT_TITLE, Strings.ERROR_UNSUPPORTED_FORMAT_DESCRIPTION, Choices.OKAY, Callback.NO_OP, new String[0]);
                    break;
                }
                default: {
                    AlerterHelper.error(this.alerter, Strings.ERROR_UPLOAD_UNEXPECTED_TITLE, Strings.ERROR_UPLOAD_UNEXPECTED_DESCRIPTION, item.getFile().getName());
                    break;
                }
            }
        } else if (!(e instanceof UploadCancelledException)) {
            AlerterHelper.error(this.alerter, Strings.ERROR_UPLOAD_UNEXPECTED_TITLE, Strings.ERROR_UPLOAD_UNEXPECTED_DESCRIPTION, item.getFile().getName());
        }
        this.popup.close();
    }

    private void gotoSuccessUrl() {
        AlerterHelper.info(this.alerter, Strings.UPLOAD_SUCCESSFUL_TITLE, Strings.UPLOAD_SUCCESSFUL_DESCRIPTION, Choices.NONE, Callback.NO_OP, new String[0]);
        this.context.showDocument(this.successUrl);
    }
}

