<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

#****************************************************************************
#*  Common translation text shared among multiple pages
#****************************************************************************
$trans["sharedCancel"]             = "\$text = 'Cancelar';";
$trans["sharedDelete"]             = "\$text = 'Borraar';";

#****************************************************************************
#*  Translation text for page biblio_view.php
#****************************************************************************
$trans["biblioViewTble1Hdr"]       = "\$text = 'Informacioon bibliografia';";
$trans["biblioViewMaterialType"]   = "\$text = 'Tipo de Material';";
$trans["biblioViewCollection"]     = "\$text = 'Colleccion';";
$trans["biblioViewCallNmbr"]       = "\$text = 'Llamar numero';";
$trans["biblioViewTble2Hdr"]       = "\$text = 'Bibliography Copy Information';";
$trans["biblioViewTble2Col1"]      = "\$text = 'Barcode #';";
$trans["biblioViewTble2Col2"]      = "\$text = 'Descriction';";
$trans["biblioViewTble2Col3"]      = "\$text = 'Status';";
$trans["biblioViewTble2Col4"]      = "\$text = 'Status Dt';";
$trans["biblioViewTble2Col5"]      = "\$text = 'Devolver';";
$trans["biblioViewTble2ColFunc"]   = "\$text = 'Funccion';";
$trans["biblioViewTble2Coldel"]    = "\$text = 'borr';";
$trans["biblioViewTble2Coledit"]   = "\$text = 'editar';";
$trans["biblioViewTble3Hdr"]       = "\$text = 'Informaciona bibliografica adicional';";
$trans["biblioViewNoAddInfo"]      = "\$text = 'Informacion bibliografica adicional no dsiponible.';";
$trans["biblioViewNoCopies"]       = "\$text = 'No se han creado copias.';";
$trans["biblioViewOpacFlg"]        = "\$text = 'Mostrar onlines';";
$trans["biblioViewNewCopy"]        = "\$text = 'Agregar nueva copia';";
$trans["biblioViewNeweCopy"]       = "\$text = 'Agregar copia electronica';";
$trans["biblioViewYes"]            = "\$text = 'si';";
$trans["biblioViewNo"]             = "\$text = 'no';";

#****************************************************************************
#*  Translation text for page biblio_search.php
#****************************************************************************
$trans["biblioSearchNoResults"]    = "\$text = 'No se encontraron resultados.';";
$trans["biblioSearchResults"]      = "\$text = 'Resultados busqueda';";
$trans["biblioSearchResultPages"]  = "\$text = 'Pag de resultados';";
$trans["biblioSearchPrev"]         = "\$text = 'prev';";
$trans["biblioSearchNext"]         = "\$text = 'sig';";
$trans["biblioSearchResultTxt"]    = "if (%items% == 1) {
                                        \$text = '%items% resultado encontrado.';
                                      } else {
                                        \$text = '%items% resultados encontrados';
                                      }";
$trans["biblioSearchauthor"]       = "\$text = ' ordenado por autor';";
$trans["biblioSearchtitle"]        = "\$text = ' ordenado por titulo';";
$trans["biblioSearchSortByAuthor"] = "\$text = 'ordenado por autor';";
$trans["biblioSearchSortByTitle"]  = "\$text = 'ordenado por titulo';";
$trans["biblioSearchTitle"]        = "\$text = 'Titulo';";
$trans["biblioSearchAuthor"]       = "\$text = 'Authr';";
$trans["biblioSearchMaterial"]     = "\$text = 'Material';";
$trans["biblioSearchCollection"]   = "\$text = 'Coleccion';";
$trans["biblioSearchCall"]         = "\$text = 'Llamar nmero';";
$trans["biblioSearchCopyBCode"]    = "\$text = 'Copiar Barcode';";
$trans["biblioSearchCopyStatus"]   = "\$text = 'Status';";
$trans["biblioSearchNoCopies"]     = "\$text = 'No hay copias disponibles.';";
$trans["biblioSearchHold"]         = "\$text = 'retener';";
$trans["biblioSearchOutIn"]        = "\$text = 'check out/in';";
$trans["biblioSearchDetail"]       = "\$text = 'Mostrar informacion detallada bibliografica';";
$trans["biblioSearchBCode2Chk"]    = "\$text = 'Barcode para Check Out o formulario Check In';";
$trans["biblioSearchBCode2Hold"]   = "\$text = 'Barcode to Hold Form';";

#****************************************************************************
#*  Translation text for page loginform.php
#****************************************************************************
$trans["loginFormTbleHdr"]         = "\$text = 'Login Staff';";
$trans["loginFormUsername"]        = "\$text = 'Usuario';";
$trans["loginFormPassword"]        = "\$text = 'Contrasea';";
$trans["loginFormLogin"]           = "\$text = 'Login';";

#****************************************************************************
#*  Translation text for page hold_del_confirm.php
#****************************************************************************
$trans["holdDelConfirmMsg"]        = "\$text = 'Confirma borrar este requerimiento?';";

#****************************************************************************
#*  Translation text for page hold_del.php
#****************************************************************************
$trans["holdDelSuccess"]           = "\$text='Requerimiento de mantener ha sido borrado.';";

#****************************************************************************
#*  Translation text for page help_header.php
#****************************************************************************
$trans["helpHeaderTitle"]          = "\$text='Ayuda';";
$trans["helpHeaderCloseWin"]       = "\$text='Cerrar ventana';";
$trans["helpHeaderContents"]       = "\$text='Contenidos';";
$trans["helpHeaderPrint"]          = "\$text='Imprimir';";

$trans["catalogResults"]           = "\$text='Resultados busqueda';";

#****************************************************************************
#*  Translation text for page header.php and header_opac.php
#****************************************************************************
$trans["headerTodaysDate"]         = "\$text='fecha hoy:';";
$trans["headerDateFormat"]         = "\$text='d.m.Y';";
$trans["headerLibraryHours"]       = "\$text='horario:';";
$trans["headerLibraryPhone"]       = "\$text='telfono biblioteca:';";
$trans["headerHome"]               = "\$text='HOME';";
$trans["headerCirculation"]        = "\$text='CIRCULACION';";
$trans["headerCataloging"]         = "\$text='CATALOGAR';";
$trans["headerAdmin"]              = "\$text='ADMIN';";
$trans["headerReports"]            = "\$text='INFORMES';";

#****************************************************************************
#*  Translation text for page footer.php
#****************************************************************************
$trans["footerLibraryHome"]        = "\$text='Home';";
$trans["footerOPAC"]               = "\$text='Online';";
$trans["footerHelp"]               = "\$text='Ayuda';";
$trans["footerPoweredBy"]          = "\$text='ayacusys';";
$trans["footerDatabaseVersion"]    = "\$text='version sql';";
$trans["footerCopyright"]          = "\$text='Copyright';";
$trans["footerUnderThe"]           = "\$text='bajo';";
$trans["footerGPL"]                = "\$text='GNU';";

?>
