<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

#****************************************************************************
#*  Common translation text shared among multiple pages
#****************************************************************************
$trans["adminSubmit"]              = "\$text = 'Enviar';";
$trans["adminCancel"]              = "\$text = 'Cancelar';";
$trans["adminDelete"]              = "\$text = 'Borrar';";
$trans["adminUpdate"]              = "\$text = 'Actualizar';";
$trans["adminFootnote"]            = "\$text = 'Campos marcados con %symbol% requeridos.';";

#****************************************************************************
#*  Translation text for page index.php
#****************************************************************************
$trans["indexHdr"]                 = "\$text = 'Admin';";
$trans["indexDesc"]                = "\$text = 'Use las funciones en el menu izquierdo para administrar el staff y los registros administrativos.';";

#****************************************************************************
#*  Translation text for page collections*.php
#****************************************************************************
$trans["adminCollections_delReturn"]                 = "\$text = 'volver a lista colecciones';";
$trans["adminCollections_delStart"]                 = "\$text = 'Coleccin, ';";

#****************************************************************************
#*  Translation text for page collections_del.php
#****************************************************************************
$trans["adminCollections_delEnd"]                 = "\$text = ', ha sido borrada.';";

#****************************************************************************
#*  Translation text for page collections_del_confirm.php
#****************************************************************************
$trans["adminCollections_del_confirmText"]                 = "\$text = 'Confirma que borra la coleccin?, ';";

#****************************************************************************
#*  Translation text for page collections_edit.php
#****************************************************************************
$trans["adminCollections_editEnd"]                 = "\$text = ', ha sido actualizada.';";

#****************************************************************************
#*  Translation text for page collections_edit_form.php
#****************************************************************************
$trans["adminCollections_edit_formEditcollection"]                 = "\$text = 'Editar Coleccion:';";
$trans["adminCollections_edit_formDescription"]                 = "\$text = 'Descripcion:';";
$trans["adminCollections_edit_formDaysdueback"]                 = "\$text = 'Days Due Back:';";
$trans["adminCollections_edit_formDailyLateFee"]                 = "\$text = 'Daily Late Fee:';";
$trans["adminCollections_edit_formNote"]                 = "\$text = '*Nota:';";
$trans["adminCollections_edit_formNoteText"]                 = "\$text = 'Setting the days due back to zero makes the entire collection unavailable for checkout.';";

#****************************************************************************
#*  Translation text for page collections_list.php
#****************************************************************************
$trans["adminCollections_listAddNewCollection"]                 = "\$text = 'Add New Collection';";
$trans["adminCollections_listCollections"]                 = "\$text = 'Collections:';";
$trans["adminCollections_listFunction"]                 = "\$text = 'Function';";
$trans["adminCollections_listDescription"]                 = "\$text = 'Description';";
$trans["adminCollections_listDaysdueback"]                 = "\$text = 'Days<br>Due Back';";
$trans["adminCollections_listDailylatefee"]                 = "\$text = 'Daily<br>Late Fee';";
$trans["adminCollections_listBibliographycount"]                 = "\$text = 'Bibliography<br>Count';";
$trans["adminCollections_listEdit"]                 = "\$text = 'Edit';";
$trans["adminCollections_listDel"]                 = "\$text = 'del';";
$trans["adminCollections_ListNote"]                 = "\$text = '*Note:';";
$trans["adminCollections_ListNoteText"]                 = "\$text = 'The delete function is only available on collections that have a bibliography count of zero.<br>If you wish to delete a collection with a bibliography count greater than zero you will first need to change the material type on those bibliographies to another material type.';";

#****************************************************************************
#*  Translation text for page collections_new.php
#****************************************************************************
$trans["adminCollections_newAdded"]                 = "\$text = ', has been added.';";

#****************************************************************************
#*  Translation text for page collections_new_form.php
#****************************************************************************
$trans["adminCollections_new_formAddnewcollection"]                 = "\$text = 'Agregar nueva coleccion:';";
$trans["adminCollections_new_formDescription"]                 = "\$text = 'Descripcion:';";
$trans["adminCollections_new_formDaysdueback"]                 = "\$text = 'Days Due Back:';";
$trans["adminCollections_new_formDailylatefee"]                 = "\$text = 'Daily Late Fee:';";
$trans["adminCollections_new_formNote"]                 = "\$text = '*Note:';";
$trans["adminCollections_new_formNoteText"]                 = "\$text = 'Setting the days due back to zero makes the entire collection unavailable for checkout.';";

#****************************************************************************
#*  Translation text for page materials_del.php
#****************************************************************************
$trans["admin_materials_delMaterialType"]                 = "\$text = 'Tipo de material, ';";
$trans["admin_materials_delMaterialdeleted"]                 = "\$text = ', ha sido borrado.';";
$trans["admin_materials_Return"]                 = "\$text = 'volver a lista tipos de materiales';";

#****************************************************************************
#*  Translation text for page materials_del_form.php
#****************************************************************************
$trans["admin_materials_delAreyousure"]                 = "\$text = 'Confirma borrar material tipo, ';";

#****************************************************************************
#*  Translation text for page materials_edit_form.php
#****************************************************************************
$trans["admin_materials_delEditmaterialtype"]                 = "\$text = 'Editar Tipo de Material:';";
$trans["admin_materials_delDescription"]                 = "\$text = 'Descripcion:';";
$trans["admin_materials_delunlimited"]                 = "\$text = '(ingresar 0 para ilimitado)';";
$trans["admin_materials_delImagefile"]                 = "\$text = 'Archivo imagen:';";
$trans["admin_materials_delNote"]                 = "\$text = '*Nota:';";
$trans["admin_materials_delNoteText"]                 = "\$text = 'Archivos de imagenes deben ubicarse en directorio openbiblio/images.';";

#****************************************************************************
#*  Translation text for page materials_edit.php
#****************************************************************************
$trans["admin_materials_editEnd"]                 = "\$text = ', ha sido actualizado.';";

#****************************************************************************
#*  Translation text for page materials_list.php
#****************************************************************************
$trans["admin_materials_listAddmaterialtypes"]                 = "\$text = 'Add New Material Type';";
$trans["admin_materials_listMaterialtypes"]                 = "\$text = 'Material Types:';";
$trans["admin_materials_listFunction"]                 = "\$text = 'Function';";
$trans["admin_materials_listDescription"]                 = "\$text = 'Description';";
$trans["admin_materials_listLimits"]                 = "\$text = 'Limits';";
$trans["admin_materials_listCheckoutlimit"]                 = "\$text = 'Checkout';";
$trans["admin_materials_listRenewallimit"]                 = "\$text = 'Renewal';";
$trans["admin_materials_listImageFile"]                 = "\$text = 'Image<br>File';";
$trans["admin_materials_listBibcount"]                 = "\$text = 'Bibliography<br>Count';";
$trans["admin_materials_listEdit"]                 = "\$text = 'edit';";
$trans["admin_materials_listDel"]                 = "\$text = 'del';";
$trans["admin_materials_listNote"]                 = "\$text = '*Note:';";
$trans["admin_materials_listNoteText"]                 = "\$text = 'The delete function is only available on material types that have a bibliography count of zero.  If you wish to delete a material type with a bibliography count greater than zero you will first need to change the material type on those bibliographies to another material type.';";

#****************************************************************************
#*  Translation text for page materials_new.php
#****************************************************************************
$trans["admin_materials_listNewadded"]                 = "\$text = ', has been added.';";

#****************************************************************************
#*  Translation text for page materials_new_form.php
#****************************************************************************
$trans["admin_materials_new_formNoteText"]                 = "\$text = 'Image files must be located in the openbiblio/images directory.';";

#****************************************************************************
#*  Translation text for page noauth.php
#****************************************************************************
$trans["admin_noauth"]                 = "\$text = 'Necesitas autorizacioon para entrar en Admin.';";

#****************************************************************************
#*  Translation text for page settings_edit.php
#****************************************************************************

#****************************************************************************
#*  Translation text for page settings_edit_form.php
#****************************************************************************
$trans["admin_settingsUpdated"]                 = "\$text = 'Datos han sido actualizados.';";
$trans["admin_settingsEditsettings"]                 = "\$text = 'Editar configuracion biblioteca:';";
$trans["admin_settingsLibName"]                 = "\$text = 'Nombre:';";
$trans["admin_settingsLibimageurl"]                 = "\$text = 'URL de la imgen de la biblioteca:';";
$trans["admin_settingsOnlyshowimginheader"]                 = "\$text = 'Solo mostrar imagen en cabecera:';";
$trans["admin_settingsLibhours"]                 = "\$text = 'Horario:';";
$trans["admin_settingsLibphone"]                 = "\$text = 'Telefono:';";
$trans["admin_settingsLibURL"]                 = "\$text = 'URL biblioteca:';";
$trans["admin_settingsOPACURL"]                 = "\$text = 'URL bibl online:';";
$trans["admin_settingsSessionTimeout"]                 = "\$text = 'STimeout de sesion:';";
$trans["admin_settingsMinutes"]                 = "\$text = 'minutos';";
$trans["admin_settingsSearchResults"]                 = "\$text = 'Resultados busquedas:';";
$trans["admin_settingsItemsperpage"]                 = "\$text = 'items por pag.';";
$trans["admin_settingsPurgebibhistory"]                 = "\$text = 'Purgar historia bibliografica despues de:';";
$trans["admin_settingsmonths"]                 = "\$text = 'meses';";
$trans["admin_settingsBlockCheckouts"]                 = "\$text = 'Bloquear Checkouts si se deben:';";
$trans["admin_settingsLocale"]                 = "\$text = 'Localiz:';";
$trans["admin_settingsHTMLChar"]                 = "\$text = 'HTML Charset:';";
$trans["admin_settingsHTMLTagLangAttr"]                 = "\$text = 'Atributo Lenguaje HTML:';";

#****************************************************************************
#*  Translation text for all staff pages
#****************************************************************************
$trans["adminStaff_Staffmember"]                 = "\$text = 'Miembro staff,';";
$trans["adminStaff_Return"]                 = "\$text = 'volver a lista de staff';";
$trans["adminStaff_Yes"]                 = "\$text = 'Si';";
$trans["adminStaff_No"]                 = "\$text = 'No';";


#****************************************************************************
#*  Translation text for page staff_del.php
#****************************************************************************
$trans["adminStaff_delDeleted"]                 = "\$text = ', ha sido borrado.';";

#****************************************************************************
#*  Translation text for page staff_delete_confirm.php
#****************************************************************************
$trans["adminStaff_del_confirmConfirmText"]                 = "\$text = 'Confirma borrar miembros staff?, ';";

#****************************************************************************
#*  Translation text for page staff_edit.php
#****************************************************************************
$trans["adminStaff_editUpdated"]                 = "\$text = ', ha sido actualizado.';";

#****************************************************************************
#*  Translation text for page staff_edit_form.php
#****************************************************************************
$trans["adminStaff_edit_formHeader"]                 = "\$text = 'Editar informacin miembros Staff:';";
$trans["adminStaff_edit_formLastname"]                 = "\$text = 'Apellido:';";
$trans["adminStaff_edit_formFirstname"]                 = "\$text = 'Nombre:';";
$trans["adminStaff_edit_formLogin"]                 = "\$text = 'Login Usuario:';";
$trans["adminStaff_edit_formAuth"]                 = "\$text = 'Autoorizacion:';";
$trans["adminStaff_edit_formCirc"]                 = "\$text = 'Circ';";
$trans["adminStaff_edit_formUpdatemember"]                 = "\$text = 'Actualizar miembro';";
$trans["adminStaff_edit_formCatalog"]                 = "\$text = 'Catalogo';";
$trans["adminStaff_edit_formAdmin"]                 = "\$text = 'Admin';";
$trans["adminStaff_edit_formReports"]                 = "\$text = 'Informes';";
$trans["adminStaff_edit_formSuspended"]                 = "\$text = 'Suspendido:';";

#****************************************************************************
#*  Translation text for page staff_list.php
#****************************************************************************
$trans["adminStaff_list_formHeader"]                 = "\$text = 'Agregar miembro staff';";
$trans["adminStaff_list_Columnheader"]                 = "\$text = ' miembros staff:';";
$trans["adminStaff_list_Function"]                 = "\$text = 'Funcion';";
$trans["adminStaff_list_Edit"]                 = "\$text = 'editar';";
$trans["adminStaff_list_Pwd"]                 = "\$text = 'pwd';";
$trans["adminStaff_list_Del"]                 = "\$text = 'borr';";

#****************************************************************************
#*  Translation text for page staff_new.php
#****************************************************************************
$trans["adminStaff_new_Added"]                 = "\$text = ', ha sido agregado.';";

#****************************************************************************
#*  Translation text for page staff_new_form.php
#****************************************************************************
$trans["adminStaff_new_form_Header"]          	= "\$text = 'Agrgar miembro staff:';";
$trans["adminStaff_new_form_Password"]          = "\$text = 'Contrasea:';";
$trans["adminStaff_new_form_Reenterpassword"]   = "\$text = 'Re-ingresar Contrasea:';";

#****************************************************************************
#*  Translation text for page staff_pwd_reset.php
#****************************************************************************
$trans["adminStaff_pwd_reset_Passwordreset"]   = "\$text = 'Se ha reseteado la contrasea.';";

#****************************************************************************
#*  Translation text for page staff_pwd_reset_form.php
#****************************************************************************
$trans["adminStaff_pwd_reset_form_Resetheader"]   = "\$text = 'Resetear contrasea miembro staff:';";

#****************************************************************************
#*  Translation text for theme pages
#****************************************************************************
$trans["adminTheme_Return"]                 = "\$text = 'volver a lista de temas';";
$trans["adminTheme_Theme"]                 = "\$text = 'Tema, ';";

#****************************************************************************
#*  Translation text for page theme_del.php
#****************************************************************************
$trans["adminTheme_Deleted"]                 = "\$text = ', ha sido borrado.';";
#****************************************************************************
#*  Translation text for page theme_del_confirm.php
#****************************************************************************
$trans["adminTheme_Deleteconfirm"]                 = "\$text = 'Confirma borrar tema?, ';";
#****************************************************************************
#*  Translation text for page theme_edit.php
#****************************************************************************
$trans["adminTheme_Updated"]                 = "\$text = ', ha sido actualizado.';";

#****************************************************************************
#*  Translation text for page theme_edit_form.php
#****************************************************************************
$trans["adminTheme_Preview"]                 = "\$text = 'Pre-ver cambio tema';";

#****************************************************************************
#*  Translation text for page theme_list.php
#****************************************************************************
$trans["adminTheme_Changetheme"]                 = "\$text = 'Cambiar tema en uso:';";
$trans["adminTheme_Choosetheme"]                 = "\$text = 'Seleccionar nuevo tema:';";
$trans["adminTheme_Addnew"]                 = "\$text = 'Agregar tema';";
$trans["adminTheme_themes"]                 = "\$text = 'Temas:';";
$trans["adminTheme_function"]                 = "\$text = 'Funcion';";
$trans["adminTheme_Themename"]                 = "\$text = 'Nombre tema';";
$trans["adminTheme_Usage"]                 = "\$text = 'Uso';";
$trans["adminTheme_Edit"]                 = "\$text = 'editar';";
$trans["adminTheme_Copy"]                 = "\$text = 'copiar';";
$trans["adminTheme_Del"]                 = "\$text = 'borr';";
$trans["adminTheme_Inuse"]                 = "\$text = 'in use';";
$trans["adminTheme_Note"]                 = "\$text = '*Nota:';";
$trans["adminTheme_Notetext"]                 = "\$text = 'LA funcion borrado no esta disponible para el tema en uso.';";

#****************************************************************************
#*  Translation text for page theme_list.php
#****************************************************************************
$trans["adminTheme_Theme2"]                 = "\$text = 'Tema:';";
$trans["adminTheme_Tablebordercolor"]                 = "\$text = 'Color borde de tabla:';";
$trans["adminTheme_Errorcolor"]                 = "\$text = 'Error de Color:';";
$trans["adminTheme_Tableborderwidth"]                 = "\$text = 'Ancho borde Tabla:';";
$trans["adminTheme_Tablecellpadding"]                 = "\$text = 'Tabla Celda Padding:';";
$trans["adminTheme_Title"]                 = "\$text = 'Titulo';";
$trans["adminTheme_Mainbody"]                 = "\$text = 'Cuerpo principal';";
$trans["adminTheme_Navigation"]                 = "\$text = 'Navegacion';";
$trans["adminTheme_Tabs"]                 = "\$text = 'Solapas';";
$trans["adminTheme_Backgroundcolor"]                 = "\$text = 'Background Color:';";
$trans["adminTheme_Fontface"]                 = "\$text = 'Fuente:';";
$trans["adminTheme_Fontsize"]                 = "\$text = 'Tamao fuente:';";
$trans["adminTheme_Bold"]                 = "\$text = 'negrita';";
$trans["adminTheme_Fontcolor"]                 = "\$text = 'Color fuente:';";
$trans["adminTheme_Linkcolor"]                 = "\$text = 'Color hipertexto:';";
$trans["adminTheme_Align"]                 = "\$text = 'Alinear:';";
$trans["adminTheme_Right"]                 = "\$text = 'Derecha';";
$trans["adminTheme_Left"]                 = "\$text = 'Izquierda';";
$trans["adminTheme_Center"]                 = "\$text = 'Centrado';";

$trans["adminTheme_HeaderWording"]                 = "\$text = 'Editar';";


#****************************************************************************
#*  Translation text for page theme_new.php
#****************************************************************************
$trans["adminTheme_new_Added"]                 = "\$text = ', ha sido agregado.';";

#****************************************************************************
#*  Translation text for page theme_new_form.php
#****************************************************************************

#****************************************************************************
#*  Translation text for page theme_preview.php
#****************************************************************************
$trans["adminTheme_preview_Themepreview"]                 = "\$text = 'Theme Preview';";
$trans["adminTheme_preview_Librarytitle"]                 = "\$text = 'Library Title';";
$trans["adminTheme_preview_CloseWindow"]                 = "\$text = 'Close Window';";
$trans["adminTheme_preview_Home"]                 = "\$text = 'Home';";
$trans["adminTheme_preview_Circulation"]   = "\$text = 'Circulacion';";
$trans["adminTheme_preview_Cataloging"]    = "\$text = 'Catalogar';";
$trans["adminTheme_preview_Admin"]         = "\$text = 'Admin';";
$trans["adminTheme_preview_Samplelink"]    = "\$text = 'Link ejemplo';";
$trans["adminTheme_preview_Thisstart"]     = "\$text = 'Vista preliminar de ';";
$trans["adminTheme_preview_Thisend"]       = "\$text = 'tema.';";
$trans["adminTheme_preview_Samplelist"]    = "\$text = 'Lista ejemplo:';";
$trans["adminTheme_preview_Tableheading"]  = "\$text = 'Encabezado tabla';";
$trans["adminTheme_preview_Sampledatarow1"]= "\$text = 'Ejemplo linea datos 1';";
$trans["adminTheme_preview_Sampledatarow2"]= "\$text = 'Ejemplo linea datos 2';";
$trans["adminTheme_preview_Sampledatarow3"]= "\$text = 'Ejemplo linea datos 3';";
$trans["adminTheme_preview_Samplelink"]    = "\$text = 'ejemplo hipertexto';";
$trans["adminTheme_preview_Sampleerror"]   = "\$text = 'ejemplo error';";
$trans["adminTheme_preview_Sampleinput"]   = "\$text = 'Ejemplo Ingreso';";
$trans["adminTheme_preview_Samplebutton"]  = "\$text = 'Ejemplo boton';";
$trans["adminTheme_preview_Poweredby"]     = "\$text = 'Ayacusys';";
$trans["adminTheme_preview_Copyright"]     = "\$text = 'Copyright 2010';";
$trans["adminTheme_preview_underthe"]      = "\$text = 'bajo';";
$trans["adminTheme_preview_GNU"]           = "\$text = 'GNU';";

#****************************************************************************
#*  Translation text for page theme_use.php
#****************************************************************************

?>
