<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 * trad parcial 2010-8
 */
 
  require_once("../shared/common.php");
  session_cache_limiter(null);

  $tab = "admin";
  $nav = "checkout_privs";
  $focus_form_name = "editprivsform";
  $focus_form_field = "checkout_limit";

  require_once("../functions/inputFuncs.php");
  require_once("../shared/logincheck.php");
  require_once("../classes/CheckoutPrivsQuery.php");
  require_once("../classes/Localize.php");
  $loc = new Localize(OBIB_LOCALE,$tab);

  if (isset($_REQUEST["material_cd"]) and isset($_REQUEST["classification"])) {
    $material_cd = $_REQUEST["material_cd"];
    $classification = $_REQUEST["classification"];
  } elseif (isset($_SESSION['postVars']["material_cd"])
            and isset($_SESSION['postVars']["classification"])) {
    $material_cd = $_SESSION['postVars']["material_cd"];
    $classification = $_SESSION['postVars']["classification"];
  } else {
    header("Location: ../admin/checkout_privs_list.php");
    exit();
  }
  
  $privsQ = new CheckoutPrivsQuery();
  $privsQ->connect();
  $priv = $privsQ->get($material_cd, $classification);
  $privsQ->close();
  
  require_once("../shared/header.php");
  
?>

<form name="editprivsform" method="POST" action="../admin/checkout_privs_edit.php">
<input type="hidden" name="material_cd" value="<?php echo H($material_cd);?>">
<input type="hidden" name="classification" value="<?php echo H($classification);?>">
<table class="primary">
  <tr>
    <th colspan="2" nowrap="yes" align="left">
      <?php echo $loc->getText("Editar privilegios checkout"); ?>
    </th>
  </tr>
  <tr>
    <td nowrap="true" class="primary">
      <?php echo $loc->getText("Tipo material:"); ?>
    </td>
    <td valign="top" class="primary">
      <?php echo H($priv['material_type']) ?>
    </td>
  </tr>
  <tr>
    <td nowrap="true" class="primary">
      <?php echo $loc->getText("Clasificacin miembro:"); ?>
    </td>
    <td valign="top" class="primary">
      <?php echo H($priv['classification_type']) ?>
    </td>
  </tr>
  <tr>
    <td nowrap="true" class="primary">
      <?php echo $loc->getText("Lmite checkout:"); ?>
    </td>
    <td valign="top" class="primary">
      <?php echo inputField('text', 'checkout_limit', $priv['checkout_limit']); ?>
    </td>
  </tr>
  <tr>
    <td nowrap="true" class="primary">
      <?php echo $loc->getText("Limite renovacion:"); ?>
    </td>
    <td valign="top" class="primary">
      <?php echo inputField('text', 'renewal_limit', $priv['renewal_limit']); ?>
    </td>
  </tr>
  <tr>
    <td align="center" colspan="2" class="primary">
      <input type="submit" value="  <?php echo $loc->getText("adminSubmit"); ?>  " class="button">
      <input type="button" onClick="self.location='../admin/checkout_privs_list.php'" value="  <?php echo $loc->getText("adminCancel"); ?>  " class="button">
    </td>
  </tr>

</table>
      </form>

<?php include("../shared/footer.php"); ?>
