
<!--- The coldfusion component or 'cfc' is defined within the scope of the <cfcomponent> tag --->
<cfcomponent hint="This is the empObj component which provides query functionality to a flash movie.">

	

	<cffunction name="getEmployees" access="remote" returnType="query" hint="This query returns all records in the employee database, and can additionally drill-down or 'narrow' the search based on optional input parameters.">

		<cfargument name="Nombre" type="string" default="">
		<cfargument name="Apellido" type="string" default="">
		<cfargument name="department" type="string" default="">				
		
		<cfquery name="empQry" datasource="nupolDB">
		SELECT Candidatos.Nombre, 
		Candidatos.Apellido, 
		Candidatos.ID, 
		Candidatos.phone AS phoneNumber,
		Candidatos.email,
		Partidos.Partido AS department
		FROM Candidatos, Partidos
		WHERE Candidatos.PartidoID = Partidos.PartidoID
		<cfif len(Nombre)>and Candidatos.Nombre like '%#Nombre)#%'</cfif>
		<cfif len(Apellido)>and Candidatos.Apellido like '#Apellido#%'</cfif>
		<cfif len(department)>and Partidos.Partido like '%#department#%'</cfif>
		ORDER BY Candidatos.Apellido, Candidatos.Nombre
		</cfquery>
			
		<!--- return the resulting query object to Flash --->
		<cfreturn empQry>

	</cffunction>

	<cffunction name="getDepartments" access="remote" returnType="query" hint="This query returns all unique departments in the employee database.">
<!--- datasource cambiado de exampleapps a nupolDB tblDepartments por Partidos--->
		<cfquery name="qDepartments" datasource="nupolDB">
		SELECT DISTINCT Partido AS department 
		FROM Partidos
		</cfquery>
		<cfreturn qDepartments>
	</cffunction>
</cfcomponent>
