dojo.require('xg.shared.util');

dojo.provide('xg.video.video.ShowEmbedToggle');
dojo.widget.defineWidget('xg.video.video.ShowEmbedToggle', dojo.widget.HtmlWidget, {
    /** The embed code for display and copying */
    _embedCode: '',
    /** The link text that appears when the embed is togged closed  */
    _toOpenText: '',
    /** The link text that appears when the embed is togged open  */
    _toCloseText: '',
    fillInTemplate: function(args, frag) {
        var a = this.getFragNodeRef(frag);
        var embedBlock = dojo.html.createNodesFromText(dojo.string.trim(' \
        <small class="showembed" style="display:none;"> \
            <label for="embedcode">' + xg.video.nls.text('embedHTMLCode') + '</label> \
            <br/> \
            <input id="embedcode" class="textfield" type="text" size="30" style="margin-bottom: 0.4em;"/> \
            <br/> \
            <input class="button" type="button" value="' + xg.video.nls.text('copyHTMLCode') + '"/> \
        </small>'))[0];
        var br = dojo.html.createNodesFromText(dojo.string.trim('<br/>'))[0];
        dojo.html.insertAfter(embedBlock,a);
        dojo.html.insertAfter(br,a);
        var inputs = embedBlock.getElementsByTagName('input');
        var embedField = inputs[0];
        var copyButton = inputs[1];
        embedField.value = this._embedCode;
        var embed = dojo.widget.createWidget("VideoEmbedField");
        xg.shared.util.selectOnClick(embedField);
        dojo.event.connect(copyButton, 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.html.selectInputText(embedField);
            embed.copyToClipboard(embedField);
        }));
        dojo.event.connect(a, 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            dojo.style.toggleShowing(embedBlock);
            if (dojo.style.isShowing(embedBlock)) {
                a.innerHTML = this._toCloseText;
            } else {
                a.innerHTML = this._toOpenText;
            }
        }));
    }
});

